/* This is -*- C -*- */
/* vim: set sw=2: */

/*
 * corba-graph-series.h
 *
 * Copyright (C) 2000 Helix Code, Inc.
 *
 * Developed by Jody Goldberg <jgoldberg@home.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_CORBA_GRAPH_SERIES_H
#define _INC_CORBA_GRAPH_SERIES_H

#include <orb/orbit_object.h>
#include <guppi-data.h>
#include <guppi-defs.h>

BEGIN_GUPPI_DECLS

typedef struct _SeqNotify SeqNotify;
typedef enum { SERIES_SCALAR, SERIES_DATE, SERIES_STRING } SeqNotifyType;

SeqNotify    *seq_notify_new         (SeqNotifyType type, CORBA_Object obj);
GuppiData    *seq_notify_get_data    (SeqNotify *seq);
CORBA_Object  seq_notify_get_servant (SeqNotify *seq);

END_GUPPI_DECLS

#endif /* _INC_CORBA_GRAPH_SERIES_H */
