/* vim: set sw=2: */
#include <config.h>
#include <libgnome/gnome-popt.h>
#include <libgnomeui/gnome-init.h>
#include <guppi-guile.h>
#include <guppi-chart-type.h>
#include <guppi-useful.h>
#include <guppi-plot-init.h>
#include <guppi-data-init.h>
#include <guppi-seq-scalar.h>
#include <guppi-seq-string.h>
#include <guppi-seq-data.h>
#include "guppi-chart-selector.h"

static void
real_main (void *closure, int argc, char* argv[])
{
  GtkWidget *win;
  GtkWidget *selector;
  GuppiChartSelector details;
  int i, j;

  struct poptOption options[] = {
    { NULL, '\0', 0, NULL, 0, NULL, NULL }
  };

  force_development_path_hacks();

  gtk_type_init ();
  gnomelib_register_popt_table (options, "1.0");
  gnomelib_parse_args (argc, argv, 0);

  gnome_init ("silly_demo", "0.0", argc, argv);

  guppi_useful_init ();
  guppi_data_init ();
  guppi_plot_init ();
  guppi_plug_in_spec_find_all ();

  win = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  guppi_chart_selector_init (&details);
  for (i = 0; i < 10; i++) {
    GuppiData *data = guppi_seq_scalar_new ();
    for (j = 0; j < 10; j++)
      guppi_seq_scalar_append (GUPPI_SEQ_SCALAR (data), j);
    guppi_seq_string_append_nc (GUPPI_SEQ_STRING (details.series_names), 
				guppi_strdup_printf ("series%d", i));
    guppi_seq_data_append (GUPPI_SEQ_DATA (details.series), data);
  }
  if (NULL != (selector = guppi_chart_selector_widget (&details))) {
    gtk_container_add (GTK_CONTAINER (win), selector);
    gtk_widget_show_all (win);
    gtk_main();
  }
}

int
main(int argc, char* argv[])
{
  scm_boot_guile (argc, argv, real_main, NULL);

  g_assert_not_reached();
  return 1;
}
