/* This is -*- C -*- */
/* vim: set sw=2: */

/*
 * guppi-date-series-impl.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <guppi-memory.h>
#include "guppi-date-series-impl.h"

static GtkObjectClass * parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_date_series_impl_get_arg (GtkObject *obj, GtkArg *arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_date_series_impl_set_arg (GtkObject *obj, GtkArg *arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_date_series_impl_finalize (GtkObject *obj)
{
  if (parent_class->finalize)
    parent_class->finalize (obj);
}

static void
guppi_date_series_impl_class_init (GuppiDateSeriesImplClass *klass)
{
  GtkObjectClass* object_class = (GtkObjectClass *)klass;

  parent_class = gtk_type_class (GUPPI_TYPE_DATE_INDEXED_IMPL);

  object_class->get_arg = guppi_date_series_impl_get_arg;
  object_class->set_arg = guppi_date_series_impl_set_arg;
  object_class->finalize = guppi_date_series_impl_finalize;

}

static void
guppi_date_series_impl_init (GuppiDateSeriesImpl *obj)
{

}

GtkType
guppi_date_series_impl_get_type (void)
{
  static GtkType guppi_date_series_impl_type = 0;
  if (!guppi_date_series_impl_type) {
    static const GtkTypeInfo guppi_date_series_impl_info = {
      "GuppiDateSeriesImpl",
      sizeof (GuppiDateSeriesImpl),
      sizeof (GuppiDateSeriesImplClass),
      (GtkClassInitFunc)guppi_date_series_impl_class_init,
      (GtkObjectInitFunc)guppi_date_series_impl_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_date_series_impl_type = gtk_type_unique (GUPPI_TYPE_DATE_INDEXED_IMPL, &guppi_date_series_impl_info);
  }
  return guppi_date_series_impl_type;
}

GtkObject *
guppi_date_series_impl_new (void)
{
  return GTK_OBJECT (guppi_type_new (guppi_date_series_impl_get_type ()));
}
