/* This is -*- C -*- */
/* $Id: guppi-geometry.h,v 1.16 2001/05/04 16:54:27 mathieu Exp $ */

/*
 * guppi-geometry.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_GEOMETRY_H
#define _INC_GUPPI_GEOMETRY_H

/* #include <gnome.h> */

#include <guppi-defs.h>

BEGIN_GUPPI_DECLS 

struct _GuppiLayout;

typedef struct _GuppiGeometry GuppiGeometry;
typedef struct _GuppiGeometryClass GuppiGeometryClass;
typedef struct _GuppiGeometryRule GuppiGeometryRule;

struct _GuppiGeometry {
  GtkObject parent;
  gpointer opaque_internals;
};

struct _GuppiGeometryClass {
  GtkObjectClass parent_class;

  /* Signals */
  void (*changed_position) (GuppiGeometry *);
  void (*changed_size) (GuppiGeometry *);
};

#define GUPPI_TYPE_GEOMETRY (guppi_geometry_get_type())
#define GUPPI_GEOMETRY(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_GEOMETRY,GuppiGeometry))
#define GUPPI_GEOMETRY0(obj) ((obj) ? (GUPPI_GEOMETRY(obj)) : NULL)
#define GUPPI_GEOMETRY_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_GEOMETRY,GuppiGeometryClass))
#define GUPPI_IS_GEOMETRY(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_GEOMETRY))
#define GUPPI_IS_GEOMETRY0(obj) (((obj) == NULL) || (GUPPI_IS_GEOMETRY(obj)))
#define GUPPI_IS_GEOMETRY_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_GEOMETRY))

GtkType guppi_geometry_get_type (void);

GuppiGeometry *guppi_geometry_new (void);

gboolean guppi_geometry_positioned (GuppiGeometry *);
double guppi_geometry_left (GuppiGeometry *);
double guppi_geometry_right (GuppiGeometry *);
double guppi_geometry_top (GuppiGeometry *);
double guppi_geometry_bottom (GuppiGeometry *);
double guppi_geometry_width (GuppiGeometry *);
double guppi_geometry_height (GuppiGeometry *);

void guppi_geometry_conv (GuppiGeometry *,
			  double x, double y, double *t_x, double *t_y);

void guppi_geometry_unconv (GuppiGeometry *,
			    double t_x, double t_y, double *x, double *y);

void guppi_geometry_set_position (GuppiGeometry *, double left, double right,
				  double top, double bottom);

gboolean guppi_geometry_contains (GuppiGeometry *, double x, double y);


void guppi_geometry_set_width_callback (GuppiGeometry *,
					double (*callback)(gpointer));
void guppi_geometry_set_height_callback (GuppiGeometry *,
					 double (*callback)(gpointer));
void guppi_geometry_set_user_data (GuppiGeometry *, gpointer);

gconstpointer guppi_geometry_user_data (GuppiGeometry *);


double guppi_geometry_natural_width (GuppiGeometry *);
double guppi_geometry_natural_height (GuppiGeometry *);

void guppi_geometry_calc_natural_size (GuppiGeometry *);

gboolean guppi_geometry_registered (GuppiGeometry *);
void guppi_geometry_set_registered (GuppiGeometry *, gboolean);

void guppi_geometry_connect_to_layout (GuppiGeometry *, struct _GuppiLayout *);
void guppi_geometry_disconnect_from_layout (GuppiGeometry *);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_GEOMETRY_H */

/* $Id: guppi-geometry.h,v 1.16 2001/05/04 16:54:27 mathieu Exp $ */
