/* This is -*- C -*- */
/* $Id: guppi-group-state.c,v 1.3 2000/12/14 20:23:06 trow Exp $ */

/*
 * guppi-group-state.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <guppi-memory.h>
#include "guppi-group-state.h"
#include "guppi-group-view.h"

static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_group_state_get_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_group_state_set_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_group_state_destroy (GtkObject * obj)
{
  if (parent_class->destroy)
    parent_class->destroy (obj);
}

static void
guppi_group_state_finalize (GtkObject * obj)
{
  if (parent_class->finalize)
    parent_class->finalize (obj);
}

static void
guppi_group_state_class_init (GuppiGroupStateClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;
  GuppiElementStateClass *state_class = GUPPI_ELEMENT_STATE_CLASS (klass);

  parent_class = gtk_type_class (GUPPI_TYPE_ELEMENT_STATE);

  object_class->get_arg = guppi_group_state_get_arg;
  object_class->set_arg = guppi_group_state_set_arg;
  object_class->destroy = guppi_group_state_destroy;
  object_class->finalize = guppi_group_state_finalize;

  state_class->view_type = GUPPI_TYPE_GROUP_VIEW;
}

static void
guppi_group_state_init (GuppiGroupState * obj)
{

}

GtkType guppi_group_state_get_type (void)
{
  static GtkType guppi_group_state_type = 0;
  if (!guppi_group_state_type) {
    static const GtkTypeInfo guppi_group_state_info = {
      "GuppiGroupState",
      sizeof (GuppiGroupState),
      sizeof (GuppiGroupStateClass),
      (GtkClassInitFunc) guppi_group_state_class_init,
      (GtkObjectInitFunc) guppi_group_state_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_group_state_type =
      gtk_type_unique (GUPPI_TYPE_ELEMENT_STATE, &guppi_group_state_info);
  }
  return guppi_group_state_type;
}

GuppiElementState *
guppi_group_state_new (void)
{
  return GUPPI_ELEMENT_STATE (guppi_type_new (guppi_group_state_get_type ()));
}



/* $Id: guppi-group-state.c,v 1.3 2000/12/14 20:23:06 trow Exp $ */
