/*
 * guppi-useful.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <gnan.h>
#include "guppi-useful.h"
#include "guppi-dharma.h"
#include "guppi-scm-useful.h"

#ifdef HAVE_PYTHON
#include "guppi-python.h"
void guppi_python_useful_init (void);
#endif

void
guppi_useful_init (void)
{
  guppi_guile_init ();
  guppi_scm_useful_init ();
  guppi_useful_init_without_guile ();

}

void
guppi_useful_init_without_guile (void)
{

#ifdef HAVE_PYTHON
  if (!guppi_python_is_active ()) {
    guppi_python_init ();
    guppi_python_useful_init ();
  }
#endif

  gnan_init ();
  guppi_timer_init ();
  guppi_dharma_init ();
  guppi_paths_init ();

  guppi_plug_in_path_reset_to_default ();

  if (guppi_guile_is_active ()) {
    /* Try to insure that we can't gracelessly shutdown the whole process
       from guile. */
    gh_eval_str ("(define exit guppi-exit)");
  }

  guppi_exit_connect_shutdown_func (guppi_plug_in_spec_shutdown,
				    NULL, "Clean up Plug-In Cache");
}



/* $Id: guppi-useful.c,v 1.17 2001/05/06 00:07:41 trow Exp $ */
