/* This is -*- C -*- */
/* $Id: func.c,v 1.13 2001/05/06 07:56:19 trow Exp $ */

/*
 * func.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>

#include <gtk/gtksignal.h>

#include <guppi-convenient.h>
#include <guppi-data-impl-plug-in.h>
#include "func.h"
#include "scm-seq-scalar-func.h"

#ifdef HAVE_PYTHON
void python_seq_scalar_func_init (void);
#endif


static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_SEQ_SCALAR_ARG1,
  ARG_SEQ_SCALAR_ARG2,
  ARG_BASIC_UNARY_FN,
  ARG_BASIC_BINARY_FN,
  ARG_BASIC_UNARY_FN_C,
  ARG_BASIC_BINARY_FN_C,
  ARG_BASIC_FN_USER_DATA,
};

static void
guppi_seq_scalar_func_impl_get_arg (GtkObject * obj, GtkArg * arg,
				    guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_seq_scalar_func_impl_set_arg (GtkObject * obj, GtkArg * arg,
				    guint arg_id)
{
  GuppiSeqScalarFuncImpl *func = GUPPI_SEQ_SCALAR_FUNC_IMPL (obj);
  GuppiSeqScalar *ss;
  double (*fn1) (double, gpointer);
  double (*fn2) (double, double, gpointer);
  GuppiFnWrapper *fw;

  switch (arg_id) {

  case ARG_SEQ_SCALAR_ARG1:
    ss = GUPPI_SEQ_SCALAR (GTK_VALUE_POINTER (*arg));
    if (ss != func->arg1) {
      if (func->arg1)
	gtk_signal_disconnect_by_func (GTK_OBJECT (func->arg1),
				       guppi_data_touch, func);
      guppi_refcounting_assign (func->arg1, ss);
      guppi_data_impl_changed (GUPPI_DATA_IMPL (obj));
      if (func->arg1)
	gtk_signal_connect_object (GTK_OBJECT (func->arg1),
				   "changed",
				   GTK_SIGNAL_FUNC (guppi_data_impl_changed),
				   GTK_OBJECT (func));
    }

    break;

  case ARG_SEQ_SCALAR_ARG2:
    ss = GUPPI_SEQ_SCALAR (GTK_VALUE_POINTER (*arg));
    if (ss != func->arg2) {
      if (func->arg2)
	gtk_signal_disconnect_by_func (GTK_OBJECT (func->arg2),
				       guppi_data_touch, func);
      guppi_refcounting_assign (func->arg2, ss);
      guppi_data_impl_changed (GUPPI_DATA_IMPL (obj));
      if (func->arg2)
	gtk_signal_connect_object (GTK_OBJECT (func->arg2),
				   "changed",
				   GTK_SIGNAL_FUNC (guppi_data_impl_changed),
				   GTK_OBJECT (func));
    }

    break;

  case ARG_BASIC_UNARY_FN:
    fw = GUPPI_FN_WRAPPER (GTK_VALUE_POINTER (*arg));
    if (func->basic_unary_wrapper != fw) {
      guppi_refcounting_assign (func->basic_unary_wrapper, fw);
      guppi_data_impl_changed (GUPPI_DATA_IMPL (obj));
    }

    break;

  case ARG_BASIC_UNARY_FN_C:
    fn1 = (double (*)(double, gpointer)) GTK_VALUE_POINTER (*arg);
    if (fn1 != func->basic_unary) {
      func->basic_unary = fn1;
      guppi_data_impl_changed (GUPPI_DATA_IMPL (obj));
    }

    break;


  case ARG_BASIC_BINARY_FN:
    fw = GUPPI_FN_WRAPPER (GTK_VALUE_POINTER (*arg));
    if (func->basic_binary_wrapper != fw) {
      guppi_refcounting_assign (func->basic_binary_wrapper, fw);
      guppi_data_impl_changed (GUPPI_DATA_IMPL (obj));
    }

    break;

  case ARG_BASIC_BINARY_FN_C:
    fn2 = (double (*)(double, double, gpointer)) GTK_VALUE_POINTER (*arg);
    if (fn2 != func->basic_binary) {
      func->basic_binary = fn2;
      guppi_data_impl_changed (GUPPI_DATA_IMPL (obj));
    }

    break;

  case ARG_BASIC_FN_USER_DATA:
    if (func->user_data != GTK_VALUE_POINTER (*arg)) {
      func->user_data = GTK_VALUE_POINTER (*arg);
      guppi_data_impl_changed (GUPPI_DATA_IMPL (obj));
    }

    break;

  default:
    break;
  };
}

static void
guppi_seq_scalar_func_impl_finalize (GtkObject * obj)
{
  GuppiSeqScalarFuncImpl *func = GUPPI_SEQ_SCALAR_FUNC_IMPL (obj);

  guppi_unref0 (func->basic_unary_wrapper);
  guppi_unref0 (func->basic_binary_wrapper);

  if (parent_class->finalize)
    parent_class->finalize (obj);
}

/**************************************************************************/

/* no range */

/* no sum */

/* no var */

static double
v_seq_scalar_get (const GuppiSeqScalarImpl * impl, gint i)
{
  GuppiSeqScalarFuncImpl *func = GUPPI_SEQ_SCALAR_FUNC_IMPL (impl);
  double x, y;

  if (func->basic_unary || func->basic_unary_wrapper) {
    x = guppi_seq_scalar_get (func->arg1, i);
    if (func->basic_unary)
      return func->basic_unary (x, func->user_data);
    else
      return guppi_fn_wrapper_eval_d__d (func->basic_unary_wrapper, x);
  }

  if (func->basic_binary || func->basic_binary_wrapper) {
    x = guppi_seq_scalar_get (func->arg1, i);
    y = guppi_seq_scalar_get (func->arg2, i);
    if (func->basic_binary)
      return func->basic_binary (x, y, func->user_data);
    else
      return guppi_fn_wrapper_eval_d__d_d (func->basic_binary_wrapper, x, y);
  }

  g_assert_not_reached ();
  return 0;
}

/* no set */

/* no insert or insert_many */

/* no raw access */

/* no set */

static void
v_seq_size_hint (GuppiSeqImpl * impl, gsize N)
{
  /* A total no-op */
}

static void
v_seq_get_bounds (const GuppiSeqImpl * impl, gint * i0, gint * i1)
{
  GuppiSeqScalarFuncImpl *func = GUPPI_SEQ_SCALAR_FUNC_IMPL (impl);

  if (func->arg2)
    guppi_seq_common_bounds (GUPPI_SEQ (func->arg1), GUPPI_SEQ (func->arg2),
			     i0, i1);
  else
    guppi_seq_bounds (GUPPI_SEQ (func->arg1), i0, i1);
}

/* no delete or delete many */

/* no grow-to-include */

static gboolean
v_seq_has_missing (GuppiSeqImpl * impl)
{
  GuppiSeqScalarFuncImpl *func = GUPPI_SEQ_SCALAR_FUNC_IMPL (impl);

  return (func->arg1 && guppi_seq_has_missing (GUPPI_SEQ (func->arg1))) ||
    (func->arg2 && guppi_seq_has_missing (GUPPI_SEQ (func->arg2)));
}

static gboolean
v_seq_missing (GuppiSeqImpl * impl, gint i)
{
  GuppiSeqScalarFuncImpl *func = GUPPI_SEQ_SCALAR_FUNC_IMPL (impl);

  return (func->arg1 && guppi_seq_missing (GUPPI_SEQ (func->arg1), i)) ||
    (func->arg2 && guppi_seq_missing (GUPPI_SEQ (func->arg2), i));
}

static GuppiDataImpl *
v_data_copy (GuppiDataImpl * impl)
{
  /* Unimplemented. */
  g_assert_not_reached ();
  return NULL;
}

static gint
v_data_size_in_bytes (GuppiDataImpl * impl)
{
  return sizeof (GuppiSeqScalarFuncImpl);
}

#define add_arg(str, t, symb) \
gtk_object_add_arg_type("GuppiSeqScalarFuncImpl::" str, t, GTK_ARG_WRITABLE, symb)

static void
guppi_seq_scalar_func_impl_class_init (GuppiSeqScalarFuncImplClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;
  GuppiSeqScalarImplClass *seq_scalar_impl_class =
    GUPPI_SEQ_SCALAR_IMPL_CLASS (klass);
  GuppiSeqImplClass *seq_impl_class = GUPPI_SEQ_IMPL_CLASS (klass);
  GuppiDataImplClass *data_impl_class = GUPPI_DATA_IMPL_CLASS (klass);

  parent_class = gtk_type_class (GUPPI_TYPE_SEQ_SCALAR_IMPL);

  object_class->get_arg = guppi_seq_scalar_func_impl_get_arg;
  object_class->set_arg = guppi_seq_scalar_func_impl_set_arg;
  object_class->finalize = guppi_seq_scalar_func_impl_finalize;

  seq_scalar_impl_class->get = v_seq_scalar_get;

  seq_impl_class->size_hint = v_seq_size_hint;
  seq_impl_class->get_bounds = v_seq_get_bounds;
  seq_impl_class->has_missing = v_seq_has_missing;
  seq_impl_class->missing = v_seq_missing;

  data_impl_class->read_only = TRUE;
  data_impl_class->copy = v_data_copy;
  data_impl_class->get_size_in_bytes = v_data_size_in_bytes;

  add_arg ("seq_scalar_arg1", GTK_TYPE_POINTER, ARG_SEQ_SCALAR_ARG1);
  add_arg ("seq_scalar_arg2", GTK_TYPE_POINTER, ARG_SEQ_SCALAR_ARG2);
  add_arg ("unary_function", GTK_TYPE_POINTER, ARG_BASIC_UNARY_FN);
  add_arg ("binary_function", GTK_TYPE_POINTER, ARG_BASIC_BINARY_FN);
  add_arg ("unary_function_C", GTK_TYPE_POINTER, ARG_BASIC_UNARY_FN_C);
  add_arg ("binary_function_C", GTK_TYPE_POINTER, ARG_BASIC_BINARY_FN_C);
  add_arg ("function_data", GTK_TYPE_POINTER, ARG_BASIC_FN_USER_DATA);
}

static void
guppi_seq_scalar_func_impl_init (GuppiSeqScalarFuncImpl * obj)
{

}

GtkType guppi_seq_scalar_func_impl_get_type (void)
{
  static GtkType guppi_seq_scalar_func_impl_type = 0;
  if (!guppi_seq_scalar_func_impl_type) {
    static const GtkTypeInfo guppi_seq_scalar_func_impl_info = {
      "GuppiSeqScalarFuncImpl",
      sizeof (GuppiSeqScalarFuncImpl),
      sizeof (GuppiSeqScalarFuncImplClass),
      (GtkClassInitFunc) guppi_seq_scalar_func_impl_class_init,
      (GtkObjectInitFunc) guppi_seq_scalar_func_impl_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_seq_scalar_func_impl_type =
      gtk_type_unique (GUPPI_TYPE_SEQ_SCALAR_IMPL,
		       &guppi_seq_scalar_func_impl_info);
  }
  return guppi_seq_scalar_func_impl_type;
}

GuppiData *
guppi_seq_scalar_new_func (GuppiFnWrapper * fn, GuppiSeqScalar * arg)
{
  g_return_val_if_fail (fn != NULL && GUPPI_IS_FN_WRAPPER (fn), NULL);
  g_return_val_if_fail (arg != NULL && GUPPI_IS_SEQ_SCALAR (arg), NULL);

  return guppi_data_new_by_type (GUPPI_TYPE_SEQ_SCALAR,
				 GUPPI_TYPE_SEQ_SCALAR_FUNC_IMPL,
				 "seq_scalar_arg1", arg,
				 "unary_function", fn, NULL);
}

GuppiData *
guppi_seq_scalar_new_binary_func (GuppiFnWrapper * fn,
				  GuppiSeqScalar * arg1,
				  GuppiSeqScalar * arg2)
{
  g_return_val_if_fail (fn != NULL && GUPPI_IS_FN_WRAPPER (fn), NULL);
  g_return_val_if_fail (arg1 != NULL && GUPPI_IS_SEQ_SCALAR (arg1), NULL);
  g_return_val_if_fail (arg2 != NULL && GUPPI_IS_SEQ_SCALAR (arg2), NULL);

  return guppi_data_new_by_type (GUPPI_TYPE_SEQ_SCALAR,
				 GUPPI_TYPE_SEQ_SCALAR_FUNC_IMPL,
				 "seq_scalar_arg1", arg1,
				 "seq_scalar_arg2", arg2,
				 "binary_function", fn,
				 NULL);
}


/**************************************************************************/

static GuppiDataImpl *
make_impl (void)
{
  return
    GUPPI_DATA_IMPL (guppi_type_new (guppi_seq_scalar_func_impl_get_type ()));
}

GuppiPlugIn *guppi_plug_in (void);

GuppiPlugIn *
guppi_plug_in (void)
{
  GuppiPlugIn *pi;
  GuppiDataImplPlugIn *dimpi;

  pi = guppi_data_impl_plug_in_new ();
  dimpi = GUPPI_DATA_IMPL_PLUG_IN (pi);

  pi->magic_number = GUPPI_PLUG_IN_MAGIC_NUMBER;
  dimpi->impl_constructor = make_impl;

  scm_seq_scalar_func_init ();

#ifdef HAVE_PYTHON
  python_seq_scalar_func_init ();
#endif

  return pi;
}



/* $Id: func.c,v 1.13 2001/05/06 07:56:19 trow Exp $ */
