/* This is -*- C -*- */
/* $Id: guppi-axis-view.c,v 1.9 2001/05/06 07:56:26 trow Exp $ */

/*
 * guppi-axis-view.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>

#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-config.h>
#include <libgnome/gnome-i18n.h>

#include "guppi-axis-state.h"
#include "guppi-axis-view.h"
#include "guppi-axis-item.h"
#include "guppi-axis-print.h"

static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_axis_view_get_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_axis_view_set_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_axis_view_destroy (GtkObject * obj)
{
  if (parent_class->destroy)
    parent_class->destroy (obj);
}

static void
guppi_axis_view_finalize (GtkObject * obj)
{
  if (parent_class->finalize)
    parent_class->finalize (obj);
}

/**************************************************************************/

static void
state_changed (GuppiElementView * view)
{
  /* If we changed, try to recalculate our natural sizes. */
  guppi_geometry_calc_natural_size (guppi_element_view_geometry (view));
}

static void
changed (GuppiElementView *view)
{
  /* If we changed, try to recalculate our natural sizes. */
  guppi_geometry_calc_natural_size (guppi_element_view_geometry (view));

  if (GUPPI_ELEMENT_VIEW_CLASS (parent_class)->changed)
    GUPPI_ELEMENT_VIEW_CLASS (parent_class)->changed (view);
}

static double
calc_width (gpointer user_data)
{
  GuppiElementView *ev = GUPPI_ELEMENT_VIEW (user_data);
  GuppiAxisMarkers *am = guppi_element_view_y_axis_markers (ev);
  GuppiAxisState *state = GUPPI_AXIS_STATE (guppi_element_view_state (ev));

  double w = 0;
  if (am != NULL && guppi_axis_state_vertical (state)) {
    w = guppi_axis_state_maximum_span (state, am);
  }
  return w;
}

static double
calc_height (gpointer user_data)
{
  GuppiElementView *ev = GUPPI_ELEMENT_VIEW (user_data);
  GuppiAxisMarkers *am = guppi_element_view_x_axis_markers (ev);
  GuppiAxisState *state = GUPPI_AXIS_STATE (guppi_element_view_state (ev));

  double h = 0;
  if (am != NULL && guppi_axis_state_horizontal (state)) {
    h = guppi_axis_state_maximum_span (state, am);
  }
  return h;
}

/**************************************************************************/

static GtkWidget *
config_cb (gpointer user_data)
{
  return gtk_label_new ("Axis View");
}

static GuppiConfigItem *
config_tree (GuppiElementView * view)
{
  GuppiConfigItem *node;

  node = guppi_config_item_new (_("Axis: Coordinates"),
				_("Coordinates"), config_cb, view);

  return node;
}

/**************************************************************************/

static void
guppi_axis_view_class_init (GuppiAxisViewClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;
  GuppiElementViewClass *view_class = GUPPI_ELEMENT_VIEW_CLASS (klass);

  parent_class = gtk_type_class (GUPPI_TYPE_ELEMENT_VIEW);

  object_class->get_arg = guppi_axis_view_get_arg;
  object_class->set_arg = guppi_axis_view_set_arg;
  object_class->destroy = guppi_axis_view_destroy;
  object_class->finalize = guppi_axis_view_finalize;

  view_class->changed = changed;
  view_class->canvas_item_type = GUPPI_TYPE_AXIS_ITEM;
  view_class->print_type = GUPPI_TYPE_AXIS_PRINT;
  view_class->state_changed = state_changed;
  view_class->config_tree = config_tree;
}

static void
guppi_axis_view_init (GuppiAxisView * obj)
{
  GuppiElementView *ev = GUPPI_ELEMENT_VIEW (obj);
  GuppiGeometry *geom = guppi_element_view_geometry (ev);

  guppi_geometry_set_width_callback (geom, calc_width);
  guppi_geometry_set_height_callback (geom, calc_height);
}

GtkType guppi_axis_view_get_type (void)
{
  static GtkType guppi_axis_view_type = 0;
  if (!guppi_axis_view_type) {
    static const GtkTypeInfo guppi_axis_view_info = {
      "GuppiAxisView",
      sizeof (GuppiAxisView),
      sizeof (GuppiAxisViewClass),
      (GtkClassInitFunc) guppi_axis_view_class_init,
      (GtkObjectInitFunc) guppi_axis_view_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_axis_view_type =
      gtk_type_unique (GUPPI_TYPE_ELEMENT_VIEW, &guppi_axis_view_info);
  }
  return guppi_axis_view_type;
}

/* $Id: guppi-axis-view.c,v 1.9 2001/05/06 07:56:26 trow Exp $ */
