/* This is -*- C -*- */
/* $Id: guppi-scatter-print.c,v 1.2 2000/10/20 01:21:34 trow Exp $ */

/*
 * guppi-scatter-print.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include "guppi-scatter-print.h"
#include "guppi-scatter-state.h"
#include "guppi-scatter-view.h"

static GtkObjectClass *parent_class = NULL;

static void
guppi_scatter_print_finalize (GtkObject * obj)
{
  if (parent_class->finalize)
    parent_class->finalize (obj);
}

static void
print (GuppiElementPrint * ep)
{
  GuppiScatterState *state;
  GuppiSeqScalar *x_data;
  GuppiSeqScalar *y_data;
  GuppiSeqInteger *style_data;
  GuppiSeqScalar *color_data;
  GuppiSeqScalar *size1_data;
  GuppiSeqScalar *size2_data;

  gint i, i0, i1, c_i0, c_i1, sz1_i0, sz1_i1, sz2_i0, sz2_i1;
  double c_min = 0, c_max = 1, sz1_min = 0, sz1_max = 1, sz2_min =
    0, sz2_max = 1;

  state = GUPPI_SCATTER_STATE (guppi_element_print_state (ep));

  x_data = guppi_scatter_state_x_data (state);
  y_data = guppi_scatter_state_y_data (state);

  if (x_data == NULL || y_data == NULL)
    return;

  guppi_seq_common_bounds (GUPPI_SEQ (x_data), GUPPI_SEQ (y_data), &i0, &i1);

  style_data = guppi_scatter_state_style_data (state);

  color_data = guppi_scatter_state_color_gradient_data (state);
  size1_data = guppi_scatter_state_size1_gradient_data (state);
  size2_data = guppi_scatter_state_size2_gradient_data (state);

  if (color_data) {
    guppi_seq_indices (GUPPI_SEQ (color_data), &c_i0, &c_i1);
    c_min = guppi_seq_scalar_min (color_data);
    c_max = guppi_seq_scalar_min (color_data);
    if (c_min == c_max) {
      c_min -= 1;
      c_max += 1;
    }

  }

  if (size1_data) {
    guppi_seq_indices (GUPPI_SEQ (size1_data), &sz1_i0, &sz1_i1);
    sz1_min = guppi_seq_scalar_min (size1_data);
    sz1_max = guppi_seq_scalar_min (size1_data);
    if (sz1_min == sz1_max) {
      sz1_min -= 1;
      sz1_max += 1;
    }
  }

  if (size2_data) {
    guppi_seq_indices (GUPPI_SEQ (size2_data), &sz2_i0, &sz2_i1);
    sz2_min = guppi_seq_scalar_min (size2_data);
    sz2_max = guppi_seq_scalar_min (size2_data);
    if (sz2_min == sz2_max) {
      sz2_min -= 1;
      sz2_max += 1;
    }
  }

  for (i = i0; i <= i1; ++i) {
    double x, y, sz1, sz2;
    guint32 color;
    gint style_num;
    GuppiScatterStyle *style;

    x = guppi_seq_scalar_get (x_data, i);
    y = guppi_seq_scalar_get (y_data, i);

    style_num = 0;
    if (style_data)
      style_num = guppi_seq_integer_get (style_data, i);
    style = guppi_scatter_state_get_style (state, style_num);

    if (size1_data && sz1_i0 <= i && i <= sz1_i1) {
      double t = guppi_seq_scalar_get (size1_data, i);
      t = (t - sz1_min) / (sz1_max - sz1_min);
      sz1 = guppi_scatter_style_calc_size1_gradient (style, t);
    } else {
      sz1 = guppi_style_marker_size1 (GUPPI_STYLE (style));
    }

    if (size2_data && sz2_i0 <= i && i <= sz2_i1) {
      double t = guppi_seq_scalar_get (size2_data, i);
      t = (t - sz2_min) / (sz2_max - sz2_min);
      sz2 = guppi_scatter_style_calc_size2_gradient (style, t);
    } else {
      sz2 = guppi_style_marker_size2 (GUPPI_STYLE (style));
    }

    if (color_data && c_i0 <= i && i <= c_i1) {
      double t = guppi_seq_scalar_get (color_data, i);
      t = (t - c_min) / (c_max - c_min);
      color = guppi_scatter_style_calc_color_gradient (style, t);
    } else {
      color = guppi_style_color (GUPPI_STYLE (style));
    }

    guppi_element_print_vp2pt_auto (ep, &x, &y);

    guppi_element_print_setrgbacolor_uint (ep, color);
    guppi_marker_print (guppi_style_marker (GUPPI_STYLE (style)),
			sz1, sz2, ep, x, y);

  }

}

static void
guppi_scatter_print_class_init (GuppiScatterPrintClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;
  GuppiElementPrintClass *ep_class = GUPPI_ELEMENT_PRINT_CLASS (klass);

  parent_class = gtk_type_class (GUPPI_TYPE_ELEMENT_PRINT);

  object_class->finalize = guppi_scatter_print_finalize;
  ep_class->print = print;

}

static void
guppi_scatter_print_init (GuppiScatterPrint * obj)
{

}

GtkType guppi_scatter_print_get_type (void)
{
  static GtkType guppi_scatter_print_type = 0;
  if (!guppi_scatter_print_type) {
    static const GtkTypeInfo guppi_scatter_print_info = {
      "GuppiScatterPrint",
      sizeof (GuppiScatterPrint),
      sizeof (GuppiScatterPrintClass),
      (GtkClassInitFunc) guppi_scatter_print_class_init,
      (GtkObjectInitFunc) guppi_scatter_print_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_scatter_print_type =
      gtk_type_unique (GUPPI_TYPE_ELEMENT_PRINT, &guppi_scatter_print_info);
  }
  return guppi_scatter_print_type;
}

/* $Id: guppi-scatter-print.c,v 1.2 2000/10/20 01:21:34 trow Exp $ */
