/* This is -*- C -*- */
/* vim: set sw=8: */

/*
 * corba-graph-manager.h
 *
 * Copyright (C) 2000 Helix Code, Inc.
 *
 * Developed by Jody Goldberg <jgoldberg@home.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_CORBA_GRAPH_MANAGER_H
#define _INC_CORBA_GRAPH_MANAGER_H

#include <bonobo/bonobo-xobject.h>
#include "gnumeric-graphs.h"
#include <guppi-embeddable.h>
#include "guppi-chart-selector.h"
#include <guppi-defs.h>

BEGIN_GUPPI_DECLS

typedef struct {
	BonoboXObject parent;

	GuppiBonoboEmbeddable *embeddable;

	struct {
		GtkWidget	*widget;
		BonoboControl	*control;
		Bonobo_Control	 bonobo_control;
	} chart_type_selector;

	GPtrArray *scalars;
	GPtrArray *dates;
	GPtrArray *strings;

	GuppiChartSelector details;
} GraphManager;

typedef struct {
	BonoboXObject parent;

	POA_GNOME_Gnumeric_Graph_Manager__epv epv;
} GraphManagerClass;

GraphManager *graph_manager_new (void);
GtkType graph_manager_get_type (void);

#define GRAPH_MANAGER_TYPE        (graph_manager_get_type ())
#define GRAPH_MANAGER(o)          (GTK_CHECK_CAST ((o), GRAPH_MANAGER_TYPE, GraphManager))
#define GRAPH_MANAGER_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), GRAPH_MANAGER_TYPE, GraphManagerClass))
#define IS_GRAPH_MANAGER(o)       (GTK_CHECK_TYPE ((o), GRAPH_MANAGER_TYPE))
#define IS_GRAPH_MANAGER_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), GRAPH_MANAGER_TYPE))

END_GUPPI_DECLS

#endif /* _INC_CORBA_GRAPH_MANAGER_H */
