/* This is -*- C -*- */
/* $Id: guppi-array.h,v 1.9 2001/01/16 23:36:12 trow Exp $ */

/*
 * guppi-array.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_ARRAY_H
#define _INC_GUPPI_ARRAY_H

/* #include <gtk/gtk.h> */

#include "guppi-data.h"

#include <guppi-defs.h>

BEGIN_GUPPI_DECLS 

typedef struct _GuppiArray GuppiArray;
typedef struct _GuppiArrayClass GuppiArrayClass;

struct _GuppiArray {
  GuppiData parent;
};

struct _GuppiArrayClass {
  GuppiDataClass parent_class;
};

#define GUPPI_TYPE_ARRAY (guppi_array_get_type())
#define GUPPI_ARRAY(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_ARRAY,GuppiArray))
#define GUPPI_ARRAY0(obj) ((obj) ? (GUPPI_ARRAY(obj)) : NULL)
#define GUPPI_ARRAY_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_ARRAY,GuppiArrayClass))
#define GUPPI_IS_ARRAY(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_ARRAY))
#define GUPPI_IS_ARRAY0(obj) (((obj) == NULL) || (GUPPI_IS_ARRAY(obj)))
#define GUPPI_IS_ARRAY_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_ARRAY))

GtkType guppi_array_get_type (void);

void guppi_array_construct (GuppiArray *, gint, const gint *, const gint *);


gint guppi_array_dimensions (const GuppiArray *);
gint guppi_array_min_index (const GuppiArray *, gint);
gint guppi_array_max_index (const GuppiArray *, gint);
void guppi_array_index_bounds (const GuppiArray *, gint,
			       gint * min, gint * max);
gboolean guppi_array_valid_index (const GuppiArray *, gint, gint);
gboolean guppi_array_validv (const GuppiArray *, const gint *);

double guppi_array_get (const GuppiArray *, ...);
double guppi_array_getv (const GuppiArray *, const gint *);

void guppi_array_set (GuppiArray *, double, ...);
void guppi_array_setv (GuppiArray *, double, const gint *);

GuppiArray *guppi_array_slice (const GuppiArray *, gint dims, ...);
GuppiArray *guppi_array_slicev (const GuppiArray *, gint dims, const gint *);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_ARRAY_H */

/* $Id: guppi-array.h,v 1.9 2001/01/16 23:36:12 trow Exp $ */
