/* This is -*- C -*- */
/* vim: set sw=2: */

/*
 * guppi-chart-type.h
 *
 * Copyright (C) 2000 Helix Code, Inc.
 *
 * Developed by Jody Goldberg <jgoldberg@home.com> and
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_CHART_TYPE_H
#define _INC_GUPPI_CHART_TYPE_H

#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include <libgnomeui/gnome-pixmap.h>

#include <guppi-root-group-view.h>
#include <guppi-seq-data.h>
#include <guppi-seq-string.h>

#include <guppi-defs.h>

BEGIN_GUPPI_DECLS 

typedef struct _GuppiCustomChartType GuppiCustomChartType;
typedef GuppiRootGroupView *(*GuppiCustomChartFactory) (void); /* TODO */
struct _GuppiCustomChartType {
  char const *name;
  char const *description;
  GuppiCustomChartFactory factory;

  gconstpointer user_data;
};

typedef struct _GuppiMajorChartType GuppiMajorChartType;
struct _GuppiMajorChartType {
  char const *name;

  gconstpointer user_data;
};

typedef struct _GuppiMinorChartType GuppiMinorChartType;
typedef GuppiRootGroupView *(*GuppiMinorChartFactory) (GuppiMinorChartType
						       const *t,
						       GuppiSeqData * series,
						       GuppiSeqData * labels,
						       GuppiSeqString *
						       series_names);
struct _GuppiMinorChartType {
  char const *name;
  char const *description;
  int row, col;
  GuppiMinorChartFactory factory;

  gconstpointer user_data;
};


GuppiCustomChartType *guppi_custom_chart_type_register (char const *name,
							const char *const *xpm_data,
							char const *description,
							GuppiCustomChartFactory factory,
							gconstpointer user_data);

GuppiMajorChartType *guppi_major_chart_type_register (char const *name,
						      const char *const *xpm_data,
						      gconstpointer user_data);

GuppiMinorChartType *guppi_minor_chart_type_register (GuppiMajorChartType *
						      major, char const *name,
						      char const *icon_file,
						      char const *description,
						      int row, int col,
						      GuppiMinorChartFactory
						      factory,
						      gconstpointer
						      user_data);

GnomePixmap *guppi_custom_chart_type_image (GuppiCustomChartType const *t);
GnomePixmap *guppi_major_chart_type_image (GuppiMajorChartType const *t);
GdkPixbuf *guppi_minor_chart_type_image (GuppiMinorChartType const *t);

typedef gboolean (*MajorChartTypeFunc) (GuppiMajorChartType const *maj,
					gpointer user_data);
gboolean guppi_chart_type_foreach_major (MajorChartTypeFunc handler,
					 gpointer user_data);

typedef gboolean (*MinorChartTypeFunc) (GuppiMajorChartType const *maj,
					GuppiMinorChartType const *min,
					gpointer user_data);
gboolean guppi_major_chart_type_foreach_minor (GuppiMajorChartType const *t,
					       MinorChartTypeFunc handler,
					       gpointer user_data);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_CHART_TYPE_H */

/* $Id: guppi-chart-type.h,v 1.11 2001/05/04 16:54:27 mathieu Exp $ */
