/* This is -*- C -*- */
/* $Id: guppi-seq-style.h,v 1.5 2001/01/16 23:36:36 trow Exp $ */

/*
 * guppi-seq-style.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SEQ_STYLE_H
#define _INC_GUPPI_SEQ_STYLE_H

/* #include <gnome.h> */
#include <guppi-seq.h>
#include "guppi-style.h"

#include <guppi-defs.h>

BEGIN_GUPPI_DECLS 

typedef struct _GuppiSeqStyle GuppiSeqStyle;
typedef struct _GuppiSeqStyleClass GuppiSeqStyleClass;

struct _GuppiSeqStyle {
  GuppiSeq parent;
};

struct _GuppiSeqStyleClass {
  GuppiSeqClass parent_class;
};

#define GUPPI_TYPE_SEQ_STYLE (guppi_seq_style_get_type())
#define GUPPI_SEQ_STYLE(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SEQ_STYLE,GuppiSeqStyle))
#define GUPPI_SEQ_STYLE0(obj) ((obj) ? (GUPPI_SEQ_STYLE(obj)) : NULL)
#define GUPPI_SEQ_STYLE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_SEQ_STYLE,GuppiSeqStyleClass))
#define GUPPI_IS_SEQ_STYLE(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SEQ_STYLE))
#define GUPPI_IS_SEQ_STYLE0(obj) (((obj) == NULL) || (GUPPI_IS_SEQ_STYLE(obj)))
#define GUPPI_IS_SEQ_STYLE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SEQ_STYLE))

GtkType guppi_seq_style_get_type (void);

GuppiData *guppi_seq_style_new (void);

GuppiStyle *guppi_seq_style_get (const GuppiSeqStyle *, gint);
void guppi_seq_style_set (GuppiSeqStyle *, gint, GuppiStyle *);

void guppi_seq_style_prepend (GuppiSeqStyle *, GuppiStyle *);
void guppi_seq_style_append (GuppiSeqStyle *, GuppiStyle *);
void guppi_seq_style_insert (GuppiSeqStyle *, gint, GuppiStyle *);



END_GUPPI_DECLS

#endif /* _INC_GUPPI_SEQ_STYLE_H */

/* $Id: guppi-seq-style.h,v 1.5 2001/01/16 23:36:36 trow Exp $ */
