/*
 * Copyright 2000 Murray Cumming
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "FileSelection.h"

namespace Bakery
{

FileSelection::FileSelection(const Gtk::nstring& title = 0)
: Gtk::FileSelection(title)
{
  m_bRunInProgress = false;
  m_bRunSuccess = false;

  get_ok_button()->clicked.connect(slot(this, &FileSelection::on_Button_OK_clicked));
  get_cancel_button()->clicked.connect(slot(this, &FileSelection::on_Button_Cancel_clicked));
  
  //close.connect(slot(this, &FileSelection::on_close));
  //destroy.connect(slot(this, &FileSelection::on_destroy));
  
}

FileSelection::~FileSelection()
{
}

bool FileSelection::run()
{
  if(m_bRunInProgress)
  {
    //Prevent a run() while run() is already happening:
    //This could probably never happen anyway.
    return false;
  }
  else
  {
    m_bRunInProgress = true;
    m_bRunSuccess = false; //re-initialisation.

    show_all();


	  //I don't see how to use Gtk::Main for this,
	  //so I'm using the C GTK+ API, as per gnome_dialog_run_real().
	  //
	  //The gtk main loop will return when one of the signal handlers
	  //for this instance calls gtk_main_quit().
	  gtk_main();
	  
	  return m_bRunSuccess; //Was set by one of the signal handlers during gtk_main().
	}
}

void FileSelection::run_main_stop()
{
  if(m_bRunInProgress)
  {
	  hide(); //Acknowledge the user's action.
	  m_bRunInProgress = false; 
	  gtk_main_quit(); //Tell the gtk_main() in run() to return.
	}
}

gint FileSelection::delete_event_impl(GdkEventAny* e)
{
  if(m_bRunInProgress)
  {
    on_Button_Cancel_clicked();
    return TRUE; //Prevent further handling.
  }
  else
  {
    //call base class:
    return Gtk::FileSelection::delete_event_impl(e);
  }
}

void FileSelection::on_Button_OK_clicked()
{
  m_bRunSuccess = true;
  run_main_stop();
}

void FileSelection::on_Button_Cancel_clicked()
{
  m_bRunSuccess = false;
  run_main_stop();
}

} //namespace
