//***********************************************************************
// *  $RCSfile$ - PersonSync.cs
// *
// *  Copyright (C) 2007 Novell, Inc.
// *
// *  This program is free software; you can redistribute it and/or
// *  modify it under the terms of the GNU General Public
// *  License as published by the Free Software Foundation; either
// *  version 2 of the License, or (at your option) any later version.
// *
// *  This program is distributed in the hope that it will be useful,
// *  but WITHOUT ANY WARRANTY; without even the implied warranty of
// *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// *  General Public License for more details.
// *
// *  You should have received a copy of the GNU General Public
// *  License along with this program; if not, write to the Free
// *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
// *
// **********************************************************************


using System;

namespace Banter
{
	///<summary>
	///	PersonSync Class
	/// Synchronizes the Telepathy contacts with EDS contacts.  This is done using
	/// the ProviderUserManager and the PersonStore.
	///</summary>
	public class PersonSync
	{

		#region Constructors
		/// <summary>
		/// Creates a new PersonSync
		/// </summary>			
		public PersonSync()
		{
		}
		#endregion
		
		
		#region Public Methods
		/// <summary>
		/// This should perform an initial sync of telepathy contacts and EDS contacts then listen to
		/// events on both sides and keep things in sync
		/// </summary>			
		public void Start()
		{
			ProviderUserManager.ProviderUserAdded += ProviderUserAdded;
		}
		
		
		/// <summary>
		/// This should deregister from all events and clean up
		/// </summary>			
		public void Stop()
		{
			ProviderUserManager.ProviderUserAdded -= ProviderUserAdded;		
		}
		#endregion
		
		
		#region Private Methods
		public void ProviderUserAdded (ProviderUser user)
		{
			Person person = PersonStore.GetPerson(user);
			if(person == null) {
				Logger.Debug("PersonSync.ProviderUserAdded: Adding new Contact in EDS: {0}", user.Alias);
				person = new Person(user.Alias);
				person.JabberId = user.Uri;
				PersonStore.AddPerson(person);
			}
		}
		#endregion
	
	}
}
