/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2004 Imendio HB
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <libgnome/gnome-i18n.h>

#include "blam-channel-menu.h"

struct _BlamChannelMenu {
	GtkItemFactory   *factory;
	CallbackHandler_  menu_cb;
};

static void channel_menu_cb (BlamChannelMenu *menu,
			     guint            action,
			     GtkWidget       *widget);

enum {
	CHANNEL_MENU_NONE,
	CHANNEL_MENU_EDIT,
	CHANNEL_MENU_MARK_AS_READ,
	CHANNEL_MENU_REMOVE,
	CHANNEL_MENU_UPDATE
};

#define GIF_CB(x) ((GtkItemFactoryCallback)(x))
static GtkItemFactoryEntry channel_menu_items[] = {
	{
		N_("/_Refresh"),
                NULL,
                GIF_CB (channel_menu_cb),
                CHANNEL_MENU_UPDATE,
                "<StockItem>",
                "gtk-refresh"
        },
	{
		N_("/_Edit"),
                NULL,
                GIF_CB (channel_menu_cb),
                CHANNEL_MENU_EDIT,
                "<Item>",
                NULL
        },
	{
		N_("/_Mark as read"),
		NULL,
		GIF_CB (channel_menu_cb),
		CHANNEL_MENU_MARK_AS_READ,
		"<Item>",
		NULL
	},
	{
		N_("/Remo_ve"),
                NULL,
                GIF_CB (channel_menu_cb),
                CHANNEL_MENU_REMOVE,
                "<StockItem>",
                "gtk-remove"
        }
};

static gchar *
channel_menu_translate_func (const gchar *path, gpointer data)
{
        return _((gchar *) path);
}

BlamChannelMenu *
blam_channel_menu_new (CallbackHandler_ menu_cb)
{ 
	BlamChannelMenu *menu = g_new0 (BlamChannelMenu, 1);
	
	menu->menu_cb = menu_cb;

	menu->factory = gtk_item_factory_new (GTK_TYPE_MENU,
					      "<main>", NULL);

	gtk_item_factory_set_translate_func (menu->factory,
					     channel_menu_translate_func,
					     NULL, NULL);

	gtk_item_factory_create_items (menu->factory,
				       G_N_ELEMENTS (channel_menu_items),
				       channel_menu_items,
				       menu);

	return menu;
}

void 
blam_channel_menu_popup (BlamChannelMenu *menu,
			 guint x, guint y, guint32 time_)
{
	gtk_item_factory_popup (GTK_ITEM_FACTORY(menu->factory),
				x, y, 3, time_);
}

void 
blam_channel_menu_destroy (BlamChannelMenu *menu)
{
	g_object_unref (menu->factory);
	g_free (menu);
}

static void
channel_menu_cb (BlamChannelMenu *menu,
		 guint            action,
		 GtkWidget       *widget)
{
	(*menu->menu_cb) (action);
}

