//
// Author: 
//   Mikael Hallendal <micke@imendio.com>
//
// (C) 2004 Imendio HB
// 

using Gnome;
using Gtk;
using GtkSharp;
using System;
using System.IO;

namespace Imendio.Blam {
    public class PrintDialog {
	private ItemView itemView;
	private PrintJob printJob;
	private bool     printed;

	private static string printConfigFile = Application.BaseDir + "/print-config";

	public PrintDialog(ItemView itemView)
	{
	    this.itemView = itemView;
	    this.printed = false;
	}

	public void Run()
	{
	    int response;

	    if (!itemView.PageLoaded) { 
		return;
	    }
	    
	    printJob = new PrintJob(LoadPrintConfig());
	    Gnome.PrintDialog dialog = new Gnome.PrintDialog(printJob, 
							     "Print - " + itemView.Title);
	    dialog.Icon = Gdk.Pixbuf.LoadFromResource("blam.png");
	    response = dialog.Run();
	    dialog.Destroy();
	    
	    if (response == (int)ResponseType.Cancel) {
		return;
	    } 

	    itemView.Print(printJob.Context);
	    printJob.Close();
	    
	    switch (response) {
	    case ((int)PrintButtons.Print):
		printJob.Print();
		break;
	    case ((int)PrintButtons.Preview):
		PrintJobPreview preview = new PrintJobPreview(printJob, 
							      itemView.Title);
		preview.Icon = Gdk.Pixbuf.LoadFromResource("blam.png");
		preview.Show();
		break;
	    }

	    SavePrintConfig(printJob.Config);
	}

	public static PrintConfig LoadPrintConfig()
	{
	    try {
		StreamReader reader = new StreamReader(File.OpenRead(printConfigFile));
		string configData = reader.ReadToEnd();
		PrintConfig config = PrintConfig.FromString(configData, 0);
		reader.Close();
		return config;
	    }
	    catch (Exception) {
		return PrintConfig.Default();
	    }
	}

	public static void SavePrintConfig(PrintConfig config)
	{
	    string configData = config.ToString(0);

	    try {
		if (File.Exists(printConfigFile)) {
		    File.Delete(printConfigFile);
		}
		StreamWriter writer = new StreamWriter(File.OpenWrite(printConfigFile));
		writer.Write(configData);
		writer.Close();
	    }
	    catch (Exception) {
		// Doesn't matter much, we just won't be able to save 
		// printer settings.
	    }
	}
    }
}

