/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */

/*
 * Nautilus
 *
 * Copyright (C) 2000 Eazel, Inc.
 *
 * Nautilus is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Nautilus is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Andy Hertzfeld <andy@eazel.com>
 *
 * This is the header file for the throbber on the location bar
 *
 * $Id: blam-spinner.h,v 1.1.1.1 2004/01/12 04:17:38 hallski Exp $
 */

#ifndef BLAM_SPINNER_H
#define BLAM_SPINNER_H

#include <gtk/gtkeventbox.h>

G_BEGIN_DECLS

#define BLAM_TYPE_SPINNER	  (blam_spinner_get_type ())
#define BLAM_SPINNER(o)		  (G_TYPE_CHECK_INSTANCE_CAST ((o), BLAM_TYPE_SPINNER, BlamSpinner))
#define BLAM_SPINNER_CLASS(k)	  (G_TYPE_CHECK_CLASS_CAST((k), BLAM_TYPE_SPINNER, BlamSpinnerClass))
#define BLAM_IS_SPINNER(o)	  (G_TYPE_CHECK_INSTANCE_TYPE ((o), BLAM_TYPE_SPINNER))
#define BLAM_IS_SPINNER_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BLAM_TYPE_SPINNER))
#define BLAM_SPINNER_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BLAM_TYPE_SPINNER, BlamSpinnerClass))

typedef struct BlamSpinner BlamSpinner;
typedef struct BlamSpinnerClass BlamSpinnerClass;
typedef struct BlamSpinnerDetails BlamSpinnerDetails;

struct BlamSpinner {
	GtkEventBox parent;

	/*< private >*/
	BlamSpinnerDetails *details;
};

struct BlamSpinnerClass {
	GtkEventBoxClass parent_class;
};

GType         blam_spinner_get_type       (void);

GtkWidget    *blam_spinner_new            (void);

void          blam_spinner_start          (BlamSpinner *throbber);

void          blam_spinner_stop           (BlamSpinner *throbber);

void	      blam_spinner_set_small_mode (BlamSpinner *spinner,
					   gboolean new_mode);

G_END_DECLS

#endif /* BLAM_SPINNER_H */
