/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * This file is part of capuchin-glib. 
 *
 * Copyright (C) Sebastian Pölsterl 2008 <marduk@k-d-w.org>
 * 
 * capuchin-glib is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option)
 * any later version.
 * 
 * capuchin-glib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with capuchin-glib.
 * If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _CAPUCHIN_G_APP_OBJECT_MANAGER_H_
#define _CAPUCHIN_G_APP_OBJECT_MANAGER_H_

#include <glib-object.h>
#include <capuchin-glib/capuchin-g-app-object.h>

G_BEGIN_DECLS

#define CAPUCHIN_TYPE_G_APP_OBJECT_MANAGER             (capuchin_g_app_object_manager_get_type ())
#define CAPUCHIN_G_APP_OBJECT_MANAGER(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), CAPUCHIN_TYPE_G_APP_OBJECT_MANAGER, CapuchinGAppObjectManager))
#define CAPUCHIN_G_APP_OBJECT_MANAGER_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), CAPUCHIN_TYPE_G_APP_OBJECT_MANAGER, CapuchinGAppObjectManagerClass))
#define CAPUCHIN_IS_G_APP_OBJECT_MANAGER(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CAPUCHIN_TYPE_G_APP_OBJECT_MANAGER))
#define CAPUCHIN_IS_G_APP_OBJECT_MANAGER_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), CAPUCHIN_TYPE_G_APP_OBJECT_MANAGER))
#define CAPUCHIN_G_APP_OBJECT_MANAGER_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), CAPUCHIN_TYPE_G_APP_OBJECT_MANAGER, CapuchinGAppObjectManagerClass))

typedef struct _CapuchinGAppObjectManagerClass CapuchinGAppObjectManagerClass;
typedef struct _CapuchinGAppObjectManager CapuchinGAppObjectManager;
typedef struct _CapuchinGAppObjectManagerPrivate CapuchinGAppObjectManagerPrivate;

struct _CapuchinGAppObjectManagerClass
{
	GObjectClass parent_class;
};

struct _CapuchinGAppObjectManager
{
	GObject parent_instance;
	CapuchinGAppObjectManagerPrivate *priv;
};

GType capuchin_g_app_object_manager_get_type (void) G_GNUC_CONST;
CapuchinGAppObjectManager* capuchin_g_app_object_manager_new (void);
CapuchinGAppObject* capuchin_g_app_object_manager_get_appobject (CapuchinGAppObjectManager *manager, const gchar *url, GError **error);

G_END_DECLS

#endif /* _CAPUCHIN_G_APP_OBJECT_MANAGER_H_ */
