#include <cv.h>
#include <highgui.h>
#include <math.h>
#include <stdio.h>

//compilar amb:
//gcc `pkg-config --cflags --libs opencv` detecta_cercles.c -o detecta_cercles

//aixo no tira per lo meu, suposo que calen cercles molt perfectes

int main(int argc, char** argv)
{
	IplImage* img;
	if( argc == 2 && (img=cvLoadImage(argv[1], 1))!= 0)
	{
		IplImage* gray = cvCreateImage( cvGetSize(img), 8, 1 );
		CvMemStorage* storage = cvCreateMemStorage(0);
		cvCvtColor( img, gray, CV_BGR2GRAY );
		//cvSmooth( gray, gray, CV_GAUSSIAN, 9, 9 ); // smooth it, otherwise a lot of false circles may be detected
//		cvSmooth( gray, gray, CV_GAUSSIAN, 9, 9, 0, 0 ); // smooth it, otherwise a lot of false circles may be detected
		//CvSeq* circles = cvHoughCircles( gray, storage, CV_HOUGH_GRADIENT, 2, gray->height/4, 200, 100 );
		CvSeq* circles = cvHoughCircles( gray, storage, CV_HOUGH_GRADIENT, 2, gray->height/4, 200, 100, 0, 0);
		int i;
		for( i = 0; i < circles->total; i++ )
		{
			float* p = (float*)cvGetSeqElem( circles, i );
			cvCircle( img, cvPoint(cvRound(p[0]),cvRound(p[1])), 3, CV_RGB(0,255,0), -1, 8, 0 );
			cvCircle( img, cvPoint(cvRound(p[0]),cvRound(p[1])), cvRound(p[2]), CV_RGB(255,0,0), 3, 8, 0 );
			printf("a");
		}
		cvNamedWindow( "circles", 1 );
		cvShowImage( "circles", img );
		while(1);
	} else {
		printf("not found");
	}
	return 0;
}

