/* cluttermm - a C++ wrapper for clutter
 *
 * Copyright 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LIBCLUTTERMM_H
#define LIBCLUTTERMM_H

/* cluttermm version.  */
extern const int cluttermm_major_version;
extern const int cluttermm_minor_version;
extern const int cluttermm_micro_version;

#include <glibmm.h>

#include <cluttermm/actor.h>
#include <cluttermm/alpha.h>
#include <cluttermm/behaviour.h>
#include <cluttermm/behaviour-bspline.h>
#include <cluttermm/behaviour-depth.h>
#include <cluttermm/behaviour-ellipse.h>
#include <cluttermm/behaviour-opacity.h>
#include <cluttermm/behaviour-path.h>
#include <cluttermm/behaviour-rotate.h>
#include <cluttermm/behaviour-scale.h>
#include <cluttermm/clone-texture.h>
#include <cluttermm/color.h>
#include <cluttermm/effecttemplate.h>
#include <cluttermm/entry.h>
#include <cluttermm/event.h>
#include <cluttermm/frame-source.h>
#include <cluttermm/group.h>
#include <cluttermm/init.h>
#include <cluttermm/label.h>
#include <cluttermm/main.h>
#include <cluttermm/media.h>
#include <cluttermm/rectangle.h>
#include <cluttermm/stage.h>
#include <cluttermm/texture.h>
#include <cluttermm/threads.h>
#include <cluttermm/timeline.h>
#include <cluttermm/score.h>
#include <cluttermm/shader.h>
#include <cluttermm/script.h>
#include <cluttermm/timeout-pool.h>
#include <cluttermm/types.h>
#include <cluttermm/utility.h>

//#include <cluttermm/box.h>
//#include <cluttermm/container.h>
//#include <cluttermm/layout.h>
//#include <cluttermm/margin.h>

#endif /* #ifndef LIBCLUTTERMM_H */
