
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <cluttermm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "types.h"
#include "actor.h"
#include "color.h"
#include "media.h"
#include "group.h"
#include "stage.h"
#include "rectangle.h"
#include "texture.h"
#include "clone-texture.h"
#include "container.h"
#include "label.h"
#include "entry.h"
#include "timeline.h"
#include "alpha.h"
#include "behaviour.h"
#include "behaviour-bspline.h"
#include "behaviour-depth.h"
#include "behaviour-opacity.h"
#include "behaviour-path.h"
#include "behaviour-ellipse.h"
#include "behaviour-rotate.h"
#include "behaviour-scale.h"
#include "score.h"
#include "shader.h"
#include "script.h"
#include "scriptable.h"
#include "effecttemplate.h"
#include "timeout-pool.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType clutter_actor_get_type(void);
GType clutter_alpha_get_type(void);
GType clutter_behaviour_get_type(void);
GType clutter_behaviour_bspline_get_type(void);
GType clutter_behaviour_depth_get_type(void);
GType clutter_behaviour_ellipse_get_type(void);
GType clutter_behaviour_opacity_get_type(void);
GType clutter_behaviour_path_get_type(void);
GType clutter_behaviour_rotate_get_type(void);
GType clutter_behaviour_scale_get_type(void);
GType clutter_clone_texture_get_type(void);
GType clutter_effect_template_get_type(void);
GType clutter_entry_get_type(void);
GType clutter_group_get_type(void);
GType clutter_label_get_type(void);
GType clutter_rectangle_get_type(void);
GType clutter_score_get_type(void);
GType clutter_script_get_type(void);
GType clutter_shader_get_type(void);
GType clutter_stage_get_type(void);
GType clutter_texture_get_type(void);
GType clutter_timeline_get_type(void);

//Declarations of the *_error_quark() functions:

GQuark clutter_init_error_quark(void);
GQuark clutter_texture_error_quark(void);
} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Clutter {  class Actor_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Alpha_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Behaviour_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class BehaviourBspline_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class BehaviourDepth_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class BehaviourEllipse_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class BehaviourOpacity_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class BehaviourPath_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class BehaviourRotate_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class BehaviourScale_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class CloneTexture_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class EffectTemplate_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Entry_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Group_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Label_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Rectangle_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Score_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Script_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Shader_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Stage_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Texture_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Timeline_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }

namespace Clutter { 

void wrap_init()
{
  // Register Error domains:
  Glib::Error::register_domain(clutter_init_error_quark(), &Clutter::InitError::throw_func);
  Glib::Error::register_domain(clutter_texture_error_quark(), &Clutter::TextureError::throw_func);

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(clutter_actor_get_type(), &Clutter::Actor_Class::wrap_new);
  Glib::wrap_register(clutter_alpha_get_type(), &Clutter::Alpha_Class::wrap_new);
  Glib::wrap_register(clutter_behaviour_get_type(), &Clutter::Behaviour_Class::wrap_new);
  Glib::wrap_register(clutter_behaviour_bspline_get_type(), &Clutter::BehaviourBspline_Class::wrap_new);
  Glib::wrap_register(clutter_behaviour_depth_get_type(), &Clutter::BehaviourDepth_Class::wrap_new);
  Glib::wrap_register(clutter_behaviour_ellipse_get_type(), &Clutter::BehaviourEllipse_Class::wrap_new);
  Glib::wrap_register(clutter_behaviour_opacity_get_type(), &Clutter::BehaviourOpacity_Class::wrap_new);
  Glib::wrap_register(clutter_behaviour_path_get_type(), &Clutter::BehaviourPath_Class::wrap_new);
  Glib::wrap_register(clutter_behaviour_rotate_get_type(), &Clutter::BehaviourRotate_Class::wrap_new);
  Glib::wrap_register(clutter_behaviour_scale_get_type(), &Clutter::BehaviourScale_Class::wrap_new);
  Glib::wrap_register(clutter_clone_texture_get_type(), &Clutter::CloneTexture_Class::wrap_new);
  Glib::wrap_register(clutter_effect_template_get_type(), &Clutter::EffectTemplate_Class::wrap_new);
  Glib::wrap_register(clutter_entry_get_type(), &Clutter::Entry_Class::wrap_new);
  Glib::wrap_register(clutter_group_get_type(), &Clutter::Group_Class::wrap_new);
  Glib::wrap_register(clutter_label_get_type(), &Clutter::Label_Class::wrap_new);
  Glib::wrap_register(clutter_rectangle_get_type(), &Clutter::Rectangle_Class::wrap_new);
  Glib::wrap_register(clutter_score_get_type(), &Clutter::Score_Class::wrap_new);
  Glib::wrap_register(clutter_script_get_type(), &Clutter::Script_Class::wrap_new);
  Glib::wrap_register(clutter_shader_get_type(), &Clutter::Shader_Class::wrap_new);
  Glib::wrap_register(clutter_stage_get_type(), &Clutter::Stage_Class::wrap_new);
  Glib::wrap_register(clutter_texture_get_type(), &Clutter::Texture_Class::wrap_new);
  Glib::wrap_register(clutter_timeline_get_type(), &Clutter::Timeline_Class::wrap_new);

  // Register the gtkmm gtypes:
  Clutter::Actor::get_type();
  Clutter::Alpha::get_type();
  Clutter::Behaviour::get_type();
  Clutter::BehaviourBspline::get_type();
  Clutter::BehaviourDepth::get_type();
  Clutter::BehaviourEllipse::get_type();
  Clutter::BehaviourOpacity::get_type();
  Clutter::BehaviourPath::get_type();
  Clutter::BehaviourRotate::get_type();
  Clutter::BehaviourScale::get_type();
  Clutter::CloneTexture::get_type();
  Clutter::EffectTemplate::get_type();
  Clutter::Entry::get_type();
  Clutter::Group::get_type();
  Clutter::Label::get_type();
  Clutter::Rectangle::get_type();
  Clutter::Score::get_type();
  Clutter::Script::get_type();
  Clutter::Shader::get_type();
  Clutter::Stage::get_type();
  Clutter::Texture::get_type();
  Clutter::Timeline::get_type();

} // wrap_init()

} //Clutter


