// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_GROUP_H
#define _CLUTTERMM_GROUP_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/actor.h>
#include <cluttermm/container.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterGroup ClutterGroup;
typedef struct _ClutterGroupClass ClutterGroupClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Group_Class; } // namespace Clutter
namespace Clutter
{


class Group :
    public Actor,
    public Container
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Group CppObjectType;
  typedef Group_Class CppClassType;
  typedef ClutterGroup BaseObjectType;
  typedef ClutterGroupClass BaseClassType;

private:  friend class Group_Class;
  static CppClassType group_class_;

private:
  // noncopyable
  Group(const Group&);
  Group& operator=(const Group&);

protected:
  explicit Group(const Glib::ConstructParams& construct_params);
  explicit Group(ClutterGroup* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Group();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterGroup*       gobj()       { return reinterpret_cast<ClutterGroup*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterGroup* gobj() const { return reinterpret_cast<ClutterGroup*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterGroup* gobj_copy();

private:

  
protected:
  Group();

public:
  
  static Glib::RefPtr<Group> create();


  /** Removes all children actors from the Clutter::Group.
   */
  void remove_all();
  
  /** Gets the number of actors held in the group.
   * @return The number of child actors held in the group.
   * 
   * Since: 0.2.
   */
  int get_n_children() const;
  
  /** Gets a groups child held at @a index in stack.
   * @param index The position of the requested actor.
   * @return A Clutter actor or <tt>0</tt> if @a index is invalid.
   * 
   * Since: 0.2.
   */
  Glib::RefPtr<Actor> get_nth_child(int index);
  
  /** Gets a groups child held at @a index in stack.
   * @param index The position of the requested actor.
   * @return A Clutter actor or <tt>0</tt> if @a index is invalid.
   * 
   * Since: 0.2.
   */
  Glib::RefPtr<const Actor> get_nth_child(int index) const;


  // these functions were deprecated in favor of their Container counterparts
  
  
public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Group
   */
  Glib::RefPtr<Clutter::Group> wrap(ClutterGroup* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_GROUP_H */

