// -*- c++ -*-
// Generated by gmmproc 2.39.93 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_CANVAS_H
#define _CLUTTERMM_CANVAS_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <cluttermm/content.h>
#include <cairomm/cairomm.h>
#include <cairo/cairo.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterCanvas ClutterCanvas;
typedef struct _ClutterCanvasClass ClutterCanvasClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Canvas_Class; } // namespace Clutter
namespace Clutter
{


class Canvas : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Canvas CppObjectType;
  typedef Canvas_Class CppClassType;
  typedef ClutterCanvas BaseObjectType;
  typedef ClutterCanvasClass BaseClassType;

private:  friend class Canvas_Class;
  static CppClassType canvas_class_;

private:
  // noncopyable
  Canvas(const Canvas&);
  Canvas& operator=(const Canvas&);

protected:
  explicit Canvas(const Glib::ConstructParams& construct_params);
  explicit Canvas(ClutterCanvas* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Canvas();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterCanvas*       gobj()       { return reinterpret_cast<ClutterCanvas*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterCanvas* gobj() const { return reinterpret_cast<ClutterCanvas*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterCanvas* gobj_copy();

private:

  
protected:
  Canvas();

public:
  
  static Glib::RefPtr<Canvas> create();


  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%draw(const ::Cairo::RefPtr< ::Cairo::Context>& p1, int width, int height)</tt>
   *
   * The Clutter::Canvas::signal_draw() signal is emitted each time a canvas is
   * invalidated.
   * 
   * It is safe to connect multiple handlers to this signal: each
   * handler invocation will be automatically protected by cairo_save()
   * and cairo_restore() pairs.
   * 
   * @newin{1,10}
   * @param cr The Cairo context used to draw.
   * @param width The width of the @a canvas.
   * @param height The height of the @a canvas.
   * @return <tt>true</tt> if the signal emission should stop, and
   * <tt>false</tt> otherwise.
   */

  Glib::SignalProxy3< bool,const ::Cairo::RefPtr< ::Cairo::Context>&,int,int > signal_draw();


  /** Sets the size of the @a canvas, and invalidates the content.
   * 
   * This function will cause the @a canvas to be invalidated only
   * if the size of the canvas surface has changed.
   * 
   * If you want to invalidate the contents of the @a canvas when setting
   * the size, you can use the return value of the function to conditionally
   * call Clutter::Content::invalidate():
   * 
   * 
   * [C example ellipted]
   * 
   * @newin{1,10}
   * @param width The width of the canvas, in pixels.
   * @param height The height of the canvas, in pixels.
   * @return This function returns <tt>true</tt> if the size change
   * caused a content invalidation, and <tt>false</tt> otherwise.
   */
  void set_size(int width, int height);

protected:
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The height of the canvas.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_height() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The height of the canvas.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_height() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The width of the canvas.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The width of the canvas.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_draw().
  virtual bool on_draw(const ::Cairo::RefPtr< ::Cairo::Context>& p1, int width, int height);


};

 }//namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Canvas
   */
  Glib::RefPtr<Clutter::Canvas> wrap(ClutterCanvas* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_CANVAS_H */

