// -*- c++ -*-
// Generated by gmmproc 2.39.93 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_IMAGE_H
#define _CLUTTERMM_IMAGE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2014 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <cogl/cogl.h>
#include <cluttermm/content.h>
#include <cluttermm/types.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterImage ClutterImage;
typedef struct _ClutterImageClass ClutterImageClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Image_Class; } // namespace Clutter
namespace Clutter
{

/** @addtogroup cluttermmEnums cluttermm Enums and Flags */

/** 
 *  @var ImageError IMAGE_ERROR_INVALID_DATA
 *  Invalid data passed to the Clutter::Image::set_data() function.
 * 
 *  @enum ImageError
 * 
 * Error enumeration for Clutter::Image.
 * 
 * @newin{1,10}
 * @ingroup cluttermmEnums
 */
enum ImageError
{
  IMAGE_ERROR_INVALID_DATA
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::ImageError> : public Glib::Value_Enum<Clutter::ImageError>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


class Image
  : public Glib::Object,
    public Content
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Image CppObjectType;
  typedef Image_Class CppClassType;
  typedef ClutterImage BaseObjectType;
  typedef ClutterImageClass BaseClassType;

private:  friend class Image_Class;
  static CppClassType image_class_;

private:
  // noncopyable
  Image(const Image&);
  Image& operator=(const Image&);

protected:
  explicit Image(const Glib::ConstructParams& construct_params);
  explicit Image(ClutterImage* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Image();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterImage*       gobj()       { return reinterpret_cast<ClutterImage*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterImage* gobj() const { return reinterpret_cast<ClutterImage*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterImage* gobj_copy();

private:

  
protected:
    explicit Image();


public:

  
  static Glib::RefPtr<Image> create();

  //_WRAP_METHOD(CoglTexture* get_texture(), clutter_image_get_texture)

  
  /** Sets the image data to be displayed by @a image.
   * 
   * If the image data was successfully loaded, the @a image will be invalidated.
   * 
   * In case of error, the @a error value will be set, and this function will
   * return <tt>false</tt>.
   * 
   * The image data is copied in texture memory.
   * 
   * @newin{1,10}
   * @param data The image data, as an array of bytes.
   * @param pixel_format The Cogl pixel format of the image data.
   * @param width The width of the image data.
   * @param height The height of the image data.
   * @param row_stride The length of each row inside @a data.
   * @return <tt>true</tt> if the image data was successfully loaded,
   * and <tt>false</tt> otherwise.
   */
  bool set(const guint8* data, CoglPixelFormat pixel_format, guint width, guint height, guint row_stride);

  
  /** Sets the image data stored inside a Bytes to be displayed by @a image.
   * 
   * If the image data was successfully loaded, the @a image will be invalidated.
   * 
   * In case of error, the @a error value will be set, and this function will
   * return <tt>false</tt>.
   * 
   * The image data contained inside the Bytes is copied in texture memory,
   * and no additional reference is acquired on the @a data.
   * 
   * @newin{1,12}
   * @param data The image data, as a Bytes.
   * @param pixel_format The Cogl pixel format of the image data.
   * @param width The width of the image data.
   * @param height The height of the image data.
   * @param row_stride The length of each row inside @a data.
   * @return <tt>true</tt> if the image data was successfully loaded,
   * and <tt>false</tt> otherwise.
   */
  bool set(const Glib::Bytes& data, CoglPixelFormat pixel_format, guint width, guint height, guint row_stride);


  //TODO IM: Not sure how to wrap the Cogl::Rectangle, seeing as Cogl isn't wrapped.

  //~ bool set_area(const int data, Cogl::PixelFormat pixel_format, int width, int height, int row_stride);

  // TODO IM: from Pango::Coverage:
  //** Convert the coverage map into a flat binary format.
   //* @return An array of bytes representing the coverage map.
   //*/
  //Glib::ArrayHandle<unsigned char> to_bytes() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Image
   */
  Glib::RefPtr<Clutter::Image> wrap(ClutterImage* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_IMAGE_H */

