// -*- c++ -*-
// Generated by gmmproc 2.40.0 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_SIZE_H
#define _CLUTTERMM_SIZE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2014 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <clutter/clutter.h>
#include <cogl/cogl.h>


namespace Clutter
{

/**
 * A size in 2D space.
 */
class Size
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Size CppObjectType;
  typedef ClutterSize BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;


  explicit Size(const ClutterSize* gobject); // always takes a copy

  ///Provides access to the underlying C instance.
  ClutterSize*       gobj()       { return &gobject_; }

  ///Provides access to the underlying C instance.
  const ClutterSize* gobj() const { return &gobject_; }

protected:
  ClutterSize gobject_;

private:
  
public:
  
  explicit Size(float width = 0, float height = 0);

  //Prevents ambiguous calls to Size(ClutterSize*, bool)
  Size(int width, int height);

  /**
   * Prevents calls to Size(double, double) being ambiguous.
   * N.B. this will convert the input to floats, and rounding
   * errors are possible.
   */
  Size(double width, double height);

  
   float get_width() const;
    float get_height() const;
    void set_width(const float& value);
    void set_height(const float& value);
 

};

} // namespace Clutter


namespace Clutter
{

/** @relates Clutter::Size
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator==(const Size& lhs, const Size& rhs);

/** @relates Clutter::Size
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator!=(const Size& lhs, const Size& rhs);


} // namespace Clutter


namespace Glib
{

/** @relates Clutter::Size
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
Clutter::Size& wrap(ClutterSize* object);

/** @relates Clutter::Size
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
const Clutter::Size& wrap(const ClutterSize* object);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Clutter::Size> : public Glib::Value_Boxed<Clutter::Size>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _CLUTTERMM_SIZE_H */

