// -*- c++ -*-
// Generated by gmmproc 2.40.0 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_SNAP_CONSTRAINT_H
#define _CLUTTERMM_SNAP_CONSTRAINT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2014 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <cluttermm/types.h>
#include <cluttermm/constraint.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterSnapConstraint ClutterSnapConstraint;
typedef struct _ClutterSnapConstraintClass ClutterSnapConstraintClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class SnapConstraint_Class; } // namespace Clutter
namespace Clutter
{

class Actor;
class Constraint;

/** @addtogroup cluttermmEnums cluttermm Enums and Flags */

/** 
 *  @var SnapEdge SNAP_EDGE_TOP
 *  The top edge.
 * 
 *  @var SnapEdge SNAP_EDGE_RIGHT
 *  The right edge.
 * 
 *  @var SnapEdge SNAP_EDGE_BOTTOM
 *  The bottom edge.
 * 
 *  @var SnapEdge SNAP_EDGE_LEFT
 *  The left edge.
 * 
 *  @enum SnapEdge
 * 
 * The edge to snap
 * 
 * @newin{1,6}
 * @ingroup cluttermmEnums
 */
enum SnapEdge
{
  SNAP_EDGE_TOP,
  SNAP_EDGE_RIGHT,
  SNAP_EDGE_BOTTOM,
  SNAP_EDGE_LEFT
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::SnapEdge> : public Glib::Value_Enum<Clutter::SnapEdge>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


/** SnapConstraint is a constraint the snaps the edges of two actors
 * together, expanding the actor's allocation if necessary.
 *
 * An offset can be applied to the constraint, to provide spacing.
 *
 * @newin{1,6}
 */

class SnapConstraint : public Constraint
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef SnapConstraint CppObjectType;
  typedef SnapConstraint_Class CppClassType;
  typedef ClutterSnapConstraint BaseObjectType;
  typedef ClutterSnapConstraintClass BaseClassType;

private:  friend class SnapConstraint_Class;
  static CppClassType snapconstraint_class_;

private:
  // noncopyable
  SnapConstraint(const SnapConstraint&);
  SnapConstraint& operator=(const SnapConstraint&);

protected:
  explicit SnapConstraint(const Glib::ConstructParams& construct_params);
  explicit SnapConstraint(ClutterSnapConstraint* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~SnapConstraint();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterSnapConstraint*       gobj()       { return reinterpret_cast<ClutterSnapConstraint*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterSnapConstraint* gobj() const { return reinterpret_cast<ClutterSnapConstraint*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterSnapConstraint* gobj_copy();

private:

  
protected:
    explicit SnapConstraint(const Glib::RefPtr<Actor>& source, SnapEdge from_edge, SnapEdge to_edge, float offset);


public:

  
  static Glib::RefPtr<SnapConstraint> create(const Glib::RefPtr<Actor>& source, SnapEdge from_edge, SnapEdge to_edge, float offset);


  /** Sets the source Clutter::Actor for the constraint
   * 
   * @newin{1,6}
   * @param source A Clutter::Actor, or <tt>0</tt> to unset the source.
   */
  void set_source(const Glib::RefPtr<Actor>& source);

  
  /** Retrieves the Clutter::Actor set using set_source()
   * 
   * @newin{1,6}
   * @return A pointer to the source actor.
   */
  Glib::RefPtr<Actor> get_source();
  
  /** Retrieves the Clutter::Actor set using set_source()
   * 
   * @newin{1,6}
   * @return A pointer to the source actor.
   */
  Glib::RefPtr<const Actor> get_source() const;

  
  /** Sets the edges to be used by the @a constraint
   * 
   * The @a from_edge is the edge on the Clutter::Actor to which @a constraint
   * has been added. The @a to_edge is the edge of the Clutter::Actor inside
   * the Clutter::SnapConstraint::property_source() property.
   * 
   * @newin{1,6}
   * @param from_edge The edge on the actor.
   * @param to_edge The edge on the source.
   */
  void set_edges(SnapEdge from_edge, SnapEdge to_edge);

  //TODO : using two enum return parameters.
  //~ _WRAP_METHOD_DOCS_ONLY(clutter_snap_constraint_get_edges)
  //~ void get_edges(SnapEdge* from_edge, SnapEdge* to_edge) const;

  
  /** Sets the offset to be applied to the constraint
   * 
   * @newin{1,6}
   * @param offset The offset to apply, in pixels.
   */
  void set_offset(float offset);

  
  /** Retrieves the offset set using set_offset()
   * 
   * @newin{1,6}
   * @return The offset, in pixels.
   */
  float get_offset() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The edge of the actor that should be snapped.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< SnapEdge > property_from_edge() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The edge of the actor that should be snapped.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< SnapEdge > property_from_edge() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The offset in pixels to apply to the constraint.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< float > property_offset() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The offset in pixels to apply to the constraint.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< float > property_offset() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The source of the constraint.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Actor> > property_source() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The source of the constraint.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Actor> > property_source() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The edge of the source that should be snapped.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< SnapEdge > property_to_edge() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The edge of the source that should be snapped.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< SnapEdge > property_to_edge() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::SnapConstraint
   */
  Glib::RefPtr<Clutter::SnapConstraint> wrap(ClutterSnapConstraint* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_SNAP_CONSTRAINT_H */

