/* app-background.c - Background configuration application.  */

#include <config.h>
#include <strings.h>
#include "capplet-widget.h"

extern void background_init(void);

gint
main (gint argc, char *argv[])
{
	GnomeClient *client = NULL;
        GnomeClientFlags flags;
	gchar *session_args[2];
	int token, init_results;

	bindtextdomain (PACKAGE, GNOMELOCALEDIR);
	textdomain (PACKAGE);
	
	init_results = gnome_capplet_init("background-properties", VERSION,
					  argc, argv, NULL, 0, NULL);

	if (init_results < 0) {
                g_warning ("an initialization error occurred while "
			   "starting 'background-properties-capplet'.\n"
                           "aborting...\n");
                exit (1);
	}

	client = gnome_master_client ();
	flags = gnome_client_get_flags(client);

	if (flags & GNOME_CLIENT_IS_CONNECTED) {
		token = gnome_startup_acquire_token("GNOME_BACKGROUND_PROPERTIES",
						    gnome_client_get_id(client));
		
		if (token) {
			session_args[0] = argv[0];
			session_args[1] = "--init-session-settings";
			session_args[2] = NULL;
			gnome_client_set_priority (client, 20);
			gnome_client_set_restart_style (client, 
							GNOME_RESTART_ANYWAY);
			gnome_client_set_restart_command (client, 2, 
							  session_args);
		}
		else 
			gnome_client_set_restart_style (client, 
							GNOME_RESTART_NEVER);

                gnome_client_flush (client);
        }
	else
		token = 1;

	/* this goes somewhere else eventually */
	background_imlib_init ();

        if(token) 
                background_properties_init();

	if (init_results != 1) {
		background_init();
	        capplet_gtk_main ();
	}
	return 0;
}
