/* dconf-window.c generated by valac 0.32.0.61-f103e, the Vala compiler
 * generated from dconf-window.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <cairo.h>


#define TYPE_BEHAVIOUR (behaviour_get_type ())

#define TYPE_DCONF_WINDOW (dconf_window_get_type ())
#define DCONF_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DCONF_WINDOW, DConfWindow))
#define DCONF_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DCONF_WINDOW, DConfWindowClass))
#define IS_DCONF_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DCONF_WINDOW))
#define IS_DCONF_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DCONF_WINDOW))
#define DCONF_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DCONF_WINDOW, DConfWindowClass))

typedef struct _DConfWindow DConfWindow;
typedef struct _DConfWindowClass DConfWindowClass;
typedef struct _DConfWindowPrivate DConfWindowPrivate;

#define TYPE_BOOKMARKS (bookmarks_get_type ())
#define BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARKS, Bookmarks))
#define BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARKS, BookmarksClass))
#define IS_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARKS))
#define IS_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARKS))
#define BOOKMARKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARKS, BookmarksClass))

typedef struct _Bookmarks Bookmarks;
typedef struct _BookmarksClass BookmarksClass;

#define TYPE_PATH_BAR (path_bar_get_type ())
#define PATH_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH_BAR, PathBar))
#define PATH_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PATH_BAR, PathBarClass))
#define IS_PATH_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH_BAR))
#define IS_PATH_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PATH_BAR))
#define PATH_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PATH_BAR, PathBarClass))

typedef struct _PathBar PathBar;
typedef struct _PathBarClass PathBarClass;

#define TYPE_REGISTRY_VIEW (registry_view_get_type ())
#define REGISTRY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGISTRY_VIEW, RegistryView))
#define REGISTRY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGISTRY_VIEW, RegistryViewClass))
#define IS_REGISTRY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGISTRY_VIEW))
#define IS_REGISTRY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGISTRY_VIEW))
#define REGISTRY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGISTRY_VIEW, RegistryViewClass))

typedef struct _RegistryView RegistryView;
typedef struct _RegistryViewClass RegistryViewClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;

#define TYPE_CONFIGURATION_EDITOR (configuration_editor_get_type ())
#define CONFIGURATION_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_EDITOR, ConfigurationEditor))
#define CONFIGURATION_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_EDITOR, ConfigurationEditorClass))
#define IS_CONFIGURATION_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_EDITOR))
#define IS_CONFIGURATION_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_EDITOR))
#define CONFIGURATION_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_EDITOR, ConfigurationEditorClass))

typedef struct _ConfigurationEditor ConfigurationEditor;
typedef struct _ConfigurationEditorClass ConfigurationEditorClass;

#define TYPE_PATH_ELEMENT (path_element_get_type ())
#define PATH_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH_ELEMENT, PathElement))
#define IS_PATH_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH_ELEMENT))
#define PATH_ELEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PATH_ELEMENT, PathElementIface))

typedef struct _PathElement PathElement;
typedef struct _PathElementIface PathElementIface;

typedef enum  {
	BEHAVIOUR_UNSAFE,
	BEHAVIOUR_SAFE,
	BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT,
	BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT,
	BEHAVIOUR_ALWAYS_DELAY
} Behaviour;

struct _DConfWindow {
	GtkApplicationWindow parent_instance;
	DConfWindowPrivate * priv;
};

struct _DConfWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _DConfWindowPrivate {
	gchar* _current_path;
	gint window_width;
	gint window_height;
	gboolean window_is_maximized;
	gboolean window_is_tiled;
	GSettings* settings;
	Bookmarks* bookmarks_button;
	GtkMenuButton* info_button;
	PathBar* pathbar;
	RegistryView* registry_view;
	GtkRevealer* notification_revealer;
	GtkLabel* notification_label;
	gulong behaviour_changed_handler;
	gulong theme_changed_handler;
	gulong small_keys_list_rows_handler;
	gulong small_bookmarks_rows_handler;
};

struct _Block1Data {
	int _ref_count_;
	DConfWindow* self;
	GtkStyleContext* context;
};

struct _Block2Data {
	int _ref_count_;
	DConfWindow* self;
	GtkCheckButton* checkbutton;
};

struct _PathElementIface {
	GTypeInterface parent_iface;
};


static gpointer dconf_window_parent_class = NULL;

GType behaviour_get_type (void) G_GNUC_CONST;
GType dconf_window_get_type (void) G_GNUC_CONST;
GType bookmarks_get_type (void) G_GNUC_CONST;
GType path_bar_get_type (void) G_GNUC_CONST;
GType registry_view_get_type (void) G_GNUC_CONST;
#define DCONF_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DCONF_WINDOW, DConfWindowPrivate))
enum  {
	DCONF_WINDOW_DUMMY_PROPERTY,
	DCONF_WINDOW_CURRENT_PATH
};
static void dconf_window_reset_recursively (DConfWindow* self);
static void _dconf_window_reset_recursively_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void dconf_window_reset (DConfWindow* self);
static void _dconf_window_reset_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void dconf_window_enter_delay_mode (DConfWindow* self);
static void _dconf_window_enter_delay_mode_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
DConfWindow* dconf_window_new (void);
DConfWindow* dconf_window_construct (GType object_type);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void registry_view_invalidate_popovers (RegistryView* self);
static void _registry_view_invalidate_popovers_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda83_ (Block1Data* _data1_);
static void ___lambda83__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda84_ (Block1Data* _data1_);
static void ___lambda84__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda85_ (Block1Data* _data1_);
static void ___lambda85__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
void registry_view_init (RegistryView* self, const gchar* path, gboolean restore_view);
gchar* dconf_window_stripped_path (const gchar* path);
static void dconf_window_on_show (DConfWindow* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda86_ (Block2Data* _data2_);
static void ___lambda86__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void _dconf_window_on_show_gtk_widget_show (GtkWidget* _sender, gpointer self);
static gboolean dconf_window_on_window_state_event (DConfWindow* self, GtkWidget* widget, GdkEventWindowState* event);
static gboolean _dconf_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void dconf_window_on_size_allocate (DConfWindow* self, GtkAllocation* allocation);
static void _dconf_window_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static void dconf_window_on_destroy (DConfWindow* self);
GType configuration_editor_get_type (void) G_GNUC_CONST;
void configuration_editor_clean_copy_notification (ConfigurationEditor* self);
static const gchar* dconf_window_get_current_path (DConfWindow* self);
static void _dconf_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void dconf_window_request_path (DConfWindow* self, const gchar* full_name);
void registry_view_set_search_mode (RegistryView* self, gboolean* mode);
void registry_view_path_requested (RegistryView* self, const gchar* _full_name, const gchar* selected);
gchar* path_bar_get_selected_child (PathBar* self, const gchar* current_path);
GType path_element_get_type (void) G_GNUC_CONST;
static void _dconf_window_request_path_path_element_request_path (PathElement* _sender, const gchar* path, gpointer self);
void dconf_window_update_path_elements (DConfWindow* self);
void bookmarks_set_path (Bookmarks* self, const gchar* path);
void path_bar_set_path (PathBar* self, const gchar* path);
void dconf_window_update_hamburger_menu (DConfWindow* self);
gboolean registry_view_get_current_delay_mode (RegistryView* self);
void registry_view_reset (RegistryView* self, gboolean recursively);
void registry_view_enter_delay_mode (RegistryView* self);
static gboolean dconf_window_on_key_press_event (DConfWindow* self, GtkWidget* widget, GdkEventKey* event);
void registry_view_discard_row_popover (RegistryView* self);
void bookmarks_set_bookmarked (Bookmarks* self, gboolean new_state);
gchar* registry_view_get_selected_row_text (RegistryView* self);
void configuration_editor_copy (ConfigurationEditor* self, const gchar* text);
void configuration_editor_about_cb (ConfigurationEditor* self);
gboolean path_bar_open_child (PathBar* self, const gchar* current_path);
gboolean registry_view_show_row_popover (RegistryView* self);
gboolean registry_view_handle_search_event (RegistryView* self, GdkEventKey* event);
static gboolean _dconf_window_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void dconf_window_on_menu_button_clicked (DConfWindow* self);
static void _dconf_window_on_menu_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
void dconf_window_show_notification (DConfWindow* self, const gchar* notification);
static void dconf_window_hide_notification (DConfWindow* self);
static void _dconf_window_hide_notification_gtk_button_clicked (GtkButton* _sender, gpointer self);
void dconf_window_set_current_path (DConfWindow* self, const gchar* value);
static void dconf_window_finalize (GObject* obj);
static void _vala_dconf_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dconf_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GActionEntry DCONF_WINDOW_action_entries[3] = {{"reset-recursive", _dconf_window_reset_recursively_gsimple_action_activate_callback}, {"reset-visible", _dconf_window_reset_gsimple_action_activate_callback}, {"enter-delay-mode", _dconf_window_enter_delay_mode_gsimple_action_activate_callback}};

GType behaviour_get_type (void) {
	static volatile gsize behaviour_type_id__volatile = 0;
	if (g_once_init_enter (&behaviour_type_id__volatile)) {
		static const GEnumValue values[] = {{BEHAVIOUR_UNSAFE, "BEHAVIOUR_UNSAFE", "unsafe"}, {BEHAVIOUR_SAFE, "BEHAVIOUR_SAFE", "safe"}, {BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT, "BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT", "always-confirm-implicit"}, {BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT, "BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT", "always-confirm-explicit"}, {BEHAVIOUR_ALWAYS_DELAY, "BEHAVIOUR_ALWAYS_DELAY", "always-delay"}, {0, NULL, NULL}};
		GType behaviour_type_id;
		behaviour_type_id = g_enum_register_static ("Behaviour", values);
		g_once_init_leave (&behaviour_type_id__volatile, behaviour_type_id);
	}
	return behaviour_type_id__volatile;
}


static void _dconf_window_reset_recursively_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 31 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_reset_recursively ((DConfWindow*) self);
#line 248 "dconf-window.c"
}


static void _dconf_window_reset_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 31 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_reset ((DConfWindow*) self);
#line 255 "dconf-window.c"
}


static void _dconf_window_enter_delay_mode_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 31 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_enter_delay_mode ((DConfWindow*) self);
#line 262 "dconf-window.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return _data1_;
#line 271 "dconf-window.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 280 "dconf-window.c"
		DConfWindow* self;
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		self = _data1_->self;
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_object_unref0 (_data1_->context);
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_object_unref0 (self);
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_slice_free (Block1Data, _data1_);
#line 290 "dconf-window.c"
	}
}


static void _registry_view_invalidate_popovers_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 64 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_invalidate_popovers ((RegistryView*) self);
#line 298 "dconf-window.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 70 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return self ? g_object_ref (self) : NULL;
#line 305 "dconf-window.c"
}


static void __lambda83_ (Block1Data* _data1_) {
	DConfWindow* self;
	gchar* theme = NULL;
	GSettings* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self = _data1_->self;
#line 72 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->settings;
#line 72 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = g_settings_get_string (_tmp0_, "theme");
#line 72 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	theme = _tmp1_;
#line 73 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = theme;
#line 73 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (g_strcmp0 (_tmp2_, "non-symbolic-keys-list") == 0) {
#line 327 "dconf-window.c"
		GtkStyleContext* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 75 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp3_ = _data1_->context;
#line 75 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp4_ = gtk_style_context_has_class (_tmp3_, "non-symbolic");
#line 75 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (!_tmp4_) {
#line 336 "dconf-window.c"
			GtkStyleContext* _tmp5_ = NULL;
#line 75 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp5_ = _data1_->context;
#line 75 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_add_class (_tmp5_, "non-symbolic");
#line 342 "dconf-window.c"
		}
	} else {
		GtkStyleContext* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
#line 77 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp6_ = _data1_->context;
#line 77 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp7_ = gtk_style_context_has_class (_tmp6_, "non-symbolic");
#line 77 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (_tmp7_) {
#line 353 "dconf-window.c"
			GtkStyleContext* _tmp8_ = NULL;
#line 77 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp8_ = _data1_->context;
#line 77 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_remove_class (_tmp8_, "non-symbolic");
#line 359 "dconf-window.c"
		}
	}
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (theme);
#line 364 "dconf-window.c"
}


static void ___lambda83__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	__lambda83_ (self);
#line 371 "dconf-window.c"
}


static void __lambda84_ (Block1Data* _data1_) {
	DConfWindow* self;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 79 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self = _data1_->self;
#line 80 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->settings;
#line 80 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "small-keys-list-rows");
#line 80 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp1_) {
#line 387 "dconf-window.c"
		GtkStyleContext* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp2_ = _data1_->context;
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp3_ = gtk_style_context_has_class (_tmp2_, "small-keys-list-rows");
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (!_tmp3_) {
#line 396 "dconf-window.c"
			GtkStyleContext* _tmp4_ = NULL;
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp4_ = _data1_->context;
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_add_class (_tmp4_, "small-keys-list-rows");
#line 402 "dconf-window.c"
		}
	} else {
		GtkStyleContext* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 84 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp5_ = _data1_->context;
#line 84 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp6_ = gtk_style_context_has_class (_tmp5_, "small-keys-list-rows");
#line 84 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (_tmp6_) {
#line 413 "dconf-window.c"
			GtkStyleContext* _tmp7_ = NULL;
#line 84 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp7_ = _data1_->context;
#line 84 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_remove_class (_tmp7_, "small-keys-list-rows");
#line 419 "dconf-window.c"
		}
	}
}


static void ___lambda84__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 79 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	__lambda84_ (self);
#line 428 "dconf-window.c"
}


static void __lambda85_ (Block1Data* _data1_) {
	DConfWindow* self;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self = _data1_->self;
#line 87 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->settings;
#line 87 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "small-bookmarks-rows");
#line 87 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp1_) {
#line 444 "dconf-window.c"
		GtkStyleContext* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 89 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp2_ = _data1_->context;
#line 89 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp3_ = gtk_style_context_has_class (_tmp2_, "small-bookmarks-rows");
#line 89 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (!_tmp3_) {
#line 453 "dconf-window.c"
			GtkStyleContext* _tmp4_ = NULL;
#line 89 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp4_ = _data1_->context;
#line 89 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_add_class (_tmp4_, "small-bookmarks-rows");
#line 459 "dconf-window.c"
		}
	} else {
		GtkStyleContext* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp5_ = _data1_->context;
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp6_ = gtk_style_context_has_class (_tmp5_, "small-bookmarks-rows");
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (_tmp6_) {
#line 470 "dconf-window.c"
			GtkStyleContext* _tmp7_ = NULL;
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp7_ = _data1_->context;
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_remove_class (_tmp7_, "small-bookmarks-rows");
#line 476 "dconf-window.c"
		}
	}
}


static void ___lambda85__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	__lambda85_ (self);
#line 485 "dconf-window.c"
}


DConfWindow* dconf_window_construct (GType object_type) {
	DConfWindow * self = NULL;
	Block1Data* _data1_;
	GSettings* _tmp0_ = NULL;
	RegistryView* _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
	GSettings* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GSettings* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GtkStyleContext* _tmp9_ = NULL;
	GtkStyleContext* _tmp10_ = NULL;
	GSettings* _tmp11_ = NULL;
	gulong _tmp12_ = 0UL;
	GSettings* _tmp13_ = NULL;
	gulong _tmp14_ = 0UL;
	GSettings* _tmp15_ = NULL;
	gulong _tmp16_ = 0UL;
	GSettings* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	GSettings* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	GSettings* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	RegistryView* _tmp28_ = NULL;
	GSettings* _tmp29_ = NULL;
	RegistryView* _tmp30_ = NULL;
	RegistryView* _tmp31_ = NULL;
	GSettings* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	GSettings* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data1_->_ref_count_ = 1;
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self = (DConfWindow*) g_object_new (object_type, NULL);
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data1_->self = g_object_ref (self);
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_action_map_add_action_entries ((GActionMap*) self, DCONF_WINDOW_action_entries, G_N_ELEMENTS (DCONF_WINDOW_action_entries), self);
#line 64 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->settings;
#line 64 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = self->priv->registry_view;
#line 64 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = g_signal_connect_object (_tmp0_, "changed::behaviour", (GCallback) _registry_view_invalidate_popovers_g_settings_changed, _tmp1_, 0);
#line 64 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->behaviour_changed_handler = _tmp2_;
#line 66 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = self->priv->settings;
#line 66 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = g_settings_get_int (_tmp3_, "window-width");
#line 66 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = self->priv->settings;
#line 66 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp6_ = g_settings_get_int (_tmp5_, "window-height");
#line 66 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_window_set_default_size ((GtkWindow*) self, _tmp4_, _tmp6_);
#line 67 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp7_ = self->priv->settings;
#line 67 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp8_ = g_settings_get_boolean (_tmp7_, "window-is-maximized");
#line 67 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp8_) {
#line 68 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		gtk_window_maximize ((GtkWindow*) self);
#line 562 "dconf-window.c"
	}
#line 70 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 70 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 70 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data1_->context = _tmp10_;
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp11_ = self->priv->settings;
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp12_ = g_signal_connect_data (_tmp11_, "changed::theme", (GCallback) ___lambda83__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->theme_changed_handler = _tmp12_;
#line 79 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp13_ = self->priv->settings;
#line 79 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp14_ = g_signal_connect_data (_tmp13_, "changed::small-keys-list-rows", (GCallback) ___lambda84__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 79 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->small_keys_list_rows_handler = _tmp14_;
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp15_ = self->priv->settings;
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp16_ = g_signal_connect_data (_tmp15_, "changed::small-bookmarks-rows", (GCallback) ___lambda85__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->small_bookmarks_rows_handler = _tmp16_;
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp17_ = self->priv->settings;
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp18_ = g_settings_get_string (_tmp17_, "theme");
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp19_ = _tmp18_;
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp20_ = g_strcmp0 (_tmp19_, "non-symbolic-keys-list") == 0;
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (_tmp19_);
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp20_) {
#line 600 "dconf-window.c"
		GtkStyleContext* _tmp21_ = NULL;
#line 94 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp21_ = _data1_->context;
#line 94 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		gtk_style_context_add_class (_tmp21_, "non-symbolic");
#line 606 "dconf-window.c"
	}
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp22_ = self->priv->settings;
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp23_ = g_settings_get_boolean (_tmp22_, "small-keys-list-rows");
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp23_) {
#line 614 "dconf-window.c"
		GtkStyleContext* _tmp24_ = NULL;
#line 96 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp24_ = _data1_->context;
#line 96 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		gtk_style_context_add_class (_tmp24_, "small-keys-list-rows");
#line 620 "dconf-window.c"
	}
#line 97 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp25_ = self->priv->settings;
#line 97 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp26_ = g_settings_get_boolean (_tmp25_, "small-bookmarks-rows");
#line 97 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp26_) {
#line 628 "dconf-window.c"
		GtkStyleContext* _tmp27_ = NULL;
#line 98 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp27_ = _data1_->context;
#line 98 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		gtk_style_context_add_class (_tmp27_, "small-bookmarks-rows");
#line 634 "dconf-window.c"
	}
#line 100 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp28_ = self->priv->registry_view;
#line 100 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_object_bind_property_with_closures ((GObject*) _tmp28_, "current-path", (GObject*) self, "current-path", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 101 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp29_ = self->priv->settings;
#line 101 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp30_ = self->priv->registry_view;
#line 101 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_settings_bind (_tmp29_, "behaviour", (GObject*) _tmp30_, "behaviour", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_NO_SENSITIVITY);
#line 102 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp31_ = self->priv->registry_view;
#line 102 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp32_ = self->priv->settings;
#line 102 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp33_ = g_settings_get_string (_tmp32_, "saved-view");
#line 102 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp34_ = _tmp33_;
#line 102 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp35_ = self->priv->settings;
#line 102 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp36_ = g_settings_get_boolean (_tmp35_, "restore-view");
#line 102 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_init (_tmp31_, _tmp34_, _tmp36_);
#line 102 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (_tmp34_);
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	block1_data_unref (_data1_);
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data1_ = NULL;
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return self;
#line 668 "dconf-window.c"
}


DConfWindow* dconf_window_new (void) {
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return dconf_window_construct (TYPE_DCONF_WINDOW);
#line 675 "dconf-window.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1328 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1329 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1329 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1329 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1330 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1330 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 708 "dconf-window.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1331 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1331 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1331 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 717 "dconf-window.c"
	}
#line 1333 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1333 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 723 "dconf-window.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1334 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1334 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1334 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 732 "dconf-window.c"
	}
#line 1336 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1336 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 738 "dconf-window.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1336 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1336 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1336 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 747 "dconf-window.c"
	} else {
#line 1336 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 751 "dconf-window.c"
	}
#line 1336 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1337 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1337 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 759 "dconf-window.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1337 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1337 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1337 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 768 "dconf-window.c"
	} else {
#line 1337 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 772 "dconf-window.c"
	}
#line 1337 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1338 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1338 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1338 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1339 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1339 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1339 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1339 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1339 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1339 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 794 "dconf-window.c"
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1017 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1018 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 1018 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 1018 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
#line 1018 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1020 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 1020 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 819 "dconf-window.c"
		gchar* _tmp4_ = NULL;
#line 1021 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 1021 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 1021 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 827 "dconf-window.c"
	} else {
#line 1023 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		result = -1;
#line 1023 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 833 "dconf-window.c"
	}
}


gchar* dconf_window_stripped_path (const gchar* path) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
#line 105 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = path;
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = strlen (_tmp0_);
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = _tmp1_;
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp2_ <= 1) {
#line 857 "dconf-window.c"
		gchar* _tmp3_ = NULL;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp3_ = g_strdup ("/");
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		result = _tmp3_;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		return result;
#line 865 "dconf-window.c"
	}
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = path;
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = path;
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp6_ = string_last_index_of_char (_tmp5_, (gunichar) '/', 0);
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp7_ = string_slice (_tmp4_, (glong) 0, (glong) (_tmp6_ + 1));
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	result = _tmp7_;
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return result;
#line 879 "dconf-window.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return _data2_;
#line 888 "dconf-window.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 897 "dconf-window.c"
		DConfWindow* self;
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		self = _data2_->self;
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_object_unref0 (_data2_->checkbutton);
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_object_unref0 (self);
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_slice_free (Block2Data, _data2_);
#line 907 "dconf-window.c"
	}
}


static void __lambda86_ (Block2Data* _data2_) {
	DConfWindow* self;
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self = _data2_->self;
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = _data2_->checkbutton;
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = _tmp1_;
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (!_tmp2_) {
#line 927 "dconf-window.c"
		GSettings* _tmp3_ = NULL;
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp3_ = self->priv->settings;
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_settings_set_boolean (_tmp3_, "show-warning", FALSE);
#line 933 "dconf-window.c"
	}
}


static void ___lambda86__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	__lambda86_ (self);
#line 941 "dconf-window.c"
}


static void dconf_window_on_show (DConfWindow* self) {
	Block2Data* _data2_;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkMessageDialog* dialog = NULL;
	const gchar* _tmp2_ = NULL;
	GtkMessageDialog* _tmp3_ = NULL;
	GtkMessageDialog* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkMessageDialog* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkBox* box = NULL;
	GtkMessageDialog* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkBox* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkCheckButton* _tmp12_ = NULL;
	GtkCheckButton* _tmp13_ = NULL;
	GtkCheckButton* _tmp14_ = NULL;
	GtkCheckButton* _tmp15_ = NULL;
	GtkBox* _tmp16_ = NULL;
	GtkCheckButton* _tmp17_ = NULL;
	gulong dialog_response_handler = 0UL;
	GtkMessageDialog* _tmp18_ = NULL;
	gulong _tmp19_ = 0UL;
	GtkMessageDialog* _tmp20_ = NULL;
	GtkMessageDialog* _tmp21_ = NULL;
	gulong _tmp22_ = 0UL;
	GtkMessageDialog* _tmp23_ = NULL;
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data2_->_ref_count_ = 1;
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data2_->self = g_object_ref (self);
#line 119 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->settings;
#line 119 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "show-warning");
#line 119 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (!_tmp1_) {
#line 120 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		block2_data_unref (_data2_);
#line 120 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_data2_ = NULL;
#line 120 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		return;
#line 994 "dconf-window.c"
	}
#line 122 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = _ ("Thanks for using Dconf Editor for editing your settings!");
#line 122 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, _tmp2_);
#line 122 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_object_ref_sink (_tmp3_);
#line 122 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dialog = _tmp3_;
#line 123 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = dialog;
#line 123 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = _ ("Don't forget that some options may break applications, so be careful.");
#line 123 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_message_dialog_format_secondary_text (_tmp4_, "%s", _tmp5_);
#line 124 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp6_ = dialog;
#line 124 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp7_ = _ ("I'll be careful.");
#line 124 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_dialog_add_buttons ((GtkDialog*) _tmp6_, _tmp7_, GTK_RESPONSE_ACCEPT, NULL);
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp8_ = dialog;
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp9_ = gtk_message_dialog_get_message_area (_tmp8_);
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_box_get_type (), GtkBox));
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	box = _tmp10_;
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp11_ = _ ("Show this dialog next time.");
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp12_ = (GtkCheckButton*) gtk_check_button_new_with_label (_tmp11_);
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_object_ref_sink (_tmp12_);
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data2_->checkbutton = _tmp12_;
#line 129 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp13_ = _data2_->checkbutton;
#line 129 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp13_, TRUE);
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp14_ = _data2_->checkbutton;
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp14_, TRUE);
#line 131 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp15_ = _data2_->checkbutton;
#line 131 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp15_, 5);
#line 132 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp16_ = box;
#line 132 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp17_ = _data2_->checkbutton;
#line 132 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp18_ = dialog;
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp19_ = g_signal_connect_data ((GtkDialog*) _tmp18_, "response", (GCallback) ___lambda86__gtk_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dialog_response_handler = _tmp19_;
#line 135 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp20_ = dialog;
#line 135 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_dialog_run ((GtkDialog*) _tmp20_);
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp21_ = dialog;
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp22_ = dialog_response_handler;
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_signal_handler_disconnect ((GObject*) _tmp21_, _tmp22_);
#line 137 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp23_ = dialog;
#line 137 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp23_);
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (box);
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (dialog);
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	block2_data_unref (_data2_);
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data2_ = NULL;
#line 1078 "dconf-window.c"
}


static void _dconf_window_on_show_gtk_widget_show (GtkWidget* _sender, gpointer self) {
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_on_show ((DConfWindow*) self);
#line 1085 "dconf-window.c"
}


static gboolean dconf_window_on_window_state_event (DConfWindow* self, GtkWidget* widget, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 143 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = event;
#line 143 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 143 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 1107 "dconf-window.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp2_ = event;
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		self->priv->window_is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1116 "dconf-window.c"
	}
#line 146 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = event;
#line 146 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = _tmp4_->changed_mask;
#line 146 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
#line 1124 "dconf-window.c"
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp6_ = event;
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp7_ = _tmp6_->new_window_state;
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		self->priv->window_is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
#line 1133 "dconf-window.c"
	}
#line 149 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	result = FALSE;
#line 149 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return result;
#line 1139 "dconf-window.c"
}


static gboolean _dconf_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = dconf_window_on_window_state_event ((DConfWindow*) self, _sender, event);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return result;
#line 1148 "dconf-window.c"
}


static void dconf_window_on_size_allocate (DConfWindow* self, GtkAllocation* allocation) {
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (allocation != NULL);
#line 157 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 157 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 157 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	context = _tmp1_;
#line 158 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = *allocation;
#line 158 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = _tmp2_.width;
#line 158 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp3_ > 1200) {
#line 1178 "dconf-window.c"
		GtkStyleContext* _tmp4_ = NULL;
		GtkStyleContext* _tmp5_ = NULL;
		GtkStyleContext* _tmp6_ = NULL;
#line 160 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp4_ = context;
#line 160 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		gtk_style_context_add_class (_tmp4_, "xxl");
#line 161 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp5_ = context;
#line 161 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		gtk_style_context_add_class (_tmp5_, "xl");
#line 162 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp6_ = context;
#line 162 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		gtk_style_context_add_class (_tmp6_, "large-window");
#line 1194 "dconf-window.c"
	} else {
		GtkAllocation _tmp7_ = {0};
		gint _tmp8_ = 0;
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp7_ = *allocation;
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp8_ = _tmp7_.width;
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (_tmp8_ > 1100) {
#line 1204 "dconf-window.c"
			GtkStyleContext* _tmp9_ = NULL;
			GtkStyleContext* _tmp10_ = NULL;
			GtkStyleContext* _tmp11_ = NULL;
#line 166 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp9_ = context;
#line 166 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_remove_class (_tmp9_, "xxl");
#line 167 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp10_ = context;
#line 167 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_add_class (_tmp10_, "xl");
#line 168 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp11_ = context;
#line 168 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_add_class (_tmp11_, "large-window");
#line 1220 "dconf-window.c"
		} else {
			GtkAllocation _tmp12_ = {0};
			gint _tmp13_ = 0;
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp12_ = *allocation;
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp13_ = _tmp12_.width;
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			if (_tmp13_ > 1000) {
#line 1230 "dconf-window.c"
				GtkStyleContext* _tmp14_ = NULL;
				GtkStyleContext* _tmp15_ = NULL;
				GtkStyleContext* _tmp16_ = NULL;
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp14_ = context;
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				gtk_style_context_remove_class (_tmp14_, "xxl");
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp15_ = context;
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				gtk_style_context_remove_class (_tmp15_, "xl");
#line 174 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp16_ = context;
#line 174 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				gtk_style_context_add_class (_tmp16_, "large-window");
#line 1246 "dconf-window.c"
			} else {
				GtkStyleContext* _tmp17_ = NULL;
				GtkStyleContext* _tmp18_ = NULL;
				GtkStyleContext* _tmp19_ = NULL;
#line 178 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp17_ = context;
#line 178 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				gtk_style_context_remove_class (_tmp17_, "xxl");
#line 179 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp18_ = context;
#line 179 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				gtk_style_context_remove_class (_tmp18_, "xl");
#line 180 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp19_ = context;
#line 180 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				gtk_style_context_remove_class (_tmp19_, "large-window");
#line 1263 "dconf-window.c"
			}
		}
	}
#line 185 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp21_ = self->priv->window_is_maximized;
#line 185 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp21_) {
#line 185 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp20_ = TRUE;
#line 1273 "dconf-window.c"
	} else {
		gboolean _tmp22_ = FALSE;
#line 185 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp22_ = self->priv->window_is_tiled;
#line 185 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp20_ = _tmp22_;
#line 1280 "dconf-window.c"
	}
#line 185 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp20_) {
#line 186 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_object_unref0 (context);
#line 186 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		return;
#line 1288 "dconf-window.c"
	}
#line 187 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_window_get_size ((GtkWindow*) self, &_tmp23_, &_tmp24_);
#line 187 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->window_width = _tmp23_;
#line 187 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->window_height = _tmp24_;
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (context);
#line 1298 "dconf-window.c"
}


static void _dconf_window_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_on_size_allocate ((DConfWindow*) self, allocation);
#line 1305 "dconf-window.c"
}


static void dconf_window_on_destroy (DConfWindow* self) {
	GtkApplication* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
	GSettings* _tmp3_ = NULL;
	gulong _tmp4_ = 0UL;
	GSettings* _tmp5_ = NULL;
	gulong _tmp6_ = 0UL;
	GSettings* _tmp7_ = NULL;
	gulong _tmp8_ = 0UL;
	GSettings* _tmp9_ = NULL;
	GSettings* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GSettings* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	GSettings* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	GSettings* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	GSettings* _tmp18_ = NULL;
#line 191 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 193 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
#line 193 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	configuration_editor_clean_copy_notification (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_CONFIGURATION_EDITOR, ConfigurationEditor));
#line 195 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = self->priv->settings;
#line 195 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = self->priv->behaviour_changed_handler;
#line 195 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_signal_handler_disconnect ((GObject*) _tmp1_, _tmp2_);
#line 196 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = self->priv->settings;
#line 196 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = self->priv->theme_changed_handler;
#line 196 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_signal_handler_disconnect ((GObject*) _tmp3_, _tmp4_);
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = self->priv->settings;
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp6_ = self->priv->small_keys_list_rows_handler;
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_signal_handler_disconnect ((GObject*) _tmp5_, _tmp6_);
#line 198 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp7_ = self->priv->settings;
#line 198 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp8_ = self->priv->small_bookmarks_rows_handler;
#line 198 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_signal_handler_disconnect ((GObject*) _tmp7_, _tmp8_);
#line 200 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp9_ = self->priv->settings;
#line 200 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_settings_delay (_tmp9_);
#line 201 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp10_ = self->priv->settings;
#line 201 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp11_ = self->priv->_current_path;
#line 201 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_settings_set_string (_tmp10_, "saved-view", _tmp11_);
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp12_ = self->priv->settings;
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp13_ = self->priv->window_width;
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_settings_set_int (_tmp12_, "window-width", _tmp13_);
#line 203 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp14_ = self->priv->settings;
#line 203 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp15_ = self->priv->window_height;
#line 203 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_settings_set_int (_tmp14_, "window-height", _tmp15_);
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp16_ = self->priv->settings;
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp17_ = self->priv->window_is_maximized;
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_settings_set_boolean (_tmp16_, "window-is-maximized", _tmp17_);
#line 205 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp18_ = self->priv->settings;
#line 205 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_settings_apply (_tmp18_);
#line 207 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	GTK_WIDGET_CLASS (dconf_window_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow));
#line 1393 "dconf-window.c"
}


static void _dconf_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_on_destroy ((DConfWindow*) self);
#line 1400 "dconf-window.c"
}


static void dconf_window_request_path (DConfWindow* self, const gchar* full_name) {
	RegistryView* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	RegistryView* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	PathBar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 215 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 215 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (full_name != NULL);
#line 217 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->registry_view;
#line 217 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = FALSE;
#line 217 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_set_search_mode (_tmp0_, &_tmp1_);
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = self->priv->registry_view;
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = full_name;
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = self->priv->pathbar;
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = full_name;
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp6_ = path_bar_get_selected_child (_tmp4_, _tmp5_);
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp7_ = _tmp6_;
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_path_requested (_tmp2_, _tmp3_, _tmp7_);
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (_tmp7_);
#line 1439 "dconf-window.c"
}


static void _dconf_window_request_path_path_element_request_path (PathElement* _sender, const gchar* path, gpointer self) {
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_request_path ((DConfWindow*) self, path);
#line 1446 "dconf-window.c"
}


void dconf_window_update_path_elements (DConfWindow* self) {
	Bookmarks* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	PathBar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 221 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 223 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->bookmarks_button;
#line 223 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = self->priv->_current_path;
#line 223 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	bookmarks_set_path (_tmp0_, _tmp1_);
#line 224 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = self->priv->pathbar;
#line 224 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = self->priv->_current_path;
#line 224 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	path_bar_set_path (_tmp2_, _tmp3_);
#line 1469 "dconf-window.c"
}


void dconf_window_update_hamburger_menu (DConfWindow* self) {
	GMenu* section = NULL;
	GMenu* menu = NULL;
	GMenu* _tmp0_ = NULL;
	GMenu* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	RegistryView* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	GMenu* _tmp28_ = NULL;
	GtkMenuButton* _tmp29_ = NULL;
	GMenu* _tmp30_ = NULL;
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = g_menu_new ();
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	menu = _tmp0_;
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = menu;
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = _ ("Copy current path");
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = self->priv->_current_path;
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = g_strescape (_tmp3_, "");
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = _tmp4_;
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp6_ = g_strconcat ("app.copy(\"", _tmp5_, NULL);
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp7_ = _tmp6_;
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp8_ = g_strconcat (_tmp7_, "\")", NULL);
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp9_ = _tmp8_;
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_menu_append (_tmp1_, _tmp2_, _tmp9_);
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (_tmp9_);
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (_tmp7_);
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (_tmp5_);
#line 234 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp10_ = self->priv->_current_path;
#line 234 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp11_ = g_str_has_suffix (_tmp10_, "/");
#line 234 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp11_) {
#line 1531 "dconf-window.c"
		GMenu* _tmp12_ = NULL;
		GMenu* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GMenu* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		GMenu* _tmp17_ = NULL;
		GMenu* _tmp18_ = NULL;
		GMenu* _tmp19_ = NULL;
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp12_ = g_menu_new ();
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_object_unref0 (section);
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		section = _tmp12_;
#line 237 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp13_ = section;
#line 237 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp14_ = _ ("Reset visible keys");
#line 237 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_menu_append (_tmp13_, _tmp14_, "win.reset-visible");
#line 238 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp15_ = section;
#line 238 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp16_ = _ ("Reset recursively");
#line 238 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_menu_append (_tmp15_, _tmp16_, "win.reset-recursive");
#line 239 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp17_ = section;
#line 239 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_menu_freeze (_tmp17_);
#line 240 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp18_ = menu;
#line 240 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp19_ = section;
#line 240 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_menu_append_section (_tmp18_, NULL, (GMenuModel*) _tmp19_);
#line 1568 "dconf-window.c"
	}
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp20_ = self->priv->registry_view;
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp21_ = registry_view_get_current_delay_mode (_tmp20_);
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (!_tmp21_) {
#line 1576 "dconf-window.c"
		GMenu* _tmp22_ = NULL;
		GMenu* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		GMenu* _tmp25_ = NULL;
		GMenu* _tmp26_ = NULL;
		GMenu* _tmp27_ = NULL;
#line 245 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp22_ = g_menu_new ();
#line 245 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_object_unref0 (section);
#line 245 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		section = _tmp22_;
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp23_ = section;
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp24_ = _ ("Enter delay mode");
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_menu_append (_tmp23_, _tmp24_, "win.enter-delay-mode");
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp25_ = section;
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_menu_freeze (_tmp25_);
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp26_ = menu;
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp27_ = section;
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_menu_append_section (_tmp26_, NULL, (GMenuModel*) _tmp27_);
#line 1605 "dconf-window.c"
	}
#line 251 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp28_ = menu;
#line 251 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_menu_freeze (_tmp28_);
#line 252 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp29_ = self->priv->info_button;
#line 252 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp30_ = menu;
#line 252 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_menu_button_set_menu_model (_tmp29_, G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, g_menu_model_get_type (), GMenuModel));
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (menu);
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (section);
#line 1621 "dconf-window.c"
}


static void dconf_window_reset (DConfWindow* self) {
	RegistryView* _tmp0_ = NULL;
#line 259 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 261 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->registry_view;
#line 261 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_reset (_tmp0_, FALSE);
#line 1633 "dconf-window.c"
}


static void dconf_window_reset_recursively (DConfWindow* self) {
	RegistryView* _tmp0_ = NULL;
#line 264 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->registry_view;
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_reset (_tmp0_, TRUE);
#line 1645 "dconf-window.c"
}


static void dconf_window_enter_delay_mode (DConfWindow* self) {
	RegistryView* _tmp0_ = NULL;
#line 269 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 271 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->registry_view;
#line 271 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_enter_delay_mode (_tmp0_);
#line 1657 "dconf-window.c"
}


static gboolean dconf_window_on_key_press_event (DConfWindow* self, GtkWidget* widget, GdkEventKey* event) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	const gchar* _tmp3_ = NULL;
	gchar* name = NULL;
	gchar* _tmp4_ = NULL;
	GdkEventKey* _tmp5_ = NULL;
	GdkModifierType _tmp6_ = 0;
	GdkEventKey* _tmp56_ = NULL;
	GdkModifierType _tmp57_ = 0;
	const gchar* _tmp86_ = NULL;
	gboolean _tmp112_ = FALSE;
	Bookmarks* _tmp113_ = NULL;
	gboolean _tmp114_ = FALSE;
	gboolean _tmp115_ = FALSE;
	RegistryView* _tmp119_ = NULL;
	GdkEventKey* _tmp120_ = NULL;
	gboolean _tmp121_ = FALSE;
#line 279 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 279 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 279 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 281 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = event;
#line 281 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = _tmp1_->keyval;
#line 281 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = gdk_keyval_name (_tmp2_);
#line 281 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = _tmp3_;
#line 281 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp0_ == NULL) {
#line 281 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp0_ = "";
#line 1699 "dconf-window.c"
	}
#line 281 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = g_strdup (_tmp0_);
#line 281 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	name = _tmp4_;
#line 283 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = event;
#line 283 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp6_ = _tmp5_->state;
#line 283 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if ((_tmp6_ & GDK_CONTROL_MASK) != 0) {
#line 1711 "dconf-window.c"
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GQuark _tmp10_ = 0U;
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		static GQuark _tmp9_label0 = 0;
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		static GQuark _tmp9_label1 = 0;
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		static GQuark _tmp9_label2 = 0;
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		static GQuark _tmp9_label3 = 0;
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		static GQuark _tmp9_label4 = 0;
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		static GQuark _tmp9_label5 = 0;
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		static GQuark _tmp9_label6 = 0;
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp7_ = name;
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp8_ = _tmp7_;
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string ("b")))) {
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 1739 "dconf-window.c"
				default:
				{
					GtkMenuButton* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					gboolean _tmp13_ = FALSE;
					RegistryView* _tmp15_ = NULL;
					Bookmarks* _tmp16_ = NULL;
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp11_ = self->priv->info_button;
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp12_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp11_);
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp13_ = _tmp12_;
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if (_tmp13_) {
#line 1755 "dconf-window.c"
						GtkMenuButton* _tmp14_ = NULL;
#line 289 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp14_ = self->priv->info_button;
#line 289 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp14_, FALSE);
#line 1761 "dconf-window.c"
					}
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp15_ = self->priv->registry_view;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_discard_row_popover (_tmp15_);
#line 291 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp16_ = self->priv->bookmarks_button;
#line 291 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					gtk_button_clicked ((GtkButton*) _tmp16_);
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = TRUE;
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 1777 "dconf-window.c"
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string ("d")))) {
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 1783 "dconf-window.c"
				default:
				{
					GtkMenuButton* _tmp17_ = NULL;
					gboolean _tmp18_ = FALSE;
					gboolean _tmp19_ = FALSE;
					RegistryView* _tmp21_ = NULL;
					Bookmarks* _tmp22_ = NULL;
#line 294 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp17_ = self->priv->info_button;
#line 294 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp18_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp17_);
#line 294 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp19_ = _tmp18_;
#line 294 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if (_tmp19_) {
#line 1799 "dconf-window.c"
						GtkMenuButton* _tmp20_ = NULL;
#line 295 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp20_ = self->priv->info_button;
#line 295 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp20_, FALSE);
#line 1805 "dconf-window.c"
					}
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp21_ = self->priv->registry_view;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_discard_row_popover (_tmp21_);
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp22_ = self->priv->bookmarks_button;
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					bookmarks_set_bookmarked (_tmp22_, TRUE);
#line 298 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = TRUE;
#line 298 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 298 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 1821 "dconf-window.c"
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label2) ? _tmp9_label2 : (_tmp9_label2 = g_quark_from_static_string ("D")))) {
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 1827 "dconf-window.c"
				default:
				{
					GtkMenuButton* _tmp23_ = NULL;
					gboolean _tmp24_ = FALSE;
					gboolean _tmp25_ = FALSE;
					RegistryView* _tmp27_ = NULL;
					Bookmarks* _tmp28_ = NULL;
#line 300 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp23_ = self->priv->info_button;
#line 300 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp24_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp23_);
#line 300 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp25_ = _tmp24_;
#line 300 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if (_tmp25_) {
#line 1843 "dconf-window.c"
						GtkMenuButton* _tmp26_ = NULL;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp26_ = self->priv->info_button;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp26_, FALSE);
#line 1849 "dconf-window.c"
					}
#line 302 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp27_ = self->priv->registry_view;
#line 302 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_discard_row_popover (_tmp27_);
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp28_ = self->priv->bookmarks_button;
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					bookmarks_set_bookmarked (_tmp28_, FALSE);
#line 304 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = TRUE;
#line 304 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 304 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 1865 "dconf-window.c"
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label3) ? _tmp9_label3 : (_tmp9_label3 = g_quark_from_static_string ("f")))) {
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 1871 "dconf-window.c"
				default:
				{
					Bookmarks* _tmp29_ = NULL;
					gboolean _tmp30_ = FALSE;
					gboolean _tmp31_ = FALSE;
					GtkMenuButton* _tmp33_ = NULL;
					gboolean _tmp34_ = FALSE;
					gboolean _tmp35_ = FALSE;
					RegistryView* _tmp37_ = NULL;
					RegistryView* _tmp38_ = NULL;
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp29_ = self->priv->bookmarks_button;
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp30_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp29_);
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp31_ = _tmp30_;
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if (_tmp31_) {
#line 1890 "dconf-window.c"
						Bookmarks* _tmp32_ = NULL;
#line 307 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp32_ = self->priv->bookmarks_button;
#line 307 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp32_, FALSE);
#line 1896 "dconf-window.c"
					}
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp33_ = self->priv->info_button;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp34_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp33_);
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp35_ = _tmp34_;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if (_tmp35_) {
#line 1906 "dconf-window.c"
						GtkMenuButton* _tmp36_ = NULL;
#line 309 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp36_ = self->priv->info_button;
#line 309 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp36_, FALSE);
#line 1912 "dconf-window.c"
					}
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp37_ = self->priv->registry_view;
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_discard_row_popover (_tmp37_);
#line 311 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp38_ = self->priv->registry_view;
#line 311 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_set_search_mode (_tmp38_, NULL);
#line 312 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = TRUE;
#line 312 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 312 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 1928 "dconf-window.c"
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label4) ? _tmp9_label4 : (_tmp9_label4 = g_quark_from_static_string ("c")))) {
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 1934 "dconf-window.c"
				default:
				{
					RegistryView* _tmp39_ = NULL;
					gchar* selected_row_text = NULL;
					RegistryView* _tmp40_ = NULL;
					gchar* _tmp41_ = NULL;
					ConfigurationEditor* application = NULL;
					GtkApplication* _tmp42_ = NULL;
					ConfigurationEditor* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					const gchar* _tmp45_ = NULL;
					ConfigurationEditor* _tmp48_ = NULL;
#line 314 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp39_ = self->priv->registry_view;
#line 314 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_discard_row_popover (_tmp39_);
#line 315 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp40_ = self->priv->registry_view;
#line 315 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp41_ = registry_view_get_selected_row_text (_tmp40_);
#line 315 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					selected_row_text = _tmp41_;
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp42_ = gtk_window_get_application ((GtkWindow*) self);
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp43_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, TYPE_CONFIGURATION_EDITOR, ConfigurationEditor));
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					application = _tmp43_;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp45_ = selected_row_text;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if (_tmp45_ == NULL) {
#line 1967 "dconf-window.c"
						const gchar* _tmp46_ = NULL;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp46_ = self->priv->_current_path;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp44_ = _tmp46_;
#line 1973 "dconf-window.c"
					} else {
						const gchar* _tmp47_ = NULL;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp47_ = selected_row_text;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp44_ = (const gchar*) _tmp47_;
#line 1980 "dconf-window.c"
					}
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp48_ = application;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					configuration_editor_copy (_tmp48_, _tmp44_);
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = TRUE;
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_object_unref0 (application);
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (selected_row_text);
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 1996 "dconf-window.c"
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label5) ? _tmp9_label5 : (_tmp9_label5 = g_quark_from_static_string ("C")))) {
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 2002 "dconf-window.c"
				default:
				{
					RegistryView* _tmp49_ = NULL;
					GtkApplication* _tmp50_ = NULL;
					const gchar* _tmp51_ = NULL;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp49_ = self->priv->registry_view;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_discard_row_popover (_tmp49_);
#line 321 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp50_ = gtk_window_get_application ((GtkWindow*) self);
#line 321 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp51_ = self->priv->_current_path;
#line 321 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					configuration_editor_copy (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, TYPE_CONFIGURATION_EDITOR, ConfigurationEditor), _tmp51_);
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = TRUE;
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 2024 "dconf-window.c"
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label6) ? _tmp9_label6 : (_tmp9_label6 = g_quark_from_static_string ("F1")))) {
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 2030 "dconf-window.c"
				default:
				{
					RegistryView* _tmp52_ = NULL;
					GdkEventKey* _tmp53_ = NULL;
					GdkModifierType _tmp54_ = 0;
					GtkApplication* _tmp55_ = NULL;
#line 324 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp52_ = self->priv->registry_view;
#line 324 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_discard_row_popover (_tmp52_);
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp53_ = event;
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp54_ = _tmp53_->state;
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if ((_tmp54_ & GDK_SHIFT_MASK) == 0) {
#line 326 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						result = FALSE;
#line 326 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_g_free0 (name);
#line 326 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						return result;
#line 2053 "dconf-window.c"
					}
#line 327 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp55_ = gtk_window_get_application ((GtkWindow*) self);
#line 327 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					configuration_editor_about_cb (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, TYPE_CONFIGURATION_EDITOR, ConfigurationEditor));
#line 328 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = TRUE;
#line 328 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 328 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 2065 "dconf-window.c"
				}
			}
		} else {
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 2071 "dconf-window.c"
				default:
				{
#line 330 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					break;
#line 2076 "dconf-window.c"
				}
			}
		}
	}
#line 334 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp56_ = event;
#line 334 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp57_ = _tmp56_->state;
#line 334 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if ((_tmp57_ & GDK_MOD1_MASK) != 0) {
#line 2087 "dconf-window.c"
		const gchar* _tmp58_ = NULL;
#line 336 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp58_ = name;
#line 336 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (g_strcmp0 (_tmp58_, "Up") == 0) {
#line 2093 "dconf-window.c"
			const gchar* _tmp59_ = NULL;
			GdkEventKey* _tmp60_ = NULL;
			GdkModifierType _tmp61_ = 0;
#line 338 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp59_ = self->priv->_current_path;
#line 338 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			if (g_strcmp0 (_tmp59_, "/") == 0) {
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				result = TRUE;
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_g_free0 (name);
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				return result;
#line 2107 "dconf-window.c"
			}
#line 340 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp60_ = event;
#line 340 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp61_ = _tmp60_->state;
#line 340 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			if ((_tmp61_ & GDK_SHIFT_MASK) != 0) {
#line 341 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				dconf_window_request_path (self, "/");
#line 2117 "dconf-window.c"
			} else {
				const gchar* _tmp62_ = NULL;
				gboolean _tmp63_ = FALSE;
#line 342 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp62_ = self->priv->_current_path;
#line 342 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp63_ = g_str_has_suffix (_tmp62_, "/");
#line 342 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				if (_tmp63_) {
#line 2127 "dconf-window.c"
					const gchar* _tmp64_ = NULL;
					const gchar* _tmp65_ = NULL;
					const gchar* _tmp66_ = NULL;
					gint _tmp67_ = 0;
					gint _tmp68_ = 0;
					gchar* _tmp69_ = NULL;
					gchar* _tmp70_ = NULL;
					gint _tmp71_ = 0;
					gchar* _tmp72_ = NULL;
					gchar* _tmp73_ = NULL;
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp64_ = self->priv->_current_path;
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp65_ = self->priv->_current_path;
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp66_ = self->priv->_current_path;
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp67_ = strlen (_tmp66_);
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp68_ = _tmp67_;
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp69_ = string_slice (_tmp65_, (glong) 0, (glong) (_tmp68_ - 1));
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp70_ = _tmp69_;
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp71_ = string_last_index_of_char (_tmp70_, (gunichar) '/', 0);
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp72_ = string_slice (_tmp64_, (glong) 0, (glong) (_tmp71_ + 1));
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp73_ = _tmp72_;
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					dconf_window_request_path (self, _tmp73_);
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (_tmp73_);
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (_tmp70_);
#line 2164 "dconf-window.c"
				} else {
					const gchar* _tmp74_ = NULL;
					const gchar* _tmp75_ = NULL;
					gint _tmp76_ = 0;
					gchar* _tmp77_ = NULL;
					gchar* _tmp78_ = NULL;
#line 345 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp74_ = self->priv->_current_path;
#line 345 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp75_ = self->priv->_current_path;
#line 345 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp76_ = string_last_index_of_char (_tmp75_, (gunichar) '/', 0);
#line 345 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp77_ = string_slice (_tmp74_, (glong) 0, (glong) (_tmp76_ + 1));
#line 345 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp78_ = _tmp77_;
#line 345 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					dconf_window_request_path (self, _tmp78_);
#line 345 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (_tmp78_);
#line 2185 "dconf-window.c"
				}
			}
#line 346 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			result = TRUE;
#line 346 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_g_free0 (name);
#line 346 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			return result;
#line 2194 "dconf-window.c"
		} else {
			const gchar* _tmp79_ = NULL;
#line 348 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp79_ = name;
#line 348 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			if (g_strcmp0 (_tmp79_, "Down") == 0) {
#line 2201 "dconf-window.c"
				const gchar* _tmp80_ = NULL;
				GdkEventKey* _tmp81_ = NULL;
				GdkModifierType _tmp82_ = 0;
				PathBar* _tmp84_ = NULL;
				gboolean _tmp85_ = FALSE;
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp81_ = event;
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp82_ = _tmp81_->state;
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				if ((_tmp82_ & GDK_SHIFT_MASK) != 0) {
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp80_ = NULL;
#line 2215 "dconf-window.c"
				} else {
					const gchar* _tmp83_ = NULL;
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp83_ = self->priv->_current_path;
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp80_ = _tmp83_;
#line 2222 "dconf-window.c"
				}
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp84_ = self->priv->pathbar;
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp85_ = path_bar_open_child (_tmp84_, _tmp80_);
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				result = _tmp85_;
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_g_free0 (name);
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				return result;
#line 2234 "dconf-window.c"
			}
		}
	}
#line 353 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp86_ = name;
#line 353 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (g_strcmp0 (_tmp86_, "F10") == 0) {
#line 2242 "dconf-window.c"
		RegistryView* _tmp87_ = NULL;
		Bookmarks* _tmp88_ = NULL;
		gboolean _tmp89_ = FALSE;
		gboolean _tmp90_ = FALSE;
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp87_ = self->priv->registry_view;
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		registry_view_discard_row_popover (_tmp87_);
#line 356 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp88_ = self->priv->bookmarks_button;
#line 356 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp89_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp88_);
#line 356 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp90_ = _tmp89_;
#line 356 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (_tmp90_) {
#line 2259 "dconf-window.c"
			Bookmarks* _tmp91_ = NULL;
#line 357 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp91_ = self->priv->bookmarks_button;
#line 357 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp91_, FALSE);
#line 2265 "dconf-window.c"
		}
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		result = FALSE;
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_free0 (name);
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		return result;
#line 2273 "dconf-window.c"
	} else {
		const gchar* _tmp92_ = NULL;
#line 360 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp92_ = name;
#line 360 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (g_strcmp0 (_tmp92_, "Menu") == 0) {
#line 2280 "dconf-window.c"
			RegistryView* _tmp93_ = NULL;
			gboolean _tmp94_ = FALSE;
#line 362 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp93_ = self->priv->registry_view;
#line 362 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp94_ = registry_view_show_row_popover (_tmp93_);
#line 362 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			if (_tmp94_) {
#line 2289 "dconf-window.c"
				Bookmarks* _tmp95_ = NULL;
				gboolean _tmp96_ = FALSE;
				gboolean _tmp97_ = FALSE;
				GtkMenuButton* _tmp99_ = NULL;
				gboolean _tmp100_ = FALSE;
				gboolean _tmp101_ = FALSE;
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp95_ = self->priv->bookmarks_button;
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp96_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp95_);
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp97_ = _tmp96_;
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				if (_tmp97_) {
#line 2304 "dconf-window.c"
					Bookmarks* _tmp98_ = NULL;
#line 365 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp98_ = self->priv->bookmarks_button;
#line 365 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp98_, FALSE);
#line 2310 "dconf-window.c"
				}
#line 366 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp99_ = self->priv->info_button;
#line 366 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp100_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp99_);
#line 366 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp101_ = _tmp100_;
#line 366 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				if (_tmp101_) {
#line 2320 "dconf-window.c"
					GtkMenuButton* _tmp102_ = NULL;
#line 367 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp102_ = self->priv->info_button;
#line 367 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp102_, FALSE);
#line 2326 "dconf-window.c"
				}
			} else {
				GtkMenuButton* _tmp103_ = NULL;
				gboolean _tmp104_ = FALSE;
				gboolean _tmp105_ = FALSE;
#line 369 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp103_ = self->priv->info_button;
#line 369 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp104_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp103_);
#line 369 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp105_ = _tmp104_;
#line 369 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				if (_tmp105_ == FALSE) {
#line 2340 "dconf-window.c"
					Bookmarks* _tmp106_ = NULL;
					gboolean _tmp107_ = FALSE;
					gboolean _tmp108_ = FALSE;
					GtkMenuButton* _tmp110_ = NULL;
#line 371 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp106_ = self->priv->bookmarks_button;
#line 371 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp107_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp106_);
#line 371 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp108_ = _tmp107_;
#line 371 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if (_tmp108_) {
#line 2353 "dconf-window.c"
						Bookmarks* _tmp109_ = NULL;
#line 372 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp109_ = self->priv->bookmarks_button;
#line 372 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp109_, FALSE);
#line 2359 "dconf-window.c"
					}
#line 373 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp110_ = self->priv->info_button;
#line 373 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp110_, TRUE);
#line 2365 "dconf-window.c"
				} else {
					GtkMenuButton* _tmp111_ = NULL;
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp111_ = self->priv->info_button;
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp111_, FALSE);
#line 2372 "dconf-window.c"
				}
			}
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			result = TRUE;
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_g_free0 (name);
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			return result;
#line 2381 "dconf-window.c"
		}
	}
#line 380 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp113_ = self->priv->bookmarks_button;
#line 380 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp114_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp113_);
#line 380 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp115_ = _tmp114_;
#line 380 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp115_) {
#line 380 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp112_ = TRUE;
#line 2394 "dconf-window.c"
	} else {
		GtkMenuButton* _tmp116_ = NULL;
		gboolean _tmp117_ = FALSE;
		gboolean _tmp118_ = FALSE;
#line 380 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp116_ = self->priv->info_button;
#line 380 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp117_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp116_);
#line 380 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp118_ = _tmp117_;
#line 380 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp112_ = _tmp118_;
#line 2407 "dconf-window.c"
	}
#line 380 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp112_) {
#line 381 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		result = FALSE;
#line 381 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_free0 (name);
#line 381 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		return result;
#line 2417 "dconf-window.c"
	}
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp119_ = self->priv->registry_view;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp120_ = event;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp121_ = registry_view_handle_search_event (_tmp119_, _tmp120_);
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	result = _tmp121_;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (name);
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return result;
#line 2431 "dconf-window.c"
}


static gboolean _dconf_window_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = dconf_window_on_key_press_event ((DConfWindow*) self, _sender, event);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return result;
#line 2440 "dconf-window.c"
}


static void dconf_window_on_menu_button_clicked (DConfWindow* self) {
	RegistryView* _tmp0_ = NULL;
	RegistryView* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 387 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 389 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->registry_view;
#line 389 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_discard_row_popover (_tmp0_);
#line 390 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = self->priv->registry_view;
#line 390 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = FALSE;
#line 390 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_set_search_mode (_tmp1_, &_tmp2_);
#line 2460 "dconf-window.c"
}


static void _dconf_window_on_menu_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_on_menu_button_clicked ((DConfWindow*) self);
#line 2467 "dconf-window.c"
}


void dconf_window_show_notification (DConfWindow* self, const gchar* notification) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkRevealer* _tmp2_ = NULL;
#line 397 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 397 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (notification != NULL);
#line 399 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->notification_label;
#line 399 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = notification;
#line 399 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_label_set_text (_tmp0_, _tmp1_);
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = self->priv->notification_revealer;
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_revealer_set_reveal_child (_tmp2_, TRUE);
#line 2489 "dconf-window.c"
}


static void dconf_window_hide_notification (DConfWindow* self) {
	GtkRevealer* _tmp0_ = NULL;
#line 404 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 406 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->notification_revealer;
#line 406 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
#line 2501 "dconf-window.c"
}


static void _dconf_window_hide_notification_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_hide_notification ((DConfWindow*) self);
#line 2508 "dconf-window.c"
}


static const gchar* dconf_window_get_current_path (DConfWindow* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->_current_path;
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	result = _tmp0_;
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return result;
#line 2523 "dconf-window.c"
}


void dconf_window_set_current_path (DConfWindow* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = value;
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (self->priv->_current_path);
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->_current_path = _tmp1_;
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_object_notify ((GObject *) self, "current-path");
#line 2542 "dconf-window.c"
}


static void dconf_window_class_init (DConfWindowClass * klass) {
	gint DConfWindow_private_offset;
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_parent_class = g_type_class_peek_parent (klass);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_type_class_add_private (klass, sizeof (DConfWindowPrivate));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_dconf_window_get_property;
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_dconf_window_set_property;
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	G_OBJECT_CLASS (klass)->finalize = dconf_window_finalize;
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DCONF_WINDOW_CURRENT_PATH, g_param_spec_string ("current-path", "current-path", "current-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	DConfWindow_private_offset = g_type_class_get_instance_private_offset (klass);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/dconf-editor.ui");
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bookmarks_button", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, bookmarks_button));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "info_button", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, info_button));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pathbar", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, pathbar));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "registry_view", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, registry_view));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "notification_revealer", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, notification_revealer));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "notification_label", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, notification_label));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_show", G_CALLBACK(_dconf_window_on_show_gtk_widget_show));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_window_state_event", G_CALLBACK(_dconf_window_on_window_state_event_gtk_widget_window_state_event));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_size_allocate", G_CALLBACK(_dconf_window_on_size_allocate_gtk_widget_size_allocate));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_destroy", G_CALLBACK(_dconf_window_on_destroy_gtk_widget_destroy));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "request_path", G_CALLBACK(_dconf_window_request_path_path_element_request_path));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_key_press_event", G_CALLBACK(_dconf_window_on_key_press_event_gtk_widget_key_press_event));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_menu_button_clicked", G_CALLBACK(_dconf_window_on_menu_button_clicked_gtk_button_clicked));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "hide_notification", G_CALLBACK(_dconf_window_hide_notification_gtk_button_clicked));
#line 2592 "dconf-window.c"
}


static void dconf_window_instance_init (DConfWindow * self) {
	gchar* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv = DCONF_WINDOW_GET_PRIVATE (self);
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = g_strdup ("/");
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->_current_path = _tmp0_;
#line 40 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->window_width = 0;
#line 41 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->window_height = 0;
#line 42 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->window_is_maximized = FALSE;
#line 43 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->window_is_tiled = FALSE;
#line 45 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = g_settings_new ("ca.desrt.dconf-editor.Settings");
#line 45 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->settings = _tmp1_;
#line 55 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->behaviour_changed_handler = (gulong) 0;
#line 56 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->theme_changed_handler = (gulong) 0;
#line 57 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->small_keys_list_rows_handler = (gulong) 0;
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->small_bookmarks_rows_handler = (gulong) 0;
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_type_ensure (TYPE_BOOKMARKS);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_type_ensure (TYPE_PATH_BAR);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_type_ensure (TYPE_REGISTRY_VIEW);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 2633 "dconf-window.c"
}


static void dconf_window_finalize (GObject* obj) {
	DConfWindow * self;
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DCONF_WINDOW, DConfWindow);
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (self->priv->_current_path);
#line 45 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (self->priv->settings);
#line 47 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (self->priv->bookmarks_button);
#line 48 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (self->priv->info_button);
#line 49 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (self->priv->pathbar);
#line 50 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (self->priv->registry_view);
#line 52 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (self->priv->notification_revealer);
#line 53 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (self->priv->notification_label);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	G_OBJECT_CLASS (dconf_window_parent_class)->finalize (obj);
#line 2659 "dconf-window.c"
}


GType dconf_window_get_type (void) {
	static volatile gsize dconf_window_type_id__volatile = 0;
	if (g_once_init_enter (&dconf_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DConfWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dconf_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DConfWindow), 0, (GInstanceInitFunc) dconf_window_instance_init, NULL };
		GType dconf_window_type_id;
		dconf_window_type_id = g_type_register_static (gtk_application_window_get_type (), "DConfWindow", &g_define_type_info, 0);
		g_once_init_leave (&dconf_window_type_id__volatile, dconf_window_type_id);
	}
	return dconf_window_type_id__volatile;
}


static void _vala_dconf_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DConfWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DCONF_WINDOW, DConfWindow);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	switch (property_id) {
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		case DCONF_WINDOW_CURRENT_PATH:
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_value_set_string (value, dconf_window_get_current_path (self));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		break;
#line 2686 "dconf-window.c"
		default:
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		break;
#line 2692 "dconf-window.c"
	}
}


static void _vala_dconf_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DConfWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DCONF_WINDOW, DConfWindow);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	switch (property_id) {
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		case DCONF_WINDOW_CURRENT_PATH:
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		dconf_window_set_current_path (self, g_value_get_string (value));
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		break;
#line 2708 "dconf-window.c"
		default:
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		break;
#line 2714 "dconf-window.c"
	}
}


static void path_element_base_init (PathElementIface * iface) {
#line 410 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	static gboolean initialized = FALSE;
#line 410 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (!initialized) {
#line 410 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		initialized = TRUE;
#line 410 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_signal_new ("request_path", TYPE_PATH_ELEMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 2728 "dconf-window.c"
	}
}


GType path_element_get_type (void) {
	static volatile gsize path_element_type_id__volatile = 0;
	if (g_once_init_enter (&path_element_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PathElementIface), (GBaseInitFunc) path_element_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType path_element_type_id;
		path_element_type_id = g_type_register_static (G_TYPE_INTERFACE, "PathElement", &g_define_type_info, 0);
		g_once_init_leave (&path_element_type_id__volatile, path_element_type_id);
	}
	return path_element_type_id__volatile;
}



