/* ease-html-exporter.c generated by valac, the Vala compiler
 * generated from ease-html-exporter.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>


#define EASE_TYPE_HTML_EXPORTER (ease_html_exporter_get_type ())
#define EASE_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporter))
#define EASE_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))
#define EASE_IS_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_HTML_EXPORTER))
#define EASE_IS_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_HTML_EXPORTER))
#define EASE_HTML_EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))

typedef struct _EaseHTMLExporter EaseHTMLExporter;
typedef struct _EaseHTMLExporterClass EaseHTMLExporterClass;
typedef struct _EaseHTMLExporterPrivate EaseHTMLExporterPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _EaseHTMLExporter {
	GObject parent_instance;
	EaseHTMLExporterPrivate * priv;
};

struct _EaseHTMLExporterClass {
	GObjectClass parent_class;
};

struct _EaseHTMLExporterPrivate {
	GtkDialog* window;
	GtkProgressBar* progress;
	char* _path;
};


static gpointer ease_html_exporter_parent_class = NULL;

GType ease_html_exporter_get_type (void) G_GNUC_CONST;
#define EASE_HTML_EXPORTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterPrivate))
enum  {
	EASE_HTML_EXPORTER_DUMMY_PROPERTY,
	EASE_HTML_EXPORTER_PATH,
	EASE_HTML_EXPORTER_BASENAME
};
#define EASE_HTML_EXPORTER_HEADER "<!DOCTYPE html>\n" \
"<html>\n" \
"<head>\n" \
"\t<title>Presentation</title>\n" \
"\t\n" \
"\t<script type=\"text/javascript\">\n" \
"\t\tvar slide = -1;\n" \
"\n" \
"\t\tfunction load() {\n" \
"\t\t\tadvance();\n" \
"\t\t}\n" \
"\n" \
"\t\tfunction keydown(e) {\n" \
"\t\t\tvar code = e.keyCode;\n" \
"\t\t\tif (code == 32 || code == 39 || code == 13 || code == 40 || code" \
" == 39) {\n" \
"\t\t\t\tadvance();\n" \
"\t\t\t}\n" \
"\t\n" \
"\t\t\telse if (code == 8 || code == 46 || code == 37 || code == 38) {\n" \
"\t\t\t\tretreat();\n" \
"\t\t\t}\n" \
"\t\t}\n" \
"\n" \
"\t\tfunction advance() {\n" \
"\t\t\tif (document.getElementById(\"slide\" + (slide + 1)) != null) {\n" \
"\t\t\t\tif (slide >= 0) {\n" \
"\t\t\t\t\tdocument.getElementById(\"slide\" + slide).style.display = \"" \
"none\";\n" \
"\t\t\t\t}\n" \
"\t\t\t\tslide++;\n" \
"\t\t\t\tdocument.getElementById(\"slide\" + slide).style.display = \"b" \
"lock\";\n" \
"\t\t\t}\n" \
"\t\t}\n" \
"\n" \
"\t\tfunction retreat() {\n" \
"\t\t\tif (slide > 0) {\n" \
"\t\t\t\tdocument.getElementById(\"slide\" + slide).style.display = \"n" \
"one\";\n" \
"\t\t\t\tslide--;\n" \
"\t\t\t\tdocument.getElementById(\"slide\" + slide).style.display = \"b" \
"lock\";\n" \
"\t\t\t}\n" \
"\t\t}\n" \
"\n" \
"\t\tdocument.onkeydown = keydown;\n" \
"\t</script>\n" \
"\t\n" \
"\t<style>\n" \
"\t\t.slide {\n" \
"\t\t\twidth: %ipx;\n" \
"\t\t\theight: %ipx;\n" \
"\t\t\tdisplay: none;\n" \
"\t\t\toverflow: hidden;\n" \
"\t\t\tposition: relative;\n" \
"\t\t\tmargin: 20px auto 20px auto;\n" \
"\t\t}\n" \
"\t\thtml {\n" \
"\t\t\tpadding: 0px;\n" \
"\t\t\tmargin: 0px;\n" \
"\t\t\tbackground-color: black;\n" \
"\t\t}\n" \
"\t</style>\n" \
"</head>\n" \
"<body onload=load()>\n"
EaseHTMLExporter* ease_html_exporter_new (void);
EaseHTMLExporter* ease_html_exporter_construct (GType object_type);
char* ease_dialog_save (const char* title, GtkWindow* modal);
static void ease_html_exporter_set_path (EaseHTMLExporter* self, const char* value);
const char* ease_html_exporter_get_path (EaseHTMLExporter* self);
gboolean ease_html_exporter_request_path (EaseHTMLExporter* self, GtkWindow* win);
void ease_html_exporter_add_progress (EaseHTMLExporter* self, double amount);
void ease_html_exporter_finish (EaseHTMLExporter* self);
void ease_error_dialog (const char* title, const char* message);
void ease_html_exporter_copy_file (EaseHTMLExporter* self, const char* end_path, const char* base_path);
char* ease_html_exporter_get_basename (EaseHTMLExporter* self);
static void ease_html_exporter_finalize (GObject* obj);
static void ease_html_exporter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_html_exporter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



#line 53 "ease-html-exporter.vala"
EaseHTMLExporter* ease_html_exporter_construct (GType object_type) {
#line 92 "ease-html-exporter.c"
	EaseHTMLExporter * self;
	GtkProgressBar* _tmp0_;
#line 53 "ease-html-exporter.vala"
	self = (EaseHTMLExporter*) g_object_new (object_type, NULL);
#line 55 "ease-html-exporter.vala"
	self->priv->progress = (_tmp0_ = g_object_ref_sink ((GtkProgressBar*) gtk_progress_bar_new ()), _g_object_unref0 (self->priv->progress), _tmp0_);
#line 99 "ease-html-exporter.c"
	return self;
}


#line 53 "ease-html-exporter.vala"
EaseHTMLExporter* ease_html_exporter_new (void) {
#line 53 "ease-html-exporter.vala"
	return ease_html_exporter_construct (EASE_TYPE_HTML_EXPORTER);
#line 108 "ease-html-exporter.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 67 "ease-html-exporter.vala"
gboolean ease_html_exporter_request_path (EaseHTMLExporter* self, GtkWindow* win) {
#line 119 "ease-html-exporter.c"
	gboolean result = FALSE;
	char* _tmp0_;
#line 67 "ease-html-exporter.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 67 "ease-html-exporter.vala"
	g_return_val_if_fail (win != NULL, FALSE);
#line 69 "ease-html-exporter.vala"
	ease_html_exporter_set_path (self, _tmp0_ = ease_dialog_save (_ ("Export to HTML"), win));
#line 128 "ease-html-exporter.c"
	_g_free0 (_tmp0_);
#line 71 "ease-html-exporter.vala"
	if (self->priv->_path != NULL) {
#line 132 "ease-html-exporter.c"
		GtkDialog* _tmp1_;
		GtkVBox* vbox;
#line 74 "ease-html-exporter.vala"
		self->priv->window = (_tmp1_ = g_object_ref_sink ((GtkDialog*) gtk_dialog_new ()), _g_object_unref0 (self->priv->window), _tmp1_);
#line 75 "ease-html-exporter.vala"
		g_object_set ((GtkWidget*) self->priv->window, "width-request", 400, NULL);
#line 76 "ease-html-exporter.vala"
		gtk_window_set_title ((GtkWindow*) self->priv->window, _ ("Exporting as HTML"));
#line 77 "ease-html-exporter.vala"
		vbox = _g_object_ref0 (GTK_VBOX (gtk_dialog_get_content_area (self->priv->window)));
#line 78 "ease-html-exporter.vala"
		gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) self->priv->progress, TRUE, TRUE, (guint) 5);
#line 79 "ease-html-exporter.vala"
		gtk_widget_show_all ((GtkWidget*) self->priv->window);
#line 147 "ease-html-exporter.c"
		result = TRUE;
		_g_object_unref0 (vbox);
#line 81 "ease-html-exporter.vala"
		return result;
#line 152 "ease-html-exporter.c"
	}
	result = FALSE;
#line 84 "ease-html-exporter.vala"
	return result;
#line 157 "ease-html-exporter.c"
}


#line 92 "ease-html-exporter.vala"
void ease_html_exporter_add_progress (EaseHTMLExporter* self, double amount) {
#line 92 "ease-html-exporter.vala"
	g_return_if_fail (self != NULL);
#line 94 "ease-html-exporter.vala"
	gtk_progress_bar_set_fraction (self->priv->progress, gtk_progress_bar_get_fraction (self->priv->progress) + amount);
#line 167 "ease-html-exporter.c"
}


#line 100 "ease-html-exporter.vala"
void ease_html_exporter_finish (EaseHTMLExporter* self) {
#line 100 "ease-html-exporter.vala"
	g_return_if_fail (self != NULL);
#line 102 "ease-html-exporter.vala"
	gtk_widget_hide_all ((GtkWidget*) self->priv->window);
#line 103 "ease-html-exporter.vala"
	gtk_object_destroy ((GtkObject*) self->priv->window);
#line 179 "ease-html-exporter.c"
}


#line 115 "ease-html-exporter.vala"
void ease_html_exporter_copy_file (EaseHTMLExporter* self, const char* end_path, const char* base_path) {
#line 185 "ease-html-exporter.c"
	GError * _inner_error_;
	char* _tmp0_;
	GFile* _tmp1_;
	GFile* source;
	char* _tmp3_;
	char* _tmp2_;
	GFile* _tmp4_;
	GFile* destination;
#line 115 "ease-html-exporter.vala"
	g_return_if_fail (self != NULL);
#line 115 "ease-html-exporter.vala"
	g_return_if_fail (end_path != NULL);
#line 115 "ease-html-exporter.vala"
	g_return_if_fail (base_path != NULL);
#line 200 "ease-html-exporter.c"
	_inner_error_ = NULL;
#line 117 "ease-html-exporter.vala"
	source = (_tmp1_ = g_file_new_for_path (_tmp0_ = g_build_path ("/", base_path, end_path, NULL)), _g_free0 (_tmp0_), _tmp1_);
#line 119 "ease-html-exporter.vala"
	destination = (_tmp4_ = g_file_new_for_path (_tmp3_ = g_strconcat (_tmp2_ = g_strconcat (self->priv->_path, " ", NULL), end_path, NULL)), _g_free0 (_tmp3_), _g_free0 (_tmp2_), _tmp4_);
#line 206 "ease-html-exporter.c"
	{
		GFile* parent;
#line 124 "ease-html-exporter.vala"
		parent = g_file_get_parent (destination);
#line 125 "ease-html-exporter.vala"
		if (!g_file_query_exists (parent, NULL)) {
#line 127 "ease-html-exporter.vala"
			g_file_make_directory_with_parents (parent, NULL, &_inner_error_);
#line 215 "ease-html-exporter.c"
			if (_inner_error_ != NULL) {
				_g_object_unref0 (parent);
				goto __catch13_g_error;
			}
		}
#line 131 "ease-html-exporter.vala"
		g_file_copy (source, destination, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
#line 223 "ease-html-exporter.c"
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			goto __catch13_g_error;
		}
		_g_object_unref0 (parent);
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 138 "ease-html-exporter.vala"
			ease_error_dialog (_ ("Error Copying File"), e->message);
#line 239 "ease-html-exporter.c"
			_g_error_free0 (e);
		}
	}
	__finally13:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (destination);
		_g_object_unref0 (source);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (destination);
	_g_object_unref0 (source);
}


const char* ease_html_exporter_get_path (EaseHTMLExporter* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_path;
#line 36 "ease-html-exporter.vala"
	return result;
#line 262 "ease-html-exporter.c"
}


static void ease_html_exporter_set_path (EaseHTMLExporter* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_path = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_path), _tmp0_);
	g_object_notify ((GObject *) self, "path");
}


char* ease_html_exporter_get_basename (EaseHTMLExporter* self) {
	char* result;
	GFile* file;
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "ease-html-exporter.vala"
	file = g_file_new_for_path (self->priv->_path);
#line 280 "ease-html-exporter.c"
	result = g_file_get_basename (file);
	_g_object_unref0 (file);
#line 46 "ease-html-exporter.vala"
	return result;
#line 285 "ease-html-exporter.c"
}


static void ease_html_exporter_class_init (EaseHTMLExporterClass * klass) {
	ease_html_exporter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseHTMLExporterPrivate));
	G_OBJECT_CLASS (klass)->get_property = ease_html_exporter_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_html_exporter_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_html_exporter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_HTML_EXPORTER_PATH, g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_HTML_EXPORTER_BASENAME, g_param_spec_string ("basename", "basename", "basename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void ease_html_exporter_instance_init (EaseHTMLExporter * self) {
	self->priv = EASE_HTML_EXPORTER_GET_PRIVATE (self);
}


static void ease_html_exporter_finalize (GObject* obj) {
	EaseHTMLExporter * self;
	self = EASE_HTML_EXPORTER (obj);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->progress);
	_g_free0 (self->priv->_path);
	G_OBJECT_CLASS (ease_html_exporter_parent_class)->finalize (obj);
}


GType ease_html_exporter_get_type (void) {
	static volatile gsize ease_html_exporter_type_id__volatile = 0;
	if (g_once_init_enter (&ease_html_exporter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseHTMLExporterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_html_exporter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseHTMLExporter), 0, (GInstanceInitFunc) ease_html_exporter_instance_init, NULL };
		GType ease_html_exporter_type_id;
		ease_html_exporter_type_id = g_type_register_static (G_TYPE_OBJECT, "EaseHTMLExporter", &g_define_type_info, 0);
		g_once_init_leave (&ease_html_exporter_type_id__volatile, ease_html_exporter_type_id);
	}
	return ease_html_exporter_type_id__volatile;
}


static void ease_html_exporter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseHTMLExporter * self;
	self = EASE_HTML_EXPORTER (object);
	switch (property_id) {
		case EASE_HTML_EXPORTER_PATH:
		g_value_set_string (value, ease_html_exporter_get_path (self));
		break;
		case EASE_HTML_EXPORTER_BASENAME:
		g_value_take_string (value, ease_html_exporter_get_basename (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_html_exporter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseHTMLExporter * self;
	self = EASE_HTML_EXPORTER (object);
	switch (property_id) {
		case EASE_HTML_EXPORTER_PATH:
		ease_html_exporter_set_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




