/* ease-media-element.c generated by valac, the Vala compiler
 * generated from ease-media-element.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <clutter/clutter.h>
#include <gtk/gtk.h>


#define EASE_TYPE_UNDO_SOURCE (ease_undo_source_get_type ())
#define EASE_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSource))
#define EASE_IS_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_SOURCE))
#define EASE_UNDO_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSourceIface))

typedef struct _EaseUndoSource EaseUndoSource;
typedef struct _EaseUndoSourceIface EaseUndoSourceIface;

#define EASE_TYPE_ELEMENT (ease_element_get_type ())
#define EASE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT, EaseElement))
#define EASE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT, EaseElementClass))
#define EASE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT))
#define EASE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT))
#define EASE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT, EaseElementClass))

typedef struct _EaseElement EaseElement;
typedef struct _EaseElementClass EaseElementClass;
typedef struct _EaseElementPrivate EaseElementPrivate;

#define EASE_TYPE_HTML_EXPORTER (ease_html_exporter_get_type ())
#define EASE_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporter))
#define EASE_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))
#define EASE_IS_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_HTML_EXPORTER))
#define EASE_IS_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_HTML_EXPORTER))
#define EASE_HTML_EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))

typedef struct _EaseHTMLExporter EaseHTMLExporter;
typedef struct _EaseHTMLExporterClass EaseHTMLExporterClass;

#define EASE_TYPE_ACTOR_CONTEXT (ease_actor_context_get_type ())

#define EASE_TYPE_ACTOR (ease_actor_get_type ())
#define EASE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ACTOR, EaseActor))
#define EASE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ACTOR, EaseActorClass))
#define EASE_IS_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ACTOR))
#define EASE_IS_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ACTOR))
#define EASE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ACTOR, EaseActorClass))

typedef struct _EaseActor EaseActor;
typedef struct _EaseActorClass EaseActorClass;

#define EASE_TYPE_MEDIA_ELEMENT (ease_media_element_get_type ())
#define EASE_MEDIA_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElement))
#define EASE_MEDIA_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElementClass))
#define EASE_IS_MEDIA_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_MEDIA_ELEMENT))
#define EASE_IS_MEDIA_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_MEDIA_ELEMENT))
#define EASE_MEDIA_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElementClass))

typedef struct _EaseMediaElement EaseMediaElement;
typedef struct _EaseMediaElementClass EaseMediaElementClass;
typedef struct _EaseMediaElementPrivate EaseMediaElementPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define EASE_TYPE_SLIDE (ease_slide_get_type ())
#define EASE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE, EaseSlide))
#define EASE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE, EaseSlideClass))
#define EASE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE))
#define EASE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE))
#define EASE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE, EaseSlideClass))

typedef struct _EaseSlide EaseSlide;
typedef struct _EaseSlideClass EaseSlideClass;

#define EASE_TYPE_DOCUMENT (ease_document_get_type ())
#define EASE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_DOCUMENT, EaseDocument))
#define EASE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_DOCUMENT, EaseDocumentClass))
#define EASE_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_DOCUMENT))
#define EASE_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_DOCUMENT))
#define EASE_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_DOCUMENT, EaseDocumentClass))

typedef struct _EaseDocument EaseDocument;
typedef struct _EaseDocumentClass EaseDocumentClass;

struct _EaseUndoSourceIface {
	GTypeInterface parent_iface;
};

typedef enum  {
	EASE_ACTOR_CONTEXT_PRESENTATION,
	EASE_ACTOR_CONTEXT_EDITOR,
	EASE_ACTOR_CONTEXT_INSPECTOR
} EaseActorContext;

struct _EaseElement {
	GObject parent_instance;
	EaseElementPrivate * priv;
};

struct _EaseElementClass {
	GObjectClass parent_class;
	void (*signals) (EaseElement* self);
	JsonObject* (*to_json) (EaseElement* self);
	void (*to_html) (EaseElement* self, char** html, EaseHTMLExporter* exporter, double amount);
	char** (*claim_media) (EaseElement* self, int* result_length1);
	char* (*html_render) (EaseElement* self, EaseHTMLExporter* exporter);
	void (*cairo_render) (EaseElement* self, cairo_t* context, GError** error);
	EaseActor* (*actor) (EaseElement* self, EaseActorContext c);
	GtkWidget* (*inspector_widget) (EaseElement* self);
	GList* (*tool_items) (EaseElement* self);
	gboolean (*set_color) (EaseElement* self, ClutterColor* c);
	ClutterColor* (*get_color) (EaseElement* self);
};

struct _EaseMediaElement {
	EaseElement parent_instance;
	EaseMediaElementPrivate * priv;
};

struct _EaseMediaElementClass {
	EaseElementClass parent_class;
};

struct _EaseMediaElementPrivate {
	char* _filename;
	char* _source_filename;
};


static gpointer ease_media_element_parent_class = NULL;

GType ease_undo_source_get_type (void) G_GNUC_CONST;
GType ease_element_get_type (void) G_GNUC_CONST;
GType ease_html_exporter_get_type (void) G_GNUC_CONST;
GType ease_actor_context_get_type (void) G_GNUC_CONST;
GType ease_actor_get_type (void) G_GNUC_CONST;
GType ease_media_element_get_type (void) G_GNUC_CONST;
#define EASE_MEDIA_ELEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElementPrivate))
enum  {
	EASE_MEDIA_ELEMENT_DUMMY_PROPERTY,
	EASE_MEDIA_ELEMENT_FILENAME,
	EASE_MEDIA_ELEMENT_SOURCE_FILENAME,
	EASE_MEDIA_ELEMENT_FULL_FILENAME
};
EaseElement* ease_element_construct_from_json (GType object_type, JsonObject* obj);
#define EASE_THEME_MEDIA_FILENAME "media-filename"
void ease_media_element_set_filename (EaseMediaElement* self, const char* value);
#define EASE_THEME_MEDIA_SOURCE_FILENAME "media-source-filename"
void ease_media_element_set_source_filename (EaseMediaElement* self, const char* value);
EaseMediaElement* ease_media_element_construct_from_json (GType object_type, JsonObject* obj);
JsonObject* ease_element_to_json (EaseElement* self);
const char* ease_media_element_get_filename (EaseMediaElement* self);
const char* ease_media_element_get_source_filename (EaseMediaElement* self);
static JsonObject* ease_media_element_real_to_json (EaseElement* base);
void ease_element_signals (EaseElement* self);
static void _lambda21_ (GObject* o, GParamSpec* p, EaseMediaElement* self);
static void __lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ease_media_element_real_signals (EaseElement* base);
static char** ease_media_element_real_claim_media (EaseElement* base, int* result_length1);
EaseElement* ease_element_construct (GType object_type);
EaseMediaElement* ease_media_element_construct (GType object_type);
GType ease_slide_get_type (void) G_GNUC_CONST;
EaseSlide* ease_element_get_parent (EaseElement* self);
GType ease_document_get_type (void) G_GNUC_CONST;
EaseDocument* ease_slide_get_parent (EaseSlide* self);
const char* ease_document_get_path (EaseDocument* self);
char* ease_media_element_get_full_filename (EaseMediaElement* self);
static void ease_media_element_finalize (GObject* obj);
static void ease_media_element_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_media_element_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



#line 26 "ease-media-element.vala"
EaseMediaElement* ease_media_element_construct_from_json (GType object_type, JsonObject* obj) {
#line 199 "ease-media-element.c"
	EaseMediaElement * self;
#line 26 "ease-media-element.vala"
	g_return_val_if_fail (obj != NULL, NULL);
#line 28 "ease-media-element.vala"
	self = (EaseMediaElement*) ease_element_construct_from_json (object_type, obj);
#line 29 "ease-media-element.vala"
	ease_media_element_set_filename (self, json_object_get_string_member (obj, EASE_THEME_MEDIA_FILENAME));
#line 30 "ease-media-element.vala"
	ease_media_element_set_source_filename (self, json_object_get_string_member (obj, EASE_THEME_MEDIA_SOURCE_FILENAME));
#line 209 "ease-media-element.c"
	return self;
}


#line 33 "ease-media-element.vala"
static JsonObject* ease_media_element_real_to_json (EaseElement* base) {
#line 216 "ease-media-element.c"
	EaseMediaElement * self;
	JsonObject* result = NULL;
	JsonObject* obj;
	self = (EaseMediaElement*) base;
#line 35 "ease-media-element.vala"
	obj = EASE_ELEMENT_CLASS (ease_media_element_parent_class)->to_json (EASE_ELEMENT (self));
#line 37 "ease-media-element.vala"
	json_object_set_string_member (obj, EASE_THEME_MEDIA_FILENAME, self->priv->_filename);
#line 38 "ease-media-element.vala"
	json_object_set_string_member (obj, EASE_THEME_MEDIA_SOURCE_FILENAME, self->priv->_source_filename);
#line 227 "ease-media-element.c"
	result = obj;
#line 40 "ease-media-element.vala"
	return result;
#line 231 "ease-media-element.c"
}


#line 46 "ease-media-element.vala"
static void _lambda21_ (GObject* o, GParamSpec* p, EaseMediaElement* self) {
#line 46 "ease-media-element.vala"
	g_return_if_fail (o != NULL);
#line 46 "ease-media-element.vala"
	g_return_if_fail (p != NULL);
#line 46 "ease-media-element.vala"
	g_signal_emit_by_name ((EaseElement*) self, "changed");
#line 243 "ease-media-element.c"
}


#line 46 "ease-media-element.vala"
static void __lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 249 "ease-media-element.c"
	_lambda21_ (_sender, pspec, self);
}


#line 43 "ease-media-element.vala"
static void ease_media_element_real_signals (EaseElement* base) {
#line 256 "ease-media-element.c"
	EaseMediaElement * self;
	self = (EaseMediaElement*) base;
#line 45 "ease-media-element.vala"
	EASE_ELEMENT_CLASS (ease_media_element_parent_class)->signals (EASE_ELEMENT (self));
#line 46 "ease-media-element.vala"
	g_signal_connect_object ((GObject*) self, "notify::filename", (GCallback) __lambda21__g_object_notify, self, 0);
#line 263 "ease-media-element.c"
}


#line 52 "ease-media-element.vala"
static char** ease_media_element_real_claim_media (EaseElement* base, int* result_length1) {
#line 269 "ease-media-element.c"
	EaseMediaElement * self;
	char** result = NULL;
	char** _tmp0_ = NULL;
	char** _tmp1_;
	self = (EaseMediaElement*) base;
	result = (_tmp1_ = (_tmp0_ = g_new0 (char*, 1 + 1), _tmp0_[0] = g_strdup (self->priv->_filename), _tmp0_), *result_length1 = 1, _tmp1_);
#line 54 "ease-media-element.vala"
	return result;
#line 278 "ease-media-element.c"
}


#line 21 "ease-media-element.vala"
EaseMediaElement* ease_media_element_construct (GType object_type) {
#line 284 "ease-media-element.c"
	EaseMediaElement * self;
#line 21 "ease-media-element.vala"
	self = (EaseMediaElement*) ease_element_construct (object_type);
#line 288 "ease-media-element.c"
	return self;
}


const char* ease_media_element_get_filename (EaseMediaElement* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_filename;
#line 60 "ease-media-element.vala"
	return result;
#line 299 "ease-media-element.c"
}


void ease_media_element_set_filename (EaseMediaElement* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_filename = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_filename), _tmp0_);
	g_object_notify ((GObject *) self, "filename");
}


const char* ease_media_element_get_source_filename (EaseMediaElement* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_source_filename;
#line 65 "ease-media-element.vala"
	return result;
#line 317 "ease-media-element.c"
}


void ease_media_element_set_source_filename (EaseMediaElement* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_source_filename = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_source_filename), _tmp0_);
	g_object_notify ((GObject *) self, "source-filename");
}


char* ease_media_element_get_full_filename (EaseMediaElement* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = g_build_filename (ease_document_get_path (ease_slide_get_parent (ease_element_get_parent ((EaseElement*) self))), self->priv->_filename, NULL);
#line 74 "ease-media-element.vala"
	return result;
#line 335 "ease-media-element.c"
}


static void ease_media_element_class_init (EaseMediaElementClass * klass) {
	ease_media_element_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseMediaElementPrivate));
	EASE_ELEMENT_CLASS (klass)->to_json = ease_media_element_real_to_json;
	EASE_ELEMENT_CLASS (klass)->signals = ease_media_element_real_signals;
	EASE_ELEMENT_CLASS (klass)->claim_media = ease_media_element_real_claim_media;
	G_OBJECT_CLASS (klass)->get_property = ease_media_element_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_media_element_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_media_element_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_MEDIA_ELEMENT_FILENAME, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_MEDIA_ELEMENT_SOURCE_FILENAME, g_param_spec_string ("source-filename", "source-filename", "source-filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_MEDIA_ELEMENT_FULL_FILENAME, g_param_spec_string ("full-filename", "full-filename", "full-filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void ease_media_element_instance_init (EaseMediaElement * self) {
	self->priv = EASE_MEDIA_ELEMENT_GET_PRIVATE (self);
}


static void ease_media_element_finalize (GObject* obj) {
	EaseMediaElement * self;
	self = EASE_MEDIA_ELEMENT (obj);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_source_filename);
	G_OBJECT_CLASS (ease_media_element_parent_class)->finalize (obj);
}


GType ease_media_element_get_type (void) {
	static volatile gsize ease_media_element_type_id__volatile = 0;
	if (g_once_init_enter (&ease_media_element_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseMediaElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_media_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseMediaElement), 0, (GInstanceInitFunc) ease_media_element_instance_init, NULL };
		GType ease_media_element_type_id;
		ease_media_element_type_id = g_type_register_static (EASE_TYPE_ELEMENT, "EaseMediaElement", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&ease_media_element_type_id__volatile, ease_media_element_type_id);
	}
	return ease_media_element_type_id__volatile;
}


static void ease_media_element_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseMediaElement * self;
	self = EASE_MEDIA_ELEMENT (object);
	switch (property_id) {
		case EASE_MEDIA_ELEMENT_FILENAME:
		g_value_set_string (value, ease_media_element_get_filename (self));
		break;
		case EASE_MEDIA_ELEMENT_SOURCE_FILENAME:
		g_value_set_string (value, ease_media_element_get_source_filename (self));
		break;
		case EASE_MEDIA_ELEMENT_FULL_FILENAME:
		g_value_take_string (value, ease_media_element_get_full_filename (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_media_element_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseMediaElement * self;
	self = EASE_MEDIA_ELEMENT (object);
	switch (property_id) {
		case EASE_MEDIA_ELEMENT_FILENAME:
		ease_media_element_set_filename (self, g_value_get_string (value));
		break;
		case EASE_MEDIA_ELEMENT_SOURCE_FILENAME:
		ease_media_element_set_source_filename (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




