/* ease-shape-element.c generated by valac, the Vala compiler
 * generated from ease-shape-element.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <clutter/clutter.h>
#include <gtk/gtk.h>


#define EASE_TYPE_UNDO_SOURCE (ease_undo_source_get_type ())
#define EASE_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSource))
#define EASE_IS_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_SOURCE))
#define EASE_UNDO_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSourceIface))

typedef struct _EaseUndoSource EaseUndoSource;
typedef struct _EaseUndoSourceIface EaseUndoSourceIface;

#define EASE_TYPE_ELEMENT (ease_element_get_type ())
#define EASE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT, EaseElement))
#define EASE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT, EaseElementClass))
#define EASE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT))
#define EASE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT))
#define EASE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT, EaseElementClass))

typedef struct _EaseElement EaseElement;
typedef struct _EaseElementClass EaseElementClass;
typedef struct _EaseElementPrivate EaseElementPrivate;

#define EASE_TYPE_HTML_EXPORTER (ease_html_exporter_get_type ())
#define EASE_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporter))
#define EASE_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))
#define EASE_IS_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_HTML_EXPORTER))
#define EASE_IS_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_HTML_EXPORTER))
#define EASE_HTML_EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))

typedef struct _EaseHTMLExporter EaseHTMLExporter;
typedef struct _EaseHTMLExporterClass EaseHTMLExporterClass;

#define EASE_TYPE_ACTOR_CONTEXT (ease_actor_context_get_type ())

#define EASE_TYPE_ACTOR (ease_actor_get_type ())
#define EASE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ACTOR, EaseActor))
#define EASE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ACTOR, EaseActorClass))
#define EASE_IS_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ACTOR))
#define EASE_IS_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ACTOR))
#define EASE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ACTOR, EaseActorClass))

typedef struct _EaseActor EaseActor;
typedef struct _EaseActorClass EaseActorClass;

#define EASE_TYPE_CAIRO_ELEMENT (ease_cairo_element_get_type ())
#define EASE_CAIRO_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_CAIRO_ELEMENT, EaseCairoElement))
#define EASE_CAIRO_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_CAIRO_ELEMENT, EaseCairoElementClass))
#define EASE_IS_CAIRO_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_CAIRO_ELEMENT))
#define EASE_IS_CAIRO_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_CAIRO_ELEMENT))
#define EASE_CAIRO_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_CAIRO_ELEMENT, EaseCairoElementClass))

typedef struct _EaseCairoElement EaseCairoElement;
typedef struct _EaseCairoElementClass EaseCairoElementClass;
typedef struct _EaseCairoElementPrivate EaseCairoElementPrivate;

#define EASE_TYPE_SHAPE_ELEMENT (ease_shape_element_get_type ())
#define EASE_SHAPE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SHAPE_ELEMENT, EaseShapeElement))
#define EASE_SHAPE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SHAPE_ELEMENT, EaseShapeElementClass))
#define EASE_IS_SHAPE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SHAPE_ELEMENT))
#define EASE_IS_SHAPE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SHAPE_ELEMENT))
#define EASE_SHAPE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SHAPE_ELEMENT, EaseShapeElementClass))

typedef struct _EaseShapeElement EaseShapeElement;
typedef struct _EaseShapeElementClass EaseShapeElementClass;
typedef struct _EaseShapeElementPrivate EaseShapeElementPrivate;

#define EASE_TYPE_SHAPE_TYPE (ease_shape_type_get_type ())

#define EASE_TYPE_BACKGROUND (ease_background_get_type ())
#define EASE_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_BACKGROUND, EaseBackground))
#define EASE_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_BACKGROUND, EaseBackgroundClass))
#define EASE_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_BACKGROUND))
#define EASE_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_BACKGROUND))
#define EASE_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_BACKGROUND, EaseBackgroundClass))

typedef struct _EaseBackground EaseBackground;
typedef struct _EaseBackgroundClass EaseBackgroundClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define EASE_TYPE_IMAGE (ease_image_get_type ())
#define EASE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_IMAGE, EaseImage))
#define EASE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_IMAGE, EaseImageClass))
#define EASE_IS_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_IMAGE))
#define EASE_IS_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_IMAGE))
#define EASE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_IMAGE, EaseImageClass))

typedef struct _EaseImage EaseImage;
typedef struct _EaseImageClass EaseImageClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define EASE_TYPE_BACKGROUND_WIDGET (ease_background_widget_get_type ())
#define EASE_BACKGROUND_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_BACKGROUND_WIDGET, EaseBackgroundWidget))
#define EASE_BACKGROUND_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_BACKGROUND_WIDGET, EaseBackgroundWidgetClass))
#define EASE_IS_BACKGROUND_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_BACKGROUND_WIDGET))
#define EASE_IS_BACKGROUND_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_BACKGROUND_WIDGET))
#define EASE_BACKGROUND_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_BACKGROUND_WIDGET, EaseBackgroundWidgetClass))

typedef struct _EaseBackgroundWidget EaseBackgroundWidget;
typedef struct _EaseBackgroundWidgetClass EaseBackgroundWidgetClass;

#define EASE_TYPE_SLIDE (ease_slide_get_type ())
#define EASE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE, EaseSlide))
#define EASE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE, EaseSlideClass))
#define EASE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE))
#define EASE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE))
#define EASE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE, EaseSlideClass))

typedef struct _EaseSlide EaseSlide;
typedef struct _EaseSlideClass EaseSlideClass;

#define EASE_TYPE_DOCUMENT (ease_document_get_type ())
#define EASE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_DOCUMENT, EaseDocument))
#define EASE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_DOCUMENT, EaseDocumentClass))
#define EASE_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_DOCUMENT))
#define EASE_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_DOCUMENT))
#define EASE_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_DOCUMENT, EaseDocumentClass))

typedef struct _EaseDocument EaseDocument;
typedef struct _EaseDocumentClass EaseDocumentClass;

#define EASE_TYPE_UNDO_ITEM (ease_undo_item_get_type ())
#define EASE_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItem))
#define EASE_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))
#define EASE_IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ITEM))
#define EASE_IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ITEM))
#define EASE_UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))

typedef struct _EaseUndoItem EaseUndoItem;
typedef struct _EaseUndoItemClass EaseUndoItemClass;

struct _EaseUndoSourceIface {
	GTypeInterface parent_iface;
};

typedef enum  {
	EASE_ACTOR_CONTEXT_PRESENTATION,
	EASE_ACTOR_CONTEXT_EDITOR,
	EASE_ACTOR_CONTEXT_INSPECTOR
} EaseActorContext;

struct _EaseElement {
	GObject parent_instance;
	EaseElementPrivate * priv;
};

struct _EaseElementClass {
	GObjectClass parent_class;
	void (*signals) (EaseElement* self);
	JsonObject* (*to_json) (EaseElement* self);
	void (*to_html) (EaseElement* self, char** html, EaseHTMLExporter* exporter, double amount);
	char** (*claim_media) (EaseElement* self, int* result_length1);
	char* (*html_render) (EaseElement* self, EaseHTMLExporter* exporter);
	void (*cairo_render) (EaseElement* self, cairo_t* context, GError** error);
	EaseActor* (*actor) (EaseElement* self, EaseActorContext c);
	GtkWidget* (*inspector_widget) (EaseElement* self);
	GList* (*tool_items) (EaseElement* self);
	gboolean (*set_color) (EaseElement* self, ClutterColor* c);
	ClutterColor* (*get_color) (EaseElement* self);
};

struct _EaseCairoElement {
	EaseElement parent_instance;
	EaseCairoElementPrivate * priv;
};

struct _EaseCairoElementClass {
	EaseElementClass parent_class;
};

struct _EaseShapeElement {
	EaseCairoElement parent_instance;
	EaseShapeElementPrivate * priv;
};

struct _EaseShapeElementClass {
	EaseCairoElementClass parent_class;
};

typedef enum  {
	EASE_SHAPE_TYPE_RECTANGLE = 0,
	EASE_SHAPE_TYPE_OVAL = 1
} EaseShapeType;

struct _EaseShapeElementPrivate {
	EaseShapeType _shape_type;
	EaseBackground* _background;
};


static gpointer ease_shape_element_parent_class = NULL;

GType ease_undo_source_get_type (void) G_GNUC_CONST;
GType ease_element_get_type (void) G_GNUC_CONST;
GType ease_html_exporter_get_type (void) G_GNUC_CONST;
GType ease_actor_context_get_type (void) G_GNUC_CONST;
GType ease_actor_get_type (void) G_GNUC_CONST;
GType ease_cairo_element_get_type (void) G_GNUC_CONST;
GType ease_shape_element_get_type (void) G_GNUC_CONST;
GType ease_shape_type_get_type (void) G_GNUC_CONST;
GType ease_background_get_type (void) G_GNUC_CONST;
#define EASE_SHAPE_ELEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_SHAPE_ELEMENT, EaseShapeElementPrivate))
enum  {
	EASE_SHAPE_ELEMENT_DUMMY_PROPERTY,
	EASE_SHAPE_ELEMENT_SHAPE_TYPE
};
#define EASE_SHAPE_ELEMENT_UI_FILE "inspector-element-shape.ui"
EaseCairoElement* ease_cairo_element_construct (GType object_type);
void ease_element_signals (EaseElement* self);
static void ease_shape_element_set_shape_type (EaseShapeElement* self, EaseShapeType value);
EaseBackground* ease_background_new_default_gradient (void);
EaseBackground* ease_background_construct_default_gradient (GType object_type);
static void ease_shape_element_set_background (EaseShapeElement* self, EaseBackground* value);
EaseShapeElement* ease_shape_element_new (EaseShapeType type);
EaseShapeElement* ease_shape_element_construct (GType object_type, EaseShapeType type);
EaseElement* ease_element_construct_from_json (GType object_type, JsonObject* obj);
EaseShapeType ease_shape_type_from_string (const char* str);
#define EASE_THEME_SHAPE_TYPE "shape-type"
EaseBackground* ease_background_new_from_json (JsonObject* obj);
EaseBackground* ease_background_construct_from_json (GType object_type, JsonObject* obj);
EaseShapeElement* ease_shape_element_new_from_json (JsonObject* obj);
EaseShapeElement* ease_shape_element_construct_from_json (GType object_type, JsonObject* obj);
JsonObject* ease_element_to_json (EaseElement* self);
EaseShapeType ease_shape_element_get_shape_type (EaseShapeElement* self);
static EaseBackground* ease_shape_element_get_background (EaseShapeElement* self);
void ease_background_to_json (EaseBackground* self, JsonObject** obj);
static JsonObject* ease_shape_element_real_to_json (EaseElement* base);
GType ease_image_get_type (void) G_GNUC_CONST;
EaseImage* ease_background_get_image (EaseBackground* self);
const char* ease_image_get_filename (EaseImage* self);
static char** ease_shape_element_real_claim_media (EaseElement* base, int* result_length1);
static char* ease_shape_element_real_html_render (EaseElement* base, EaseHTMLExporter* exporter);
char* ease_data_path (const char* path);
#define EASE_TEMP_UI_DIR "ui"
EaseBackgroundWidget* ease_background_widget_new (EaseBackground* bg, EaseElement* e);
EaseBackgroundWidget* ease_background_widget_construct (GType object_type, EaseBackground* bg, EaseElement* e);
GType ease_background_widget_get_type (void) G_GNUC_CONST;
static void _lambda37_ (EaseShapeElement* self);
static void __lambda37__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda38_ (EaseShapeElement* self);
static void __lambda38__gtk_button_clicked (GtkButton* _sender, gpointer self);
static GtkWidget* ease_shape_element_real_inspector_widget (EaseElement* base);
void ease_background_set_cairo (EaseBackground* self, cairo_t* cr, gint width, gint height, const char* path);
float ease_element_get_width (EaseElement* self);
float ease_element_get_height (EaseElement* self);
GType ease_slide_get_type (void) G_GNUC_CONST;
EaseSlide* ease_element_get_parent (EaseElement* self);
GType ease_document_get_type (void) G_GNUC_CONST;
EaseDocument* ease_slide_get_parent (EaseSlide* self);
const char* ease_document_get_path (EaseDocument* self);
static void ease_shape_element_real_cairo_render (EaseElement* base, cairo_t* cr, GError** error);
static void _lambda25_ (GObject* o, GParamSpec* p, EaseShapeElement* self);
static void __lambda25__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GType ease_undo_item_get_type (void) G_GNUC_CONST;
gboolean ease_background_owns_undoitem (EaseBackground* self, EaseUndoItem* item);
static void _lambda26_ (EaseUndoItem* item, EaseShapeElement* self);
static void __lambda26__ease_undo_source_undo (EaseUndoSource* _sender, EaseUndoItem* action, gpointer self);
static void ease_shape_element_real_signals (EaseElement* base);
static void ease_shape_element_finalize (GObject* obj);
static void ease_shape_element_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_shape_element_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



#line 37 "ease-shape-element.vala"
EaseShapeElement* ease_shape_element_construct (GType object_type, EaseShapeType type) {
#line 298 "ease-shape-element.c"
	EaseShapeElement * self;
	EaseBackground* _tmp0_;
#line 37 "ease-shape-element.vala"
	self = (EaseShapeElement*) ease_cairo_element_construct (object_type);
#line 39 "ease-shape-element.vala"
	ease_element_signals ((EaseElement*) self);
#line 41 "ease-shape-element.vala"
	ease_shape_element_set_shape_type (self, type);
#line 42 "ease-shape-element.vala"
	ease_shape_element_set_background (self, _tmp0_ = ease_background_new_default_gradient ());
#line 309 "ease-shape-element.c"
	_g_object_unref0 (_tmp0_);
	return self;
}


#line 37 "ease-shape-element.vala"
EaseShapeElement* ease_shape_element_new (EaseShapeType type) {
#line 37 "ease-shape-element.vala"
	return ease_shape_element_construct (EASE_TYPE_SHAPE_ELEMENT, type);
#line 319 "ease-shape-element.c"
}


#line 48 "ease-shape-element.vala"
EaseShapeElement* ease_shape_element_construct_from_json (GType object_type, JsonObject* obj) {
#line 325 "ease-shape-element.c"
	EaseShapeElement * self;
	EaseBackground* _tmp0_;
#line 48 "ease-shape-element.vala"
	g_return_val_if_fail (obj != NULL, NULL);
#line 50 "ease-shape-element.vala"
	self = (EaseShapeElement*) ease_element_construct_from_json (object_type, obj);
#line 51 "ease-shape-element.vala"
	ease_shape_element_set_shape_type (self, ease_shape_type_from_string (json_object_get_string_member (obj, EASE_THEME_SHAPE_TYPE)));
#line 55 "ease-shape-element.vala"
	ease_shape_element_set_background (self, _tmp0_ = ease_background_new_from_json (obj));
#line 336 "ease-shape-element.c"
	_g_object_unref0 (_tmp0_);
	return self;
}


#line 48 "ease-shape-element.vala"
EaseShapeElement* ease_shape_element_new_from_json (JsonObject* obj) {
#line 48 "ease-shape-element.vala"
	return ease_shape_element_construct_from_json (EASE_TYPE_SHAPE_ELEMENT, obj);
#line 346 "ease-shape-element.c"
}


#line 61 "ease-shape-element.vala"
static JsonObject* ease_shape_element_real_to_json (EaseElement* base) {
#line 352 "ease-shape-element.c"
	EaseShapeElement * self;
	JsonObject* result = NULL;
	JsonObject* obj;
	GEnumValue* _tmp0_;
	self = (EaseShapeElement*) base;
#line 63 "ease-shape-element.vala"
	obj = EASE_ELEMENT_CLASS (ease_shape_element_parent_class)->to_json ((EaseElement*) EASE_CAIRO_ELEMENT (self));
#line 64 "ease-shape-element.vala"
	json_object_set_string_member (obj, EASE_THEME_SHAPE_TYPE, (_tmp0_ = g_enum_get_value (g_type_class_ref (EASE_TYPE_SHAPE_TYPE), (int) self->priv->_shape_type), (_tmp0_ != NULL) ? _tmp0_->value_name : NULL));
#line 67 "ease-shape-element.vala"
	ease_background_to_json (self->priv->_background, &obj);
#line 364 "ease-shape-element.c"
	result = obj;
#line 69 "ease-shape-element.vala"
	return result;
#line 368 "ease-shape-element.c"
}


#line 75 "ease-shape-element.vala"
static char** ease_shape_element_real_claim_media (EaseElement* base, int* result_length1) {
#line 374 "ease-shape-element.c"
	EaseShapeElement * self;
	char** result = NULL;
	char** _tmp2_ = NULL;
	char** _tmp3_;
	self = (EaseShapeElement*) base;
#line 77 "ease-shape-element.vala"
	if (ease_image_get_filename (ease_background_get_image (self->priv->_background)) != NULL) {
#line 382 "ease-shape-element.c"
		char** _tmp0_ = NULL;
		char** _tmp1_;
		result = (_tmp1_ = (_tmp0_ = g_new0 (char*, 1 + 1), _tmp0_[0] = g_strdup (ease_image_get_filename (ease_background_get_image (self->priv->_background))), _tmp0_), *result_length1 = 1, _tmp1_);
#line 78 "ease-shape-element.vala"
		return result;
#line 388 "ease-shape-element.c"
	}
	result = (_tmp3_ = (_tmp2_ = g_new0 (char*, 0 + 1), _tmp2_), *result_length1 = 0, _tmp3_);
#line 79 "ease-shape-element.vala"
	return result;
#line 393 "ease-shape-element.c"
}


#line 87 "ease-shape-element.vala"
static char* ease_shape_element_real_html_render (EaseElement* base, EaseHTMLExporter* exporter) {
#line 399 "ease-shape-element.c"
	EaseShapeElement * self;
	char* result = NULL;
	self = (EaseShapeElement*) base;
#line 87 "ease-shape-element.vala"
	g_return_val_if_fail (exporter != NULL, NULL);
#line 89 "ease-shape-element.vala"
	g_warning ("ease-shape-element.vala:89: HTML Export not currently supported for sh" \
"apes");
#line 407 "ease-shape-element.c"
	result = g_strdup ("<!-- HTML Export not supported for shapes -->");
#line 90 "ease-shape-element.vala"
	return result;
#line 411 "ease-shape-element.c"
}


#line 117 "ease-shape-element.vala"
static void _lambda37_ (EaseShapeElement* self) {
#line 118 "ease-shape-element.vala"
	ease_shape_element_set_shape_type (self, EASE_SHAPE_TYPE_RECTANGLE);
#line 419 "ease-shape-element.c"
}


#line 117 "ease-shape-element.vala"
static void __lambda37__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 425 "ease-shape-element.c"
	_lambda37_ (self);
}


#line 121 "ease-shape-element.vala"
static void _lambda38_ (EaseShapeElement* self) {
#line 122 "ease-shape-element.vala"
	ease_shape_element_set_shape_type (self, EASE_SHAPE_TYPE_OVAL);
#line 434 "ease-shape-element.c"
}


#line 121 "ease-shape-element.vala"
static void __lambda38__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 440 "ease-shape-element.c"
	_lambda38_ (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 96 "ease-shape-element.vala"
static GtkWidget* ease_shape_element_real_inspector_widget (EaseElement* base) {
#line 452 "ease-shape-element.c"
	EaseShapeElement * self;
	GtkWidget* result = NULL;
	GError * _inner_error_;
	GtkBuilder* builder;
	EaseBackgroundWidget* bg;
	GObject* _tmp4_;
	GObject* _tmp5_;
	GObject* _tmp6_;
	GObject* _tmp7_;
	self = (EaseShapeElement*) base;
	_inner_error_ = NULL;
#line 98 "ease-shape-element.vala"
	builder = gtk_builder_new ();
#line 466 "ease-shape-element.c"
	{
		char* _tmp1_;
		char* _tmp0_;
#line 101 "ease-shape-element.vala"
		gtk_builder_add_from_file (builder, _tmp1_ = ease_data_path (_tmp0_ = g_build_filename (EASE_TEMP_UI_DIR, EASE_SHAPE_ELEMENT_UI_FILE, NULL)), &_inner_error_);
#line 472 "ease-shape-element.c"
		_g_free0 (_tmp1_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 104 "ease-shape-element.vala"
			g_error ("ease-shape-element.vala:104: Error loading UI: %s", e->message);
#line 488 "ease-shape-element.c"
			_g_error_free0 (e);
		}
	}
	__finally18:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 106 "ease-shape-element.vala"
	bg = g_object_ref_sink (ease_background_widget_new (self->priv->_background, (EaseElement*) self));
#line 108 "ease-shape-element.vala"
	if (self->priv->_shape_type == EASE_SHAPE_TYPE_RECTANGLE) {
#line 503 "ease-shape-element.c"
		GObject* _tmp2_;
#line 110 "ease-shape-element.vala"
		gtk_toggle_button_set_active ((_tmp2_ = gtk_builder_get_object (builder, "rect"), GTK_IS_TOGGLE_BUTTON (_tmp2_) ? ((GtkToggleButton*) _tmp2_) : NULL), TRUE);
#line 507 "ease-shape-element.c"
	} else {
		GObject* _tmp3_;
#line 114 "ease-shape-element.vala"
		gtk_toggle_button_set_active ((_tmp3_ = gtk_builder_get_object (builder, "oval"), GTK_IS_TOGGLE_BUTTON (_tmp3_) ? ((GtkToggleButton*) _tmp3_) : NULL), TRUE);
#line 512 "ease-shape-element.c"
	}
#line 117 "ease-shape-element.vala"
	g_signal_connect_object ((_tmp4_ = gtk_builder_get_object (builder, "rect"), GTK_IS_BUTTON (_tmp4_) ? ((GtkButton*) _tmp4_) : NULL), "clicked", (GCallback) __lambda37__gtk_button_clicked, self, 0);
#line 121 "ease-shape-element.vala"
	g_signal_connect_object ((_tmp5_ = gtk_builder_get_object (builder, "oval"), GTK_IS_BUTTON (_tmp5_) ? ((GtkButton*) _tmp5_) : NULL), "clicked", (GCallback) __lambda38__gtk_button_clicked, self, 0);
#line 125 "ease-shape-element.vala"
	gtk_box_pack_end ((_tmp6_ = gtk_builder_get_object (builder, "vbox-root"), GTK_IS_BOX (_tmp6_) ? ((GtkBox*) _tmp6_) : NULL), (GtkWidget*) bg, FALSE, TRUE, (guint) 0);
#line 128 "ease-shape-element.vala"
	gtk_widget_show ((GtkWidget*) bg);
#line 522 "ease-shape-element.c"
	result = _g_object_ref0 ((_tmp7_ = gtk_builder_get_object (builder, "root"), GTK_IS_WIDGET (_tmp7_) ? ((GtkWidget*) _tmp7_) : NULL));
	_g_object_unref0 (bg);
	_g_object_unref0 (builder);
#line 130 "ease-shape-element.vala"
	return result;
#line 528 "ease-shape-element.c"
	_g_object_unref0 (bg);
	_g_object_unref0 (builder);
}


#line 138 "ease-shape-element.vala"
static void ease_shape_element_real_cairo_render (EaseElement* base, cairo_t* cr, GError** error) {
#line 536 "ease-shape-element.c"
	EaseShapeElement * self;
	self = (EaseShapeElement*) base;
#line 138 "ease-shape-element.vala"
	g_return_if_fail (cr != NULL);
#line 140 "ease-shape-element.vala"
	ease_background_set_cairo (self->priv->_background, cr, (gint) ease_element_get_width ((EaseElement*) self), (gint) ease_element_get_height ((EaseElement*) self), ease_document_get_path (ease_slide_get_parent (ease_element_get_parent ((EaseElement*) self))));
#line 142 "ease-shape-element.vala"
	switch (self->priv->_shape_type) {
#line 545 "ease-shape-element.c"
		case EASE_SHAPE_TYPE_RECTANGLE:
		{
#line 145 "ease-shape-element.vala"
			cairo_rectangle (cr, (double) 0, (double) 0, (double) ease_element_get_width ((EaseElement*) self), (double) ease_element_get_height ((EaseElement*) self));
#line 146 "ease-shape-element.vala"
			break;
#line 552 "ease-shape-element.c"
		}
		case EASE_SHAPE_TYPE_OVAL:
		{
#line 148 "ease-shape-element.vala"
			cairo_translate (cr, (double) (ease_element_get_width ((EaseElement*) self) / 2), (double) (ease_element_get_height ((EaseElement*) self) / 2));
#line 149 "ease-shape-element.vala"
			cairo_scale (cr, (double) (ease_element_get_width ((EaseElement*) self) / 2), (double) (ease_element_get_height ((EaseElement*) self) / 2));
#line 150 "ease-shape-element.vala"
			cairo_arc (cr, (double) 0, (double) 0, (double) 1, (double) 0, 2 * G_PI);
#line 151 "ease-shape-element.vala"
			break;
#line 564 "ease-shape-element.c"
		}
	}
#line 153 "ease-shape-element.vala"
	cairo_fill (cr);
#line 569 "ease-shape-element.c"
}


#line 160 "ease-shape-element.vala"
static void _lambda25_ (GObject* o, GParamSpec* p, EaseShapeElement* self) {
#line 160 "ease-shape-element.vala"
	g_return_if_fail (o != NULL);
#line 160 "ease-shape-element.vala"
	g_return_if_fail (p != NULL);
#line 160 "ease-shape-element.vala"
	g_signal_emit_by_name ((EaseElement*) self, "changed");
#line 581 "ease-shape-element.c"
}


#line 160 "ease-shape-element.vala"
static void __lambda25__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 587 "ease-shape-element.c"
	_lambda25_ (_sender, pspec, self);
}


#line 162 "ease-shape-element.vala"
static void _lambda26_ (EaseUndoItem* item, EaseShapeElement* self) {
#line 162 "ease-shape-element.vala"
	g_return_if_fail (item != NULL);
#line 163 "ease-shape-element.vala"
	if (ease_background_owns_undoitem (self->priv->_background, item)) {
#line 163 "ease-shape-element.vala"
		g_signal_emit_by_name ((EaseElement*) self, "changed");
#line 600 "ease-shape-element.c"
	}
}


#line 162 "ease-shape-element.vala"
static void __lambda26__ease_undo_source_undo (EaseUndoSource* _sender, EaseUndoItem* action, gpointer self) {
#line 607 "ease-shape-element.c"
	_lambda26_ (action, self);
}


#line 156 "ease-shape-element.vala"
static void ease_shape_element_real_signals (EaseElement* base) {
#line 614 "ease-shape-element.c"
	EaseShapeElement * self;
	self = (EaseShapeElement*) base;
#line 158 "ease-shape-element.vala"
	EASE_ELEMENT_CLASS (ease_shape_element_parent_class)->signals ((EaseElement*) EASE_CAIRO_ELEMENT (self));
#line 160 "ease-shape-element.vala"
	g_signal_connect_object ((GObject*) self, "notify::shape-type", (GCallback) __lambda25__g_object_notify, self, 0);
#line 162 "ease-shape-element.vala"
	g_signal_connect_object ((EaseUndoSource*) self, "undo", (GCallback) __lambda26__ease_undo_source_undo, self, 0);
#line 623 "ease-shape-element.c"
}


EaseShapeType ease_shape_element_get_shape_type (EaseShapeElement* self) {
	EaseShapeType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_shape_type;
#line 25 "ease-shape-element.vala"
	return result;
#line 633 "ease-shape-element.c"
}


static void ease_shape_element_set_shape_type (EaseShapeElement* self, EaseShapeType value) {
	g_return_if_fail (self != NULL);
	self->priv->_shape_type = value;
	g_object_notify ((GObject *) self, "shape-type");
}


static EaseBackground* ease_shape_element_get_background (EaseShapeElement* self) {
	EaseBackground* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_background;
#line 30 "ease-shape-element.vala"
	return result;
#line 650 "ease-shape-element.c"
}


static void ease_shape_element_set_background (EaseShapeElement* self, EaseBackground* value) {
	EaseBackground* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_background = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_background), _tmp0_);
}


static void ease_shape_element_class_init (EaseShapeElementClass * klass) {
	ease_shape_element_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseShapeElementPrivate));
	EASE_ELEMENT_CLASS (klass)->to_json = ease_shape_element_real_to_json;
	EASE_ELEMENT_CLASS (klass)->claim_media = ease_shape_element_real_claim_media;
	EASE_ELEMENT_CLASS (klass)->html_render = ease_shape_element_real_html_render;
	EASE_ELEMENT_CLASS (klass)->inspector_widget = ease_shape_element_real_inspector_widget;
	EASE_ELEMENT_CLASS (klass)->cairo_render = ease_shape_element_real_cairo_render;
	EASE_ELEMENT_CLASS (klass)->signals = ease_shape_element_real_signals;
	G_OBJECT_CLASS (klass)->get_property = ease_shape_element_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_shape_element_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_shape_element_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SHAPE_ELEMENT_SHAPE_TYPE, g_param_spec_enum ("shape-type", "shape-type", "shape-type", EASE_TYPE_SHAPE_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void ease_shape_element_instance_init (EaseShapeElement * self) {
	self->priv = EASE_SHAPE_ELEMENT_GET_PRIVATE (self);
}


static void ease_shape_element_finalize (GObject* obj) {
	EaseShapeElement * self;
	self = EASE_SHAPE_ELEMENT (obj);
	_g_object_unref0 (self->priv->_background);
	G_OBJECT_CLASS (ease_shape_element_parent_class)->finalize (obj);
}


GType ease_shape_element_get_type (void) {
	static volatile gsize ease_shape_element_type_id__volatile = 0;
	if (g_once_init_enter (&ease_shape_element_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseShapeElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_shape_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseShapeElement), 0, (GInstanceInitFunc) ease_shape_element_instance_init, NULL };
		GType ease_shape_element_type_id;
		ease_shape_element_type_id = g_type_register_static (EASE_TYPE_CAIRO_ELEMENT, "EaseShapeElement", &g_define_type_info, 0);
		g_once_init_leave (&ease_shape_element_type_id__volatile, ease_shape_element_type_id);
	}
	return ease_shape_element_type_id__volatile;
}


static void ease_shape_element_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseShapeElement * self;
	self = EASE_SHAPE_ELEMENT (object);
	switch (property_id) {
		case EASE_SHAPE_ELEMENT_SHAPE_TYPE:
		g_value_set_enum (value, ease_shape_element_get_shape_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_shape_element_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseShapeElement * self;
	self = EASE_SHAPE_ELEMENT (object);
	switch (property_id) {
		case EASE_SHAPE_ELEMENT_SHAPE_TYPE:
		ease_shape_element_set_shape_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


#line 186 "ease-shape-element.vala"
EaseShapeType ease_shape_type_from_string (const char* str) {
#line 732 "ease-shape-element.c"
	EaseShapeType result = 0;
	GQuark _tmp1_;
	const char* _tmp0_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
#line 186 "ease-shape-element.vala"
	g_return_val_if_fail (str != NULL, 0);
#line 740 "ease-shape-element.c"
	_tmp0_ = str;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("EASE_SHAPE_TYPE_RECTANGLE"))))
	switch (0) {
		default:
		{
			result = EASE_SHAPE_TYPE_RECTANGLE;
#line 191 "ease-shape-element.vala"
			return result;
#line 750 "ease-shape-element.c"
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("EASE_SHAPE_TYPE_OVAL"))))
	switch (0) {
		default:
		{
			result = EASE_SHAPE_TYPE_OVAL;
#line 193 "ease-shape-element.vala"
			return result;
#line 759 "ease-shape-element.c"
		}
	} else
	switch (0) {
		default:
		{
#line 195 "ease-shape-element.vala"
			g_critical ("ease-shape-element.vala:195: Invalid shape type: %s", str);
#line 767 "ease-shape-element.c"
			result = EASE_SHAPE_TYPE_RECTANGLE;
#line 196 "ease-shape-element.vala"
			return result;
#line 771 "ease-shape-element.c"
		}
	}
}


GType ease_shape_type_get_type (void) {
	static volatile gsize ease_shape_type_type_id__volatile = 0;
	if (g_once_init_enter (&ease_shape_type_type_id__volatile)) {
		static const GEnumValue values[] = {{EASE_SHAPE_TYPE_RECTANGLE, "EASE_SHAPE_TYPE_RECTANGLE", "rectangle"}, {EASE_SHAPE_TYPE_OVAL, "EASE_SHAPE_TYPE_OVAL", "oval"}, {0, NULL, NULL}};
		GType ease_shape_type_type_id;
		ease_shape_type_type_id = g_enum_register_static ("EaseShapeType", values);
		g_once_init_leave (&ease_shape_type_type_id__volatile, ease_shape_type_type_id);
	}
	return ease_shape_type_type_id__volatile;
}




