/* ease-background.c generated by valac, the Vala compiler
 * generated from ease-background.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <glib/gi18n-lib.h>


#define EASE_TYPE_BACKGROUND (ease_background_get_type ())
#define EASE_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_BACKGROUND, EaseBackground))
#define EASE_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_BACKGROUND, EaseBackgroundClass))
#define EASE_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_BACKGROUND))
#define EASE_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_BACKGROUND))
#define EASE_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_BACKGROUND, EaseBackgroundClass))

typedef struct _EaseBackground EaseBackground;
typedef struct _EaseBackgroundClass EaseBackgroundClass;
typedef struct _EaseBackgroundPrivate EaseBackgroundPrivate;

#define EASE_TYPE_BACKGROUND_TYPE (ease_background_type_get_type ())

#define EASE_TYPE_COLOR (ease_color_get_type ())
#define EASE_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_COLOR, EaseColor))
#define EASE_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_COLOR, EaseColorClass))
#define EASE_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_COLOR))
#define EASE_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_COLOR))
#define EASE_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_COLOR, EaseColorClass))

typedef struct _EaseColor EaseColor;
typedef struct _EaseColorClass EaseColorClass;

#define EASE_TYPE_GRADIENT (ease_gradient_get_type ())
#define EASE_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_GRADIENT, EaseGradient))
#define EASE_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_GRADIENT, EaseGradientClass))
#define EASE_IS_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_GRADIENT))
#define EASE_IS_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_GRADIENT))
#define EASE_GRADIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_GRADIENT, EaseGradientClass))

typedef struct _EaseGradient EaseGradient;
typedef struct _EaseGradientClass EaseGradientClass;

#define EASE_TYPE_IMAGE (ease_image_get_type ())
#define EASE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_IMAGE, EaseImage))
#define EASE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_IMAGE, EaseImageClass))
#define EASE_IS_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_IMAGE))
#define EASE_IS_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_IMAGE))
#define EASE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_IMAGE, EaseImageClass))

typedef struct _EaseImage EaseImage;
typedef struct _EaseImageClass EaseImageClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define EASE_TYPE_IMAGE_FILL_TYPE (ease_image_fill_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define EASE_TYPE_UNDO_ITEM (ease_undo_item_get_type ())
#define EASE_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItem))
#define EASE_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))
#define EASE_IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ITEM))
#define EASE_IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ITEM))
#define EASE_UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))

typedef struct _EaseUndoItem EaseUndoItem;
typedef struct _EaseUndoItemClass EaseUndoItemClass;

struct _EaseBackground {
	GObject parent_instance;
	EaseBackgroundPrivate * priv;
};

struct _EaseBackgroundClass {
	GObjectClass parent_class;
};

typedef enum  {
	EASE_BACKGROUND_TYPE_COLOR,
	EASE_BACKGROUND_TYPE_GRADIENT,
	EASE_BACKGROUND_TYPE_IMAGE
} EaseBackgroundType;

struct _EaseBackgroundPrivate {
	EaseBackgroundType _background_type;
	EaseColor* _color;
	EaseGradient* _gradient;
	EaseImage* _image;
};

typedef enum  {
	EASE_IMAGE_FILL_TYPE_STRETCH,
	EASE_IMAGE_FILL_TYPE_ASPECT,
	EASE_IMAGE_FILL_TYPE_ORIGINAL
} EaseImageFillType;


static gpointer ease_background_parent_class = NULL;

GType ease_background_get_type (void) G_GNUC_CONST;
GType ease_background_type_get_type (void) G_GNUC_CONST;
GType ease_color_get_type (void) G_GNUC_CONST;
GType ease_gradient_get_type (void) G_GNUC_CONST;
GType ease_image_get_type (void) G_GNUC_CONST;
#define EASE_BACKGROUND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_BACKGROUND, EaseBackgroundPrivate))
enum  {
	EASE_BACKGROUND_DUMMY_PROPERTY,
	EASE_BACKGROUND_BACKGROUND_TYPE,
	EASE_BACKGROUND_COLOR,
	EASE_BACKGROUND_GRADIENT,
	EASE_BACKGROUND_IMAGE
};
EaseColor* ease_color_get_black (void);
EaseGradient* ease_gradient_get_default_background (void);
EaseImage* ease_image_new (void);
EaseImage* ease_image_construct (GType object_type);
EaseBackground* ease_background_new (void);
EaseBackground* ease_background_construct (GType object_type);
EaseColor* ease_color_get_white (void);
void ease_background_set_color (EaseBackground* self, EaseColor* value);
void ease_background_set_gradient (EaseBackground* self, EaseGradient* value);
void ease_background_set_background_type (EaseBackground* self, EaseBackgroundType value);
EaseBackground* ease_background_new_default_gradient (void);
EaseBackground* ease_background_construct_default_gradient (GType object_type);
#define EASE_THEME_BACKGROUND_IMAGE "background-image"
void ease_image_set_filename (EaseImage* self, const char* value);
EaseImage* ease_background_get_image (EaseBackground* self);
#define EASE_THEME_BACKGROUND_IMAGE_SOURCE "background-image-source"
void ease_image_set_source (EaseImage* self, const char* value);
GType ease_image_fill_type_get_type (void) G_GNUC_CONST;
EaseImageFillType ease_image_fill_type_from_string (const char* str);
#define EASE_THEME_BACKGROUND_IMAGE_FILL "background-image-fill"
void ease_image_set_fill (EaseImage* self, EaseImageFillType value);
#define EASE_THEME_BACKGROUND_COLOR "background-color"
EaseColor* ease_color_new_from_string (const char* str);
EaseColor* ease_color_construct_from_string (GType object_type, const char* str);
#define EASE_THEME_BACKGROUND_GRADIENT "background-gradient"
EaseGradient* ease_gradient_new_from_string (const char* str);
EaseGradient* ease_gradient_construct_from_string (GType object_type, const char* str);
EaseBackgroundType ease_background_type_from_string (const char* str);
#define EASE_THEME_BACKGROUND_TYPE "background-type"
EaseBackground* ease_background_new_from_json (JsonObject* obj);
EaseBackground* ease_background_construct_from_json (GType object_type, JsonObject* obj);
const char* ease_image_get_filename (EaseImage* self);
EaseImageFillType ease_image_get_fill (EaseImage* self);
char* ease_image_fill_type_to_string (EaseImageFillType self);
const char* ease_image_get_source (EaseImage* self);
EaseColor* ease_background_get_color (EaseBackground* self);
char* ease_color_to_string (EaseColor* self);
EaseGradient* ease_background_get_gradient (EaseBackground* self);
char* ease_gradient_to_string (EaseGradient* self);
EaseBackgroundType ease_background_get_background_type (EaseBackground* self);
char* ease_background_type_to_string (EaseBackgroundType self);
void ease_background_to_json (EaseBackground* self, JsonObject** obj);
void ease_color_set_cairo (EaseColor* self, cairo_t* cr);
void ease_gradient_set_cairo (EaseGradient* self, cairo_t* cr, gint width, gint height);
void ease_image_set_cairo (EaseImage* self, cairo_t* cr, gint width, gint height, const char* path);
void ease_background_set_cairo (EaseBackground* self, cairo_t* cr, gint width, gint height, const char* path);
GType ease_undo_item_get_type (void) G_GNUC_CONST;
gboolean ease_undo_item_contains (EaseUndoItem* self, GObject* obj);
EaseColor* ease_gradient_get_start (EaseGradient* self);
EaseColor* ease_gradient_get_end (EaseGradient* self);
gboolean ease_background_owns_undoitem (EaseBackground* self, EaseUndoItem* item);
void ease_background_set_image (EaseBackground* self, EaseImage* value);
static void ease_background_finalize (GObject* obj);
static void ease_background_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_background_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define EASE_THEME_BACKGROUND_TYPE_COLOR "background-type-color"
#define EASE_THEME_BACKGROUND_TYPE_GRADIENT "background-type-gradient"
#define EASE_THEME_BACKGROUND_TYPE_IMAGE "background-type-image"
char* ease_background_type_description (EaseBackgroundType self);

const EaseBackgroundType EASE_BACKGROUND_TYPE_TYPES[3] = {EASE_BACKGROUND_TYPE_COLOR, EASE_BACKGROUND_TYPE_GRADIENT, EASE_BACKGROUND_TYPE_IMAGE};


#line 63 "ease-background.vala"
EaseBackground* ease_background_construct (GType object_type) {
#line 197 "ease-background.c"
	EaseBackground * self;
#line 63 "ease-background.vala"
	self = (EaseBackground*) g_object_new (object_type, NULL);
#line 201 "ease-background.c"
	return self;
}


#line 63 "ease-background.vala"
EaseBackground* ease_background_new (void) {
#line 63 "ease-background.vala"
	return ease_background_construct (EASE_TYPE_BACKGROUND);
#line 210 "ease-background.c"
}


#line 68 "ease-background.vala"
EaseBackground* ease_background_construct_default_gradient (GType object_type) {
#line 216 "ease-background.c"
	EaseBackground * self;
	EaseColor* _tmp0_;
	EaseGradient* _tmp1_;
#line 68 "ease-background.vala"
	self = (EaseBackground*) g_object_new (object_type, NULL);
#line 70 "ease-background.vala"
	ease_background_set_color (self, _tmp0_ = ease_color_get_white ());
#line 224 "ease-background.c"
	_g_object_unref0 (_tmp0_);
#line 71 "ease-background.vala"
	ease_background_set_gradient (self, _tmp1_ = ease_gradient_get_default_background ());
#line 228 "ease-background.c"
	_g_object_unref0 (_tmp1_);
#line 72 "ease-background.vala"
	ease_background_set_background_type (self, EASE_BACKGROUND_TYPE_GRADIENT);
#line 232 "ease-background.c"
	return self;
}


#line 68 "ease-background.vala"
EaseBackground* ease_background_new_default_gradient (void) {
#line 68 "ease-background.vala"
	return ease_background_construct_default_gradient (EASE_TYPE_BACKGROUND);
#line 241 "ease-background.c"
}


#line 78 "ease-background.vala"
EaseBackground* ease_background_construct_from_json (GType object_type, JsonObject* obj) {
#line 247 "ease-background.c"
	EaseBackground * self;
#line 78 "ease-background.vala"
	g_return_val_if_fail (obj != NULL, NULL);
#line 78 "ease-background.vala"
	self = (EaseBackground*) g_object_new (object_type, NULL);
#line 80 "ease-background.vala"
	if (json_object_has_member (obj, EASE_THEME_BACKGROUND_IMAGE)) {
#line 82 "ease-background.vala"
		ease_image_set_filename (self->priv->_image, json_object_get_string_member (obj, EASE_THEME_BACKGROUND_IMAGE));
#line 83 "ease-background.vala"
		ease_image_set_source (self->priv->_image, json_object_get_string_member (obj, EASE_THEME_BACKGROUND_IMAGE_SOURCE));
#line 85 "ease-background.vala"
		ease_image_set_fill (self->priv->_image, ease_image_fill_type_from_string (json_object_get_string_member (obj, EASE_THEME_BACKGROUND_IMAGE_FILL)));
#line 261 "ease-background.c"
	}
#line 88 "ease-background.vala"
	if (json_object_has_member (obj, EASE_THEME_BACKGROUND_COLOR)) {
#line 265 "ease-background.c"
		EaseColor* _tmp0_;
#line 90 "ease-background.vala"
		ease_background_set_color (self, _tmp0_ = ease_color_new_from_string (json_object_get_string_member (obj, EASE_THEME_BACKGROUND_COLOR)));
#line 269 "ease-background.c"
		_g_object_unref0 (_tmp0_);
	}
#line 93 "ease-background.vala"
	if (json_object_has_member (obj, EASE_THEME_BACKGROUND_GRADIENT)) {
#line 274 "ease-background.c"
		EaseGradient* _tmp1_;
#line 95 "ease-background.vala"
		ease_background_set_gradient (self, _tmp1_ = ease_gradient_new_from_string (json_object_get_string_member (obj, EASE_THEME_BACKGROUND_GRADIENT)));
#line 278 "ease-background.c"
		_g_object_unref0 (_tmp1_);
	}
#line 98 "ease-background.vala"
	ease_background_set_background_type (self, ease_background_type_from_string (json_object_get_string_member (obj, EASE_THEME_BACKGROUND_TYPE)));
#line 283 "ease-background.c"
	return self;
}


#line 78 "ease-background.vala"
EaseBackground* ease_background_new_from_json (JsonObject* obj) {
#line 78 "ease-background.vala"
	return ease_background_construct_from_json (EASE_TYPE_BACKGROUND, obj);
#line 292 "ease-background.c"
}


#line 105 "ease-background.vala"
void ease_background_to_json (EaseBackground* self, JsonObject** obj) {
#line 298 "ease-background.c"
	char* _tmp3_;
#line 105 "ease-background.vala"
	g_return_if_fail (self != NULL);
#line 105 "ease-background.vala"
	g_return_if_fail (obj != NULL);
#line 107 "ease-background.vala"
	if (self->priv->_image != NULL) {
#line 306 "ease-background.c"
		char* _tmp0_;
#line 109 "ease-background.vala"
		json_object_set_string_member (*obj, EASE_THEME_BACKGROUND_IMAGE, ease_image_get_filename (self->priv->_image));
#line 110 "ease-background.vala"
		json_object_set_string_member (*obj, EASE_THEME_BACKGROUND_IMAGE_FILL, _tmp0_ = ease_image_fill_type_to_string (ease_image_get_fill (self->priv->_image)));
#line 312 "ease-background.c"
		_g_free0 (_tmp0_);
#line 112 "ease-background.vala"
		json_object_set_string_member (*obj, EASE_THEME_BACKGROUND_IMAGE_SOURCE, ease_image_get_source (self->priv->_image));
#line 316 "ease-background.c"
	}
#line 115 "ease-background.vala"
	if (self->priv->_color != NULL) {
#line 320 "ease-background.c"
		char* _tmp1_;
#line 117 "ease-background.vala"
		json_object_set_string_member (*obj, EASE_THEME_BACKGROUND_COLOR, _tmp1_ = ease_color_to_string (self->priv->_color));
#line 324 "ease-background.c"
		_g_free0 (_tmp1_);
	}
#line 119 "ease-background.vala"
	if (self->priv->_gradient != NULL) {
#line 329 "ease-background.c"
		char* _tmp2_;
#line 121 "ease-background.vala"
		json_object_set_string_member (*obj, EASE_THEME_BACKGROUND_GRADIENT, _tmp2_ = ease_gradient_to_string (self->priv->_gradient));
#line 333 "ease-background.c"
		_g_free0 (_tmp2_);
	}
#line 124 "ease-background.vala"
	json_object_set_string_member (*obj, EASE_THEME_BACKGROUND_TYPE, _tmp3_ = ease_background_type_to_string (self->priv->_background_type));
#line 338 "ease-background.c"
	_g_free0 (_tmp3_);
}


#line 136 "ease-background.vala"
void ease_background_set_cairo (EaseBackground* self, cairo_t* cr, gint width, gint height, const char* path) {
#line 136 "ease-background.vala"
	g_return_if_fail (self != NULL);
#line 136 "ease-background.vala"
	g_return_if_fail (cr != NULL);
#line 136 "ease-background.vala"
	g_return_if_fail (path != NULL);
#line 138 "ease-background.vala"
	switch (self->priv->_background_type) {
#line 353 "ease-background.c"
		case EASE_BACKGROUND_TYPE_COLOR:
		{
#line 141 "ease-background.vala"
			ease_color_set_cairo (self->priv->_color, cr);
#line 142 "ease-background.vala"
			break;
#line 360 "ease-background.c"
		}
		case EASE_BACKGROUND_TYPE_GRADIENT:
		{
#line 144 "ease-background.vala"
			ease_gradient_set_cairo (self->priv->_gradient, cr, width, height);
#line 145 "ease-background.vala"
			break;
#line 368 "ease-background.c"
		}
		case EASE_BACKGROUND_TYPE_IMAGE:
		{
#line 147 "ease-background.vala"
			ease_image_set_cairo (self->priv->_image, cr, width, height, path);
#line 148 "ease-background.vala"
			break;
#line 376 "ease-background.c"
		}
	}
}


#line 153 "ease-background.vala"
gboolean ease_background_owns_undoitem (EaseBackground* self, EaseUndoItem* item) {
#line 384 "ease-background.c"
	gboolean result = FALSE;
#line 153 "ease-background.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 153 "ease-background.vala"
	g_return_val_if_fail (item != NULL, FALSE);
#line 155 "ease-background.vala"
	if (ease_undo_item_contains (item, (GObject*) self)) {
#line 392 "ease-background.c"
		result = TRUE;
#line 155 "ease-background.vala"
		return result;
#line 396 "ease-background.c"
	}
#line 156 "ease-background.vala"
	if (ease_undo_item_contains (item, (GObject*) self->priv->_color)) {
#line 400 "ease-background.c"
		result = TRUE;
#line 156 "ease-background.vala"
		return result;
#line 404 "ease-background.c"
	}
#line 157 "ease-background.vala"
	if (ease_undo_item_contains (item, (GObject*) ease_gradient_get_start (self->priv->_gradient))) {
#line 408 "ease-background.c"
		result = TRUE;
#line 157 "ease-background.vala"
		return result;
#line 412 "ease-background.c"
	}
#line 158 "ease-background.vala"
	if (ease_undo_item_contains (item, (GObject*) ease_gradient_get_end (self->priv->_gradient))) {
#line 416 "ease-background.c"
		result = TRUE;
#line 158 "ease-background.vala"
		return result;
#line 420 "ease-background.c"
	}
#line 159 "ease-background.vala"
	if (ease_undo_item_contains (item, (GObject*) self->priv->_gradient)) {
#line 424 "ease-background.c"
		result = TRUE;
#line 159 "ease-background.vala"
		return result;
#line 428 "ease-background.c"
	}
#line 160 "ease-background.vala"
	if (ease_undo_item_contains (item, (GObject*) self->priv->_image)) {
#line 432 "ease-background.c"
		result = TRUE;
#line 160 "ease-background.vala"
		return result;
#line 436 "ease-background.c"
	}
	result = FALSE;
#line 161 "ease-background.vala"
	return result;
#line 441 "ease-background.c"
}


EaseBackgroundType ease_background_get_background_type (EaseBackground* self) {
	EaseBackgroundType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_background_type;
#line 27 "ease-background.vala"
	return result;
#line 451 "ease-background.c"
}


void ease_background_set_background_type (EaseBackground* self, EaseBackgroundType value) {
	g_return_if_fail (self != NULL);
	self->priv->_background_type = value;
	g_object_notify ((GObject *) self, "background-type");
}


EaseColor* ease_background_get_color (EaseBackground* self) {
	EaseColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_color;
#line 36 "ease-background.vala"
	return result;
#line 468 "ease-background.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void ease_background_set_color (EaseBackground* self, EaseColor* value) {
	EaseColor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_color = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_color), _tmp0_);
	g_object_notify ((GObject *) self, "color");
}


EaseGradient* ease_background_get_gradient (EaseBackground* self) {
	EaseGradient* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_gradient;
#line 44 "ease-background.vala"
	return result;
#line 491 "ease-background.c"
}


void ease_background_set_gradient (EaseBackground* self, EaseGradient* value) {
	EaseGradient* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_gradient = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_gradient), _tmp0_);
	g_object_notify ((GObject *) self, "gradient");
}


EaseImage* ease_background_get_image (EaseBackground* self) {
	EaseImage* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_image;
#line 53 "ease-background.vala"
	return result;
#line 509 "ease-background.c"
}


void ease_background_set_image (EaseBackground* self, EaseImage* value) {
	EaseImage* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_image = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_image), _tmp0_);
	g_object_notify ((GObject *) self, "image");
}


static void ease_background_class_init (EaseBackgroundClass * klass) {
	ease_background_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseBackgroundPrivate));
	G_OBJECT_CLASS (klass)->get_property = ease_background_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_background_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_background_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_BACKGROUND_BACKGROUND_TYPE, g_param_spec_enum ("background-type", "background-type", "background-type", EASE_TYPE_BACKGROUND_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_BACKGROUND_COLOR, g_param_spec_object ("color", "color", "color", EASE_TYPE_COLOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_BACKGROUND_GRADIENT, g_param_spec_object ("gradient", "gradient", "gradient", EASE_TYPE_GRADIENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_BACKGROUND_IMAGE, g_param_spec_object ("image", "image", "image", EASE_TYPE_IMAGE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("image_added", EASE_TYPE_BACKGROUND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void ease_background_instance_init (EaseBackground * self) {
	self->priv = EASE_BACKGROUND_GET_PRIVATE (self);
	self->priv->_color = ease_color_get_black ();
	self->priv->_gradient = ease_gradient_get_default_background ();
	self->priv->_image = ease_image_new ();
}


static void ease_background_finalize (GObject* obj) {
	EaseBackground * self;
	self = EASE_BACKGROUND (obj);
	_g_object_unref0 (self->priv->_color);
	_g_object_unref0 (self->priv->_gradient);
	_g_object_unref0 (self->priv->_image);
	G_OBJECT_CLASS (ease_background_parent_class)->finalize (obj);
}


GType ease_background_get_type (void) {
	static volatile gsize ease_background_type_id__volatile = 0;
	if (g_once_init_enter (&ease_background_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseBackgroundClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_background_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseBackground), 0, (GInstanceInitFunc) ease_background_instance_init, NULL };
		GType ease_background_type_id;
		ease_background_type_id = g_type_register_static (G_TYPE_OBJECT, "EaseBackground", &g_define_type_info, 0);
		g_once_init_leave (&ease_background_type_id__volatile, ease_background_type_id);
	}
	return ease_background_type_id__volatile;
}


static void ease_background_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseBackground * self;
	self = EASE_BACKGROUND (object);
	switch (property_id) {
		case EASE_BACKGROUND_BACKGROUND_TYPE:
		g_value_set_enum (value, ease_background_get_background_type (self));
		break;
		case EASE_BACKGROUND_COLOR:
		g_value_set_object (value, ease_background_get_color (self));
		break;
		case EASE_BACKGROUND_GRADIENT:
		g_value_set_object (value, ease_background_get_gradient (self));
		break;
		case EASE_BACKGROUND_IMAGE:
		g_value_set_object (value, ease_background_get_image (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_background_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseBackground * self;
	self = EASE_BACKGROUND (object);
	switch (property_id) {
		case EASE_BACKGROUND_BACKGROUND_TYPE:
		ease_background_set_background_type (self, g_value_get_enum (value));
		break;
		case EASE_BACKGROUND_COLOR:
		ease_background_set_color (self, g_value_get_object (value));
		break;
		case EASE_BACKGROUND_GRADIENT:
		ease_background_set_gradient (self, g_value_get_object (value));
		break;
		case EASE_BACKGROUND_IMAGE:
		ease_background_set_image (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


#line 176 "ease-background.vala"
char* ease_background_type_to_string (EaseBackgroundType self) {
#line 613 "ease-background.c"
	char* result = NULL;
#line 178 "ease-background.vala"
	switch (self) {
#line 617 "ease-background.c"
		case EASE_BACKGROUND_TYPE_COLOR:
		{
			result = g_strdup (EASE_THEME_BACKGROUND_TYPE_COLOR);
#line 180 "ease-background.vala"
			return result;
#line 623 "ease-background.c"
		}
		case EASE_BACKGROUND_TYPE_GRADIENT:
		{
			result = g_strdup (EASE_THEME_BACKGROUND_TYPE_GRADIENT);
#line 181 "ease-background.vala"
			return result;
#line 630 "ease-background.c"
		}
		case EASE_BACKGROUND_TYPE_IMAGE:
		{
			result = g_strdup (EASE_THEME_BACKGROUND_TYPE_IMAGE);
#line 182 "ease-background.vala"
			return result;
#line 637 "ease-background.c"
		}
	}
	result = g_strdup ("undefined");
#line 184 "ease-background.vala"
	return result;
#line 643 "ease-background.c"
}


#line 190 "ease-background.vala"
EaseBackgroundType ease_background_type_from_string (const char* str) {
#line 649 "ease-background.c"
	EaseBackgroundType result = 0;
	GQuark _tmp1_;
	const char* _tmp0_;
#line 190 "ease-background.vala"
	g_return_val_if_fail (str != NULL, 0);
#line 655 "ease-background.c"
	_tmp0_ = str;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == g_quark_from_string (EASE_THEME_BACKGROUND_TYPE_COLOR))
	switch (0) {
		default:
		{
			result = EASE_BACKGROUND_TYPE_COLOR;
#line 194 "ease-background.vala"
			return result;
#line 665 "ease-background.c"
		}
	} else if (_tmp1_ == g_quark_from_string (EASE_THEME_BACKGROUND_TYPE_GRADIENT))
	switch (0) {
		default:
		{
			result = EASE_BACKGROUND_TYPE_GRADIENT;
#line 195 "ease-background.vala"
			return result;
#line 674 "ease-background.c"
		}
	} else if (_tmp1_ == g_quark_from_string (EASE_THEME_BACKGROUND_TYPE_IMAGE))
	switch (0) {
		default:
		{
			result = EASE_BACKGROUND_TYPE_IMAGE;
#line 196 "ease-background.vala"
			return result;
#line 683 "ease-background.c"
		}
	}
#line 199 "ease-background.vala"
	g_warning ("ease-background.vala:199: %s is not a gradient type", str);
#line 688 "ease-background.c"
	result = EASE_BACKGROUND_TYPE_COLOR;
#line 200 "ease-background.vala"
	return result;
#line 692 "ease-background.c"
}


#line 206 "ease-background.vala"
char* ease_background_type_description (EaseBackgroundType self) {
#line 698 "ease-background.c"
	char* result = NULL;
#line 208 "ease-background.vala"
	switch (self) {
#line 702 "ease-background.c"
		case EASE_BACKGROUND_TYPE_COLOR:
		{
			result = g_strdup (_ ("Solid Color"));
#line 210 "ease-background.vala"
			return result;
#line 708 "ease-background.c"
		}
		case EASE_BACKGROUND_TYPE_GRADIENT:
		{
			result = g_strdup (_ ("Gradient"));
#line 211 "ease-background.vala"
			return result;
#line 715 "ease-background.c"
		}
		case EASE_BACKGROUND_TYPE_IMAGE:
		{
			result = g_strdup (_ ("Image"));
#line 212 "ease-background.vala"
			return result;
#line 722 "ease-background.c"
		}
	}
	result = g_strdup ("undefined");
#line 214 "ease-background.vala"
	return result;
#line 728 "ease-background.c"
}


GType ease_background_type_get_type (void) {
	static volatile gsize ease_background_type_type_id__volatile = 0;
	if (g_once_init_enter (&ease_background_type_type_id__volatile)) {
		static const GEnumValue values[] = {{EASE_BACKGROUND_TYPE_COLOR, "EASE_BACKGROUND_TYPE_COLOR", "color"}, {EASE_BACKGROUND_TYPE_GRADIENT, "EASE_BACKGROUND_TYPE_GRADIENT", "gradient"}, {EASE_BACKGROUND_TYPE_IMAGE, "EASE_BACKGROUND_TYPE_IMAGE", "image"}, {0, NULL, NULL}};
		GType ease_background_type_type_id;
		ease_background_type_type_id = g_enum_register_static ("EaseBackgroundType", values);
		g_once_init_leave (&ease_background_type_type_id__volatile, ease_background_type_type_id);
	}
	return ease_background_type_type_id__volatile;
}




