/* ease-dialog-progress.c generated by valac, the Vala compiler
 * generated from ease-dialog-progress.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>


#define EASE_DIALOG_TYPE_PROGRESS (ease_dialog_progress_get_type ())
#define EASE_DIALOG_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_DIALOG_TYPE_PROGRESS, EaseDialogProgress))
#define EASE_DIALOG_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_DIALOG_TYPE_PROGRESS, EaseDialogProgressClass))
#define EASE_DIALOG_IS_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_DIALOG_TYPE_PROGRESS))
#define EASE_DIALOG_IS_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_DIALOG_TYPE_PROGRESS))
#define EASE_DIALOG_PROGRESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_DIALOG_TYPE_PROGRESS, EaseDialogProgressClass))

typedef struct _EaseDialogProgress EaseDialogProgress;
typedef struct _EaseDialogProgressClass EaseDialogProgressClass;
typedef struct _EaseDialogProgressPrivate EaseDialogProgressPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _EaseDialogProgress {
	GObject parent_instance;
	EaseDialogProgressPrivate * priv;
};

struct _EaseDialogProgressClass {
	GObjectClass parent_class;
};

struct _EaseDialogProgressPrivate {
	GtkDialog* dialog;
	GtkButton* cancel;
	GtkLabel* label;
	GtkProgressBar* progress;
	double max_val;
	gboolean destroyed;
};


static gpointer ease_dialog_progress_parent_class = NULL;

GType ease_dialog_progress_get_type (void) G_GNUC_CONST;
#define EASE_DIALOG_PROGRESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_DIALOG_TYPE_PROGRESS, EaseDialogProgressPrivate))
enum  {
	EASE_DIALOG_PROGRESS_DUMMY_PROPERTY
};
#define EASE_DIALOG_PROGRESS_UI_FILE "progress-dialog.ui"
char* ease_data_path (const char* path);
#define EASE_TEMP_UI_DIR "ui"
EaseDialogProgress* ease_dialog_progress_new (const char* title, gboolean cancellable, double max, GtkWindow* modal);
EaseDialogProgress* ease_dialog_progress_construct (GType object_type, const char* title, gboolean cancellable, double max, GtkWindow* modal);
void ease_dialog_progress_show (EaseDialogProgress* self);
void ease_dialog_progress_destroy (EaseDialogProgress* self);
void ease_dialog_progress_set_label (EaseDialogProgress* self, const char* str);
void ease_dialog_progress_set (EaseDialogProgress* self, double val);
void ease_dialog_progress_set_fraction (EaseDialogProgress* self, double val);
void ease_dialog_progress_add (EaseDialogProgress* self, double val);
void ease_dialog_progress_add_fraction (EaseDialogProgress* self, double val);
static void ease_dialog_progress_finalize (GObject* obj);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 43 "ease-dialog-progress.vala"
EaseDialogProgress* ease_dialog_progress_construct (GType object_type, const char* title, gboolean cancellable, double max, GtkWindow* modal) {
#line 94 "ease-dialog-progress.c"
	GError * _inner_error_;
	EaseDialogProgress * self;
	GtkBuilder* builder;
	GtkDialog* _tmp3_;
	GObject* _tmp2_;
	GtkButton* _tmp5_;
	GObject* _tmp4_;
	GtkLabel* _tmp7_;
	GObject* _tmp6_;
	GtkProgressBar* _tmp9_;
	GObject* _tmp8_;
#line 43 "ease-dialog-progress.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 108 "ease-dialog-progress.c"
	_inner_error_ = NULL;
#line 43 "ease-dialog-progress.vala"
	self = (EaseDialogProgress*) g_object_new (object_type, NULL);
#line 46 "ease-dialog-progress.vala"
	self->priv->max_val = max;
#line 48 "ease-dialog-progress.vala"
	builder = gtk_builder_new ();
#line 116 "ease-dialog-progress.c"
	{
		char* _tmp1_;
		char* _tmp0_;
#line 51 "ease-dialog-progress.vala"
		gtk_builder_add_from_file (builder, _tmp1_ = ease_data_path (_tmp0_ = g_build_filename (EASE_TEMP_UI_DIR, EASE_DIALOG_PROGRESS_UI_FILE, NULL)), &_inner_error_);
#line 122 "ease-dialog-progress.c"
		_g_free0 (_tmp1_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 54 "ease-dialog-progress.vala"
			g_error ("ease-dialog-progress.vala:54: Error loading UI: %s", e->message);
#line 138 "ease-dialog-progress.c"
			_g_error_free0 (e);
		}
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 57 "ease-dialog-progress.vala"
	self->priv->dialog = (_tmp3_ = _g_object_ref0 ((_tmp2_ = gtk_builder_get_object (builder, "dialog"), GTK_IS_DIALOG (_tmp2_) ? ((GtkDialog*) _tmp2_) : NULL)), _g_object_unref0 (self->priv->dialog), _tmp3_);
#line 58 "ease-dialog-progress.vala"
	self->priv->cancel = (_tmp5_ = _g_object_ref0 ((_tmp4_ = gtk_builder_get_object (builder, "cancel"), GTK_IS_BUTTON (_tmp4_) ? ((GtkButton*) _tmp4_) : NULL)), _g_object_unref0 (self->priv->cancel), _tmp5_);
#line 59 "ease-dialog-progress.vala"
	self->priv->label = (_tmp7_ = _g_object_ref0 ((_tmp6_ = gtk_builder_get_object (builder, "label"), GTK_IS_LABEL (_tmp6_) ? ((GtkLabel*) _tmp6_) : NULL)), _g_object_unref0 (self->priv->label), _tmp7_);
#line 60 "ease-dialog-progress.vala"
	self->priv->progress = (_tmp9_ = _g_object_ref0 ((_tmp8_ = gtk_builder_get_object (builder, "progress"), GTK_IS_PROGRESS_BAR (_tmp8_) ? ((GtkProgressBar*) _tmp8_) : NULL)), _g_object_unref0 (self->priv->progress), _tmp9_);
#line 63 "ease-dialog-progress.vala"
	gtk_window_set_title ((GtkWindow*) self->priv->dialog, title);
#line 64 "ease-dialog-progress.vala"
	gtk_widget_set_visible ((GtkWidget*) self->priv->cancel, cancellable);
#line 161 "ease-dialog-progress.c"
	_g_object_unref0 (builder);
	return self;
}


#line 43 "ease-dialog-progress.vala"
EaseDialogProgress* ease_dialog_progress_new (const char* title, gboolean cancellable, double max, GtkWindow* modal) {
#line 43 "ease-dialog-progress.vala"
	return ease_dialog_progress_construct (EASE_DIALOG_TYPE_PROGRESS, title, cancellable, max, modal);
#line 171 "ease-dialog-progress.c"
}


#line 70 "ease-dialog-progress.vala"
void ease_dialog_progress_show (EaseDialogProgress* self) {
#line 70 "ease-dialog-progress.vala"
	g_return_if_fail (self != NULL);
#line 74 "ease-dialog-progress.vala"
	if (!self->priv->destroyed) {
#line 74 "ease-dialog-progress.vala"
		gtk_widget_show_now ((GtkWidget*) self->priv->dialog);
#line 183 "ease-dialog-progress.c"
	}
}


#line 80 "ease-dialog-progress.vala"
void ease_dialog_progress_destroy (EaseDialogProgress* self) {
#line 80 "ease-dialog-progress.vala"
	g_return_if_fail (self != NULL);
#line 82 "ease-dialog-progress.vala"
	self->priv->destroyed = TRUE;
#line 83 "ease-dialog-progress.vala"
	gtk_object_destroy ((GtkObject*) self->priv->dialog);
#line 196 "ease-dialog-progress.c"
}


#line 89 "ease-dialog-progress.vala"
void ease_dialog_progress_set_label (EaseDialogProgress* self, const char* str) {
#line 89 "ease-dialog-progress.vala"
	g_return_if_fail (self != NULL);
#line 91 "ease-dialog-progress.vala"
	if (str == NULL) {
#line 93 "ease-dialog-progress.vala"
		gtk_widget_hide ((GtkWidget*) self->priv->label);
#line 94 "ease-dialog-progress.vala"
		return;
#line 210 "ease-dialog-progress.c"
	}
#line 96 "ease-dialog-progress.vala"
	gtk_label_set_markup (self->priv->label, str);
#line 97 "ease-dialog-progress.vala"
	gtk_widget_show_all ((GtkWidget*) self->priv->label);
#line 216 "ease-dialog-progress.c"
}


#line 104 "ease-dialog-progress.vala"
void ease_dialog_progress_set (EaseDialogProgress* self, double val) {
#line 104 "ease-dialog-progress.vala"
	g_return_if_fail (self != NULL);
#line 106 "ease-dialog-progress.vala"
	gtk_progress_bar_set_fraction (self->priv->progress, val / self->priv->max_val);
#line 226 "ease-dialog-progress.c"
}


#line 112 "ease-dialog-progress.vala"
void ease_dialog_progress_set_fraction (EaseDialogProgress* self, double val) {
#line 112 "ease-dialog-progress.vala"
	g_return_if_fail (self != NULL);
#line 114 "ease-dialog-progress.vala"
	gtk_progress_bar_set_fraction (self->priv->progress, val);
#line 236 "ease-dialog-progress.c"
}


#line 121 "ease-dialog-progress.vala"
void ease_dialog_progress_add (EaseDialogProgress* self, double val) {
#line 121 "ease-dialog-progress.vala"
	g_return_if_fail (self != NULL);
#line 123 "ease-dialog-progress.vala"
	gtk_progress_bar_set_fraction (self->priv->progress, gtk_progress_bar_get_fraction (self->priv->progress) + (val / self->priv->max_val));
#line 246 "ease-dialog-progress.c"
}


#line 129 "ease-dialog-progress.vala"
void ease_dialog_progress_add_fraction (EaseDialogProgress* self, double val) {
#line 129 "ease-dialog-progress.vala"
	g_return_if_fail (self != NULL);
#line 131 "ease-dialog-progress.vala"
	gtk_progress_bar_set_fraction (self->priv->progress, gtk_progress_bar_get_fraction (self->priv->progress) + val);
#line 256 "ease-dialog-progress.c"
}


static void ease_dialog_progress_class_init (EaseDialogProgressClass * klass) {
	ease_dialog_progress_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseDialogProgressPrivate));
	G_OBJECT_CLASS (klass)->finalize = ease_dialog_progress_finalize;
}


static void ease_dialog_progress_instance_init (EaseDialogProgress * self) {
	self->priv = EASE_DIALOG_PROGRESS_GET_PRIVATE (self);
	self->priv->destroyed = FALSE;
}


static void ease_dialog_progress_finalize (GObject* obj) {
	EaseDialogProgress * self;
	self = EASE_DIALOG_PROGRESS (obj);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->cancel);
	_g_object_unref0 (self->priv->label);
	_g_object_unref0 (self->priv->progress);
	G_OBJECT_CLASS (ease_dialog_progress_parent_class)->finalize (obj);
}


GType ease_dialog_progress_get_type (void) {
	static volatile gsize ease_dialog_progress_type_id__volatile = 0;
	if (g_once_init_enter (&ease_dialog_progress_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseDialogProgressClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_dialog_progress_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseDialogProgress), 0, (GInstanceInitFunc) ease_dialog_progress_instance_init, NULL };
		GType ease_dialog_progress_type_id;
		ease_dialog_progress_type_id = g_type_register_static (G_TYPE_OBJECT, "EaseDialogProgress", &g_define_type_info, 0);
		g_once_init_leave (&ease_dialog_progress_type_id__volatile, ease_dialog_progress_type_id);
	}
	return ease_dialog_progress_type_id__volatile;
}




