/* ease-welcome-window.c generated by valac, the Vala compiler
 * generated from ease-welcome-window.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <ease-core.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gdk/gdk.h>


#define EASE_TYPE_WELCOME_WINDOW (ease_welcome_window_get_type ())
#define EASE_WELCOME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_WELCOME_WINDOW, EaseWelcomeWindow))
#define EASE_WELCOME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_WELCOME_WINDOW, EaseWelcomeWindowClass))
#define EASE_IS_WELCOME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_WELCOME_WINDOW))
#define EASE_IS_WELCOME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_WELCOME_WINDOW))
#define EASE_WELCOME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_WELCOME_WINDOW, EaseWelcomeWindowClass))

typedef struct _EaseWelcomeWindow EaseWelcomeWindow;
typedef struct _EaseWelcomeWindowClass EaseWelcomeWindowClass;
typedef struct _EaseWelcomeWindowPrivate EaseWelcomeWindowPrivate;

#define EASE_TYPE_SCROLLABLE_EMBED (ease_scrollable_embed_get_type ())
#define EASE_SCROLLABLE_EMBED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbed))
#define EASE_SCROLLABLE_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbedClass))
#define EASE_IS_SCROLLABLE_EMBED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SCROLLABLE_EMBED))
#define EASE_IS_SCROLLABLE_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SCROLLABLE_EMBED))
#define EASE_SCROLLABLE_EMBED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbedClass))

typedef struct _EaseScrollableEmbed EaseScrollableEmbed;
typedef struct _EaseScrollableEmbedClass EaseScrollableEmbedClass;

#define EASE_TYPE_WELCOME_ACTOR (ease_welcome_actor_get_type ())
#define EASE_WELCOME_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_WELCOME_ACTOR, EaseWelcomeActor))
#define EASE_WELCOME_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_WELCOME_ACTOR, EaseWelcomeActorClass))
#define EASE_IS_WELCOME_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_WELCOME_ACTOR))
#define EASE_IS_WELCOME_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_WELCOME_ACTOR))
#define EASE_WELCOME_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_WELCOME_ACTOR, EaseWelcomeActorClass))

typedef struct _EaseWelcomeActor EaseWelcomeActor;
typedef struct _EaseWelcomeActorClass EaseWelcomeActorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

struct _EaseWelcomeWindow {
	GtkWindow parent_instance;
	EaseWelcomeWindowPrivate * priv;
};

struct _EaseWelcomeWindowClass {
	GtkWindowClass parent_class;
};

struct _EaseWelcomeWindowPrivate {
	GtkButton* new_pres_button;
	GtkButton* open_pres_button;
	GtkComboBox* combores;
	GtkSpinButton* x_res;
	GtkSpinButton* y_res;
	GeeArrayList* themes;
	EaseTheme* selected_theme;
	EaseScrollableEmbed* embed;
	ClutterGroup* preview_container;
	ClutterRectangle* preview_background;
	GeeArrayList* previews;
	gint preview_width;
	float preview_aspect;
	gint preview_row_count;
	gboolean animate_resize;
	ClutterTimeline* animate_alarm;
	GeeArrayList* x_anims;
	GeeArrayList* y_anims;
	EaseZoomSlider* zoom_slider;
	gint* ZOOM_VALUES;
	gint ZOOM_VALUES_length1;
	gint _ZOOM_VALUES_size_;
};


static gpointer ease_welcome_window_parent_class = NULL;

GType ease_welcome_window_get_type (void) G_GNUC_CONST;
GType ease_scrollable_embed_get_type (void) G_GNUC_CONST;
GType ease_welcome_actor_get_type (void) G_GNUC_CONST;
#define EASE_WELCOME_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_WELCOME_WINDOW, EaseWelcomeWindowPrivate))
enum  {
	EASE_WELCOME_WINDOW_DUMMY_PROPERTY
};
#define EASE_WELCOME_WINDOW_PREVIEW_PADDING 20
#define EASE_WELCOME_WINDOW_PREVIEW_VERT_PADDING 35
#define EASE_WELCOME_WINDOW_DEFAULT_ACTIVE 2
#define EASE_WELCOME_WINDOW_ANIM_TIME 300
#define EASE_WELCOME_WINDOW_ANIM_EASE ((gint) CLUTTER_EASE_IN_OUT_SINE)
#define EASE_WELCOME_WINDOW_SLIDER_START 190
#define EASE_WELCOME_WINDOW_PREVIEW_ID EASE_THEME_TITLE
static void ease_welcome_window_reflow_previews (EaseWelcomeWindow* self);
static void _lambda58_ (EaseWelcomeWindow* self);
static void __lambda58__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void ease_welcome_window_set_resolution_box (EaseWelcomeWindow* self, gint width, gint height);
void ease_welcome_actor_set_slide_size (EaseWelcomeActor* self, gint w, gint h);
static void _lambda60_ (EaseWelcomeWindow* self);
static void __lambda60__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void _lambda61_ (EaseWelcomeWindow* self);
static void __lambda61__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
EaseScrollableEmbed* ease_scrollable_embed_new (gboolean horizontal, gboolean has_frame);
EaseScrollableEmbed* ease_scrollable_embed_construct (GType object_type, gboolean horizontal, gboolean has_frame);
ClutterStage* ease_scrollable_embed_get_stage (EaseScrollableEmbed* self);
EaseWelcomeActor* ease_welcome_actor_new (EaseTheme* t);
EaseWelcomeActor* ease_welcome_actor_construct (GType object_type, EaseTheme* t);
EaseTheme* ease_welcome_actor_get_theme (EaseWelcomeActor* self);
void ease_welcome_actor_fade (EaseWelcomeActor* self);
void ease_welcome_actor_unfade (EaseWelcomeActor* self);
static void _lambda62_ (EaseWelcomeActor* sender, EaseWelcomeWindow* self);
static void __lambda62__ease_welcome_actor_selected (EaseWelcomeActor* _sender, EaseWelcomeActor* sender, gpointer self);
void ease_welcome_window_create_new_document (GtkWidget* sender, EaseWelcomeWindow* self);
static void _lambda63_ (EaseWelcomeActor* sender, EaseWelcomeWindow* self);
static void __lambda63__ease_welcome_actor_double_click (EaseWelcomeActor* _sender, EaseWelcomeActor* sender, gpointer self);
ClutterGroup* ease_scrollable_embed_get_contents (EaseScrollableEmbed* self);
static void _lambda65_ (EaseWelcomeWindow* self);
static void __lambda65__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self);
static void _lambda66_ (EaseWelcomeWindow* self);
static void __lambda66__ease_zoom_slider_value_changed (EaseZoomSlider* _sender, gpointer self);
EaseWelcomeWindow* ease_welcome_window_new (void);
EaseWelcomeWindow* ease_welcome_window_construct (GType object_type);
void ease_main_open_file (const char* path);
void ease_welcome_window_on_open_pres_button_clicked (GtkWidget* sender, EaseWelcomeWindow* self);
void ease_main_new_from_theme (EaseTheme* theme, gint width, gint height);
float ease_scrollable_embed_get_width (EaseScrollableEmbed* self);
static void _lambda59_ (EaseWelcomeWindow* self);
static void __lambda59__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
void ease_welcome_actor_set_actor_size (EaseWelcomeActor* self, float w, float h);
float ease_scrollable_embed_get_height (EaseScrollableEmbed* self);
static void ease_welcome_window_finalize (GObject* obj);
static gint _vala_array_length (gpointer array);

static const gint EASE_WELCOME_WINDOW_RESOLUTIONS_X[6] = {640, 800, 1024, 1280, 1280, 1920};
static const gint EASE_WELCOME_WINDOW_RESOLUTIONS_Y[6] = {480, 600, 768, 1024, 720, 1080};


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 127 "ease-welcome-window.vala"
static void _lambda58_ (EaseWelcomeWindow* self) {
#line 174 "ease-welcome-window.c"
	gint val;
#line 129 "ease-welcome-window.vala"
	val = gtk_combo_box_get_active (self->priv->combores);
#line 130 "ease-welcome-window.vala"
	if (val > 0) {
#line 131 "ease-welcome-window.vala"
		gtk_spin_button_set_value (self->priv->x_res, (double) EASE_WELCOME_WINDOW_RESOLUTIONS_X[val - 1]);
#line 132 "ease-welcome-window.vala"
		gtk_spin_button_set_value (self->priv->y_res, (double) EASE_WELCOME_WINDOW_RESOLUTIONS_Y[val - 1]);
#line 184 "ease-welcome-window.c"
	}
#line 134 "ease-welcome-window.vala"
	ease_welcome_window_reflow_previews (self);
#line 188 "ease-welcome-window.c"
}


#line 127 "ease-welcome-window.vala"
static void __lambda58__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 194 "ease-welcome-window.c"
	_lambda58_ (self);
}


#line 151 "ease-welcome-window.vala"
static void _lambda60_ (EaseWelcomeWindow* self) {
#line 152 "ease-welcome-window.vala"
	ease_welcome_window_set_resolution_box (self, (gint) gtk_spin_button_get_value (self->priv->x_res), (gint) gtk_spin_button_get_value (self->priv->y_res));
#line 203 "ease-welcome-window.c"
	{
		GeeIterator* _p_it;
#line 154 "ease-welcome-window.vala"
		_p_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->previews);
#line 154 "ease-welcome-window.vala"
		while (TRUE) {
#line 210 "ease-welcome-window.c"
			EaseWelcomeActor* p;
#line 154 "ease-welcome-window.vala"
			if (!gee_iterator_next (_p_it)) {
#line 154 "ease-welcome-window.vala"
				break;
#line 216 "ease-welcome-window.c"
			}
#line 154 "ease-welcome-window.vala"
			p = (EaseWelcomeActor*) gee_iterator_get (_p_it);
#line 156 "ease-welcome-window.vala"
			ease_welcome_actor_set_slide_size (p, (gint) gtk_spin_button_get_value (self->priv->x_res), (gint) gtk_spin_button_get_value (self->priv->y_res));
#line 222 "ease-welcome-window.c"
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
}


#line 151 "ease-welcome-window.vala"
static void __lambda60__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
#line 232 "ease-welcome-window.c"
	_lambda60_ (self);
}


#line 161 "ease-welcome-window.vala"
static void _lambda61_ (EaseWelcomeWindow* self) {
#line 162 "ease-welcome-window.vala"
	ease_welcome_window_set_resolution_box (self, (gint) gtk_spin_button_get_value (self->priv->x_res), (gint) gtk_spin_button_get_value (self->priv->y_res));
#line 241 "ease-welcome-window.c"
	{
		GeeIterator* _p_it;
#line 164 "ease-welcome-window.vala"
		_p_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->previews);
#line 164 "ease-welcome-window.vala"
		while (TRUE) {
#line 248 "ease-welcome-window.c"
			EaseWelcomeActor* p;
#line 164 "ease-welcome-window.vala"
			if (!gee_iterator_next (_p_it)) {
#line 164 "ease-welcome-window.vala"
				break;
#line 254 "ease-welcome-window.c"
			}
#line 164 "ease-welcome-window.vala"
			p = (EaseWelcomeActor*) gee_iterator_get (_p_it);
#line 166 "ease-welcome-window.vala"
			ease_welcome_actor_set_slide_size (p, (gint) gtk_spin_button_get_value (self->priv->x_res), (gint) gtk_spin_button_get_value (self->priv->y_res));
#line 260 "ease-welcome-window.c"
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
}


#line 161 "ease-welcome-window.vala"
static void __lambda61__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
#line 270 "ease-welcome-window.c"
	_lambda61_ (self);
}


#line 220 "ease-welcome-window.vala"
static void _lambda62_ (EaseWelcomeActor* sender, EaseWelcomeWindow* self) {
#line 277 "ease-welcome-window.c"
	EaseTheme* _tmp1_;
	EaseWelcomeActor* _tmp0_;
#line 220 "ease-welcome-window.vala"
	g_return_if_fail (sender != NULL);
#line 221 "ease-welcome-window.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->new_pres_button, TRUE);
#line 222 "ease-welcome-window.vala"
	self->priv->selected_theme = (_tmp1_ = _g_object_ref0 (ease_welcome_actor_get_theme ((_tmp0_ = sender, EASE_IS_WELCOME_ACTOR (_tmp0_) ? ((EaseWelcomeActor*) _tmp0_) : NULL))), _g_object_unref0 (self->priv->selected_theme), _tmp1_);
#line 286 "ease-welcome-window.c"
	{
		GeeIterator* _t_it;
#line 224 "ease-welcome-window.vala"
		_t_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->previews);
#line 224 "ease-welcome-window.vala"
		while (TRUE) {
#line 293 "ease-welcome-window.c"
			EaseWelcomeActor* t;
#line 224 "ease-welcome-window.vala"
			if (!gee_iterator_next (_t_it)) {
#line 224 "ease-welcome-window.vala"
				break;
#line 299 "ease-welcome-window.c"
			}
#line 224 "ease-welcome-window.vala"
			t = (EaseWelcomeActor*) gee_iterator_get (_t_it);
#line 226 "ease-welcome-window.vala"
			if (t != sender) {
#line 226 "ease-welcome-window.vala"
				ease_welcome_actor_fade (t);
#line 307 "ease-welcome-window.c"
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_it);
	}
#line 228 "ease-welcome-window.vala"
	ease_welcome_actor_unfade (sender);
#line 315 "ease-welcome-window.c"
}


#line 220 "ease-welcome-window.vala"
static void __lambda62__ease_welcome_actor_selected (EaseWelcomeActor* _sender, EaseWelcomeActor* sender, gpointer self) {
#line 321 "ease-welcome-window.c"
	_lambda62_ (sender, self);
}


#line 232 "ease-welcome-window.vala"
static void _lambda63_ (EaseWelcomeActor* sender, EaseWelcomeWindow* self) {
#line 328 "ease-welcome-window.c"
	EaseTheme* _tmp1_;
	EaseWelcomeActor* _tmp0_;
#line 232 "ease-welcome-window.vala"
	g_return_if_fail (sender != NULL);
#line 233 "ease-welcome-window.vala"
	self->priv->selected_theme = (_tmp1_ = _g_object_ref0 (ease_welcome_actor_get_theme ((_tmp0_ = sender, EASE_IS_WELCOME_ACTOR (_tmp0_) ? ((EaseWelcomeActor*) _tmp0_) : NULL))), _g_object_unref0 (self->priv->selected_theme), _tmp1_);
#line 234 "ease-welcome-window.vala"
	ease_welcome_window_create_new_document (NULL, self);
#line 337 "ease-welcome-window.c"
}


#line 232 "ease-welcome-window.vala"
static void __lambda63__ease_welcome_actor_double_click (EaseWelcomeActor* _sender, EaseWelcomeActor* sender, gpointer self) {
#line 343 "ease-welcome-window.c"
	_lambda63_ (sender, self);
}


#line 249 "ease-welcome-window.vala"
static void _lambda65_ (EaseWelcomeWindow* self) {
#line 251 "ease-welcome-window.vala"
	ease_welcome_window_reflow_previews (self);
#line 352 "ease-welcome-window.c"
}


#line 249 "ease-welcome-window.vala"
static void __lambda65__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self) {
#line 358 "ease-welcome-window.c"
	_lambda65_ (self);
}


#line 255 "ease-welcome-window.vala"
static void _lambda66_ (EaseWelcomeWindow* self) {
#line 257 "ease-welcome-window.vala"
	self->priv->preview_width = (gint) ease_zoom_slider_get_value (self->priv->zoom_slider);
#line 258 "ease-welcome-window.vala"
	ease_welcome_window_reflow_previews (self);
#line 369 "ease-welcome-window.c"
}


#line 255 "ease-welcome-window.vala"
static void __lambda66__ease_zoom_slider_value_changed (EaseZoomSlider* _sender, gpointer self) {
#line 375 "ease-welcome-window.c"
	_lambda66_ (self);
}


#line 86 "ease-welcome-window.vala"
EaseWelcomeWindow* ease_welcome_window_construct (GType object_type) {
#line 382 "ease-welcome-window.c"
	GError * _inner_error_;
	EaseWelcomeWindow * self;
	GtkBuilder* builder;
	GObject* _tmp2_;
	GtkVBox* vbox;
	GObject* _tmp3_;
	GtkHBox* hbox;
	GtkComboBox* _tmp5_;
	GObject* _tmp4_;
	GtkSpinButton* _tmp7_;
	GObject* _tmp6_;
	GtkSpinButton* _tmp9_;
	GObject* _tmp8_;
	GtkButton* _tmp11_;
	GObject* _tmp10_;
	GtkButton* _tmp13_;
	GObject* _tmp12_;
	EaseZoomSlider* _tmp15_;
	GtkAdjustment* _tmp14_;
	GtkComboBox* _tmp16_;
	gint resolution_count;
	GtkImage* _tmp19_;
	EaseScrollableEmbed* _tmp20_;
	ClutterStage* _tmp21_;
	ClutterGroup* _tmp22_;
	ClutterRectangle* _tmp25_;
	ClutterColor _tmp24_;
	ClutterColor _tmp23_ = {0};
	_inner_error_ = NULL;
	self = g_object_newv (object_type, 0, NULL);
#line 88 "ease-welcome-window.vala"
	g_assert (G_N_ELEMENTS (EASE_WELCOME_WINDOW_RESOLUTIONS_X) == G_N_ELEMENTS (EASE_WELCOME_WINDOW_RESOLUTIONS_Y));
#line 90 "ease-welcome-window.vala"
	gtk_window_set_title ((GtkWindow*) self, _ ("Pick a theme and start editing"));
#line 91 "ease-welcome-window.vala"
	gtk_window_set_default_size ((GtkWindow*) self, 640, 480);
#line 93 "ease-welcome-window.vala"
	builder = gtk_builder_new ();
#line 421 "ease-welcome-window.c"
	{
		char* _tmp0_;
		char* _tmp1_;
		char* ui_path;
#line 95 "ease-welcome-window.vala"
		ui_path = (_tmp1_ = ease_data_path (_tmp0_ = g_build_filename (EASE_TEMP_UI_DIR, "welcome-window.ui", NULL)), _g_free0 (_tmp0_), _tmp1_);
#line 97 "ease-welcome-window.vala"
		gtk_builder_add_from_file (builder, ui_path, &_inner_error_);
#line 430 "ease-welcome-window.c"
		if (_inner_error_ != NULL) {
			_g_free0 (ui_path);
			goto __catch16_g_error;
		}
		_g_free0 (ui_path);
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 99 "ease-welcome-window.vala"
			g_error ("ease-welcome-window.vala:99: Unable to load UI : %s", e->message);
#line 446 "ease-welcome-window.c"
			_g_error_free0 (e);
		}
	}
	__finally16:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 102 "ease-welcome-window.vala"
	vbox = _g_object_ref0 ((_tmp2_ = gtk_builder_get_object (builder, "vbox1"), GTK_IS_VBOX (_tmp2_) ? ((GtkVBox*) _tmp2_) : NULL));
#line 103 "ease-welcome-window.vala"
	hbox = _g_object_ref0 ((_tmp3_ = gtk_builder_get_object (builder, "hbox1"), GTK_IS_HBOX (_tmp3_) ? ((GtkHBox*) _tmp3_) : NULL));
#line 104 "ease-welcome-window.vala"
	self->priv->combores = (_tmp5_ = _g_object_ref0 ((_tmp4_ = gtk_builder_get_object (builder, "combo_resolution"), GTK_IS_COMBO_BOX (_tmp4_) ? ((GtkComboBox*) _tmp4_) : NULL)), _g_object_unref0 (self->priv->combores), _tmp5_);
#line 105 "ease-welcome-window.vala"
	self->priv->x_res = (_tmp7_ = _g_object_ref0 ((_tmp6_ = gtk_builder_get_object (builder, "horiz_spin"), GTK_IS_SPIN_BUTTON (_tmp6_) ? ((GtkSpinButton*) _tmp6_) : NULL)), _g_object_unref0 (self->priv->x_res), _tmp7_);
#line 106 "ease-welcome-window.vala"
	self->priv->y_res = (_tmp9_ = _g_object_ref0 ((_tmp8_ = gtk_builder_get_object (builder, "vert_spin"), GTK_IS_SPIN_BUTTON (_tmp8_) ? ((GtkSpinButton*) _tmp8_) : NULL)), _g_object_unref0 (self->priv->y_res), _tmp9_);
#line 107 "ease-welcome-window.vala"
	self->priv->new_pres_button = (_tmp11_ = _g_object_ref0 ((_tmp10_ = gtk_builder_get_object (builder, "newpres"), GTK_IS_BUTTON (_tmp10_) ? ((GtkButton*) _tmp10_) : NULL)), _g_object_unref0 (self->priv->new_pres_button), _tmp11_);
#line 108 "ease-welcome-window.vala"
	self->priv->open_pres_button = (_tmp13_ = _g_object_ref0 ((_tmp12_ = gtk_builder_get_object (builder, "openpres"), GTK_IS_BUTTON (_tmp12_) ? ((GtkButton*) _tmp12_) : NULL)), _g_object_unref0 (self->priv->open_pres_button), _tmp13_);
#line 111 "ease-welcome-window.vala"
	self->priv->zoom_slider = (_tmp15_ = (EaseZoomSlider*) g_object_ref_sink (ease_animated_zoom_slider_new (_tmp14_ = g_object_ref_sink ((GtkAdjustment*) gtk_adjustment_new ((double) 100, (double) 100, (double) 400, (double) 10, (double) 50, (double) 50)), self->priv->ZOOM_VALUES, self->priv->ZOOM_VALUES_length1)), _g_object_unref0 (self->priv->zoom_slider), _tmp15_);
#line 473 "ease-welcome-window.c"
	_g_object_unref0 (_tmp14_);
#line 113 "ease-welcome-window.vala"
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->zoom_slider, TRUE, FALSE, (guint) 0);
#line 114 "ease-welcome-window.vala"
	gtk_box_reorder_child ((GtkBox*) hbox, (GtkWidget*) self->priv->zoom_slider, 4);
#line 115 "ease-welcome-window.vala"
	ease_zoom_slider_set_sliderpos (self->priv->zoom_slider, (double) EASE_WELCOME_WINDOW_SLIDER_START);
#line 119 "ease-welcome-window.vala"
	gtk_container_remove ((GtkContainer*) hbox, (GtkWidget*) self->priv->combores);
#line 120 "ease-welcome-window.vala"
	self->priv->combores = (_tmp16_ = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new_text ()), _g_object_unref0 (self->priv->combores), _tmp16_);
#line 121 "ease-welcome-window.vala"
	gtk_combo_box_insert_text (self->priv->combores, 0, _ ("Custom"));
#line 487 "ease-welcome-window.c"
	{
		gint i;
#line 122 "ease-welcome-window.vala"
		i = 0;
#line 492 "ease-welcome-window.c"
		{
			gboolean _tmp17_;
#line 122 "ease-welcome-window.vala"
			_tmp17_ = TRUE;
#line 122 "ease-welcome-window.vala"
			while (TRUE) {
#line 499 "ease-welcome-window.c"
				char* _tmp18_;
#line 122 "ease-welcome-window.vala"
				if (!_tmp17_) {
#line 122 "ease-welcome-window.vala"
					i++;
#line 505 "ease-welcome-window.c"
				}
#line 122 "ease-welcome-window.vala"
				_tmp17_ = FALSE;
#line 122 "ease-welcome-window.vala"
				if (!(i < G_N_ELEMENTS (EASE_WELCOME_WINDOW_RESOLUTIONS_X))) {
#line 122 "ease-welcome-window.vala"
					break;
#line 513 "ease-welcome-window.c"
				}
#line 123 "ease-welcome-window.vala"
				gtk_combo_box_append_text (self->priv->combores, _tmp18_ = g_strdup_printf (_ ("%i by %i"), EASE_WELCOME_WINDOW_RESOLUTIONS_X[i], EASE_WELCOME_WINDOW_RESOLUTIONS_Y[i]));
#line 517 "ease-welcome-window.c"
				_g_free0 (_tmp18_);
			}
		}
	}
#line 127 "ease-welcome-window.vala"
	g_signal_connect_object (self->priv->combores, "changed", (GCallback) __lambda58__gtk_combo_box_changed, self, 0);
#line 137 "ease-welcome-window.vala"
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->combores, TRUE, TRUE, 0);
#line 138 "ease-welcome-window.vala"
	gtk_box_reorder_child ((GtkBox*) hbox, (GtkWidget*) self->priv->combores, 0);
#line 144 "ease-welcome-window.vala"
	resolution_count = G_N_ELEMENTS (EASE_WELCOME_WINDOW_RESOLUTIONS_X);
#line 145 "ease-welcome-window.vala"
	gtk_spin_button_set_range (self->priv->x_res, (double) EASE_WELCOME_WINDOW_RESOLUTIONS_X[0], (double) EASE_WELCOME_WINDOW_RESOLUTIONS_X[resolution_count - 1]);
#line 148 "ease-welcome-window.vala"
	gtk_spin_button_set_range (self->priv->y_res, (double) EASE_WELCOME_WINDOW_RESOLUTIONS_Y[0], (double) EASE_WELCOME_WINDOW_RESOLUTIONS_Y[resolution_count - 1]);
#line 151 "ease-welcome-window.vala"
	g_signal_connect_object (self->priv->x_res, "value-changed", (GCallback) __lambda60__gtk_spin_button_value_changed, self, 0);
#line 161 "ease-welcome-window.vala"
	g_signal_connect_object (self->priv->y_res, "value-changed", (GCallback) __lambda61__gtk_spin_button_value_changed, self, 0);
#line 172 "ease-welcome-window.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->new_pres_button, FALSE);
#line 174 "ease-welcome-window.vala"
	gtk_button_set_image (self->priv->new_pres_button, (GtkWidget*) (_tmp19_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock ("gtk-new", GTK_ICON_SIZE_BUTTON))));
#line 542 "ease-welcome-window.c"
	_g_object_unref0 (_tmp19_);
#line 179 "ease-welcome-window.vala"
	self->priv->embed = (_tmp20_ = g_object_ref_sink (ease_scrollable_embed_new (FALSE, FALSE)), _g_object_unref0 (self->priv->embed), _tmp20_);
#line 180 "ease-welcome-window.vala"
	clutter_stage_set_use_fog (_tmp21_ = ease_scrollable_embed_get_stage (self->priv->embed), FALSE);
#line 548 "ease-welcome-window.c"
	_g_object_unref0 (_tmp21_);
#line 183 "ease-welcome-window.vala"
	self->priv->preview_container = (_tmp22_ = g_object_ref_sink ((ClutterGroup*) clutter_group_new ()), _g_object_unref0 (self->priv->preview_container), _tmp22_);
#line 186 "ease-welcome-window.vala"
	self->priv->preview_background = (_tmp25_ = g_object_ref_sink ((ClutterRectangle*) clutter_rectangle_new_with_color ((_tmp24_ = (clutter_color_from_string (&_tmp23_, "black"), _tmp23_), &_tmp24_))), _g_object_unref0 (self->priv->preview_background), _tmp25_);
#line 187 "ease-welcome-window.vala"
	clutter_container_add_actor ((ClutterContainer*) self->priv->preview_container, (ClutterActor*) self->priv->preview_background);
#line 556 "ease-welcome-window.c"
	{
		char** _tmp27_;
		gint _data_dirs_size_;
		gint data_dirs_length1;
		char** _tmp26_;
		char** data_dirs;
		data_dirs = (_tmp27_ = _tmp26_ = g_get_system_data_dirs (), data_dirs_length1 = _vala_array_length (_tmp26_), _data_dirs_size_ = data_dirs_length1, _tmp27_);
		{
			char** dir_collection;
			int dir_collection_length1;
			int dir_it;
#line 191 "ease-welcome-window.vala"
			dir_collection = data_dirs;
#line 570 "ease-welcome-window.c"
			dir_collection_length1 = data_dirs_length1;
			for (dir_it = 0; dir_it < data_dirs_length1; dir_it = dir_it + 1) {
				char* dir;
				dir = g_strdup (dir_collection[dir_it]);
				{
					char* filename;
					GFile* file;
#line 192 "ease-welcome-window.vala"
					filename = g_build_filename (dir, EASE_TEMP_TEMP_DIR, EASE_TEMP_THEME_DIR, NULL);
#line 195 "ease-welcome-window.vala"
					file = g_file_new_for_path (filename);
#line 197 "ease-welcome-window.vala"
					if (g_file_query_exists (file, NULL)) {
#line 584 "ease-welcome-window.c"
						GDir* directory;
						char* name;
#line 198 "ease-welcome-window.vala"
						directory = g_dir_open (filename, (guint) 0, &_inner_error_);
#line 589 "ease-welcome-window.c"
						if (_inner_error_ != NULL) {
							_g_object_unref0 (file);
							_g_free0 (filename);
							_g_free0 (dir);
							goto __catch17_g_error;
						}
#line 199 "ease-welcome-window.vala"
						name = g_strdup (g_dir_read_name (directory));
#line 200 "ease-welcome-window.vala"
						while (TRUE) {
#line 600 "ease-welcome-window.c"
							char* path;
							EaseTheme* _tmp28_;
							char* _tmp29_;
#line 200 "ease-welcome-window.vala"
							if (!(name != NULL)) {
#line 200 "ease-welcome-window.vala"
								break;
#line 608 "ease-welcome-window.c"
							}
#line 201 "ease-welcome-window.vala"
							path = g_build_filename (filename, name, NULL);
#line 202 "ease-welcome-window.vala"
							gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->themes, _tmp28_ = ease_theme_new (path));
#line 614 "ease-welcome-window.c"
							_g_object_unref0 (_tmp28_);
#line 203 "ease-welcome-window.vala"
							name = (_tmp29_ = g_strdup (g_dir_read_name (directory)), _g_free0 (name), _tmp29_);
#line 618 "ease-welcome-window.c"
							_g_free0 (path);
						}
						_g_free0 (name);
						_g_dir_close0 (directory);
					}
					_g_object_unref0 (file);
					_g_free0 (filename);
					_g_free0 (dir);
				}
			}
		}
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 208 "ease-welcome-window.vala"
			ease_error_dialog ("Error loading themes : %s", e->message);
#line 640 "ease-welcome-window.c"
			_g_error_free0 (e);
		}
	}
	__finally17:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (hbox);
		_g_object_unref0 (vbox);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		GeeIterator* _theme_it;
#line 212 "ease-welcome-window.vala"
		_theme_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->themes);
#line 212 "ease-welcome-window.vala"
		while (TRUE) {
#line 659 "ease-welcome-window.c"
			EaseTheme* theme;
			EaseWelcomeActor* act;
#line 212 "ease-welcome-window.vala"
			if (!gee_iterator_next (_theme_it)) {
#line 212 "ease-welcome-window.vala"
				break;
#line 666 "ease-welcome-window.c"
			}
#line 212 "ease-welcome-window.vala"
			theme = (EaseTheme*) gee_iterator_get (_theme_it);
#line 215 "ease-welcome-window.vala"
			act = g_object_ref_sink (ease_welcome_actor_new (theme));
#line 216 "ease-welcome-window.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->previews, act);
#line 217 "ease-welcome-window.vala"
			clutter_container_add_actor ((ClutterContainer*) self->priv->preview_container, (ClutterActor*) act);
#line 220 "ease-welcome-window.vala"
			g_signal_connect_object (act, "selected", (GCallback) __lambda62__ease_welcome_actor_selected, self, 0);
#line 232 "ease-welcome-window.vala"
			g_signal_connect_object (act, "double-click", (GCallback) __lambda63__ease_welcome_actor_double_click, self, 0);
#line 680 "ease-welcome-window.c"
			_g_object_unref0 (act);
			_g_object_unref0 (theme);
		}
		_g_object_unref0 (_theme_it);
	}
#line 238 "ease-welcome-window.vala"
	clutter_container_add_actor ((ClutterContainer*) ease_scrollable_embed_get_contents (self->priv->embed), (ClutterActor*) self->priv->preview_container);
#line 239 "ease-welcome-window.vala"
	clutter_actor_show_all ((ClutterActor*) ease_scrollable_embed_get_contents (self->priv->embed));
#line 240 "ease-welcome-window.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) self->priv->embed, TRUE, TRUE, (guint) 0);
#line 241 "ease-welcome-window.vala"
	gtk_box_reorder_child ((GtkBox*) vbox, (GtkWidget*) self->priv->embed, 0);
#line 243 "ease-welcome-window.vala"
	gtk_builder_connect_signals (builder, self);
#line 244 "ease-welcome-window.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) vbox);
#line 245 "ease-welcome-window.vala"
	gtk_widget_show_all ((GtkWidget*) self);
#line 249 "ease-welcome-window.vala"
	g_signal_connect_object ((GtkWidget*) self->priv->embed, "size-allocate", (GCallback) __lambda65__gtk_widget_size_allocate, self, 0);
#line 255 "ease-welcome-window.vala"
	g_signal_connect_object (self->priv->zoom_slider, "value-changed", (GCallback) __lambda66__ease_zoom_slider_value_changed, self, 0);
#line 261 "ease-welcome-window.vala"
	gtk_combo_box_set_active (self->priv->combores, EASE_WELCOME_WINDOW_DEFAULT_ACTIVE + 1);
#line 262 "ease-welcome-window.vala"
	self->priv->preview_width = (gint) ease_zoom_slider_get_value (self->priv->zoom_slider);
#line 265 "ease-welcome-window.vala"
	self->priv->preview_row_count = -1;
#line 266 "ease-welcome-window.vala"
	ease_welcome_window_reflow_previews (self);
#line 712 "ease-welcome-window.c"
	_g_object_unref0 (builder);
	_g_object_unref0 (vbox);
	_g_object_unref0 (hbox);
	return self;
}


#line 86 "ease-welcome-window.vala"
EaseWelcomeWindow* ease_welcome_window_new (void) {
#line 86 "ease-welcome-window.vala"
	return ease_welcome_window_construct (EASE_TYPE_WELCOME_WINDOW);
#line 724 "ease-welcome-window.c"
}


#line 270 "ease-welcome-window.vala"
void ease_welcome_window_on_open_pres_button_clicked (GtkWidget* sender, EaseWelcomeWindow* self) {
#line 730 "ease-welcome-window.c"
	char* filename;
#line 270 "ease-welcome-window.vala"
	g_return_if_fail (self != NULL);
#line 270 "ease-welcome-window.vala"
	g_return_if_fail (sender != NULL);
#line 272 "ease-welcome-window.vala"
	filename = ease_dialog_open_document ((GtkWindow*) self);
#line 273 "ease-welcome-window.vala"
	if (filename != NULL) {
#line 273 "ease-welcome-window.vala"
		ease_main_open_file (filename);
#line 742 "ease-welcome-window.c"
	}
#line 274 "ease-welcome-window.vala"
	gtk_widget_hide ((GtkWidget*) self);
#line 746 "ease-welcome-window.c"
	_g_free0 (filename);
}


#line 278 "ease-welcome-window.vala"
void ease_welcome_window_create_new_document (GtkWidget* sender, EaseWelcomeWindow* self) {
#line 278 "ease-welcome-window.vala"
	g_return_if_fail (self != NULL);
#line 280 "ease-welcome-window.vala"
	ease_main_new_from_theme (self->priv->selected_theme, (gint) gtk_spin_button_get_value (self->priv->x_res), (gint) gtk_spin_button_get_value (self->priv->y_res));
#line 283 "ease-welcome-window.vala"
	gtk_widget_hide ((GtkWidget*) self);
#line 759 "ease-welcome-window.c"
}


#line 286 "ease-welcome-window.vala"
static void ease_welcome_window_set_resolution_box (EaseWelcomeWindow* self, gint width, gint height) {
#line 286 "ease-welcome-window.vala"
	g_return_if_fail (self != NULL);
#line 767 "ease-welcome-window.c"
	{
		gint i;
#line 288 "ease-welcome-window.vala"
		i = 0;
#line 772 "ease-welcome-window.c"
		{
			gboolean _tmp0_;
#line 288 "ease-welcome-window.vala"
			_tmp0_ = TRUE;
#line 288 "ease-welcome-window.vala"
			while (TRUE) {
#line 779 "ease-welcome-window.c"
				gboolean _tmp1_ = FALSE;
#line 288 "ease-welcome-window.vala"
				if (!_tmp0_) {
#line 288 "ease-welcome-window.vala"
					i++;
#line 785 "ease-welcome-window.c"
				}
#line 288 "ease-welcome-window.vala"
				_tmp0_ = FALSE;
#line 288 "ease-welcome-window.vala"
				if (!(i < G_N_ELEMENTS (EASE_WELCOME_WINDOW_RESOLUTIONS_X))) {
#line 288 "ease-welcome-window.vala"
					break;
#line 793 "ease-welcome-window.c"
				}
#line 290 "ease-welcome-window.vala"
				if (width == EASE_WELCOME_WINDOW_RESOLUTIONS_X[i]) {
#line 290 "ease-welcome-window.vala"
					_tmp1_ = height == EASE_WELCOME_WINDOW_RESOLUTIONS_Y[i];
#line 799 "ease-welcome-window.c"
				} else {
#line 290 "ease-welcome-window.vala"
					_tmp1_ = FALSE;
#line 803 "ease-welcome-window.c"
				}
#line 290 "ease-welcome-window.vala"
				if (_tmp1_) {
#line 292 "ease-welcome-window.vala"
					gtk_combo_box_set_active (self->priv->combores, i + 1);
#line 293 "ease-welcome-window.vala"
					return;
#line 811 "ease-welcome-window.c"
				}
			}
		}
	}
#line 296 "ease-welcome-window.vala"
	gtk_combo_box_set_active (self->priv->combores, 0);
#line 297 "ease-welcome-window.vala"
	ease_welcome_window_reflow_previews (self);
#line 820 "ease-welcome-window.c"
}


#line 333 "ease-welcome-window.vala"
static void _lambda59_ (EaseWelcomeWindow* self) {
#line 826 "ease-welcome-window.c"
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
#line 334 "ease-welcome-window.vala"
	self->priv->animate_resize = FALSE;
#line 335 "ease-welcome-window.vala"
	self->priv->x_anims = (_tmp0_ = NULL, _g_object_unref0 (self->priv->x_anims), _tmp0_);
#line 336 "ease-welcome-window.vala"
	self->priv->y_anims = (_tmp1_ = NULL, _g_object_unref0 (self->priv->y_anims), _tmp1_);
#line 835 "ease-welcome-window.c"
}


#line 333 "ease-welcome-window.vala"
static void __lambda59__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 841 "ease-welcome-window.c"
	_lambda59_ (self);
}


#line 300 "ease-welcome-window.vala"
static void ease_welcome_window_reflow_previews (EaseWelcomeWindow* self) {
#line 848 "ease-welcome-window.c"
	gint per_line;
	float x_origin;
	float y_pixels;
	gint x_position;
	float _tmp13_ = 0.0F;
#line 300 "ease-welcome-window.vala"
	g_return_if_fail (self != NULL);
#line 303 "ease-welcome-window.vala"
	self->priv->preview_aspect = (float) (gtk_spin_button_get_value (self->priv->y_res) / gtk_spin_button_get_value (self->priv->x_res));
#line 306 "ease-welcome-window.vala"
	per_line = 2;
#line 860 "ease-welcome-window.c"
	{
		gboolean _tmp0_;
#line 307 "ease-welcome-window.vala"
		_tmp0_ = TRUE;
#line 307 "ease-welcome-window.vala"
		while (TRUE) {
#line 307 "ease-welcome-window.vala"
			if (!_tmp0_) {
#line 309 "ease-welcome-window.vala"
				per_line++;
#line 871 "ease-welcome-window.c"
			}
#line 307 "ease-welcome-window.vala"
			_tmp0_ = FALSE;
#line 307 "ease-welcome-window.vala"
			if (!(((per_line * (self->priv->preview_width + EASE_WELCOME_WINDOW_PREVIEW_PADDING)) + EASE_WELCOME_WINDOW_PREVIEW_PADDING) < ease_scrollable_embed_get_width (self->priv->embed))) {
#line 307 "ease-welcome-window.vala"
				break;
#line 879 "ease-welcome-window.c"
			}
			;
		}
	}
#line 310 "ease-welcome-window.vala"
	per_line--;
#line 313 "ease-welcome-window.vala"
	if (self->priv->preview_row_count == (-1)) {
#line 315 "ease-welcome-window.vala"
		self->priv->preview_row_count = per_line;
#line 890 "ease-welcome-window.c"
	}
#line 319 "ease-welcome-window.vala"
	if (self->priv->preview_row_count != per_line) {
#line 894 "ease-welcome-window.c"
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		ClutterTimeline* _tmp3_;
#line 321 "ease-welcome-window.vala"
		self->priv->preview_row_count = per_line;
#line 322 "ease-welcome-window.vala"
		self->priv->animate_resize = TRUE;
#line 324 "ease-welcome-window.vala"
		if (self->priv->animate_alarm != NULL) {
#line 325 "ease-welcome-window.vala"
			clutter_timeline_stop (self->priv->animate_alarm);
#line 906 "ease-welcome-window.c"
		}
#line 328 "ease-welcome-window.vala"
		self->priv->x_anims = (_tmp1_ = gee_array_list_new (CLUTTER_TYPE_ANIMATION, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->priv->x_anims), _tmp1_);
#line 329 "ease-welcome-window.vala"
		self->priv->y_anims = (_tmp2_ = gee_array_list_new (CLUTTER_TYPE_ANIMATION, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->priv->y_anims), _tmp2_);
#line 331 "ease-welcome-window.vala"
		self->priv->animate_alarm = (_tmp3_ = clutter_timeline_new ((guint) EASE_WELCOME_WINDOW_ANIM_TIME), _g_object_unref0 (self->priv->animate_alarm), _tmp3_);
#line 332 "ease-welcome-window.vala"
		clutter_timeline_start (self->priv->animate_alarm);
#line 333 "ease-welcome-window.vala"
		g_signal_connect_object (self->priv->animate_alarm, "completed", (GCallback) __lambda59__clutter_timeline_completed, self, 0);
#line 918 "ease-welcome-window.c"
	}
#line 341 "ease-welcome-window.vala"
	x_origin = (ease_scrollable_embed_get_width (self->priv->embed) / 2) - (((self->priv->preview_width * per_line) + (EASE_WELCOME_WINDOW_PREVIEW_PADDING * (per_line - 1))) / 2);
#line 345 "ease-welcome-window.vala"
	y_pixels = (float) EASE_WELCOME_WINDOW_PREVIEW_PADDING;
#line 348 "ease-welcome-window.vala"
	x_position = 0;
#line 926 "ease-welcome-window.c"
	{
		gint i;
#line 351 "ease-welcome-window.vala"
		i = 0;
#line 931 "ease-welcome-window.c"
		{
			gboolean _tmp4_;
#line 351 "ease-welcome-window.vala"
			_tmp4_ = TRUE;
#line 351 "ease-welcome-window.vala"
			while (TRUE) {
#line 938 "ease-welcome-window.c"
				EaseWelcomeActor* a;
				float x_pixels;
				float x_round;
				float y_round;
#line 351 "ease-welcome-window.vala"
				if (!_tmp4_) {
#line 351 "ease-welcome-window.vala"
					i++;
#line 947 "ease-welcome-window.c"
				}
#line 351 "ease-welcome-window.vala"
				_tmp4_ = FALSE;
#line 351 "ease-welcome-window.vala"
				if (!(i < gee_collection_get_size ((GeeCollection*) self->priv->previews))) {
#line 351 "ease-welcome-window.vala"
					break;
#line 955 "ease-welcome-window.c"
				}
#line 354 "ease-welcome-window.vala"
				a = (EaseWelcomeActor*) gee_abstract_list_get ((GeeAbstractList*) self->priv->previews, i);
#line 356 "ease-welcome-window.vala"
				if (a == NULL) {
#line 961 "ease-welcome-window.c"
					_g_object_unref0 (a);
#line 358 "ease-welcome-window.vala"
					continue;
#line 965 "ease-welcome-window.c"
				}
#line 362 "ease-welcome-window.vala"
				x_pixels = x_origin + (x_position * (EASE_WELCOME_WINDOW_PREVIEW_PADDING + self->priv->preview_width));
#line 365 "ease-welcome-window.vala"
				x_round = (float) ease_roundd ((double) x_pixels);
#line 366 "ease-welcome-window.vala"
				y_round = (float) ease_roundd ((double) y_pixels);
#line 368 "ease-welcome-window.vala"
				if (self->priv->animate_resize) {
#line 371 "ease-welcome-window.vala"
					if (gee_collection_get_size ((GeeCollection*) self->priv->x_anims) == i) {
#line 373 "ease-welcome-window.vala"
						gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->x_anims, clutter_actor_animate ((ClutterActor*) a, (gulong) EASE_WELCOME_WINDOW_ANIM_EASE, (guint) EASE_WELCOME_WINDOW_ANIM_TIME, "x", x_round, NULL));
#line 374 "ease-welcome-window.vala"
						gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->y_anims, clutter_actor_animate ((ClutterActor*) a, (gulong) EASE_WELCOME_WINDOW_ANIM_EASE, (guint) EASE_WELCOME_WINDOW_ANIM_TIME, "y", y_round, NULL));
#line 981 "ease-welcome-window.c"
					} else {
						ClutterAnimation* _tmp5_;
						ClutterAnimation* _tmp6_;
						GValue _tmp9_;
						GValue _tmp8_ = {0};
						ClutterAnimation* _tmp7_;
						GValue _tmp12_;
						GValue _tmp11_ = {0};
						ClutterAnimation* _tmp10_;
#line 380 "ease-welcome-window.vala"
						clutter_animation_unbind_property (_tmp5_ = (ClutterAnimation*) gee_abstract_list_get ((GeeAbstractList*) self->priv->x_anims, i), "x");
#line 993 "ease-welcome-window.c"
						_g_object_unref0 (_tmp5_);
#line 381 "ease-welcome-window.vala"
						clutter_animation_unbind_property (_tmp6_ = (ClutterAnimation*) gee_abstract_list_get ((GeeAbstractList*) self->priv->y_anims, i), "y");
#line 997 "ease-welcome-window.c"
						_g_object_unref0 (_tmp6_);
#line 383 "ease-welcome-window.vala"
						clutter_animation_bind (_tmp7_ = (ClutterAnimation*) gee_abstract_list_get ((GeeAbstractList*) self->priv->x_anims, i), "x", (_tmp9_ = (g_value_init (&_tmp8_, G_TYPE_FLOAT), g_value_set_float (&_tmp8_, x_round), _tmp8_), &_tmp9_));
#line 1001 "ease-welcome-window.c"
						_g_object_unref0 (_tmp7_);
#line 384 "ease-welcome-window.vala"
						clutter_animation_bind (_tmp10_ = (ClutterAnimation*) gee_abstract_list_get ((GeeAbstractList*) self->priv->y_anims, i), "y", (_tmp12_ = (g_value_init (&_tmp11_, G_TYPE_FLOAT), g_value_set_float (&_tmp11_, y_round), _tmp11_), &_tmp12_));
#line 1005 "ease-welcome-window.c"
						_g_object_unref0 (_tmp10_);
					}
				} else {
#line 390 "ease-welcome-window.vala"
					clutter_actor_set_x ((ClutterActor*) a, x_pixels);
#line 391 "ease-welcome-window.vala"
					clutter_actor_set_y ((ClutterActor*) a, y_pixels);
#line 1013 "ease-welcome-window.c"
				}
#line 395 "ease-welcome-window.vala"
				ease_welcome_actor_set_actor_size (a, (float) self->priv->preview_width, self->priv->preview_width * self->priv->preview_aspect);
#line 398 "ease-welcome-window.vala"
				if ((x_position = x_position + 1) >= per_line) {
#line 400 "ease-welcome-window.vala"
					x_position = 0;
#line 401 "ease-welcome-window.vala"
					y_pixels = y_pixels + (EASE_WELCOME_WINDOW_PREVIEW_VERT_PADDING + (self->priv->preview_width * self->priv->preview_aspect));
#line 1023 "ease-welcome-window.c"
				}
				_g_object_unref0 (a);
			}
		}
	}
#line 406 "ease-welcome-window.vala"
	clutter_actor_set_width ((ClutterActor*) self->priv->preview_background, ease_scrollable_embed_get_width (self->priv->embed));
#line 407 "ease-welcome-window.vala"
	if (x_position != 0) {
#line 408 "ease-welcome-window.vala"
		_tmp13_ = (y_pixels + (self->priv->preview_width * self->priv->preview_aspect)) + EASE_WELCOME_WINDOW_PREVIEW_VERT_PADDING;
#line 1035 "ease-welcome-window.c"
	} else {
#line 410 "ease-welcome-window.vala"
		_tmp13_ = y_pixels + EASE_WELCOME_WINDOW_PREVIEW_VERT_PADDING;
#line 1039 "ease-welcome-window.c"
	}
#line 407 "ease-welcome-window.vala"
	clutter_actor_set_height ((ClutterActor*) self->priv->preview_background, _tmp13_);
#line 413 "ease-welcome-window.vala"
	if (clutter_actor_get_height ((ClutterActor*) self->priv->preview_background) < ease_scrollable_embed_get_height (self->priv->embed)) {
#line 415 "ease-welcome-window.vala"
		clutter_actor_set_height ((ClutterActor*) self->priv->preview_background, ease_scrollable_embed_get_height (self->priv->embed));
#line 1047 "ease-welcome-window.c"
	}
}


static void ease_welcome_window_class_init (EaseWelcomeWindowClass * klass) {
	ease_welcome_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseWelcomeWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = ease_welcome_window_finalize;
}


static void ease_welcome_window_instance_init (EaseWelcomeWindow * self) {
	gint* _tmp0_ = NULL;
	self->priv = EASE_WELCOME_WINDOW_GET_PRIVATE (self);
	self->priv->themes = gee_array_list_new (EASE_TYPE_THEME, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	self->priv->previews = gee_array_list_new (EASE_TYPE_WELCOME_ACTOR, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	self->priv->preview_row_count = -1;
	self->priv->animate_resize = FALSE;
	self->priv->ZOOM_VALUES = (_tmp0_ = g_new0 (gint, 5), _tmp0_[0] = 100, _tmp0_[1] = 150, _tmp0_[2] = 200, _tmp0_[3] = 250, _tmp0_[4] = 400, _tmp0_);
	self->priv->ZOOM_VALUES_length1 = 5;
	self->priv->_ZOOM_VALUES_size_ = self->priv->ZOOM_VALUES_length1;
}


static void ease_welcome_window_finalize (GObject* obj) {
	EaseWelcomeWindow * self;
	self = EASE_WELCOME_WINDOW (obj);
	_g_object_unref0 (self->priv->new_pres_button);
	_g_object_unref0 (self->priv->open_pres_button);
	_g_object_unref0 (self->priv->combores);
	_g_object_unref0 (self->priv->x_res);
	_g_object_unref0 (self->priv->y_res);
	_g_object_unref0 (self->priv->themes);
	_g_object_unref0 (self->priv->selected_theme);
	_g_object_unref0 (self->priv->embed);
	_g_object_unref0 (self->priv->preview_container);
	_g_object_unref0 (self->priv->preview_background);
	_g_object_unref0 (self->priv->previews);
	_g_object_unref0 (self->priv->animate_alarm);
	_g_object_unref0 (self->priv->x_anims);
	_g_object_unref0 (self->priv->y_anims);
	_g_object_unref0 (self->priv->zoom_slider);
	self->priv->ZOOM_VALUES = (g_free (self->priv->ZOOM_VALUES), NULL);
	G_OBJECT_CLASS (ease_welcome_window_parent_class)->finalize (obj);
}


GType ease_welcome_window_get_type (void) {
	static volatile gsize ease_welcome_window_type_id__volatile = 0;
	if (g_once_init_enter (&ease_welcome_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseWelcomeWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_welcome_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseWelcomeWindow), 0, (GInstanceInitFunc) ease_welcome_window_instance_init, NULL };
		GType ease_welcome_window_type_id;
		ease_welcome_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "EaseWelcomeWindow", &g_define_type_info, 0);
		g_once_init_leave (&ease_welcome_window_type_id__volatile, ease_welcome_window_type_id);
	}
	return ease_welcome_window_type_id__volatile;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




