/* ease-slide.c generated by valac, the Vala compiler
 * generated from ease-slide.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <cairo.h>
#include <clutter/clutter.h>
#include <gtk/gtk.h>
#include <gobject/gvaluecollector.h>


#define EASE_TYPE_UNDO_SOURCE (ease_undo_source_get_type ())
#define EASE_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSource))
#define EASE_IS_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_SOURCE))
#define EASE_UNDO_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSourceIface))

typedef struct _EaseUndoSource EaseUndoSource;
typedef struct _EaseUndoSourceIface EaseUndoSourceIface;

#define EASE_TYPE_SLIDE (ease_slide_get_type ())
#define EASE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE, EaseSlide))
#define EASE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE, EaseSlideClass))
#define EASE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE))
#define EASE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE))
#define EASE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE, EaseSlideClass))

typedef struct _EaseSlide EaseSlide;
typedef struct _EaseSlideClass EaseSlideClass;
typedef struct _EaseSlidePrivate EaseSlidePrivate;

#define EASE_TYPE_ELEMENT (ease_element_get_type ())
#define EASE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT, EaseElement))
#define EASE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT, EaseElementClass))
#define EASE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT))
#define EASE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT))
#define EASE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT, EaseElementClass))

typedef struct _EaseElement EaseElement;
typedef struct _EaseElementClass EaseElementClass;

#define EASE_TYPE_TRANSITION (ease_transition_get_type ())

#define EASE_TYPE_TRANSITION_VARIANT (ease_transition_variant_get_type ())

#define EASE_TYPE_BACKGROUND (ease_background_get_type ())
#define EASE_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_BACKGROUND, EaseBackground))
#define EASE_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_BACKGROUND, EaseBackgroundClass))
#define EASE_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_BACKGROUND))
#define EASE_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_BACKGROUND))
#define EASE_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_BACKGROUND, EaseBackgroundClass))

typedef struct _EaseBackground EaseBackground;
typedef struct _EaseBackgroundClass EaseBackgroundClass;

#define EASE_TYPE_DOCUMENT (ease_document_get_type ())
#define EASE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_DOCUMENT, EaseDocument))
#define EASE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_DOCUMENT, EaseDocumentClass))
#define EASE_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_DOCUMENT))
#define EASE_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_DOCUMENT))
#define EASE_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_DOCUMENT, EaseDocumentClass))

typedef struct _EaseDocument EaseDocument;
typedef struct _EaseDocumentClass EaseDocumentClass;

#define EASE_TYPE_THEME (ease_theme_get_type ())
#define EASE_THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_THEME, EaseTheme))
#define EASE_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_THEME, EaseThemeClass))
#define EASE_IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_THEME))
#define EASE_IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_THEME))
#define EASE_THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_THEME, EaseThemeClass))

typedef struct _EaseTheme EaseTheme;
typedef struct _EaseThemeClass EaseThemeClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define EASE_TYPE_UNDO_ITEM (ease_undo_item_get_type ())
#define EASE_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItem))
#define EASE_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))
#define EASE_IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ITEM))
#define EASE_IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ITEM))
#define EASE_UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))

typedef struct _EaseUndoItem EaseUndoItem;
typedef struct _EaseUndoItemClass EaseUndoItemClass;

#define EASE_TYPE_UNDO_ACTION (ease_undo_action_get_type ())
#define EASE_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoAction))
#define EASE_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))
#define EASE_IS_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ACTION))
#define EASE_IS_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ACTION))
#define EASE_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))

typedef struct _EaseUndoAction EaseUndoAction;
typedef struct _EaseUndoActionClass EaseUndoActionClass;
typedef struct _EaseUndoItemPrivate EaseUndoItemPrivate;
typedef struct _EaseUndoActionPrivate EaseUndoActionPrivate;

#define EASE_UNDO_ACTION_TYPE_UNDO_PAIR (ease_undo_action_undo_pair_get_type ())
#define EASE_UNDO_ACTION_UNDO_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_UNDO_ACTION_TYPE_UNDO_PAIR, EaseUndoActionUndoPair))
#define EASE_UNDO_ACTION_UNDO_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_UNDO_ACTION_TYPE_UNDO_PAIR, EaseUndoActionUndoPairClass))
#define EASE_UNDO_ACTION_IS_UNDO_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_UNDO_ACTION_TYPE_UNDO_PAIR))
#define EASE_UNDO_ACTION_IS_UNDO_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_UNDO_ACTION_TYPE_UNDO_PAIR))
#define EASE_UNDO_ACTION_UNDO_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_UNDO_ACTION_TYPE_UNDO_PAIR, EaseUndoActionUndoPairClass))

typedef struct _EaseUndoActionUndoPair EaseUndoActionUndoPair;
typedef struct _EaseUndoActionUndoPairClass EaseUndoActionUndoPairClass;
typedef struct _EaseUndoActionUndoPairPrivate EaseUndoActionUndoPairPrivate;
#define _ease_undo_action_undo_pair_unref0(var) ((var == NULL) ? NULL : (var = (ease_undo_action_undo_pair_unref (var), NULL)))

#define EASE_TYPE_IMAGE (ease_image_get_type ())
#define EASE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_IMAGE, EaseImage))
#define EASE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_IMAGE, EaseImageClass))
#define EASE_IS_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_IMAGE))
#define EASE_IS_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_IMAGE))
#define EASE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_IMAGE, EaseImageClass))

typedef struct _EaseImage EaseImage;
typedef struct _EaseImageClass EaseImageClass;

#define EASE_TYPE_COLOR (ease_color_get_type ())
#define EASE_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_COLOR, EaseColor))
#define EASE_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_COLOR, EaseColorClass))
#define EASE_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_COLOR))
#define EASE_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_COLOR))
#define EASE_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_COLOR, EaseColorClass))

typedef struct _EaseColor EaseColor;
typedef struct _EaseColorClass EaseColorClass;

#define EASE_TYPE_GRADIENT (ease_gradient_get_type ())
#define EASE_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_GRADIENT, EaseGradient))
#define EASE_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_GRADIENT, EaseGradientClass))
#define EASE_IS_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_GRADIENT))
#define EASE_IS_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_GRADIENT))
#define EASE_GRADIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_GRADIENT, EaseGradientClass))

typedef struct _EaseGradient EaseGradient;
typedef struct _EaseGradientClass EaseGradientClass;

#define EASE_TYPE_BACKGROUND_TYPE (ease_background_type_get_type ())

#define EASE_TYPE_MEDIA_ELEMENT (ease_media_element_get_type ())
#define EASE_MEDIA_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElement))
#define EASE_MEDIA_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElementClass))
#define EASE_IS_MEDIA_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_MEDIA_ELEMENT))
#define EASE_IS_MEDIA_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_MEDIA_ELEMENT))
#define EASE_MEDIA_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElementClass))

typedef struct _EaseMediaElement EaseMediaElement;
typedef struct _EaseMediaElementClass EaseMediaElementClass;

#define EASE_TYPE_IMAGE_ELEMENT (ease_image_element_get_type ())
#define EASE_IMAGE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_IMAGE_ELEMENT, EaseImageElement))
#define EASE_IMAGE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_IMAGE_ELEMENT, EaseImageElementClass))
#define EASE_IS_IMAGE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_IMAGE_ELEMENT))
#define EASE_IS_IMAGE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_IMAGE_ELEMENT))
#define EASE_IMAGE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_IMAGE_ELEMENT, EaseImageElementClass))

typedef struct _EaseImageElement EaseImageElement;
typedef struct _EaseImageElementClass EaseImageElementClass;

#define EASE_TYPE_CAIRO_ELEMENT (ease_cairo_element_get_type ())
#define EASE_CAIRO_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_CAIRO_ELEMENT, EaseCairoElement))
#define EASE_CAIRO_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_CAIRO_ELEMENT, EaseCairoElementClass))
#define EASE_IS_CAIRO_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_CAIRO_ELEMENT))
#define EASE_IS_CAIRO_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_CAIRO_ELEMENT))
#define EASE_CAIRO_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_CAIRO_ELEMENT, EaseCairoElementClass))

typedef struct _EaseCairoElement EaseCairoElement;
typedef struct _EaseCairoElementClass EaseCairoElementClass;

#define EASE_TYPE_SHAPE_ELEMENT (ease_shape_element_get_type ())
#define EASE_SHAPE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SHAPE_ELEMENT, EaseShapeElement))
#define EASE_SHAPE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SHAPE_ELEMENT, EaseShapeElementClass))
#define EASE_IS_SHAPE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SHAPE_ELEMENT))
#define EASE_IS_SHAPE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SHAPE_ELEMENT))
#define EASE_SHAPE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SHAPE_ELEMENT, EaseShapeElementClass))

typedef struct _EaseShapeElement EaseShapeElement;
typedef struct _EaseShapeElementClass EaseShapeElementClass;

#define EASE_TYPE_VIDEO_ELEMENT (ease_video_element_get_type ())
#define EASE_VIDEO_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_VIDEO_ELEMENT, EaseVideoElement))
#define EASE_VIDEO_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_VIDEO_ELEMENT, EaseVideoElementClass))
#define EASE_IS_VIDEO_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_VIDEO_ELEMENT))
#define EASE_IS_VIDEO_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_VIDEO_ELEMENT))
#define EASE_VIDEO_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_VIDEO_ELEMENT, EaseVideoElementClass))

typedef struct _EaseVideoElement EaseVideoElement;
typedef struct _EaseVideoElementClass EaseVideoElementClass;

#define EASE_TYPE_TEXT_ELEMENT (ease_text_element_get_type ())
#define EASE_TEXT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_TEXT_ELEMENT, EaseTextElement))
#define EASE_TEXT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_TEXT_ELEMENT, EaseTextElementClass))
#define EASE_IS_TEXT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_TEXT_ELEMENT))
#define EASE_IS_TEXT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_TEXT_ELEMENT))
#define EASE_TEXT_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_TEXT_ELEMENT, EaseTextElementClass))

typedef struct _EaseTextElement EaseTextElement;
typedef struct _EaseTextElementClass EaseTextElementClass;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _json_node_free0(var) ((var == NULL) ? NULL : (var = (json_node_free (var), NULL)))

#define EASE_TYPE_ELEMENT_ADD_UNDO_ACTION (ease_element_add_undo_action_get_type ())
#define EASE_ELEMENT_ADD_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT_ADD_UNDO_ACTION, EaseElementAddUndoAction))
#define EASE_ELEMENT_ADD_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT_ADD_UNDO_ACTION, EaseElementAddUndoActionClass))
#define EASE_IS_ELEMENT_ADD_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT_ADD_UNDO_ACTION))
#define EASE_IS_ELEMENT_ADD_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT_ADD_UNDO_ACTION))
#define EASE_ELEMENT_ADD_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT_ADD_UNDO_ACTION, EaseElementAddUndoActionClass))

typedef struct _EaseElementAddUndoAction EaseElementAddUndoAction;
typedef struct _EaseElementAddUndoActionClass EaseElementAddUndoActionClass;

#define EASE_TYPE_ELEMENT_REMOVE_UNDO_ACTION (ease_element_remove_undo_action_get_type ())
#define EASE_ELEMENT_REMOVE_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT_REMOVE_UNDO_ACTION, EaseElementRemoveUndoAction))
#define EASE_ELEMENT_REMOVE_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT_REMOVE_UNDO_ACTION, EaseElementRemoveUndoActionClass))
#define EASE_IS_ELEMENT_REMOVE_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT_REMOVE_UNDO_ACTION))
#define EASE_IS_ELEMENT_REMOVE_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT_REMOVE_UNDO_ACTION))
#define EASE_ELEMENT_REMOVE_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT_REMOVE_UNDO_ACTION, EaseElementRemoveUndoActionClass))

typedef struct _EaseElementRemoveUndoAction EaseElementRemoveUndoAction;
typedef struct _EaseElementRemoveUndoActionClass EaseElementRemoveUndoActionClass;

#define EASE_TYPE_ELEMENT_REORDER_UNDO_ACTION (ease_element_reorder_undo_action_get_type ())
#define EASE_ELEMENT_REORDER_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT_REORDER_UNDO_ACTION, EaseElementReorderUndoAction))
#define EASE_ELEMENT_REORDER_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT_REORDER_UNDO_ACTION, EaseElementReorderUndoActionClass))
#define EASE_IS_ELEMENT_REORDER_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT_REORDER_UNDO_ACTION))
#define EASE_IS_ELEMENT_REORDER_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT_REORDER_UNDO_ACTION))
#define EASE_ELEMENT_REORDER_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT_REORDER_UNDO_ACTION, EaseElementReorderUndoActionClass))

typedef struct _EaseElementReorderUndoAction EaseElementReorderUndoAction;
typedef struct _EaseElementReorderUndoActionClass EaseElementReorderUndoActionClass;

#define EASE_TYPE_HTML_EXPORTER (ease_html_exporter_get_type ())
#define EASE_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporter))
#define EASE_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))
#define EASE_IS_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_HTML_EXPORTER))
#define EASE_IS_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_HTML_EXPORTER))
#define EASE_HTML_EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))

typedef struct _EaseHTMLExporter EaseHTMLExporter;
typedef struct _EaseHTMLExporterClass EaseHTMLExporterClass;

#define EASE_SLIDE_TYPE_ITERATOR (ease_slide_iterator_get_type ())
#define EASE_SLIDE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_SLIDE_TYPE_ITERATOR, EaseSlideIterator))
#define EASE_SLIDE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_SLIDE_TYPE_ITERATOR, EaseSlideIteratorClass))
#define EASE_SLIDE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_SLIDE_TYPE_ITERATOR))
#define EASE_SLIDE_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_SLIDE_TYPE_ITERATOR))
#define EASE_SLIDE_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_SLIDE_TYPE_ITERATOR, EaseSlideIteratorClass))

typedef struct _EaseSlideIterator EaseSlideIterator;
typedef struct _EaseSlideIteratorClass EaseSlideIteratorClass;
typedef struct _EaseDocumentPrivate EaseDocumentPrivate;

#define EASE_TYPE_ITERABLE_LIST_STORE (ease_iterable_list_store_get_type ())
#define EASE_ITERABLE_LIST_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ITERABLE_LIST_STORE, EaseIterableListStore))
#define EASE_ITERABLE_LIST_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ITERABLE_LIST_STORE, EaseIterableListStoreClass))
#define EASE_IS_ITERABLE_LIST_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ITERABLE_LIST_STORE))
#define EASE_IS_ITERABLE_LIST_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ITERABLE_LIST_STORE))
#define EASE_ITERABLE_LIST_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ITERABLE_LIST_STORE, EaseIterableListStoreClass))

typedef struct _EaseIterableListStore EaseIterableListStore;
typedef struct _EaseIterableListStoreClass EaseIterableListStoreClass;
typedef struct _EaseSlideIteratorPrivate EaseSlideIteratorPrivate;
typedef struct _EaseSlideParamSpecIterator EaseSlideParamSpecIterator;

struct _EaseUndoSourceIface {
	GTypeInterface parent_iface;
};

struct _EaseSlide {
	GObject parent_instance;
	EaseSlidePrivate * priv;
	GeeLinkedList* elements;
};

struct _EaseSlideClass {
	GObjectClass parent_class;
};

typedef enum  {
	EASE_TRANSITION_NONE,
	EASE_TRANSITION_FADE,
	EASE_TRANSITION_SLIDE,
	EASE_TRANSITION_DROP,
	EASE_TRANSITION_PIVOT,
	EASE_TRANSITION_FLIP,
	EASE_TRANSITION_REVOLVING_DOOR,
	EASE_TRANSITION_REVEAL,
	EASE_TRANSITION_FALL,
	EASE_TRANSITION_SLATS,
	EASE_TRANSITION_OPEN_DOOR,
	EASE_TRANSITION_EXPLODE,
	EASE_TRANSITION_ASSEMBLE,
	EASE_TRANSITION_ZOOM,
	EASE_TRANSITION_PANEL,
	EASE_TRANSITION_SPIN_CONTENTS,
	EASE_TRANSITION_SPRING_CONTENTS,
	EASE_TRANSITION_SWING_CONTENTS,
	EASE_TRANSITION_SLIDE_CONTENTS,
	EASE_TRANSITION_ZOOM_CONTENTS
} EaseTransition;

typedef enum  {
	EASE_TRANSITION_VARIANT_LEFT,
	EASE_TRANSITION_VARIANT_RIGHT,
	EASE_TRANSITION_VARIANT_UP,
	EASE_TRANSITION_VARIANT_DOWN,
	EASE_TRANSITION_VARIANT_BOTTOM,
	EASE_TRANSITION_VARIANT_TOP,
	EASE_TRANSITION_VARIANT_CENTER,
	EASE_TRANSITION_VARIANT_TOP_LEFT,
	EASE_TRANSITION_VARIANT_TOP_RIGHT,
	EASE_TRANSITION_VARIANT_BOTTOM_LEFT,
	EASE_TRANSITION_VARIANT_BOTTOM_RIGHT,
	EASE_TRANSITION_VARIANT_TOP_TO_BOTTOM,
	EASE_TRANSITION_VARIANT_BOTTOM_TO_TOP,
	EASE_TRANSITION_VARIANT_LEFT_TO_RIGHT,
	EASE_TRANSITION_VARIANT_RIGHT_TO_LEFT,
	EASE_TRANSITION_VARIANT_IN,
	EASE_TRANSITION_VARIANT_OUT
} EaseTransitionVariant;

struct _EaseSlidePrivate {
	EaseTransition _transition;
	EaseTransitionVariant _variant;
	double _transition_time;
	gboolean _automatically_advance;
	double _advance_delay;
	EaseBackground* _background;
	EaseDocument* _parent;
	EaseTheme* _theme;
	char* _master;
};

struct _EaseUndoItem {
	GObject parent_instance;
	EaseUndoItemPrivate * priv;
};

struct _EaseUndoItemClass {
	GObjectClass parent_class;
	EaseUndoItem* (*apply) (EaseUndoItem* self);
	gboolean (*contains) (EaseUndoItem* self, GObject* obj);
};

struct _EaseUndoAction {
	EaseUndoItem parent_instance;
	EaseUndoActionPrivate * priv;
	GeeLinkedList* pairs;
};

struct _EaseUndoActionClass {
	EaseUndoItemClass parent_class;
};

struct _EaseUndoActionUndoPair {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EaseUndoActionUndoPairPrivate * priv;
	char* property;
	GObject* object;
	GValue val;
	GType type;
};

struct _EaseUndoActionUndoPairClass {
	GTypeClass parent_class;
	void (*finalize) (EaseUndoActionUndoPair *self);
};

typedef enum  {
	EASE_BACKGROUND_TYPE_COLOR,
	EASE_BACKGROUND_TYPE_GRADIENT,
	EASE_BACKGROUND_TYPE_IMAGE
} EaseBackgroundType;

struct _EaseDocument {
	GObject parent_instance;
	EaseDocumentPrivate * priv;
	EaseIterableListStore* slides;
};

struct _EaseDocumentClass {
	GObjectClass parent_class;
};

struct _EaseSlideIterator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EaseSlideIteratorPrivate * priv;
};

struct _EaseSlideIteratorClass {
	GTypeClass parent_class;
	void (*finalize) (EaseSlideIterator *self);
};

struct _EaseSlideIteratorPrivate {
	gint i;
	EaseSlide* self;
};

struct _EaseSlideParamSpecIterator {
	GParamSpec parent_instance;
};


static gpointer ease_slide_iterator_parent_class = NULL;
static gpointer ease_slide_parent_class = NULL;
static EaseUndoSourceIface* ease_slide_ease_undo_source_parent_iface = NULL;

GType ease_undo_source_get_type (void) G_GNUC_CONST;
GType ease_slide_get_type (void) G_GNUC_CONST;
GType ease_element_get_type (void) G_GNUC_CONST;
GType ease_transition_get_type (void) G_GNUC_CONST;
GType ease_transition_variant_get_type (void) G_GNUC_CONST;
GType ease_background_get_type (void) G_GNUC_CONST;
GType ease_document_get_type (void) G_GNUC_CONST;
GType ease_theme_get_type (void) G_GNUC_CONST;
#define EASE_SLIDE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_SLIDE, EaseSlidePrivate))
enum  {
	EASE_SLIDE_DUMMY_PROPERTY,
	EASE_SLIDE_TRANSITION,
	EASE_SLIDE_VARIANT,
	EASE_SLIDE_TRANSITION_TIME,
	EASE_SLIDE_TRANSITION_MSECS,
	EASE_SLIDE_AUTOMATICALLY_ADVANCE,
	EASE_SLIDE_ADVANCE_DELAY,
	EASE_SLIDE_BACKGROUND,
	EASE_SLIDE_BACKGROUND_ABS,
	EASE_SLIDE_PARENT,
	EASE_SLIDE_WIDTH,
	EASE_SLIDE_HEIGHT,
	EASE_SLIDE_ASPECT,
	EASE_SLIDE_THEME,
	EASE_SLIDE_MASTER,
	EASE_SLIDE_COUNT,
	EASE_SLIDE_NEXT,
	EASE_SLIDE_PREVIOUS
};
#define EASE_SLIDE_IMAGE_TYPE "EaseImageElement"
#define EASE_SLIDE_SHAPE_TYPE "EaseShapeElement"
#define EASE_SLIDE_VIDEO_TYPE "EaseVideoElement"
EaseBackground* ease_background_new (void);
EaseBackground* ease_background_construct (GType object_type);
void ease_slide_set_background (EaseSlide* self, EaseBackground* value);
EaseBackground* ease_slide_get_background (EaseSlide* self);
GType ease_undo_item_get_type (void) G_GNUC_CONST;
gboolean ease_background_owns_undoitem (EaseBackground* self, EaseUndoItem* item);
static void _lambda55_ (EaseUndoItem* item, EaseSlide* self);
static void __lambda55__ease_undo_source_undo (EaseUndoSource* _sender, EaseUndoItem* action, gpointer self);
GType ease_undo_action_get_type (void) G_GNUC_CONST;
gpointer ease_undo_action_undo_pair_ref (gpointer instance);
void ease_undo_action_undo_pair_unref (gpointer instance);
GParamSpec* ease_undo_action_param_spec_undo_pair (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void ease_undo_action_value_set_undo_pair (GValue* value, gpointer v_object);
void ease_undo_action_value_take_undo_pair (GValue* value, gpointer v_object);
gpointer ease_undo_action_value_get_undo_pair (const GValue* value);
GType ease_undo_action_undo_pair_get_type (void) G_GNUC_CONST;
static void ease_slide_update_title (EaseSlide* self, GObject* object);
static void _lambda56_ (EaseUndoItem* item, EaseSlide* self);
static void __lambda56__ease_undo_source_forwarded (EaseUndoSource* _sender, EaseUndoItem* action, gpointer self);
EaseSlide* ease_slide_new (void);
EaseSlide* ease_slide_construct (GType object_type);
void ease_slide_set_parent (EaseSlide* self, EaseDocument* value);
EaseSlide* ease_slide_new_with_owner (EaseDocument* owner);
EaseSlide* ease_slide_construct_with_owner (GType object_type, EaseDocument* owner);
void ease_slide_set_master (EaseSlide* self, const char* value);
EaseTransition ease_transition_from_string (const char* str);
void ease_slide_set_transition (EaseSlide* self, EaseTransition value);
EaseTransitionVariant ease_transition_variant_from_string (const char* str);
void ease_slide_set_variant (EaseSlide* self, EaseTransitionVariant value);
void ease_slide_set_transition_time (EaseSlide* self, double value);
void ease_slide_set_automatically_advance (EaseSlide* self, gboolean value);
void ease_slide_set_advance_delay (EaseSlide* self, double value);
#define EASE_THEME_BACKGROUND_IMAGE "background-image"
GType ease_image_get_type (void) G_GNUC_CONST;
void ease_image_set_filename (EaseImage* self, const char* value);
EaseImage* ease_background_get_image (EaseBackground* self);
void ease_image_set_source (EaseImage* self, const char* value);
#define EASE_THEME_BACKGROUND_COLOR "background-color"
EaseColor* ease_color_new_from_string (const char* str);
EaseColor* ease_color_construct_from_string (GType object_type, const char* str);
GType ease_color_get_type (void) G_GNUC_CONST;
void ease_background_set_color (EaseBackground* self, EaseColor* value);
#define EASE_THEME_BACKGROUND_GRADIENT "background-gradient"
EaseGradient* ease_gradient_new_from_string (const char* str);
EaseGradient* ease_gradient_construct_from_string (GType object_type, const char* str);
GType ease_gradient_get_type (void) G_GNUC_CONST;
void ease_background_set_gradient (EaseBackground* self, EaseGradient* value);
GType ease_background_type_get_type (void) G_GNUC_CONST;
EaseBackgroundType ease_background_type_from_string (const char* str);
#define EASE_THEME_BACKGROUND_TYPE "background-type"
void ease_background_set_background_type (EaseBackground* self, EaseBackgroundType value);
#define EASE_THEME_ELEMENT_TYPE "element-type"
EaseImageElement* ease_image_element_new_from_json (JsonObject* obj);
EaseImageElement* ease_image_element_construct_from_json (GType object_type, JsonObject* obj);
GType ease_media_element_get_type (void) G_GNUC_CONST;
GType ease_image_element_get_type (void) G_GNUC_CONST;
EaseShapeElement* ease_shape_element_new_from_json (JsonObject* obj);
EaseShapeElement* ease_shape_element_construct_from_json (GType object_type, JsonObject* obj);
GType ease_cairo_element_get_type (void) G_GNUC_CONST;
GType ease_shape_element_get_type (void) G_GNUC_CONST;
EaseVideoElement* ease_video_element_new_from_json (JsonObject* obj);
EaseVideoElement* ease_video_element_construct_from_json (GType object_type, JsonObject* obj);
GType ease_video_element_get_type (void) G_GNUC_CONST;
EaseTextElement* ease_text_element_new_from_json (JsonObject* obj);
EaseTextElement* ease_text_element_construct_from_json (GType object_type, JsonObject* obj);
GType ease_text_element_get_type (void) G_GNUC_CONST;
void ease_element_set_element_type (EaseElement* self, const char* value);
void ease_slide_append (EaseSlide* self, EaseElement* e);
EaseSlide* ease_slide_new_from_json (JsonObject* obj);
EaseSlide* ease_slide_construct_from_json (GType object_type, JsonObject* obj);
const char* ease_slide_get_master (EaseSlide* self);
EaseTransition ease_slide_get_transition (EaseSlide* self);
EaseTransitionVariant ease_slide_get_variant (EaseSlide* self);
double ease_slide_get_transition_time (EaseSlide* self);
gboolean ease_slide_get_automatically_advance (EaseSlide* self);
double ease_slide_get_advance_delay (EaseSlide* self);
const char* ease_image_get_filename (EaseImage* self);
const char* ease_image_get_source (EaseImage* self);
EaseColor* ease_background_get_color (EaseBackground* self);
char* ease_color_to_string (EaseColor* self);
EaseGradient* ease_background_get_gradient (EaseBackground* self);
char* ease_gradient_to_string (EaseGradient* self);
EaseBackgroundType ease_background_get_background_type (EaseBackground* self);
char* ease_background_type_to_string (EaseBackgroundType self);
JsonObject* ease_element_to_json (EaseElement* self);
JsonNode* ease_slide_to_json (EaseSlide* self);
void ease_slide_add_actual (EaseSlide* self, gint index, EaseElement* e, gboolean emit_undo);
void ease_slide_add (EaseSlide* self, gint index, EaseElement* e);
void ease_element_set_parent (EaseElement* self, EaseSlide* value);
void ease_undo_source_listen (EaseUndoSource* self, EaseUndoSource* source);
EaseElementAddUndoAction* ease_element_add_undo_action_new (EaseElement* e);
EaseElementAddUndoAction* ease_element_add_undo_action_construct (GType object_type, EaseElement* e);
GType ease_element_add_undo_action_get_type (void) G_GNUC_CONST;
gint ease_slide_get_count (EaseSlide* self);
void ease_slide_remove_actual (EaseSlide* self, EaseElement* e, gboolean emit_undo);
void ease_slide_remove (EaseSlide* self, EaseElement* e);
EaseElementRemoveUndoAction* ease_element_remove_undo_action_new (EaseElement* e);
EaseElementRemoveUndoAction* ease_element_remove_undo_action_construct (GType object_type, EaseElement* e);
GType ease_element_remove_undo_action_get_type (void) G_GNUC_CONST;
gint ease_slide_index_of (EaseSlide* self, EaseElement* e);
void ease_undo_source_silence (EaseUndoSource* self, EaseUndoSource* source);
const char* ease_element_get_identifier (EaseElement* self);
#define EASE_THEME_TITLE_TEXT "title-text"
#define EASE_THEME_HEADER_TEXT "header-text"
void ease_slide_remove_at (EaseSlide* self, gint index);
EaseElement* ease_slide_element_at (EaseSlide* self, gint i);
EaseElementReorderUndoAction* ease_element_reorder_undo_action_new (EaseElement* e, gint orig, gint current);
EaseElementReorderUndoAction* ease_element_reorder_undo_action_construct (GType object_type, EaseElement* e, gint orig, gint current);
GType ease_element_reorder_undo_action_get_type (void) G_GNUC_CONST;
void ease_slide_raise (EaseSlide* self, EaseElement* element);
void ease_slide_lower (EaseSlide* self, EaseElement* element);
void ease_slide_raise_top (EaseSlide* self, EaseElement* element);
void ease_slide_lower_bottom (EaseSlide* self, EaseElement* element);
void ease_slide_reorder (EaseSlide* self, EaseElement* element, gint current, gint target);
EaseDocument* ease_slide_get_parent (EaseSlide* self);
void ease_slide_cairo_render_sized (EaseSlide* self, cairo_t* context, gint w, gint h, GError** error);
gint ease_document_get_width (EaseDocument* self);
gint ease_document_get_height (EaseDocument* self);
void ease_slide_cairo_render (EaseSlide* self, cairo_t* context, GError** error);
void ease_slide_cairo_render_background (EaseSlide* self, cairo_t* cr, gint w, gint h, GError** error);
float ease_element_get_x (EaseElement* self);
float ease_element_get_y (EaseElement* self);
void ease_element_cairo_render (EaseElement* self, cairo_t* context, GError** error);
EaseTheme* ease_slide_get_theme (EaseSlide* self);
const char* ease_theme_get_path (EaseTheme* self);
const char* ease_document_get_path (EaseDocument* self);
void ease_background_set_cairo (EaseBackground* self, cairo_t* cr, gint width, gint height, const char* path);
void ease_color_get_clutter (EaseColor* self, ClutterColor* result);
GType ease_html_exporter_get_type (void) G_GNUC_CONST;
char* ease_html_exporter_get_basename (EaseHTMLExporter* self);
void ease_html_exporter_copy_file (EaseHTMLExporter* self, const char* end_path, const char* base_path);
void ease_element_to_html (EaseElement* self, char** html, EaseHTMLExporter* exporter, double amount);
void ease_slide_to_html (EaseSlide* self, char** html, EaseHTMLExporter* exporter, double amount, gint index);
const char* ease_text_element_get_text (EaseTextElement* self);
EaseSlideIterator* ease_slide_iterator_new (EaseSlide* slide);
EaseSlideIterator* ease_slide_iterator_construct (GType object_type, EaseSlide* slide);
gpointer ease_slide_iterator_ref (gpointer instance);
void ease_slide_iterator_unref (gpointer instance);
GParamSpec* ease_slide_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void ease_slide_value_set_iterator (GValue* value, gpointer v_object);
void ease_slide_value_take_iterator (GValue* value, gpointer v_object);
gpointer ease_slide_value_get_iterator (const GValue* value);
GType ease_slide_iterator_get_type (void) G_GNUC_CONST;
EaseSlideIterator* ease_slide_iterator (EaseSlide* self);
guint ease_slide_get_transition_msecs (EaseSlide* self);
void ease_slide_set_transition_msecs (EaseSlide* self, guint value);
char* ease_slide_get_background_abs (EaseSlide* self);
gint ease_slide_get_width (EaseSlide* self);
gint ease_slide_get_height (EaseSlide* self);
float ease_document_get_aspect (EaseDocument* self);
float ease_slide_get_aspect (EaseSlide* self);
void ease_slide_set_theme (EaseSlide* self, EaseTheme* value);
GType ease_iterable_list_store_get_type (void) G_GNUC_CONST;
gint ease_iterable_list_store_get_size (EaseIterableListStore* self);
EaseSlide* ease_document_get_slide (EaseDocument* self, gint index);
EaseSlide* ease_slide_get_next (EaseSlide* self);
EaseSlide* ease_slide_get_previous (EaseSlide* self);
#define EASE_SLIDE_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_SLIDE_TYPE_ITERATOR, EaseSlideIteratorPrivate))
enum  {
	EASE_SLIDE_ITERATOR_DUMMY_PROPERTY
};
gboolean ease_slide_iterator_next (EaseSlideIterator* self);
EaseElement* ease_slide_iterator_get (EaseSlideIterator* self);
static void ease_slide_iterator_finalize (EaseSlideIterator* obj);
static void ease_slide_finalize (GObject* obj);
static void ease_slide_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_slide_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

#line 206 "ease-slide.vala"
static void _lambda55_ (EaseUndoItem* item, EaseSlide* self) {
#line 206 "ease-slide.vala"
	g_return_if_fail (item != NULL);
#line 207 "ease-slide.vala"
	if (ease_background_owns_undoitem (self->priv->_background, item)) {
#line 207 "ease-slide.vala"
		g_signal_emit_by_name (self, "background-changed", self);
#line 653 "ease-slide.c"
	}
}


#line 206 "ease-slide.vala"
static void __lambda55__ease_undo_source_undo (EaseUndoSource* _sender, EaseUndoItem* action, gpointer self) {
#line 660 "ease-slide.c"
	_lambda55_ (action, self);
}


#line 211 "ease-slide.vala"
static void _lambda56_ (EaseUndoItem* item, EaseSlide* self) {
#line 211 "ease-slide.vala"
	g_return_if_fail (item != NULL);
#line 212 "ease-slide.vala"
	if (EASE_IS_UNDO_ACTION (item)) {
#line 671 "ease-slide.c"
		{
			EaseUndoItem* _tmp0_;
			GeeIterator* _pair_it;
#line 214 "ease-slide.vala"
			_pair_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) (_tmp0_ = item, EASE_IS_UNDO_ACTION (_tmp0_) ? ((EaseUndoAction*) _tmp0_) : NULL)->pairs);
#line 214 "ease-slide.vala"
			while (TRUE) {
#line 679 "ease-slide.c"
				EaseUndoActionUndoPair* pair;
#line 214 "ease-slide.vala"
				if (!gee_iterator_next (_pair_it)) {
#line 214 "ease-slide.vala"
					break;
#line 685 "ease-slide.c"
				}
#line 214 "ease-slide.vala"
				pair = (EaseUndoActionUndoPair*) gee_iterator_get (_pair_it);
#line 216 "ease-slide.vala"
				if (_vala_strcmp0 (pair->property, "text") == 0) {
#line 216 "ease-slide.vala"
					ease_slide_update_title (self, pair->object);
#line 693 "ease-slide.c"
				}
				_ease_undo_action_undo_pair_unref0 (pair);
			}
			_g_object_unref0 (_pair_it);
		}
	}
}


#line 211 "ease-slide.vala"
static void __lambda56__ease_undo_source_forwarded (EaseUndoSource* _sender, EaseUndoItem* action, gpointer self) {
#line 705 "ease-slide.c"
	_lambda56_ (action, self);
}


#line 201 "ease-slide.vala"
EaseSlide* ease_slide_construct (GType object_type) {
#line 712 "ease-slide.c"
	EaseSlide * self;
	EaseBackground* _tmp0_;
#line 201 "ease-slide.vala"
	self = (EaseSlide*) g_object_new (object_type, NULL);
#line 203 "ease-slide.vala"
	ease_slide_set_background (self, _tmp0_ = ease_background_new ());
#line 719 "ease-slide.c"
	_g_object_unref0 (_tmp0_);
#line 206 "ease-slide.vala"
	g_signal_connect_object ((EaseUndoSource*) self, "undo", (GCallback) __lambda55__ease_undo_source_undo, self, 0);
#line 211 "ease-slide.vala"
	g_signal_connect_object ((EaseUndoSource*) self, "forwarded", (GCallback) __lambda56__ease_undo_source_forwarded, self, 0);
#line 725 "ease-slide.c"
	return self;
}


#line 201 "ease-slide.vala"
EaseSlide* ease_slide_new (void) {
#line 201 "ease-slide.vala"
	return ease_slide_construct (EASE_TYPE_SLIDE);
#line 734 "ease-slide.c"
}


#line 229 "ease-slide.vala"
EaseSlide* ease_slide_construct_with_owner (GType object_type, EaseDocument* owner) {
#line 740 "ease-slide.c"
	EaseSlide * self;
#line 229 "ease-slide.vala"
	g_return_val_if_fail (owner != NULL, NULL);
#line 231 "ease-slide.vala"
	self = (EaseSlide*) ease_slide_construct (object_type);
#line 232 "ease-slide.vala"
	ease_slide_set_parent (self, owner);
#line 748 "ease-slide.c"
	return self;
}


#line 229 "ease-slide.vala"
EaseSlide* ease_slide_new_with_owner (EaseDocument* owner) {
#line 229 "ease-slide.vala"
	return ease_slide_construct_with_owner (EASE_TYPE_SLIDE, owner);
#line 757 "ease-slide.c"
}


#line 1056 "glib-2.0.vapi"
static gboolean string_to_bool (const char* self) {
#line 763 "ease-slide.c"
	gboolean result = FALSE;
#line 1056 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1057 "glib-2.0.vapi"
	if (_vala_strcmp0 (self, "true") == 0) {
#line 769 "ease-slide.c"
		result = TRUE;
#line 1058 "glib-2.0.vapi"
		return result;
#line 773 "ease-slide.c"
	} else {
		result = FALSE;
#line 1060 "glib-2.0.vapi"
		return result;
#line 778 "ease-slide.c"
	}
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


#line 238 "ease-slide.vala"
EaseSlide* ease_slide_construct_from_json (GType object_type, JsonObject* obj) {
#line 795 "ease-slide.c"
	EaseSlide * self;
	EaseSlide* slide;
	JsonArray* elements;
#line 238 "ease-slide.vala"
	g_return_val_if_fail (obj != NULL, NULL);
#line 240 "ease-slide.vala"
	self = (EaseSlide*) ease_slide_construct (object_type);
#line 242 "ease-slide.vala"
	slide = ease_slide_new ();
#line 245 "ease-slide.vala"
	ease_slide_set_master (self, json_object_get_string_member (obj, "master"));
#line 248 "ease-slide.vala"
	ease_slide_set_transition (self, ease_transition_from_string (json_object_get_string_member (obj, "transition")));
#line 251 "ease-slide.vala"
	ease_slide_set_variant (self, ease_transition_variant_from_string (json_object_get_string_member (obj, "variant")));
#line 254 "ease-slide.vala"
	ease_slide_set_transition_time (self, g_ascii_strtod (json_object_get_string_member (obj, "transition_time"), NULL));
#line 256 "ease-slide.vala"
	ease_slide_set_automatically_advance (self, string_to_bool (json_object_get_string_member (obj, "automatically_advance")));
#line 259 "ease-slide.vala"
	ease_slide_set_advance_delay (self, g_ascii_strtod (json_object_get_string_member (obj, "advance_delay"), NULL));
#line 263 "ease-slide.vala"
	if (json_object_has_member (obj, EASE_THEME_BACKGROUND_IMAGE)) {
#line 265 "ease-slide.vala"
		ease_image_set_filename (ease_background_get_image (self->priv->_background), json_object_get_string_member (obj, EASE_THEME_BACKGROUND_IMAGE));
#line 266 "ease-slide.vala"
		ease_image_set_source (ease_background_get_image (self->priv->_background), json_object_get_string_member (obj, "background-image-source"));
#line 823 "ease-slide.c"
	}
#line 269 "ease-slide.vala"
	if (json_object_has_member (obj, EASE_THEME_BACKGROUND_COLOR)) {
#line 827 "ease-slide.c"
		EaseColor* _tmp0_;
#line 271 "ease-slide.vala"
		ease_background_set_color (self->priv->_background, _tmp0_ = ease_color_new_from_string (json_object_get_string_member (obj, EASE_THEME_BACKGROUND_COLOR)));
#line 831 "ease-slide.c"
		_g_object_unref0 (_tmp0_);
	}
#line 275 "ease-slide.vala"
	if (json_object_has_member (obj, EASE_THEME_BACKGROUND_GRADIENT)) {
#line 836 "ease-slide.c"
		EaseGradient* _tmp1_;
#line 277 "ease-slide.vala"
		ease_background_set_gradient (self->priv->_background, _tmp1_ = ease_gradient_new_from_string (json_object_get_string_member (obj, EASE_THEME_BACKGROUND_GRADIENT)));
#line 840 "ease-slide.c"
		_g_object_unref0 (_tmp1_);
	}
#line 281 "ease-slide.vala"
	ease_background_set_background_type (self->priv->_background, ease_background_type_from_string (json_object_get_string_member (obj, EASE_THEME_BACKGROUND_TYPE)));
#line 285 "ease-slide.vala"
	elements = _json_array_ref0 (json_object_get_array_member (obj, "elements"));
#line 847 "ease-slide.c"
	{
		gint i;
#line 287 "ease-slide.vala"
		i = 0;
#line 852 "ease-slide.c"
		{
			gboolean _tmp2_;
#line 287 "ease-slide.vala"
			_tmp2_ = TRUE;
#line 287 "ease-slide.vala"
			while (TRUE) {
#line 859 "ease-slide.c"
				JsonObject* node;
				char* type;
				EaseElement* e;
#line 287 "ease-slide.vala"
				if (!_tmp2_) {
#line 287 "ease-slide.vala"
					i++;
#line 867 "ease-slide.c"
				}
#line 287 "ease-slide.vala"
				_tmp2_ = FALSE;
#line 287 "ease-slide.vala"
				if (!(i < json_array_get_length (elements))) {
#line 287 "ease-slide.vala"
					break;
#line 875 "ease-slide.c"
				}
#line 289 "ease-slide.vala"
				node = _json_object_ref0 (json_array_get_object_element (elements, (guint) i));
#line 292 "ease-slide.vala"
				type = g_strdup (json_object_get_string_member (node, EASE_THEME_ELEMENT_TYPE));
#line 881 "ease-slide.c"
				e = NULL;
#line 295 "ease-slide.vala"
				if (_vala_strcmp0 (type, EASE_SLIDE_IMAGE_TYPE) == 0) {
#line 885 "ease-slide.c"
					EaseElement* _tmp3_;
#line 297 "ease-slide.vala"
					e = (_tmp3_ = (EaseElement*) ease_image_element_new_from_json (node), _g_object_unref0 (e), _tmp3_);
#line 889 "ease-slide.c"
				} else {
#line 299 "ease-slide.vala"
					if (_vala_strcmp0 (type, EASE_SLIDE_SHAPE_TYPE) == 0) {
#line 893 "ease-slide.c"
						EaseElement* _tmp4_;
#line 301 "ease-slide.vala"
						e = (_tmp4_ = (EaseElement*) ease_shape_element_new_from_json (node), _g_object_unref0 (e), _tmp4_);
#line 897 "ease-slide.c"
					} else {
#line 303 "ease-slide.vala"
						if (_vala_strcmp0 (type, EASE_SLIDE_VIDEO_TYPE) == 0) {
#line 901 "ease-slide.c"
							EaseElement* _tmp5_;
#line 305 "ease-slide.vala"
							e = (_tmp5_ = (EaseElement*) ease_video_element_new_from_json (node), _g_object_unref0 (e), _tmp5_);
#line 905 "ease-slide.c"
						} else {
							EaseElement* _tmp6_;
#line 309 "ease-slide.vala"
							e = (_tmp6_ = (EaseElement*) ease_text_element_new_from_json (node), _g_object_unref0 (e), _tmp6_);
#line 910 "ease-slide.c"
						}
					}
				}
#line 311 "ease-slide.vala"
				ease_element_set_element_type (e, type);
#line 312 "ease-slide.vala"
				ease_slide_append (self, e);
#line 918 "ease-slide.c"
				_g_object_unref0 (e);
				_g_free0 (type);
				_json_object_unref0 (node);
			}
		}
	}
	_json_array_unref0 (elements);
	_g_object_unref0 (slide);
	return self;
}


#line 238 "ease-slide.vala"
EaseSlide* ease_slide_new_from_json (JsonObject* obj) {
#line 238 "ease-slide.vala"
	return ease_slide_construct_from_json (EASE_TYPE_SLIDE, obj);
#line 935 "ease-slide.c"
}


#line 687 "glib-2.0.vapi"
static char* double_to_string (double self) {
#line 941 "ease-slide.c"
	char* result = NULL;
	gint _tmp0__length1;
	gchar* _tmp0_;
	char* _tmp1_;
	result = (_tmp1_ = g_strdup (g_ascii_dtostr ((_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE), _tmp0__length1 = G_ASCII_DTOSTR_BUF_SIZE, _tmp0_), G_ASCII_DTOSTR_BUF_SIZE, self)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
#line 688 "glib-2.0.vapi"
	return result;
#line 949 "ease-slide.c"
}


#line 35 "glib-2.0.vapi"
static char* bool_to_string (gboolean self) {
#line 955 "ease-slide.c"
	char* result = NULL;
#line 36 "glib-2.0.vapi"
	if (self) {
#line 959 "ease-slide.c"
		result = g_strdup ("true");
#line 37 "glib-2.0.vapi"
		return result;
#line 963 "ease-slide.c"
	} else {
		result = g_strdup ("false");
#line 39 "glib-2.0.vapi"
		return result;
#line 968 "ease-slide.c"
	}
}


#line 316 "ease-slide.vala"
JsonNode* ease_slide_to_json (EaseSlide* self) {
#line 975 "ease-slide.c"
	JsonNode* result = NULL;
	JsonNode* node;
	JsonObject* obj;
	GEnumValue* _tmp0_;
	GEnumValue* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp7_;
	JsonArray* json_elements;
#line 316 "ease-slide.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 318 "ease-slide.vala"
	node = json_node_new (JSON_NODE_OBJECT);
#line 319 "ease-slide.vala"
	obj = json_object_new ();
#line 322 "ease-slide.vala"
	json_object_set_string_member (obj, "master", self->priv->_master);
#line 325 "ease-slide.vala"
	json_object_set_string_member (obj, "transition", (_tmp0_ = g_enum_get_value (g_type_class_ref (EASE_TYPE_TRANSITION), (int) self->priv->_transition), (_tmp0_ != NULL) ? _tmp0_->value_name : NULL));
#line 326 "ease-slide.vala"
	json_object_set_string_member (obj, "variant", (_tmp1_ = g_enum_get_value (g_type_class_ref (EASE_TYPE_TRANSITION_VARIANT), (int) self->priv->_variant), (_tmp1_ != NULL) ? _tmp1_->value_name : NULL));
#line 327 "ease-slide.vala"
	json_object_set_string_member (obj, "transition_time", _tmp2_ = double_to_string (self->priv->_transition_time));
#line 1000 "ease-slide.c"
	_g_free0 (_tmp2_);
#line 328 "ease-slide.vala"
	json_object_set_string_member (obj, "automatically_advance", _tmp3_ = bool_to_string (self->priv->_automatically_advance));
#line 1004 "ease-slide.c"
	_g_free0 (_tmp3_);
#line 330 "ease-slide.vala"
	json_object_set_string_member (obj, "advance_delay", _tmp4_ = double_to_string (self->priv->_advance_delay));
#line 1008 "ease-slide.c"
	_g_free0 (_tmp4_);
#line 333 "ease-slide.vala"
	if (ease_image_get_filename (ease_background_get_image (self->priv->_background)) != NULL) {
#line 335 "ease-slide.vala"
		json_object_set_string_member (obj, EASE_THEME_BACKGROUND_IMAGE, ease_image_get_filename (ease_background_get_image (self->priv->_background)));
#line 337 "ease-slide.vala"
		json_object_set_string_member (obj, "background-image-source", ease_image_get_source (ease_background_get_image (self->priv->_background)));
#line 1016 "ease-slide.c"
	}
#line 340 "ease-slide.vala"
	if (ease_background_get_color (self->priv->_background) != NULL) {
#line 1020 "ease-slide.c"
		char* _tmp5_;
#line 342 "ease-slide.vala"
		json_object_set_string_member (obj, EASE_THEME_BACKGROUND_COLOR, _tmp5_ = ease_color_to_string (ease_background_get_color (self->priv->_background)));
#line 1024 "ease-slide.c"
		_g_free0 (_tmp5_);
	}
#line 345 "ease-slide.vala"
	if (ease_background_get_gradient (self->priv->_background) != NULL) {
#line 1029 "ease-slide.c"
		char* _tmp6_;
#line 347 "ease-slide.vala"
		json_object_set_string_member (obj, EASE_THEME_BACKGROUND_GRADIENT, _tmp6_ = ease_gradient_to_string (ease_background_get_gradient (self->priv->_background)));
#line 1033 "ease-slide.c"
		_g_free0 (_tmp6_);
	}
#line 350 "ease-slide.vala"
	json_object_set_string_member (obj, EASE_THEME_BACKGROUND_TYPE, _tmp7_ = ease_background_type_to_string (ease_background_get_background_type (self->priv->_background)));
#line 1038 "ease-slide.c"
	_g_free0 (_tmp7_);
#line 354 "ease-slide.vala"
	json_elements = json_array_new ();
#line 1042 "ease-slide.c"
	{
		GeeIterator* _e_it;
#line 355 "ease-slide.vala"
		_e_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->elements);
#line 355 "ease-slide.vala"
		while (TRUE) {
#line 1049 "ease-slide.c"
			EaseElement* e;
			JsonNode* e_node;
			JsonObject* _tmp8_;
#line 355 "ease-slide.vala"
			if (!gee_iterator_next (_e_it)) {
#line 355 "ease-slide.vala"
				break;
#line 1057 "ease-slide.c"
			}
#line 355 "ease-slide.vala"
			e = (EaseElement*) gee_iterator_get (_e_it);
#line 357 "ease-slide.vala"
			e_node = json_node_new (JSON_NODE_OBJECT);
#line 358 "ease-slide.vala"
			json_node_set_object (e_node, _tmp8_ = ease_element_to_json (e));
#line 1065 "ease-slide.c"
			_json_object_unref0 (_tmp8_);
#line 359 "ease-slide.vala"
			json_array_add_element (json_elements, json_node_copy (e_node));
#line 1069 "ease-slide.c"
			_json_node_free0 (e_node);
			_g_object_unref0 (e);
		}
		_g_object_unref0 (_e_it);
	}
#line 362 "ease-slide.vala"
	json_object_set_array_member (obj, "elements", _json_array_ref0 (json_elements));
#line 364 "ease-slide.vala"
	json_node_set_object (node, obj);
#line 1079 "ease-slide.c"
	result = node;
	_json_array_unref0 (json_elements);
	_json_object_unref0 (obj);
#line 365 "ease-slide.vala"
	return result;
#line 1085 "ease-slide.c"
}


#line 374 "ease-slide.vala"
void ease_slide_add (EaseSlide* self, gint index, EaseElement* e) {
#line 374 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 374 "ease-slide.vala"
	g_return_if_fail (e != NULL);
#line 376 "ease-slide.vala"
	ease_slide_add_actual (self, index, e, TRUE);
#line 1097 "ease-slide.c"
}


#line 382 "ease-slide.vala"
void ease_slide_add_actual (EaseSlide* self, gint index, EaseElement* e, gboolean emit_undo) {
#line 382 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 382 "ease-slide.vala"
	g_return_if_fail (e != NULL);
#line 384 "ease-slide.vala"
	ease_element_set_parent (e, self);
#line 385 "ease-slide.vala"
	gee_abstract_list_insert ((GeeAbstractList*) self->elements, index, e);
#line 386 "ease-slide.vala"
	g_signal_emit_by_name (self, "element-added", self, e, index);
#line 387 "ease-slide.vala"
	ease_undo_source_listen ((EaseUndoSource*) self, (EaseUndoSource*) e);
#line 388 "ease-slide.vala"
	ease_slide_update_title (self, (GObject*) e);
#line 389 "ease-slide.vala"
	if (emit_undo) {
#line 1119 "ease-slide.c"
		EaseElementAddUndoAction* _tmp0_;
#line 389 "ease-slide.vala"
		g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp0_ = ease_element_add_undo_action_new (e)));
#line 1123 "ease-slide.c"
		_g_object_unref0 (_tmp0_);
	}
}


#line 397 "ease-slide.vala"
void ease_slide_append (EaseSlide* self, EaseElement* e) {
#line 397 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 397 "ease-slide.vala"
	g_return_if_fail (e != NULL);
#line 399 "ease-slide.vala"
	ease_slide_add (self, ease_slide_get_count (self), e);
#line 1137 "ease-slide.c"
}


#line 405 "ease-slide.vala"
void ease_slide_remove (EaseSlide* self, EaseElement* e) {
#line 405 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 405 "ease-slide.vala"
	g_return_if_fail (e != NULL);
#line 407 "ease-slide.vala"
	ease_slide_remove_actual (self, e, TRUE);
#line 1149 "ease-slide.c"
}


#line 413 "ease-slide.vala"
void ease_slide_remove_actual (EaseSlide* self, EaseElement* e, gboolean emit_undo) {
#line 1155 "ease-slide.c"
	gint index;
#line 413 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 413 "ease-slide.vala"
	g_return_if_fail (e != NULL);
#line 415 "ease-slide.vala"
	if (emit_undo) {
#line 1163 "ease-slide.c"
		EaseElementRemoveUndoAction* _tmp0_;
#line 415 "ease-slide.vala"
		g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp0_ = ease_element_remove_undo_action_new (e)));
#line 1167 "ease-slide.c"
		_g_object_unref0 (_tmp0_);
	}
#line 416 "ease-slide.vala"
	index = ease_slide_index_of (self, e);
#line 417 "ease-slide.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) self->elements, e);
#line 418 "ease-slide.vala"
	g_signal_emit_by_name (self, "element-removed", self, e, index);
#line 419 "ease-slide.vala"
	ease_undo_source_silence ((EaseUndoSource*) self, (EaseUndoSource*) e);
#line 421 "ease-slide.vala"
	if (EASE_IS_TEXT_ELEMENT (e)) {
#line 1180 "ease-slide.c"
		gboolean _tmp1_ = FALSE;
		EaseElement* _tmp2_;
#line 423 "ease-slide.vala"
		if (_vala_strcmp0 (ease_element_get_identifier ((EaseElement*) (_tmp2_ = e, EASE_IS_TEXT_ELEMENT (_tmp2_) ? ((EaseTextElement*) _tmp2_) : NULL)), EASE_THEME_TITLE_TEXT) == 0) {
#line 423 "ease-slide.vala"
			_tmp1_ = TRUE;
#line 1187 "ease-slide.c"
		} else {
			EaseElement* _tmp3_;
#line 424 "ease-slide.vala"
			_tmp1_ = _vala_strcmp0 (ease_element_get_identifier ((EaseElement*) (_tmp3_ = e, EASE_IS_TEXT_ELEMENT (_tmp3_) ? ((EaseTextElement*) _tmp3_) : NULL)), EASE_THEME_HEADER_TEXT) == 0;
#line 1192 "ease-slide.c"
		}
#line 423 "ease-slide.vala"
		if (_tmp1_) {
#line 426 "ease-slide.vala"
			g_signal_emit_by_name (self, "title-reset", self);
#line 1198 "ease-slide.c"
		}
	}
}


#line 434 "ease-slide.vala"
void ease_slide_remove_at (EaseSlide* self, gint index) {
#line 1206 "ease-slide.c"
	EaseElement* e;
#line 434 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 436 "ease-slide.vala"
	e = (EaseElement*) gee_abstract_list_get ((GeeAbstractList*) self->elements, index);
#line 437 "ease-slide.vala"
	ease_slide_remove (self, e);
#line 1214 "ease-slide.c"
	_g_object_unref0 (e);
}


#line 443 "ease-slide.vala"
gint ease_slide_index_of (EaseSlide* self, EaseElement* e) {
#line 1221 "ease-slide.c"
	gint result = 0;
#line 443 "ease-slide.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 443 "ease-slide.vala"
	g_return_val_if_fail (e != NULL, 0);
#line 1227 "ease-slide.c"
	result = gee_abstract_list_index_of ((GeeAbstractList*) self->elements, e);
#line 445 "ease-slide.vala"
	return result;
#line 1231 "ease-slide.c"
}


#line 451 "ease-slide.vala"
EaseElement* ease_slide_element_at (EaseSlide* self, gint i) {
#line 1237 "ease-slide.c"
	EaseElement* result = NULL;
#line 451 "ease-slide.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1241 "ease-slide.c"
	result = (EaseElement*) gee_abstract_list_get ((GeeAbstractList*) self->elements, i);
#line 453 "ease-slide.vala"
	return result;
#line 1245 "ease-slide.c"
}


#line 460 "ease-slide.vala"
void ease_slide_raise (EaseSlide* self, EaseElement* element) {
#line 1251 "ease-slide.c"
	EaseElement* _tmp0_;
	gboolean _tmp1_;
	gint index;
	EaseElement* temp;
	EaseElementReorderUndoAction* _tmp2_;
#line 460 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 460 "ease-slide.vala"
	g_return_if_fail (element != NULL);
#line 462 "ease-slide.vala"
	if ((_tmp1_ = element == (_tmp0_ = (EaseElement*) gee_abstract_list_last ((GeeAbstractList*) self->elements)), _g_object_unref0 (_tmp0_), _tmp1_)) {
#line 462 "ease-slide.vala"
		return;
#line 1265 "ease-slide.c"
	}
#line 464 "ease-slide.vala"
	index = gee_abstract_list_index_of ((GeeAbstractList*) self->elements, element);
#line 465 "ease-slide.vala"
	temp = (EaseElement*) gee_abstract_list_get ((GeeAbstractList*) self->elements, index + 1);
#line 466 "ease-slide.vala"
	gee_abstract_list_set ((GeeAbstractList*) self->elements, index + 1, element);
#line 467 "ease-slide.vala"
	gee_abstract_list_set ((GeeAbstractList*) self->elements, index, temp);
#line 468 "ease-slide.vala"
	g_signal_emit_by_name (self, "element-reordered", self, element);
#line 469 "ease-slide.vala"
	g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp2_ = ease_element_reorder_undo_action_new (element, index, index + 1)));
#line 1279 "ease-slide.c"
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (temp);
}


#line 476 "ease-slide.vala"
void ease_slide_lower (EaseSlide* self, EaseElement* element) {
#line 1287 "ease-slide.c"
	EaseElement* _tmp0_;
	gboolean _tmp1_;
	gint index;
	EaseElement* temp;
	EaseElementReorderUndoAction* _tmp2_;
#line 476 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 476 "ease-slide.vala"
	g_return_if_fail (element != NULL);
#line 478 "ease-slide.vala"
	if ((_tmp1_ = element == (_tmp0_ = (EaseElement*) gee_abstract_list_first ((GeeAbstractList*) self->elements)), _g_object_unref0 (_tmp0_), _tmp1_)) {
#line 478 "ease-slide.vala"
		return;
#line 1301 "ease-slide.c"
	}
#line 480 "ease-slide.vala"
	index = gee_abstract_list_index_of ((GeeAbstractList*) self->elements, element);
#line 481 "ease-slide.vala"
	temp = (EaseElement*) gee_abstract_list_get ((GeeAbstractList*) self->elements, index - 1);
#line 482 "ease-slide.vala"
	gee_abstract_list_set ((GeeAbstractList*) self->elements, index - 1, element);
#line 483 "ease-slide.vala"
	gee_abstract_list_set ((GeeAbstractList*) self->elements, index, temp);
#line 484 "ease-slide.vala"
	g_signal_emit_by_name (self, "element-reordered", self, element);
#line 485 "ease-slide.vala"
	g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp2_ = ease_element_reorder_undo_action_new (element, index, index - 1)));
#line 1315 "ease-slide.c"
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (temp);
}


#line 492 "ease-slide.vala"
void ease_slide_raise_top (EaseSlide* self, EaseElement* element) {
#line 1323 "ease-slide.c"
	EaseElement* _tmp0_;
	gboolean _tmp1_;
	gint index;
	EaseElementReorderUndoAction* _tmp2_;
#line 492 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 492 "ease-slide.vala"
	g_return_if_fail (element != NULL);
#line 494 "ease-slide.vala"
	if ((_tmp1_ = element == (_tmp0_ = (EaseElement*) gee_abstract_list_last ((GeeAbstractList*) self->elements)), _g_object_unref0 (_tmp0_), _tmp1_)) {
#line 494 "ease-slide.vala"
		return;
#line 1336 "ease-slide.c"
	}
#line 496 "ease-slide.vala"
	index = gee_abstract_list_index_of ((GeeAbstractList*) self->elements, element);
#line 497 "ease-slide.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) self->elements, element);
#line 498 "ease-slide.vala"
	gee_deque_offer_tail ((GeeDeque*) self->elements, element);
#line 499 "ease-slide.vala"
	g_signal_emit_by_name (self, "element-reordered", self, element);
#line 500 "ease-slide.vala"
	g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp2_ = ease_element_reorder_undo_action_new (element, index, gee_abstract_list_index_of ((GeeAbstractList*) self->elements, element))));
#line 1348 "ease-slide.c"
	_g_object_unref0 (_tmp2_);
}


#line 508 "ease-slide.vala"
void ease_slide_lower_bottom (EaseSlide* self, EaseElement* element) {
#line 1355 "ease-slide.c"
	EaseElement* _tmp0_;
	gboolean _tmp1_;
	gint index;
	EaseElementReorderUndoAction* _tmp2_;
#line 508 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 508 "ease-slide.vala"
	g_return_if_fail (element != NULL);
#line 510 "ease-slide.vala"
	if ((_tmp1_ = element == (_tmp0_ = (EaseElement*) gee_abstract_list_first ((GeeAbstractList*) self->elements)), _g_object_unref0 (_tmp0_), _tmp1_)) {
#line 510 "ease-slide.vala"
		return;
#line 1368 "ease-slide.c"
	}
#line 512 "ease-slide.vala"
	index = gee_abstract_list_index_of ((GeeAbstractList*) self->elements, element);
#line 513 "ease-slide.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) self->elements, element);
#line 514 "ease-slide.vala"
	gee_deque_offer_head ((GeeDeque*) self->elements, element);
#line 515 "ease-slide.vala"
	g_signal_emit_by_name (self, "element-reordered", self, element);
#line 516 "ease-slide.vala"
	g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp2_ = ease_element_reorder_undo_action_new (element, index, gee_abstract_list_index_of ((GeeAbstractList*) self->elements, element))));
#line 1380 "ease-slide.c"
	_g_object_unref0 (_tmp2_);
}


#line 523 "ease-slide.vala"
void ease_slide_reorder (EaseSlide* self, EaseElement* element, gint current, gint target) {
#line 523 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 523 "ease-slide.vala"
	g_return_if_fail (element != NULL);
#line 525 "ease-slide.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) self->elements, element);
#line 526 "ease-slide.vala"
	gee_abstract_list_insert ((GeeAbstractList*) self->elements, target, element);
#line 527 "ease-slide.vala"
	g_signal_emit_by_name (self, "element-reordered", self, element);
#line 1397 "ease-slide.c"
}


#line 535 "ease-slide.vala"
void ease_slide_cairo_render (EaseSlide* self, cairo_t* context, GError** error) {
#line 1403 "ease-slide.c"
	GError * _inner_error_;
#line 535 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 535 "ease-slide.vala"
	g_return_if_fail (context != NULL);
#line 1409 "ease-slide.c"
	_inner_error_ = NULL;
#line 537 "ease-slide.vala"
	if (self->priv->_parent == NULL) {
#line 1413 "ease-slide.c"
		_inner_error_ = g_error_new ((GQuark) 0, 0, "Slide must have a parent document", NULL);
		{
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
#line 540 "ease-slide.vala"
	ease_slide_cairo_render_sized (self, context, ease_document_get_width (self->priv->_parent), ease_document_get_height (self->priv->_parent), &_inner_error_);
#line 1422 "ease-slide.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


#line 550 "ease-slide.vala"
void ease_slide_cairo_render_sized (EaseSlide* self, cairo_t* context, gint w, gint h, GError** error) {
#line 1432 "ease-slide.c"
	GError * _inner_error_;
#line 550 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 550 "ease-slide.vala"
	g_return_if_fail (context != NULL);
#line 1438 "ease-slide.c"
	_inner_error_ = NULL;
#line 553 "ease-slide.vala"
	cairo_save (context);
#line 554 "ease-slide.vala"
	ease_slide_cairo_render_background (self, context, w, h, &_inner_error_);
#line 1444 "ease-slide.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
#line 555 "ease-slide.vala"
	cairo_restore (context);
#line 1451 "ease-slide.c"
	{
		GeeIterator* _e_it;
#line 557 "ease-slide.vala"
		_e_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->elements);
#line 557 "ease-slide.vala"
		while (TRUE) {
#line 1458 "ease-slide.c"
			EaseElement* e;
#line 557 "ease-slide.vala"
			if (!gee_iterator_next (_e_it)) {
#line 557 "ease-slide.vala"
				break;
#line 1464 "ease-slide.c"
			}
#line 557 "ease-slide.vala"
			e = (EaseElement*) gee_iterator_get (_e_it);
#line 559 "ease-slide.vala"
			cairo_save (context);
#line 560 "ease-slide.vala"
			cairo_translate (context, (double) ease_element_get_x (e), (double) ease_element_get_y (e));
#line 561 "ease-slide.vala"
			ease_element_cairo_render (e, context, &_inner_error_);
#line 1474 "ease-slide.c"
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (e);
				_g_object_unref0 (_e_it);
				return;
			}
#line 562 "ease-slide.vala"
			cairo_restore (context);
#line 1483 "ease-slide.c"
			_g_object_unref0 (e);
		}
		_g_object_unref0 (_e_it);
	}
}


#line 573 "ease-slide.vala"
void ease_slide_cairo_render_background (EaseSlide* self, cairo_t* cr, gint w, gint h, GError** error) {
#line 1493 "ease-slide.c"
	const char* _tmp0_;
#line 573 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 573 "ease-slide.vala"
	g_return_if_fail (cr != NULL);
#line 576 "ease-slide.vala"
	cairo_save (cr);
#line 1501 "ease-slide.c"
	_tmp0_ = NULL;
#line 578 "ease-slide.vala"
	if (self->priv->_parent == NULL) {
#line 578 "ease-slide.vala"
		_tmp0_ = ease_theme_get_path (self->priv->_theme);
#line 1507 "ease-slide.c"
	} else {
#line 578 "ease-slide.vala"
		_tmp0_ = ease_document_get_path (self->priv->_parent);
#line 1511 "ease-slide.c"
	}
#line 577 "ease-slide.vala"
	ease_background_set_cairo (self->priv->_background, cr, w, h, _tmp0_);
#line 579 "ease-slide.vala"
	cairo_rectangle (cr, (double) 0, (double) 0, (double) w, (double) h);
#line 580 "ease-slide.vala"
	cairo_fill (cr);
#line 581 "ease-slide.vala"
	cairo_restore (cr);
#line 1521 "ease-slide.c"
}


#line 1085 "glib-2.0.vapi"
static char* string_substring (const char* self, glong offset, glong len) {
#line 1527 "ease-slide.c"
	char* result = NULL;
	glong string_length;
	const char* start;
#line 1085 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1086 "glib-2.0.vapi"
	string_length = g_utf8_strlen (self, -1);
#line 1087 "glib-2.0.vapi"
	if (offset < 0) {
#line 1088 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1089 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= 0, NULL);
#line 1541 "ease-slide.c"
	} else {
#line 1091 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 1545 "ease-slide.c"
	}
#line 1093 "glib-2.0.vapi"
	if (len < 0) {
#line 1094 "glib-2.0.vapi"
		len = string_length - offset;
#line 1551 "ease-slide.c"
	}
#line 1096 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1097 "glib-2.0.vapi"
	start = g_utf8_offset_to_pointer (self, offset);
#line 1557 "ease-slide.c"
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
#line 1098 "glib-2.0.vapi"
	return result;
#line 1561 "ease-slide.c"
}


#line 594 "ease-slide.vala"
void ease_slide_to_html (EaseSlide* self, char** html, EaseHTMLExporter* exporter, double amount, gint index) {
#line 1567 "ease-slide.c"
	char* _tmp3_;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp24_;
#line 594 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 594 "ease-slide.vala"
	g_return_if_fail (html != NULL);
#line 594 "ease-slide.vala"
	g_return_if_fail (exporter != NULL);
#line 600 "ease-slide.vala"
	*html = (_tmp3_ = g_strconcat (*html, _tmp2_ = g_strconcat (_tmp1_ = g_strconcat ("<div class=\"slide\" id=\"slide", _tmp0_ = g_strdup_printf ("%i", index), NULL), "\" ", NULL), NULL), _g_free0 (*html), _tmp3_);
#line 1581 "ease-slide.c"
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
#line 603 "ease-slide.vala"
	if (ease_image_get_filename (ease_background_get_image (self->priv->_background)) == NULL) {
#line 1587 "ease-slide.c"
		char* _tmp10_;
		char* _tmp9_;
		char* _tmp8_;
		char* _tmp7_;
		char* _tmp6_;
		ClutterColor _tmp5_;
		ClutterColor _tmp4_ = {0};
#line 606 "ease-slide.vala"
		*html = (_tmp10_ = g_strconcat (*html, _tmp9_ = g_strconcat (_tmp8_ = g_strconcat ("style=\"background-color: ", _tmp7_ = string_substring (_tmp6_ = clutter_color_to_string ((_tmp5_ = (ease_color_get_clutter (ease_background_get_color (self->priv->_background), &_tmp4_), _tmp4_), &_tmp5_)), (glong) 0, (glong) 7), NULL), "\">", NULL), NULL), _g_free0 (*html), _tmp10_);
#line 1597 "ease-slide.c"
		_g_free0 (_tmp9_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp6_);
	} else {
		char* _tmp11_;
		char* _tmp23_;
		char* _tmp22_;
		char* _tmp21_;
		char* _tmp20_;
		char* _tmp19_;
		char* _tmp18_;
		char* _tmp17_;
		char* _tmp16_;
		char* _tmp15_;
		char* _tmp14_;
		char* _tmp13_;
		char* _tmp12_;
#line 613 "ease-slide.vala"
		*html = (_tmp11_ = g_strconcat (*html, ">", NULL), _g_free0 (*html), _tmp11_);
#line 616 "ease-slide.vala"
		*html = (_tmp23_ = g_strconcat (*html, _tmp22_ = g_strconcat (_tmp21_ = g_strconcat (_tmp19_ = g_strconcat (_tmp18_ = g_strconcat (_tmp16_ = g_strconcat (_tmp15_ = g_strconcat (_tmp14_ = g_strconcat (_tmp13_ = g_strconcat ("<img src=\"", _tmp12_ = ease_html_exporter_get_basename (exporter), NULL), " ", NULL), ease_image_get_filename (ease_background_get_image (self->priv->_background)), NULL), "\" alt=\"Background\" width=\"", NULL), _tmp17_ = g_strdup_printf ("%i", ease_document_get_width (self->priv->_parent)), NULL), "\" height=\"", NULL), _tmp20_ = g_strdup_printf ("%i", ease_document_get_height (self->priv->_parent)), NULL), "\"/>", NULL), NULL), _g_free0 (*html), _tmp23_);
#line 1620 "ease-slide.c"
		_g_free0 (_tmp22_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp12_);
#line 622 "ease-slide.vala"
		ease_html_exporter_copy_file (exporter, ease_image_get_filename (ease_background_get_image (self->priv->_background)), ease_document_get_path (self->priv->_parent));
#line 1634 "ease-slide.c"
	}
	{
		GeeIterator* _e_it;
#line 626 "ease-slide.vala"
		_e_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->elements);
#line 626 "ease-slide.vala"
		while (TRUE) {
#line 1642 "ease-slide.c"
			EaseElement* e;
#line 626 "ease-slide.vala"
			if (!gee_iterator_next (_e_it)) {
#line 626 "ease-slide.vala"
				break;
#line 1648 "ease-slide.c"
			}
#line 626 "ease-slide.vala"
			e = (EaseElement*) gee_iterator_get (_e_it);
#line 628 "ease-slide.vala"
			ease_element_to_html (e, html, exporter, amount / gee_collection_get_size ((GeeCollection*) self->elements));
#line 1654 "ease-slide.c"
			_g_object_unref0 (e);
		}
		_g_object_unref0 (_e_it);
	}
#line 631 "ease-slide.vala"
	*html = (_tmp24_ = g_strconcat (*html, "</div>\n", NULL), _g_free0 (*html), _tmp24_);
#line 1661 "ease-slide.c"
}


#line 638 "ease-slide.vala"
static void ease_slide_update_title (EaseSlide* self, GObject* object) {
#line 638 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 638 "ease-slide.vala"
	g_return_if_fail (object != NULL);
#line 640 "ease-slide.vala"
	if (EASE_IS_TEXT_ELEMENT (object)) {
#line 1673 "ease-slide.c"
		gboolean _tmp0_ = FALSE;
		GObject* _tmp1_;
#line 642 "ease-slide.vala"
		if (_vala_strcmp0 (ease_element_get_identifier ((EaseElement*) (_tmp1_ = object, EASE_IS_TEXT_ELEMENT (_tmp1_) ? ((EaseTextElement*) _tmp1_) : NULL)), EASE_THEME_TITLE_TEXT) == 0) {
#line 642 "ease-slide.vala"
			_tmp0_ = TRUE;
#line 1680 "ease-slide.c"
		} else {
			GObject* _tmp2_;
#line 643 "ease-slide.vala"
			_tmp0_ = _vala_strcmp0 (ease_element_get_identifier ((EaseElement*) (_tmp2_ = object, EASE_IS_TEXT_ELEMENT (_tmp2_) ? ((EaseTextElement*) _tmp2_) : NULL)), EASE_THEME_HEADER_TEXT) == 0;
#line 1685 "ease-slide.c"
		}
#line 642 "ease-slide.vala"
		if (_tmp0_) {
#line 1689 "ease-slide.c"
			GObject* _tmp3_;
#line 645 "ease-slide.vala"
			g_signal_emit_by_name (self, "title-changed", self, ease_text_element_get_text ((_tmp3_ = object, EASE_IS_TEXT_ELEMENT (_tmp3_) ? ((EaseTextElement*) _tmp3_) : NULL)));
#line 1693 "ease-slide.c"
		}
	}
}


#line 655 "ease-slide.vala"
EaseSlideIterator* ease_slide_iterator (EaseSlide* self) {
#line 1701 "ease-slide.c"
	EaseSlideIterator* result = NULL;
#line 655 "ease-slide.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1705 "ease-slide.c"
	result = ease_slide_iterator_new (self);
#line 657 "ease-slide.vala"
	return result;
#line 1709 "ease-slide.c"
}


EaseTransition ease_slide_get_transition (EaseSlide* self) {
	EaseTransition result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_transition;
#line 39 "ease-slide.vala"
	return result;
#line 1719 "ease-slide.c"
}


void ease_slide_set_transition (EaseSlide* self, EaseTransition value) {
	g_return_if_fail (self != NULL);
	self->priv->_transition = value;
	g_object_notify ((GObject *) self, "transition");
}


EaseTransitionVariant ease_slide_get_variant (EaseSlide* self) {
	EaseTransitionVariant result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_variant;
#line 44 "ease-slide.vala"
	return result;
#line 1736 "ease-slide.c"
}


void ease_slide_set_variant (EaseSlide* self, EaseTransitionVariant value) {
	g_return_if_fail (self != NULL);
	self->priv->_variant = value;
	g_object_notify ((GObject *) self, "variant");
}


double ease_slide_get_transition_time (EaseSlide* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_transition_time;
#line 49 "ease-slide.vala"
	return result;
#line 1753 "ease-slide.c"
}


void ease_slide_set_transition_time (EaseSlide* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_transition_time = value;
	g_object_notify ((GObject *) self, "transition-time");
}


guint ease_slide_get_transition_msecs (EaseSlide* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = (guint) (self->priv->_transition_time * 1000);
#line 56 "ease-slide.vala"
	return result;
#line 1770 "ease-slide.c"
}


void ease_slide_set_transition_msecs (EaseSlide* self, guint value) {
	g_return_if_fail (self != NULL);
#line 57 "ease-slide.vala"
	ease_slide_set_transition_time (self, (double) (value / 1000.f));
#line 1778 "ease-slide.c"
	g_object_notify ((GObject *) self, "transition-msecs");
}


gboolean ease_slide_get_automatically_advance (EaseSlide* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_automatically_advance;
#line 63 "ease-slide.vala"
	return result;
#line 1789 "ease-slide.c"
}


void ease_slide_set_automatically_advance (EaseSlide* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_automatically_advance = value;
	g_object_notify ((GObject *) self, "automatically-advance");
}


double ease_slide_get_advance_delay (EaseSlide* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_advance_delay;
#line 68 "ease-slide.vala"
	return result;
#line 1806 "ease-slide.c"
}


void ease_slide_set_advance_delay (EaseSlide* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_advance_delay = value;
	g_object_notify ((GObject *) self, "advance-delay");
}


EaseBackground* ease_slide_get_background (EaseSlide* self) {
	EaseBackground* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_background;
#line 73 "ease-slide.vala"
	return result;
#line 1823 "ease-slide.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void ease_slide_set_background (EaseSlide* self, EaseBackground* value) {
	EaseBackground* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_background = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_background), _tmp0_);
	g_object_notify ((GObject *) self, "background");
}


char* ease_slide_get_background_abs (EaseSlide* self) {
	char* result;
	const char* _tmp0_;
	char* p;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
#line 82 "ease-slide.vala"
	if (self->priv->_parent == NULL) {
#line 82 "ease-slide.vala"
		_tmp0_ = ease_theme_get_path (self->priv->_theme);
#line 1850 "ease-slide.c"
	} else {
#line 82 "ease-slide.vala"
		_tmp0_ = ease_document_get_path (self->priv->_parent);
#line 1854 "ease-slide.c"
	}
#line 82 "ease-slide.vala"
	p = g_strdup (_tmp0_);
#line 1858 "ease-slide.c"
	result = g_build_filename (p, ease_image_get_filename (ease_background_get_image (self->priv->_background)), NULL);
	_g_free0 (p);
#line 83 "ease-slide.vala"
	return result;
#line 1863 "ease-slide.c"
}


EaseDocument* ease_slide_get_parent (EaseSlide* self) {
	EaseDocument* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_parent;
#line 90 "ease-slide.vala"
	return result;
#line 1873 "ease-slide.c"
}


void ease_slide_set_parent (EaseSlide* self, EaseDocument* value) {
	EaseDocument* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_parent = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_parent), _tmp0_);
	g_object_notify ((GObject *) self, "parent");
}


gint ease_slide_get_width (EaseSlide* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = ease_document_get_width (self->priv->_parent);
#line 95 "ease-slide.vala"
	return result;
#line 1891 "ease-slide.c"
}


gint ease_slide_get_height (EaseSlide* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = ease_document_get_height (self->priv->_parent);
#line 100 "ease-slide.vala"
	return result;
#line 1901 "ease-slide.c"
}


float ease_slide_get_aspect (EaseSlide* self) {
	float result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = ease_document_get_aspect (self->priv->_parent);
#line 105 "ease-slide.vala"
	return result;
#line 1911 "ease-slide.c"
}


EaseTheme* ease_slide_get_theme (EaseSlide* self) {
	EaseTheme* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_theme;
#line 110 "ease-slide.vala"
	return result;
#line 1921 "ease-slide.c"
}


void ease_slide_set_theme (EaseSlide* self, EaseTheme* value) {
	EaseTheme* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_theme = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_theme), _tmp0_);
	g_object_notify ((GObject *) self, "theme");
}


const char* ease_slide_get_master (EaseSlide* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_master;
#line 115 "ease-slide.vala"
	return result;
#line 1939 "ease-slide.c"
}


void ease_slide_set_master (EaseSlide* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_master = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_master), _tmp0_);
	g_object_notify ((GObject *) self, "master");
}


gint ease_slide_get_count (EaseSlide* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = gee_collection_get_size ((GeeCollection*) self->elements);
#line 120 "ease-slide.vala"
	return result;
#line 1957 "ease-slide.c"
}


EaseSlide* ease_slide_get_next (EaseSlide* self) {
	EaseSlide* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gint i;
#line 134 "ease-slide.vala"
		i = 0;
#line 1968 "ease-slide.c"
		{
			gboolean _tmp0_;
#line 134 "ease-slide.vala"
			_tmp0_ = TRUE;
#line 134 "ease-slide.vala"
			while (TRUE) {
#line 1975 "ease-slide.c"
				EaseSlide* _tmp1_;
				gboolean _tmp2_;
#line 134 "ease-slide.vala"
				if (!_tmp0_) {
#line 134 "ease-slide.vala"
					i++;
#line 1982 "ease-slide.c"
				}
#line 134 "ease-slide.vala"
				_tmp0_ = FALSE;
#line 134 "ease-slide.vala"
				if (!(i < (ease_iterable_list_store_get_size (self->priv->_parent->slides) - 1))) {
#line 134 "ease-slide.vala"
					break;
#line 1990 "ease-slide.c"
				}
#line 136 "ease-slide.vala"
				if ((_tmp2_ = (_tmp1_ = ease_document_get_slide (self->priv->_parent, i)) == self, _g_object_unref0 (_tmp1_), _tmp2_)) {
#line 1994 "ease-slide.c"
					result = ease_document_get_slide (self->priv->_parent, i + 1);
#line 138 "ease-slide.vala"
					return result;
#line 1998 "ease-slide.c"
				}
			}
		}
	}
	result = NULL;
#line 141 "ease-slide.vala"
	return result;
#line 2006 "ease-slide.c"
}


EaseSlide* ease_slide_get_previous (EaseSlide* self) {
	EaseSlide* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gint i;
#line 152 "ease-slide.vala"
		i = 1;
#line 2017 "ease-slide.c"
		{
			gboolean _tmp0_;
#line 152 "ease-slide.vala"
			_tmp0_ = TRUE;
#line 152 "ease-slide.vala"
			while (TRUE) {
#line 2024 "ease-slide.c"
				EaseSlide* _tmp1_;
				gboolean _tmp2_;
#line 152 "ease-slide.vala"
				if (!_tmp0_) {
#line 152 "ease-slide.vala"
					i++;
#line 2031 "ease-slide.c"
				}
#line 152 "ease-slide.vala"
				_tmp0_ = FALSE;
#line 152 "ease-slide.vala"
				if (!(i < ease_iterable_list_store_get_size (self->priv->_parent->slides))) {
#line 152 "ease-slide.vala"
					break;
#line 2039 "ease-slide.c"
				}
#line 154 "ease-slide.vala"
				if ((_tmp2_ = (_tmp1_ = ease_document_get_slide (self->priv->_parent, i)) == self, _g_object_unref0 (_tmp1_), _tmp2_)) {
#line 2043 "ease-slide.c"
					result = ease_document_get_slide (self->priv->_parent, i - 1);
#line 156 "ease-slide.vala"
					return result;
#line 2047 "ease-slide.c"
				}
			}
		}
	}
	result = NULL;
#line 159 "ease-slide.vala"
	return result;
#line 2055 "ease-slide.c"
}


#line 668 "ease-slide.vala"
EaseSlideIterator* ease_slide_iterator_construct (GType object_type, EaseSlide* slide) {
#line 2061 "ease-slide.c"
	EaseSlideIterator* self;
	EaseSlide* _tmp0_;
#line 668 "ease-slide.vala"
	g_return_val_if_fail (slide != NULL, NULL);
#line 2066 "ease-slide.c"
	self = (EaseSlideIterator*) g_type_create_instance (object_type);
#line 670 "ease-slide.vala"
	self->priv->self = (_tmp0_ = _g_object_ref0 (slide), _g_object_unref0 (self->priv->self), _tmp0_);
#line 2070 "ease-slide.c"
	return self;
}


#line 668 "ease-slide.vala"
EaseSlideIterator* ease_slide_iterator_new (EaseSlide* slide) {
#line 668 "ease-slide.vala"
	return ease_slide_iterator_construct (EASE_SLIDE_TYPE_ITERATOR, slide);
#line 2079 "ease-slide.c"
}


#line 673 "ease-slide.vala"
gboolean ease_slide_iterator_next (EaseSlideIterator* self) {
#line 2085 "ease-slide.c"
	gboolean result = FALSE;
#line 673 "ease-slide.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2089 "ease-slide.c"
	result = self->priv->i < gee_collection_get_size ((GeeCollection*) self->priv->self->elements);
#line 675 "ease-slide.vala"
	return result;
#line 2093 "ease-slide.c"
}


#line 678 "ease-slide.vala"
EaseElement* ease_slide_iterator_get (EaseSlideIterator* self) {
#line 2099 "ease-slide.c"
	EaseElement* result = NULL;
#line 678 "ease-slide.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 680 "ease-slide.vala"
	self->priv->i++;
#line 2105 "ease-slide.c"
	result = (EaseElement*) gee_abstract_list_get ((GeeAbstractList*) self->priv->self->elements, self->priv->i - 1);
#line 681 "ease-slide.vala"
	return result;
#line 2109 "ease-slide.c"
}


static void ease_slide_value_iterator_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void ease_slide_value_iterator_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		ease_slide_iterator_unref (value->data[0].v_pointer);
	}
}


static void ease_slide_value_iterator_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ease_slide_iterator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer ease_slide_value_iterator_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* ease_slide_value_iterator_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		EaseSlideIterator* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ease_slide_iterator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* ease_slide_value_iterator_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	EaseSlideIterator** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ease_slide_iterator_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* ease_slide_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	EaseSlideParamSpecIterator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, EASE_SLIDE_TYPE_ITERATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer ease_slide_value_get_iterator (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EASE_SLIDE_TYPE_ITERATOR), NULL);
	return value->data[0].v_pointer;
}


void ease_slide_value_set_iterator (GValue* value, gpointer v_object) {
	EaseSlideIterator* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EASE_SLIDE_TYPE_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EASE_SLIDE_TYPE_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ease_slide_iterator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ease_slide_iterator_unref (old);
	}
}


void ease_slide_value_take_iterator (GValue* value, gpointer v_object) {
	EaseSlideIterator* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EASE_SLIDE_TYPE_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EASE_SLIDE_TYPE_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ease_slide_iterator_unref (old);
	}
}


static void ease_slide_iterator_class_init (EaseSlideIteratorClass * klass) {
	ease_slide_iterator_parent_class = g_type_class_peek_parent (klass);
	EASE_SLIDE_ITERATOR_CLASS (klass)->finalize = ease_slide_iterator_finalize;
	g_type_class_add_private (klass, sizeof (EaseSlideIteratorPrivate));
}


static void ease_slide_iterator_instance_init (EaseSlideIterator * self) {
	self->priv = EASE_SLIDE_ITERATOR_GET_PRIVATE (self);
	self->priv->i = 0;
	self->ref_count = 1;
}


static void ease_slide_iterator_finalize (EaseSlideIterator* obj) {
	EaseSlideIterator * self;
	self = EASE_SLIDE_ITERATOR (obj);
	_g_object_unref0 (self->priv->self);
}


GType ease_slide_iterator_get_type (void) {
	static volatile gsize ease_slide_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&ease_slide_iterator_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { ease_slide_value_iterator_init, ease_slide_value_iterator_free_value, ease_slide_value_iterator_copy_value, ease_slide_value_iterator_peek_pointer, "p", ease_slide_value_iterator_collect_value, "p", ease_slide_value_iterator_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (EaseSlideIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_slide_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseSlideIterator), 0, (GInstanceInitFunc) ease_slide_iterator_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType ease_slide_iterator_type_id;
		ease_slide_iterator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EaseSlideIterator", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&ease_slide_iterator_type_id__volatile, ease_slide_iterator_type_id);
	}
	return ease_slide_iterator_type_id__volatile;
}


gpointer ease_slide_iterator_ref (gpointer instance) {
	EaseSlideIterator* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void ease_slide_iterator_unref (gpointer instance) {
	EaseSlideIterator* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		EASE_SLIDE_ITERATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void ease_slide_class_init (EaseSlideClass * klass) {
	ease_slide_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseSlidePrivate));
	G_OBJECT_CLASS (klass)->get_property = ease_slide_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_slide_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_slide_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_TRANSITION, g_param_spec_enum ("transition", "transition", "transition", EASE_TYPE_TRANSITION, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_VARIANT, g_param_spec_enum ("variant", "variant", "variant", EASE_TYPE_TRANSITION_VARIANT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_TRANSITION_TIME, g_param_spec_double ("transition-time", "transition-time", "transition-time", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_TRANSITION_MSECS, g_param_spec_uint ("transition-msecs", "transition-msecs", "transition-msecs", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_AUTOMATICALLY_ADVANCE, g_param_spec_boolean ("automatically-advance", "automatically-advance", "automatically-advance", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_ADVANCE_DELAY, g_param_spec_double ("advance-delay", "advance-delay", "advance-delay", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_BACKGROUND, g_param_spec_object ("background", "background", "background", EASE_TYPE_BACKGROUND, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_BACKGROUND_ABS, g_param_spec_string ("background-abs", "background-abs", "background-abs", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_PARENT, g_param_spec_object ("parent", "parent", "parent", EASE_TYPE_DOCUMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_WIDTH, g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_HEIGHT, g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_ASPECT, g_param_spec_float ("aspect", "aspect", "aspect", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_THEME, g_param_spec_object ("theme", "theme", "theme", EASE_TYPE_THEME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_MASTER, g_param_spec_string ("master", "master", "master", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_COUNT, g_param_spec_int ("count", "count", "count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_NEXT, g_param_spec_object ("next", "next", "next", EASE_TYPE_SLIDE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_PREVIOUS, g_param_spec_object ("previous", "previous", "previous", EASE_TYPE_SLIDE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("request_advance", EASE_TYPE_SLIDE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_ELEMENT);
	g_signal_new ("changed", EASE_TYPE_SLIDE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_SLIDE);
	g_signal_new ("background_changed", EASE_TYPE_SLIDE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_SLIDE);
	g_signal_new ("element_added", EASE_TYPE_SLIDE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_INT, G_TYPE_NONE, 3, EASE_TYPE_SLIDE, EASE_TYPE_ELEMENT, G_TYPE_INT);
	g_signal_new ("element_removed", EASE_TYPE_SLIDE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_INT, G_TYPE_NONE, 3, EASE_TYPE_SLIDE, EASE_TYPE_ELEMENT, G_TYPE_INT);
	g_signal_new ("element_reordered", EASE_TYPE_SLIDE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, EASE_TYPE_SLIDE, EASE_TYPE_ELEMENT);
	g_signal_new ("title_changed", EASE_TYPE_SLIDE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_STRING, G_TYPE_NONE, 2, EASE_TYPE_SLIDE, G_TYPE_STRING);
	g_signal_new ("title_reset", EASE_TYPE_SLIDE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_SLIDE);
}


static void ease_slide_ease_undo_source_interface_init (EaseUndoSourceIface * iface) {
	ease_slide_ease_undo_source_parent_iface = g_type_interface_peek_parent (iface);
}


static void ease_slide_instance_init (EaseSlide * self) {
	self->priv = EASE_SLIDE_GET_PRIVATE (self);
	self->elements = gee_linked_list_new (EASE_TYPE_ELEMENT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
}


static void ease_slide_finalize (GObject* obj) {
	EaseSlide * self;
	self = EASE_SLIDE (obj);
	_g_object_unref0 (self->elements);
	_g_object_unref0 (self->priv->_background);
	_g_object_unref0 (self->priv->_parent);
	_g_object_unref0 (self->priv->_theme);
	_g_free0 (self->priv->_master);
	G_OBJECT_CLASS (ease_slide_parent_class)->finalize (obj);
}


GType ease_slide_get_type (void) {
	static volatile gsize ease_slide_type_id__volatile = 0;
	if (g_once_init_enter (&ease_slide_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseSlideClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_slide_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseSlide), 0, (GInstanceInitFunc) ease_slide_instance_init, NULL };
		static const GInterfaceInfo ease_undo_source_info = { (GInterfaceInitFunc) ease_slide_ease_undo_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType ease_slide_type_id;
		ease_slide_type_id = g_type_register_static (G_TYPE_OBJECT, "EaseSlide", &g_define_type_info, 0);
		g_type_add_interface_static (ease_slide_type_id, EASE_TYPE_UNDO_SOURCE, &ease_undo_source_info);
		g_once_init_leave (&ease_slide_type_id__volatile, ease_slide_type_id);
	}
	return ease_slide_type_id__volatile;
}


static void ease_slide_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseSlide * self;
	self = EASE_SLIDE (object);
	switch (property_id) {
		case EASE_SLIDE_TRANSITION:
		g_value_set_enum (value, ease_slide_get_transition (self));
		break;
		case EASE_SLIDE_VARIANT:
		g_value_set_enum (value, ease_slide_get_variant (self));
		break;
		case EASE_SLIDE_TRANSITION_TIME:
		g_value_set_double (value, ease_slide_get_transition_time (self));
		break;
		case EASE_SLIDE_TRANSITION_MSECS:
		g_value_set_uint (value, ease_slide_get_transition_msecs (self));
		break;
		case EASE_SLIDE_AUTOMATICALLY_ADVANCE:
		g_value_set_boolean (value, ease_slide_get_automatically_advance (self));
		break;
		case EASE_SLIDE_ADVANCE_DELAY:
		g_value_set_double (value, ease_slide_get_advance_delay (self));
		break;
		case EASE_SLIDE_BACKGROUND:
		g_value_set_object (value, ease_slide_get_background (self));
		break;
		case EASE_SLIDE_BACKGROUND_ABS:
		g_value_take_string (value, ease_slide_get_background_abs (self));
		break;
		case EASE_SLIDE_PARENT:
		g_value_set_object (value, ease_slide_get_parent (self));
		break;
		case EASE_SLIDE_WIDTH:
		g_value_set_int (value, ease_slide_get_width (self));
		break;
		case EASE_SLIDE_HEIGHT:
		g_value_set_int (value, ease_slide_get_height (self));
		break;
		case EASE_SLIDE_ASPECT:
		g_value_set_float (value, ease_slide_get_aspect (self));
		break;
		case EASE_SLIDE_THEME:
		g_value_set_object (value, ease_slide_get_theme (self));
		break;
		case EASE_SLIDE_MASTER:
		g_value_set_string (value, ease_slide_get_master (self));
		break;
		case EASE_SLIDE_COUNT:
		g_value_set_int (value, ease_slide_get_count (self));
		break;
		case EASE_SLIDE_NEXT:
		g_value_take_object (value, ease_slide_get_next (self));
		break;
		case EASE_SLIDE_PREVIOUS:
		g_value_take_object (value, ease_slide_get_previous (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_slide_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseSlide * self;
	self = EASE_SLIDE (object);
	switch (property_id) {
		case EASE_SLIDE_TRANSITION:
		ease_slide_set_transition (self, g_value_get_enum (value));
		break;
		case EASE_SLIDE_VARIANT:
		ease_slide_set_variant (self, g_value_get_enum (value));
		break;
		case EASE_SLIDE_TRANSITION_TIME:
		ease_slide_set_transition_time (self, g_value_get_double (value));
		break;
		case EASE_SLIDE_TRANSITION_MSECS:
		ease_slide_set_transition_msecs (self, g_value_get_uint (value));
		break;
		case EASE_SLIDE_AUTOMATICALLY_ADVANCE:
		ease_slide_set_automatically_advance (self, g_value_get_boolean (value));
		break;
		case EASE_SLIDE_ADVANCE_DELAY:
		ease_slide_set_advance_delay (self, g_value_get_double (value));
		break;
		case EASE_SLIDE_BACKGROUND:
		ease_slide_set_background (self, g_value_get_object (value));
		break;
		case EASE_SLIDE_PARENT:
		ease_slide_set_parent (self, g_value_get_object (value));
		break;
		case EASE_SLIDE_THEME:
		ease_slide_set_theme (self, g_value_get_object (value));
		break;
		case EASE_SLIDE_MASTER:
		ease_slide_set_master (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_INT) (gpointer data1, gpointer arg_1, gpointer arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_INT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_int (param_values + 3), data2);
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_STRING) (gpointer data1, gpointer arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_string (param_values + 2), data2);
}



