/* ease-text-element.c generated by valac, the Vala compiler
 * generated from ease-text-element.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <clutter/clutter.h>
#include <gtk/gtk.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <pango/pangocairo.h>


#define EASE_TYPE_UNDO_SOURCE (ease_undo_source_get_type ())
#define EASE_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSource))
#define EASE_IS_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_SOURCE))
#define EASE_UNDO_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSourceIface))

typedef struct _EaseUndoSource EaseUndoSource;
typedef struct _EaseUndoSourceIface EaseUndoSourceIface;

#define EASE_TYPE_ELEMENT (ease_element_get_type ())
#define EASE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT, EaseElement))
#define EASE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT, EaseElementClass))
#define EASE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT))
#define EASE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT))
#define EASE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT, EaseElementClass))

typedef struct _EaseElement EaseElement;
typedef struct _EaseElementClass EaseElementClass;
typedef struct _EaseElementPrivate EaseElementPrivate;

#define EASE_TYPE_HTML_EXPORTER (ease_html_exporter_get_type ())
#define EASE_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporter))
#define EASE_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))
#define EASE_IS_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_HTML_EXPORTER))
#define EASE_IS_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_HTML_EXPORTER))
#define EASE_HTML_EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))

typedef struct _EaseHTMLExporter EaseHTMLExporter;
typedef struct _EaseHTMLExporterClass EaseHTMLExporterClass;

#define EASE_TYPE_ACTOR_CONTEXT (ease_actor_context_get_type ())

#define EASE_TYPE_ACTOR (ease_actor_get_type ())
#define EASE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ACTOR, EaseActor))
#define EASE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ACTOR, EaseActorClass))
#define EASE_IS_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ACTOR))
#define EASE_IS_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ACTOR))
#define EASE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ACTOR, EaseActorClass))

typedef struct _EaseActor EaseActor;
typedef struct _EaseActorClass EaseActorClass;

#define EASE_TYPE_TEXT_ELEMENT (ease_text_element_get_type ())
#define EASE_TEXT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_TEXT_ELEMENT, EaseTextElement))
#define EASE_TEXT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_TEXT_ELEMENT, EaseTextElementClass))
#define EASE_IS_TEXT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_TEXT_ELEMENT))
#define EASE_IS_TEXT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_TEXT_ELEMENT))
#define EASE_TEXT_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_TEXT_ELEMENT, EaseTextElementClass))

typedef struct _EaseTextElement EaseTextElement;
typedef struct _EaseTextElementClass EaseTextElementClass;
typedef struct _EaseTextElementPrivate EaseTextElementPrivate;

#define EASE_TYPE_COLOR (ease_color_get_type ())
#define EASE_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_COLOR, EaseColor))
#define EASE_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_COLOR, EaseColorClass))
#define EASE_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_COLOR))
#define EASE_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_COLOR))
#define EASE_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_COLOR, EaseColorClass))

typedef struct _EaseColor EaseColor;
typedef struct _EaseColorClass EaseColorClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define EASE_TYPE_TEXT_ACTOR (ease_text_actor_get_type ())
#define EASE_TEXT_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_TEXT_ACTOR, EaseTextActor))
#define EASE_TEXT_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_TEXT_ACTOR, EaseTextActorClass))
#define EASE_IS_TEXT_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_TEXT_ACTOR))
#define EASE_IS_TEXT_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_TEXT_ACTOR))
#define EASE_TEXT_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_TEXT_ACTOR, EaseTextActorClass))

typedef struct _EaseTextActor EaseTextActor;
typedef struct _EaseTextActorClass EaseTextActorClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _pango_font_description_free0(var) ((var == NULL) ? NULL : (var = (pango_font_description_free (var), NULL)))

#define EASE_TYPE_UNDO_ITEM (ease_undo_item_get_type ())
#define EASE_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItem))
#define EASE_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))
#define EASE_IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ITEM))
#define EASE_IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ITEM))
#define EASE_UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))

typedef struct _EaseUndoItem EaseUndoItem;
typedef struct _EaseUndoItemClass EaseUndoItemClass;

#define EASE_TYPE_UNDO_ACTION (ease_undo_action_get_type ())
#define EASE_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoAction))
#define EASE_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))
#define EASE_IS_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ACTION))
#define EASE_IS_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ACTION))
#define EASE_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))

typedef struct _EaseUndoAction EaseUndoAction;
typedef struct _EaseUndoActionClass EaseUndoActionClass;
typedef struct _Block10Data Block10Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _EaseUndoSourceIface {
	GTypeInterface parent_iface;
};

typedef enum  {
	EASE_ACTOR_CONTEXT_PRESENTATION,
	EASE_ACTOR_CONTEXT_EDITOR,
	EASE_ACTOR_CONTEXT_INSPECTOR
} EaseActorContext;

struct _EaseElement {
	GObject parent_instance;
	EaseElementPrivate * priv;
};

struct _EaseElementClass {
	GObjectClass parent_class;
	void (*signals) (EaseElement* self);
	JsonObject* (*to_json) (EaseElement* self);
	void (*to_html) (EaseElement* self, char** html, EaseHTMLExporter* exporter, double amount);
	char** (*claim_media) (EaseElement* self, int* result_length1);
	char* (*html_render) (EaseElement* self, EaseHTMLExporter* exporter);
	void (*cairo_render) (EaseElement* self, cairo_t* context, GError** error);
	EaseActor* (*actor) (EaseElement* self, EaseActorContext c);
	GtkWidget* (*inspector_widget) (EaseElement* self);
	GList* (*tool_items) (EaseElement* self);
	gboolean (*set_color) (EaseElement* self, ClutterColor* c);
	ClutterColor* (*get_color) (EaseElement* self);
};

struct _EaseTextElement {
	EaseElement parent_instance;
	EaseTextElementPrivate * priv;
};

struct _EaseTextElementClass {
	EaseElementClass parent_class;
};

struct _EaseTextElementPrivate {
	gboolean freeze;
	char* _text;
	EaseColor* _color;
	char* text_font_priv;
	PangoStyle text_style_priv;
	PangoVariant text_variant_priv;
	gint text_weight_priv;
	PangoAlignment _text_align;
	gint text_size_priv;
};

struct _Block10Data {
	int _ref_count_;
	EaseTextElement * self;
	GtkButton* left;
	GtkButton* center;
	GtkButton* right;
	GtkFontButton* font;
	GtkColorButton* color_b;
};


static gpointer ease_text_element_parent_class = NULL;

GType ease_undo_source_get_type (void) G_GNUC_CONST;
GType ease_element_get_type (void) G_GNUC_CONST;
GType ease_html_exporter_get_type (void) G_GNUC_CONST;
GType ease_actor_context_get_type (void) G_GNUC_CONST;
GType ease_actor_get_type (void) G_GNUC_CONST;
GType ease_text_element_get_type (void) G_GNUC_CONST;
GType ease_color_get_type (void) G_GNUC_CONST;
#define EASE_TEXT_ELEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_TEXT_ELEMENT, EaseTextElementPrivate))
enum  {
	EASE_TEXT_ELEMENT_DUMMY_PROPERTY,
	EASE_TEXT_ELEMENT_TEXT,
	EASE_TEXT_ELEMENT_DISPLAY_TEXT,
	EASE_TEXT_ELEMENT_COLOR,
	EASE_TEXT_ELEMENT_TEXT_FONT,
	EASE_TEXT_ELEMENT_TEXT_STYLE,
	EASE_TEXT_ELEMENT_TEXT_VARIANT,
	EASE_TEXT_ELEMENT_TEXT_WEIGHT,
	EASE_TEXT_ELEMENT_FONT_DESCRIPTION,
	EASE_TEXT_ELEMENT_TEXT_ALIGN,
	EASE_TEXT_ELEMENT_TEXT_SIZE
};
#define EASE_TEXT_ELEMENT_UI_FILE_PATH "inspector-element-text.ui"
#define EASE_TEXT_ELEMENT_DEFAULT_TEXT _ ("Double click to edit")
EaseElement* ease_element_construct (GType object_type);
void ease_element_signals (EaseElement* self);
EaseTextElement* ease_text_element_new (void);
EaseTextElement* ease_text_element_construct (GType object_type);
EaseElement* ease_element_construct_from_json (GType object_type, JsonObject* obj);
#define EASE_THEME_TEXT_TEXT "text"
void ease_text_element_set_text (EaseTextElement* self, const char* value);
EaseColor* ease_color_new_from_string (const char* str);
EaseColor* ease_color_construct_from_string (GType object_type, const char* str);
#define EASE_THEME_TEXT_COLOR "text-color"
void ease_text_element_set_color (EaseTextElement* self, EaseColor* value);
#define EASE_THEME_TEXT_FONT "text-font"
void ease_text_element_set_text_font (EaseTextElement* self, const char* value);
void ease_text_element_text_style_from_string (EaseTextElement* self, const char* str);
#define EASE_THEME_TEXT_STYLE "text-style"
void ease_text_element_text_variant_from_string (EaseTextElement* self, const char* str);
#define EASE_THEME_TEXT_VARIANT "text-variant"
void ease_text_element_text_weight_from_string (EaseTextElement* self, const char* str);
#define EASE_THEME_TEXT_WEIGHT "text-weight"
void ease_text_element_text_align_from_string (EaseTextElement* self, const char* str);
#define EASE_THEME_TEXT_ALIGN "text-align"
void ease_text_element_text_size_from_string (EaseTextElement* self, const char* str);
#define EASE_THEME_TEXT_SIZE "text-size"
EaseTextElement* ease_text_element_new_from_json (JsonObject* obj);
EaseTextElement* ease_text_element_construct_from_json (GType object_type, JsonObject* obj);
JsonObject* ease_element_to_json (EaseElement* self);
EaseColor* ease_text_element_get_color (EaseTextElement* self);
char* ease_color_to_string (EaseColor* self);
const char* ease_text_element_get_text (EaseTextElement* self);
const char* ease_text_element_get_text_font (EaseTextElement* self);
char* ease_text_element_text_style_to_string (EaseTextElement* self);
char* ease_text_element_text_variant_to_string (EaseTextElement* self);
char* ease_text_element_text_weight_to_string (EaseTextElement* self);
char* ease_text_element_text_align_to_string (EaseTextElement* self);
char* ease_text_element_text_size_to_string (EaseTextElement* self);
static JsonObject* ease_text_element_real_to_json (EaseElement* base);
EaseTextActor* ease_text_actor_new (EaseTextElement* e, EaseActorContext c);
EaseTextActor* ease_text_actor_construct (GType object_type, EaseTextElement* e, EaseActorContext c);
GType ease_text_actor_get_type (void) G_GNUC_CONST;
static EaseActor* ease_text_element_real_actor (EaseElement* base, EaseActorContext c);
EaseColor* ease_color_new_from_clutter (ClutterColor* color);
EaseColor* ease_color_construct_from_clutter (GType object_type, ClutterColor* color);
static gboolean ease_text_element_real_set_color (EaseElement* base, ClutterColor* c);
void ease_color_get_clutter (EaseColor* self, ClutterColor* result);
static ClutterColor* _clutter_color_dup (ClutterColor* self);
static ClutterColor* ease_text_element_real_get_color (EaseElement* base);
char* ease_data_path (const char* path);
#define EASE_TEMP_UI_DIR "ui"
PangoAlignment ease_text_element_get_text_align (EaseTextElement* self);
static void _lambda15_ (GObject* obj, GParamSpec* spec, Block10Data* _data10_);
static void __lambda15__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
PangoFontDescription* ease_text_element_get_font_description (EaseTextElement* self);
EaseUndoAction* ease_undo_action_new (GObject* obj, const char* prop);
EaseUndoAction* ease_undo_action_construct (GType object_type, GObject* obj, const char* prop);
GType ease_undo_item_get_type (void) G_GNUC_CONST;
GType ease_undo_action_get_type (void) G_GNUC_CONST;
void ease_text_element_set_font_description (EaseTextElement* self, const PangoFontDescription* value);
static void _lambda16_ (GtkFontButton* button, Block10Data* _data10_);
static void __lambda16__gtk_font_button_font_set (GtkFontButton* _sender, gpointer self);
static void _lambda17_ (GObject* obj, GParamSpec* spec, Block10Data* _data10_);
static void __lambda17__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void ease_color_get_gdk (EaseColor* self, GdkColor* result);
EaseColor* ease_color_new_from_gdk (GdkColor* color);
EaseColor* ease_color_construct_from_gdk (GType object_type, GdkColor* color);
static void _lambda18_ (GtkColorButton* button, Block10Data* _data10_);
static void __lambda18__gtk_color_button_color_set (GtkColorButton* _sender, gpointer self);
static void _lambda19_ (GObject* obj, GParamSpec* spec, Block10Data* _data10_);
static void __lambda19__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (Block10Data* _data10_);
static GtkWidget* ease_text_element_real_inspector_widget (EaseElement* base);
static void _lambda20_ (GtkWidget* widget, EaseTextElement* self);
static void __lambda20__gtk_callback (GtkWidget* widget, gpointer self);
void ease_text_element_on_inspector_alignment (GtkWidget* sender, EaseTextElement* self);
float ease_element_get_x (EaseElement* self);
float ease_element_get_y (EaseElement* self);
float ease_element_get_width (EaseElement* self);
double ease_color_get_red (EaseColor* self);
double ease_color_get_green (EaseColor* self);
double ease_color_get_blue (EaseColor* self);
static char* ease_text_element_real_html_render (EaseElement* base, EaseHTMLExporter* exporter);
const char* ease_text_element_get_display_text (EaseTextElement* self);
float ease_element_get_height (EaseElement* self);
void ease_color_set_cairo (EaseColor* self, cairo_t* cr);
static void ease_text_element_real_cairo_render (EaseElement* base, cairo_t* context, GError** error);
PangoStyle ease_text_element_get_text_style (EaseTextElement* self);
void ease_text_element_set_text_style (EaseTextElement* self, PangoStyle value);
void ease_text_element_set_text_variant (EaseTextElement* self, PangoVariant value);
PangoVariant ease_text_element_get_text_variant (EaseTextElement* self);
void ease_text_element_set_text_weight (EaseTextElement* self, gint value);
gint ease_text_element_get_text_weight (EaseTextElement* self);
void ease_text_element_set_text_align (EaseTextElement* self, PangoAlignment value);
void ease_text_element_set_text_size (EaseTextElement* self, gint value);
gint ease_text_element_get_text_size (EaseTextElement* self);
gboolean ease_element_get_has_been_edited (EaseElement* self);
static void ease_text_element_finalize (GObject* obj);
static void ease_text_element_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_text_element_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 30 "ease-text-element.vala"
EaseTextElement* ease_text_element_construct (GType object_type) {
#line 328 "ease-text-element.c"
	EaseTextElement * self;
#line 30 "ease-text-element.vala"
	self = (EaseTextElement*) ease_element_construct (object_type);
#line 32 "ease-text-element.vala"
	ease_element_signals ((EaseElement*) self);
#line 334 "ease-text-element.c"
	return self;
}


#line 30 "ease-text-element.vala"
EaseTextElement* ease_text_element_new (void) {
#line 30 "ease-text-element.vala"
	return ease_text_element_construct (EASE_TYPE_TEXT_ELEMENT);
#line 343 "ease-text-element.c"
}


#line 38 "ease-text-element.vala"
EaseTextElement* ease_text_element_construct_from_json (GType object_type, JsonObject* obj) {
#line 349 "ease-text-element.c"
	EaseTextElement * self;
	EaseColor* _tmp0_;
#line 38 "ease-text-element.vala"
	g_return_val_if_fail (obj != NULL, NULL);
#line 40 "ease-text-element.vala"
	self = (EaseTextElement*) ease_element_construct_from_json (object_type, obj);
#line 42 "ease-text-element.vala"
	ease_text_element_set_text (self, json_object_get_string_member (obj, EASE_THEME_TEXT_TEXT));
#line 43 "ease-text-element.vala"
	ease_text_element_set_color (self, _tmp0_ = ease_color_new_from_string (json_object_get_string_member (obj, EASE_THEME_TEXT_COLOR)));
#line 360 "ease-text-element.c"
	_g_object_unref0 (_tmp0_);
#line 44 "ease-text-element.vala"
	ease_text_element_set_text_font (self, json_object_get_string_member (obj, EASE_THEME_TEXT_FONT));
#line 45 "ease-text-element.vala"
	ease_text_element_text_style_from_string (self, json_object_get_string_member (obj, EASE_THEME_TEXT_STYLE));
#line 46 "ease-text-element.vala"
	ease_text_element_text_variant_from_string (self, json_object_get_string_member (obj, EASE_THEME_TEXT_VARIANT));
#line 47 "ease-text-element.vala"
	ease_text_element_text_weight_from_string (self, json_object_get_string_member (obj, EASE_THEME_TEXT_WEIGHT));
#line 48 "ease-text-element.vala"
	ease_text_element_text_align_from_string (self, json_object_get_string_member (obj, EASE_THEME_TEXT_ALIGN));
#line 49 "ease-text-element.vala"
	ease_text_element_text_size_from_string (self, json_object_get_string_member (obj, EASE_THEME_TEXT_SIZE));
#line 374 "ease-text-element.c"
	return self;
}


#line 38 "ease-text-element.vala"
EaseTextElement* ease_text_element_new_from_json (JsonObject* obj) {
#line 38 "ease-text-element.vala"
	return ease_text_element_construct_from_json (EASE_TYPE_TEXT_ELEMENT, obj);
#line 383 "ease-text-element.c"
}


#line 52 "ease-text-element.vala"
static JsonObject* ease_text_element_real_to_json (EaseElement* base) {
#line 389 "ease-text-element.c"
	EaseTextElement * self;
	JsonObject* result = NULL;
	JsonObject* obj;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	self = (EaseTextElement*) base;
#line 54 "ease-text-element.vala"
	obj = EASE_ELEMENT_CLASS (ease_text_element_parent_class)->to_json (EASE_ELEMENT (self));
#line 56 "ease-text-element.vala"
	json_object_set_string_member (obj, EASE_THEME_TEXT_COLOR, _tmp0_ = ease_color_to_string (self->priv->_color));
#line 404 "ease-text-element.c"
	_g_free0 (_tmp0_);
#line 57 "ease-text-element.vala"
	json_object_set_string_member (obj, EASE_THEME_TEXT_TEXT, self->priv->_text);
#line 58 "ease-text-element.vala"
	json_object_set_string_member (obj, EASE_THEME_TEXT_FONT, ease_text_element_get_text_font (self));
#line 59 "ease-text-element.vala"
	json_object_set_string_member (obj, EASE_THEME_TEXT_STYLE, _tmp1_ = ease_text_element_text_style_to_string (self));
#line 412 "ease-text-element.c"
	_g_free0 (_tmp1_);
#line 60 "ease-text-element.vala"
	json_object_set_string_member (obj, EASE_THEME_TEXT_VARIANT, _tmp2_ = ease_text_element_text_variant_to_string (self));
#line 416 "ease-text-element.c"
	_g_free0 (_tmp2_);
#line 61 "ease-text-element.vala"
	json_object_set_string_member (obj, EASE_THEME_TEXT_WEIGHT, _tmp3_ = ease_text_element_text_weight_to_string (self));
#line 420 "ease-text-element.c"
	_g_free0 (_tmp3_);
#line 62 "ease-text-element.vala"
	json_object_set_string_member (obj, EASE_THEME_TEXT_ALIGN, _tmp4_ = ease_text_element_text_align_to_string (self));
#line 424 "ease-text-element.c"
	_g_free0 (_tmp4_);
#line 63 "ease-text-element.vala"
	json_object_set_string_member (obj, EASE_THEME_TEXT_SIZE, _tmp5_ = ease_text_element_text_size_to_string (self));
#line 428 "ease-text-element.c"
	_g_free0 (_tmp5_);
	result = obj;
#line 65 "ease-text-element.vala"
	return result;
#line 433 "ease-text-element.c"
}


#line 68 "ease-text-element.vala"
static EaseActor* ease_text_element_real_actor (EaseElement* base, EaseActorContext c) {
#line 439 "ease-text-element.c"
	EaseTextElement * self;
	EaseActor* result = NULL;
	self = (EaseTextElement*) base;
	result = (EaseActor*) g_object_ref_sink (ease_text_actor_new (self, c));
#line 70 "ease-text-element.vala"
	return result;
#line 446 "ease-text-element.c"
}


#line 78 "ease-text-element.vala"
static gboolean ease_text_element_real_set_color (EaseElement* base, ClutterColor* c) {
#line 452 "ease-text-element.c"
	EaseTextElement * self;
	gboolean result = FALSE;
	EaseColor* _tmp0_;
	self = (EaseTextElement*) base;
#line 80 "ease-text-element.vala"
	ease_text_element_set_color (self, _tmp0_ = ease_color_new_from_clutter (c));
#line 459 "ease-text-element.c"
	_g_object_unref0 (_tmp0_);
	result = TRUE;
#line 81 "ease-text-element.vala"
	return result;
#line 464 "ease-text-element.c"
}


static ClutterColor* _clutter_color_dup (ClutterColor* self) {
	ClutterColor* dup;
	dup = g_new0 (ClutterColor, 1);
	memcpy (dup, self, sizeof (ClutterColor));
	return dup;
}


static gpointer __clutter_color_dup0 (gpointer self) {
	return self ? _clutter_color_dup (self) : NULL;
}


#line 87 "ease-text-element.vala"
static ClutterColor* ease_text_element_real_get_color (EaseElement* base) {
#line 483 "ease-text-element.c"
	EaseTextElement * self;
	ClutterColor* result = NULL;
	ClutterColor _tmp1_;
	ClutterColor _tmp0_ = {0};
	self = (EaseTextElement*) base;
	result = __clutter_color_dup0 ((_tmp1_ = (ease_color_get_clutter (self->priv->_color, &_tmp0_), _tmp0_), &_tmp1_));
#line 89 "ease-text-element.vala"
	return result;
#line 492 "ease-text-element.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 125 "ease-text-element.vala"
static void _lambda15_ (GObject* obj, GParamSpec* spec, Block10Data* _data10_) {
#line 503 "ease-text-element.c"
	EaseTextElement * self;
	self = _data10_->self;
#line 125 "ease-text-element.vala"
	g_return_if_fail (obj != NULL);
#line 125 "ease-text-element.vala"
	g_return_if_fail (spec != NULL);
#line 126 "ease-text-element.vala"
	switch (self->priv->_text_align) {
#line 512 "ease-text-element.c"
		case PANGO_ALIGN_LEFT:
		{
#line 129 "ease-text-element.vala"
			gtk_button_set_relief (_data10_->left, GTK_RELIEF_NORMAL);
#line 130 "ease-text-element.vala"
			gtk_button_set_relief (_data10_->center, GTK_RELIEF_NONE);
#line 131 "ease-text-element.vala"
			gtk_button_set_relief (_data10_->right, GTK_RELIEF_NONE);
#line 132 "ease-text-element.vala"
			break;
#line 523 "ease-text-element.c"
		}
		case PANGO_ALIGN_CENTER:
		{
#line 134 "ease-text-element.vala"
			gtk_button_set_relief (_data10_->left, GTK_RELIEF_NONE);
#line 135 "ease-text-element.vala"
			gtk_button_set_relief (_data10_->center, GTK_RELIEF_NORMAL);
#line 136 "ease-text-element.vala"
			gtk_button_set_relief (_data10_->right, GTK_RELIEF_NONE);
#line 137 "ease-text-element.vala"
			break;
#line 535 "ease-text-element.c"
		}
		case PANGO_ALIGN_RIGHT:
		{
#line 139 "ease-text-element.vala"
			gtk_button_set_relief (_data10_->left, GTK_RELIEF_NONE);
#line 140 "ease-text-element.vala"
			gtk_button_set_relief (_data10_->center, GTK_RELIEF_NONE);
#line 141 "ease-text-element.vala"
			gtk_button_set_relief (_data10_->right, GTK_RELIEF_NORMAL);
#line 142 "ease-text-element.vala"
			break;
#line 547 "ease-text-element.c"
		}
	}
}


#line 125 "ease-text-element.vala"
static void __lambda15__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 555 "ease-text-element.c"
	_lambda15_ (_sender, pspec, self);
}


#line 150 "ease-text-element.vala"
static void _lambda16_ (GtkFontButton* button, Block10Data* _data10_) {
#line 562 "ease-text-element.c"
	EaseTextElement * self;
	EaseUndoAction* action;
	PangoFontDescription* _tmp0_;
	self = _data10_->self;
#line 150 "ease-text-element.vala"
	g_return_if_fail (button != NULL);
#line 151 "ease-text-element.vala"
	action = ease_undo_action_new ((GObject*) self, "font-description");
#line 152 "ease-text-element.vala"
	g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) action);
#line 153 "ease-text-element.vala"
	ease_text_element_set_font_description (self, _tmp0_ = pango_font_description_from_string (gtk_font_button_get_font_name (_data10_->font)));
#line 575 "ease-text-element.c"
	_pango_font_description_free0 (_tmp0_);
	_g_object_unref0 (action);
}


#line 150 "ease-text-element.vala"
static void __lambda16__gtk_font_button_font_set (GtkFontButton* _sender, gpointer self) {
#line 583 "ease-text-element.c"
	_lambda16_ (_sender, self);
}


#line 157 "ease-text-element.vala"
static void _lambda17_ (GObject* obj, GParamSpec* spec, Block10Data* _data10_) {
#line 590 "ease-text-element.c"
	EaseTextElement * self;
	PangoFontDescription* _tmp0_;
	self = _data10_->self;
#line 157 "ease-text-element.vala"
	g_return_if_fail (obj != NULL);
#line 157 "ease-text-element.vala"
	g_return_if_fail (spec != NULL);
#line 158 "ease-text-element.vala"
	gtk_font_button_set_font_name (_data10_->font, pango_font_description_to_string (_tmp0_ = ease_text_element_get_font_description (self)));
#line 600 "ease-text-element.c"
	_pango_font_description_free0 (_tmp0_);
}


#line 157 "ease-text-element.vala"
static void __lambda17__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 607 "ease-text-element.c"
	_lambda17_ (_sender, pspec, self);
}


#line 165 "ease-text-element.vala"
static void _lambda18_ (GtkColorButton* button, Block10Data* _data10_) {
#line 614 "ease-text-element.c"
	EaseTextElement * self;
	EaseUndoAction* action;
	EaseColor* _tmp2_;
	GdkColor _tmp1_;
	GdkColor _tmp0_ = {0};
	self = _data10_->self;
#line 165 "ease-text-element.vala"
	g_return_if_fail (button != NULL);
#line 166 "ease-text-element.vala"
	action = ease_undo_action_new ((GObject*) self, "color");
#line 167 "ease-text-element.vala"
	g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) action);
#line 168 "ease-text-element.vala"
	ease_text_element_set_color (self, _tmp2_ = ease_color_new_from_gdk ((_tmp1_ = (gtk_color_button_get_color (_data10_->color_b, &_tmp0_), _tmp0_), &_tmp1_)));
#line 629 "ease-text-element.c"
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (action);
}


#line 165 "ease-text-element.vala"
static void __lambda18__gtk_color_button_color_set (GtkColorButton* _sender, gpointer self) {
#line 637 "ease-text-element.c"
	_lambda18_ (_sender, self);
}


#line 171 "ease-text-element.vala"
static void _lambda19_ (GObject* obj, GParamSpec* spec, Block10Data* _data10_) {
#line 644 "ease-text-element.c"
	EaseTextElement * self;
	GdkColor _tmp0_ = {0};
	GdkColor _tmp1_;
	self = _data10_->self;
#line 171 "ease-text-element.vala"
	g_return_if_fail (obj != NULL);
#line 171 "ease-text-element.vala"
	g_return_if_fail (spec != NULL);
#line 172 "ease-text-element.vala"
	gtk_color_button_set_color (_data10_->color_b, (_tmp1_ = (ease_color_get_gdk (self->priv->_color, &_tmp0_), _tmp0_), &_tmp1_));
#line 655 "ease-text-element.c"
}


#line 171 "ease-text-element.vala"
static void __lambda19__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 661 "ease-text-element.c"
	_lambda19_ (_sender, pspec, self);
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (Block10Data* _data10_) {
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		_g_object_unref0 (_data10_->self);
		_g_object_unref0 (_data10_->color_b);
		_g_object_unref0 (_data10_->font);
		_g_object_unref0 (_data10_->right);
		_g_object_unref0 (_data10_->center);
		_g_object_unref0 (_data10_->left);
		g_slice_free (Block10Data, _data10_);
	}
}


#line 92 "ease-text-element.vala"
static GtkWidget* ease_text_element_real_inspector_widget (EaseElement* base) {
#line 687 "ease-text-element.c"
	EaseTextElement * self;
	GtkWidget* result = NULL;
	GError * _inner_error_;
	Block10Data* _data10_;
	GtkBuilder* builder;
	GObject* _tmp2_;
	GObject* _tmp3_;
	GObject* _tmp4_;
	GObject* _tmp5_;
	PangoFontDescription* _tmp6_;
	GObject* _tmp7_;
	GdkColor _tmp9_;
	GdkColor _tmp8_ = {0};
	GObject* _tmp10_;
	self = (EaseTextElement*) base;
	_inner_error_ = NULL;
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
#line 94 "ease-text-element.vala"
	builder = gtk_builder_new ();
#line 709 "ease-text-element.c"
	{
		char* _tmp1_;
		char* _tmp0_;
#line 97 "ease-text-element.vala"
		gtk_builder_add_from_file (builder, _tmp1_ = ease_data_path (_tmp0_ = g_build_filename (EASE_TEMP_UI_DIR, EASE_TEXT_ELEMENT_UI_FILE_PATH, NULL)), &_inner_error_);
#line 715 "ease-text-element.c"
		_g_free0 (_tmp1_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			goto __catch21_g_error;
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 100 "ease-text-element.vala"
			g_error ("ease-text-element.vala:100: Error loading UI: %s", e->message);
#line 731 "ease-text-element.c"
			_g_error_free0 (e);
		}
	}
	__finally21:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		block10_data_unref (_data10_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 103 "ease-text-element.vala"
	gtk_builder_connect_signals (builder, self);
#line 745 "ease-text-element.c"
	_data10_->left = _g_object_ref0 ((_tmp2_ = gtk_builder_get_object (builder, "left-button"), GTK_IS_BUTTON (_tmp2_) ? ((GtkButton*) _tmp2_) : NULL));
	_data10_->center = _g_object_ref0 ((_tmp3_ = gtk_builder_get_object (builder, "center-button"), GTK_IS_BUTTON (_tmp3_) ? ((GtkButton*) _tmp3_) : NULL));
	_data10_->right = _g_object_ref0 ((_tmp4_ = gtk_builder_get_object (builder, "right-button"), GTK_IS_BUTTON (_tmp4_) ? ((GtkButton*) _tmp4_) : NULL));
#line 111 "ease-text-element.vala"
	switch (self->priv->_text_align) {
#line 751 "ease-text-element.c"
		case PANGO_ALIGN_LEFT:
		{
#line 114 "ease-text-element.vala"
			gtk_button_set_relief (_data10_->left, GTK_RELIEF_NORMAL);
#line 115 "ease-text-element.vala"
			break;
#line 758 "ease-text-element.c"
		}
		case PANGO_ALIGN_CENTER:
		{
#line 117 "ease-text-element.vala"
			gtk_button_set_relief (_data10_->center, GTK_RELIEF_NORMAL);
#line 118 "ease-text-element.vala"
			break;
#line 766 "ease-text-element.c"
		}
		case PANGO_ALIGN_RIGHT:
		{
#line 120 "ease-text-element.vala"
			gtk_button_set_relief (_data10_->right, GTK_RELIEF_NORMAL);
#line 121 "ease-text-element.vala"
			break;
#line 774 "ease-text-element.c"
		}
	}
#line 125 "ease-text-element.vala"
	g_signal_connect_data ((GObject*) self, "notify::text-align", (GCallback) __lambda15__g_object_notify, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
#line 779 "ease-text-element.c"
	_data10_->font = _g_object_ref0 ((_tmp5_ = gtk_builder_get_object (builder, "font-button"), GTK_IS_FONT_BUTTON (_tmp5_) ? ((GtkFontButton*) _tmp5_) : NULL));
#line 148 "ease-text-element.vala"
	gtk_font_button_set_font_name (_data10_->font, pango_font_description_to_string (_tmp6_ = ease_text_element_get_font_description (self)));
#line 783 "ease-text-element.c"
	_pango_font_description_free0 (_tmp6_);
#line 150 "ease-text-element.vala"
	g_signal_connect_data (_data10_->font, "font-set", (GCallback) __lambda16__gtk_font_button_font_set, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
#line 157 "ease-text-element.vala"
	g_signal_connect_data ((GObject*) self, "notify::font-description", (GCallback) __lambda17__g_object_notify, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
#line 789 "ease-text-element.c"
	_data10_->color_b = _g_object_ref0 ((_tmp7_ = gtk_builder_get_object (builder, "color-button"), GTK_IS_COLOR_BUTTON (_tmp7_) ? ((GtkColorButton*) _tmp7_) : NULL));
#line 163 "ease-text-element.vala"
	gtk_color_button_set_color (_data10_->color_b, (_tmp9_ = (ease_color_get_gdk (self->priv->_color, &_tmp8_), _tmp8_), &_tmp9_));
#line 165 "ease-text-element.vala"
	g_signal_connect_data (_data10_->color_b, "color-set", (GCallback) __lambda18__gtk_color_button_color_set, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
#line 171 "ease-text-element.vala"
	g_signal_connect_data ((GObject*) self, "notify::color", (GCallback) __lambda19__g_object_notify, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
#line 797 "ease-text-element.c"
	result = _g_object_ref0 ((_tmp10_ = gtk_builder_get_object (builder, "root"), GTK_IS_WIDGET (_tmp10_) ? ((GtkWidget*) _tmp10_) : NULL));
	_g_object_unref0 (builder);
	block10_data_unref (_data10_);
#line 176 "ease-text-element.vala"
	return result;
#line 803 "ease-text-element.c"
	_g_object_unref0 (builder);
	block10_data_unref (_data10_);
}


#line 182 "ease-text-element.vala"
static void _lambda20_ (GtkWidget* widget, EaseTextElement* self) {
#line 811 "ease-text-element.c"
	GtkWidget* _tmp0_;
#line 182 "ease-text-element.vala"
	g_return_if_fail (widget != NULL);
#line 183 "ease-text-element.vala"
	gtk_button_set_relief ((_tmp0_ = widget, GTK_IS_BUTTON (_tmp0_) ? ((GtkButton*) _tmp0_) : NULL), GTK_RELIEF_NONE);
#line 817 "ease-text-element.c"
}


#line 182 "ease-text-element.vala"
static void __lambda20__gtk_callback (GtkWidget* widget, gpointer self) {
#line 823 "ease-text-element.c"
	_lambda20_ (widget, self);
}


#line 180 "ease-text-element.vala"
void ease_text_element_on_inspector_alignment (GtkWidget* sender, EaseTextElement* self) {
#line 830 "ease-text-element.c"
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	EaseUndoAction* action;
	PangoAlignment old;
	char* _tmp5_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	char* _tmp4_ = NULL;
#line 180 "ease-text-element.vala"
	g_return_if_fail (self != NULL);
#line 180 "ease-text-element.vala"
	g_return_if_fail (sender != NULL);
#line 182 "ease-text-element.vala"
	gtk_container_foreach ((_tmp0_ = gtk_widget_get_parent (sender), GTK_IS_CONTAINER (_tmp0_) ? ((GtkContainer*) _tmp0_) : NULL), __lambda20__gtk_callback, self);
#line 186 "ease-text-element.vala"
	gtk_button_set_relief ((_tmp1_ = sender, GTK_IS_BUTTON (_tmp1_) ? ((GtkButton*) _tmp1_) : NULL), GTK_RELIEF_NORMAL);
#line 188 "ease-text-element.vala"
	action = ease_undo_action_new ((GObject*) self, "text-align");
#line 189 "ease-text-element.vala"
	old = self->priv->_text_align;
#line 191 "ease-text-element.vala"
	ease_text_element_text_align_from_string (self, _tmp5_ = (g_object_get ((_tmp3_ = gtk_bin_get_child ((_tmp2_ = sender, GTK_IS_BIN (_tmp2_) ? ((GtkBin*) _tmp2_) : NULL)), GTK_IS_IMAGE (_tmp3_) ? ((GtkImage*) _tmp3_) : NULL), "stock", &_tmp4_, NULL), _tmp4_));
#line 853 "ease-text-element.c"
	_g_free0 (_tmp5_);
#line 194 "ease-text-element.vala"
	if (self->priv->_text_align != old) {
#line 196 "ease-text-element.vala"
		g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) action);
#line 859 "ease-text-element.c"
	}
	_g_object_unref0 (action);
}


#line 687 "glib-2.0.vapi"
static char* double_to_string (double self) {
#line 867 "ease-text-element.c"
	char* result = NULL;
	gint _tmp0__length1;
	gchar* _tmp0_;
	char* _tmp1_;
	result = (_tmp1_ = g_strdup (g_ascii_dtostr ((_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE), _tmp0__length1 = G_ASCII_DTOSTR_BUF_SIZE, _tmp0_), G_ASCII_DTOSTR_BUF_SIZE, self)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
#line 688 "glib-2.0.vapi"
	return result;
#line 875 "ease-text-element.c"
}


#line 1156 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 881 "ease-text-element.c"
	char* result = NULL;
	GError * _inner_error_;
#line 1156 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1156 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1156 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 890 "ease-text-element.c"
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1158 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 899 "ease-text-element.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch22_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1159 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 910 "ease-text-element.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch22_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1159 "glib-2.0.vapi"
		return result;
#line 925 "ease-text-element.c"
	}
	goto __finally22;
	__catch22_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1161 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 936 "ease-text-element.c"
			_g_error_free0 (e);
		}
	}
	__finally22:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


#line 200 "ease-text-element.vala"
static char* ease_text_element_real_html_render (EaseElement* base, EaseHTMLExporter* exporter) {
#line 951 "ease-text-element.c"
	EaseTextElement * self;
	char* result = NULL;
	char* html;
	char* _tmp0_;
	char* _tmp4_;
	char* _tmp3_;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp8_;
	char* _tmp7_;
	char* _tmp6_;
	char* _tmp5_;
	char* _tmp12_;
	char* _tmp11_;
	char* _tmp10_;
	char* _tmp9_;
	char* _tmp16_;
	char* _tmp15_;
	char* _tmp14_;
	char* _tmp13_;
	char* _tmp17_;
	char* _tmp23_;
	char* _tmp22_;
	char* _tmp21_;
	char* _tmp20_;
	char* _tmp19_;
	char* _tmp18_;
	char* _tmp26_;
	char* _tmp25_;
	char* _tmp24_;
	char* _tmp30_;
	char* _tmp29_;
	char* _tmp28_;
	char* _tmp27_;
	char* _tmp34_;
	char* _tmp33_;
	char* _tmp32_;
	char* _tmp31_;
	char* _tmp39_;
	char* _tmp38_;
	char* _tmp37_;
	char* _tmp36_;
	char* _tmp35_;
	char* _tmp43_;
	char* _tmp42_;
	char* _tmp41_;
	char* _tmp40_;
	char* _tmp47_;
	char* _tmp46_;
	char* _tmp45_;
	char* _tmp44_;
	self = (EaseTextElement*) base;
#line 200 "ease-text-element.vala"
	g_return_val_if_fail (exporter != NULL, NULL);
#line 203 "ease-text-element.vala"
	html = g_strdup ("<div class=\"text element\" ");
#line 206 "ease-text-element.vala"
	html = (_tmp0_ = g_strconcat (html, "style=\"", NULL), _g_free0 (html), _tmp0_);
#line 207 "ease-text-element.vala"
	html = (_tmp4_ = g_strconcat (html, _tmp3_ = g_strconcat (_tmp2_ = g_strconcat ("left:", _tmp1_ = g_strdup_printf ("%g", ease_element_get_x ((EaseElement*) self)), NULL), "px;", NULL), NULL), _g_free0 (html), _tmp4_);
#line 1012 "ease-text-element.c"
	_g_free0 (_tmp3_);
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
#line 208 "ease-text-element.vala"
	html = (_tmp8_ = g_strconcat (html, _tmp7_ = g_strconcat (_tmp6_ = g_strconcat (" top:", _tmp5_ = g_strdup_printf ("%g", ease_element_get_y ((EaseElement*) self)), NULL), "px;", NULL), NULL), _g_free0 (html), _tmp8_);
#line 1018 "ease-text-element.c"
	_g_free0 (_tmp7_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp5_);
#line 209 "ease-text-element.vala"
	html = (_tmp12_ = g_strconcat (html, _tmp11_ = g_strconcat (_tmp10_ = g_strconcat (" width:", _tmp9_ = g_strdup_printf ("%g", ease_element_get_width ((EaseElement*) self)), NULL), "px;", NULL), NULL), _g_free0 (html), _tmp12_);
#line 1024 "ease-text-element.c"
	_g_free0 (_tmp11_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp9_);
#line 210 "ease-text-element.vala"
	html = (_tmp16_ = g_strconcat (html, _tmp15_ = g_strconcat (_tmp14_ = g_strconcat (" height:", _tmp13_ = g_strdup_printf ("%g", ease_element_get_width ((EaseElement*) self)), NULL), "px;", NULL), NULL), _g_free0 (html), _tmp16_);
#line 1030 "ease-text-element.c"
	_g_free0 (_tmp15_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp13_);
#line 211 "ease-text-element.vala"
	html = (_tmp17_ = g_strconcat (html, " position: absolute;", NULL), _g_free0 (html), _tmp17_);
#line 214 "ease-text-element.vala"
	html = (_tmp23_ = g_strconcat (html, _tmp22_ = g_strconcat (" color:", _tmp21_ = g_strconcat ("rgb(", _tmp18_ = double_to_string (ease_color_get_red (self->priv->_color)), ",", _tmp19_ = double_to_string (ease_color_get_green (self->priv->_color)), ",", _tmp20_ = double_to_string (ease_color_get_blue (self->priv->_color)), ");", NULL), NULL), NULL), _g_free0 (html), _tmp23_);
#line 1038 "ease-text-element.c"
	_g_free0 (_tmp22_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp18_);
#line 217 "ease-text-element.vala"
	html = (_tmp26_ = g_strconcat (html, _tmp25_ = g_strconcat (_tmp24_ = g_strconcat (" font-family:'", ease_text_element_get_text_font (self), NULL), "', sans-serif;", NULL), NULL), _g_free0 (html), _tmp26_);
#line 1046 "ease-text-element.c"
	_g_free0 (_tmp25_);
	_g_free0 (_tmp24_);
#line 219 "ease-text-element.vala"
	html = (_tmp30_ = g_strconcat (html, _tmp29_ = g_strconcat (_tmp28_ = g_strconcat (" font-size:", _tmp27_ = ease_text_element_text_size_to_string (self), NULL), "pt;", NULL), NULL), _g_free0 (html), _tmp30_);
#line 1051 "ease-text-element.c"
	_g_free0 (_tmp29_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp27_);
#line 221 "ease-text-element.vala"
	html = (_tmp34_ = g_strconcat (html, _tmp33_ = g_strconcat (_tmp32_ = g_strconcat (" font-weight:", _tmp31_ = ease_text_element_text_weight_to_string (self), NULL), ";", NULL), NULL), _g_free0 (html), _tmp34_);
#line 1057 "ease-text-element.c"
	_g_free0 (_tmp33_);
	_g_free0 (_tmp32_);
	_g_free0 (_tmp31_);
#line 222 "ease-text-element.vala"
	html = (_tmp39_ = g_strconcat (html, _tmp38_ = g_strconcat (_tmp37_ = g_strconcat (" font-style:", _tmp36_ = g_utf8_strdown (_tmp35_ = ease_text_element_text_style_to_string (self), -1), NULL), ";", NULL), NULL), _g_free0 (html), _tmp39_);
#line 1063 "ease-text-element.c"
	_g_free0 (_tmp38_);
	_g_free0 (_tmp37_);
	_g_free0 (_tmp36_);
	_g_free0 (_tmp35_);
#line 225 "ease-text-element.vala"
	html = (_tmp43_ = g_strconcat (html, _tmp42_ = g_strconcat (_tmp41_ = g_strconcat (" text-align:", _tmp40_ = ease_text_element_text_align_to_string (self), NULL), ";\"", NULL), NULL), _g_free0 (html), _tmp43_);
#line 1070 "ease-text-element.c"
	_g_free0 (_tmp42_);
	_g_free0 (_tmp41_);
	_g_free0 (_tmp40_);
#line 228 "ease-text-element.vala"
	html = (_tmp47_ = g_strconcat (html, _tmp46_ = g_strconcat (_tmp45_ = g_strconcat (">", _tmp44_ = string_replace (self->priv->_text, "\n", "<br />"), NULL), "</div>", NULL), NULL), _g_free0 (html), _tmp47_);
#line 1076 "ease-text-element.c"
	_g_free0 (_tmp46_);
	_g_free0 (_tmp45_);
	_g_free0 (_tmp44_);
	result = html;
#line 231 "ease-text-element.vala"
	return result;
#line 1083 "ease-text-element.c"
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
#line 1166 "glib-2.0.vapi"
	return result;
#line 1093 "ease-text-element.c"
}


#line 237 "ease-text-element.vala"
static void ease_text_element_real_cairo_render (EaseElement* base, cairo_t* context, GError** error) {
#line 1099 "ease-text-element.c"
	EaseTextElement * self;
	char* t;
	PangoLayout* layout;
	PangoFontDescription* _tmp0_;
	self = (EaseTextElement*) base;
#line 237 "ease-text-element.vala"
	g_return_if_fail (context != NULL);
#line 239 "ease-text-element.vala"
	t = g_strdup (ease_text_element_get_display_text (self));
#line 242 "ease-text-element.vala"
	layout = pango_cairo_create_layout (context);
#line 243 "ease-text-element.vala"
	pango_layout_set_text (layout, t, (gint) string_get_length (t));
#line 244 "ease-text-element.vala"
	pango_layout_set_width (layout, (gint) (ease_element_get_width ((EaseElement*) self) * PANGO_SCALE));
#line 245 "ease-text-element.vala"
	pango_layout_set_height (layout, (gint) (ease_element_get_height ((EaseElement*) self) * PANGO_SCALE));
#line 246 "ease-text-element.vala"
	pango_layout_set_font_description (layout, _tmp0_ = ease_text_element_get_font_description (self));
#line 1119 "ease-text-element.c"
	_pango_font_description_free0 (_tmp0_);
#line 247 "ease-text-element.vala"
	pango_layout_set_alignment (layout, self->priv->_text_align);
#line 250 "ease-text-element.vala"
	ease_color_set_cairo (self->priv->_color, context);
#line 251 "ease-text-element.vala"
	pango_cairo_update_layout (context, layout);
#line 252 "ease-text-element.vala"
	pango_cairo_show_layout (context, layout);
#line 1129 "ease-text-element.c"
	_g_object_unref0 (layout);
	_g_free0 (t);
}


#line 305 "ease-text-element.vala"
char* ease_text_element_text_style_to_string (EaseTextElement* self) {
#line 1137 "ease-text-element.c"
	char* result = NULL;
#line 305 "ease-text-element.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 307 "ease-text-element.vala"
	switch (ease_text_element_get_text_style (self)) {
#line 1143 "ease-text-element.c"
		case PANGO_STYLE_OBLIQUE:
		{
			result = g_strdup ("oblique");
#line 310 "ease-text-element.vala"
			return result;
#line 1149 "ease-text-element.c"
		}
		case PANGO_STYLE_ITALIC:
		{
			result = g_strdup ("italic");
#line 312 "ease-text-element.vala"
			return result;
#line 1156 "ease-text-element.c"
		}
		case PANGO_STYLE_NORMAL:
		{
			result = g_strdup ("normal");
#line 314 "ease-text-element.vala"
			return result;
#line 1163 "ease-text-element.c"
		}
		default:
		{
#line 316 "ease-text-element.vala"
			g_critical ("ease-text-element.vala:316: Invalid text style");
#line 1169 "ease-text-element.c"
			result = g_strdup ("normal");
#line 317 "ease-text-element.vala"
			return result;
#line 1173 "ease-text-element.c"
		}
	}
}


#line 321 "ease-text-element.vala"
void ease_text_element_text_style_from_string (EaseTextElement* self, const char* str) {
#line 1181 "ease-text-element.c"
	GQuark _tmp1_;
	const char* _tmp0_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
#line 321 "ease-text-element.vala"
	g_return_if_fail (self != NULL);
#line 321 "ease-text-element.vala"
	g_return_if_fail (str != NULL);
#line 1190 "ease-text-element.c"
	_tmp0_ = str;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("oblique"))))
	switch (0) {
		default:
		{
#line 326 "ease-text-element.vala"
			ease_text_element_set_text_style (self, PANGO_STYLE_OBLIQUE);
#line 327 "ease-text-element.vala"
			break;
#line 1201 "ease-text-element.c"
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("italic"))))
	switch (0) {
		default:
		{
#line 329 "ease-text-element.vala"
			ease_text_element_set_text_style (self, PANGO_STYLE_ITALIC);
#line 330 "ease-text-element.vala"
			break;
#line 1211 "ease-text-element.c"
		}
	} else
	switch (0) {
		default:
		{
#line 332 "ease-text-element.vala"
			ease_text_element_set_text_style (self, PANGO_STYLE_NORMAL);
#line 333 "ease-text-element.vala"
			break;
#line 1221 "ease-text-element.c"
		}
	}
}


#line 351 "ease-text-element.vala"
void ease_text_element_text_variant_from_string (EaseTextElement* self, const char* str) {
#line 1229 "ease-text-element.c"
	PangoVariant _tmp0_ = 0;
#line 351 "ease-text-element.vala"
	g_return_if_fail (self != NULL);
#line 351 "ease-text-element.vala"
	g_return_if_fail (str != NULL);
#line 353 "ease-text-element.vala"
	if (_vala_strcmp0 (str, "normal") == 0) {
#line 354 "ease-text-element.vala"
		_tmp0_ = PANGO_VARIANT_NORMAL;
#line 1239 "ease-text-element.c"
	} else {
#line 354 "ease-text-element.vala"
		_tmp0_ = PANGO_VARIANT_SMALL_CAPS;
#line 1243 "ease-text-element.c"
	}
#line 353 "ease-text-element.vala"
	ease_text_element_set_text_variant (self, _tmp0_);
#line 1247 "ease-text-element.c"
}


#line 357 "ease-text-element.vala"
char* ease_text_element_text_variant_to_string (EaseTextElement* self) {
#line 1253 "ease-text-element.c"
	char* result = NULL;
	const char* _tmp0_;
#line 357 "ease-text-element.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1258 "ease-text-element.c"
	_tmp0_ = NULL;
#line 359 "ease-text-element.vala"
	if (ease_text_element_get_text_variant (self) == PANGO_VARIANT_NORMAL) {
#line 359 "ease-text-element.vala"
		_tmp0_ = "Normal";
#line 1264 "ease-text-element.c"
	} else {
#line 359 "ease-text-element.vala"
		_tmp0_ = "Small Caps";
#line 1268 "ease-text-element.c"
	}
	result = g_strdup (_tmp0_);
#line 359 "ease-text-element.vala"
	return result;
#line 1273 "ease-text-element.c"
}


#line 377 "ease-text-element.vala"
void ease_text_element_text_weight_from_string (EaseTextElement* self, const char* str) {
#line 377 "ease-text-element.vala"
	g_return_if_fail (self != NULL);
#line 377 "ease-text-element.vala"
	g_return_if_fail (str != NULL);
#line 379 "ease-text-element.vala"
	ease_text_element_set_text_weight (self, (gint) ((PangoWeight) atoi (str)));
#line 1285 "ease-text-element.c"
}


#line 382 "ease-text-element.vala"
char* ease_text_element_text_weight_to_string (EaseTextElement* self) {
#line 1291 "ease-text-element.c"
	char* result = NULL;
#line 382 "ease-text-element.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1295 "ease-text-element.c"
	result = g_strdup_printf ("%i", (gint) ease_text_element_get_text_weight (self));
#line 384 "ease-text-element.vala"
	return result;
#line 1299 "ease-text-element.c"
}


#line 423 "ease-text-element.vala"
void ease_text_element_text_align_from_string (EaseTextElement* self, const char* str) {
#line 1305 "ease-text-element.c"
	GQuark _tmp1_;
	const char* _tmp0_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	static GQuark _tmp1__label3 = 0;
	static GQuark _tmp1__label4 = 0;
	static GQuark _tmp1__label5 = 0;
#line 423 "ease-text-element.vala"
	g_return_if_fail (self != NULL);
#line 423 "ease-text-element.vala"
	g_return_if_fail (str != NULL);
#line 1318 "ease-text-element.c"
	_tmp0_ = str;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if ((_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("right")))) || (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("gtk-justify-right")))))
	switch (0) {
		default:
		{
#line 429 "ease-text-element.vala"
			ease_text_element_set_text_align (self, PANGO_ALIGN_RIGHT);
#line 430 "ease-text-element.vala"
			break;
#line 1329 "ease-text-element.c"
		}
	} else if ((_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("center")))) || (_tmp1_ == ((0 != _tmp1__label3) ? _tmp1__label3 : (_tmp1__label3 = g_quark_from_static_string ("gtk-justify-center")))))
	switch (0) {
		default:
		{
#line 433 "ease-text-element.vala"
			ease_text_element_set_text_align (self, PANGO_ALIGN_CENTER);
#line 434 "ease-text-element.vala"
			break;
#line 1339 "ease-text-element.c"
		}
	} else if ((_tmp1_ == ((0 != _tmp1__label4) ? _tmp1__label4 : (_tmp1__label4 = g_quark_from_static_string ("left")))) || (_tmp1_ == ((0 != _tmp1__label5) ? _tmp1__label5 : (_tmp1__label5 = g_quark_from_static_string ("gtk-justify-left")))))
	switch (0) {
		default:
		{
#line 437 "ease-text-element.vala"
			ease_text_element_set_text_align (self, PANGO_ALIGN_LEFT);
#line 438 "ease-text-element.vala"
			break;
#line 1349 "ease-text-element.c"
		}
	} else
	switch (0) {
		default:
		{
#line 440 "ease-text-element.vala"
			g_critical ("ease-text-element.vala:440: Illegal alignment: %s", str);
#line 441 "ease-text-element.vala"
			ease_text_element_set_text_align (self, PANGO_ALIGN_LEFT);
#line 442 "ease-text-element.vala"
			break;
#line 1361 "ease-text-element.c"
		}
	}
}


#line 446 "ease-text-element.vala"
char* ease_text_element_text_align_to_string (EaseTextElement* self) {
#line 1369 "ease-text-element.c"
	char* result = NULL;
#line 446 "ease-text-element.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 448 "ease-text-element.vala"
	switch (self->priv->_text_align) {
#line 1375 "ease-text-element.c"
		case PANGO_ALIGN_RIGHT:
		{
			result = g_strdup ("right");
#line 451 "ease-text-element.vala"
			return result;
#line 1381 "ease-text-element.c"
		}
		case PANGO_ALIGN_CENTER:
		{
			result = g_strdup ("center");
#line 453 "ease-text-element.vala"
			return result;
#line 1388 "ease-text-element.c"
		}
		default:
		{
			result = g_strdup ("left");
#line 455 "ease-text-element.vala"
			return result;
#line 1395 "ease-text-element.c"
		}
	}
}


#line 476 "ease-text-element.vala"
void ease_text_element_text_size_from_string (EaseTextElement* self, const char* str) {
#line 476 "ease-text-element.vala"
	g_return_if_fail (self != NULL);
#line 476 "ease-text-element.vala"
	g_return_if_fail (str != NULL);
#line 478 "ease-text-element.vala"
	ease_text_element_set_text_size (self, atoi (str));
#line 1409 "ease-text-element.c"
}


#line 481 "ease-text-element.vala"
char* ease_text_element_text_size_to_string (EaseTextElement* self) {
#line 1415 "ease-text-element.c"
	char* result = NULL;
#line 481 "ease-text-element.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1419 "ease-text-element.c"
	result = g_strdup_printf ("%i", ease_text_element_get_text_size (self));
#line 483 "ease-text-element.vala"
	return result;
#line 1423 "ease-text-element.c"
}


const char* ease_text_element_get_text (EaseTextElement* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_text;
#line 258 "ease-text-element.vala"
	return result;
#line 1433 "ease-text-element.c"
}


void ease_text_element_set_text (EaseTextElement* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_text = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_text), _tmp0_);
	g_object_notify ((GObject *) self, "text");
}


const char* ease_text_element_get_display_text (EaseTextElement* self) {
	const char* result;
	const char* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
#line 268 "ease-text-element.vala"
	if (ease_element_get_has_been_edited ((EaseElement*) self)) {
#line 268 "ease-text-element.vala"
		_tmp1_ = TRUE;
#line 1455 "ease-text-element.c"
	} else {
#line 268 "ease-text-element.vala"
		_tmp1_ = string_get_length (self->priv->_text) > 0;
#line 1459 "ease-text-element.c"
	}
#line 268 "ease-text-element.vala"
	if (_tmp1_) {
#line 268 "ease-text-element.vala"
		_tmp0_ = self->priv->_text;
#line 1465 "ease-text-element.c"
	} else {
#line 268 "ease-text-element.vala"
		_tmp0_ = EASE_TEXT_ELEMENT_DEFAULT_TEXT;
#line 1469 "ease-text-element.c"
	}
	result = _tmp0_;
#line 268 "ease-text-element.vala"
	return result;
#line 1474 "ease-text-element.c"
}


EaseColor* ease_text_element_get_color (EaseTextElement* self) {
	EaseColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_color;
#line 275 "ease-text-element.vala"
	return result;
#line 1484 "ease-text-element.c"
}


void ease_text_element_set_color (EaseTextElement* self, EaseColor* value) {
	EaseColor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_color = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_color), _tmp0_);
	g_object_notify ((GObject *) self, "color");
}


const char* ease_text_element_get_text_font (EaseTextElement* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->text_font_priv;
#line 282 "ease-text-element.vala"
	return result;
#line 1502 "ease-text-element.c"
}


void ease_text_element_set_text_font (EaseTextElement* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
#line 285 "ease-text-element.vala"
	self->priv->text_font_priv = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->text_font_priv), _tmp0_);
#line 286 "ease-text-element.vala"
	if (!self->priv->freeze) {
#line 286 "ease-text-element.vala"
		g_object_notify ((GObject*) self, "font-description");
#line 1515 "ease-text-element.c"
	}
	g_object_notify ((GObject *) self, "text-font");
}


PangoStyle ease_text_element_get_text_style (EaseTextElement* self) {
	PangoStyle result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->text_style_priv;
#line 296 "ease-text-element.vala"
	return result;
#line 1527 "ease-text-element.c"
}


void ease_text_element_set_text_style (EaseTextElement* self, PangoStyle value) {
	g_return_if_fail (self != NULL);
#line 299 "ease-text-element.vala"
	self->priv->text_style_priv = value;
#line 300 "ease-text-element.vala"
	if (!self->priv->freeze) {
#line 300 "ease-text-element.vala"
		g_object_notify ((GObject*) self, "font-description");
#line 1539 "ease-text-element.c"
	}
	g_object_notify ((GObject *) self, "text-style");
}


PangoVariant ease_text_element_get_text_variant (EaseTextElement* self) {
	PangoVariant result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->text_variant_priv;
#line 342 "ease-text-element.vala"
	return result;
#line 1551 "ease-text-element.c"
}


void ease_text_element_set_text_variant (EaseTextElement* self, PangoVariant value) {
	g_return_if_fail (self != NULL);
#line 345 "ease-text-element.vala"
	self->priv->text_variant_priv = value;
#line 346 "ease-text-element.vala"
	if (!self->priv->freeze) {
#line 346 "ease-text-element.vala"
		g_object_notify ((GObject*) self, "font-description");
#line 1563 "ease-text-element.c"
	}
	g_object_notify ((GObject *) self, "text-variant");
}


gint ease_text_element_get_text_weight (EaseTextElement* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->text_weight_priv;
#line 367 "ease-text-element.vala"
	return result;
#line 1575 "ease-text-element.c"
}


void ease_text_element_set_text_weight (EaseTextElement* self, gint value) {
	g_return_if_fail (self != NULL);
#line 370 "ease-text-element.vala"
	self->priv->text_weight_priv = value;
#line 371 "ease-text-element.vala"
	if (!self->priv->freeze) {
#line 371 "ease-text-element.vala"
		g_object_notify ((GObject*) self, "font-description");
#line 1587 "ease-text-element.c"
	}
	g_object_notify ((GObject *) self, "text-weight");
}


PangoFontDescription* ease_text_element_get_font_description (EaseTextElement* self) {
	PangoFontDescription* result;
	PangoFontDescription* desc;
	g_return_val_if_fail (self != NULL, NULL);
#line 397 "ease-text-element.vala"
	desc = pango_font_description_new ();
#line 398 "ease-text-element.vala"
	pango_font_description_set_family (desc, ease_text_element_get_text_font (self));
#line 399 "ease-text-element.vala"
	pango_font_description_set_style (desc, ease_text_element_get_text_style (self));
#line 400 "ease-text-element.vala"
	pango_font_description_set_weight (desc, (PangoWeight) ease_text_element_get_text_weight (self));
#line 401 "ease-text-element.vala"
	pango_font_description_set_variant (desc, ease_text_element_get_text_variant (self));
#line 402 "ease-text-element.vala"
	pango_font_description_set_size (desc, ease_text_element_get_text_size (self) * PANGO_SCALE);
#line 1609 "ease-text-element.c"
	result = desc;
#line 404 "ease-text-element.vala"
	return result;
#line 1613 "ease-text-element.c"
}


void ease_text_element_set_font_description (EaseTextElement* self, const PangoFontDescription* value) {
	g_return_if_fail (self != NULL);
#line 408 "ease-text-element.vala"
	self->priv->freeze = TRUE;
#line 409 "ease-text-element.vala"
	ease_text_element_set_text_font (self, pango_font_description_get_family (value));
#line 410 "ease-text-element.vala"
	ease_text_element_set_text_style (self, pango_font_description_get_style (value));
#line 411 "ease-text-element.vala"
	ease_text_element_set_text_weight (self, (gint) pango_font_description_get_weight (value));
#line 412 "ease-text-element.vala"
	ease_text_element_set_text_variant (self, pango_font_description_get_variant (value));
#line 413 "ease-text-element.vala"
	ease_text_element_set_text_size (self, pango_font_description_get_size (value) / PANGO_SCALE);
#line 414 "ease-text-element.vala"
	self->priv->freeze = FALSE;
#line 1633 "ease-text-element.c"
	g_object_notify ((GObject *) self, "font-description");
}


PangoAlignment ease_text_element_get_text_align (EaseTextElement* self) {
	PangoAlignment result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_text_align;
#line 421 "ease-text-element.vala"
	return result;
#line 1644 "ease-text-element.c"
}


void ease_text_element_set_text_align (EaseTextElement* self, PangoAlignment value) {
	g_return_if_fail (self != NULL);
	self->priv->_text_align = value;
	g_object_notify ((GObject *) self, "text-align");
}


gint ease_text_element_get_text_size (EaseTextElement* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->text_size_priv;
#line 467 "ease-text-element.vala"
	return result;
#line 1661 "ease-text-element.c"
}


void ease_text_element_set_text_size (EaseTextElement* self, gint value) {
	g_return_if_fail (self != NULL);
#line 470 "ease-text-element.vala"
	self->priv->text_size_priv = value;
#line 471 "ease-text-element.vala"
	if (!self->priv->freeze) {
#line 471 "ease-text-element.vala"
		g_object_notify ((GObject*) self, "font-description");
#line 1673 "ease-text-element.c"
	}
	g_object_notify ((GObject *) self, "text-size");
}


static void ease_text_element_class_init (EaseTextElementClass * klass) {
	ease_text_element_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseTextElementPrivate));
	EASE_ELEMENT_CLASS (klass)->to_json = ease_text_element_real_to_json;
	EASE_ELEMENT_CLASS (klass)->actor = ease_text_element_real_actor;
	EASE_ELEMENT_CLASS (klass)->set_color = ease_text_element_real_set_color;
	EASE_ELEMENT_CLASS (klass)->get_color = ease_text_element_real_get_color;
	EASE_ELEMENT_CLASS (klass)->inspector_widget = ease_text_element_real_inspector_widget;
	EASE_ELEMENT_CLASS (klass)->html_render = ease_text_element_real_html_render;
	EASE_ELEMENT_CLASS (klass)->cairo_render = ease_text_element_real_cairo_render;
	G_OBJECT_CLASS (klass)->get_property = ease_text_element_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_text_element_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_text_element_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_TEXT_ELEMENT_TEXT, g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_TEXT_ELEMENT_DISPLAY_TEXT, g_param_spec_string ("display-text", "display-text", "display-text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_TEXT_ELEMENT_COLOR, g_param_spec_object ("color", "color", "color", EASE_TYPE_COLOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_TEXT_ELEMENT_TEXT_FONT, g_param_spec_string ("text-font", "text-font", "text-font", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_TEXT_ELEMENT_TEXT_STYLE, g_param_spec_enum ("text-style", "text-style", "text-style", PANGO_TYPE_STYLE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_TEXT_ELEMENT_TEXT_VARIANT, g_param_spec_enum ("text-variant", "text-variant", "text-variant", PANGO_TYPE_VARIANT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_TEXT_ELEMENT_TEXT_WEIGHT, g_param_spec_int ("text-weight", "text-weight", "text-weight", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_TEXT_ELEMENT_FONT_DESCRIPTION, g_param_spec_boxed ("font-description", "font-description", "font-description", PANGO_TYPE_FONT_DESCRIPTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_TEXT_ELEMENT_TEXT_ALIGN, g_param_spec_enum ("text-align", "text-align", "text-align", PANGO_TYPE_ALIGNMENT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_TEXT_ELEMENT_TEXT_SIZE, g_param_spec_int ("text-size", "text-size", "text-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void ease_text_element_instance_init (EaseTextElement * self) {
	self->priv = EASE_TEXT_ELEMENT_GET_PRIVATE (self);
	self->priv->freeze = FALSE;
}


static void ease_text_element_finalize (GObject* obj) {
	EaseTextElement * self;
	self = EASE_TEXT_ELEMENT (obj);
	_g_free0 (self->priv->_text);
	_g_object_unref0 (self->priv->_color);
	_g_free0 (self->priv->text_font_priv);
	G_OBJECT_CLASS (ease_text_element_parent_class)->finalize (obj);
}


GType ease_text_element_get_type (void) {
	static volatile gsize ease_text_element_type_id__volatile = 0;
	if (g_once_init_enter (&ease_text_element_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseTextElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_text_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseTextElement), 0, (GInstanceInitFunc) ease_text_element_instance_init, NULL };
		GType ease_text_element_type_id;
		ease_text_element_type_id = g_type_register_static (EASE_TYPE_ELEMENT, "EaseTextElement", &g_define_type_info, 0);
		g_once_init_leave (&ease_text_element_type_id__volatile, ease_text_element_type_id);
	}
	return ease_text_element_type_id__volatile;
}


static void ease_text_element_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseTextElement * self;
	self = EASE_TEXT_ELEMENT (object);
	switch (property_id) {
		case EASE_TEXT_ELEMENT_TEXT:
		g_value_set_string (value, ease_text_element_get_text (self));
		break;
		case EASE_TEXT_ELEMENT_DISPLAY_TEXT:
		g_value_set_string (value, ease_text_element_get_display_text (self));
		break;
		case EASE_TEXT_ELEMENT_COLOR:
		g_value_set_object (value, ease_text_element_get_color (self));
		break;
		case EASE_TEXT_ELEMENT_TEXT_FONT:
		g_value_set_string (value, ease_text_element_get_text_font (self));
		break;
		case EASE_TEXT_ELEMENT_TEXT_STYLE:
		g_value_set_enum (value, ease_text_element_get_text_style (self));
		break;
		case EASE_TEXT_ELEMENT_TEXT_VARIANT:
		g_value_set_enum (value, ease_text_element_get_text_variant (self));
		break;
		case EASE_TEXT_ELEMENT_TEXT_WEIGHT:
		g_value_set_int (value, ease_text_element_get_text_weight (self));
		break;
		case EASE_TEXT_ELEMENT_FONT_DESCRIPTION:
		g_value_take_boxed (value, ease_text_element_get_font_description (self));
		break;
		case EASE_TEXT_ELEMENT_TEXT_ALIGN:
		g_value_set_enum (value, ease_text_element_get_text_align (self));
		break;
		case EASE_TEXT_ELEMENT_TEXT_SIZE:
		g_value_set_int (value, ease_text_element_get_text_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_text_element_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseTextElement * self;
	self = EASE_TEXT_ELEMENT (object);
	switch (property_id) {
		case EASE_TEXT_ELEMENT_TEXT:
		ease_text_element_set_text (self, g_value_get_string (value));
		break;
		case EASE_TEXT_ELEMENT_COLOR:
		ease_text_element_set_color (self, g_value_get_object (value));
		break;
		case EASE_TEXT_ELEMENT_TEXT_FONT:
		ease_text_element_set_text_font (self, g_value_get_string (value));
		break;
		case EASE_TEXT_ELEMENT_TEXT_STYLE:
		ease_text_element_set_text_style (self, g_value_get_enum (value));
		break;
		case EASE_TEXT_ELEMENT_TEXT_VARIANT:
		ease_text_element_set_text_variant (self, g_value_get_enum (value));
		break;
		case EASE_TEXT_ELEMENT_TEXT_WEIGHT:
		ease_text_element_set_text_weight (self, g_value_get_int (value));
		break;
		case EASE_TEXT_ELEMENT_FONT_DESCRIPTION:
		ease_text_element_set_font_description (self, g_value_get_boxed (value));
		break;
		case EASE_TEXT_ELEMENT_TEXT_ALIGN:
		ease_text_element_set_text_align (self, g_value_get_enum (value));
		break;
		case EASE_TEXT_ELEMENT_TEXT_SIZE:
		ease_text_element_set_text_size (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




