/* ease-utilities.c generated by valac, the Vala compiler
 * generated from ease-utilities.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
typedef struct _Block11Data Block11Data;

typedef void (*EaseRecursiveDirAction) (const char* path, const char* full_path, void* user_data, GError** error);
struct _Block11Data {
	int _ref_count_;
	char* to_dir;
};



#define EASE_LOCAL_DATA "data"
#define EASE_SYS_DATA "ease"
void ease_error_dialog (const char* title, const char* message);
char* ease_query_file (const char* dir, const char* path);
static char** _vala_array_dup1 (char** self, int length);
char* ease_data_path (const char* path);
void ease_do_recursive_directory (const char* directory, EaseRecursiveDirAction directory_action, void* directory_action_target, EaseRecursiveDirAction file_action, void* file_action_target, const char* rel_path, gboolean dir_first, GError** error);
void ease_recursive_directory (const char* directory, EaseRecursiveDirAction directory_action, void* directory_action_target, EaseRecursiveDirAction file_action, void* file_action_target, GError** error);
void ease_recursive_directory_after (const char* directory, EaseRecursiveDirAction directory_action, void* directory_action_target, EaseRecursiveDirAction file_action, void* file_action_target, GError** error);
static void _lambda13_ (const char* p, const char* full_path, GError** error);
static void __lambda13__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error);
static void _lambda14_ (const char* p, const char* full_path, GError** error);
static void __lambda14__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error);
void ease_recursive_delete (const char* path, GError** error);
static void _lambda0_ (const char* path, const char* full_path, Block11Data* _data11_, GError** error);
static void __lambda0__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error);
static void _lambda1_ (const char* path, const char* full_path, Block11Data* _data11_, GError** error);
static void __lambda1__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
void ease_recursive_copy (const char* from_dir, const char* to_dir, GError** error);
static GdkColor* _gdk_color_dup (GdkColor* self);
GdkColor* ease_theme_color (const char* color);
void ease_transformations_gdk_color_to_clutter_color (GdkColor* color, ClutterColor* result);
void ease_theme_clutter_color (const char* color, ClutterColor* result);
GtkWindow* ease_widget_window (GtkWidget* widg);
char* ease_absolute_path (const char* path);
double ease_dmax (double a, double b);
double ease_dmin (double a, double b);
gint ease_roundd (double num);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);



#line 36 "ease-utilities.vala"
void ease_error_dialog (const char* title, const char* message) {
#line 86 "ease-utilities.c"
	GtkMessageDialog* dialog;
#line 36 "ease-utilities.vala"
	g_return_if_fail (title != NULL);
#line 36 "ease-utilities.vala"
	g_return_if_fail (message != NULL);
#line 38 "ease-utilities.vala"
	dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", message));
#line 42 "ease-utilities.vala"
	gtk_window_set_title ((GtkWindow*) dialog, title);
#line 43 "ease-utilities.vala"
	gtk_container_set_border_width ((GtkContainer*) dialog, (guint) 5);
#line 44 "ease-utilities.vala"
	gtk_dialog_run ((GtkDialog*) dialog);
#line 45 "ease-utilities.vala"
	gtk_object_destroy ((GtkObject*) dialog);
#line 102 "ease-utilities.c"
	_g_object_unref0 (dialog);
}


static char** _vala_array_dup1 (char** self, int length) {
	char** result;
	int i;
	char** _tmp1_;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


#line 54 "ease-utilities.vala"
char* ease_data_path (const char* path) {
#line 121 "ease-utilities.c"
	char* result = NULL;
	char* file;
	char* _tmp0_;
	char** _tmp3_;
	gint _data_dirs_size_;
	gint data_dirs_length1;
	char** _tmp2_;
	char** _tmp1_;
	char** data_dirs;
#line 54 "ease-utilities.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 133 "ease-utilities.c"
	file = NULL;
#line 57 "ease-utilities.vala"
	file = (_tmp0_ = ease_query_file (EASE_LOCAL_DATA, path), _g_free0 (file), _tmp0_);
#line 58 "ease-utilities.vala"
	if (file != NULL) {
#line 139 "ease-utilities.c"
		result = file;
#line 58 "ease-utilities.vala"
		return result;
#line 143 "ease-utilities.c"
	}
	data_dirs = (_tmp3_ = (_tmp2_ = _tmp1_ = g_get_system_data_dirs (), (_tmp2_ == NULL) ? ((gpointer) _tmp2_) : _vala_array_dup1 (_tmp2_, _vala_array_length (_tmp1_))), data_dirs_length1 = _vala_array_length (_tmp1_), _data_dirs_size_ = data_dirs_length1, _tmp3_);
	{
		char** dir_collection;
		int dir_collection_length1;
		int dir_it;
#line 61 "ease-utilities.vala"
		dir_collection = data_dirs;
#line 152 "ease-utilities.c"
		dir_collection_length1 = data_dirs_length1;
		for (dir_it = 0; dir_it < data_dirs_length1; dir_it = dir_it + 1) {
			char* dir;
			dir = g_strdup (dir_collection[dir_it]);
			{
				char* _tmp4_;
				char* _tmp5_;
				char* sys_file;
#line 63 "ease-utilities.vala"
				sys_file = (_tmp5_ = ease_query_file (_tmp4_ = g_build_filename (dir, EASE_SYS_DATA, NULL), path), _g_free0 (_tmp4_), _tmp5_);
#line 64 "ease-utilities.vala"
				if (sys_file != NULL) {
#line 165 "ease-utilities.c"
					result = sys_file;
					_g_free0 (dir);
					data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (file);
#line 64 "ease-utilities.vala"
					return result;
#line 172 "ease-utilities.c"
				}
				_g_free0 (sys_file);
				_g_free0 (dir);
			}
		}
	}
	result = NULL;
	data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (file);
#line 67 "ease-utilities.vala"
	return result;
#line 184 "ease-utilities.c"
}


#line 78 "ease-utilities.vala"
char* ease_query_file (const char* dir, const char* path) {
#line 190 "ease-utilities.c"
	char* result = NULL;
	char* filename;
	GFile* file;
#line 78 "ease-utilities.vala"
	g_return_val_if_fail (dir != NULL, NULL);
#line 78 "ease-utilities.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 80 "ease-utilities.vala"
	filename = g_build_filename (dir, path, NULL);
#line 81 "ease-utilities.vala"
	file = g_file_new_for_path (filename);
#line 83 "ease-utilities.vala"
	if (g_file_query_exists (file, NULL)) {
#line 204 "ease-utilities.c"
		result = filename;
		_g_object_unref0 (file);
#line 85 "ease-utilities.vala"
		return result;
#line 209 "ease-utilities.c"
	}
	result = NULL;
	_g_object_unref0 (file);
	_g_free0 (filename);
#line 87 "ease-utilities.vala"
	return result;
#line 216 "ease-utilities.c"
}


#line 106 "ease-utilities.vala"
void ease_recursive_directory (const char* directory, EaseRecursiveDirAction directory_action, void* directory_action_target, EaseRecursiveDirAction file_action, void* file_action_target, GError** error) {
#line 222 "ease-utilities.c"
	GError * _inner_error_;
#line 106 "ease-utilities.vala"
	g_return_if_fail (directory != NULL);
#line 226 "ease-utilities.c"
	_inner_error_ = NULL;
#line 111 "ease-utilities.vala"
	ease_do_recursive_directory (directory, directory_action, directory_action_target, file_action, file_action_target, "", TRUE, &_inner_error_);
#line 230 "ease-utilities.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


#line 134 "ease-utilities.vala"
void ease_recursive_directory_after (const char* directory, EaseRecursiveDirAction directory_action, void* directory_action_target, EaseRecursiveDirAction file_action, void* file_action_target, GError** error) {
#line 240 "ease-utilities.c"
	GError * _inner_error_;
#line 134 "ease-utilities.vala"
	g_return_if_fail (directory != NULL);
#line 244 "ease-utilities.c"
	_inner_error_ = NULL;
#line 139 "ease-utilities.vala"
	ease_do_recursive_directory (directory, directory_action, directory_action_target, file_action, file_action_target, "", FALSE, &_inner_error_);
#line 248 "ease-utilities.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


#line 150 "ease-utilities.vala"
void ease_do_recursive_directory (const char* directory, EaseRecursiveDirAction directory_action, void* directory_action_target, EaseRecursiveDirAction file_action, void* file_action_target, const char* rel_path, gboolean dir_first, GError** error) {
#line 258 "ease-utilities.c"
	GError * _inner_error_;
	GDir* dir;
	char* child_path;
#line 150 "ease-utilities.vala"
	g_return_if_fail (directory != NULL);
#line 150 "ease-utilities.vala"
	g_return_if_fail (rel_path != NULL);
#line 266 "ease-utilities.c"
	_inner_error_ = NULL;
#line 157 "ease-utilities.vala"
	dir = g_dir_open (directory, (guint) 0, &_inner_error_);
#line 270 "ease-utilities.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	child_path = NULL;
#line 160 "ease-utilities.vala"
	while (TRUE) {
#line 278 "ease-utilities.c"
		char* _tmp0_;
		char* child_full_path;
		char* child_rel_path;
#line 160 "ease-utilities.vala"
		if (!((child_path = (_tmp0_ = g_strdup (g_dir_read_name (dir)), _g_free0 (child_path), _tmp0_)) != NULL)) {
#line 160 "ease-utilities.vala"
			break;
#line 286 "ease-utilities.c"
		}
#line 162 "ease-utilities.vala"
		child_full_path = g_build_filename (directory, child_path, NULL);
#line 163 "ease-utilities.vala"
		child_rel_path = g_build_filename (rel_path, child_path, NULL);
#line 164 "ease-utilities.vala"
		if (g_file_test (child_full_path, G_FILE_TEST_IS_DIR)) {
#line 294 "ease-utilities.c"
			gboolean _tmp1_ = FALSE;
			gboolean _tmp2_ = FALSE;
#line 166 "ease-utilities.vala"
			if (directory_action != NULL) {
#line 166 "ease-utilities.vala"
				_tmp1_ = dir_first;
#line 301 "ease-utilities.c"
			} else {
#line 166 "ease-utilities.vala"
				_tmp1_ = FALSE;
#line 305 "ease-utilities.c"
			}
#line 166 "ease-utilities.vala"
			if (_tmp1_) {
#line 168 "ease-utilities.vala"
				directory_action (child_rel_path, child_full_path, directory_action_target, &_inner_error_);
#line 311 "ease-utilities.c"
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (child_rel_path);
					_g_free0 (child_full_path);
					_g_free0 (child_path);
					_g_dir_close0 (dir);
					return;
				}
			}
#line 172 "ease-utilities.vala"
			ease_do_recursive_directory (child_full_path, directory_action, directory_action_target, file_action, file_action_target, child_rel_path, dir_first, &_inner_error_);
#line 323 "ease-utilities.c"
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (child_rel_path);
				_g_free0 (child_full_path);
				_g_free0 (child_path);
				_g_dir_close0 (dir);
				return;
			}
#line 177 "ease-utilities.vala"
			if (directory_action != NULL) {
#line 177 "ease-utilities.vala"
				_tmp2_ = !dir_first;
#line 336 "ease-utilities.c"
			} else {
#line 177 "ease-utilities.vala"
				_tmp2_ = FALSE;
#line 340 "ease-utilities.c"
			}
#line 177 "ease-utilities.vala"
			if (_tmp2_) {
#line 179 "ease-utilities.vala"
				directory_action (child_rel_path, child_full_path, directory_action_target, &_inner_error_);
#line 346 "ease-utilities.c"
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (child_rel_path);
					_g_free0 (child_full_path);
					_g_free0 (child_path);
					_g_dir_close0 (dir);
					return;
				}
			}
		} else {
#line 184 "ease-utilities.vala"
			if (file_action != NULL) {
#line 186 "ease-utilities.vala"
				file_action (child_rel_path, child_full_path, file_action_target, &_inner_error_);
#line 361 "ease-utilities.c"
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (child_rel_path);
					_g_free0 (child_full_path);
					_g_free0 (child_path);
					_g_dir_close0 (dir);
					return;
				}
			}
		}
		_g_free0 (child_rel_path);
		_g_free0 (child_full_path);
	}
	_g_free0 (child_path);
	_g_dir_close0 (dir);
}


#line 211 "ease-utilities.vala"
static void _lambda13_ (const char* p, const char* full_path, GError** error) {
#line 211 "ease-utilities.vala"
	g_return_if_fail (p != NULL);
#line 211 "ease-utilities.vala"
	g_return_if_fail (full_path != NULL);
#line 212 "ease-utilities.vala"
	g_rmdir (full_path);
#line 388 "ease-utilities.c"
}


#line 211 "ease-utilities.vala"
static void __lambda13__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error) {
#line 394 "ease-utilities.c"
	_lambda13_ (path, full_path, error);
}


#line 214 "ease-utilities.vala"
static void _lambda14_ (const char* p, const char* full_path, GError** error) {
#line 214 "ease-utilities.vala"
	g_return_if_fail (p != NULL);
#line 214 "ease-utilities.vala"
	g_return_if_fail (full_path != NULL);
#line 215 "ease-utilities.vala"
	g_unlink (full_path);
#line 407 "ease-utilities.c"
}


#line 214 "ease-utilities.vala"
static void __lambda14__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error) {
#line 413 "ease-utilities.c"
	_lambda14_ (path, full_path, error);
}


#line 200 "ease-utilities.vala"
void ease_recursive_delete (const char* path, GError** error) {
#line 420 "ease-utilities.c"
	GError * _inner_error_;
	GDir* dir;
#line 200 "ease-utilities.vala"
	g_return_if_fail (path != NULL);
#line 425 "ease-utilities.c"
	_inner_error_ = NULL;
#line 202 "ease-utilities.vala"
	dir = g_dir_open (path, (guint) 0, &_inner_error_);
#line 429 "ease-utilities.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
#line 204 "ease-utilities.vala"
	if (dir == NULL) {
#line 436 "ease-utilities.c"
		_inner_error_ = g_error_new (G_FILE_ERROR, G_FILE_ERROR_NOENT, _ ("Directory to remove doesn't exist: %s"), path);
		{
			g_propagate_error (error, _inner_error_);
			_g_dir_close0 (dir);
			return;
		}
	}
#line 210 "ease-utilities.vala"
	ease_recursive_directory_after (path, __lambda13__ease_recursive_dir_action, NULL, __lambda14__ease_recursive_dir_action, NULL, &_inner_error_);
#line 446 "ease-utilities.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_dir_close0 (dir);
		return;
	}
#line 218 "ease-utilities.vala"
	g_rmdir (path);
#line 454 "ease-utilities.c"
	_g_dir_close0 (dir);
}


#line 236 "ease-utilities.vala"
static void _lambda0_ (const char* path, const char* full_path, Block11Data* _data11_, GError** error) {
#line 461 "ease-utilities.c"
	GError * _inner_error_;
	char* _tmp0_;
	GFile* _tmp1_;
	GFile* dir;
#line 236 "ease-utilities.vala"
	g_return_if_fail (path != NULL);
#line 236 "ease-utilities.vala"
	g_return_if_fail (full_path != NULL);
#line 470 "ease-utilities.c"
	_inner_error_ = NULL;
#line 237 "ease-utilities.vala"
	dir = (_tmp1_ = g_file_new_for_path (_tmp0_ = g_build_filename (_data11_->to_dir, path, NULL)), _g_free0 (_tmp0_), _tmp1_);
#line 238 "ease-utilities.vala"
	if (!g_file_query_exists (dir, NULL)) {
#line 238 "ease-utilities.vala"
		g_file_make_directory (dir, NULL, &_inner_error_);
#line 478 "ease-utilities.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (dir);
			return;
		}
	}
	_g_object_unref0 (dir);
}


#line 236 "ease-utilities.vala"
static void __lambda0__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error) {
#line 491 "ease-utilities.c"
	_lambda0_ (path, full_path, self, error);
}


#line 240 "ease-utilities.vala"
static void _lambda1_ (const char* path, const char* full_path, Block11Data* _data11_, GError** error) {
#line 498 "ease-utilities.c"
	GError * _inner_error_;
	GFile* from;
	char* _tmp0_;
	GFile* _tmp1_;
	GFile* to;
#line 240 "ease-utilities.vala"
	g_return_if_fail (path != NULL);
#line 240 "ease-utilities.vala"
	g_return_if_fail (full_path != NULL);
#line 508 "ease-utilities.c"
	_inner_error_ = NULL;
#line 241 "ease-utilities.vala"
	from = g_file_new_for_path (full_path);
#line 242 "ease-utilities.vala"
	to = (_tmp1_ = g_file_new_for_path (_tmp0_ = g_build_filename (_data11_->to_dir, path, NULL)), _g_free0 (_tmp0_), _tmp1_);
#line 243 "ease-utilities.vala"
	g_file_copy (from, to, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
#line 516 "ease-utilities.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (to);
		_g_object_unref0 (from);
		return;
	}
	_g_object_unref0 (to);
	_g_object_unref0 (from);
}


#line 240 "ease-utilities.vala"
static void __lambda1__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error) {
#line 530 "ease-utilities.c"
	_lambda1_ (path, full_path, self, error);
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (Block11Data* _data11_) {
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		_g_free0 (_data11_->to_dir);
		g_slice_free (Block11Data, _data11_);
	}
}


#line 227 "ease-utilities.vala"
void ease_recursive_copy (const char* from_dir, const char* to_dir, GError** error) {
#line 551 "ease-utilities.c"
	GError * _inner_error_;
	Block11Data* _data11_;
	GFile* top;
#line 227 "ease-utilities.vala"
	g_return_if_fail (from_dir != NULL);
#line 227 "ease-utilities.vala"
	g_return_if_fail (to_dir != NULL);
#line 559 "ease-utilities.c"
	_inner_error_ = NULL;
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->to_dir = g_strdup (to_dir);
#line 229 "ease-utilities.vala"
	top = g_file_new_for_path (_data11_->to_dir);
#line 230 "ease-utilities.vala"
	if (!g_file_query_exists (top, NULL)) {
#line 232 "ease-utilities.vala"
		g_file_make_directory_with_parents (top, NULL, &_inner_error_);
#line 570 "ease-utilities.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (top);
			block11_data_unref (_data11_);
			return;
		}
	}
#line 235 "ease-utilities.vala"
	ease_recursive_directory (from_dir, __lambda0__ease_recursive_dir_action, _data11_, __lambda1__ease_recursive_dir_action, _data11_, &_inner_error_);
#line 580 "ease-utilities.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (top);
		block11_data_unref (_data11_);
		return;
	}
	_g_object_unref0 (top);
	block11_data_unref (_data11_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 1026 "glib-2.0.vapi"
static char* string_strip (const char* self) {
#line 599 "ease-utilities.c"
	char* result = NULL;
	char* _result_;
#line 1026 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1027 "glib-2.0.vapi"
	_result_ = g_strdup (self);
#line 1028 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 608 "ease-utilities.c"
	result = _result_;
#line 1029 "glib-2.0.vapi"
	return result;
#line 612 "ease-utilities.c"
}


#line 1085 "glib-2.0.vapi"
static char* string_substring (const char* self, glong offset, glong len) {
#line 618 "ease-utilities.c"
	char* result = NULL;
	glong string_length;
	const char* start;
#line 1085 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1086 "glib-2.0.vapi"
	string_length = g_utf8_strlen (self, -1);
#line 1087 "glib-2.0.vapi"
	if (offset < 0) {
#line 1088 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1089 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= 0, NULL);
#line 632 "ease-utilities.c"
	} else {
#line 1091 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 636 "ease-utilities.c"
	}
#line 1093 "glib-2.0.vapi"
	if (len < 0) {
#line 1094 "glib-2.0.vapi"
		len = string_length - offset;
#line 642 "ease-utilities.c"
	}
#line 1096 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1097 "glib-2.0.vapi"
	start = g_utf8_offset_to_pointer (self, offset);
#line 648 "ease-utilities.c"
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
#line 1098 "glib-2.0.vapi"
	return result;
#line 652 "ease-utilities.c"
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
#line 1166 "glib-2.0.vapi"
	return result;
#line 662 "ease-utilities.c"
}


static GdkColor* _gdk_color_dup (GdkColor* self) {
	GdkColor* dup;
	dup = g_new0 (GdkColor, 1);
	memcpy (dup, self, sizeof (GdkColor));
	return dup;
}


static gpointer __gdk_color_dup0 (gpointer self) {
	return self ? _gdk_color_dup (self) : NULL;
}


#line 252 "ease-utilities.vala"
GdkColor* ease_theme_color (const char* color) {
#line 681 "ease-utilities.c"
	GdkColor* result = NULL;
	GtkSettings* settings;
	char** _tmp4_;
	gint _colors_size_;
	gint colors_length1;
	char** _tmp2_;
	char* _tmp1_;
	char* _tmp0_ = NULL;
	char** _tmp3_;
	char** colors;
#line 252 "ease-utilities.vala"
	g_return_val_if_fail (color != NULL, NULL);
#line 255 "ease-utilities.vala"
	settings = _g_object_ref0 (gtk_settings_get_default ());
#line 696 "ease-utilities.c"
	colors = (_tmp4_ = (_tmp3_ = _tmp2_ = g_strsplit_set (_tmp1_ = (g_object_get (settings, "gtk-color-scheme", &_tmp0_, NULL), _tmp0_), "\n;", 0), _g_free0 (_tmp1_), _tmp3_), colors_length1 = _vala_array_length (_tmp2_), _colors_size_ = colors_length1, _tmp4_);
	{
		gint i;
#line 257 "ease-utilities.vala"
		i = 0;
#line 702 "ease-utilities.c"
		{
			gboolean _tmp5_;
#line 257 "ease-utilities.vala"
			_tmp5_ = TRUE;
#line 257 "ease-utilities.vala"
			while (TRUE) {
#line 709 "ease-utilities.c"
				char* _tmp6_;
#line 257 "ease-utilities.vala"
				if (!_tmp5_) {
#line 257 "ease-utilities.vala"
					i++;
#line 715 "ease-utilities.c"
				}
#line 257 "ease-utilities.vala"
				_tmp5_ = FALSE;
#line 257 "ease-utilities.vala"
				if (!(i < colors_length1)) {
#line 257 "ease-utilities.vala"
					break;
#line 723 "ease-utilities.c"
				}
#line 259 "ease-utilities.vala"
				colors[i] = (_tmp6_ = string_strip (colors[i]), _g_free0 (colors[i]), _tmp6_);
#line 261 "ease-utilities.vala"
				if (g_str_has_prefix (colors[i], color)) {
#line 729 "ease-utilities.c"
					GdkColor gdk_color = {0};
					{
						gboolean _tmp7_;
#line 263 "ease-utilities.vala"
						_tmp7_ = TRUE;
#line 263 "ease-utilities.vala"
						while (TRUE) {
#line 737 "ease-utilities.c"
							gboolean _tmp9_ = FALSE;
#line 263 "ease-utilities.vala"
							if (!_tmp7_) {
#line 741 "ease-utilities.c"
								char* _tmp8_;
#line 264 "ease-utilities.vala"
								colors[i] = (_tmp8_ = string_substring (colors[i], (glong) 1, string_get_length (colors[i]) - 1), _g_free0 (colors[i]), _tmp8_);
#line 745 "ease-utilities.c"
							}
#line 263 "ease-utilities.vala"
							_tmp7_ = FALSE;
#line 263 "ease-utilities.vala"
							if (!g_str_has_prefix (colors[i], "#")) {
#line 263 "ease-utilities.vala"
								_tmp9_ = string_get_length (colors[i]) > 3;
#line 753 "ease-utilities.c"
							} else {
#line 263 "ease-utilities.vala"
								_tmp9_ = FALSE;
#line 757 "ease-utilities.c"
							}
#line 263 "ease-utilities.vala"
							if (!_tmp9_) {
#line 263 "ease-utilities.vala"
								break;
#line 763 "ease-utilities.c"
							}
							;
						}
					}
#line 267 "ease-utilities.vala"
					gdk_color_parse (colors[i], &gdk_color);
#line 770 "ease-utilities.c"
					result = __gdk_color_dup0 (&gdk_color);
					colors = (_vala_array_free (colors, colors_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (settings);
#line 268 "ease-utilities.vala"
					return result;
#line 776 "ease-utilities.c"
				}
			}
		}
	}
#line 272 "ease-utilities.vala"
	g_warning ("ease-utilities.vala:272: Could not find color: %s", color);
#line 783 "ease-utilities.c"
	result = NULL;
	colors = (_vala_array_free (colors, colors_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (settings);
#line 273 "ease-utilities.vala"
	return result;
#line 789 "ease-utilities.c"
}


#line 281 "ease-utilities.vala"
void ease_theme_clutter_color (const char* color, ClutterColor* result) {
#line 795 "ease-utilities.c"
	ClutterColor _tmp1_ = {0};
	GdkColor* _tmp0_;
	ClutterColor _tmp2_;
#line 281 "ease-utilities.vala"
	g_return_if_fail (color != NULL);
#line 801 "ease-utilities.c"
	*result = (_tmp2_ = (ease_transformations_gdk_color_to_clutter_color (_tmp0_ = ease_theme_color (color), &_tmp1_), _tmp1_), _g_free0 (_tmp0_), _tmp2_);
#line 283 "ease-utilities.vala"
	return;
#line 805 "ease-utilities.c"
}


#line 289 "ease-utilities.vala"
GtkWindow* ease_widget_window (GtkWidget* widg) {
#line 811 "ease-utilities.c"
	GtkWindow* result = NULL;
	GtkWidget* _tmp0_;
#line 289 "ease-utilities.vala"
	g_return_val_if_fail (widg != NULL, NULL);
#line 291 "ease-utilities.vala"
	while (TRUE) {
#line 291 "ease-utilities.vala"
		if (!(gtk_widget_get_parent (widg) != NULL)) {
#line 291 "ease-utilities.vala"
			break;
#line 822 "ease-utilities.c"
		}
#line 291 "ease-utilities.vala"
		widg = gtk_widget_get_parent (widg);
#line 826 "ease-utilities.c"
	}
	result = _g_object_ref0 ((_tmp0_ = widg, GTK_IS_WINDOW (_tmp0_) ? ((GtkWindow*) _tmp0_) : NULL));
#line 292 "ease-utilities.vala"
	return result;
#line 831 "ease-utilities.c"
}


#line 298 "ease-utilities.vala"
char* ease_absolute_path (const char* path) {
#line 837 "ease-utilities.c"
	char* result = NULL;
	GFile* file;
	GFile* _tmp0_;
	char* _tmp1_;
#line 298 "ease-utilities.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 300 "ease-utilities.vala"
	file = g_file_new_for_path (path);
#line 846 "ease-utilities.c"
	result = (_tmp1_ = g_file_get_path (_tmp0_ = g_file_resolve_relative_path (file, ".")), _g_object_unref0 (_tmp0_), _tmp1_);
	_g_object_unref0 (file);
#line 301 "ease-utilities.vala"
	return result;
#line 851 "ease-utilities.c"
	_g_object_unref0 (file);
}


#line 304 "ease-utilities.vala"
double ease_dmax (double a, double b) {
#line 858 "ease-utilities.c"
	double result = 0.0;
	double _tmp0_ = 0.0;
#line 306 "ease-utilities.vala"
	if (a > b) {
#line 306 "ease-utilities.vala"
		_tmp0_ = a;
#line 865 "ease-utilities.c"
	} else {
#line 306 "ease-utilities.vala"
		_tmp0_ = b;
#line 869 "ease-utilities.c"
	}
	result = _tmp0_;
#line 306 "ease-utilities.vala"
	return result;
#line 874 "ease-utilities.c"
}


#line 309 "ease-utilities.vala"
double ease_dmin (double a, double b) {
#line 880 "ease-utilities.c"
	double result = 0.0;
	double _tmp0_ = 0.0;
#line 311 "ease-utilities.vala"
	if (a < b) {
#line 311 "ease-utilities.vala"
		_tmp0_ = a;
#line 887 "ease-utilities.c"
	} else {
#line 311 "ease-utilities.vala"
		_tmp0_ = b;
#line 891 "ease-utilities.c"
	}
	result = _tmp0_;
#line 311 "ease-utilities.vala"
	return result;
#line 896 "ease-utilities.c"
}


#line 314 "ease-utilities.vala"
gint ease_roundd (double num) {
#line 902 "ease-utilities.c"
	gint result = 0;
	double _tmp0_ = 0.0;
#line 316 "ease-utilities.vala"
	if ((num - ((gint) num)) < 0.5) {
#line 316 "ease-utilities.vala"
		_tmp0_ = num;
#line 909 "ease-utilities.c"
	} else {
#line 316 "ease-utilities.vala"
		_tmp0_ = num + 1;
#line 913 "ease-utilities.c"
	}
	result = (gint) _tmp0_;
#line 316 "ease-utilities.vala"
	return result;
#line 918 "ease-utilities.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




