/* ease-editor-embed.c generated by valac, the Vala compiler
 * generated from ease-editor-embed.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <ease-core.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <clutter-gtk/clutter-gtk.h>
#include <gdk/gdk.h>
#include <flutter.h>


#define EASE_TYPE_SCROLLABLE_EMBED (ease_scrollable_embed_get_type ())
#define EASE_SCROLLABLE_EMBED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbed))
#define EASE_SCROLLABLE_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbedClass))
#define EASE_IS_SCROLLABLE_EMBED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SCROLLABLE_EMBED))
#define EASE_IS_SCROLLABLE_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SCROLLABLE_EMBED))
#define EASE_SCROLLABLE_EMBED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbedClass))

typedef struct _EaseScrollableEmbed EaseScrollableEmbed;
typedef struct _EaseScrollableEmbedClass EaseScrollableEmbedClass;
typedef struct _EaseScrollableEmbedPrivate EaseScrollableEmbedPrivate;

#define EASE_TYPE_EDITOR_EMBED (ease_editor_embed_get_type ())
#define EASE_EDITOR_EMBED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_EDITOR_EMBED, EaseEditorEmbed))
#define EASE_EDITOR_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_EDITOR_EMBED, EaseEditorEmbedClass))
#define EASE_IS_EDITOR_EMBED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_EDITOR_EMBED))
#define EASE_IS_EDITOR_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_EDITOR_EMBED))
#define EASE_EDITOR_EMBED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_EDITOR_EMBED, EaseEditorEmbedClass))

typedef struct _EaseEditorEmbed EaseEditorEmbed;
typedef struct _EaseEditorEmbedClass EaseEditorEmbedClass;
typedef struct _EaseEditorEmbedPrivate EaseEditorEmbedPrivate;

#define EASE_TYPE_SLIDE_ACTOR (ease_slide_actor_get_type ())
#define EASE_SLIDE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE_ACTOR, EaseSlideActor))
#define EASE_SLIDE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE_ACTOR, EaseSlideActorClass))
#define EASE_IS_SLIDE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE_ACTOR))
#define EASE_IS_SLIDE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE_ACTOR))
#define EASE_SLIDE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE_ACTOR, EaseSlideActorClass))

typedef struct _EaseSlideActor EaseSlideActor;
typedef struct _EaseSlideActorClass EaseSlideActorClass;

#define EASE_TYPE_EDITOR_WINDOW (ease_editor_window_get_type ())
#define EASE_EDITOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_EDITOR_WINDOW, EaseEditorWindow))
#define EASE_EDITOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_EDITOR_WINDOW, EaseEditorWindowClass))
#define EASE_IS_EDITOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_EDITOR_WINDOW))
#define EASE_IS_EDITOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_EDITOR_WINDOW))
#define EASE_EDITOR_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_EDITOR_WINDOW, EaseEditorWindowClass))

typedef struct _EaseEditorWindow EaseEditorWindow;
typedef struct _EaseEditorWindowClass EaseEditorWindowClass;

#define EASE_TYPE_SELECTION_RECTANGLE (ease_selection_rectangle_get_type ())
#define EASE_SELECTION_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SELECTION_RECTANGLE, EaseSelectionRectangle))
#define EASE_SELECTION_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SELECTION_RECTANGLE, EaseSelectionRectangleClass))
#define EASE_IS_SELECTION_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SELECTION_RECTANGLE))
#define EASE_IS_SELECTION_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SELECTION_RECTANGLE))
#define EASE_SELECTION_RECTANGLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SELECTION_RECTANGLE, EaseSelectionRectangleClass))

typedef struct _EaseSelectionRectangle EaseSelectionRectangle;
typedef struct _EaseSelectionRectangleClass EaseSelectionRectangleClass;

#define EASE_TYPE_HANDLE (ease_handle_get_type ())
#define EASE_HANDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_HANDLE, EaseHandle))
#define EASE_HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_HANDLE, EaseHandleClass))
#define EASE_IS_HANDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_HANDLE))
#define EASE_IS_HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_HANDLE))
#define EASE_HANDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_HANDLE, EaseHandleClass))

typedef struct _EaseHandle EaseHandle;
typedef struct _EaseHandleClass EaseHandleClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _EaseSlideActorPrivate EaseSlideActorPrivate;
#define _flutter_container_iterator_unref0(var) ((var == NULL) ? NULL : (var = (flutter_container_iterator_unref (var), NULL)))

struct _EaseScrollableEmbed {
	GtkHBox parent_instance;
	EaseScrollableEmbedPrivate * priv;
};

struct _EaseScrollableEmbedClass {
	GtkHBoxClass parent_class;
};

struct _EaseEditorEmbed {
	EaseScrollableEmbed parent_instance;
	EaseEditorEmbedPrivate * priv;
	EaseSlideActor* slide_actor;
};

struct _EaseEditorEmbedClass {
	EaseScrollableEmbedClass parent_class;
};

struct _EaseEditorEmbedPrivate {
	EaseEditorWindow* win;
	EaseSelectionRectangle* selection_rectangle;
	EaseHandle** handles;
	gint handles_length1;
	gint _handles_size_;
	EaseActor* selected_priv;
	gboolean _is_editing;
	gboolean is_dragging;
	gboolean is_drag_initialized;
	EaseUndoAction* move_undo;
	float mouse_x;
	float mouse_y;
	float orig_x;
	float orig_y;
	float orig_w;
	float orig_h;
	gboolean keys_connected;
	EaseDocument* document;
	float zoom_priv;
	gboolean _zoom_fit;
};

struct _EaseSlideActor {
	ClutterGroup parent_instance;
	EaseSlideActorPrivate * priv;
	ClutterCairoTexture* background;
	FlutterGroup* contents;
	EaseActorContext context;
};

struct _EaseSlideActorClass {
	ClutterGroupClass parent_class;
};


static gpointer ease_editor_embed_parent_class = NULL;
static EaseUndoSourceIface* ease_editor_embed_ease_undo_source_parent_iface = NULL;

GType ease_scrollable_embed_get_type (void) G_GNUC_CONST;
GType ease_editor_embed_get_type (void) G_GNUC_CONST;
GType ease_slide_actor_get_type (void) G_GNUC_CONST;
GType ease_editor_window_get_type (void) G_GNUC_CONST;
GType ease_selection_rectangle_get_type (void) G_GNUC_CONST;
GType ease_handle_get_type (void) G_GNUC_CONST;
#define EASE_EDITOR_EMBED_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_EDITOR_EMBED, EaseEditorEmbedPrivate))
enum  {
	EASE_EDITOR_EMBED_DUMMY_PROPERTY,
	EASE_EDITOR_EMBED_SELECTED,
	EASE_EDITOR_EMBED_ZOOM,
	EASE_EDITOR_EMBED_ZOOM_FIT
};
#define EASE_EDITOR_EMBED_BG_COLOR "bg_color:"
#define EASE_EDITOR_EMBED_SHADE_FACTOR 0.85
#define EASE_EDITOR_EMBED_HANDLE_COUNT 8
#define EASE_EDITOR_EMBED_NUDGE_PIXELS 10
#define EASE_EDITOR_EMBED_NUDGE_SHIFT_PIXELS 50
EaseScrollableEmbed* ease_scrollable_embed_new (gboolean horizontal, gboolean has_frame);
EaseScrollableEmbed* ease_scrollable_embed_construct (GType object_type, gboolean horizontal, gboolean has_frame);
ClutterStage* ease_scrollable_embed_get_stage (EaseScrollableEmbed* self);
void ease_editor_embed_set_zoom (EaseEditorEmbed* self, float value);
void ease_editor_embed_set_zoom_fit (EaseEditorEmbed* self, gboolean value);
gboolean ease_editor_embed_get_zoom_fit (EaseEditorEmbed* self);
float ease_scrollable_embed_get_width (EaseScrollableEmbed* self);
float ease_scrollable_embed_get_height (EaseScrollableEmbed* self);
void ease_editor_embed_reposition_group (EaseEditorEmbed* self);
static void _lambda76_ (EaseEditorEmbed* self);
static void __lambda76__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self);
static void _lambda77_ (GObject* o, GParamSpec* pspec, EaseEditorEmbed* self);
static void __lambda77__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void ease_editor_embed_connect_keys (EaseEditorEmbed* self);
EaseEditorEmbed* ease_editor_embed_new (EaseDocument* d, EaseEditorWindow* w);
EaseEditorEmbed* ease_editor_embed_construct (GType object_type, EaseDocument* d, EaseEditorWindow* w);
static gboolean ease_editor_embed_get_is_editing (EaseEditorEmbed* self);
EaseActor* ease_editor_embed_get_selected (EaseEditorEmbed* self);
static void ease_editor_embed_set_is_editing (EaseEditorEmbed* self, gboolean value);
static void ease_editor_embed_deselect_actor (EaseEditorEmbed* self);
ClutterGroup* ease_scrollable_embed_get_contents (EaseScrollableEmbed* self);
static gboolean ease_editor_embed_actor_clicked (EaseEditorEmbed* self, ClutterActor* sender, ClutterButtonEvent* event);
static gboolean _ease_editor_embed_actor_clicked_clutter_actor_button_press_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
static gboolean ease_editor_embed_actor_released (EaseEditorEmbed* self, ClutterActor* sender, ClutterButtonEvent* event);
static gboolean _ease_editor_embed_actor_released_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
void ease_editor_embed_on_ease_actor_added (EaseEditorEmbed* self, EaseActor* actor);
static void _ease_editor_embed_on_ease_actor_added_ease_slide_actor_ease_actor_added (EaseSlideActor* _sender, EaseActor* actor, gpointer self);
void ease_editor_embed_on_ease_actor_removed (EaseEditorEmbed* self, EaseActor* actor);
static void _ease_editor_embed_on_ease_actor_removed_ease_slide_actor_ease_actor_removed (EaseSlideActor* _sender, EaseActor* actor, gpointer self);
EaseSlide* ease_slide_actor_get_slide (EaseSlideActor* self);
void ease_editor_embed_on_element_removed (EaseEditorEmbed* self, EaseSlide* slide, EaseElement* element, gint index);
static void _ease_editor_embed_on_element_removed_ease_slide_element_removed (EaseSlide* _sender, EaseSlide* _self_, EaseElement* element, gint index, gpointer self);
static void ease_editor_embed_remove_selection_rect (EaseEditorEmbed* self);
EaseSlideActor* ease_slide_actor_new_from_slide (EaseDocument* document, EaseSlide* s, gboolean clip, EaseActorContext ctx);
EaseSlideActor* ease_slide_actor_construct_from_slide (GType object_type, EaseDocument* document, EaseSlide* s, gboolean clip, EaseActorContext ctx);
void ease_editor_embed_set_slide (EaseEditorEmbed* self, EaseSlide* slide);
static gboolean ease_editor_embed_handle_clicked (EaseEditorEmbed* self, ClutterActor* sender, ClutterButtonEvent* event);
static gboolean _ease_editor_embed_handle_clicked_clutter_actor_button_press_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
static gboolean ease_editor_embed_handle_released (EaseEditorEmbed* self, ClutterActor* sender, ClutterButtonEvent* event);
static gboolean _ease_editor_embed_handle_released_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
float ease_editor_embed_get_zoom (EaseEditorEmbed* self);
static void ease_editor_embed_position_selection (EaseEditorEmbed* self);
void ease_handle_reposition (EaseHandle* self, ClutterActor* selection);
void ease_editor_embed_recreate_slide (EaseEditorEmbed* self);
static void ease_editor_embed_select_actor (EaseEditorEmbed* self, EaseActor* sender);
void ease_editor_embed_select_element (EaseEditorEmbed* self, EaseElement* e);
void ease_editor_embed_disconnect_keys (EaseEditorEmbed* self);
static gboolean ease_editor_embed_actor_motion (EaseEditorEmbed* self, ClutterActor* sender, ClutterMotionEvent* event);
static gboolean _ease_editor_embed_actor_motion_clutter_actor_motion_event (ClutterActor* _sender, ClutterMotionEvent* event, gpointer self);
static void ease_editor_embed_set_selected (EaseEditorEmbed* self, EaseActor* value);
EaseSelectionRectangle* ease_selection_rectangle_new (void);
EaseSelectionRectangle* ease_selection_rectangle_construct (GType object_type);
EaseHandle* ease_handle_new (EaseHandlePosition pos);
EaseHandle* ease_handle_construct (GType object_type, EaseHandlePosition pos);
void ease_handle_flip (EaseHandle* self, gboolean f);
static gboolean ease_editor_embed_handle_motion (EaseEditorEmbed* self, ClutterActor* sender, ClutterMotionEvent* event);
static gboolean _ease_editor_embed_handle_motion_clutter_actor_motion_event (ClutterActor* _sender, ClutterMotionEvent* event, gpointer self);
void ease_handle_drag_from_center (EaseHandle* self, float change_x, float change_y, EaseActor* target, gboolean prop);
void ease_handle_drag (EaseHandle* self, float change_x, float change_y, EaseActor* target, gboolean prop);
void ease_editor_embed_set_element_color (EaseEditorEmbed* self, ClutterColor* color);
gboolean ease_editor_embed_on_key_press_event (EaseEditorEmbed* self, GtkWidget* _self_, GdkEventKey* event);
static gboolean _ease_editor_embed_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
void ease_editor_embed_on_selected_changed (EaseEditorEmbed* self, EaseSlide* sender);
static void _ease_editor_embed_on_selected_changed_ease_slide_changed (EaseSlide* _sender, EaseSlide* _self_, gpointer self);
static void ease_editor_embed_finalize (GObject* obj);
static void ease_editor_embed_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_editor_embed_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 230 "ease-editor-embed.vala"
static void _lambda76_ (EaseEditorEmbed* self) {
#line 231 "ease-editor-embed.vala"
	if (self->priv->_zoom_fit) {
#line 258 "ease-editor-embed.c"
		float _tmp0_ = 0.0F;
#line 233 "ease-editor-embed.vala"
		if ((ease_scrollable_embed_get_width ((EaseScrollableEmbed*) self) / ease_scrollable_embed_get_height ((EaseScrollableEmbed*) self)) > (((float) ease_document_get_width (self->priv->document)) / ease_document_get_height (self->priv->document))) {
#line 234 "ease-editor-embed.vala"
			_tmp0_ = ease_scrollable_embed_get_height ((EaseScrollableEmbed*) self) / ease_document_get_height (self->priv->document);
#line 264 "ease-editor-embed.c"
		} else {
#line 235 "ease-editor-embed.vala"
			_tmp0_ = ease_scrollable_embed_get_width ((EaseScrollableEmbed*) self) / ease_document_get_width (self->priv->document);
#line 268 "ease-editor-embed.c"
		}
#line 233 "ease-editor-embed.vala"
		ease_editor_embed_set_zoom (self, _tmp0_);
#line 236 "ease-editor-embed.vala"
		ease_editor_embed_reposition_group (self);
#line 274 "ease-editor-embed.c"
	} else {
#line 240 "ease-editor-embed.vala"
		ease_editor_embed_reposition_group (self);
#line 278 "ease-editor-embed.c"
	}
}


#line 230 "ease-editor-embed.vala"
static void __lambda76__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self) {
#line 285 "ease-editor-embed.c"
	_lambda76_ (self);
}


#line 245 "ease-editor-embed.vala"
static void _lambda77_ (GObject* o, GParamSpec* pspec, EaseEditorEmbed* self) {
#line 292 "ease-editor-embed.c"
	float _tmp0_ = 0.0F;
#line 245 "ease-editor-embed.vala"
	g_return_if_fail (o != NULL);
#line 245 "ease-editor-embed.vala"
	g_return_if_fail (pspec != NULL);
#line 246 "ease-editor-embed.vala"
	if (!self->priv->_zoom_fit) {
#line 246 "ease-editor-embed.vala"
		return;
#line 302 "ease-editor-embed.c"
	}
#line 248 "ease-editor-embed.vala"
	if ((ease_scrollable_embed_get_width ((EaseScrollableEmbed*) self) / ease_scrollable_embed_get_height ((EaseScrollableEmbed*) self)) > (((float) ease_document_get_width (self->priv->document)) / ease_document_get_height (self->priv->document))) {
#line 249 "ease-editor-embed.vala"
		_tmp0_ = ease_scrollable_embed_get_height ((EaseScrollableEmbed*) self) / ease_document_get_height (self->priv->document);
#line 308 "ease-editor-embed.c"
	} else {
#line 250 "ease-editor-embed.vala"
		_tmp0_ = ease_scrollable_embed_get_width ((EaseScrollableEmbed*) self) / ease_document_get_width (self->priv->document);
#line 312 "ease-editor-embed.c"
	}
#line 248 "ease-editor-embed.vala"
	ease_editor_embed_set_zoom (self, _tmp0_);
#line 251 "ease-editor-embed.vala"
	ease_editor_embed_reposition_group (self);
#line 318 "ease-editor-embed.c"
}


#line 245 "ease-editor-embed.vala"
static void __lambda77__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 324 "ease-editor-embed.c"
	_lambda77_ (_sender, pspec, self);
}


#line 208 "ease-editor-embed.vala"
EaseEditorEmbed* ease_editor_embed_construct (GType object_type, EaseDocument* d, EaseEditorWindow* w) {
#line 331 "ease-editor-embed.c"
	EaseEditorEmbed * self;
	EaseEditorWindow* _tmp0_;
	ClutterStage* _tmp1_;
	ClutterColor out_color = {0};
	ClutterColor color = {0};
	ClutterStage* _tmp2_;
	EaseDocument* _tmp3_;
#line 208 "ease-editor-embed.vala"
	g_return_val_if_fail (d != NULL, NULL);
#line 208 "ease-editor-embed.vala"
	g_return_val_if_fail (w != NULL, NULL);
#line 210 "ease-editor-embed.vala"
	self = (EaseEditorEmbed*) ease_scrollable_embed_construct (object_type, TRUE, TRUE);
#line 211 "ease-editor-embed.vala"
	self->priv->win = (_tmp0_ = _g_object_ref0 (w), _g_object_unref0 (self->priv->win), _tmp0_);
#line 214 "ease-editor-embed.vala"
	clutter_stage_set_use_fog (_tmp1_ = ease_scrollable_embed_get_stage ((EaseScrollableEmbed*) self), FALSE);
#line 349 "ease-editor-embed.c"
	_g_object_unref0 (_tmp1_);
#line 218 "ease-editor-embed.vala"
	gtk_clutter_get_bg_color ((GtkWidget*) self, GTK_STATE_NORMAL, &color);
#line 219 "ease-editor-embed.vala"
	clutter_color_shade (&color, EASE_EDITOR_EMBED_SHADE_FACTOR, &out_color);
#line 221 "ease-editor-embed.vala"
	clutter_stage_set_color (_tmp2_ = ease_scrollable_embed_get_stage ((EaseScrollableEmbed*) self), &out_color);
#line 357 "ease-editor-embed.c"
	_g_object_unref0 (_tmp2_);
#line 223 "ease-editor-embed.vala"
	self->priv->document = (_tmp3_ = _g_object_ref0 (d), _g_object_unref0 (self->priv->document), _tmp3_);
#line 224 "ease-editor-embed.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, 320, 240);
#line 226 "ease-editor-embed.vala"
	ease_editor_embed_set_zoom (self, (float) 1);
#line 227 "ease-editor-embed.vala"
	ease_editor_embed_set_zoom_fit (self, FALSE);
#line 230 "ease-editor-embed.vala"
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) __lambda76__gtk_widget_size_allocate, self, 0);
#line 245 "ease-editor-embed.vala"
	g_signal_connect_object ((GObject*) self, "notify::zoom-fit", (GCallback) __lambda77__g_object_notify, self, 0);
#line 254 "ease-editor-embed.vala"
	ease_editor_embed_connect_keys (self);
#line 373 "ease-editor-embed.c"
	return self;
}


#line 208 "ease-editor-embed.vala"
EaseEditorEmbed* ease_editor_embed_new (EaseDocument* d, EaseEditorWindow* w) {
#line 208 "ease-editor-embed.vala"
	return ease_editor_embed_construct (EASE_TYPE_EDITOR_EMBED, d, w);
#line 382 "ease-editor-embed.c"
}


#line 433 "ease-editor-embed.vala"
static gboolean _ease_editor_embed_actor_clicked_clutter_actor_button_press_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
#line 388 "ease-editor-embed.c"
	gboolean result;
	result = ease_editor_embed_actor_clicked (self, _sender, event);
	return result;
}


#line 542 "ease-editor-embed.vala"
static gboolean _ease_editor_embed_actor_released_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
#line 397 "ease-editor-embed.c"
	gboolean result;
	result = ease_editor_embed_actor_released (self, _sender, event);
	return result;
}


#line 730 "ease-editor-embed.vala"
static void _ease_editor_embed_on_ease_actor_added_ease_slide_actor_ease_actor_added (EaseSlideActor* _sender, EaseActor* actor, gpointer self) {
#line 406 "ease-editor-embed.c"
	ease_editor_embed_on_ease_actor_added (self, actor);
}


#line 719 "ease-editor-embed.vala"
static void _ease_editor_embed_on_ease_actor_removed_ease_slide_actor_ease_actor_removed (EaseSlideActor* _sender, EaseActor* actor, gpointer self) {
#line 413 "ease-editor-embed.c"
	ease_editor_embed_on_ease_actor_removed (self, actor);
}


#line 806 "ease-editor-embed.vala"
static void _ease_editor_embed_on_element_removed_ease_slide_element_removed (EaseSlide* _sender, EaseSlide* _self_, EaseElement* element, gint index, gpointer self) {
#line 420 "ease-editor-embed.c"
	ease_editor_embed_on_element_removed (self, _self_, element, index);
}


#line 270 "ease-editor-embed.vala"
void ease_editor_embed_set_slide (EaseEditorEmbed* self, EaseSlide* slide) {
#line 427 "ease-editor-embed.c"
	EaseSlideActor* _tmp5_;
#line 270 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 270 "ease-editor-embed.vala"
	g_return_if_fail (slide != NULL);
#line 272 "ease-editor-embed.vala"
	if (slide == NULL) {
#line 272 "ease-editor-embed.vala"
		return;
#line 437 "ease-editor-embed.c"
	}
#line 274 "ease-editor-embed.vala"
	if (self->priv->_is_editing) {
#line 276 "ease-editor-embed.vala"
		ease_actor_end_edit (ease_editor_embed_get_selected (self), (GtkWidget*) self);
#line 277 "ease-editor-embed.vala"
		ease_editor_embed_set_is_editing (self, FALSE);
#line 445 "ease-editor-embed.c"
	}
#line 280 "ease-editor-embed.vala"
	ease_editor_embed_connect_keys (self);
#line 281 "ease-editor-embed.vala"
	ease_editor_embed_deselect_actor (self);
#line 282 "ease-editor-embed.vala"
	g_signal_emit_by_name (self, "element-deselected", NULL);
#line 285 "ease-editor-embed.vala"
	if (self->slide_actor != NULL) {
#line 455 "ease-editor-embed.c"
		guint _tmp2_;
		guint _tmp3_;
		guint _tmp4_;
#line 287 "ease-editor-embed.vala"
		clutter_container_remove_actor ((ClutterContainer*) ease_scrollable_embed_get_contents ((EaseScrollableEmbed*) self), (ClutterActor*) self->slide_actor);
#line 461 "ease-editor-embed.c"
		{
			FlutterContainerIterator* _a_it;
#line 288 "ease-editor-embed.vala"
			_a_it = flutter_container_iterator ((FlutterContainer*) self->slide_actor->contents);
#line 288 "ease-editor-embed.vala"
			while (TRUE) {
#line 468 "ease-editor-embed.c"
				ClutterActor* a;
				guint _tmp0_;
				guint _tmp1_;
#line 288 "ease-editor-embed.vala"
				if (!flutter_container_iterator_next (_a_it)) {
#line 288 "ease-editor-embed.vala"
					break;
#line 476 "ease-editor-embed.c"
				}
#line 288 "ease-editor-embed.vala"
				a = flutter_container_iterator_get (_a_it);
#line 290 "ease-editor-embed.vala"
				g_signal_parse_name ("button-press-event", CLUTTER_TYPE_ACTOR, &_tmp0_, NULL, FALSE);
#line 290 "ease-editor-embed.vala"
				g_signal_handlers_disconnect_matched (a, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _ease_editor_embed_actor_clicked_clutter_actor_button_press_event, self);
#line 291 "ease-editor-embed.vala"
				g_signal_parse_name ("button-release-event", CLUTTER_TYPE_ACTOR, &_tmp1_, NULL, FALSE);
#line 291 "ease-editor-embed.vala"
				g_signal_handlers_disconnect_matched (a, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _ease_editor_embed_actor_released_clutter_actor_button_release_event, self);
#line 292 "ease-editor-embed.vala"
				clutter_actor_set_reactive (a, FALSE);
#line 490 "ease-editor-embed.c"
				_g_object_unref0 (a);
			}
			_flutter_container_iterator_unref0 (_a_it);
		}
#line 295 "ease-editor-embed.vala"
		g_signal_parse_name ("ease-actor-added", EASE_TYPE_SLIDE_ACTOR, &_tmp2_, NULL, FALSE);
#line 295 "ease-editor-embed.vala"
		g_signal_handlers_disconnect_matched (self->slide_actor, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _ease_editor_embed_on_ease_actor_added_ease_slide_actor_ease_actor_added, self);
#line 296 "ease-editor-embed.vala"
		g_signal_parse_name ("ease-actor-removed", EASE_TYPE_SLIDE_ACTOR, &_tmp3_, NULL, FALSE);
#line 296 "ease-editor-embed.vala"
		g_signal_handlers_disconnect_matched (self->slide_actor, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _ease_editor_embed_on_ease_actor_removed_ease_slide_actor_ease_actor_removed, self);
#line 297 "ease-editor-embed.vala"
		g_signal_parse_name ("element-removed", EASE_TYPE_SLIDE, &_tmp4_, NULL, FALSE);
#line 297 "ease-editor-embed.vala"
		g_signal_handlers_disconnect_matched (ease_slide_actor_get_slide (self->slide_actor), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _ease_editor_embed_on_element_removed_ease_slide_element_removed, self);
#line 507 "ease-editor-embed.c"
	}
#line 301 "ease-editor-embed.vala"
	ease_editor_embed_remove_selection_rect (self);
#line 304 "ease-editor-embed.vala"
	self->slide_actor = (_tmp5_ = g_object_ref_sink (ease_slide_actor_new_from_slide (self->priv->document, slide, FALSE, EASE_ACTOR_CONTEXT_EDITOR)), _g_object_unref0 (self->slide_actor), _tmp5_);
#line 513 "ease-editor-embed.c"
	{
		FlutterContainerIterator* _a_it;
#line 310 "ease-editor-embed.vala"
		_a_it = flutter_container_iterator ((FlutterContainer*) self->slide_actor->contents);
#line 310 "ease-editor-embed.vala"
		while (TRUE) {
#line 520 "ease-editor-embed.c"
			ClutterActor* a;
#line 310 "ease-editor-embed.vala"
			if (!flutter_container_iterator_next (_a_it)) {
#line 310 "ease-editor-embed.vala"
				break;
#line 526 "ease-editor-embed.c"
			}
#line 310 "ease-editor-embed.vala"
			a = flutter_container_iterator_get (_a_it);
#line 312 "ease-editor-embed.vala"
			g_signal_connect_object (a, "button-press-event", (GCallback) _ease_editor_embed_actor_clicked_clutter_actor_button_press_event, self, 0);
#line 313 "ease-editor-embed.vala"
			g_signal_connect_object (a, "button-release-event", (GCallback) _ease_editor_embed_actor_released_clutter_actor_button_release_event, self, 0);
#line 314 "ease-editor-embed.vala"
			clutter_actor_set_reactive (a, TRUE);
#line 536 "ease-editor-embed.c"
			_g_object_unref0 (a);
		}
		_flutter_container_iterator_unref0 (_a_it);
	}
#line 317 "ease-editor-embed.vala"
	g_signal_connect_object (self->slide_actor, "ease-actor-added", (GCallback) _ease_editor_embed_on_ease_actor_added_ease_slide_actor_ease_actor_added, self, 0);
#line 318 "ease-editor-embed.vala"
	g_signal_connect_object (self->slide_actor, "ease-actor-removed", (GCallback) _ease_editor_embed_on_ease_actor_removed_ease_slide_actor_ease_actor_removed, self, 0);
#line 319 "ease-editor-embed.vala"
	g_signal_connect_object (ease_slide_actor_get_slide (self->slide_actor), "element-removed", (GCallback) _ease_editor_embed_on_element_removed_ease_slide_element_removed, self, 0);
#line 321 "ease-editor-embed.vala"
	clutter_container_add_actor ((ClutterContainer*) ease_scrollable_embed_get_contents ((EaseScrollableEmbed*) self), (ClutterActor*) self->slide_actor);
#line 322 "ease-editor-embed.vala"
	ease_editor_embed_reposition_group (self);
#line 551 "ease-editor-embed.c"
}


#line 606 "ease-editor-embed.vala"
static gboolean _ease_editor_embed_handle_clicked_clutter_actor_button_press_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
#line 557 "ease-editor-embed.c"
	gboolean result;
	result = ease_editor_embed_handle_clicked (self, _sender, event);
	return result;
}


#line 634 "ease-editor-embed.vala"
static gboolean _ease_editor_embed_handle_released_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
#line 566 "ease-editor-embed.c"
	gboolean result;
	result = ease_editor_embed_handle_released (self, _sender, event);
	return result;
}


#line 328 "ease-editor-embed.vala"
static void ease_editor_embed_remove_selection_rect (EaseEditorEmbed* self) {
#line 328 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 330 "ease-editor-embed.vala"
	if (self->priv->selection_rectangle != NULL) {
#line 579 "ease-editor-embed.c"
		EaseHandle** _tmp2_;
#line 332 "ease-editor-embed.vala"
		if (clutter_actor_get_parent ((ClutterActor*) self->priv->selection_rectangle) == CLUTTER_ACTOR (ease_scrollable_embed_get_contents ((EaseScrollableEmbed*) self))) {
#line 334 "ease-editor-embed.vala"
			clutter_container_remove_actor ((ClutterContainer*) ease_scrollable_embed_get_contents ((EaseScrollableEmbed*) self), (ClutterActor*) self->priv->selection_rectangle);
#line 585 "ease-editor-embed.c"
		}
		{
			EaseHandle** h_collection;
			int h_collection_length1;
			int h_it;
#line 336 "ease-editor-embed.vala"
			h_collection = self->priv->handles;
#line 593 "ease-editor-embed.c"
			h_collection_length1 = self->priv->handles_length1;
			for (h_it = 0; h_it < self->priv->handles_length1; h_it = h_it + 1) {
				EaseHandle* h;
				h = _g_object_ref0 (h_collection[h_it]);
				{
					guint _tmp0_;
					guint _tmp1_;
#line 338 "ease-editor-embed.vala"
					if (clutter_actor_get_parent ((ClutterActor*) h) == CLUTTER_ACTOR (ease_scrollable_embed_get_contents ((EaseScrollableEmbed*) self))) {
#line 340 "ease-editor-embed.vala"
						clutter_container_remove_actor ((ClutterContainer*) ease_scrollable_embed_get_contents ((EaseScrollableEmbed*) self), (ClutterActor*) h);
#line 605 "ease-editor-embed.c"
					}
#line 342 "ease-editor-embed.vala"
					g_signal_parse_name ("button-press-event", CLUTTER_TYPE_ACTOR, &_tmp0_, NULL, FALSE);
#line 342 "ease-editor-embed.vala"
					g_signal_handlers_disconnect_matched ((ClutterActor*) h, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _ease_editor_embed_handle_clicked_clutter_actor_button_press_event, self);
#line 343 "ease-editor-embed.vala"
					g_signal_parse_name ("button-release-event", CLUTTER_TYPE_ACTOR, &_tmp1_, NULL, FALSE);
#line 343 "ease-editor-embed.vala"
					g_signal_handlers_disconnect_matched ((ClutterActor*) h, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _ease_editor_embed_handle_released_clutter_actor_button_release_event, self);
#line 615 "ease-editor-embed.c"
					_g_object_unref0 (h);
				}
			}
		}
#line 345 "ease-editor-embed.vala"
		self->priv->handles = (_tmp2_ = NULL, self->priv->handles = (_vala_array_free (self->priv->handles, self->priv->handles_length1, (GDestroyNotify) g_object_unref), NULL), self->priv->handles_length1 = 0, self->priv->_handles_size_ = self->priv->handles_length1, _tmp2_);
#line 622 "ease-editor-embed.c"
	}
}


#line 355 "ease-editor-embed.vala"
void ease_editor_embed_reposition_group (EaseEditorEmbed* self) {
#line 629 "ease-editor-embed.c"
	float w;
	float h;
	float _tmp0_ = 0.0F;
	float _tmp1_ = 0.0F;
	gboolean _tmp2_ = FALSE;
#line 355 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 357 "ease-editor-embed.vala"
	if (self->slide_actor == NULL) {
#line 359 "ease-editor-embed.vala"
		return;
#line 641 "ease-editor-embed.c"
	}
#line 362 "ease-editor-embed.vala"
	w = ease_editor_embed_get_zoom (self) * ease_slide_get_width (ease_slide_actor_get_slide (self->slide_actor));
#line 363 "ease-editor-embed.vala"
	h = ease_editor_embed_get_zoom (self) * ease_slide_get_height (ease_slide_actor_get_slide (self->slide_actor));
#line 365 "ease-editor-embed.vala"
	clutter_actor_set_scale_full ((ClutterActor*) self->slide_actor, (double) ease_editor_embed_get_zoom (self), (double) ease_editor_embed_get_zoom (self), (float) 0, (float) 0);
#line 367 "ease-editor-embed.vala"
	if (w < ease_scrollable_embed_get_width ((EaseScrollableEmbed*) self)) {
#line 368 "ease-editor-embed.vala"
		_tmp0_ = (ease_scrollable_embed_get_width ((EaseScrollableEmbed*) self) / 2) - (w / 2);
#line 653 "ease-editor-embed.c"
	} else {
#line 369 "ease-editor-embed.vala"
		_tmp0_ = (float) 0;
#line 657 "ease-editor-embed.c"
	}
#line 367 "ease-editor-embed.vala"
	clutter_actor_set_x ((ClutterActor*) self->slide_actor, (float) ease_roundd ((double) _tmp0_));
#line 371 "ease-editor-embed.vala"
	if (h < ease_scrollable_embed_get_height ((EaseScrollableEmbed*) self)) {
#line 372 "ease-editor-embed.vala"
		_tmp1_ = (ease_scrollable_embed_get_height ((EaseScrollableEmbed*) self) / 2) - (h / 2);
#line 665 "ease-editor-embed.c"
	} else {
#line 373 "ease-editor-embed.vala"
		_tmp1_ = (float) 0;
#line 669 "ease-editor-embed.c"
	}
#line 371 "ease-editor-embed.vala"
	clutter_actor_set_y ((ClutterActor*) self->slide_actor, (float) ease_roundd ((double) _tmp1_));
#line 375 "ease-editor-embed.vala"
	if (self->priv->selection_rectangle != NULL) {
#line 375 "ease-editor-embed.vala"
		_tmp2_ = ease_editor_embed_get_selected (self) != NULL;
#line 677 "ease-editor-embed.c"
	} else {
#line 375 "ease-editor-embed.vala"
		_tmp2_ = FALSE;
#line 681 "ease-editor-embed.c"
	}
#line 375 "ease-editor-embed.vala"
	if (_tmp2_) {
#line 377 "ease-editor-embed.vala"
		ease_editor_embed_position_selection (self);
#line 687 "ease-editor-embed.c"
	}
}


#line 387 "ease-editor-embed.vala"
static void ease_editor_embed_position_selection (EaseEditorEmbed* self) {
#line 387 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 389 "ease-editor-embed.vala"
	clutter_actor_set_position ((ClutterActor*) self->priv->selection_rectangle, (ease_editor_embed_get_zoom (self) * clutter_actor_get_x ((ClutterActor*) ease_editor_embed_get_selected (self))) + clutter_actor_get_x ((ClutterActor*) self->slide_actor), (ease_editor_embed_get_zoom (self) * clutter_actor_get_y ((ClutterActor*) ease_editor_embed_get_selected (self))) + clutter_actor_get_y ((ClutterActor*) self->slide_actor));
#line 391 "ease-editor-embed.vala"
	clutter_actor_set_size ((ClutterActor*) self->priv->selection_rectangle, ease_editor_embed_get_zoom (self) * clutter_actor_get_width ((ClutterActor*) ease_editor_embed_get_selected (self)), ease_editor_embed_get_zoom (self) * clutter_actor_get_height ((ClutterActor*) ease_editor_embed_get_selected (self)));
#line 700 "ease-editor-embed.c"
	{
		EaseHandle** h_collection;
		int h_collection_length1;
		int h_it;
#line 394 "ease-editor-embed.vala"
		h_collection = self->priv->handles;
#line 707 "ease-editor-embed.c"
		h_collection_length1 = self->priv->handles_length1;
		for (h_it = 0; h_it < self->priv->handles_length1; h_it = h_it + 1) {
			EaseHandle* h;
			h = _g_object_ref0 (h_collection[h_it]);
			{
#line 396 "ease-editor-embed.vala"
				ease_handle_reposition (h, (ClutterActor*) self->priv->selection_rectangle);
#line 715 "ease-editor-embed.c"
				_g_object_unref0 (h);
			}
		}
	}
}


#line 403 "ease-editor-embed.vala"
void ease_editor_embed_recreate_slide (EaseEditorEmbed* self) {
#line 403 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 405 "ease-editor-embed.vala"
	ease_editor_embed_set_slide (self, ease_slide_actor_get_slide (self->slide_actor));
#line 729 "ease-editor-embed.c"
}


#line 413 "ease-editor-embed.vala"
void ease_editor_embed_select_element (EaseEditorEmbed* self, EaseElement* e) {
#line 413 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 413 "ease-editor-embed.vala"
	g_return_if_fail (e != NULL);
#line 739 "ease-editor-embed.c"
	{
		FlutterContainerIterator* _a_it;
#line 415 "ease-editor-embed.vala"
		_a_it = flutter_container_iterator ((FlutterContainer*) self->slide_actor->contents);
#line 415 "ease-editor-embed.vala"
		while (TRUE) {
#line 746 "ease-editor-embed.c"
			ClutterActor* a;
			ClutterActor* _tmp0_;
#line 415 "ease-editor-embed.vala"
			if (!flutter_container_iterator_next (_a_it)) {
#line 415 "ease-editor-embed.vala"
				break;
#line 753 "ease-editor-embed.c"
			}
#line 415 "ease-editor-embed.vala"
			a = flutter_container_iterator_get (_a_it);
#line 417 "ease-editor-embed.vala"
			if ((_tmp0_ = a, EASE_IS_ACTOR (_tmp0_) ? ((EaseActor*) _tmp0_) : NULL)->element == e) {
#line 759 "ease-editor-embed.c"
				ClutterActor* _tmp1_;
#line 419 "ease-editor-embed.vala"
				ease_editor_embed_select_actor (self, (_tmp1_ = a, EASE_IS_ACTOR (_tmp1_) ? ((EaseActor*) _tmp1_) : NULL));
#line 763 "ease-editor-embed.c"
			}
			_g_object_unref0 (a);
		}
		_flutter_container_iterator_unref0 (_a_it);
	}
}


#line 564 "ease-editor-embed.vala"
static gboolean _ease_editor_embed_actor_motion_clutter_actor_motion_event (ClutterActor* _sender, ClutterMotionEvent* event, gpointer self) {
#line 774 "ease-editor-embed.c"
	gboolean result;
	result = ease_editor_embed_actor_motion (self, _sender, event);
	return result;
}


#line 433 "ease-editor-embed.vala"
static gboolean ease_editor_embed_actor_clicked (EaseEditorEmbed* self, ClutterActor* sender, ClutterButtonEvent* event) {
#line 783 "ease-editor-embed.c"
	gboolean result = FALSE;
	ClutterActor* _tmp2_;
#line 433 "ease-editor-embed.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 433 "ease-editor-embed.vala"
	g_return_val_if_fail (sender != NULL, FALSE);
#line 436 "ease-editor-embed.vala"
	if ((*event).click_count == 2) {
#line 792 "ease-editor-embed.c"
		ClutterActor* _tmp0_;
#line 438 "ease-editor-embed.vala"
		ease_editor_embed_disconnect_keys (self);
#line 439 "ease-editor-embed.vala"
		ease_actor_edit ((_tmp0_ = sender, EASE_IS_ACTOR (_tmp0_) ? ((EaseActor*) _tmp0_) : NULL), (GtkWidget*) self);
#line 440 "ease-editor-embed.vala"
		ease_editor_embed_set_is_editing (self, TRUE);
#line 800 "ease-editor-embed.c"
		result = TRUE;
#line 441 "ease-editor-embed.vala"
		return result;
#line 804 "ease-editor-embed.c"
	} else {
#line 445 "ease-editor-embed.vala"
		if (sender == CLUTTER_ACTOR (ease_editor_embed_get_selected (self))) {
#line 808 "ease-editor-embed.c"
			EaseUndoAction* _tmp1_;
#line 447 "ease-editor-embed.vala"
			self->priv->is_dragging = TRUE;
#line 448 "ease-editor-embed.vala"
			self->priv->is_drag_initialized = FALSE;
#line 449 "ease-editor-embed.vala"
			clutter_grab_pointer (sender);
#line 450 "ease-editor-embed.vala"
			g_signal_connect_object (sender, "motion-event", (GCallback) _ease_editor_embed_actor_motion_clutter_actor_motion_event, self, 0);
#line 453 "ease-editor-embed.vala"
			self->priv->move_undo = (_tmp1_ = ease_undo_action_new ((GObject*) ease_editor_embed_get_selected (self)->element, "x"), _g_object_unref0 (self->priv->move_undo), _tmp1_);
#line 454 "ease-editor-embed.vala"
			ease_undo_action_add (self->priv->move_undo, (GObject*) ease_editor_embed_get_selected (self)->element, "y");
#line 822 "ease-editor-embed.c"
			result = TRUE;
#line 456 "ease-editor-embed.vala"
			return result;
#line 826 "ease-editor-embed.c"
		}
	}
#line 459 "ease-editor-embed.vala"
	ease_editor_embed_select_actor (self, (_tmp2_ = sender, EASE_IS_ACTOR (_tmp2_) ? ((EaseActor*) _tmp2_) : NULL));
#line 831 "ease-editor-embed.c"
	result = TRUE;
#line 461 "ease-editor-embed.vala"
	return result;
#line 835 "ease-editor-embed.c"
}


#line 469 "ease-editor-embed.vala"
static void ease_editor_embed_select_actor (EaseEditorEmbed* self, EaseActor* sender) {
#line 841 "ease-editor-embed.c"
	EaseActor* _tmp0_;
	EaseSelectionRectangle* _tmp1_;
#line 469 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 469 "ease-editor-embed.vala"
	g_return_if_fail (sender != NULL);
#line 472 "ease-editor-embed.vala"
	ease_editor_embed_deselect_actor (self);
#line 474 "ease-editor-embed.vala"
	ease_editor_embed_connect_keys (self);
#line 476 "ease-editor-embed.vala"
	ease_editor_embed_set_selected (self, (_tmp0_ = sender, EASE_IS_ACTOR (_tmp0_) ? ((EaseActor*) _tmp0_) : NULL));
#line 477 "ease-editor-embed.vala"
	g_signal_emit_by_name (self, "element-selected", ease_editor_embed_get_selected (self)->element);
#line 480 "ease-editor-embed.vala"
	self->priv->selection_rectangle = (_tmp1_ = g_object_ref_sink (ease_selection_rectangle_new ()), _g_object_unref0 (self->priv->selection_rectangle), _tmp1_);
#line 481 "ease-editor-embed.vala"
	ease_editor_embed_position_selection (self);
#line 482 "ease-editor-embed.vala"
	clutter_container_add_actor ((ClutterContainer*) ease_scrollable_embed_get_contents ((EaseScrollableEmbed*) self), (ClutterActor*) self->priv->selection_rectangle);
#line 485 "ease-editor-embed.vala"
	if (self->priv->handles == NULL) {
#line 864 "ease-editor-embed.c"
		EaseHandle** _tmp2_;
#line 487 "ease-editor-embed.vala"
		self->priv->handles = (_tmp2_ = g_new0 (EaseHandle*, EASE_EDITOR_EMBED_HANDLE_COUNT + 1), self->priv->handles = (_vala_array_free (self->priv->handles, self->priv->handles_length1, (GDestroyNotify) g_object_unref), NULL), self->priv->handles_length1 = EASE_EDITOR_EMBED_HANDLE_COUNT, self->priv->_handles_size_ = self->priv->handles_length1, _tmp2_);
#line 868 "ease-editor-embed.c"
		{
			gint i;
#line 488 "ease-editor-embed.vala"
			i = 0;
#line 873 "ease-editor-embed.c"
			{
				gboolean _tmp3_;
#line 488 "ease-editor-embed.vala"
				_tmp3_ = TRUE;
#line 488 "ease-editor-embed.vala"
				while (TRUE) {
#line 880 "ease-editor-embed.c"
					EaseHandle* _tmp4_;
#line 488 "ease-editor-embed.vala"
					if (!_tmp3_) {
#line 488 "ease-editor-embed.vala"
						i++;
#line 886 "ease-editor-embed.c"
					}
#line 488 "ease-editor-embed.vala"
					_tmp3_ = FALSE;
#line 488 "ease-editor-embed.vala"
					if (!(i < EASE_EDITOR_EMBED_HANDLE_COUNT)) {
#line 488 "ease-editor-embed.vala"
						break;
#line 894 "ease-editor-embed.c"
					}
#line 490 "ease-editor-embed.vala"
					self->priv->handles[i] = (_tmp4_ = g_object_ref_sink (ease_handle_new ((EaseHandlePosition) i)), _g_object_unref0 (self->priv->handles[i]), _tmp4_);
#line 491 "ease-editor-embed.vala"
					clutter_container_add_actor ((ClutterContainer*) ease_scrollable_embed_get_contents ((EaseScrollableEmbed*) self), (ClutterActor*) self->priv->handles[i]);
#line 492 "ease-editor-embed.vala"
					g_signal_connect_object ((ClutterActor*) self->priv->handles[i], "button-press-event", (GCallback) _ease_editor_embed_handle_clicked_clutter_actor_button_press_event, self, 0);
#line 493 "ease-editor-embed.vala"
					g_signal_connect_object ((ClutterActor*) self->priv->handles[i], "button-release-event", (GCallback) _ease_editor_embed_handle_released_clutter_actor_button_release_event, self, 0);
#line 904 "ease-editor-embed.c"
				}
			}
		}
	}
	{
		gint i;
#line 497 "ease-editor-embed.vala"
		i = 0;
#line 913 "ease-editor-embed.c"
		{
			gboolean _tmp5_;
#line 497 "ease-editor-embed.vala"
			_tmp5_ = TRUE;
#line 497 "ease-editor-embed.vala"
			while (TRUE) {
#line 497 "ease-editor-embed.vala"
				if (!_tmp5_) {
#line 497 "ease-editor-embed.vala"
					i++;
#line 924 "ease-editor-embed.c"
				}
#line 497 "ease-editor-embed.vala"
				_tmp5_ = FALSE;
#line 497 "ease-editor-embed.vala"
				if (!(i < EASE_EDITOR_EMBED_HANDLE_COUNT)) {
#line 497 "ease-editor-embed.vala"
					break;
#line 932 "ease-editor-embed.c"
				}
#line 499 "ease-editor-embed.vala"
				ease_handle_reposition (self->priv->handles[i], (ClutterActor*) self->priv->selection_rectangle);
#line 500 "ease-editor-embed.vala"
				clutter_container_raise_child ((ClutterContainer*) ease_scrollable_embed_get_contents ((EaseScrollableEmbed*) self), (ClutterActor*) self->priv->handles[i], (ClutterActor*) self->priv->selection_rectangle);
#line 938 "ease-editor-embed.c"
			}
		}
	}
#line 504 "ease-editor-embed.vala"
	gtk_widget_set_can_focus ((GtkWidget*) self, TRUE);
#line 505 "ease-editor-embed.vala"
	gtk_widget_grab_focus ((GtkWidget*) self);
#line 946 "ease-editor-embed.c"
}


#line 513 "ease-editor-embed.vala"
static void ease_editor_embed_deselect_actor (EaseEditorEmbed* self) {
#line 952 "ease-editor-embed.c"
	gboolean _tmp0_ = FALSE;
#line 513 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 516 "ease-editor-embed.vala"
	if (ease_editor_embed_get_selected (self) != NULL) {
#line 516 "ease-editor-embed.vala"
		_tmp0_ = self->priv->_is_editing;
#line 960 "ease-editor-embed.c"
	} else {
#line 516 "ease-editor-embed.vala"
		_tmp0_ = FALSE;
#line 964 "ease-editor-embed.c"
	}
#line 516 "ease-editor-embed.vala"
	if (_tmp0_) {
#line 518 "ease-editor-embed.vala"
		ease_actor_end_edit (ease_editor_embed_get_selected (self), (GtkWidget*) self);
#line 519 "ease-editor-embed.vala"
		ease_editor_embed_set_is_editing (self, FALSE);
#line 520 "ease-editor-embed.vala"
		g_signal_emit_by_name (self, "element-deselected", ease_editor_embed_get_selected (self)->element);
#line 974 "ease-editor-embed.c"
	}
#line 522 "ease-editor-embed.vala"
	ease_editor_embed_connect_keys (self);
#line 525 "ease-editor-embed.vala"
	ease_editor_embed_set_selected (self, NULL);
#line 528 "ease-editor-embed.vala"
	ease_editor_embed_remove_selection_rect (self);
#line 982 "ease-editor-embed.c"
}


#line 542 "ease-editor-embed.vala"
static gboolean ease_editor_embed_actor_released (EaseEditorEmbed* self, ClutterActor* sender, ClutterButtonEvent* event) {
#line 988 "ease-editor-embed.c"
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 542 "ease-editor-embed.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 542 "ease-editor-embed.vala"
	g_return_val_if_fail (sender != NULL, FALSE);
#line 544 "ease-editor-embed.vala"
	if (sender == CLUTTER_ACTOR (ease_editor_embed_get_selected (self))) {
#line 544 "ease-editor-embed.vala"
		_tmp0_ = self->priv->is_dragging;
#line 999 "ease-editor-embed.c"
	} else {
#line 544 "ease-editor-embed.vala"
		_tmp0_ = FALSE;
#line 1003 "ease-editor-embed.c"
	}
#line 544 "ease-editor-embed.vala"
	if (_tmp0_) {
#line 1007 "ease-editor-embed.c"
		guint _tmp1_;
#line 546 "ease-editor-embed.vala"
		self->priv->is_dragging = FALSE;
#line 547 "ease-editor-embed.vala"
		clutter_ungrab_pointer ();
#line 548 "ease-editor-embed.vala"
		g_signal_parse_name ("motion-event", CLUTTER_TYPE_ACTOR, &_tmp1_, NULL, FALSE);
#line 548 "ease-editor-embed.vala"
		g_signal_handlers_disconnect_matched (sender, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _ease_editor_embed_actor_motion_clutter_actor_motion_event, self);
#line 549 "ease-editor-embed.vala"
		g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) self->priv->move_undo);
#line 1019 "ease-editor-embed.c"
	}
	result = TRUE;
#line 551 "ease-editor-embed.vala"
	return result;
#line 1024 "ease-editor-embed.c"
}


#line 564 "ease-editor-embed.vala"
static gboolean ease_editor_embed_actor_motion (EaseEditorEmbed* self, ClutterActor* sender, ClutterMotionEvent* event) {
#line 1030 "ease-editor-embed.c"
	gboolean result = FALSE;
	EaseActor* actor;
	gboolean _tmp0_ = FALSE;
#line 564 "ease-editor-embed.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 564 "ease-editor-embed.vala"
	g_return_val_if_fail (sender != NULL, FALSE);
#line 566 "ease-editor-embed.vala"
	actor = _g_object_ref0 (EASE_ACTOR (sender));
#line 568 "ease-editor-embed.vala"
	if (sender == CLUTTER_ACTOR (ease_editor_embed_get_selected (self))) {
#line 568 "ease-editor-embed.vala"
		_tmp0_ = self->priv->is_dragging;
#line 1044 "ease-editor-embed.c"
	} else {
#line 568 "ease-editor-embed.vala"
		_tmp0_ = FALSE;
#line 1048 "ease-editor-embed.c"
	}
#line 568 "ease-editor-embed.vala"
	if (_tmp0_) {
#line 1052 "ease-editor-embed.c"
		float factor;
#line 570 "ease-editor-embed.vala"
		if (!self->priv->is_drag_initialized) {
#line 572 "ease-editor-embed.vala"
			self->priv->is_drag_initialized = TRUE;
#line 573 "ease-editor-embed.vala"
			self->priv->mouse_x = (*event).x;
#line 574 "ease-editor-embed.vala"
			self->priv->mouse_y = (*event).y;
#line 576 "ease-editor-embed.vala"
			self->priv->orig_x = clutter_actor_get_x ((ClutterActor*) ease_editor_embed_get_selected (self));
#line 577 "ease-editor-embed.vala"
			self->priv->orig_y = clutter_actor_get_y ((ClutterActor*) ease_editor_embed_get_selected (self));
#line 578 "ease-editor-embed.vala"
			self->priv->orig_w = clutter_actor_get_width ((ClutterActor*) ease_editor_embed_get_selected (self));
#line 579 "ease-editor-embed.vala"
			self->priv->orig_h = clutter_actor_get_height ((ClutterActor*) ease_editor_embed_get_selected (self));
#line 1070 "ease-editor-embed.c"
			result = TRUE;
			_g_object_unref0 (actor);
#line 581 "ease-editor-embed.vala"
			return result;
#line 1075 "ease-editor-embed.c"
		}
#line 584 "ease-editor-embed.vala"
		factor = 1 / ease_editor_embed_get_zoom (self);
#line 586 "ease-editor-embed.vala"
		ease_actor_translate (actor, factor * ((*event).x - self->priv->mouse_x), factor * ((*event).y - self->priv->mouse_y));
#line 589 "ease-editor-embed.vala"
		self->priv->mouse_x = (*event).x;
#line 590 "ease-editor-embed.vala"
		self->priv->mouse_y = (*event).y;
#line 592 "ease-editor-embed.vala"
		g_signal_emit_by_name (ease_editor_embed_get_selected (self)->element, "changed");
#line 1087 "ease-editor-embed.c"
	}
	result = TRUE;
	_g_object_unref0 (actor);
#line 594 "ease-editor-embed.vala"
	return result;
#line 1093 "ease-editor-embed.c"
}


#line 659 "ease-editor-embed.vala"
static gboolean _ease_editor_embed_handle_motion_clutter_actor_motion_event (ClutterActor* _sender, ClutterMotionEvent* event, gpointer self) {
#line 1099 "ease-editor-embed.c"
	gboolean result;
	result = ease_editor_embed_handle_motion (self, _sender, event);
	return result;
}


#line 606 "ease-editor-embed.vala"
static gboolean ease_editor_embed_handle_clicked (EaseEditorEmbed* self, ClutterActor* sender, ClutterButtonEvent* event) {
#line 1108 "ease-editor-embed.c"
	gboolean result = FALSE;
	ClutterActor* _tmp0_;
	EaseUndoAction* _tmp1_;
#line 606 "ease-editor-embed.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 606 "ease-editor-embed.vala"
	g_return_val_if_fail (sender != NULL, FALSE);
#line 608 "ease-editor-embed.vala"
	ease_handle_flip ((_tmp0_ = sender, EASE_IS_HANDLE (_tmp0_) ? ((EaseHandle*) _tmp0_) : NULL), TRUE);
#line 609 "ease-editor-embed.vala"
	self->priv->is_dragging = TRUE;
#line 610 "ease-editor-embed.vala"
	self->priv->is_drag_initialized = FALSE;
#line 611 "ease-editor-embed.vala"
	g_signal_connect_object (sender, "motion-event", (GCallback) _ease_editor_embed_handle_motion_clutter_actor_motion_event, self, 0);
#line 612 "ease-editor-embed.vala"
	clutter_grab_pointer (sender);
#line 615 "ease-editor-embed.vala"
	self->priv->move_undo = (_tmp1_ = ease_undo_action_new ((GObject*) ease_editor_embed_get_selected (self)->element, "x"), _g_object_unref0 (self->priv->move_undo), _tmp1_);
#line 616 "ease-editor-embed.vala"
	ease_undo_action_add (self->priv->move_undo, (GObject*) ease_editor_embed_get_selected (self)->element, "y");
#line 617 "ease-editor-embed.vala"
	ease_undo_action_add (self->priv->move_undo, (GObject*) ease_editor_embed_get_selected (self)->element, "width");
#line 618 "ease-editor-embed.vala"
	ease_undo_action_add (self->priv->move_undo, (GObject*) ease_editor_embed_get_selected (self)->element, "height");
#line 1134 "ease-editor-embed.c"
	result = TRUE;
#line 620 "ease-editor-embed.vala"
	return result;
#line 1138 "ease-editor-embed.c"
}


#line 634 "ease-editor-embed.vala"
static gboolean ease_editor_embed_handle_released (EaseEditorEmbed* self, ClutterActor* sender, ClutterButtonEvent* event) {
#line 1144 "ease-editor-embed.c"
	gboolean result = FALSE;
#line 634 "ease-editor-embed.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 634 "ease-editor-embed.vala"
	g_return_val_if_fail (sender != NULL, FALSE);
#line 636 "ease-editor-embed.vala"
	if (self->priv->is_dragging) {
#line 1152 "ease-editor-embed.c"
		ClutterActor* _tmp0_;
		guint _tmp1_;
#line 638 "ease-editor-embed.vala"
		ease_handle_flip ((_tmp0_ = sender, EASE_IS_HANDLE (_tmp0_) ? ((EaseHandle*) _tmp0_) : NULL), FALSE);
#line 639 "ease-editor-embed.vala"
		self->priv->is_dragging = FALSE;
#line 640 "ease-editor-embed.vala"
		g_signal_parse_name ("motion-event", CLUTTER_TYPE_ACTOR, &_tmp1_, NULL, FALSE);
#line 640 "ease-editor-embed.vala"
		g_signal_handlers_disconnect_matched (sender, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _ease_editor_embed_handle_motion_clutter_actor_motion_event, self);
#line 641 "ease-editor-embed.vala"
		g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) self->priv->move_undo);
#line 1165 "ease-editor-embed.c"
	}
#line 644 "ease-editor-embed.vala"
	clutter_ungrab_pointer ();
#line 1169 "ease-editor-embed.c"
	result = TRUE;
#line 645 "ease-editor-embed.vala"
	return result;
#line 1173 "ease-editor-embed.c"
}


#line 659 "ease-editor-embed.vala"
static gboolean ease_editor_embed_handle_motion (EaseEditorEmbed* self, ClutterActor* sender, ClutterMotionEvent* event) {
#line 1179 "ease-editor-embed.c"
	gboolean result = FALSE;
	EaseHandle* handle;
	float factor;
	gboolean p;
	float change_x;
	float change_y;
#line 659 "ease-editor-embed.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 659 "ease-editor-embed.vala"
	g_return_val_if_fail (sender != NULL, FALSE);
#line 661 "ease-editor-embed.vala"
	handle = _g_object_ref0 (EASE_HANDLE (sender));
#line 663 "ease-editor-embed.vala"
	if (!self->priv->is_drag_initialized) {
#line 665 "ease-editor-embed.vala"
		self->priv->is_drag_initialized = TRUE;
#line 666 "ease-editor-embed.vala"
		self->priv->mouse_x = (*event).x;
#line 667 "ease-editor-embed.vala"
		self->priv->mouse_y = (*event).y;
#line 669 "ease-editor-embed.vala"
		self->priv->orig_x = clutter_actor_get_x ((ClutterActor*) ease_editor_embed_get_selected (self));
#line 670 "ease-editor-embed.vala"
		self->priv->orig_y = clutter_actor_get_y ((ClutterActor*) ease_editor_embed_get_selected (self));
#line 671 "ease-editor-embed.vala"
		self->priv->orig_w = clutter_actor_get_width ((ClutterActor*) ease_editor_embed_get_selected (self));
#line 672 "ease-editor-embed.vala"
		self->priv->orig_h = clutter_actor_get_height ((ClutterActor*) ease_editor_embed_get_selected (self));
#line 1208 "ease-editor-embed.c"
		result = TRUE;
		_g_object_unref0 (handle);
#line 674 "ease-editor-embed.vala"
		return result;
#line 1213 "ease-editor-embed.c"
	}
#line 677 "ease-editor-embed.vala"
	factor = 1 / ease_editor_embed_get_zoom (self);
#line 678 "ease-editor-embed.vala"
	p = ((*event).modifier_state & CLUTTER_SHIFT_MASK) != 0;
#line 679 "ease-editor-embed.vala"
	change_x = (*event).x - self->priv->mouse_x;
#line 680 "ease-editor-embed.vala"
	change_y = (*event).y - self->priv->mouse_y;
#line 683 "ease-editor-embed.vala"
	if (((*event).modifier_state & CLUTTER_CONTROL_MASK) != 0) {
#line 685 "ease-editor-embed.vala"
		ease_handle_drag_from_center (handle, factor * change_x, factor * change_y, ease_editor_embed_get_selected (self), p);
#line 1227 "ease-editor-embed.c"
	} else {
#line 692 "ease-editor-embed.vala"
		ease_handle_drag (handle, factor * change_x, factor * change_y, ease_editor_embed_get_selected (self), p);
#line 1231 "ease-editor-embed.c"
	}
#line 695 "ease-editor-embed.vala"
	self->priv->mouse_x = (*event).x;
#line 696 "ease-editor-embed.vala"
	self->priv->mouse_y = (*event).y;
#line 698 "ease-editor-embed.vala"
	g_signal_emit_by_name (ease_editor_embed_get_selected (self)->element, "changed");
#line 1239 "ease-editor-embed.c"
	result = TRUE;
	_g_object_unref0 (handle);
#line 700 "ease-editor-embed.vala"
	return result;
#line 1244 "ease-editor-embed.c"
}


#line 709 "ease-editor-embed.vala"
void ease_editor_embed_set_element_color (EaseEditorEmbed* self, ClutterColor* color) {
#line 709 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 711 "ease-editor-embed.vala"
	if (ease_editor_embed_get_selected (self) == NULL) {
#line 711 "ease-editor-embed.vala"
		return;
#line 1256 "ease-editor-embed.c"
	}
#line 712 "ease-editor-embed.vala"
	if (!ease_element_set_color (ease_editor_embed_get_selected (self)->element, color)) {
#line 712 "ease-editor-embed.vala"
		return;
#line 1262 "ease-editor-embed.c"
	}
}


#line 719 "ease-editor-embed.vala"
void ease_editor_embed_on_ease_actor_removed (EaseEditorEmbed* self, EaseActor* actor) {
#line 1269 "ease-editor-embed.c"
	guint _tmp0_;
	guint _tmp1_;
#line 719 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 719 "ease-editor-embed.vala"
	g_return_if_fail (actor != NULL);
#line 721 "ease-editor-embed.vala"
	if (ease_editor_embed_get_selected (self) == actor) {
#line 721 "ease-editor-embed.vala"
		ease_editor_embed_deselect_actor (self);
#line 1280 "ease-editor-embed.c"
	}
#line 722 "ease-editor-embed.vala"
	g_signal_parse_name ("button-press-event", CLUTTER_TYPE_ACTOR, &_tmp0_, NULL, FALSE);
#line 722 "ease-editor-embed.vala"
	g_signal_handlers_disconnect_matched ((ClutterActor*) actor, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _ease_editor_embed_actor_clicked_clutter_actor_button_press_event, self);
#line 723 "ease-editor-embed.vala"
	g_signal_parse_name ("button-release-event", CLUTTER_TYPE_ACTOR, &_tmp1_, NULL, FALSE);
#line 723 "ease-editor-embed.vala"
	g_signal_handlers_disconnect_matched ((ClutterActor*) actor, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _ease_editor_embed_actor_released_clutter_actor_button_release_event, self);
#line 724 "ease-editor-embed.vala"
	clutter_actor_set_reactive ((ClutterActor*) actor, FALSE);
#line 1292 "ease-editor-embed.c"
}


#line 730 "ease-editor-embed.vala"
void ease_editor_embed_on_ease_actor_added (EaseEditorEmbed* self, EaseActor* actor) {
#line 730 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 730 "ease-editor-embed.vala"
	g_return_if_fail (actor != NULL);
#line 732 "ease-editor-embed.vala"
	g_signal_connect_object ((ClutterActor*) actor, "button-press-event", (GCallback) _ease_editor_embed_actor_clicked_clutter_actor_button_press_event, self, 0);
#line 733 "ease-editor-embed.vala"
	g_signal_connect_object ((ClutterActor*) actor, "button-release-event", (GCallback) _ease_editor_embed_actor_released_clutter_actor_button_release_event, self, 0);
#line 734 "ease-editor-embed.vala"
	clutter_actor_set_reactive ((ClutterActor*) actor, TRUE);
#line 1308 "ease-editor-embed.c"
}


#line 740 "ease-editor-embed.vala"
gboolean ease_editor_embed_on_key_press_event (EaseEditorEmbed* self, GtkWidget* _self_, GdkEventKey* event) {
#line 1314 "ease-editor-embed.c"
	gboolean result = FALSE;
	gboolean shift;
#line 740 "ease-editor-embed.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 740 "ease-editor-embed.vala"
	g_return_val_if_fail (_self_ != NULL, FALSE);
#line 742 "ease-editor-embed.vala"
	if ((*event).type == GDK_KEY_RELEASE) {
#line 1323 "ease-editor-embed.c"
		result = FALSE;
#line 742 "ease-editor-embed.vala"
		return result;
#line 1327 "ease-editor-embed.c"
	}
#line 744 "ease-editor-embed.vala"
	shift = ((*event).state & GDK_SHIFT_MASK) != 0;
#line 746 "ease-editor-embed.vala"
	switch ((*event).keyval) {
#line 1333 "ease-editor-embed.c"
		case EASE_KEY_UP:
		{
			EaseUndoAction* _tmp0_;
			gint _tmp1_ = 0;
#line 749 "ease-editor-embed.vala"
			if (ease_editor_embed_get_selected (self) == NULL) {
#line 749 "ease-editor-embed.vala"
				break;
#line 1342 "ease-editor-embed.c"
			}
#line 750 "ease-editor-embed.vala"
			if (self->priv->_is_editing) {
#line 1346 "ease-editor-embed.c"
				result = TRUE;
#line 750 "ease-editor-embed.vala"
				return result;
#line 1350 "ease-editor-embed.c"
			}
#line 752 "ease-editor-embed.vala"
			g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp0_ = ease_undo_action_new ((GObject*) ease_editor_embed_get_selected (self)->element, "y")));
#line 1354 "ease-editor-embed.c"
			_g_object_unref0 (_tmp0_);
#line 753 "ease-editor-embed.vala"
			if (shift) {
#line 754 "ease-editor-embed.vala"
				_tmp1_ = -EASE_EDITOR_EMBED_NUDGE_SHIFT_PIXELS;
#line 1360 "ease-editor-embed.c"
			} else {
#line 754 "ease-editor-embed.vala"
				_tmp1_ = -EASE_EDITOR_EMBED_NUDGE_PIXELS;
#line 1364 "ease-editor-embed.c"
			}
#line 753 "ease-editor-embed.vala"
			ease_actor_translate (ease_editor_embed_get_selected (self), (float) 0, (float) _tmp1_);
#line 755 "ease-editor-embed.vala"
			g_signal_emit_by_name (ease_editor_embed_get_selected (self)->element, "changed");
#line 1370 "ease-editor-embed.c"
			result = TRUE;
#line 756 "ease-editor-embed.vala"
			return result;
#line 1374 "ease-editor-embed.c"
		}
		case EASE_KEY_DOWN:
		{
			EaseUndoAction* _tmp2_;
			gint _tmp3_ = 0;
#line 759 "ease-editor-embed.vala"
			if (ease_editor_embed_get_selected (self) == NULL) {
#line 759 "ease-editor-embed.vala"
				break;
#line 1384 "ease-editor-embed.c"
			}
#line 760 "ease-editor-embed.vala"
			if (self->priv->_is_editing) {
#line 1388 "ease-editor-embed.c"
				result = TRUE;
#line 760 "ease-editor-embed.vala"
				return result;
#line 1392 "ease-editor-embed.c"
			}
#line 762 "ease-editor-embed.vala"
			g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp2_ = ease_undo_action_new ((GObject*) ease_editor_embed_get_selected (self)->element, "y")));
#line 1396 "ease-editor-embed.c"
			_g_object_unref0 (_tmp2_);
#line 763 "ease-editor-embed.vala"
			if (shift) {
#line 764 "ease-editor-embed.vala"
				_tmp3_ = EASE_EDITOR_EMBED_NUDGE_SHIFT_PIXELS;
#line 1402 "ease-editor-embed.c"
			} else {
#line 764 "ease-editor-embed.vala"
				_tmp3_ = EASE_EDITOR_EMBED_NUDGE_PIXELS;
#line 1406 "ease-editor-embed.c"
			}
#line 763 "ease-editor-embed.vala"
			ease_actor_translate (ease_editor_embed_get_selected (self), (float) 0, (float) _tmp3_);
#line 765 "ease-editor-embed.vala"
			g_signal_emit_by_name (ease_editor_embed_get_selected (self)->element, "changed");
#line 1412 "ease-editor-embed.c"
			result = TRUE;
#line 766 "ease-editor-embed.vala"
			return result;
#line 1416 "ease-editor-embed.c"
		}
		case EASE_KEY_LEFT:
		{
			EaseUndoAction* _tmp4_;
			gint _tmp5_ = 0;
#line 769 "ease-editor-embed.vala"
			if (ease_editor_embed_get_selected (self) == NULL) {
#line 769 "ease-editor-embed.vala"
				break;
#line 1426 "ease-editor-embed.c"
			}
#line 770 "ease-editor-embed.vala"
			if (self->priv->_is_editing) {
#line 1430 "ease-editor-embed.c"
				result = TRUE;
#line 770 "ease-editor-embed.vala"
				return result;
#line 1434 "ease-editor-embed.c"
			}
#line 772 "ease-editor-embed.vala"
			g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp4_ = ease_undo_action_new ((GObject*) ease_editor_embed_get_selected (self)->element, "x")));
#line 1438 "ease-editor-embed.c"
			_g_object_unref0 (_tmp4_);
#line 773 "ease-editor-embed.vala"
			if (shift) {
#line 774 "ease-editor-embed.vala"
				_tmp5_ = -EASE_EDITOR_EMBED_NUDGE_SHIFT_PIXELS;
#line 1444 "ease-editor-embed.c"
			} else {
#line 774 "ease-editor-embed.vala"
				_tmp5_ = -EASE_EDITOR_EMBED_NUDGE_PIXELS;
#line 1448 "ease-editor-embed.c"
			}
#line 773 "ease-editor-embed.vala"
			ease_actor_translate (ease_editor_embed_get_selected (self), (float) _tmp5_, (float) 0);
#line 775 "ease-editor-embed.vala"
			g_signal_emit_by_name (ease_editor_embed_get_selected (self)->element, "changed");
#line 1454 "ease-editor-embed.c"
			result = TRUE;
#line 776 "ease-editor-embed.vala"
			return result;
#line 1458 "ease-editor-embed.c"
		}
		case EASE_KEY_RIGHT:
		{
			EaseUndoAction* _tmp6_;
			gint _tmp7_ = 0;
#line 779 "ease-editor-embed.vala"
			if (ease_editor_embed_get_selected (self) == NULL) {
#line 779 "ease-editor-embed.vala"
				break;
#line 1468 "ease-editor-embed.c"
			}
#line 780 "ease-editor-embed.vala"
			if (self->priv->_is_editing) {
#line 1472 "ease-editor-embed.c"
				result = TRUE;
#line 780 "ease-editor-embed.vala"
				return result;
#line 1476 "ease-editor-embed.c"
			}
#line 782 "ease-editor-embed.vala"
			g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp6_ = ease_undo_action_new ((GObject*) ease_editor_embed_get_selected (self)->element, "x")));
#line 1480 "ease-editor-embed.c"
			_g_object_unref0 (_tmp6_);
#line 783 "ease-editor-embed.vala"
			if (shift) {
#line 784 "ease-editor-embed.vala"
				_tmp7_ = EASE_EDITOR_EMBED_NUDGE_SHIFT_PIXELS;
#line 1486 "ease-editor-embed.c"
			} else {
#line 784 "ease-editor-embed.vala"
				_tmp7_ = EASE_EDITOR_EMBED_NUDGE_PIXELS;
#line 1490 "ease-editor-embed.c"
			}
#line 783 "ease-editor-embed.vala"
			ease_actor_translate (ease_editor_embed_get_selected (self), (float) _tmp7_, (float) 0);
#line 785 "ease-editor-embed.vala"
			g_signal_emit_by_name (ease_editor_embed_get_selected (self)->element, "changed");
#line 1496 "ease-editor-embed.c"
			result = TRUE;
#line 786 "ease-editor-embed.vala"
			return result;
#line 1500 "ease-editor-embed.c"
		}
		case EASE_KEY_BACKSPACE:
		case EASE_KEY_DELETE:
		{
			EaseSlide* slide;
			gint i;
#line 790 "ease-editor-embed.vala"
			if (ease_editor_embed_get_selected (self) == NULL) {
#line 790 "ease-editor-embed.vala"
				break;
#line 1511 "ease-editor-embed.c"
			}
#line 792 "ease-editor-embed.vala"
			slide = _g_object_ref0 (ease_slide_actor_get_slide (self->slide_actor));
#line 793 "ease-editor-embed.vala"
			i = ease_slide_index_of (slide, ease_editor_embed_get_selected (self)->element);
#line 794 "ease-editor-embed.vala"
			ease_slide_remove_at (slide, i);
#line 795 "ease-editor-embed.vala"
			g_signal_emit_by_name (self, "element-deselected", NULL);
#line 1521 "ease-editor-embed.c"
			result = TRUE;
			_g_object_unref0 (slide);
#line 797 "ease-editor-embed.vala"
			return result;
#line 1526 "ease-editor-embed.c"
		}
	}
	result = FALSE;
#line 800 "ease-editor-embed.vala"
	return result;
#line 1532 "ease-editor-embed.c"
}


#line 806 "ease-editor-embed.vala"
void ease_editor_embed_on_element_removed (EaseEditorEmbed* self, EaseSlide* slide, EaseElement* element, gint index) {
#line 806 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 806 "ease-editor-embed.vala"
	g_return_if_fail (slide != NULL);
#line 806 "ease-editor-embed.vala"
	g_return_if_fail (element != NULL);
#line 808 "ease-editor-embed.vala"
	if (slide != ease_slide_actor_get_slide (self->slide_actor)) {
#line 808 "ease-editor-embed.vala"
		return;
#line 1548 "ease-editor-embed.c"
	}
#line 809 "ease-editor-embed.vala"
	if (ease_editor_embed_get_selected (self) == NULL) {
#line 809 "ease-editor-embed.vala"
		g_signal_emit_by_name (self, "element-deselected", element);
#line 1554 "ease-editor-embed.c"
	}
}


#line 740 "ease-editor-embed.vala"
static gboolean _ease_editor_embed_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
#line 1561 "ease-editor-embed.c"
	gboolean result;
	result = ease_editor_embed_on_key_press_event (self, _sender, event);
	return result;
}


#line 815 "ease-editor-embed.vala"
void ease_editor_embed_connect_keys (EaseEditorEmbed* self) {
#line 815 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 817 "ease-editor-embed.vala"
	if (self->priv->keys_connected) {
#line 817 "ease-editor-embed.vala"
		return;
#line 1576 "ease-editor-embed.c"
	}
#line 818 "ease-editor-embed.vala"
	self->priv->keys_connected = TRUE;
#line 819 "ease-editor-embed.vala"
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) _ease_editor_embed_on_key_press_event_gtk_widget_key_press_event, self, 0);
#line 1582 "ease-editor-embed.c"
}


#line 825 "ease-editor-embed.vala"
void ease_editor_embed_disconnect_keys (EaseEditorEmbed* self) {
#line 1588 "ease-editor-embed.c"
	guint _tmp0_;
#line 825 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 827 "ease-editor-embed.vala"
	if (!self->priv->keys_connected) {
#line 827 "ease-editor-embed.vala"
		return;
#line 1596 "ease-editor-embed.c"
	}
#line 828 "ease-editor-embed.vala"
	self->priv->keys_connected = FALSE;
#line 829 "ease-editor-embed.vala"
	g_signal_parse_name ("key-press-event", GTK_TYPE_WIDGET, &_tmp0_, NULL, FALSE);
#line 829 "ease-editor-embed.vala"
	g_signal_handlers_disconnect_matched ((GtkWidget*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _ease_editor_embed_on_key_press_event_gtk_widget_key_press_event, self);
#line 1604 "ease-editor-embed.c"
}


#line 835 "ease-editor-embed.vala"
void ease_editor_embed_on_selected_changed (EaseEditorEmbed* self, EaseSlide* sender) {
#line 835 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 835 "ease-editor-embed.vala"
	g_return_if_fail (sender != NULL);
#line 837 "ease-editor-embed.vala"
	if (self->priv->selection_rectangle == NULL) {
#line 837 "ease-editor-embed.vala"
		return;
#line 1618 "ease-editor-embed.c"
	}
#line 838 "ease-editor-embed.vala"
	ease_editor_embed_position_selection (self);
#line 1622 "ease-editor-embed.c"
}


EaseActor* ease_editor_embed_get_selected (EaseEditorEmbed* self) {
	EaseActor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->selected_priv;
#line 57 "ease-editor-embed.vala"
	return result;
#line 1632 "ease-editor-embed.c"
}


#line 835 "ease-editor-embed.vala"
static void _ease_editor_embed_on_selected_changed_ease_slide_changed (EaseSlide* _sender, EaseSlide* _self_, gpointer self) {
#line 1638 "ease-editor-embed.c"
	ease_editor_embed_on_selected_changed (self, _self_);
}


static void ease_editor_embed_set_selected (EaseEditorEmbed* self, EaseActor* value) {
	EaseActor* _tmp1_;
	g_return_if_fail (self != NULL);
#line 60 "ease-editor-embed.vala"
	if (self->priv->selected_priv != NULL) {
#line 1648 "ease-editor-embed.c"
		guint _tmp0_;
#line 62 "ease-editor-embed.vala"
		g_signal_parse_name ("changed", EASE_TYPE_SLIDE, &_tmp0_, NULL, FALSE);
#line 62 "ease-editor-embed.vala"
		g_signal_handlers_disconnect_matched (ease_slide_actor_get_slide (self->slide_actor), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _ease_editor_embed_on_selected_changed_ease_slide_changed, self);
#line 1654 "ease-editor-embed.c"
	}
#line 64 "ease-editor-embed.vala"
	self->priv->selected_priv = (_tmp1_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->selected_priv), _tmp1_);
#line 65 "ease-editor-embed.vala"
	if (value != NULL) {
#line 67 "ease-editor-embed.vala"
		g_signal_connect_object (ease_slide_actor_get_slide (self->slide_actor), "changed", (GCallback) _ease_editor_embed_on_selected_changed_ease_slide_changed, self, 0);
#line 1662 "ease-editor-embed.c"
	}
	g_object_notify ((GObject *) self, "selected");
}


static gboolean ease_editor_embed_get_is_editing (EaseEditorEmbed* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_editing;
#line 76 "ease-editor-embed.vala"
	return result;
#line 1674 "ease-editor-embed.c"
}


static void ease_editor_embed_set_is_editing (EaseEditorEmbed* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_editing = value;
}


float ease_editor_embed_get_zoom (EaseEditorEmbed* self) {
	float result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->zoom_priv;
#line 177 "ease-editor-embed.vala"
	return result;
#line 1690 "ease-editor-embed.c"
}


void ease_editor_embed_set_zoom (EaseEditorEmbed* self, float value) {
	g_return_if_fail (self != NULL);
#line 181 "ease-editor-embed.vala"
	self->priv->zoom_priv = value;
#line 182 "ease-editor-embed.vala"
	ease_editor_embed_reposition_group (self);
#line 1700 "ease-editor-embed.c"
	g_object_notify ((GObject *) self, "zoom");
}


gboolean ease_editor_embed_get_zoom_fit (EaseEditorEmbed* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_zoom_fit;
#line 194 "ease-editor-embed.vala"
	return result;
#line 1711 "ease-editor-embed.c"
}


void ease_editor_embed_set_zoom_fit (EaseEditorEmbed* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_zoom_fit = value;
	g_object_notify ((GObject *) self, "zoom-fit");
}


static void ease_editor_embed_class_init (EaseEditorEmbedClass * klass) {
	ease_editor_embed_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseEditorEmbedPrivate));
	G_OBJECT_CLASS (klass)->get_property = ease_editor_embed_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_editor_embed_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_editor_embed_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_EDITOR_EMBED_SELECTED, g_param_spec_object ("selected", "selected", "selected", EASE_TYPE_ACTOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_EDITOR_EMBED_ZOOM, g_param_spec_float ("zoom", "zoom", "zoom", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_EDITOR_EMBED_ZOOM_FIT, g_param_spec_boolean ("zoom-fit", "zoom-fit", "zoom-fit", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("element_selected", EASE_TYPE_EDITOR_EMBED, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_ELEMENT);
	g_signal_new ("element_deselected", EASE_TYPE_EDITOR_EMBED, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_ELEMENT);
}


static void ease_editor_embed_ease_undo_source_interface_init (EaseUndoSourceIface * iface) {
	ease_editor_embed_ease_undo_source_parent_iface = g_type_interface_peek_parent (iface);
}


static void ease_editor_embed_instance_init (EaseEditorEmbed * self) {
	self->priv = EASE_EDITOR_EMBED_GET_PRIVATE (self);
	self->priv->keys_connected = FALSE;
}


static void ease_editor_embed_finalize (GObject* obj) {
	EaseEditorEmbed * self;
	self = EASE_EDITOR_EMBED (obj);
	_g_object_unref0 (self->priv->win);
	_g_object_unref0 (self->priv->selection_rectangle);
	self->priv->handles = (_vala_array_free (self->priv->handles, self->priv->handles_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->slide_actor);
	_g_object_unref0 (self->priv->selected_priv);
	_g_object_unref0 (self->priv->move_undo);
	_g_object_unref0 (self->priv->document);
	G_OBJECT_CLASS (ease_editor_embed_parent_class)->finalize (obj);
}


GType ease_editor_embed_get_type (void) {
	static volatile gsize ease_editor_embed_type_id__volatile = 0;
	if (g_once_init_enter (&ease_editor_embed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseEditorEmbedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_editor_embed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseEditorEmbed), 0, (GInstanceInitFunc) ease_editor_embed_instance_init, NULL };
		static const GInterfaceInfo ease_undo_source_info = { (GInterfaceInitFunc) ease_editor_embed_ease_undo_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType ease_editor_embed_type_id;
		ease_editor_embed_type_id = g_type_register_static (EASE_TYPE_SCROLLABLE_EMBED, "EaseEditorEmbed", &g_define_type_info, 0);
		g_type_add_interface_static (ease_editor_embed_type_id, EASE_TYPE_UNDO_SOURCE, &ease_undo_source_info);
		g_once_init_leave (&ease_editor_embed_type_id__volatile, ease_editor_embed_type_id);
	}
	return ease_editor_embed_type_id__volatile;
}


static void ease_editor_embed_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseEditorEmbed * self;
	self = EASE_EDITOR_EMBED (object);
	switch (property_id) {
		case EASE_EDITOR_EMBED_SELECTED:
		g_value_set_object (value, ease_editor_embed_get_selected (self));
		break;
		case EASE_EDITOR_EMBED_ZOOM:
		g_value_set_float (value, ease_editor_embed_get_zoom (self));
		break;
		case EASE_EDITOR_EMBED_ZOOM_FIT:
		g_value_set_boolean (value, ease_editor_embed_get_zoom_fit (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_editor_embed_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseEditorEmbed * self;
	self = EASE_EDITOR_EMBED (object);
	switch (property_id) {
		case EASE_EDITOR_EMBED_SELECTED:
		ease_editor_embed_set_selected (self, g_value_get_object (value));
		break;
		case EASE_EDITOR_EMBED_ZOOM:
		ease_editor_embed_set_zoom (self, g_value_get_float (value));
		break;
		case EASE_EDITOR_EMBED_ZOOM_FIT:
		ease_editor_embed_set_zoom_fit (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




