/* ease-slide-actor.c generated by valac, the Vala compiler
 * generated from ease-slide-actor.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <flutter.h>
#include <ease-core.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <cogl/cogl.h>
#include <stdlib.h>
#include <string.h>


#define EASE_TYPE_SLIDE_ACTOR (ease_slide_actor_get_type ())
#define EASE_SLIDE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE_ACTOR, EaseSlideActor))
#define EASE_SLIDE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE_ACTOR, EaseSlideActorClass))
#define EASE_IS_SLIDE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE_ACTOR))
#define EASE_IS_SLIDE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE_ACTOR))
#define EASE_SLIDE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE_ACTOR, EaseSlideActorClass))

typedef struct _EaseSlideActor EaseSlideActor;
typedef struct _EaseSlideActorClass EaseSlideActorClass;
typedef struct _EaseSlideActorPrivate EaseSlideActorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _ease_slide_iterator_unref0(var) ((var == NULL) ? NULL : (var = (ease_slide_iterator_unref (var), NULL)))
#define _flutter_container_iterator_unref0(var) ((var == NULL) ? NULL : (var = (flutter_container_iterator_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;

struct _EaseSlideActor {
	ClutterGroup parent_instance;
	EaseSlideActorPrivate * priv;
	ClutterCairoTexture* background;
	FlutterGroup* contents;
	EaseActorContext context;
};

struct _EaseSlideActorClass {
	ClutterGroupClass parent_class;
};

struct _EaseSlideActorPrivate {
	EaseSlide* _slide;
	float width_px;
	float height_px;
	ClutterTimeline* _animation_time;
	ClutterAlpha* _animation_alpha;
	ClutterTimeline* time1;
	ClutterTimeline* time2;
	ClutterAlpha* alpha1;
	ClutterAlpha* alpha2;
};

struct _Block2Data {
	int _ref_count_;
	EaseSlideActor * self;
	float xpos;
	float ypos;
	float angle;
	EaseSlideActor* new_slide;
};

struct _Block3Data {
	int _ref_count_;
	EaseSlideActor * self;
	ClutterRotateAxis axis;
	float positive;
	float x_point;
	float y_point;
	EaseSlideActor* new_slide;
};

struct _Block4Data {
	int _ref_count_;
	EaseSlideActor * self;
	ClutterRotateAxis axis;
	float positive;
	float x_point;
	float y_point;
	EaseSlideActor* new_slide;
};

struct _Block5Data {
	int _ref_count_;
	EaseSlideActor * self;
	ClutterGroup** groups;
	gint groups_length1;
	gint _groups_size_;
	float width;
	EaseSlideActor* new_slide;
	ClutterGroup* container;
};

struct _Block6Data {
	int _ref_count_;
	EaseSlideActor * self;
	float width;
	ClutterGroup* left_group;
	ClutterGroup* right_group;
	ClutterGroup* container;
};

struct _Block7Data {
	int _ref_count_;
	EaseSlideActor * self;
	EaseSlideActor* new_slide;
};

struct _Block8Data {
	int _ref_count_;
	EaseSlideActor * self;
	float pos;
	char* property;
	EaseSlideActor* new_slide;
	guint length;
};

struct _Block9Data {
	int _ref_count_;
	EaseSlideActor * self;
	float angle;
	EaseSlideActor* new_slide;
};

struct _Block10Data {
	int _ref_count_;
	EaseSlideActor * self;
	EaseSlideActor* new_slide;
};

struct _Block11Data {
	int _ref_count_;
	EaseSlideActor * self;
	EaseSlideActor* new_slide;
};

struct _Block12Data {
	int _ref_count_;
	EaseSlideActor * self;
	gint count;
	ClutterClone** particles;
	gint particles_length1;
	gint _particles_size_;
	ClutterGroup* container;
};

struct _Block13Data {
	int _ref_count_;
	EaseSlideActor * self;
	gint count;
	ClutterClone** particles;
	gint particles_length1;
	gint _particles_size_;
	EaseSlideActor* new_slide;
	ClutterGroup* container;
};


static gpointer ease_slide_actor_parent_class = NULL;

GType ease_slide_actor_get_type (void) G_GNUC_CONST;
#define EASE_SLIDE_ACTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_SLIDE_ACTOR, EaseSlideActorPrivate))
enum  {
	EASE_SLIDE_ACTOR_DUMMY_PROPERTY,
	EASE_SLIDE_ACTOR_SLIDE,
	EASE_SLIDE_ACTOR_ANIMATION_TIME
};
#define EASE_SLIDE_ACTOR_EASE_SLIDE ((gint) CLUTTER_EASE_IN_OUT_SINE)
#define EASE_SLIDE_ACTOR_EASE_DROP ((gint) CLUTTER_EASE_OUT_BOUNCE)
#define EASE_SLIDE_ACTOR_EASE_PIVOT ((gint) CLUTTER_EASE_OUT_SINE)
#define EASE_SLIDE_ACTOR_FLIP_DEPTH ((float) (-400))
#define EASE_SLIDE_ACTOR_PANEL_SCALE 0.75f
#define EASE_SLIDE_ACTOR_OPEN_DEPTH ((float) (-3000))
#define EASE_SLIDE_ACTOR_OPEN_MOVE 0.15f
#define EASE_SLIDE_ACTOR_OPEN_TIME 0.8f
#define EASE_SLIDE_ACTOR_SLAT_COUNT 8
#define EASE_SLIDE_ACTOR_REFLECTION_OPACITY 70
#define EASE_SLIDE_ACTOR_EXPLODE_PARTICLES 10
#define EASE_SLIDE_ACTOR_ASSEMBLE_TILES 12
EaseSlideActor* ease_slide_actor_new_with_dimensions (float w, float h, EaseSlide* s, gboolean clip, EaseActorContext ctx);
EaseSlideActor* ease_slide_actor_construct_with_dimensions (GType object_type, float w, float h, EaseSlide* s, gboolean clip, EaseActorContext ctx);
EaseSlideActor* ease_slide_actor_new_from_slide (EaseDocument* document, EaseSlide* s, gboolean clip, EaseActorContext ctx);
EaseSlideActor* ease_slide_actor_construct_from_slide (GType object_type, EaseDocument* document, EaseSlide* s, gboolean clip, EaseActorContext ctx);
void ease_slide_actor_set_slide (EaseSlideActor* self, EaseSlide* value);
static void ease_slide_actor_set_background (EaseSlideActor* self);
EaseSlide* ease_slide_actor_get_slide (EaseSlideActor* self);
static void _lambda7_ (EaseSlide* s, EaseSlideActor* self);
static void __lambda7__ease_slide_background_changed (EaseSlide* _sender, EaseSlide* _self_, gpointer self);
void ease_slide_actor_on_element_added (EaseSlideActor* self, EaseSlide* slide, EaseElement* element, gint index);
static void _ease_slide_actor_on_element_added_ease_slide_element_added (EaseSlide* _sender, EaseSlide* _self_, EaseElement* element, gint index, gpointer self);
void ease_slide_actor_on_element_removed (EaseSlideActor* self, EaseSlide* slide, EaseElement* element, gint index);
static void _ease_slide_actor_on_element_removed_ease_slide_element_removed (EaseSlide* _sender, EaseSlide* _self_, EaseElement* element, gint index, gpointer self);
static void ease_slide_actor_reorder (EaseSlideActor* self);
static void _lambda8_ (EaseSlide* s, EaseElement* e, EaseSlideActor* self);
static void __lambda8__ease_slide_element_reordered (EaseSlide* _sender, EaseSlide* _self_, EaseElement* element, gpointer self);
EaseSlideActor* ease_slide_actor_new_blank (EaseDocument* document, ClutterColor* color);
EaseSlideActor* ease_slide_actor_construct_blank (GType object_type, EaseDocument* document, ClutterColor* color);
static void ease_slide_actor_reset_actor (EaseSlideActor* self, ClutterActor* actor);
void ease_slide_actor_stack (EaseSlideActor* self, ClutterActor* container);
void ease_slide_actor_reset (EaseSlideActor* self, ClutterGroup* container);
void ease_slide_actor_relayout (EaseSlideActor* self);
void ease_slide_actor_unstack (EaseSlideActor* self, EaseSlideActor* other, ClutterActor* container);
static void ease_slide_actor_prepare_slide_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container);
static void ease_slide_actor_prepare_stack_transition (EaseSlideActor* self, gboolean current_on_top, EaseSlideActor* new_slide, ClutterGroup* container);
void ease_slide_actor_set_animation_time (EaseSlideActor* self, ClutterTimeline* value);
static void ease_slide_actor_slide_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_drop_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_pivot_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_open_door_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_reveal_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_slats_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_flip_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_revolving_door_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_fall_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_spin_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_swing_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_zoom_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_slide_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_spring_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_zoom_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_panel_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_explode_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_assemble_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_fade_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
ClutterTimeline* ease_slide_actor_get_animation_time (EaseSlideActor* self);
void ease_slide_actor_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container);
static void ease_slide_actor_set_animation_alpha (EaseSlideActor* self, ClutterAlpha* value);
static ClutterAlpha* ease_slide_actor_get_animation_alpha (EaseSlideActor* self);
static void _lambda9_ (gint m, Block2Data* _data2_);
static void __lambda9__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void _lambda14_ (gint m, Block3Data* _data3_);
static void __lambda14__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static void _lambda15_ (gint m, Block3Data* _data3_);
static void __lambda15__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static void _lambda16_ (Block3Data* _data3_);
static void __lambda16__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void _lambda17_ (gint m, Block4Data* _data4_);
static void __lambda17__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static void _lambda18_ (gint m, EaseSlideActor* self);
static void __lambda18__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static void _lambda12_ (gint m, Block5Data* _data5_);
static void __lambda12__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static void _lambda13_ (Block5Data* _data5_);
static void __lambda13__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static void _lambda10_ (gint m, Block6Data* _data6_);
static void __lambda10__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static void _lambda11_ (Block6Data* _data6_);
static void __lambda11__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
static void _lambda23_ (gint m, Block7Data* _data7_);
static void __lambda23__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
static void _lambda26_ (gint m, EaseSlideActor* self);
static void __lambda26__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static void _lambda27_ (Block8Data* _data8_);
static void __lambda27__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static void _lambda29_ (gint m, Block8Data* _data8_);
static void __lambda29__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static void _lambda28_ (Block8Data* _data8_);
static void __lambda28__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
static void _lambda19_ (EaseSlideActor* self);
static void __lambda19__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static void _lambda20_ (gint m, Block9Data* _data9_);
static void __lambda20__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static void _lambda21_ (gint m, Block9Data* _data9_);
static void __lambda21__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (Block9Data* _data9_);
static guint8 ease_slide_actor_clamp_opacity (double o);
static void _lambda22_ (gint m, Block10Data* _data10_);
static void __lambda22__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (Block10Data* _data10_);
static void _lambda24_ (gint m, Block11Data* _data11_);
static void __lambda24__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static void _lambda25_ (gint m, Block11Data* _data11_);
static void __lambda25__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
static guint ease_slide_actor_explode_time (EaseSlideActor* self, guint time);
static float ease_slide_actor_explode_dist (EaseSlideActor* self);
static float ease_slide_actor_explode_depth (EaseSlideActor* self);
static void _lambda30_ (Block12Data* _data12_);
static void __lambda30__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (Block12Data* _data12_);
static float ease_slide_actor_assemble_extra (EaseSlideActor* self);
static void _lambda31_ (Block13Data* _data13_);
static void __lambda31__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (Block13Data* _data13_);
EaseSlideActor* ease_slide_actor_new (void);
EaseSlideActor* ease_slide_actor_construct (GType object_type);
static void ease_slide_actor_finalize (GObject* obj);
static void ease_slide_actor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_slide_actor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



#line 153 "ease-slide-actor.vala"
EaseSlideActor* ease_slide_actor_construct_from_slide (GType object_type, EaseDocument* document, EaseSlide* s, gboolean clip, EaseActorContext ctx) {
#line 350 "ease-slide-actor.c"
	EaseSlideActor * self;
#line 153 "ease-slide-actor.vala"
	g_return_val_if_fail (document != NULL, NULL);
#line 153 "ease-slide-actor.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 156 "ease-slide-actor.vala"
	self = (EaseSlideActor*) ease_slide_actor_construct_with_dimensions (object_type, (float) ease_document_get_width (document), (float) ease_document_get_height (document), s, clip, ctx);
#line 358 "ease-slide-actor.c"
	return self;
}


#line 153 "ease-slide-actor.vala"
EaseSlideActor* ease_slide_actor_new_from_slide (EaseDocument* document, EaseSlide* s, gboolean clip, EaseActorContext ctx) {
#line 153 "ease-slide-actor.vala"
	return ease_slide_actor_construct_from_slide (EASE_TYPE_SLIDE_ACTOR, document, s, clip, ctx);
#line 367 "ease-slide-actor.c"
}


#line 196 "ease-slide-actor.vala"
static void _lambda7_ (EaseSlide* s, EaseSlideActor* self) {
#line 196 "ease-slide-actor.vala"
	g_return_if_fail (s != NULL);
#line 196 "ease-slide-actor.vala"
	ease_slide_actor_set_background (self);
#line 377 "ease-slide-actor.c"
}


#line 196 "ease-slide-actor.vala"
static void __lambda7__ease_slide_background_changed (EaseSlide* _sender, EaseSlide* _self_, gpointer self) {
#line 383 "ease-slide-actor.c"
	_lambda7_ (_self_, self);
}


#line 228 "ease-slide-actor.vala"
static void _ease_slide_actor_on_element_added_ease_slide_element_added (EaseSlide* _sender, EaseSlide* _self_, EaseElement* element, gint index, gpointer self) {
#line 390 "ease-slide-actor.c"
	ease_slide_actor_on_element_added (self, _self_, element, index);
}


#line 243 "ease-slide-actor.vala"
static void _ease_slide_actor_on_element_removed_ease_slide_element_removed (EaseSlide* _sender, EaseSlide* _self_, EaseElement* element, gint index, gpointer self) {
#line 397 "ease-slide-actor.c"
	ease_slide_actor_on_element_removed (self, _self_, element, index);
}


#line 201 "ease-slide-actor.vala"
static void _lambda8_ (EaseSlide* s, EaseElement* e, EaseSlideActor* self) {
#line 201 "ease-slide-actor.vala"
	g_return_if_fail (s != NULL);
#line 201 "ease-slide-actor.vala"
	g_return_if_fail (e != NULL);
#line 201 "ease-slide-actor.vala"
	ease_slide_actor_reorder (self);
#line 410 "ease-slide-actor.c"
}


#line 201 "ease-slide-actor.vala"
static void __lambda8__ease_slide_element_reordered (EaseSlide* _sender, EaseSlide* _self_, EaseElement* element, gpointer self) {
#line 416 "ease-slide-actor.c"
	_lambda8_ (_self_, element, self);
}


#line 169 "ease-slide-actor.vala"
EaseSlideActor* ease_slide_actor_construct_with_dimensions (GType object_type, float w, float h, EaseSlide* s, gboolean clip, EaseActorContext ctx) {
#line 423 "ease-slide-actor.c"
	EaseSlideActor * self;
	FlutterGroup* _tmp0_;
#line 169 "ease-slide-actor.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 428 "ease-slide-actor.c"
	self = g_object_newv (object_type, 0, NULL);
#line 172 "ease-slide-actor.vala"
	ease_slide_actor_set_slide (self, s);
#line 173 "ease-slide-actor.vala"
	self->context = ctx;
#line 174 "ease-slide-actor.vala"
	self->priv->width_px = w;
#line 175 "ease-slide-actor.vala"
	self->priv->height_px = h;
#line 178 "ease-slide-actor.vala"
	if (clip) {
#line 180 "ease-slide-actor.vala"
		clutter_actor_set_clip ((ClutterActor*) self, (float) 0, (float) 0, w, h);
#line 442 "ease-slide-actor.c"
	}
#line 184 "ease-slide-actor.vala"
	ease_slide_actor_set_background (self);
#line 185 "ease-slide-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) self->background);
#line 187 "ease-slide-actor.vala"
	self->contents = (_tmp0_ = g_object_ref_sink (flutter_group_new ()), _g_object_unref0 (self->contents), _tmp0_);
#line 450 "ease-slide-actor.c"
	{
		EaseSlideIterator* _e_it;
#line 189 "ease-slide-actor.vala"
		_e_it = ease_slide_iterator (self->priv->_slide);
#line 189 "ease-slide-actor.vala"
		while (TRUE) {
#line 457 "ease-slide-actor.c"
			EaseElement* e;
			EaseActor* _tmp1_;
#line 189 "ease-slide-actor.vala"
			if (!ease_slide_iterator_next (_e_it)) {
#line 189 "ease-slide-actor.vala"
				break;
#line 464 "ease-slide-actor.c"
			}
#line 189 "ease-slide-actor.vala"
			e = ease_slide_iterator_get (_e_it);
#line 191 "ease-slide-actor.vala"
			clutter_container_add_actor ((ClutterContainer*) self->contents, (ClutterActor*) (_tmp1_ = ease_element_actor (e, self->context)));
#line 470 "ease-slide-actor.c"
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (e);
		}
		_ease_slide_iterator_unref0 (_e_it);
	}
#line 194 "ease-slide-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) self->contents);
#line 196 "ease-slide-actor.vala"
	g_signal_connect_object (self->priv->_slide, "background-changed", (GCallback) __lambda7__ease_slide_background_changed, self, 0);
#line 198 "ease-slide-actor.vala"
	g_signal_connect_object (self->priv->_slide, "element-added", (GCallback) _ease_slide_actor_on_element_added_ease_slide_element_added, self, 0);
#line 199 "ease-slide-actor.vala"
	g_signal_connect_object (self->priv->_slide, "element-removed", (GCallback) _ease_slide_actor_on_element_removed_ease_slide_element_removed, self, 0);
#line 201 "ease-slide-actor.vala"
	g_signal_connect_object (self->priv->_slide, "element-reordered", (GCallback) __lambda8__ease_slide_element_reordered, self, 0);
#line 486 "ease-slide-actor.c"
	return self;
}


#line 169 "ease-slide-actor.vala"
EaseSlideActor* ease_slide_actor_new_with_dimensions (float w, float h, EaseSlide* s, gboolean clip, EaseActorContext ctx) {
#line 169 "ease-slide-actor.vala"
	return ease_slide_actor_construct_with_dimensions (EASE_TYPE_SLIDE_ACTOR, w, h, s, clip, ctx);
#line 495 "ease-slide-actor.c"
}


#line 212 "ease-slide-actor.vala"
EaseSlideActor* ease_slide_actor_construct_blank (GType object_type, EaseDocument* document, ClutterColor* color) {
#line 501 "ease-slide-actor.c"
	EaseSlideActor * self;
	ClutterCairoTexture* _tmp0_;
	FlutterGroup* _tmp1_;
#line 212 "ease-slide-actor.vala"
	g_return_val_if_fail (document != NULL, NULL);
#line 507 "ease-slide-actor.c"
	self = g_object_newv (object_type, 0, NULL);
#line 215 "ease-slide-actor.vala"
	self->background = (_tmp0_ = g_object_ref_sink ((ClutterCairoTexture*) clutter_cairo_texture_new ((guint) ease_document_get_width (document), (guint) ease_document_get_height (document))), _g_object_unref0 (self->background), _tmp0_);
#line 218 "ease-slide-actor.vala"
	self->contents = (_tmp1_ = g_object_ref_sink (flutter_group_new ()), _g_object_unref0 (self->contents), _tmp1_);
#line 221 "ease-slide-actor.vala"
	clutter_actor_set_width ((ClutterActor*) self->background, self->priv->width_px);
#line 222 "ease-slide-actor.vala"
	clutter_actor_set_height ((ClutterActor*) self->background, self->priv->height_px);
#line 517 "ease-slide-actor.c"
	return self;
}


#line 212 "ease-slide-actor.vala"
EaseSlideActor* ease_slide_actor_new_blank (EaseDocument* document, ClutterColor* color) {
#line 212 "ease-slide-actor.vala"
	return ease_slide_actor_construct_blank (EASE_TYPE_SLIDE_ACTOR, document, color);
#line 526 "ease-slide-actor.c"
}


#line 228 "ease-slide-actor.vala"
void ease_slide_actor_on_element_added (EaseSlideActor* self, EaseSlide* slide, EaseElement* element, gint index) {
#line 532 "ease-slide-actor.c"
	EaseActor* actor;
	EaseActor* _tmp0_;
#line 228 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 228 "ease-slide-actor.vala"
	g_return_if_fail (slide != NULL);
#line 228 "ease-slide-actor.vala"
	g_return_if_fail (element != NULL);
#line 230 "ease-slide-actor.vala"
	actor = ease_element_actor (element, self->context);
#line 231 "ease-slide-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) self->contents, (ClutterActor*) actor);
#line 232 "ease-slide-actor.vala"
	clutter_container_lower_child ((ClutterContainer*) self->contents, (ClutterActor*) actor, NULL);
#line 235 "ease-slide-actor.vala"
	ease_slide_actor_reorder (self);
#line 237 "ease-slide-actor.vala"
	g_signal_emit_by_name (self, "ease-actor-added", (_tmp0_ = actor, EASE_IS_ACTOR (_tmp0_) ? ((EaseActor*) _tmp0_) : NULL));
#line 551 "ease-slide-actor.c"
	_g_object_unref0 (actor);
}


#line 243 "ease-slide-actor.vala"
void ease_slide_actor_on_element_removed (EaseSlideActor* self, EaseSlide* slide, EaseElement* element, gint index) {
#line 243 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 243 "ease-slide-actor.vala"
	g_return_if_fail (slide != NULL);
#line 243 "ease-slide-actor.vala"
	g_return_if_fail (element != NULL);
#line 564 "ease-slide-actor.c"
	{
		FlutterContainerIterator* _a_it;
#line 245 "ease-slide-actor.vala"
		_a_it = flutter_container_iterator ((FlutterContainer*) self->contents);
#line 245 "ease-slide-actor.vala"
		while (TRUE) {
#line 571 "ease-slide-actor.c"
			ClutterActor* a;
			ClutterActor* _tmp0_;
#line 245 "ease-slide-actor.vala"
			if (!flutter_container_iterator_next (_a_it)) {
#line 245 "ease-slide-actor.vala"
				break;
#line 578 "ease-slide-actor.c"
			}
#line 245 "ease-slide-actor.vala"
			a = flutter_container_iterator_get (_a_it);
#line 247 "ease-slide-actor.vala"
			if ((_tmp0_ = a, EASE_IS_ACTOR (_tmp0_) ? ((EaseActor*) _tmp0_) : NULL)->element == element) {
#line 584 "ease-slide-actor.c"
				ClutterActor* _tmp1_;
#line 249 "ease-slide-actor.vala"
				clutter_container_remove_actor ((ClutterContainer*) self->contents, a);
#line 250 "ease-slide-actor.vala"
				g_signal_emit_by_name (self, "ease-actor-removed", (_tmp1_ = a, EASE_IS_ACTOR (_tmp1_) ? ((EaseActor*) _tmp1_) : NULL));
#line 590 "ease-slide-actor.c"
				_g_object_unref0 (a);
#line 251 "ease-slide-actor.vala"
				break;
#line 594 "ease-slide-actor.c"
			}
			_g_object_unref0 (a);
		}
		_flutter_container_iterator_unref0 (_a_it);
	}
}


#line 259 "ease-slide-actor.vala"
void ease_slide_actor_reset (EaseSlideActor* self, ClutterGroup* container) {
#line 259 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 259 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 261 "ease-slide-actor.vala"
	ease_slide_actor_reset_actor (self, (ClutterActor*) self);
#line 262 "ease-slide-actor.vala"
	ease_slide_actor_reset_actor (self, (ClutterActor*) self->background);
#line 263 "ease-slide-actor.vala"
	ease_slide_actor_reset_actor (self, (ClutterActor*) self->contents);
#line 264 "ease-slide-actor.vala"
	ease_slide_actor_stack (self, (ClutterActor*) container);
#line 617 "ease-slide-actor.c"
}


#line 272 "ease-slide-actor.vala"
static void ease_slide_actor_reset_actor (EaseSlideActor* self, ClutterActor* actor) {
#line 272 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 272 "ease-slide-actor.vala"
	g_return_if_fail (actor != NULL);
#line 274 "ease-slide-actor.vala"
	clutter_actor_set_depth (actor, (float) 0);
#line 275 "ease-slide-actor.vala"
	clutter_actor_set_opacity (actor, (guint) 255);
#line 276 "ease-slide-actor.vala"
	g_object_set (actor, "rotation-angle-x", (double) 0, NULL);
#line 277 "ease-slide-actor.vala"
	g_object_set (actor, "rotation-angle-y", (double) 0, NULL);
#line 278 "ease-slide-actor.vala"
	g_object_set (actor, "rotation-angle-z", (double) 0, NULL);
#line 279 "ease-slide-actor.vala"
	g_object_set (actor, "scale-x", (double) 1, NULL);
#line 280 "ease-slide-actor.vala"
	g_object_set (actor, "scale-y", (double) 1, NULL);
#line 281 "ease-slide-actor.vala"
	clutter_actor_set_x (actor, (float) 0);
#line 282 "ease-slide-actor.vala"
	clutter_actor_set_y (actor, (float) 0);
#line 645 "ease-slide-actor.c"
}


#line 289 "ease-slide-actor.vala"
void ease_slide_actor_relayout (EaseSlideActor* self) {
#line 289 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 291 "ease-slide-actor.vala"
	ease_slide_actor_set_background (self);
#line 655 "ease-slide-actor.c"
	{
		GList* itr;
#line 293 "ease-slide-actor.vala"
		itr = clutter_container_get_children ((ClutterContainer*) self->contents);
#line 660 "ease-slide-actor.c"
		{
			gboolean _tmp0_;
#line 293 "ease-slide-actor.vala"
			_tmp0_ = TRUE;
#line 293 "ease-slide-actor.vala"
			while (TRUE) {
#line 293 "ease-slide-actor.vala"
				if (!_tmp0_) {
#line 295 "ease-slide-actor.vala"
					itr = itr->next;
#line 671 "ease-slide-actor.c"
				}
#line 293 "ease-slide-actor.vala"
				_tmp0_ = FALSE;
#line 294 "ease-slide-actor.vala"
				if (!(itr != NULL)) {
#line 294 "ease-slide-actor.vala"
					break;
#line 679 "ease-slide-actor.c"
				}
#line 297 "ease-slide-actor.vala"
				ease_actor_reposition (EASE_ACTOR ((ClutterActor*) itr->data));
#line 683 "ease-slide-actor.c"
			}
		}
	}
}


#line 304 "ease-slide-actor.vala"
static void ease_slide_actor_set_background (EaseSlideActor* self) {
#line 692 "ease-slide-actor.c"
	GError * _inner_error_;
#line 304 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 696 "ease-slide-actor.c"
	_inner_error_ = NULL;
#line 306 "ease-slide-actor.vala"
	if (self->background == NULL) {
#line 700 "ease-slide-actor.c"
		ClutterCairoTexture* _tmp0_;
#line 308 "ease-slide-actor.vala"
		self->background = (_tmp0_ = g_object_ref_sink ((ClutterCairoTexture*) clutter_cairo_texture_new ((guint) self->priv->width_px, (guint) self->priv->height_px)), _g_object_unref0 (self->background), _tmp0_);
#line 704 "ease-slide-actor.c"
	}
	{
		cairo_t* cr;
#line 315 "ease-slide-actor.vala"
		cr = clutter_cairo_texture_create (self->background);
#line 316 "ease-slide-actor.vala"
		ease_slide_cairo_render_background (self->priv->_slide, cr, (gint) self->priv->width_px, (gint) self->priv->height_px, &_inner_error_);
#line 712 "ease-slide-actor.c"
		if (_inner_error_ != NULL) {
			_cairo_destroy0 (cr);
			goto __catch11_g_error;
		}
		_cairo_destroy0 (cr);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 320 "ease-slide-actor.vala"
			g_critical ("ease-slide-actor.vala:320: Error rendering slide actor background: %s", e->message);
#line 728 "ease-slide-actor.c"
			_g_error_free0 (e);
		}
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
#line 323 "ease-slide-actor.vala"
	clutter_actor_set_width ((ClutterActor*) self->background, self->priv->width_px);
#line 324 "ease-slide-actor.vala"
	clutter_actor_set_height ((ClutterActor*) self->background, self->priv->height_px);
#line 742 "ease-slide-actor.c"
}


#line 330 "ease-slide-actor.vala"
static void ease_slide_actor_reorder (EaseSlideActor* self) {
#line 330 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 750 "ease-slide-actor.c"
	{
		EaseSlideIterator* _e_it;
#line 333 "ease-slide-actor.vala"
		_e_it = ease_slide_iterator (self->priv->_slide);
#line 333 "ease-slide-actor.vala"
		while (TRUE) {
#line 757 "ease-slide-actor.c"
			EaseElement* e;
#line 333 "ease-slide-actor.vala"
			if (!ease_slide_iterator_next (_e_it)) {
#line 333 "ease-slide-actor.vala"
				break;
#line 763 "ease-slide-actor.c"
			}
#line 333 "ease-slide-actor.vala"
			e = ease_slide_iterator_get (_e_it);
#line 767 "ease-slide-actor.c"
			{
				FlutterContainerIterator* _a_it;
#line 335 "ease-slide-actor.vala"
				_a_it = flutter_container_iterator ((FlutterContainer*) self->contents);
#line 335 "ease-slide-actor.vala"
				while (TRUE) {
#line 774 "ease-slide-actor.c"
					ClutterActor* a;
					ClutterActor* _tmp0_;
#line 335 "ease-slide-actor.vala"
					if (!flutter_container_iterator_next (_a_it)) {
#line 335 "ease-slide-actor.vala"
						break;
#line 781 "ease-slide-actor.c"
					}
#line 335 "ease-slide-actor.vala"
					a = flutter_container_iterator_get (_a_it);
#line 337 "ease-slide-actor.vala"
					if ((_tmp0_ = a, EASE_IS_ACTOR (_tmp0_) ? ((EaseActor*) _tmp0_) : NULL)->element == e) {
#line 339 "ease-slide-actor.vala"
						clutter_actor_raise_top (a);
#line 789 "ease-slide-actor.c"
						_g_object_unref0 (a);
#line 340 "ease-slide-actor.vala"
						break;
#line 793 "ease-slide-actor.c"
					}
					_g_object_unref0 (a);
				}
				_flutter_container_iterator_unref0 (_a_it);
			}
			_g_object_unref0 (e);
		}
		_ease_slide_iterator_unref0 (_e_it);
	}
}


#line 363 "ease-slide-actor.vala"
void ease_slide_actor_stack (EaseSlideActor* self, ClutterActor* container) {
#line 363 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 363 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 365 "ease-slide-actor.vala"
	if (clutter_actor_get_parent ((ClutterActor*) self->background) != CLUTTER_ACTOR (self)) {
#line 367 "ease-slide-actor.vala"
		clutter_actor_reparent ((ClutterActor*) self->background, (ClutterActor*) self);
#line 816 "ease-slide-actor.c"
	}
#line 369 "ease-slide-actor.vala"
	if (clutter_actor_get_parent ((ClutterActor*) self->contents) != CLUTTER_ACTOR (self)) {
#line 371 "ease-slide-actor.vala"
		clutter_actor_reparent ((ClutterActor*) self->contents, (ClutterActor*) self);
#line 822 "ease-slide-actor.c"
	}
#line 373 "ease-slide-actor.vala"
	if (clutter_actor_get_parent ((ClutterActor*) self) != container) {
#line 375 "ease-slide-actor.vala"
		clutter_actor_reparent ((ClutterActor*) self, container);
#line 828 "ease-slide-actor.c"
	}
}


#line 397 "ease-slide-actor.vala"
void ease_slide_actor_unstack (EaseSlideActor* self, EaseSlideActor* other, ClutterActor* container) {
#line 397 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 397 "ease-slide-actor.vala"
	g_return_if_fail (other != NULL);
#line 397 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 399 "ease-slide-actor.vala"
	if (clutter_actor_get_parent ((ClutterActor*) other->background) != container) {
#line 401 "ease-slide-actor.vala"
		clutter_actor_reparent ((ClutterActor*) other->background, container);
#line 845 "ease-slide-actor.c"
	}
#line 403 "ease-slide-actor.vala"
	if (clutter_actor_get_parent ((ClutterActor*) self->background) != container) {
#line 405 "ease-slide-actor.vala"
		clutter_actor_reparent ((ClutterActor*) self->background, container);
#line 851 "ease-slide-actor.c"
	}
#line 407 "ease-slide-actor.vala"
	if (clutter_actor_get_parent ((ClutterActor*) self->contents) != container) {
#line 409 "ease-slide-actor.vala"
		clutter_actor_reparent ((ClutterActor*) self->contents, container);
#line 857 "ease-slide-actor.c"
	}
#line 411 "ease-slide-actor.vala"
	if (clutter_actor_get_parent ((ClutterActor*) other->contents) != container) {
#line 413 "ease-slide-actor.vala"
		clutter_actor_reparent ((ClutterActor*) other->contents, container);
#line 863 "ease-slide-actor.c"
	}
}


#line 427 "ease-slide-actor.vala"
static void ease_slide_actor_prepare_slide_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container) {
#line 427 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 427 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 427 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 430 "ease-slide-actor.vala"
	ease_slide_actor_stack (new_slide, (ClutterActor*) container);
#line 431 "ease-slide-actor.vala"
	ease_slide_actor_stack (self, (ClutterActor*) container);
#line 880 "ease-slide-actor.c"
}


#line 440 "ease-slide-actor.vala"
static void ease_slide_actor_prepare_stack_transition (EaseSlideActor* self, gboolean current_on_top, EaseSlideActor* new_slide, ClutterGroup* container) {
#line 440 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 440 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 440 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 444 "ease-slide-actor.vala"
	ease_slide_actor_unstack (self, new_slide, (ClutterActor*) container);
#line 894 "ease-slide-actor.c"
}


#line 456 "ease-slide-actor.vala"
void ease_slide_actor_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container) {
#line 900 "ease-slide-actor.c"
	guint length;
	ClutterTimeline* _tmp0_;
#line 456 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 456 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 456 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 459 "ease-slide-actor.vala"
	length = (guint) ease_dmax ((double) 1, ease_slide_get_transition_time (self->priv->_slide) * 1000);
#line 461 "ease-slide-actor.vala"
	ease_slide_actor_set_animation_time (self, _tmp0_ = clutter_timeline_new (length));
#line 913 "ease-slide-actor.c"
	_g_object_unref0 (_tmp0_);
#line 463 "ease-slide-actor.vala"
	switch (ease_slide_get_transition (self->priv->_slide)) {
#line 917 "ease-slide-actor.c"
		case EASE_TRANSITION_SLIDE:
		{
#line 466 "ease-slide-actor.vala"
			ease_slide_actor_slide_transition (self, new_slide, container, length);
#line 467 "ease-slide-actor.vala"
			break;
#line 924 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_DROP:
		{
#line 470 "ease-slide-actor.vala"
			ease_slide_actor_drop_transition (self, new_slide, container, length);
#line 471 "ease-slide-actor.vala"
			break;
#line 932 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_PIVOT:
		{
#line 474 "ease-slide-actor.vala"
			ease_slide_actor_pivot_transition (self, new_slide, container, length);
#line 475 "ease-slide-actor.vala"
			break;
#line 940 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_OPEN_DOOR:
		{
#line 478 "ease-slide-actor.vala"
			ease_slide_actor_open_door_transition (self, new_slide, container, length);
#line 479 "ease-slide-actor.vala"
			break;
#line 948 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_REVEAL:
		{
#line 482 "ease-slide-actor.vala"
			ease_slide_actor_reveal_transition (self, new_slide, container, length);
#line 483 "ease-slide-actor.vala"
			break;
#line 956 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_SLATS:
		{
#line 486 "ease-slide-actor.vala"
			ease_slide_actor_slats_transition (self, new_slide, container, length);
#line 487 "ease-slide-actor.vala"
			break;
#line 964 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_FLIP:
		{
#line 490 "ease-slide-actor.vala"
			ease_slide_actor_flip_transition (self, new_slide, container, length);
#line 491 "ease-slide-actor.vala"
			break;
#line 972 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_REVOLVING_DOOR:
		{
#line 494 "ease-slide-actor.vala"
			ease_slide_actor_revolving_door_transition (self, new_slide, container, length);
#line 495 "ease-slide-actor.vala"
			break;
#line 980 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_FALL:
		{
#line 498 "ease-slide-actor.vala"
			ease_slide_actor_fall_transition (self, new_slide, container, length);
#line 499 "ease-slide-actor.vala"
			break;
#line 988 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_SPIN_CONTENTS:
		{
#line 502 "ease-slide-actor.vala"
			ease_slide_actor_spin_contents_transition (self, new_slide, container, length);
#line 503 "ease-slide-actor.vala"
			break;
#line 996 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_SWING_CONTENTS:
		{
#line 506 "ease-slide-actor.vala"
			ease_slide_actor_swing_contents_transition (self, new_slide, container, length);
#line 507 "ease-slide-actor.vala"
			break;
#line 1004 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_ZOOM:
		{
#line 510 "ease-slide-actor.vala"
			ease_slide_actor_zoom_transition (self, new_slide, container, length);
#line 511 "ease-slide-actor.vala"
			break;
#line 1012 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_SLIDE_CONTENTS:
		{
#line 514 "ease-slide-actor.vala"
			ease_slide_actor_slide_contents_transition (self, new_slide, container, length);
#line 515 "ease-slide-actor.vala"
			break;
#line 1020 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_SPRING_CONTENTS:
		{
#line 518 "ease-slide-actor.vala"
			ease_slide_actor_spring_contents_transition (self, new_slide, container, length);
#line 519 "ease-slide-actor.vala"
			break;
#line 1028 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_ZOOM_CONTENTS:
		{
#line 522 "ease-slide-actor.vala"
			ease_slide_actor_zoom_contents_transition (self, new_slide, container, length);
#line 523 "ease-slide-actor.vala"
			break;
#line 1036 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_PANEL:
		{
#line 526 "ease-slide-actor.vala"
			ease_slide_actor_panel_transition (self, new_slide, container, length);
#line 527 "ease-slide-actor.vala"
			break;
#line 1044 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_EXPLODE:
		{
#line 530 "ease-slide-actor.vala"
			ease_slide_actor_explode_transition (self, new_slide, container, length);
#line 531 "ease-slide-actor.vala"
			break;
#line 1052 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_ASSEMBLE:
		{
#line 534 "ease-slide-actor.vala"
			ease_slide_actor_assemble_transition (self, new_slide, container, length);
#line 535 "ease-slide-actor.vala"
			break;
#line 1060 "ease-slide-actor.c"
		}
		default:
		{
#line 538 "ease-slide-actor.vala"
			ease_slide_actor_fade_transition (self, new_slide, container, length);
#line 539 "ease-slide-actor.vala"
			break;
#line 1068 "ease-slide-actor.c"
		}
	}
#line 542 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->_animation_time);
#line 1073 "ease-slide-actor.c"
}


#line 552 "ease-slide-actor.vala"
static void ease_slide_actor_fade_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 552 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 552 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 552 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 555 "ease-slide-actor.vala"
	ease_slide_actor_prepare_slide_transition (self, new_slide, container);
#line 556 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) new_slide, (guint) 0);
#line 557 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) new_slide, (gulong) CLUTTER_LINEAR, length, "opacity", 255, NULL);
#line 1091 "ease-slide-actor.c"
}


#line 568 "ease-slide-actor.vala"
static void ease_slide_actor_slide_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 568 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 568 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 568 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 571 "ease-slide-actor.vala"
	switch (ease_slide_get_variant (self->priv->_slide)) {
#line 1105 "ease-slide-actor.c"
		case EASE_TRANSITION_VARIANT_UP:
		{
#line 574 "ease-slide-actor.vala"
			clutter_actor_set_y ((ClutterActor*) new_slide, (float) ease_slide_get_height (self->priv->_slide));
#line 575 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) new_slide, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "y", 0, NULL);
#line 576 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "y", -clutter_actor_get_y ((ClutterActor*) new_slide), NULL);
#line 577 "ease-slide-actor.vala"
			break;
#line 1116 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_DOWN:
		{
#line 580 "ease-slide-actor.vala"
			clutter_actor_set_y ((ClutterActor*) new_slide, (float) (-ease_slide_get_height (self->priv->_slide)));
#line 581 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) new_slide, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "y", 0, NULL);
#line 582 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "y", -clutter_actor_get_y ((ClutterActor*) new_slide), NULL);
#line 583 "ease-slide-actor.vala"
			break;
#line 1128 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_LEFT:
		{
#line 586 "ease-slide-actor.vala"
			clutter_actor_set_x ((ClutterActor*) new_slide, (float) ease_slide_get_width (self->priv->_slide));
#line 587 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) new_slide, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "x", 0, NULL);
#line 588 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "x", -clutter_actor_get_x ((ClutterActor*) new_slide), NULL);
#line 589 "ease-slide-actor.vala"
			break;
#line 1140 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_RIGHT:
		{
#line 592 "ease-slide-actor.vala"
			clutter_actor_set_x ((ClutterActor*) new_slide, (float) (-ease_slide_get_width (self->priv->_slide)));
#line 593 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) new_slide, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "x", 0, NULL);
#line 594 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "x", -clutter_actor_get_x ((ClutterActor*) new_slide), NULL);
#line 595 "ease-slide-actor.vala"
			break;
#line 1152 "ease-slide-actor.c"
		}
	}
}


#line 606 "ease-slide-actor.vala"
static void ease_slide_actor_drop_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 606 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 606 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 606 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 609 "ease-slide-actor.vala"
	clutter_actor_set_y ((ClutterActor*) new_slide, (float) (-ease_slide_get_height (self->priv->_slide)));
#line 610 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) new_slide, (gulong) EASE_SLIDE_ACTOR_EASE_DROP, length, "y", 0, NULL);
#line 1170 "ease-slide-actor.c"
}


#line 647 "ease-slide-actor.vala"
static void _lambda9_ (gint m, Block2Data* _data2_) {
#line 1176 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data2_->self;
#line 648 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) _data2_->new_slide, CLUTTER_Z_AXIS, _data2_->angle * (1 - clutter_alpha_get_alpha (self->priv->_animation_alpha)), _data2_->xpos, _data2_->ypos, (float) 0);
#line 1181 "ease-slide-actor.c"
}


#line 647 "ease-slide-actor.vala"
static void __lambda9__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 1187 "ease-slide-actor.c"
	_lambda9_ (frame_num, self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->new_slide);
		g_slice_free (Block2Data, _data2_);
	}
}


#line 620 "ease-slide-actor.vala"
static void ease_slide_actor_pivot_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 1214 "ease-slide-actor.c"
	Block2Data* _data2_;
	ClutterAlpha* _tmp0_;
#line 620 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 620 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 620 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 1223 "ease-slide-actor.c"
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->new_slide = _g_object_ref0 (new_slide);
	_data2_->xpos = (float) 0;
	_data2_->ypos = (float) 0;
	_data2_->angle = (float) 90;
#line 624 "ease-slide-actor.vala"
	switch (ease_slide_get_variant (self->priv->_slide)) {
#line 1233 "ease-slide-actor.c"
		case EASE_TRANSITION_VARIANT_TOP_RIGHT:
		{
#line 627 "ease-slide-actor.vala"
			_data2_->xpos = (float) ease_slide_get_width (self->priv->_slide);
#line 628 "ease-slide-actor.vala"
			_data2_->angle = (float) (-90);
#line 629 "ease-slide-actor.vala"
			break;
#line 1242 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_BOTTOM_LEFT:
		{
#line 631 "ease-slide-actor.vala"
			_data2_->ypos = (float) ease_slide_get_height (self->priv->_slide);
#line 632 "ease-slide-actor.vala"
			_data2_->angle = (float) (-90);
#line 633 "ease-slide-actor.vala"
			break;
#line 1252 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_BOTTOM_RIGHT:
		{
#line 635 "ease-slide-actor.vala"
			_data2_->xpos = (float) ease_slide_get_width (self->priv->_slide);
#line 636 "ease-slide-actor.vala"
			_data2_->ypos = (float) ease_slide_get_height (self->priv->_slide);
#line 637 "ease-slide-actor.vala"
			break;
#line 1262 "ease-slide-actor.c"
		}
	}
#line 641 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) _data2_->new_slide, CLUTTER_Z_AXIS, (double) _data2_->angle, _data2_->xpos, _data2_->ypos, (float) 0);
#line 643 "ease-slide-actor.vala"
	ease_slide_actor_set_animation_alpha (self, _tmp0_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->_animation_time, (gulong) EASE_SLIDE_ACTOR_EASE_PIVOT)));
#line 1269 "ease-slide-actor.c"
	_g_object_unref0 (_tmp0_);
#line 647 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->_animation_time, "new-frame", (GCallback) __lambda9__clutter_timeline_new_frame, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 1273 "ease-slide-actor.c"
	block2_data_unref (_data2_);
}


#line 711 "ease-slide-actor.vala"
static void _lambda14_ (gint m, Block3Data* _data3_) {
#line 1280 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data3_->self;
#line 713 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) self, _data3_->axis, (_data3_->positive * 90) * clutter_alpha_get_alpha (self->priv->alpha1), _data3_->x_point, _data3_->y_point, (float) 0);
#line 717 "ease-slide-actor.vala"
	clutter_actor_set_depth ((ClutterActor*) self, (float) (EASE_SLIDE_ACTOR_FLIP_DEPTH * clutter_alpha_get_alpha (self->priv->alpha1)));
#line 1287 "ease-slide-actor.c"
}


#line 711 "ease-slide-actor.vala"
static void __lambda14__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 1293 "ease-slide-actor.c"
	_lambda14_ (frame_num, self);
}


#line 721 "ease-slide-actor.vala"
static void _lambda15_ (gint m, Block3Data* _data3_) {
#line 1300 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data3_->self;
#line 723 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) _data3_->new_slide, _data3_->axis, (_data3_->positive * (-90)) * (1 - clutter_alpha_get_alpha (self->priv->alpha2)), _data3_->x_point, _data3_->y_point, (float) 0);
#line 727 "ease-slide-actor.vala"
	clutter_actor_set_depth ((ClutterActor*) _data3_->new_slide, EASE_SLIDE_ACTOR_FLIP_DEPTH * ((float) (1 - clutter_alpha_get_alpha (self->priv->alpha2))));
#line 730 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) _data3_->new_slide, (guint) 255);
#line 1309 "ease-slide-actor.c"
}


#line 721 "ease-slide-actor.vala"
static void __lambda15__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 1315 "ease-slide-actor.c"
	_lambda15_ (frame_num, self);
}


#line 733 "ease-slide-actor.vala"
static void _lambda16_ (Block3Data* _data3_) {
#line 1322 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data3_->self;
#line 735 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
#line 738 "ease-slide-actor.vala"
	clutter_actor_set_depth ((ClutterActor*) _data3_->new_slide, EASE_SLIDE_ACTOR_FLIP_DEPTH);
#line 741 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->time2);
#line 1331 "ease-slide-actor.c"
}


#line 733 "ease-slide-actor.vala"
static void __lambda16__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 1337 "ease-slide-actor.c"
	_lambda16_ (self);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_object_unref0 (_data3_->new_slide);
		g_slice_free (Block3Data, _data3_);
	}
}


#line 661 "ease-slide-actor.vala"
static void ease_slide_actor_flip_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 1359 "ease-slide-actor.c"
	Block3Data* _data3_;
	ClutterTimeline* _tmp0_;
	ClutterTimeline* _tmp1_;
	ClutterAlpha* _tmp2_;
	ClutterAlpha* _tmp3_;
#line 661 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 661 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 661 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 1371 "ease-slide-actor.c"
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->new_slide = _g_object_ref0 (new_slide);
#line 665 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) _data3_->new_slide, (guint) 0);
#line 668 "ease-slide-actor.vala"
	self->priv->time1 = (_tmp0_ = clutter_timeline_new (length / 2), _g_object_unref0 (self->priv->time1), _tmp0_);
#line 669 "ease-slide-actor.vala"
	self->priv->time2 = (_tmp1_ = clutter_timeline_new (length / 2), _g_object_unref0 (self->priv->time2), _tmp1_);
#line 670 "ease-slide-actor.vala"
	self->priv->alpha1 = (_tmp2_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->time1, (gulong) CLUTTER_EASE_IN_SINE)), _g_object_unref0 (self->priv->alpha1), _tmp2_);
#line 672 "ease-slide-actor.vala"
	self->priv->alpha2 = (_tmp3_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->time2, (gulong) CLUTTER_EASE_OUT_SINE)), _g_object_unref0 (self->priv->alpha2), _tmp3_);
#line 1386 "ease-slide-actor.c"
	_data3_->x_point = (float) 0;
	_data3_->y_point = (float) 0;
#line 684 "ease-slide-actor.vala"
	switch (ease_slide_get_variant (self->priv->_slide)) {
#line 1391 "ease-slide-actor.c"
		case EASE_TRANSITION_VARIANT_BOTTOM_TO_TOP:
		{
#line 687 "ease-slide-actor.vala"
			_data3_->axis = CLUTTER_X_AXIS;
#line 688 "ease-slide-actor.vala"
			_data3_->positive = (float) 1;
#line 689 "ease-slide-actor.vala"
			_data3_->y_point = (float) (ease_slide_get_height (self->priv->_slide) / 2);
#line 690 "ease-slide-actor.vala"
			break;
#line 1402 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_TOP_TO_BOTTOM:
		{
#line 693 "ease-slide-actor.vala"
			_data3_->axis = CLUTTER_X_AXIS;
#line 694 "ease-slide-actor.vala"
			_data3_->positive = (float) (-1);
#line 695 "ease-slide-actor.vala"
			break;
#line 1412 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_LEFT_TO_RIGHT:
		{
#line 698 "ease-slide-actor.vala"
			_data3_->axis = CLUTTER_Y_AXIS;
#line 699 "ease-slide-actor.vala"
			_data3_->positive = (float) 1;
#line 700 "ease-slide-actor.vala"
			_data3_->x_point = (float) (ease_slide_get_width (self->priv->_slide) / 2);
#line 701 "ease-slide-actor.vala"
			break;
#line 1424 "ease-slide-actor.c"
		}
		default:
		{
#line 704 "ease-slide-actor.vala"
			_data3_->axis = CLUTTER_Y_AXIS;
#line 705 "ease-slide-actor.vala"
			_data3_->positive = (float) (-1);
#line 706 "ease-slide-actor.vala"
			_data3_->x_point = (float) (ease_slide_get_width (self->priv->_slide) / 2);
#line 707 "ease-slide-actor.vala"
			break;
#line 1436 "ease-slide-actor.c"
		}
	}
#line 711 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time1, "new-frame", (GCallback) __lambda14__clutter_timeline_new_frame, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 721 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time2, "new-frame", (GCallback) __lambda15__clutter_timeline_new_frame, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 733 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time1, "completed", (GCallback) __lambda16__clutter_timeline_completed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 745 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->time1);
#line 1447 "ease-slide-actor.c"
	block3_data_unref (_data3_);
}


#line 801 "ease-slide-actor.vala"
static void _lambda17_ (gint m, Block4Data* _data4_) {
#line 1454 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data4_->self;
#line 803 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) _data4_->new_slide, _data4_->axis, (_data4_->positive * 90) * (1 - clutter_alpha_get_alpha (self->priv->_animation_alpha)), _data4_->x_point, _data4_->y_point, (float) 0);
#line 808 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) self, _data4_->axis, (_data4_->positive * (-110)) * clutter_alpha_get_alpha (self->priv->_animation_alpha), _data4_->x_point, _data4_->y_point, (float) 0);
#line 1461 "ease-slide-actor.c"
}


#line 801 "ease-slide-actor.vala"
static void __lambda17__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 1467 "ease-slide-actor.c"
	_lambda17_ (frame_num, self);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		_g_object_unref0 (_data4_->new_slide);
		g_slice_free (Block4Data, _data4_);
	}
}


#line 755 "ease-slide-actor.vala"
static void ease_slide_actor_revolving_door_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 1489 "ease-slide-actor.c"
	Block4Data* _data4_;
	ClutterAlpha* _tmp0_;
#line 755 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 755 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 755 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 1498 "ease-slide-actor.c"
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_data4_->new_slide = _g_object_ref0 (new_slide);
#line 760 "ease-slide-actor.vala"
	clutter_actor_set_depth ((ClutterActor*) self, (float) 1);
#line 762 "ease-slide-actor.vala"
	ease_slide_actor_set_animation_alpha (self, _tmp0_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->_animation_time, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE)));
#line 1507 "ease-slide-actor.c"
	_g_object_unref0 (_tmp0_);
	_data4_->x_point = (float) 0;
	_data4_->y_point = (float) 0;
#line 773 "ease-slide-actor.vala"
	switch (ease_slide_get_variant (self->priv->_slide)) {
#line 1513 "ease-slide-actor.c"
		case EASE_TRANSITION_VARIANT_LEFT:
		{
#line 776 "ease-slide-actor.vala"
			_data4_->axis = CLUTTER_Y_AXIS;
#line 777 "ease-slide-actor.vala"
			_data4_->positive = (float) 1;
#line 778 "ease-slide-actor.vala"
			break;
#line 1522 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_RIGHT:
		{
#line 781 "ease-slide-actor.vala"
			_data4_->axis = CLUTTER_Y_AXIS;
#line 782 "ease-slide-actor.vala"
			_data4_->positive = (float) (-1);
#line 783 "ease-slide-actor.vala"
			_data4_->x_point = (float) ease_slide_get_width (self->priv->_slide);
#line 784 "ease-slide-actor.vala"
			break;
#line 1534 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_TOP:
		{
#line 787 "ease-slide-actor.vala"
			_data4_->axis = CLUTTER_X_AXIS;
#line 788 "ease-slide-actor.vala"
			_data4_->positive = (float) (-1);
#line 789 "ease-slide-actor.vala"
			break;
#line 1544 "ease-slide-actor.c"
		}
		default:
		{
#line 792 "ease-slide-actor.vala"
			_data4_->axis = CLUTTER_X_AXIS;
#line 793 "ease-slide-actor.vala"
			_data4_->positive = (float) 1;
#line 794 "ease-slide-actor.vala"
			_data4_->y_point = (float) ease_slide_get_height (self->priv->_slide);
#line 795 "ease-slide-actor.vala"
			break;
#line 1556 "ease-slide-actor.c"
		}
	}
#line 799 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) _data4_->new_slide, _data4_->axis, (double) (90 * _data4_->positive), _data4_->x_point, _data4_->y_point, (float) 0);
#line 801 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->_animation_time, "new-frame", (GCallback) __lambda17__clutter_timeline_new_frame, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
#line 1563 "ease-slide-actor.c"
	block4_data_unref (_data4_);
}


#line 821 "ease-slide-actor.vala"
static void ease_slide_actor_reveal_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 1570 "ease-slide-actor.c"
	ClutterActor* _tmp0_;
#line 821 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 821 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 821 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 824 "ease-slide-actor.vala"
	clutter_container_raise_child ((_tmp0_ = clutter_actor_get_parent ((ClutterActor*) self), CLUTTER_IS_CONTAINER (_tmp0_) ? ((ClutterContainer*) _tmp0_) : NULL), (ClutterActor*) self, (ClutterActor*) new_slide);
#line 826 "ease-slide-actor.vala"
	switch (ease_slide_get_variant (self->priv->_slide)) {
#line 1582 "ease-slide-actor.c"
		case EASE_TRANSITION_VARIANT_UP:
		{
#line 829 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "y", -((float) ease_slide_get_height (self->priv->_slide)), NULL);
#line 830 "ease-slide-actor.vala"
			break;
#line 1589 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_DOWN:
		{
#line 832 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "y", (float) ease_slide_get_height (self->priv->_slide), NULL);
#line 833 "ease-slide-actor.vala"
			break;
#line 1597 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_LEFT:
		{
#line 835 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "x", -((float) ease_slide_get_width (self->priv->_slide)), NULL);
#line 836 "ease-slide-actor.vala"
			break;
#line 1605 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_RIGHT:
		{
#line 838 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "x", (float) ease_slide_get_width (self->priv->_slide), NULL);
#line 839 "ease-slide-actor.vala"
			break;
#line 1613 "ease-slide-actor.c"
		}
	}
}


#line 857 "ease-slide-actor.vala"
static void _lambda18_ (gint m, EaseSlideActor* self) {
#line 858 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) self, CLUTTER_X_AXIS, (-90) * clutter_alpha_get_alpha (self->priv->_animation_alpha), (float) 0, (float) ease_slide_get_height (self->priv->_slide), (float) 0);
#line 1623 "ease-slide-actor.c"
}


#line 857 "ease-slide-actor.vala"
static void __lambda18__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 1629 "ease-slide-actor.c"
	_lambda18_ (frame_num, self);
}


#line 850 "ease-slide-actor.vala"
static void ease_slide_actor_fall_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 1636 "ease-slide-actor.c"
	ClutterAlpha* _tmp0_;
#line 850 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 850 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 850 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 853 "ease-slide-actor.vala"
	clutter_actor_set_depth ((ClutterActor*) self, (float) 1);
#line 855 "ease-slide-actor.vala"
	ease_slide_actor_set_animation_alpha (self, _tmp0_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->_animation_time, (gulong) CLUTTER_EASE_IN_QUART)));
#line 1648 "ease-slide-actor.c"
	_g_object_unref0 (_tmp0_);
#line 857 "ease-slide-actor.vala"
	g_signal_connect_object (self->priv->_animation_time, "new-frame", (GCallback) __lambda18__clutter_timeline_new_frame, self, 0);
#line 1652 "ease-slide-actor.c"
}


#line 923 "ease-slide-actor.vala"
static void _lambda12_ (gint m, Block5Data* _data5_) {
#line 1658 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data5_->self;
	{
		gint i;
#line 924 "ease-slide-actor.vala"
		i = 0;
#line 1665 "ease-slide-actor.c"
		{
			gboolean _tmp0_;
#line 924 "ease-slide-actor.vala"
			_tmp0_ = TRUE;
#line 924 "ease-slide-actor.vala"
			while (TRUE) {
#line 924 "ease-slide-actor.vala"
				if (!_tmp0_) {
#line 924 "ease-slide-actor.vala"
					i++;
#line 1676 "ease-slide-actor.c"
				}
#line 924 "ease-slide-actor.vala"
				_tmp0_ = FALSE;
#line 924 "ease-slide-actor.vala"
				if (!(i < EASE_SLIDE_ACTOR_SLAT_COUNT)) {
#line 924 "ease-slide-actor.vala"
					break;
#line 1684 "ease-slide-actor.c"
				}
#line 926 "ease-slide-actor.vala"
				clutter_actor_set_rotation ((ClutterActor*) _data5_->groups[i], CLUTTER_Y_AXIS, 180 * clutter_alpha_get_alpha (self->priv->_animation_alpha), (i + 0.5f) * _data5_->width, (float) 0, (float) 0);
#line 1688 "ease-slide-actor.c"
			}
		}
	}
}


#line 923 "ease-slide-actor.vala"
static void __lambda12__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 1697 "ease-slide-actor.c"
	_lambda12_ (frame_num, self);
}


#line 933 "ease-slide-actor.vala"
static void _lambda13_ (Block5Data* _data5_) {
#line 1704 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data5_->self;
	{
		gint i;
#line 935 "ease-slide-actor.vala"
		i = 0;
#line 1711 "ease-slide-actor.c"
		{
			gboolean _tmp0_;
#line 935 "ease-slide-actor.vala"
			_tmp0_ = TRUE;
#line 935 "ease-slide-actor.vala"
			while (TRUE) {
#line 935 "ease-slide-actor.vala"
				if (!_tmp0_) {
#line 935 "ease-slide-actor.vala"
					i++;
#line 1722 "ease-slide-actor.c"
				}
#line 935 "ease-slide-actor.vala"
				_tmp0_ = FALSE;
#line 935 "ease-slide-actor.vala"
				if (!(i < EASE_SLIDE_ACTOR_SLAT_COUNT)) {
#line 935 "ease-slide-actor.vala"
					break;
#line 1730 "ease-slide-actor.c"
				}
#line 937 "ease-slide-actor.vala"
				clutter_container_remove_actor ((ClutterContainer*) _data5_->container, (ClutterActor*) _data5_->groups[i]);
#line 1734 "ease-slide-actor.c"
			}
		}
	}
#line 941 "ease-slide-actor.vala"
	clutter_actor_set_x ((ClutterActor*) _data5_->new_slide, (float) 0);
#line 944 "ease-slide-actor.vala"
	cogl_set_depth_test_enabled (FALSE);
#line 1742 "ease-slide-actor.c"
}


#line 933 "ease-slide-actor.vala"
static void __lambda13__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 1748 "ease-slide-actor.c"
	_lambda13_ (self);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->self);
		_data5_->groups = (_vala_array_free (_data5_->groups, _data5_->groups_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (_data5_->new_slide);
		_g_object_unref0 (_data5_->container);
		g_slice_free (Block5Data, _data5_);
	}
}


#line 871 "ease-slide-actor.vala"
static void ease_slide_actor_slats_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 1772 "ease-slide-actor.c"
	Block5Data* _data5_;
	ClutterClone** _tmp0_;
	gint _this_slats_size_;
	gint this_slats_length1;
	ClutterClone** this_slats;
	ClutterClone** _tmp1_;
	gint _new_slats_size_;
	gint new_slats_length1;
	ClutterClone** new_slats;
	ClutterGroup** _tmp2_;
	ClutterAlpha* _tmp7_;
#line 871 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 871 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 871 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 1790 "ease-slide-actor.c"
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->new_slide = _g_object_ref0 (new_slide);
	_data5_->container = _g_object_ref0 (container);
#line 875 "ease-slide-actor.vala"
	cogl_set_depth_test_enabled (TRUE);
#line 878 "ease-slide-actor.vala"
	clutter_actor_reparent ((ClutterActor*) self, (ClutterActor*) _data5_->container);
#line 879 "ease-slide-actor.vala"
	clutter_actor_reparent ((ClutterActor*) _data5_->new_slide, (ClutterActor*) _data5_->container);
#line 880 "ease-slide-actor.vala"
	clutter_actor_set_x ((ClutterActor*) self, (float) ease_slide_get_width (self->priv->_slide));
#line 881 "ease-slide-actor.vala"
	clutter_actor_set_x ((ClutterActor*) _data5_->new_slide, (float) ease_slide_get_width (self->priv->_slide));
#line 1806 "ease-slide-actor.c"
	this_slats = (_tmp0_ = g_new0 (ClutterClone*, EASE_SLIDE_ACTOR_SLAT_COUNT + 1), this_slats_length1 = EASE_SLIDE_ACTOR_SLAT_COUNT, _this_slats_size_ = this_slats_length1, _tmp0_);
	new_slats = (_tmp1_ = g_new0 (ClutterClone*, EASE_SLIDE_ACTOR_SLAT_COUNT + 1), new_slats_length1 = EASE_SLIDE_ACTOR_SLAT_COUNT, _new_slats_size_ = new_slats_length1, _tmp1_);
	_data5_->groups = (_tmp2_ = g_new0 (ClutterGroup*, EASE_SLIDE_ACTOR_SLAT_COUNT + 1), _data5_->groups_length1 = EASE_SLIDE_ACTOR_SLAT_COUNT, _tmp2_);
	_data5_->width = ((float) ease_slide_get_width (self->priv->_slide)) / EASE_SLIDE_ACTOR_SLAT_COUNT;
	{
		gint i;
#line 892 "ease-slide-actor.vala"
		i = 0;
#line 1815 "ease-slide-actor.c"
		{
			gboolean _tmp3_;
#line 892 "ease-slide-actor.vala"
			_tmp3_ = TRUE;
#line 892 "ease-slide-actor.vala"
			while (TRUE) {
#line 1822 "ease-slide-actor.c"
				ClutterGroup* _tmp4_;
				ClutterClone* _tmp5_;
				ClutterClone* _tmp6_;
#line 892 "ease-slide-actor.vala"
				if (!_tmp3_) {
#line 892 "ease-slide-actor.vala"
					i++;
#line 1830 "ease-slide-actor.c"
				}
#line 892 "ease-slide-actor.vala"
				_tmp3_ = FALSE;
#line 892 "ease-slide-actor.vala"
				if (!(i < EASE_SLIDE_ACTOR_SLAT_COUNT)) {
#line 892 "ease-slide-actor.vala"
					break;
#line 1838 "ease-slide-actor.c"
				}
#line 895 "ease-slide-actor.vala"
				_data5_->groups[i] = (_tmp4_ = g_object_ref_sink ((ClutterGroup*) clutter_group_new ()), _g_object_unref0 (_data5_->groups[i]), _tmp4_);
#line 896 "ease-slide-actor.vala"
				clutter_container_add_actor ((ClutterContainer*) _data5_->container, (ClutterActor*) _data5_->groups[i]);
#line 899 "ease-slide-actor.vala"
				this_slats[i] = (_tmp5_ = g_object_ref_sink ((ClutterClone*) clutter_clone_new ((ClutterActor*) self)), _g_object_unref0 (this_slats[i]), _tmp5_);
#line 900 "ease-slide-actor.vala"
				clutter_container_add_actor ((ClutterContainer*) _data5_->groups[i], (ClutterActor*) this_slats[i]);
#line 901 "ease-slide-actor.vala"
				new_slats[i] = (_tmp6_ = g_object_ref_sink ((ClutterClone*) clutter_clone_new ((ClutterActor*) _data5_->new_slide)), _g_object_unref0 (new_slats[i]), _tmp6_);
#line 902 "ease-slide-actor.vala"
				clutter_container_add_actor ((ClutterContainer*) _data5_->groups[i], (ClutterActor*) new_slats[i]);
#line 905 "ease-slide-actor.vala"
				clutter_actor_set_clip ((ClutterActor*) this_slats[i], _data5_->width * i, (float) 0, _data5_->width, (float) ease_slide_get_height (self->priv->_slide));
#line 907 "ease-slide-actor.vala"
				clutter_actor_set_clip ((ClutterActor*) new_slats[i], _data5_->width * i, (float) 0, _data5_->width, (float) ease_slide_get_height (self->priv->_slide));
#line 911 "ease-slide-actor.vala"
				clutter_actor_set_rotation ((ClutterActor*) new_slats[i], CLUTTER_Y_AXIS, (double) 180, (_data5_->width / 2) + (i * _data5_->width), (float) 0, (float) 0);
#line 915 "ease-slide-actor.vala"
				clutter_actor_set_depth ((ClutterActor*) new_slats[i], (float) (-2));
#line 1860 "ease-slide-actor.c"
			}
		}
	}
#line 919 "ease-slide-actor.vala"
	ease_slide_actor_set_animation_alpha (self, _tmp7_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->_animation_time, (gulong) CLUTTER_EASE_IN_OUT_BACK)));
#line 1866 "ease-slide-actor.c"
	_g_object_unref0 (_tmp7_);
#line 923 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->_animation_time, "new-frame", (GCallback) __lambda12__clutter_timeline_new_frame, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
#line 933 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->_animation_time, "completed", (GCallback) __lambda13__clutter_timeline_completed, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
#line 1872 "ease-slide-actor.c"
	new_slats = (_vala_array_free (new_slats, new_slats_length1, (GDestroyNotify) g_object_unref), NULL);
	this_slats = (_vala_array_free (this_slats, this_slats_length1, (GDestroyNotify) g_object_unref), NULL);
	block5_data_unref (_data5_);
}


#line 1029 "ease-slide-actor.vala"
static void _lambda10_ (gint m, Block6Data* _data6_) {
#line 1881 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data6_->self;
#line 1030 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) _data6_->left_group, CLUTTER_Y_AXIS, 180 * clutter_alpha_get_alpha (self->priv->_animation_alpha), (float) 0, (float) 0, (float) 0);
#line 1034 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) _data6_->right_group, CLUTTER_Y_AXIS, (-180) * clutter_alpha_get_alpha (self->priv->_animation_alpha), _data6_->width * 2, (float) 0, (float) 0);
#line 1888 "ease-slide-actor.c"
}


#line 1029 "ease-slide-actor.vala"
static void __lambda10__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 1894 "ease-slide-actor.c"
	_lambda10_ (frame_num, self);
}


#line 1040 "ease-slide-actor.vala"
static void _lambda11_ (Block6Data* _data6_) {
#line 1901 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data6_->self;
#line 1041 "ease-slide-actor.vala"
	clutter_container_remove_actor ((ClutterContainer*) _data6_->container, (ClutterActor*) _data6_->left_group);
#line 1042 "ease-slide-actor.vala"
	clutter_container_remove_actor ((ClutterContainer*) _data6_->container, (ClutterActor*) _data6_->right_group);
#line 1908 "ease-slide-actor.c"
}


#line 1040 "ease-slide-actor.vala"
static void __lambda11__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 1914 "ease-slide-actor.c"
	_lambda11_ (self);
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_g_object_unref0 (_data6_->self);
		_g_object_unref0 (_data6_->right_group);
		_g_object_unref0 (_data6_->left_group);
		_g_object_unref0 (_data6_->container);
		g_slice_free (Block6Data, _data6_);
	}
}


#line 955 "ease-slide-actor.vala"
static void ease_slide_actor_open_door_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 1938 "ease-slide-actor.c"
	Block6Data* _data6_;
	ClutterClone* reflection;
	ClutterClone* left;
	ClutterClone* right;
	ClutterClone* left_ref;
	ClutterClone* right_ref;
	ClutterTimeline* _tmp0_;
	ClutterTimeline* _tmp1_;
	ClutterAlpha* _tmp2_;
#line 955 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 955 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 955 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 1954 "ease-slide-actor.c"
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_data6_->container = _g_object_ref0 (container);
#line 960 "ease-slide-actor.vala"
	reflection = g_object_ref_sink ((ClutterClone*) clutter_clone_new ((ClutterActor*) new_slide));
#line 961 "ease-slide-actor.vala"
	g_object_set ((ClutterActor*) reflection, "rotation-angle-z", (double) 180, NULL);
#line 962 "ease-slide-actor.vala"
	g_object_set ((ClutterActor*) reflection, "rotation-angle-y", (double) 180, NULL);
#line 963 "ease-slide-actor.vala"
	clutter_actor_set_y ((ClutterActor*) reflection, (float) (2 * ease_slide_get_height (self->priv->_slide)));
#line 964 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) reflection, (guint) EASE_SLIDE_ACTOR_REFLECTION_OPACITY);
#line 967 "ease-slide-actor.vala"
	clutter_actor_set_depth ((ClutterActor*) new_slide, EASE_SLIDE_ACTOR_OPEN_DEPTH);
#line 968 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) new_slide, (gulong) CLUTTER_EASE_OUT_SINE, length, "depth", 0, NULL);
#line 971 "ease-slide-actor.vala"
	clutter_actor_set_depth ((ClutterActor*) reflection, EASE_SLIDE_ACTOR_OPEN_DEPTH);
#line 972 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) reflection, (gulong) CLUTTER_EASE_OUT_SINE, length, "depth", 0, NULL);
#line 974 "ease-slide-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) _data6_->container, (ClutterActor*) reflection);
#line 976 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) self, (gulong) CLUTTER_LINEAR, length, "opacity", 0, NULL);
#line 977 "ease-slide-actor.vala"
	clutter_actor_reparent ((ClutterActor*) self, (ClutterActor*) _data6_->container);
#line 978 "ease-slide-actor.vala"
	clutter_actor_set_x ((ClutterActor*) self, (float) ease_slide_get_width (self->priv->_slide));
#line 1985 "ease-slide-actor.c"
	_data6_->width = ease_slide_get_width (self->priv->_slide) / 2.f;
#line 982 "ease-slide-actor.vala"
	left = g_object_ref_sink ((ClutterClone*) clutter_clone_new ((ClutterActor*) self));
#line 983 "ease-slide-actor.vala"
	right = g_object_ref_sink ((ClutterClone*) clutter_clone_new ((ClutterActor*) self));
#line 985 "ease-slide-actor.vala"
	clutter_actor_set_clip ((ClutterActor*) left, (float) 0, (float) 0, _data6_->width, (float) ease_slide_get_height (self->priv->_slide));
#line 986 "ease-slide-actor.vala"
	clutter_actor_set_clip ((ClutterActor*) right, _data6_->width, (float) 0, _data6_->width, (float) ease_slide_get_height (self->priv->_slide));
#line 989 "ease-slide-actor.vala"
	left_ref = g_object_ref_sink ((ClutterClone*) clutter_clone_new ((ClutterActor*) left));
#line 990 "ease-slide-actor.vala"
	right_ref = g_object_ref_sink ((ClutterClone*) clutter_clone_new ((ClutterActor*) right));
#line 992 "ease-slide-actor.vala"
	g_object_set ((ClutterActor*) left_ref, "rotation-angle-z", (double) 180, NULL);
#line 993 "ease-slide-actor.vala"
	g_object_set ((ClutterActor*) left_ref, "rotation-angle-y", (double) 180, NULL);
#line 994 "ease-slide-actor.vala"
	clutter_actor_set_y ((ClutterActor*) left_ref, (float) (2 * ease_slide_get_height (self->priv->_slide)));
#line 995 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) left_ref, (guint) EASE_SLIDE_ACTOR_REFLECTION_OPACITY);
#line 997 "ease-slide-actor.vala"
	g_object_set ((ClutterActor*) right_ref, "rotation-angle-z", (double) 180, NULL);
#line 998 "ease-slide-actor.vala"
	g_object_set ((ClutterActor*) right_ref, "rotation-angle-y", (double) 180, NULL);
#line 999 "ease-slide-actor.vala"
	clutter_actor_set_y ((ClutterActor*) right_ref, (float) (2 * ease_slide_get_height (self->priv->_slide)));
#line 1000 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) right_ref, (guint) EASE_SLIDE_ACTOR_REFLECTION_OPACITY);
#line 2015 "ease-slide-actor.c"
	_data6_->left_group = g_object_ref_sink ((ClutterGroup*) clutter_group_new ());
	_data6_->right_group = g_object_ref_sink ((ClutterGroup*) clutter_group_new ());
#line 1007 "ease-slide-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) _data6_->left_group, (ClutterActor*) left_ref);
#line 1008 "ease-slide-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) _data6_->left_group, (ClutterActor*) left);
#line 1009 "ease-slide-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) _data6_->right_group, (ClutterActor*) right_ref);
#line 1010 "ease-slide-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) _data6_->right_group, (ClutterActor*) right);
#line 1013 "ease-slide-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) _data6_->container, (ClutterActor*) _data6_->left_group);
#line 1014 "ease-slide-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) _data6_->container, (ClutterActor*) _data6_->right_group);
#line 1017 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) _data6_->left_group, (gulong) CLUTTER_EASE_IN_OUT_SINE, length / 2, "x", clutter_actor_get_x ((ClutterActor*) left) - (_data6_->width * EASE_SLIDE_ACTOR_OPEN_MOVE), NULL);
#line 1020 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) _data6_->right_group, (gulong) CLUTTER_EASE_IN_OUT_SINE, length / 2, "x", clutter_actor_get_x ((ClutterActor*) right) + (_data6_->width * EASE_SLIDE_ACTOR_OPEN_MOVE), NULL);
#line 1024 "ease-slide-actor.vala"
	self->priv->time1 = (_tmp0_ = clutter_timeline_new ((guint) ((gint) (EASE_SLIDE_ACTOR_OPEN_TIME * length))), _g_object_unref0 (self->priv->time1), _tmp0_);
#line 1025 "ease-slide-actor.vala"
	self->priv->time2 = (_tmp1_ = clutter_timeline_new (length), _g_object_unref0 (self->priv->time2), _tmp1_);
#line 1026 "ease-slide-actor.vala"
	ease_slide_actor_set_animation_alpha (self, _tmp2_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->time1, (gulong) CLUTTER_EASE_IN_SINE)));
#line 2040 "ease-slide-actor.c"
	_g_object_unref0 (_tmp2_);
#line 1029 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time1, "new-frame", (GCallback) __lambda10__clutter_timeline_new_frame, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
#line 1040 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time1, "completed", (GCallback) __lambda11__clutter_timeline_completed, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
#line 1045 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->time1);
#line 1046 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->time2);
#line 2050 "ease-slide-actor.c"
	_g_object_unref0 (right_ref);
	_g_object_unref0 (left_ref);
	_g_object_unref0 (right);
	_g_object_unref0 (left);
	_g_object_unref0 (reflection);
	block6_data_unref (_data6_);
}


#line 1084 "ease-slide-actor.vala"
static void _lambda23_ (gint m, Block7Data* _data7_) {
#line 2062 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data7_->self;
#line 1085 "ease-slide-actor.vala"
	clutter_actor_set_scale ((ClutterActor*) _data7_->new_slide, clutter_alpha_get_alpha (self->priv->_animation_alpha), clutter_alpha_get_alpha (self->priv->_animation_alpha));
#line 2067 "ease-slide-actor.c"
}


#line 1084 "ease-slide-actor.vala"
static void __lambda23__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 2073 "ease-slide-actor.c"
	_lambda23_ (frame_num, self);
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		_g_object_unref0 (_data7_->self);
		_g_object_unref0 (_data7_->new_slide);
		g_slice_free (Block7Data, _data7_);
	}
}


#line 1056 "ease-slide-actor.vala"
static void ease_slide_actor_zoom_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 2095 "ease-slide-actor.c"
	Block7Data* _data7_;
	ClutterAlpha* _tmp0_;
#line 1056 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 1056 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 1056 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 2104 "ease-slide-actor.c"
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_data7_->new_slide = _g_object_ref0 (new_slide);
#line 1059 "ease-slide-actor.vala"
	switch (ease_slide_get_variant (self->priv->_slide)) {
#line 2111 "ease-slide-actor.c"
		case EASE_TRANSITION_VARIANT_CENTER:
		{
#line 1062 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) _data7_->new_slide, (double) 0, (double) 0, (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) (ease_slide_get_height (self->priv->_slide) / 2));
#line 1065 "ease-slide-actor.vala"
			break;
#line 2118 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_TOP_LEFT:
		{
#line 1067 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) _data7_->new_slide, (double) 0, (double) 0, (float) 0, (float) 0);
#line 1068 "ease-slide-actor.vala"
			break;
#line 2126 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_TOP_RIGHT:
		{
#line 1070 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) _data7_->new_slide, (double) 0, (double) 0, (float) ease_slide_get_width (self->priv->_slide), (float) 0);
#line 1071 "ease-slide-actor.vala"
			break;
#line 2134 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_BOTTOM_LEFT:
		{
#line 1073 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) _data7_->new_slide, (double) 0, (double) 0, (float) 0, (float) ease_slide_get_height (self->priv->_slide));
#line 1074 "ease-slide-actor.vala"
			break;
#line 2142 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_BOTTOM_RIGHT:
		{
#line 1076 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) _data7_->new_slide, (double) 0, (double) 0, (float) ease_slide_get_width (self->priv->_slide), (float) ease_slide_get_height (self->priv->_slide));
#line 1079 "ease-slide-actor.vala"
			break;
#line 2150 "ease-slide-actor.c"
		}
	}
#line 1081 "ease-slide-actor.vala"
	ease_slide_actor_set_animation_alpha (self, _tmp0_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->_animation_time, (gulong) CLUTTER_EASE_OUT_SINE)));
#line 2155 "ease-slide-actor.c"
	_g_object_unref0 (_tmp0_);
#line 1084 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->_animation_time, "new-frame", (GCallback) __lambda23__clutter_timeline_new_frame, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
#line 2159 "ease-slide-actor.c"
	block7_data_unref (_data7_);
}


#line 1132 "ease-slide-actor.vala"
static void _lambda26_ (gint m, EaseSlideActor* self) {
#line 1133 "ease-slide-actor.vala"
	clutter_actor_set_scale_full ((ClutterActor*) self, EASE_SLIDE_ACTOR_PANEL_SCALE + ((1 - EASE_SLIDE_ACTOR_PANEL_SCALE) * (1 - clutter_alpha_get_alpha (self->priv->alpha1))), EASE_SLIDE_ACTOR_PANEL_SCALE + ((1 - EASE_SLIDE_ACTOR_PANEL_SCALE) * (1 - clutter_alpha_get_alpha (self->priv->alpha1))), (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) (ease_slide_get_height (self->priv->_slide) / 2));
#line 2168 "ease-slide-actor.c"
}


#line 1132 "ease-slide-actor.vala"
static void __lambda26__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 2174 "ease-slide-actor.c"
	_lambda26_ (frame_num, self);
}


#line 1139 "ease-slide-actor.vala"
static void _lambda27_ (Block8Data* _data8_) {
#line 2181 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data8_->self;
#line 1140 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) self, (gulong) CLUTTER_EASE_IN_OUT_SINE, _data8_->length / 2, _data8_->property, -_data8_->pos, NULL);
#line 1143 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) _data8_->new_slide, (gulong) CLUTTER_EASE_IN_OUT_SINE, _data8_->length / 2, _data8_->property, 0.0f, NULL);
#line 2188 "ease-slide-actor.c"
}


#line 1139 "ease-slide-actor.vala"
static void __lambda27__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 2194 "ease-slide-actor.c"
	_lambda27_ (self);
}


#line 1147 "ease-slide-actor.vala"
static void _lambda29_ (gint m, Block8Data* _data8_) {
#line 2201 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data8_->self;
#line 1148 "ease-slide-actor.vala"
	clutter_actor_set_scale_full ((ClutterActor*) _data8_->new_slide, EASE_SLIDE_ACTOR_PANEL_SCALE + ((1 - EASE_SLIDE_ACTOR_PANEL_SCALE) * clutter_alpha_get_alpha (self->priv->alpha1)), EASE_SLIDE_ACTOR_PANEL_SCALE + ((1 - EASE_SLIDE_ACTOR_PANEL_SCALE) * clutter_alpha_get_alpha (self->priv->alpha1)), (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) (ease_slide_get_height (self->priv->_slide) / 2));
#line 2206 "ease-slide-actor.c"
}


#line 1147 "ease-slide-actor.vala"
static void __lambda29__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 2212 "ease-slide-actor.c"
	_lambda29_ (frame_num, self);
}


#line 1146 "ease-slide-actor.vala"
static void _lambda28_ (Block8Data* _data8_) {
#line 2219 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data8_->self;
#line 1147 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time1, "new-frame", (GCallback) __lambda29__clutter_timeline_new_frame, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
#line 1155 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->time1);
#line 2226 "ease-slide-actor.c"
}


#line 1146 "ease-slide-actor.vala"
static void __lambda28__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 2232 "ease-slide-actor.c"
	_lambda28_ (self);
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (Block8Data* _data8_) {
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		_g_object_unref0 (_data8_->self);
		_g_free0 (_data8_->property);
		_g_object_unref0 (_data8_->new_slide);
		g_slice_free (Block8Data, _data8_);
	}
}


#line 1096 "ease-slide-actor.vala"
static void ease_slide_actor_panel_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 2255 "ease-slide-actor.c"
	Block8Data* _data8_;
	ClutterTimeline* _tmp4_;
	ClutterTimeline* _tmp5_;
	GValue _tmp7_;
	GValue _tmp6_ = {0};
	ClutterAlpha* _tmp8_;
#line 1096 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 1096 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 1096 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 2268 "ease-slide-actor.c"
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_data8_->new_slide = _g_object_ref0 (new_slide);
	_data8_->length = length;
	_data8_->pos = (float) 0;
	_data8_->property = g_strdup ("");
#line 1102 "ease-slide-actor.vala"
	switch (ease_slide_get_variant (self->priv->_slide)) {
#line 2278 "ease-slide-actor.c"
		case EASE_TRANSITION_VARIANT_UP:
		{
			char* _tmp0_;
#line 1105 "ease-slide-actor.vala"
			_data8_->pos = (float) ease_slide_get_height (self->priv->_slide);
#line 1106 "ease-slide-actor.vala"
			_data8_->property = (_tmp0_ = g_strdup ("y"), _g_free0 (_data8_->property), _tmp0_);
#line 1107 "ease-slide-actor.vala"
			break;
#line 2288 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_DOWN:
		{
			char* _tmp1_;
#line 1109 "ease-slide-actor.vala"
			_data8_->pos = (float) (-ease_slide_get_height (self->priv->_slide));
#line 1110 "ease-slide-actor.vala"
			_data8_->property = (_tmp1_ = g_strdup ("y"), _g_free0 (_data8_->property), _tmp1_);
#line 1111 "ease-slide-actor.vala"
			break;
#line 2299 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_LEFT:
		{
			char* _tmp2_;
#line 1113 "ease-slide-actor.vala"
			_data8_->pos = (float) ease_slide_get_width (self->priv->_slide);
#line 1114 "ease-slide-actor.vala"
			_data8_->property = (_tmp2_ = g_strdup ("x"), _g_free0 (_data8_->property), _tmp2_);
#line 1115 "ease-slide-actor.vala"
			break;
#line 2310 "ease-slide-actor.c"
		}
		default:
		{
			char* _tmp3_;
#line 1117 "ease-slide-actor.vala"
			_data8_->pos = (float) (-ease_slide_get_width (self->priv->_slide));
#line 1118 "ease-slide-actor.vala"
			_data8_->property = (_tmp3_ = g_strdup ("x"), _g_free0 (_data8_->property), _tmp3_);
#line 1119 "ease-slide-actor.vala"
			break;
#line 2321 "ease-slide-actor.c"
		}
	}
#line 1122 "ease-slide-actor.vala"
	self->priv->time1 = (_tmp4_ = clutter_timeline_new (_data8_->length / 4), _g_object_unref0 (self->priv->time1), _tmp4_);
#line 1123 "ease-slide-actor.vala"
	self->priv->time2 = (_tmp5_ = clutter_timeline_new ((3 * _data8_->length) / 4), _g_object_unref0 (self->priv->time2), _tmp5_);
#line 1124 "ease-slide-actor.vala"
	clutter_actor_set_scale_full ((ClutterActor*) _data8_->new_slide, (double) EASE_SLIDE_ACTOR_PANEL_SCALE, (double) EASE_SLIDE_ACTOR_PANEL_SCALE, (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) (ease_slide_get_height (self->priv->_slide) / 2));
#line 1128 "ease-slide-actor.vala"
	g_object_set_property ((GObject*) _data8_->new_slide, _data8_->property, (_tmp7_ = (g_value_init (&_tmp6_, G_TYPE_FLOAT), g_value_set_float (&_tmp6_, _data8_->pos), _tmp6_), &_tmp7_));
#line 1129 "ease-slide-actor.vala"
	self->priv->alpha1 = (_tmp8_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->time1, (gulong) CLUTTER_EASE_IN_OUT_SINE)), _g_object_unref0 (self->priv->alpha1), _tmp8_);
#line 1132 "ease-slide-actor.vala"
	g_signal_connect_object (self->priv->time1, "new-frame", (GCallback) __lambda26__clutter_timeline_new_frame, self, 0);
#line 1139 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time1, "completed", (GCallback) __lambda27__clutter_timeline_completed, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
#line 1146 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time2, "completed", (GCallback) __lambda28__clutter_timeline_completed, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
#line 1157 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->time1);
#line 1158 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->time2);
#line 2344 "ease-slide-actor.c"
	block8_data_unref (_data8_);
}


#line 1187 "ease-slide-actor.vala"
static void _lambda19_ (EaseSlideActor* self) {
#line 1188 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) self->contents, (guint) 0);
#line 1189 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->time2);
#line 2355 "ease-slide-actor.c"
}


#line 1187 "ease-slide-actor.vala"
static void __lambda19__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 2361 "ease-slide-actor.c"
	_lambda19_ (self);
}


#line 1191 "ease-slide-actor.vala"
static void _lambda20_ (gint m, Block9Data* _data9_) {
#line 2368 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data9_->self;
#line 1192 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) self->contents, CLUTTER_Y_AXIS, _data9_->angle * clutter_alpha_get_alpha (self->priv->alpha1), (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) 0, (float) 0);
#line 2373 "ease-slide-actor.c"
}


#line 1191 "ease-slide-actor.vala"
static void __lambda20__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 2379 "ease-slide-actor.c"
	_lambda20_ (frame_num, self);
}


#line 1196 "ease-slide-actor.vala"
static void _lambda21_ (gint m, Block9Data* _data9_) {
#line 2386 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data9_->self;
#line 1197 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) _data9_->new_slide->contents, (guint) 255);
#line 1198 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) _data9_->new_slide->contents, CLUTTER_Y_AXIS, (-_data9_->angle) * (1 - clutter_alpha_get_alpha (self->priv->alpha2)), (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) 0, (float) 0);
#line 2393 "ease-slide-actor.c"
}


#line 1196 "ease-slide-actor.vala"
static void __lambda21__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 2399 "ease-slide-actor.c"
	_lambda21_ (frame_num, self);
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (Block9Data* _data9_) {
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		_g_object_unref0 (_data9_->self);
		_g_object_unref0 (_data9_->new_slide);
		g_slice_free (Block9Data, _data9_);
	}
}


#line 1169 "ease-slide-actor.vala"
static void ease_slide_actor_spin_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 2421 "ease-slide-actor.c"
	Block9Data* _data9_;
	ClutterTimeline* _tmp0_;
	ClutterTimeline* _tmp1_;
	ClutterAlpha* _tmp2_;
	ClutterAlpha* _tmp3_;
	gint _tmp4_ = 0;
#line 1169 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 1169 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 1169 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 2434 "ease-slide-actor.c"
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_data9_->new_slide = _g_object_ref0 (new_slide);
#line 1173 "ease-slide-actor.vala"
	ease_slide_actor_prepare_stack_transition (self, FALSE, _data9_->new_slide, container);
#line 1175 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) _data9_->new_slide->contents, (guint) 0);
#line 1176 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) self->background, (gulong) CLUTTER_EASE_IN_OUT_SINE, length, "opacity", 0, NULL);
#line 1178 "ease-slide-actor.vala"
	self->priv->time1 = (_tmp0_ = clutter_timeline_new (length / 2), _g_object_unref0 (self->priv->time1), _tmp0_);
#line 1179 "ease-slide-actor.vala"
	self->priv->time2 = (_tmp1_ = clutter_timeline_new (length / 2), _g_object_unref0 (self->priv->time2), _tmp1_);
#line 1180 "ease-slide-actor.vala"
	self->priv->alpha1 = (_tmp2_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->time1, (gulong) CLUTTER_EASE_IN_SINE)), _g_object_unref0 (self->priv->alpha1), _tmp2_);
#line 1183 "ease-slide-actor.vala"
	self->priv->alpha2 = (_tmp3_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->time2, (gulong) CLUTTER_EASE_OUT_SINE)), _g_object_unref0 (self->priv->alpha2), _tmp3_);
#line 1186 "ease-slide-actor.vala"
	if (ease_slide_get_variant (self->priv->_slide) == EASE_TRANSITION_VARIANT_LEFT) {
#line 1186 "ease-slide-actor.vala"
		_tmp4_ = -90;
#line 2457 "ease-slide-actor.c"
	} else {
#line 1186 "ease-slide-actor.vala"
		_tmp4_ = 90;
#line 2461 "ease-slide-actor.c"
	}
	_data9_->angle = (float) _tmp4_;
#line 1187 "ease-slide-actor.vala"
	g_signal_connect_object (self->priv->time1, "completed", (GCallback) __lambda19__clutter_timeline_completed, self, 0);
#line 1191 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time1, "new-frame", (GCallback) __lambda20__clutter_timeline_new_frame, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
#line 1196 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time2, "new-frame", (GCallback) __lambda21__clutter_timeline_new_frame, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
#line 1202 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->time1);
#line 2472 "ease-slide-actor.c"
	block9_data_unref (_data9_);
}


#line 1231 "ease-slide-actor.vala"
static void _lambda22_ (gint m, Block10Data* _data10_) {
#line 2479 "ease-slide-actor.c"
	EaseSlideActor * self;
	GList* itr = NULL;
	self = _data10_->self;
#line 1233 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) self->contents, (guint) ease_slide_actor_clamp_opacity (455 - (555 * clutter_alpha_get_alpha (self->priv->alpha1))));
#line 1234 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) _data10_->new_slide->contents, (guint) ease_slide_actor_clamp_opacity ((-100) + (400 * clutter_alpha_get_alpha (self->priv->alpha2))));
#line 2487 "ease-slide-actor.c"
	{
		gboolean _tmp0_;
#line 1236 "ease-slide-actor.vala"
		itr = clutter_container_get_children ((ClutterContainer*) self->contents);
#line 1236 "ease-slide-actor.vala"
		_tmp0_ = TRUE;
#line 1236 "ease-slide-actor.vala"
		while (TRUE) {
#line 1236 "ease-slide-actor.vala"
			if (!_tmp0_) {
#line 1236 "ease-slide-actor.vala"
				itr = itr->next;
#line 2500 "ease-slide-actor.c"
			}
#line 1236 "ease-slide-actor.vala"
			_tmp0_ = FALSE;
#line 1236 "ease-slide-actor.vala"
			if (!(itr != NULL)) {
#line 1236 "ease-slide-actor.vala"
				break;
#line 2508 "ease-slide-actor.c"
			}
#line 1238 "ease-slide-actor.vala"
			clutter_actor_set_rotation ((ClutterActor*) ((EaseActor*) ((ClutterActor*) itr->data)), CLUTTER_X_AXIS, 540 * clutter_alpha_get_alpha (self->priv->alpha1), (float) 0, (float) 0, (float) 0);
#line 2512 "ease-slide-actor.c"
		}
	}
	{
		gboolean _tmp1_;
#line 1242 "ease-slide-actor.vala"
		itr = clutter_container_get_children ((ClutterContainer*) _data10_->new_slide->contents);
#line 1242 "ease-slide-actor.vala"
		_tmp1_ = TRUE;
#line 1242 "ease-slide-actor.vala"
		while (TRUE) {
#line 1242 "ease-slide-actor.vala"
			if (!_tmp1_) {
#line 1243 "ease-slide-actor.vala"
				itr = itr->next;
#line 2527 "ease-slide-actor.c"
			}
#line 1242 "ease-slide-actor.vala"
			_tmp1_ = FALSE;
#line 1243 "ease-slide-actor.vala"
			if (!(itr != NULL)) {
#line 1243 "ease-slide-actor.vala"
				break;
#line 2535 "ease-slide-actor.c"
			}
#line 1245 "ease-slide-actor.vala"
			clutter_actor_set_rotation ((ClutterActor*) ((EaseActor*) ((ClutterActor*) itr->data)), CLUTTER_X_AXIS, (-540) * (1 - clutter_alpha_get_alpha (self->priv->alpha2)), (float) 0, (float) 0, (float) 0);
#line 2539 "ease-slide-actor.c"
		}
	}
}


#line 1231 "ease-slide-actor.vala"
static void __lambda22__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 2547 "ease-slide-actor.c"
	_lambda22_ (frame_num, self);
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (Block10Data* _data10_) {
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		_g_object_unref0 (_data10_->self);
		_g_object_unref0 (_data10_->new_slide);
		g_slice_free (Block10Data, _data10_);
	}
}


#line 1213 "ease-slide-actor.vala"
static void ease_slide_actor_swing_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 2569 "ease-slide-actor.c"
	Block10Data* _data10_;
	ClutterAlpha* _tmp0_;
	ClutterAlpha* _tmp1_;
	ClutterAlpha* _tmp2_;
#line 1213 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 1213 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 1213 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 2580 "ease-slide-actor.c"
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_data10_->new_slide = _g_object_ref0 (new_slide);
#line 1217 "ease-slide-actor.vala"
	ease_slide_actor_prepare_stack_transition (self, FALSE, _data10_->new_slide, container);
#line 1219 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) _data10_->new_slide->contents, (guint) 0);
#line 1220 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) self->background, (gulong) CLUTTER_EASE_IN_OUT_SINE, length, "opacity", 0, NULL);
#line 1222 "ease-slide-actor.vala"
	self->priv->alpha1 = (_tmp0_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->_animation_time, (gulong) CLUTTER_EASE_IN_SINE)), _g_object_unref0 (self->priv->alpha1), _tmp0_);
#line 1225 "ease-slide-actor.vala"
	self->priv->alpha2 = (_tmp1_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->_animation_time, (gulong) CLUTTER_EASE_OUT_SINE)), _g_object_unref0 (self->priv->alpha2), _tmp1_);
#line 1228 "ease-slide-actor.vala"
	ease_slide_actor_set_animation_alpha (self, _tmp2_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->_animation_time, (gulong) CLUTTER_LINEAR)));
#line 2597 "ease-slide-actor.c"
	_g_object_unref0 (_tmp2_);
#line 1231 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->_animation_time, "new-frame", (GCallback) __lambda22__clutter_timeline_new_frame, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
#line 2601 "ease-slide-actor.c"
	block10_data_unref (_data10_);
}


#line 1260 "ease-slide-actor.vala"
static void ease_slide_actor_slide_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 1260 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 1260 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 1260 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 1264 "ease-slide-actor.vala"
	ease_slide_actor_prepare_stack_transition (self, FALSE, new_slide, container);
#line 1266 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) self->background, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "opacity", 0, NULL);
#line 1268 "ease-slide-actor.vala"
	switch (ease_slide_get_variant (self->priv->_slide)) {
#line 2620 "ease-slide-actor.c"
		case EASE_TRANSITION_VARIANT_RIGHT:
		{
#line 1271 "ease-slide-actor.vala"
			clutter_actor_set_x ((ClutterActor*) new_slide->contents, (float) (-ease_slide_get_width (self->priv->_slide)));
#line 1272 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) new_slide->contents, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "x", 0, NULL);
#line 1274 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self->contents, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "x", -clutter_actor_get_x ((ClutterActor*) new_slide->contents), NULL);
#line 1276 "ease-slide-actor.vala"
			break;
#line 2631 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_LEFT:
		{
#line 1278 "ease-slide-actor.vala"
			clutter_actor_set_x ((ClutterActor*) new_slide->contents, (float) ease_slide_get_width (self->priv->_slide));
#line 1279 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) new_slide->contents, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "x", 0, NULL);
#line 1281 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self->contents, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "x", -clutter_actor_get_x ((ClutterActor*) new_slide->contents), NULL);
#line 1283 "ease-slide-actor.vala"
			break;
#line 2643 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_UP:
		{
#line 1285 "ease-slide-actor.vala"
			clutter_actor_set_y ((ClutterActor*) new_slide->contents, (float) ease_slide_get_height (self->priv->_slide));
#line 1286 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) new_slide->contents, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "y", 0, NULL);
#line 1288 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self->contents, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "y", -clutter_actor_get_y ((ClutterActor*) new_slide->contents), NULL);
#line 1290 "ease-slide-actor.vala"
			break;
#line 2655 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_DOWN:
		{
#line 1292 "ease-slide-actor.vala"
			clutter_actor_set_y ((ClutterActor*) new_slide->contents, (float) (-ease_slide_get_height (self->priv->_slide)));
#line 1293 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) new_slide->contents, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "y", 0, NULL);
#line 1295 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self->contents, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "y", -clutter_actor_get_y ((ClutterActor*) new_slide->contents), NULL);
#line 1297 "ease-slide-actor.vala"
			break;
#line 2667 "ease-slide-actor.c"
		}
	}
}


#line 1309 "ease-slide-actor.vala"
static void ease_slide_actor_spring_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 1309 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 1309 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 1309 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 1313 "ease-slide-actor.vala"
	ease_slide_actor_prepare_stack_transition (self, FALSE, new_slide, container);
#line 1315 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) self->background, (gulong) CLUTTER_EASE_IN_OUT_SINE, length, "opacity", 0, NULL);
#line 1318 "ease-slide-actor.vala"
	switch (ease_slide_get_variant (self->priv->_slide)) {
#line 2687 "ease-slide-actor.c"
		case EASE_TRANSITION_VARIANT_UP:
		{
#line 1321 "ease-slide-actor.vala"
			clutter_actor_set_y ((ClutterActor*) new_slide->contents, ease_slide_get_height (self->priv->_slide) * 1.2f);
#line 1322 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) new_slide->contents, (gulong) CLUTTER_EASE_IN_OUT_ELASTIC, length, "y", 0, NULL);
#line 1324 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self->contents, (gulong) CLUTTER_EASE_IN_OUT_ELASTIC, length, "y", (-ease_slide_get_height (self->priv->_slide)) * 1.2, NULL);
#line 1326 "ease-slide-actor.vala"
			break;
#line 2698 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_DOWN:
		{
#line 1328 "ease-slide-actor.vala"
			clutter_actor_set_y ((ClutterActor*) new_slide->contents, (-ease_slide_get_height (self->priv->_slide)) * 1.2f);
#line 1329 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) new_slide->contents, (gulong) CLUTTER_EASE_IN_OUT_ELASTIC, length, "y", 0, NULL);
#line 1331 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self->contents, (gulong) CLUTTER_EASE_IN_OUT_ELASTIC, length, "y", ease_slide_get_height (self->priv->_slide) * 1.2, NULL);
#line 1333 "ease-slide-actor.vala"
			break;
#line 2710 "ease-slide-actor.c"
		}
	}
}


#line 1368 "ease-slide-actor.vala"
static void _lambda24_ (gint m, Block11Data* _data11_) {
#line 2718 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data11_->self;
#line 1369 "ease-slide-actor.vala"
	clutter_actor_set_scale ((ClutterActor*) _data11_->new_slide->contents, clutter_alpha_get_alpha (self->priv->_animation_alpha), clutter_alpha_get_alpha (self->priv->_animation_alpha));
#line 1372 "ease-slide-actor.vala"
	clutter_actor_set_scale ((ClutterActor*) self->contents, 1.0 + (2 * clutter_alpha_get_alpha (self->priv->_animation_alpha)), 1.0 + (2 * clutter_alpha_get_alpha (self->priv->_animation_alpha)));
#line 2725 "ease-slide-actor.c"
}


#line 1368 "ease-slide-actor.vala"
static void __lambda24__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 2731 "ease-slide-actor.c"
	_lambda24_ (frame_num, self);
}


#line 1388 "ease-slide-actor.vala"
static void _lambda25_ (gint m, Block11Data* _data11_) {
#line 2738 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data11_->self;
#line 1389 "ease-slide-actor.vala"
	clutter_actor_set_scale ((ClutterActor*) _data11_->new_slide->contents, 1.0 + (2 * (1 - clutter_alpha_get_alpha (self->priv->_animation_alpha))), 1.0 + (2 * (1 - clutter_alpha_get_alpha (self->priv->_animation_alpha))));
#line 1391 "ease-slide-actor.vala"
	clutter_actor_set_scale ((ClutterActor*) self->contents, 1 - clutter_alpha_get_alpha (self->priv->_animation_alpha), 1 - clutter_alpha_get_alpha (self->priv->_animation_alpha));
#line 2745 "ease-slide-actor.c"
}


#line 1388 "ease-slide-actor.vala"
static void __lambda25__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 2751 "ease-slide-actor.c"
	_lambda25_ (frame_num, self);
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (Block11Data* _data11_) {
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		_g_object_unref0 (_data11_->self);
		_g_object_unref0 (_data11_->new_slide);
		g_slice_free (Block11Data, _data11_);
	}
}


#line 1345 "ease-slide-actor.vala"
static void ease_slide_actor_zoom_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 2773 "ease-slide-actor.c"
	Block11Data* _data11_;
	ClutterAlpha* _tmp0_;
#line 1345 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 1345 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 1345 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 2782 "ease-slide-actor.c"
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_data11_->new_slide = _g_object_ref0 (new_slide);
#line 1349 "ease-slide-actor.vala"
	ease_slide_actor_prepare_stack_transition (self, ease_slide_get_variant (self->priv->_slide) == EASE_TRANSITION_VARIANT_OUT, _data11_->new_slide, container);
#line 1352 "ease-slide-actor.vala"
	ease_slide_actor_set_animation_alpha (self, _tmp0_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->_animation_time, (gulong) CLUTTER_EASE_IN_OUT_SINE)));
#line 2791 "ease-slide-actor.c"
	_g_object_unref0 (_tmp0_);
#line 1355 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) self->background, (gulong) CLUTTER_LINEAR, length, "opacity", 0, NULL);
#line 1356 "ease-slide-actor.vala"
	switch (ease_slide_get_variant (self->priv->_slide)) {
#line 2797 "ease-slide-actor.c"
		case EASE_TRANSITION_VARIANT_IN:
		{
#line 1359 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) _data11_->new_slide->contents, (double) 0, (double) 0, (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) (ease_slide_get_height (self->priv->_slide) / 2));
#line 1363 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) self->contents, (double) 1, (double) 1, (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) (ease_slide_get_height (self->priv->_slide) / 2));
#line 1367 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self->contents, (gulong) CLUTTER_LINEAR, length / 2, "opacity", 0, NULL);
#line 1368 "ease-slide-actor.vala"
			g_signal_connect_data (self->priv->_animation_time, "new-frame", (GCallback) __lambda24__clutter_timeline_new_frame, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
#line 1375 "ease-slide-actor.vala"
			break;
#line 2810 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_OUT:
		{
#line 1377 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) _data11_->new_slide->contents, (double) 0, (double) 0, (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) (ease_slide_get_height (self->priv->_slide) / 2));
#line 1381 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) self->contents, (double) 1, (double) 1, (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) (ease_slide_get_height (self->priv->_slide) / 2));
#line 1385 "ease-slide-actor.vala"
			clutter_actor_set_opacity ((ClutterActor*) _data11_->new_slide->contents, (guint) 0);
#line 1386 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) _data11_->new_slide->contents, (gulong) CLUTTER_EASE_IN_SINE, length / 2, "opacity", 255, NULL);
#line 1388 "ease-slide-actor.vala"
			g_signal_connect_data (self->priv->_animation_time, "new-frame", (GCallback) __lambda25__clutter_timeline_new_frame, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
#line 1394 "ease-slide-actor.vala"
			break;
#line 2826 "ease-slide-actor.c"
		}
	}
	block11_data_unref (_data11_);
}


#line 1454 "ease-slide-actor.vala"
static void _lambda30_ (Block12Data* _data12_) {
#line 2835 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data12_->self;
	{
		gint j;
#line 1455 "ease-slide-actor.vala"
		j = 0;
#line 2842 "ease-slide-actor.c"
		{
			gboolean _tmp0_;
#line 1455 "ease-slide-actor.vala"
			_tmp0_ = TRUE;
#line 1455 "ease-slide-actor.vala"
			while (TRUE) {
#line 1455 "ease-slide-actor.vala"
				if (!_tmp0_) {
#line 1455 "ease-slide-actor.vala"
					j++;
#line 2853 "ease-slide-actor.c"
				}
#line 1455 "ease-slide-actor.vala"
				_tmp0_ = FALSE;
#line 1455 "ease-slide-actor.vala"
				if (!(j < _data12_->count)) {
#line 1455 "ease-slide-actor.vala"
					break;
#line 2861 "ease-slide-actor.c"
				}
#line 1457 "ease-slide-actor.vala"
				clutter_container_remove_actor ((ClutterContainer*) _data12_->container, (ClutterActor*) _data12_->particles[j]);
#line 2865 "ease-slide-actor.c"
			}
		}
	}
}


#line 1454 "ease-slide-actor.vala"
static void __lambda30__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 2874 "ease-slide-actor.c"
	_lambda30_ (self);
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}


static void block12_data_unref (Block12Data* _data12_) {
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		_g_object_unref0 (_data12_->self);
		_data12_->particles = (_vala_array_free (_data12_->particles, _data12_->particles_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (_data12_->container);
		g_slice_free (Block12Data, _data12_);
	}
}


#line 1405 "ease-slide-actor.vala"
static void ease_slide_actor_explode_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 2897 "ease-slide-actor.c"
	Block12Data* _data12_;
	gint v_count;
	ClutterClone** _tmp0_;
	float size;
	float center_x;
	float center_y;
	gint i = 0;
#line 1405 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 1405 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 1405 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 2911 "ease-slide-actor.c"
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_data12_->container = _g_object_ref0 (container);
#line 1410 "ease-slide-actor.vala"
	clutter_actor_reparent ((ClutterActor*) self, (ClutterActor*) _data12_->container);
#line 1411 "ease-slide-actor.vala"
	clutter_actor_reparent ((ClutterActor*) new_slide, (ClutterActor*) _data12_->container);
#line 1412 "ease-slide-actor.vala"
	clutter_actor_set_x ((ClutterActor*) self, (float) ease_slide_get_width (self->priv->_slide));
#line 1415 "ease-slide-actor.vala"
	v_count = (gint) ceil ((double) ((1 / ease_slide_get_aspect (self->priv->_slide)) * EASE_SLIDE_ACTOR_EXPLODE_PARTICLES));
#line 2924 "ease-slide-actor.c"
	_data12_->count = EASE_SLIDE_ACTOR_EXPLODE_PARTICLES * v_count;
	_data12_->particles = (_tmp0_ = g_new0 (ClutterClone*, _data12_->count + 1), _data12_->particles_length1 = _data12_->count, _tmp0_);
#line 1420 "ease-slide-actor.vala"
	size = ((float) ease_slide_get_width (self->priv->_slide)) / EASE_SLIDE_ACTOR_EXPLODE_PARTICLES;
#line 1421 "ease-slide-actor.vala"
	center_x = (float) (ease_slide_get_width (self->priv->_slide) / 2);
#line 1422 "ease-slide-actor.vala"
	center_y = (float) (ease_slide_get_height (self->priv->_slide) / 2);
#line 2933 "ease-slide-actor.c"
	{
		gint vpos;
#line 1426 "ease-slide-actor.vala"
		vpos = 0;
#line 2938 "ease-slide-actor.c"
		{
			gboolean _tmp1_;
#line 1426 "ease-slide-actor.vala"
			_tmp1_ = TRUE;
#line 1426 "ease-slide-actor.vala"
			while (TRUE) {
#line 1426 "ease-slide-actor.vala"
				if (!_tmp1_) {
#line 1426 "ease-slide-actor.vala"
					vpos++;
#line 2949 "ease-slide-actor.c"
				}
#line 1426 "ease-slide-actor.vala"
				_tmp1_ = FALSE;
#line 1426 "ease-slide-actor.vala"
				if (!(vpos < v_count)) {
#line 1426 "ease-slide-actor.vala"
					break;
#line 2957 "ease-slide-actor.c"
				}
				{
					gint hpos;
#line 1428 "ease-slide-actor.vala"
					hpos = 0;
#line 2963 "ease-slide-actor.c"
					{
						gboolean _tmp2_;
#line 1428 "ease-slide-actor.vala"
						_tmp2_ = TRUE;
#line 1428 "ease-slide-actor.vala"
						while (TRUE) {
#line 2970 "ease-slide-actor.c"
							ClutterClone* _tmp3_;
							float atan;
#line 1428 "ease-slide-actor.vala"
							if (!_tmp2_) {
#line 1428 "ease-slide-actor.vala"
								hpos++;
#line 2977 "ease-slide-actor.c"
							}
#line 1428 "ease-slide-actor.vala"
							_tmp2_ = FALSE;
#line 1428 "ease-slide-actor.vala"
							if (!(hpos < EASE_SLIDE_ACTOR_EXPLODE_PARTICLES)) {
#line 1428 "ease-slide-actor.vala"
								break;
#line 2985 "ease-slide-actor.c"
							}
#line 1431 "ease-slide-actor.vala"
							i = (vpos * EASE_SLIDE_ACTOR_EXPLODE_PARTICLES) + hpos;
#line 1432 "ease-slide-actor.vala"
							_data12_->particles[i] = (_tmp3_ = g_object_ref_sink ((ClutterClone*) clutter_clone_new ((ClutterActor*) self)), _g_object_unref0 (_data12_->particles[i]), _tmp3_);
#line 1435 "ease-slide-actor.vala"
							clutter_actor_set_clip ((ClutterActor*) _data12_->particles[i], hpos * size, vpos * size, size, size);
#line 1437 "ease-slide-actor.vala"
							atan = atan2f (center_y - (vpos * size), center_x - (hpos * size));
#line 1441 "ease-slide-actor.vala"
							clutter_actor_animate ((ClutterActor*) _data12_->particles[i], (gulong) CLUTTER_EASE_IN_SINE, ease_slide_actor_explode_time (self, length), "x", (-cosf (atan)) * ease_slide_actor_explode_dist (self), "y", (-sinf (atan)) * ease_slide_actor_explode_dist (self), "depth", ease_slide_actor_explode_depth (self), "opacity", 0, NULL);
#line 1448 "ease-slide-actor.vala"
							clutter_container_add_actor ((ClutterContainer*) _data12_->container, (ClutterActor*) _data12_->particles[i]);
#line 1449 "ease-slide-actor.vala"
							clutter_actor_show ((ClutterActor*) _data12_->particles[i]);
#line 3001 "ease-slide-actor.c"
						}
					}
				}
			}
		}
	}
#line 1454 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->_animation_time, "completed", (GCallback) __lambda30__clutter_timeline_completed, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
#line 3010 "ease-slide-actor.c"
	block12_data_unref (_data12_);
}


#line 1529 "ease-slide-actor.vala"
static void _lambda31_ (Block13Data* _data13_) {
#line 3017 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data13_->self;
#line 1530 "ease-slide-actor.vala"
	clutter_actor_set_x ((ClutterActor*) _data13_->new_slide, (float) 0);
#line 3022 "ease-slide-actor.c"
	{
		gint j;
#line 1531 "ease-slide-actor.vala"
		j = 0;
#line 3027 "ease-slide-actor.c"
		{
			gboolean _tmp0_;
#line 1531 "ease-slide-actor.vala"
			_tmp0_ = TRUE;
#line 1531 "ease-slide-actor.vala"
			while (TRUE) {
#line 1531 "ease-slide-actor.vala"
				if (!_tmp0_) {
#line 1531 "ease-slide-actor.vala"
					j++;
#line 3038 "ease-slide-actor.c"
				}
#line 1531 "ease-slide-actor.vala"
				_tmp0_ = FALSE;
#line 1531 "ease-slide-actor.vala"
				if (!(j < _data13_->count)) {
#line 1531 "ease-slide-actor.vala"
					break;
#line 3046 "ease-slide-actor.c"
				}
#line 1533 "ease-slide-actor.vala"
				if (clutter_actor_get_parent ((ClutterActor*) _data13_->particles[j]) == CLUTTER_ACTOR (_data13_->container)) {
#line 1535 "ease-slide-actor.vala"
					clutter_container_remove_actor ((ClutterContainer*) _data13_->container, (ClutterActor*) _data13_->particles[j]);
#line 3052 "ease-slide-actor.c"
				}
			}
		}
	}
}


#line 1529 "ease-slide-actor.vala"
static void __lambda31__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 3062 "ease-slide-actor.c"
	_lambda31_ (self);
}


static Block13Data* block13_data_ref (Block13Data* _data13_) {
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}


static void block13_data_unref (Block13Data* _data13_) {
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		_g_object_unref0 (_data13_->self);
		_data13_->particles = (_vala_array_free (_data13_->particles, _data13_->particles_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (_data13_->new_slide);
		_g_object_unref0 (_data13_->container);
		g_slice_free (Block13Data, _data13_);
	}
}


#line 1469 "ease-slide-actor.vala"
static void ease_slide_actor_assemble_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 3086 "ease-slide-actor.c"
	Block13Data* _data13_;
	gint v_count;
	ClutterClone** _tmp0_;
	float size;
	gint i = 0;
#line 1469 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 1469 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 1469 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 3098 "ease-slide-actor.c"
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_data13_->new_slide = _g_object_ref0 (new_slide);
	_data13_->container = _g_object_ref0 (container);
#line 1474 "ease-slide-actor.vala"
	clutter_actor_reparent ((ClutterActor*) _data13_->new_slide, (ClutterActor*) _data13_->container);
#line 1475 "ease-slide-actor.vala"
	clutter_actor_set_x ((ClutterActor*) _data13_->new_slide, (float) ease_slide_get_width (self->priv->_slide));
#line 1478 "ease-slide-actor.vala"
	v_count = (gint) ceil ((double) ((1 / ease_slide_get_aspect (self->priv->_slide)) * EASE_SLIDE_ACTOR_ASSEMBLE_TILES));
#line 3110 "ease-slide-actor.c"
	_data13_->count = EASE_SLIDE_ACTOR_ASSEMBLE_TILES * v_count;
	_data13_->particles = (_tmp0_ = g_new0 (ClutterClone*, _data13_->count + 1), _data13_->particles_length1 = _data13_->count, _tmp0_);
#line 1483 "ease-slide-actor.vala"
	size = ((float) ease_slide_get_width (self->priv->_slide)) / EASE_SLIDE_ACTOR_ASSEMBLE_TILES;
#line 3115 "ease-slide-actor.c"
	{
		gint vpos;
#line 1487 "ease-slide-actor.vala"
		vpos = 0;
#line 3120 "ease-slide-actor.c"
		{
			gboolean _tmp1_;
#line 1487 "ease-slide-actor.vala"
			_tmp1_ = TRUE;
#line 1487 "ease-slide-actor.vala"
			while (TRUE) {
#line 1487 "ease-slide-actor.vala"
				if (!_tmp1_) {
#line 1487 "ease-slide-actor.vala"
					vpos++;
#line 3131 "ease-slide-actor.c"
				}
#line 1487 "ease-slide-actor.vala"
				_tmp1_ = FALSE;
#line 1487 "ease-slide-actor.vala"
				if (!(vpos < v_count)) {
#line 1487 "ease-slide-actor.vala"
					break;
#line 3139 "ease-slide-actor.c"
				}
				{
					gint hpos;
#line 1489 "ease-slide-actor.vala"
					hpos = 0;
#line 3145 "ease-slide-actor.c"
					{
						gboolean _tmp2_;
#line 1489 "ease-slide-actor.vala"
						_tmp2_ = TRUE;
#line 1489 "ease-slide-actor.vala"
						while (TRUE) {
#line 3152 "ease-slide-actor.c"
							ClutterClone* _tmp3_;
							gboolean anim_x;
							const char* _tmp4_;
#line 1489 "ease-slide-actor.vala"
							if (!_tmp2_) {
#line 1489 "ease-slide-actor.vala"
								hpos++;
#line 3160 "ease-slide-actor.c"
							}
#line 1489 "ease-slide-actor.vala"
							_tmp2_ = FALSE;
#line 1489 "ease-slide-actor.vala"
							if (!(hpos < EASE_SLIDE_ACTOR_ASSEMBLE_TILES)) {
#line 1489 "ease-slide-actor.vala"
								break;
#line 3168 "ease-slide-actor.c"
							}
#line 1492 "ease-slide-actor.vala"
							i = (vpos * EASE_SLIDE_ACTOR_ASSEMBLE_TILES) + hpos;
#line 1493 "ease-slide-actor.vala"
							_data13_->particles[i] = (_tmp3_ = g_object_ref_sink ((ClutterClone*) clutter_clone_new ((ClutterActor*) _data13_->new_slide)), _g_object_unref0 (_data13_->particles[i]), _tmp3_);
#line 1496 "ease-slide-actor.vala"
							clutter_actor_set_clip ((ClutterActor*) _data13_->particles[i], hpos * size, vpos * size, size + 1, size + 1);
#line 1500 "ease-slide-actor.vala"
							anim_x = FALSE;
#line 1501 "ease-slide-actor.vala"
							switch (g_random_int_range ((gint32) 0, (gint32) 4)) {
#line 3180 "ease-slide-actor.c"
								case 0:
								{
#line 1504 "ease-slide-actor.vala"
									clutter_actor_set_x ((ClutterActor*) _data13_->particles[i], ((-(hpos + 1)) * size) - ease_slide_actor_assemble_extra (self));
#line 1505 "ease-slide-actor.vala"
									anim_x = TRUE;
#line 1506 "ease-slide-actor.vala"
									break;
#line 3189 "ease-slide-actor.c"
								}
								case 1:
								{
#line 1508 "ease-slide-actor.vala"
									clutter_actor_set_y ((ClutterActor*) _data13_->particles[i], ((-(vpos + 1)) * size) - ease_slide_actor_assemble_extra (self));
#line 1509 "ease-slide-actor.vala"
									break;
#line 3197 "ease-slide-actor.c"
								}
								case 2:
								{
#line 1511 "ease-slide-actor.vala"
									clutter_actor_set_x ((ClutterActor*) _data13_->particles[i], (((EASE_SLIDE_ACTOR_ASSEMBLE_TILES - hpos) + 1) * size) + ease_slide_actor_assemble_extra (self));
#line 1513 "ease-slide-actor.vala"
									anim_x = TRUE;
#line 1514 "ease-slide-actor.vala"
									break;
#line 3207 "ease-slide-actor.c"
								}
								case 3:
								{
#line 1516 "ease-slide-actor.vala"
									clutter_actor_set_y ((ClutterActor*) _data13_->particles[i], (((v_count - vpos) + 1) * size) + ease_slide_actor_assemble_extra (self));
#line 1518 "ease-slide-actor.vala"
									break;
#line 3215 "ease-slide-actor.c"
								}
							}
							_tmp4_ = NULL;
#line 1522 "ease-slide-actor.vala"
							if (anim_x) {
#line 1522 "ease-slide-actor.vala"
								_tmp4_ = "x";
#line 3223 "ease-slide-actor.c"
							} else {
#line 1522 "ease-slide-actor.vala"
								_tmp4_ = "y";
#line 3227 "ease-slide-actor.c"
							}
#line 1521 "ease-slide-actor.vala"
							clutter_actor_animate ((ClutterActor*) _data13_->particles[i], (gulong) CLUTTER_EASE_IN_OUT_SINE, length, _tmp4_, 0, NULL);
#line 1523 "ease-slide-actor.vala"
							clutter_container_add_actor ((ClutterContainer*) _data13_->container, (ClutterActor*) _data13_->particles[i]);
#line 1524 "ease-slide-actor.vala"
							clutter_actor_show ((ClutterActor*) _data13_->particles[i]);
#line 3235 "ease-slide-actor.c"
						}
					}
				}
			}
		}
	}
#line 1529 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->_animation_time, "completed", (GCallback) __lambda31__clutter_timeline_completed, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
#line 3244 "ease-slide-actor.c"
	block13_data_unref (_data13_);
}


#line 1541 "ease-slide-actor.vala"
static float ease_slide_actor_assemble_extra (EaseSlideActor* self) {
#line 3251 "ease-slide-actor.c"
	float result = 0.0F;
#line 1541 "ease-slide-actor.vala"
	g_return_val_if_fail (self != NULL, 0.0F);
#line 3255 "ease-slide-actor.c"
	result = (float) g_random_int_range ((gint32) 0, (gint32) 1000);
#line 1543 "ease-slide-actor.vala"
	return result;
#line 3259 "ease-slide-actor.c"
}


#line 1546 "ease-slide-actor.vala"
static float ease_slide_actor_explode_dist (EaseSlideActor* self) {
#line 3265 "ease-slide-actor.c"
	float result = 0.0F;
#line 1546 "ease-slide-actor.vala"
	g_return_val_if_fail (self != NULL, 0.0F);
#line 3269 "ease-slide-actor.c"
	result = (float) g_random_int_range ((gint32) 10, (gint32) 200);
#line 1548 "ease-slide-actor.vala"
	return result;
#line 3273 "ease-slide-actor.c"
}


#line 1551 "ease-slide-actor.vala"
static float ease_slide_actor_explode_depth (EaseSlideActor* self) {
#line 3279 "ease-slide-actor.c"
	float result = 0.0F;
#line 1551 "ease-slide-actor.vala"
	g_return_val_if_fail (self != NULL, 0.0F);
#line 3283 "ease-slide-actor.c"
	result = (float) g_random_int_range ((gint32) (-5), (gint32) 50);
#line 1553 "ease-slide-actor.vala"
	return result;
#line 3287 "ease-slide-actor.c"
}


#line 1556 "ease-slide-actor.vala"
static guint ease_slide_actor_explode_time (EaseSlideActor* self, guint time) {
#line 3293 "ease-slide-actor.c"
	guint result = 0U;
#line 1556 "ease-slide-actor.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 3297 "ease-slide-actor.c"
	result = (guint) ((0.25 * time) + ((g_random_double () * 0.75) * time));
#line 1558 "ease-slide-actor.vala"
	return result;
#line 3301 "ease-slide-actor.c"
}


#line 1564 "ease-slide-actor.vala"
static guint8 ease_slide_actor_clamp_opacity (double o) {
#line 3307 "ease-slide-actor.c"
	guint8 result = 0U;
	result = (guint8) ease_dmax ((double) 0, ease_dmin ((double) 255, o));
#line 1566 "ease-slide-actor.vala"
	return result;
#line 3312 "ease-slide-actor.c"
}


#line 25 "ease-slide-actor.vala"
EaseSlideActor* ease_slide_actor_construct (GType object_type) {
#line 3318 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


#line 25 "ease-slide-actor.vala"
EaseSlideActor* ease_slide_actor_new (void) {
#line 25 "ease-slide-actor.vala"
	return ease_slide_actor_construct (EASE_TYPE_SLIDE_ACTOR);
#line 3329 "ease-slide-actor.c"
}


EaseSlide* ease_slide_actor_get_slide (EaseSlideActor* self) {
	EaseSlide* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_slide;
#line 30 "ease-slide-actor.vala"
	return result;
#line 3339 "ease-slide-actor.c"
}


void ease_slide_actor_set_slide (EaseSlideActor* self, EaseSlide* value) {
	g_return_if_fail (self != NULL);
	self->priv->_slide = value;
	g_object_notify ((GObject *) self, "slide");
}


ClutterTimeline* ease_slide_actor_get_animation_time (EaseSlideActor* self) {
	ClutterTimeline* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_animation_time;
#line 62 "ease-slide-actor.vala"
	return result;
#line 3356 "ease-slide-actor.c"
}


void ease_slide_actor_set_animation_time (EaseSlideActor* self, ClutterTimeline* value) {
	ClutterTimeline* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_animation_time = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_animation_time), _tmp0_);
	g_object_notify ((GObject *) self, "animation-time");
}


static ClutterAlpha* ease_slide_actor_get_animation_alpha (EaseSlideActor* self) {
	ClutterAlpha* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_animation_alpha;
#line 63 "ease-slide-actor.vala"
	return result;
#line 3374 "ease-slide-actor.c"
}


static void ease_slide_actor_set_animation_alpha (EaseSlideActor* self, ClutterAlpha* value) {
	ClutterAlpha* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_animation_alpha = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_animation_alpha), _tmp0_);
}


static void ease_slide_actor_class_init (EaseSlideActorClass * klass) {
	ease_slide_actor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseSlideActorPrivate));
	G_OBJECT_CLASS (klass)->get_property = ease_slide_actor_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_slide_actor_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_slide_actor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_ACTOR_SLIDE, g_param_spec_object ("slide", "slide", "slide", EASE_TYPE_SLIDE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_ACTOR_ANIMATION_TIME, g_param_spec_object ("animation-time", "animation-time", "animation-time", CLUTTER_TYPE_TIMELINE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("ease_actor_removed", EASE_TYPE_SLIDE_ACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_ACTOR);
	g_signal_new ("ease_actor_added", EASE_TYPE_SLIDE_ACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_ACTOR);
}


static void ease_slide_actor_instance_init (EaseSlideActor * self) {
	self->priv = EASE_SLIDE_ACTOR_GET_PRIVATE (self);
}


static void ease_slide_actor_finalize (GObject* obj) {
	EaseSlideActor * self;
	self = EASE_SLIDE_ACTOR (obj);
	_g_object_unref0 (self->background);
	_g_object_unref0 (self->contents);
	_g_object_unref0 (self->priv->_animation_time);
	_g_object_unref0 (self->priv->_animation_alpha);
	_g_object_unref0 (self->priv->time1);
	_g_object_unref0 (self->priv->time2);
	_g_object_unref0 (self->priv->alpha1);
	_g_object_unref0 (self->priv->alpha2);
	G_OBJECT_CLASS (ease_slide_actor_parent_class)->finalize (obj);
}


GType ease_slide_actor_get_type (void) {
	static volatile gsize ease_slide_actor_type_id__volatile = 0;
	if (g_once_init_enter (&ease_slide_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseSlideActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_slide_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseSlideActor), 0, (GInstanceInitFunc) ease_slide_actor_instance_init, NULL };
		GType ease_slide_actor_type_id;
		ease_slide_actor_type_id = g_type_register_static (CLUTTER_TYPE_GROUP, "EaseSlideActor", &g_define_type_info, 0);
		g_once_init_leave (&ease_slide_actor_type_id__volatile, ease_slide_actor_type_id);
	}
	return ease_slide_actor_type_id__volatile;
}


static void ease_slide_actor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseSlideActor * self;
	self = EASE_SLIDE_ACTOR (object);
	switch (property_id) {
		case EASE_SLIDE_ACTOR_SLIDE:
		g_value_set_object (value, ease_slide_actor_get_slide (self));
		break;
		case EASE_SLIDE_ACTOR_ANIMATION_TIME:
		g_value_set_object (value, ease_slide_actor_get_animation_time (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_slide_actor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseSlideActor * self;
	self = EASE_SLIDE_ACTOR (object);
	switch (property_id) {
		case EASE_SLIDE_ACTOR_SLIDE:
		ease_slide_actor_set_slide (self, g_value_get_object (value));
		break;
		case EASE_SLIDE_ACTOR_ANIMATION_TIME:
		ease_slide_actor_set_animation_time (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




