/* ease-dialog-progress.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-dialog-progress.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>


#define EASE_DIALOG_TYPE_PROGRESS (ease_dialog_progress_get_type ())
#define EASE_DIALOG_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_DIALOG_TYPE_PROGRESS, EaseDialogProgress))
#define EASE_DIALOG_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_DIALOG_TYPE_PROGRESS, EaseDialogProgressClass))
#define EASE_DIALOG_IS_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_DIALOG_TYPE_PROGRESS))
#define EASE_DIALOG_IS_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_DIALOG_TYPE_PROGRESS))
#define EASE_DIALOG_PROGRESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_DIALOG_TYPE_PROGRESS, EaseDialogProgressClass))

typedef struct _EaseDialogProgress EaseDialogProgress;
typedef struct _EaseDialogProgressClass EaseDialogProgressClass;
typedef struct _EaseDialogProgressPrivate EaseDialogProgressPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _EaseDialogProgress {
	GObject parent_instance;
	EaseDialogProgressPrivate * priv;
};

struct _EaseDialogProgressClass {
	GObjectClass parent_class;
};

struct _EaseDialogProgressPrivate {
	GtkDialog* dialog;
	GtkButton* cancel;
	GtkProgressBar* progress;
	double max_val;
	gboolean destroyed;
	GtkBuilder* builder;
};


static gpointer ease_dialog_progress_parent_class = NULL;

GType ease_dialog_progress_get_type (void) G_GNUC_CONST;
#define EASE_DIALOG_PROGRESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_DIALOG_TYPE_PROGRESS, EaseDialogProgressPrivate))
enum  {
	EASE_DIALOG_PROGRESS_DUMMY_PROPERTY
};
#define EASE_DIALOG_PROGRESS_UI_FILE "progress-dialog.ui"
EaseDialogProgress* ease_dialog_progress_new (const char* title, gboolean cancellable, double max, GtkWindow* modal);
EaseDialogProgress* ease_dialog_progress_construct (GType object_type, const char* title, gboolean cancellable, double max, GtkWindow* modal);
char* ease_data_path (const char* path);
#define EASE_TEMP_UI_DIR "ui"
EaseDialogProgress* ease_dialog_progress_new_with_image (const char* title, gboolean cancellable, double max, GtkWindow* modal, GtkImage* image);
EaseDialogProgress* ease_dialog_progress_construct_with_image (GType object_type, const char* title, gboolean cancellable, double max, GtkWindow* modal, GtkImage* image);
void ease_dialog_progress_show (EaseDialogProgress* self);
void ease_dialog_progress_destroy (EaseDialogProgress* self);
void ease_dialog_progress_set_label (EaseDialogProgress* self, const char* str);
void ease_dialog_progress_set (EaseDialogProgress* self, double val);
void ease_dialog_progress_set_fraction (EaseDialogProgress* self, double val);
void ease_dialog_progress_add (EaseDialogProgress* self, double val);
void ease_dialog_progress_add_fraction (EaseDialogProgress* self, double val);
static void ease_dialog_progress_finalize (GObject* obj);



/**
 * Creates a progress dialog.
 *
 * @param title The title of the dialog.
 * @param cancellable If the dialog should display a cancel button.
 * @param max The maximum value of the dialog.
 * @param modal The window the dialog should be modal for, or null.
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 43 "ease-dialog-progress.vala"
EaseDialogProgress* ease_dialog_progress_construct (GType object_type, const char* title, gboolean cancellable, double max, GtkWindow* modal) {
#line 104 "ease-dialog-progress.c"
	EaseDialogProgress * self;
	GtkBuilder* _tmp0_;
	GObject* _tmp3_;
	GtkDialog* _tmp4_;
	GObject* _tmp5_;
	GtkButton* _tmp6_;
	GObject* _tmp7_;
	GtkProgressBar* _tmp8_;
	GError * _inner_error_ = NULL;
#line 43 "ease-dialog-progress.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 43 "ease-dialog-progress.vala"
	self = (EaseDialogProgress*) g_object_new (object_type, NULL);
#line 46 "ease-dialog-progress.vala"
	self->priv->max_val = max;
#line 48 "ease-dialog-progress.vala"
	self->priv->builder = (_tmp0_ = gtk_builder_new (), _g_object_unref0 (self->priv->builder), _tmp0_);
#line 122 "ease-dialog-progress.c"
	{
		char* _tmp1_;
		char* _tmp2_;
#line 51 "ease-dialog-progress.vala"
		gtk_builder_add_from_file (self->priv->builder, _tmp2_ = ease_data_path (_tmp1_ = g_build_filename (EASE_TEMP_UI_DIR, EASE_DIALOG_PROGRESS_UI_FILE, NULL)), &_inner_error_);
#line 128 "ease-dialog-progress.c"
		_g_free0 (_tmp2_);
		_g_free0 (_tmp1_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 54 "ease-dialog-progress.vala"
			g_error ("ease-dialog-progress.vala:54: Error loading UI: %s", e->message);
#line 144 "ease-dialog-progress.c"
			_g_error_free0 (e);
		}
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 57 "ease-dialog-progress.vala"
	self->priv->dialog = (_tmp4_ = _g_object_ref0 ((_tmp3_ = gtk_builder_get_object (self->priv->builder, "dialog"), GTK_IS_DIALOG (_tmp3_) ? ((GtkDialog*) _tmp3_) : NULL)), _g_object_unref0 (self->priv->dialog), _tmp4_);
#line 58 "ease-dialog-progress.vala"
	self->priv->cancel = (_tmp6_ = _g_object_ref0 ((_tmp5_ = gtk_builder_get_object (self->priv->builder, "cancel"), GTK_IS_BUTTON (_tmp5_) ? ((GtkButton*) _tmp5_) : NULL)), _g_object_unref0 (self->priv->cancel), _tmp6_);
#line 59 "ease-dialog-progress.vala"
	self->priv->progress = (_tmp8_ = _g_object_ref0 ((_tmp7_ = gtk_builder_get_object (self->priv->builder, "progress"), GTK_IS_PROGRESS_BAR (_tmp7_) ? ((GtkProgressBar*) _tmp7_) : NULL)), _g_object_unref0 (self->priv->progress), _tmp8_);
#line 62 "ease-dialog-progress.vala"
	gtk_window_set_title ((GtkWindow*) self->priv->dialog, title);
#line 63 "ease-dialog-progress.vala"
	gtk_widget_set_visible ((GtkWidget*) self->priv->cancel, cancellable);
#line 164 "ease-dialog-progress.c"
	return self;
}


#line 43 "ease-dialog-progress.vala"
EaseDialogProgress* ease_dialog_progress_new (const char* title, gboolean cancellable, double max, GtkWindow* modal) {
#line 43 "ease-dialog-progress.vala"
	return ease_dialog_progress_construct (EASE_DIALOG_TYPE_PROGRESS, title, cancellable, max, modal);
#line 173 "ease-dialog-progress.c"
}


/**
 * Creates a progress dialog with an image on the left side. Although
 * this is a dialog, Gtk.IconSize.LARGE_TOOLBAR should be used if the icon
 * is a stock item.
 *
 * @param title The title of the dialog.
 * @param cancellable If the dialog should display a cancel button.
 * @param max The maximum value of the dialog.
 * @param modal The window the dialog should be modal for, or null.
 * @param image The image widget.
 */
#line 77 "ease-dialog-progress.vala"
EaseDialogProgress* ease_dialog_progress_construct_with_image (GType object_type, const char* title, gboolean cancellable, double max, GtkWindow* modal, GtkImage* image) {
#line 190 "ease-dialog-progress.c"
	EaseDialogProgress * self;
	GObject* _tmp0_;
	GtkHBox* hbox;
	GtkAlignment* align;
#line 77 "ease-dialog-progress.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 77 "ease-dialog-progress.vala"
	g_return_val_if_fail (image != NULL, NULL);
#line 80 "ease-dialog-progress.vala"
	self = (EaseDialogProgress*) ease_dialog_progress_construct (object_type, title, cancellable, max, modal);
#line 83 "ease-dialog-progress.vala"
	hbox = _g_object_ref0 ((_tmp0_ = gtk_builder_get_object (self->priv->builder, "hbox"), GTK_IS_HBOX (_tmp0_) ? ((GtkHBox*) _tmp0_) : NULL));
#line 84 "ease-dialog-progress.vala"
	align = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, (float) 0, (float) 0));
#line 85 "ease-dialog-progress.vala"
	gtk_alignment_set_padding (align, (guint) 0, (guint) 0, (guint) 4, (guint) 4);
#line 86 "ease-dialog-progress.vala"
	gtk_container_add ((GtkContainer*) align, (GtkWidget*) image);
#line 87 "ease-dialog-progress.vala"
	gtk_widget_show ((GtkWidget*) align);
#line 88 "ease-dialog-progress.vala"
	gtk_widget_show ((GtkWidget*) image);
#line 89 "ease-dialog-progress.vala"
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) align, FALSE, FALSE, (guint) 0);
#line 215 "ease-dialog-progress.c"
	_g_object_unref0 (align);
	_g_object_unref0 (hbox);
	return self;
}


#line 77 "ease-dialog-progress.vala"
EaseDialogProgress* ease_dialog_progress_new_with_image (const char* title, gboolean cancellable, double max, GtkWindow* modal, GtkImage* image) {
#line 77 "ease-dialog-progress.vala"
	return ease_dialog_progress_construct_with_image (EASE_DIALOG_TYPE_PROGRESS, title, cancellable, max, modal, image);
#line 226 "ease-dialog-progress.c"
}


/**
 * Shows the progress dialog.
 */
#line 95 "ease-dialog-progress.vala"
void ease_dialog_progress_show (EaseDialogProgress* self) {
#line 95 "ease-dialog-progress.vala"
	g_return_if_fail (self != NULL);
#line 99 "ease-dialog-progress.vala"
	if (!self->priv->destroyed) {
#line 99 "ease-dialog-progress.vala"
		gtk_widget_show_now ((GtkWidget*) self->priv->dialog);
#line 241 "ease-dialog-progress.c"
	}
}


/**
 * Hides the progress dialog.
 */
#line 105 "ease-dialog-progress.vala"
void ease_dialog_progress_destroy (EaseDialogProgress* self) {
#line 105 "ease-dialog-progress.vala"
	g_return_if_fail (self != NULL);
#line 107 "ease-dialog-progress.vala"
	self->priv->destroyed = TRUE;
#line 108 "ease-dialog-progress.vala"
	gtk_object_destroy ((GtkObject*) self->priv->dialog);
#line 257 "ease-dialog-progress.c"
}


/**
 * Sets (or unsets with null) the label of this dialog.
 */
#line 114 "ease-dialog-progress.vala"
void ease_dialog_progress_set_label (EaseDialogProgress* self, const char* str) {
#line 114 "ease-dialog-progress.vala"
	g_return_if_fail (self != NULL);
#line 116 "ease-dialog-progress.vala"
	gtk_progress_bar_set_text (self->priv->progress, str);
#line 270 "ease-dialog-progress.c"
}


/**
 * Sets the dialog's progress to a value relative to the maximum, specified
 * in the constructor.
 */
#line 123 "ease-dialog-progress.vala"
void ease_dialog_progress_set (EaseDialogProgress* self, double val) {
#line 123 "ease-dialog-progress.vala"
	g_return_if_fail (self != NULL);
#line 125 "ease-dialog-progress.vala"
	gtk_progress_bar_set_fraction (self->priv->progress, val / self->priv->max_val);
#line 284 "ease-dialog-progress.c"
}


/**
 * Sets the dialog's progress to a fraction between 0 and 1.
 */
#line 131 "ease-dialog-progress.vala"
void ease_dialog_progress_set_fraction (EaseDialogProgress* self, double val) {
#line 131 "ease-dialog-progress.vala"
	g_return_if_fail (self != NULL);
#line 133 "ease-dialog-progress.vala"
	gtk_progress_bar_set_fraction (self->priv->progress, val);
#line 297 "ease-dialog-progress.c"
}


/**
 * Adds a value, relative to the maximum specified in the constructor, to
 * the progress bar.
 */
#line 140 "ease-dialog-progress.vala"
void ease_dialog_progress_add (EaseDialogProgress* self, double val) {
#line 140 "ease-dialog-progress.vala"
	g_return_if_fail (self != NULL);
#line 142 "ease-dialog-progress.vala"
	gtk_progress_bar_set_fraction (self->priv->progress, gtk_progress_bar_get_fraction (self->priv->progress) + (val / self->priv->max_val));
#line 311 "ease-dialog-progress.c"
}


/**
 * Adds a fractional value to the progress bar.
 */
#line 148 "ease-dialog-progress.vala"
void ease_dialog_progress_add_fraction (EaseDialogProgress* self, double val) {
#line 148 "ease-dialog-progress.vala"
	g_return_if_fail (self != NULL);
#line 150 "ease-dialog-progress.vala"
	gtk_progress_bar_set_fraction (self->priv->progress, gtk_progress_bar_get_fraction (self->priv->progress) + val);
#line 324 "ease-dialog-progress.c"
}


static void ease_dialog_progress_class_init (EaseDialogProgressClass * klass) {
	ease_dialog_progress_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseDialogProgressPrivate));
	G_OBJECT_CLASS (klass)->finalize = ease_dialog_progress_finalize;
}


static void ease_dialog_progress_instance_init (EaseDialogProgress * self) {
	self->priv = EASE_DIALOG_PROGRESS_GET_PRIVATE (self);
	self->priv->destroyed = FALSE;
}


static void ease_dialog_progress_finalize (GObject* obj) {
	EaseDialogProgress * self;
	self = EASE_DIALOG_PROGRESS (obj);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->cancel);
	_g_object_unref0 (self->priv->progress);
	_g_object_unref0 (self->priv->builder);
	G_OBJECT_CLASS (ease_dialog_progress_parent_class)->finalize (obj);
}


/**
 * Controls a dialog displaying a progress bar, and optionally a cancel button
 * and label.
 *
 * Note that this class is not a subclass of Gtk.Dialog.
 */
GType ease_dialog_progress_get_type (void) {
	static volatile gsize ease_dialog_progress_type_id__volatile = 0;
	if (g_once_init_enter (&ease_dialog_progress_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseDialogProgressClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_dialog_progress_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseDialogProgress), 0, (GInstanceInitFunc) ease_dialog_progress_instance_init, NULL };
		GType ease_dialog_progress_type_id;
		ease_dialog_progress_type_id = g_type_register_static (G_TYPE_OBJECT, "EaseDialogProgress", &g_define_type_info, 0);
		g_once_init_leave (&ease_dialog_progress_type_id__volatile, ease_dialog_progress_type_id);
	}
	return ease_dialog_progress_type_id__volatile;
}




