/* ease-import-dialog.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-import-dialog.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <ease-core.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>


#define EASE_TYPE_IMPORT_DIALOG (ease_import_dialog_get_type ())
#define EASE_IMPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_IMPORT_DIALOG, EaseImportDialog))
#define EASE_IMPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_IMPORT_DIALOG, EaseImportDialogClass))
#define EASE_IS_IMPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_IMPORT_DIALOG))
#define EASE_IS_IMPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_IMPORT_DIALOG))
#define EASE_IMPORT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_IMPORT_DIALOG, EaseImportDialogClass))

typedef struct _EaseImportDialog EaseImportDialog;
typedef struct _EaseImportDialogClass EaseImportDialogClass;
typedef struct _EaseImportDialogPrivate EaseImportDialogPrivate;

#define EASE_TYPE_FLICKR_SERVICE (ease_flickr_service_get_type ())
#define EASE_FLICKR_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_FLICKR_SERVICE, EaseFlickrService))
#define EASE_FLICKR_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_FLICKR_SERVICE, EaseFlickrServiceClass))
#define EASE_IS_FLICKR_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_FLICKR_SERVICE))
#define EASE_IS_FLICKR_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_FLICKR_SERVICE))
#define EASE_FLICKR_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_FLICKR_SERVICE, EaseFlickrServiceClass))

typedef struct _EaseFlickrService EaseFlickrService;
typedef struct _EaseFlickrServiceClass EaseFlickrServiceClass;

#define EASE_TYPE_OCA_SERVICE (ease_oca_service_get_type ())
#define EASE_OCA_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_OCA_SERVICE, EaseOCAService))
#define EASE_OCA_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_OCA_SERVICE, EaseOCAServiceClass))
#define EASE_IS_OCA_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_OCA_SERVICE))
#define EASE_IS_OCA_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_OCA_SERVICE))
#define EASE_OCA_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_OCA_SERVICE, EaseOCAServiceClass))

typedef struct _EaseOCAService EaseOCAService;
typedef struct _EaseOCAServiceClass EaseOCAServiceClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define EASE_TYPE_IMPORT_WIDGET (ease_import_widget_get_type ())
#define EASE_IMPORT_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_IMPORT_WIDGET, EaseImportWidget))
#define EASE_IMPORT_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_IMPORT_WIDGET, EaseImportWidgetClass))
#define EASE_IS_IMPORT_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_IMPORT_WIDGET))
#define EASE_IS_IMPORT_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_IMPORT_WIDGET))
#define EASE_IMPORT_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_IMPORT_WIDGET, EaseImportWidgetClass))

typedef struct _EaseImportWidget EaseImportWidget;
typedef struct _EaseImportWidgetClass EaseImportWidgetClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
typedef struct _Block4Data Block4Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;

struct _EaseImportDialog {
	GtkWindow parent_instance;
	EaseImportDialogPrivate * priv;
};

struct _EaseImportDialogClass {
	GtkWindowClass parent_class;
};

struct _EaseImportDialogPrivate {
	gint total_images;
};

struct _Block2Data {
	int _ref_count_;
	EaseImportDialog * self;
	SourceSpinnerItem* item;
};

struct _Block4Data {
	int _ref_count_;
	Block3Data * _data3_;
	double previous;
};

struct _Block3Data {
	int _ref_count_;
	EaseImportDialog * self;
	GFile* copy;
	EaseDialogProgress* progress;
	GeeQueue* media_list;
	char* temp;
	gint i;
};


static gpointer ease_import_dialog_parent_class = NULL;

GType ease_import_dialog_get_type (void) G_GNUC_CONST;
#define EASE_IMPORT_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_IMPORT_DIALOG, EaseImportDialogPrivate))
enum  {
	EASE_IMPORT_DIALOG_DUMMY_PROPERTY
};
#define EASE_IMPORT_DIALOG_PROGRESS_FORMAT _ ("Downloading image %i of %i")
EaseImportDialog* ease_import_dialog_new (void);
EaseImportDialog* ease_import_dialog_construct (GType object_type);
EaseFlickrService* ease_flickr_service_new (void);
EaseFlickrService* ease_flickr_service_construct (GType object_type);
GType ease_flickr_service_get_type (void) G_GNUC_CONST;
static SourceItem* ease_import_dialog_create_item (EaseImportDialog* self, const char* title, const char* stock_id, EasePluginImportService* service);
EaseOCAService* ease_oca_service_new (void);
EaseOCAService* ease_oca_service_construct (GType object_type);
GType ease_oca_service_get_type (void) G_GNUC_CONST;
void ease_import_dialog_run (EaseImportDialog* self);
EaseImportWidget* ease_import_widget_new (EasePluginImportService* serv);
EaseImportWidget* ease_import_widget_construct (GType object_type, EasePluginImportService* serv);
GType ease_import_widget_get_type (void) G_GNUC_CONST;
static void _lambda84_ (GeeQueue* media_list, EaseImportDialog* self);
static void ease_import_dialog_add_media_recursive (EaseImportDialog* self, EaseDialogProgress* progress, GeeQueue* media_list, const char* temp, gint i);
static void __lambda84__ease_import_widget_add_media (EaseImportWidget* _sender, GeeQueue* media_list, gpointer self);
static void _lambda87_ (Block2Data* _data2_);
static void __lambda87__ease_plugin_import_service_started (EasePluginImportService* _sender, gpointer self);
static void _lambda88_ (Block2Data* _data2_);
static void __lambda88__ease_plugin_import_service_no_results (EasePluginImportService* _sender, gpointer self);
static void _lambda89_ (Block2Data* _data2_);
static void __lambda89__ease_plugin_import_service_loading_complete (EasePluginImportService* _sender, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void _lambda85_ (gint64 current, gint64 total, Block4Data* _data4_);
static void __lambda85__gfile_progress_callback (gint64 current_num_bytes, gint64 total_num_bytes, gpointer self);
static void _lambda86_ (GObject* sender, GAsyncResult* _result_, Block4Data* _data4_);
static void __lambda86__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void ease_import_dialog_finalize (GObject* obj);



#line 26 "ease-import-dialog.vala"
EaseImportDialog* ease_import_dialog_construct (GType object_type) {
#line 164 "ease-import-dialog.c"
	EaseImportDialog * self;
	SourceView* view;
	SourceGroup* group;
	EasePluginImportService* service;
	SourceItem* flickr;
	EasePluginImportService* _tmp0_;
	SourceItem* _tmp1_;
	self = g_object_newv (object_type, 0, NULL);
#line 28 "ease-import-dialog.vala"
	gtk_window_set_title ((GtkWindow*) self, _ ("Import Media"));
#line 29 "ease-import-dialog.vala"
	gtk_window_set_default_size ((GtkWindow*) self, 640, 480);
#line 32 "ease-import-dialog.vala"
	view = g_object_ref_sink (source_view_new ());
#line 33 "ease-import-dialog.vala"
	group = g_object_ref_sink (source_group_new (_ ("Images")));
#line 34 "ease-import-dialog.vala"
	source_base_view_add_group ((SourceBaseView*) view, (SourceBaseGroup*) group);
#line 35 "ease-import-dialog.vala"
	gtk_widget_show_all ((GtkWidget*) view);
#line 37 "ease-import-dialog.vala"
	service = (EasePluginImportService*) ease_flickr_service_new ();
#line 38 "ease-import-dialog.vala"
	flickr = ease_import_dialog_create_item (self, "Flickr", "gtk-go-down", service);
#line 39 "ease-import-dialog.vala"
	source_base_group_add_item ((SourceBaseGroup*) group, flickr);
#line 40 "ease-import-dialog.vala"
	service = (_tmp0_ = (EasePluginImportService*) ease_oca_service_new (), _g_object_unref0 (service), _tmp0_);
#line 41 "ease-import-dialog.vala"
	source_base_group_add_item ((SourceBaseGroup*) group, _tmp1_ = ease_import_dialog_create_item (self, "OpenClipArt", "gtk-go-down", service));
#line 195 "ease-import-dialog.c"
	_g_object_unref0 (_tmp1_);
#line 43 "ease-import-dialog.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) view);
#line 44 "ease-import-dialog.vala"
	gtk_widget_show_all ((GtkWidget*) view);
#line 45 "ease-import-dialog.vala"
	source_item_select (flickr);
#line 203 "ease-import-dialog.c"
	_g_object_unref0 (flickr);
	_g_object_unref0 (service);
	_g_object_unref0 (group);
	_g_object_unref0 (view);
	return self;
}


#line 26 "ease-import-dialog.vala"
EaseImportDialog* ease_import_dialog_new (void) {
#line 26 "ease-import-dialog.vala"
	return ease_import_dialog_construct (EASE_TYPE_IMPORT_DIALOG);
#line 216 "ease-import-dialog.c"
}


#line 48 "ease-import-dialog.vala"
void ease_import_dialog_run (EaseImportDialog* self) {
#line 48 "ease-import-dialog.vala"
	g_return_if_fail (self != NULL);
#line 50 "ease-import-dialog.vala"
	gtk_widget_show ((GtkWidget*) self);
#line 226 "ease-import-dialog.c"
}


#line 60 "ease-import-dialog.vala"
static void _lambda84_ (GeeQueue* media_list, EaseImportDialog* self) {
#line 232 "ease-import-dialog.c"
	GtkImage* img;
	EaseDialogProgress* progress;
	char* _tmp0_;
	char* _tmp1_;
	GError * _inner_error_ = NULL;
#line 60 "ease-import-dialog.vala"
	g_return_if_fail (media_list != NULL);
#line 61 "ease-import-dialog.vala"
	img = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock ("gtk-go-down", GTK_ICON_SIZE_LARGE_TOOLBAR));
#line 63 "ease-import-dialog.vala"
	progress = ease_dialog_progress_new_with_image (_ ("Downloading Media Files"), FALSE, (double) gee_collection_get_size ((GeeCollection*) media_list), (GtkWindow*) self, img);
#line 66 "ease-import-dialog.vala"
	ease_dialog_progress_show (progress);
#line 67 "ease-import-dialog.vala"
	self->priv->total_images = gee_collection_get_size ((GeeCollection*) media_list);
#line 68 "ease-import-dialog.vala"
	_tmp0_ = ease_temp_request (&_inner_error_);
#line 250 "ease-import-dialog.c"
	if (_inner_error_ != NULL) {
		_g_object_unref0 (progress);
		_g_object_unref0 (img);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
#line 68 "ease-import-dialog.vala"
	ease_import_dialog_add_media_recursive (self, progress, media_list, _tmp1_ = _tmp0_, 0);
#line 260 "ease-import-dialog.c"
	_g_free0 (_tmp1_);
	_g_object_unref0 (progress);
	_g_object_unref0 (img);
}


#line 60 "ease-import-dialog.vala"
static void __lambda84__ease_import_widget_add_media (EaseImportWidget* _sender, GeeQueue* media_list, gpointer self) {
#line 269 "ease-import-dialog.c"
	_lambda84_ (media_list, self);
}


#line 71 "ease-import-dialog.vala"
static void _lambda87_ (Block2Data* _data2_) {
#line 276 "ease-import-dialog.c"
	EaseImportDialog * self;
	self = _data2_->self;
#line 71 "ease-import-dialog.vala"
	source_spinner_item_start (_data2_->item);
#line 281 "ease-import-dialog.c"
}


#line 71 "ease-import-dialog.vala"
static void __lambda87__ease_plugin_import_service_started (EasePluginImportService* _sender, gpointer self) {
#line 287 "ease-import-dialog.c"
	_lambda87_ (self);
}


#line 72 "ease-import-dialog.vala"
static void _lambda88_ (Block2Data* _data2_) {
#line 294 "ease-import-dialog.c"
	EaseImportDialog * self;
	self = _data2_->self;
#line 72 "ease-import-dialog.vala"
	source_spinner_item_stop (_data2_->item);
#line 299 "ease-import-dialog.c"
}


#line 72 "ease-import-dialog.vala"
static void __lambda88__ease_plugin_import_service_no_results (EasePluginImportService* _sender, gpointer self) {
#line 305 "ease-import-dialog.c"
	_lambda88_ (self);
}


#line 73 "ease-import-dialog.vala"
static void _lambda89_ (Block2Data* _data2_) {
#line 312 "ease-import-dialog.c"
	EaseImportDialog * self;
	self = _data2_->self;
#line 73 "ease-import-dialog.vala"
	source_spinner_item_stop (_data2_->item);
#line 317 "ease-import-dialog.c"
}


#line 73 "ease-import-dialog.vala"
static void __lambda89__ease_plugin_import_service_loading_complete (EasePluginImportService* _sender, gpointer self) {
#line 323 "ease-import-dialog.c"
	_lambda89_ (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->item);
		g_slice_free (Block2Data, _data2_);
	}
}


#line 53 "ease-import-dialog.vala"
static SourceItem* ease_import_dialog_create_item (EaseImportDialog* self, const char* title, const char* stock_id, EasePluginImportService* service) {
#line 350 "ease-import-dialog.c"
	SourceItem* result = NULL;
	Block2Data* _data2_;
	EaseImportWidget* widget;
#line 53 "ease-import-dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 53 "ease-import-dialog.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 53 "ease-import-dialog.vala"
	g_return_val_if_fail (stock_id != NULL, NULL);
#line 53 "ease-import-dialog.vala"
	g_return_val_if_fail (service != NULL, NULL);
#line 362 "ease-import-dialog.c"
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
#line 56 "ease-import-dialog.vala"
	widget = g_object_ref_sink (ease_import_widget_new (service));
#line 368 "ease-import-dialog.c"
	_data2_->item = g_object_ref_sink (source_spinner_item_new_from_stock_icon (title, stock_id, (GtkWidget*) widget));
#line 60 "ease-import-dialog.vala"
	g_signal_connect_object (widget, "add-media", (GCallback) __lambda84__ease_import_widget_add_media, self, 0);
#line 71 "ease-import-dialog.vala"
	g_signal_connect_data (service, "started", (GCallback) __lambda87__ease_plugin_import_service_started, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 72 "ease-import-dialog.vala"
	g_signal_connect_data (service, "no-results", (GCallback) __lambda88__ease_plugin_import_service_no_results, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 73 "ease-import-dialog.vala"
	g_signal_connect_data (service, "loading-complete", (GCallback) __lambda89__ease_plugin_import_service_loading_complete, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 378 "ease-import-dialog.c"
	result = _g_object_ref0 ((SourceItem*) _data2_->item);
	_g_object_unref0 (widget);
	block2_data_unref (_data2_);
#line 75 "ease-import-dialog.vala"
	return result;
#line 384 "ease-import-dialog.c"
}


#line 100 "ease-import-dialog.vala"
static void _lambda85_ (gint64 current, gint64 total, Block4Data* _data4_) {
#line 390 "ease-import-dialog.c"
	Block3Data* _data3_;
	EaseImportDialog * self;
	_data3_ = _data4_->_data3_;
	self = _data3_->self;
#line 101 "ease-import-dialog.vala"
	ease_dialog_progress_add (_data3_->progress, (((double) current) - _data4_->previous) / ((double) total));
#line 102 "ease-import-dialog.vala"
	_data4_->previous = (double) current;
#line 399 "ease-import-dialog.c"
}


#line 100 "ease-import-dialog.vala"
static void __lambda85__gfile_progress_callback (gint64 current_num_bytes, gint64 total_num_bytes, gpointer self) {
#line 405 "ease-import-dialog.c"
	_lambda85_ (current_num_bytes, total_num_bytes, self);
}


#line 104 "ease-import-dialog.vala"
static void _lambda86_ (GObject* sender, GAsyncResult* _result_, Block4Data* _data4_) {
#line 412 "ease-import-dialog.c"
	Block3Data* _data3_;
	EaseImportDialog * self;
	char* _tmp0_;
	_data3_ = _data4_->_data3_;
	self = _data3_->self;
#line 104 "ease-import-dialog.vala"
	g_return_if_fail (_result_ != NULL);
#line 105 "ease-import-dialog.vala"
	g_signal_emit_by_name (self, "add-image", _tmp0_ = g_file_get_path (_data3_->copy));
#line 422 "ease-import-dialog.c"
	_g_free0 (_tmp0_);
#line 106 "ease-import-dialog.vala"
	ease_import_dialog_add_media_recursive (self, _data3_->progress, _data3_->media_list, _data3_->temp, _data3_->i);
#line 426 "ease-import-dialog.c"
}


#line 104 "ease-import-dialog.vala"
static void __lambda86__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 432 "ease-import-dialog.c"
	_lambda86_ (source_object, res, self);
	block4_data_unref (self);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		block3_data_unref (_data4_->_data3_);
		g_slice_free (Block4Data, _data4_);
	}
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_object_unref0 (_data3_->copy);
		_g_object_unref0 (_data3_->progress);
		_g_object_unref0 (_data3_->media_list);
		_g_free0 (_data3_->temp);
		g_slice_free (Block3Data, _data3_);
	}
}


#line 78 "ease-import-dialog.vala"
static void ease_import_dialog_add_media_recursive (EaseImportDialog* self, EaseDialogProgress* progress, GeeQueue* media_list, const char* temp, gint i) {
#line 472 "ease-import-dialog.c"
	Block3Data* _data3_;
	char* _tmp0_;
	EasePluginImportMedia* _tmp1_;
	GFile* _tmp2_;
	GFile* file;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	GFile* _tmp6_;
	GError * _inner_error_ = NULL;
#line 78 "ease-import-dialog.vala"
	g_return_if_fail (self != NULL);
#line 78 "ease-import-dialog.vala"
	g_return_if_fail (progress != NULL);
#line 78 "ease-import-dialog.vala"
	g_return_if_fail (media_list != NULL);
#line 78 "ease-import-dialog.vala"
	g_return_if_fail (temp != NULL);
#line 491 "ease-import-dialog.c"
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->progress = _g_object_ref0 (progress);
	_data3_->media_list = _g_object_ref0 (media_list);
	_data3_->temp = g_strdup (temp);
	_data3_->i = i;
#line 82 "ease-import-dialog.vala"
	if (gee_collection_get_size ((GeeCollection*) _data3_->media_list) == 0) {
#line 84 "ease-import-dialog.vala"
		ease_dialog_progress_destroy (_data3_->progress);
#line 503 "ease-import-dialog.c"
		block3_data_unref (_data3_);
#line 85 "ease-import-dialog.vala"
		return;
#line 507 "ease-import-dialog.c"
	}
#line 89 "ease-import-dialog.vala"
	ease_dialog_progress_set_label (_data3_->progress, _tmp0_ = g_strdup_printf (EASE_IMPORT_DIALOG_PROGRESS_FORMAT, _data3_->i + 1, self->priv->total_images));
#line 511 "ease-import-dialog.c"
	_g_free0 (_tmp0_);
#line 91 "ease-import-dialog.vala"
	file = (_tmp2_ = g_file_new_for_uri ((_tmp1_ = (EasePluginImportMedia*) gee_queue_poll (_data3_->media_list))->file_link), _g_object_unref0 (_tmp1_), _tmp2_);
#line 515 "ease-import-dialog.c"
	_data3_->copy = (_tmp6_ = g_file_new_for_path (_tmp5_ = g_build_filename (_data3_->temp, _tmp4_ = g_strconcat ("media", _tmp3_ = g_strdup_printf ("%i", _data3_->i++), NULL), NULL)), _g_free0 (_tmp5_), _g_free0 (_tmp4_), _g_free0 (_tmp3_), _tmp6_);
	{
		Block4Data* _data4_;
		_data4_ = g_slice_new0 (Block4Data);
		_data4_->_ref_count_ = 1;
		_data4_->_data3_ = block3_data_ref (_data3_);
		_data4_->previous = (double) 0;
#line 98 "ease-import-dialog.vala"
		g_file_copy_async (file, _data3_->copy, G_FILE_COPY_OVERWRITE, G_PRIORITY_DEFAULT, NULL, __lambda85__gfile_progress_callback, _data4_, __lambda86__gasync_ready_callback, block4_data_ref (_data4_));
#line 525 "ease-import-dialog.c"
		block4_data_unref (_data4_);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 111 "ease-import-dialog.vala"
			g_critical ("ease-import-dialog.vala:111: Couldn't read file: %s", e->message);
#line 537 "ease-import-dialog.c"
			_g_error_free0 (e);
			_g_object_unref0 (file);
			block3_data_unref (_data3_);
#line 112 "ease-import-dialog.vala"
			return;
#line 543 "ease-import-dialog.c"
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		block3_data_unref (_data3_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (file);
	block3_data_unref (_data3_);
}


static void ease_import_dialog_class_init (EaseImportDialogClass * klass) {
	ease_import_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseImportDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = ease_import_dialog_finalize;
	g_signal_new ("add_image", EASE_TYPE_IMPORT_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void ease_import_dialog_instance_init (EaseImportDialog * self) {
	self->priv = EASE_IMPORT_DIALOG_GET_PRIVATE (self);
}


static void ease_import_dialog_finalize (GObject* obj) {
	EaseImportDialog * self;
	self = EASE_IMPORT_DIALOG (obj);
	G_OBJECT_CLASS (ease_import_dialog_parent_class)->finalize (obj);
}


GType ease_import_dialog_get_type (void) {
	static volatile gsize ease_import_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&ease_import_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseImportDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_import_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseImportDialog), 0, (GInstanceInitFunc) ease_import_dialog_instance_init, NULL };
		GType ease_import_dialog_type_id;
		ease_import_dialog_type_id = g_type_register_static (GTK_TYPE_WINDOW, "EaseImportDialog", &g_define_type_info, 0);
		g_once_init_leave (&ease_import_dialog_type_id__volatile, ease_import_dialog_type_id);
	}
	return ease_import_dialog_type_id__volatile;
}




