/* ease-slide-sorter.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-slide-sorter.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <ease-core.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixdata.h>


#define EASE_TYPE_SLIDE_SORTER (ease_slide_sorter_get_type ())
#define EASE_SLIDE_SORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE_SORTER, EaseSlideSorter))
#define EASE_SLIDE_SORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE_SORTER, EaseSlideSorterClass))
#define EASE_IS_SLIDE_SORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE_SORTER))
#define EASE_IS_SLIDE_SORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE_SORTER))
#define EASE_SLIDE_SORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE_SORTER, EaseSlideSorterClass))

typedef struct _EaseSlideSorter EaseSlideSorter;
typedef struct _EaseSlideSorterClass EaseSlideSorterClass;
typedef struct _EaseSlideSorterPrivate EaseSlideSorterPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
typedef struct _Block18Data Block18Data;
#define _ease_iterable_tree_model_iterator_unref0(var) ((var == NULL) ? NULL : (var = (ease_iterable_tree_model_iterator_unref (var), NULL)))

struct _EaseSlideSorter {
	GtkScrolledWindow parent_instance;
	EaseSlideSorterPrivate * priv;
};

struct _EaseSlideSorterClass {
	GtkScrolledWindowClass parent_class;
};

struct _EaseSlideSorterPrivate {
	GtkIconView* view;
	EaseDocument* document;
	gint width;
};

struct _Block18Data {
	int _ref_count_;
	EaseSlideSorter * self;
	EaseSlide* slide;
	EaseSlide* ret_slide;
	GList* slides_to_remove;
};


static gpointer ease_slide_sorter_parent_class = NULL;

GType ease_slide_sorter_get_type (void) G_GNUC_CONST;
#define EASE_SLIDE_SORTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_SLIDE_SORTER, EaseSlideSorterPrivate))
enum  {
	EASE_SLIDE_SORTER_DUMMY_PROPERTY
};
#define EASE_SLIDE_SORTER_WIDTH 100
#define EASE_SLIDE_SORTER_WIDTH_ADDITIONAL 300
EaseSlideSorter* ease_slide_sorter_new (EaseDocument* doc, double zoom);
EaseSlideSorter* ease_slide_sorter_construct (GType object_type, EaseDocument* doc, double zoom);
void ease_slide_sorter_on_slide_added (EaseSlideSorter* self, EaseSlide* slide, gint index);
static void _ease_slide_sorter_on_slide_added_ease_document_slide_added (EaseDocument* _sender, EaseSlide* slide, gint index, gpointer self);
void ease_slide_sorter_set_zoom (EaseSlideSorter* self, double zoom);
static void _lambda50_ (GtkIconView* v, GtkTreePath* path, EaseSlideSorter* self);
static void __lambda50__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self);
EaseSlide* ease_slide_sorter_delete_slide (EaseSlideSorter* self);
static void _lambda51_ (GtkIconView* v, GtkTreePath* path, Block18Data* _data18_);
static void __lambda51__gtk_icon_view_foreach_func (GtkIconView* icon_view, GtkTreePath* path, gpointer self);
static void _lambda52_ (Block18Data* _data18_);
static void __lambda52__gfunc (void* data, gpointer self);
static void _g_list_free_g_object_unref (GList* self);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (Block18Data* _data18_);
GdkPixbuf* ease_slide_button_panel_pixbuf (EaseSlide* slide, gint width);
static void ease_slide_sorter_finalize (GObject* obj);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 97 "ease-slide-sorter.vala"
static void _ease_slide_sorter_on_slide_added_ease_document_slide_added (EaseDocument* _sender, EaseSlide* slide, gint index, gpointer self) {
#line 106 "ease-slide-sorter.c"
	ease_slide_sorter_on_slide_added (self, slide, index);
}


#line 52 "ease-slide-sorter.vala"
static void _lambda50_ (GtkIconView* v, GtkTreePath* path, EaseSlideSorter* self) {
#line 113 "ease-slide-sorter.c"
	GtkTreeIter itr = {0};
	EaseSlide* slide;
#line 52 "ease-slide-sorter.vala"
	g_return_if_fail (v != NULL);
#line 52 "ease-slide-sorter.vala"
	g_return_if_fail (path != NULL);
#line 120 "ease-slide-sorter.c"
	slide = NULL;
#line 55 "ease-slide-sorter.vala"
	gtk_tree_model_get_iter (gtk_icon_view_get_model (self->priv->view), &itr, path);
#line 56 "ease-slide-sorter.vala"
	gtk_tree_model_get (gtk_icon_view_get_model (self->priv->view), &itr, EASE_DOCUMENT_COL_SLIDE, &slide, -1);
#line 57 "ease-slide-sorter.vala"
	g_signal_emit_by_name (self, "display-slide", slide);
#line 128 "ease-slide-sorter.c"
	_g_object_unref0 (slide);
}


#line 52 "ease-slide-sorter.vala"
static void __lambda50__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self) {
#line 135 "ease-slide-sorter.c"
	_lambda50_ (_sender, path, self);
}


#line 32 "ease-slide-sorter.vala"
EaseSlideSorter* ease_slide_sorter_construct (GType object_type, EaseDocument* doc, double zoom) {
#line 142 "ease-slide-sorter.c"
	EaseSlideSorter * self;
	EaseDocument* _tmp0_;
	GtkIconView* _tmp1_;
#line 32 "ease-slide-sorter.vala"
	g_return_val_if_fail (doc != NULL, NULL);
#line 148 "ease-slide-sorter.c"
	self = g_object_newv (object_type, 0, NULL);
#line 34 "ease-slide-sorter.vala"
	self->priv->document = (_tmp0_ = _g_object_ref0 (doc), _g_object_unref0 (self->priv->document), _tmp0_);
#line 35 "ease-slide-sorter.vala"
	g_signal_connect_object (self->priv->document, "slide-added", (GCallback) _ease_slide_sorter_on_slide_added_ease_document_slide_added, self, 0);
#line 38 "ease-slide-sorter.vala"
	ease_slide_sorter_set_zoom (self, zoom);
#line 41 "ease-slide-sorter.vala"
	self->priv->view = (_tmp1_ = g_object_ref_sink ((GtkIconView*) gtk_icon_view_new_with_model ((GtkTreeModel*) ease_document_get_slides (self->priv->document))), _g_object_unref0 (self->priv->view), _tmp1_);
#line 42 "ease-slide-sorter.vala"
	gtk_icon_view_set_pixbuf_column (self->priv->view, EASE_DOCUMENT_COL_PIXBUF_DYNAMIC);
#line 43 "ease-slide-sorter.vala"
	gtk_icon_view_set_markup_column (self->priv->view, EASE_DOCUMENT_COL_TITLE);
#line 44 "ease-slide-sorter.vala"
	gtk_icon_view_set_reorderable (self->priv->view, TRUE);
#line 45 "ease-slide-sorter.vala"
	gtk_icon_view_set_item_width (self->priv->view, EASE_SLIDE_SORTER_WIDTH);
#line 48 "ease-slide-sorter.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->view);
#line 49 "ease-slide-sorter.vala"
	gtk_widget_show ((GtkWidget*) self->priv->view);
#line 52 "ease-slide-sorter.vala"
	g_signal_connect_object (self->priv->view, "item-activated", (GCallback) __lambda50__gtk_icon_view_item_activated, self, 0);
#line 172 "ease-slide-sorter.c"
	return self;
}


#line 32 "ease-slide-sorter.vala"
EaseSlideSorter* ease_slide_sorter_new (EaseDocument* doc, double zoom) {
#line 32 "ease-slide-sorter.vala"
	return ease_slide_sorter_construct (EASE_TYPE_SLIDE_SORTER, doc, zoom);
#line 181 "ease-slide-sorter.c"
}


#line 66 "ease-slide-sorter.vala"
static void _lambda51_ (GtkIconView* v, GtkTreePath* path, Block18Data* _data18_) {
#line 187 "ease-slide-sorter.c"
	EaseSlideSorter * self;
	GtkTreeIter itr = {0};
	self = _data18_->self;
#line 66 "ease-slide-sorter.vala"
	g_return_if_fail (v != NULL);
#line 66 "ease-slide-sorter.vala"
	g_return_if_fail (path != NULL);
#line 68 "ease-slide-sorter.vala"
	gtk_tree_model_get_iter (gtk_icon_view_get_model (self->priv->view), &itr, path);
#line 69 "ease-slide-sorter.vala"
	gtk_tree_model_get (gtk_icon_view_get_model (self->priv->view), &itr, EASE_DOCUMENT_COL_SLIDE, &_data18_->slide, -1);
#line 70 "ease-slide-sorter.vala"
	_data18_->slides_to_remove = g_list_append (_data18_->slides_to_remove, _g_object_ref0 (_data18_->slide));
#line 201 "ease-slide-sorter.c"
}


#line 66 "ease-slide-sorter.vala"
static void __lambda51__gtk_icon_view_foreach_func (GtkIconView* icon_view, GtkTreePath* path, gpointer self) {
#line 207 "ease-slide-sorter.c"
	_lambda51_ (icon_view, path, self);
}


#line 73 "ease-slide-sorter.vala"
static void _lambda52_ (Block18Data* _data18_) {
#line 214 "ease-slide-sorter.c"
	EaseSlideSorter * self;
	EaseSlide* _tmp0_;
	self = _data18_->self;
#line 74 "ease-slide-sorter.vala"
	if (ease_document_get_length (self->priv->document) < 2) {
#line 74 "ease-slide-sorter.vala"
		return;
#line 222 "ease-slide-sorter.c"
	}
#line 75 "ease-slide-sorter.vala"
	_data18_->ret_slide = (_tmp0_ = ease_document_remove_slide (self->priv->document, _data18_->slide), _g_object_unref0 (_data18_->ret_slide), _tmp0_);
#line 226 "ease-slide-sorter.c"
}


#line 73 "ease-slide-sorter.vala"
static void __lambda52__gfunc (void* data, gpointer self) {
#line 232 "ease-slide-sorter.c"
	_lambda52_ (self);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static Block18Data* block18_data_ref (Block18Data* _data18_) {
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}


static void block18_data_unref (Block18Data* _data18_) {
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		_g_object_unref0 (_data18_->self);
		__g_list_free_g_object_unref0 (_data18_->slides_to_remove);
		_g_object_unref0 (_data18_->ret_slide);
		_g_object_unref0 (_data18_->slide);
		g_slice_free (Block18Data, _data18_);
	}
}


#line 61 "ease-slide-sorter.vala"
EaseSlide* ease_slide_sorter_delete_slide (EaseSlideSorter* self) {
#line 262 "ease-slide-sorter.c"
	EaseSlide* result = NULL;
	Block18Data* _data18_;
#line 61 "ease-slide-sorter.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 267 "ease-slide-sorter.c"
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->self = g_object_ref (self);
	_data18_->slide = NULL;
	_data18_->ret_slide = NULL;
	_data18_->slides_to_remove = NULL;
#line 66 "ease-slide-sorter.vala"
	gtk_icon_view_selected_foreach (self->priv->view, __lambda51__gtk_icon_view_foreach_func, _data18_);
#line 73 "ease-slide-sorter.vala"
	g_list_foreach (_data18_->slides_to_remove, __lambda52__gfunc, _data18_);
#line 278 "ease-slide-sorter.c"
	result = _g_object_ref0 (_data18_->ret_slide);
	block18_data_unref (_data18_);
#line 78 "ease-slide-sorter.vala"
	return result;
#line 283 "ease-slide-sorter.c"
}


#line 81 "ease-slide-sorter.vala"
void ease_slide_sorter_set_zoom (EaseSlideSorter* self, double zoom) {
#line 289 "ease-slide-sorter.c"
	EaseSlide* slide;
#line 81 "ease-slide-sorter.vala"
	g_return_if_fail (self != NULL);
#line 83 "ease-slide-sorter.vala"
	self->priv->width = (gint) (EASE_SLIDE_SORTER_WIDTH + (zoom * EASE_SLIDE_SORTER_WIDTH_ADDITIONAL));
#line 295 "ease-slide-sorter.c"
	slide = NULL;
	{
		EaseIterableTreeModelIterator* _itr_it;
#line 86 "ease-slide-sorter.vala"
		_itr_it = ease_iterable_tree_model_iterator ((EaseIterableTreeModel*) ease_document_get_slides (self->priv->document));
#line 86 "ease-slide-sorter.vala"
		while (TRUE) {
#line 303 "ease-slide-sorter.c"
			GtkTreeIter _tmp0_ = {0};
			GtkTreeIter itr;
			GdkPixbuf* _tmp1_;
#line 86 "ease-slide-sorter.vala"
			if (!ease_iterable_tree_model_iterator_next (_itr_it)) {
#line 86 "ease-slide-sorter.vala"
				break;
#line 311 "ease-slide-sorter.c"
			}
#line 86 "ease-slide-sorter.vala"
			itr = (ease_iterable_tree_model_iterator_get (_itr_it, &_tmp0_), _tmp0_);
#line 89 "ease-slide-sorter.vala"
			gtk_tree_model_get ((GtkTreeModel*) ease_document_get_slides (self->priv->document), &itr, EASE_DOCUMENT_COL_SLIDE, &slide, -1);
#line 92 "ease-slide-sorter.vala"
			gtk_list_store_set ((GtkListStore*) ease_document_get_slides (self->priv->document), &itr, EASE_DOCUMENT_COL_PIXBUF_DYNAMIC, _tmp1_ = ease_slide_button_panel_pixbuf (slide, self->priv->width), -1);
#line 319 "ease-slide-sorter.c"
			_g_object_unref0 (_tmp1_);
		}
		_ease_iterable_tree_model_iterator_unref0 (_itr_it);
	}
	_g_object_unref0 (slide);
}


#line 97 "ease-slide-sorter.vala"
void ease_slide_sorter_on_slide_added (EaseSlideSorter* self, EaseSlide* slide, gint index) {
#line 330 "ease-slide-sorter.c"
	GtkTreeIter _tmp0_ = {0};
	GtkTreeIter itr;
	GdkPixbuf* _tmp1_;
#line 97 "ease-slide-sorter.vala"
	g_return_if_fail (self != NULL);
#line 97 "ease-slide-sorter.vala"
	g_return_if_fail (slide != NULL);
#line 99 "ease-slide-sorter.vala"
	itr = (ease_iterable_tree_model_index ((EaseIterableTreeModel*) ease_document_get_slides (self->priv->document), index, &_tmp0_), _tmp0_);
#line 100 "ease-slide-sorter.vala"
	gtk_list_store_set ((GtkListStore*) ease_document_get_slides (self->priv->document), &itr, EASE_DOCUMENT_COL_PIXBUF_DYNAMIC, _tmp1_ = ease_slide_button_panel_pixbuf (slide, self->priv->width), -1);
#line 342 "ease-slide-sorter.c"
	_g_object_unref0 (_tmp1_);
}


static void ease_slide_sorter_class_init (EaseSlideSorterClass * klass) {
	ease_slide_sorter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseSlideSorterPrivate));
	G_OBJECT_CLASS (klass)->finalize = ease_slide_sorter_finalize;
	g_signal_new ("display_slide", EASE_TYPE_SLIDE_SORTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_SLIDE);
}


static void ease_slide_sorter_instance_init (EaseSlideSorter * self) {
	self->priv = EASE_SLIDE_SORTER_GET_PRIVATE (self);
}


static void ease_slide_sorter_finalize (GObject* obj) {
	EaseSlideSorter * self;
	self = EASE_SLIDE_SORTER (obj);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->document);
	G_OBJECT_CLASS (ease_slide_sorter_parent_class)->finalize (obj);
}


/**
 * A widget displaying an icon view the user can use to sort and delete slides.
 */
GType ease_slide_sorter_get_type (void) {
	static volatile gsize ease_slide_sorter_type_id__volatile = 0;
	if (g_once_init_enter (&ease_slide_sorter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseSlideSorterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_slide_sorter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseSlideSorter), 0, (GInstanceInitFunc) ease_slide_sorter_instance_init, NULL };
		GType ease_slide_sorter_type_id;
		ease_slide_sorter_type_id = g_type_register_static (GTK_TYPE_SCROLLED_WINDOW, "EaseSlideSorter", &g_define_type_info, 0);
		g_once_init_leave (&ease_slide_sorter_type_id__volatile, ease_slide_sorter_type_id);
	}
	return ease_slide_sorter_type_id__volatile;
}




