/* ease-main.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-main.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <unique/unique.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <clutter/clutter.h>
#include <stdio.h>
#include <gst/gst.h>
#include <ease-core.h>
#include <gobject/gvaluecollector.h>


#define EASE_TYPE_MAIN (ease_main_get_type ())
#define EASE_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_MAIN, EaseMain))
#define EASE_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_MAIN, EaseMainClass))
#define EASE_IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_MAIN))
#define EASE_IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_MAIN))
#define EASE_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_MAIN, EaseMainClass))

typedef struct _EaseMain EaseMain;
typedef struct _EaseMainClass EaseMainClass;
typedef struct _EaseMainPrivate EaseMainPrivate;

#define EASE_MAIN_TYPE_UNIQUE_COMMAND (ease_main_unique_command_get_type ())

#define EASE_MAIN_TYPE_EDITOR_WINDOW_INFO (ease_main_editor_window_info_get_type ())
#define EASE_MAIN_EDITOR_WINDOW_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_MAIN_TYPE_EDITOR_WINDOW_INFO, EaseMainEditorWindowInfo))
#define EASE_MAIN_EDITOR_WINDOW_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_MAIN_TYPE_EDITOR_WINDOW_INFO, EaseMainEditorWindowInfoClass))
#define EASE_MAIN_IS_EDITOR_WINDOW_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_MAIN_TYPE_EDITOR_WINDOW_INFO))
#define EASE_MAIN_IS_EDITOR_WINDOW_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_MAIN_TYPE_EDITOR_WINDOW_INFO))
#define EASE_MAIN_EDITOR_WINDOW_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_MAIN_TYPE_EDITOR_WINDOW_INFO, EaseMainEditorWindowInfoClass))

typedef struct _EaseMainEditorWindowInfo EaseMainEditorWindowInfo;
typedef struct _EaseMainEditorWindowInfoClass EaseMainEditorWindowInfoClass;

#define EASE_TYPE_WELCOME_WINDOW (ease_welcome_window_get_type ())
#define EASE_WELCOME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_WELCOME_WINDOW, EaseWelcomeWindow))
#define EASE_WELCOME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_WELCOME_WINDOW, EaseWelcomeWindowClass))
#define EASE_IS_WELCOME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_WELCOME_WINDOW))
#define EASE_IS_WELCOME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_WELCOME_WINDOW))
#define EASE_WELCOME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_WELCOME_WINDOW, EaseWelcomeWindowClass))

typedef struct _EaseWelcomeWindow EaseWelcomeWindow;
typedef struct _EaseWelcomeWindowClass EaseWelcomeWindowClass;

#define EASE_TYPE_PLAYER (ease_player_get_type ())
#define EASE_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_PLAYER, EasePlayer))
#define EASE_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_PLAYER, EasePlayerClass))
#define EASE_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_PLAYER))
#define EASE_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_PLAYER))
#define EASE_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_PLAYER, EasePlayerClass))

typedef struct _EasePlayer EasePlayer;
typedef struct _EasePlayerClass EasePlayerClass;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _unique_message_data_free0(var) ((var == NULL) ? NULL : (var = (unique_message_data_free (var), NULL)))
typedef struct _EaseMainEditorWindowInfoPrivate EaseMainEditorWindowInfoPrivate;

#define EASE_TYPE_EDITOR_WINDOW (ease_editor_window_get_type ())
#define EASE_EDITOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_EDITOR_WINDOW, EaseEditorWindow))
#define EASE_EDITOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_EDITOR_WINDOW, EaseEditorWindowClass))
#define EASE_IS_EDITOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_EDITOR_WINDOW))
#define EASE_IS_EDITOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_EDITOR_WINDOW))
#define EASE_EDITOR_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_EDITOR_WINDOW, EaseEditorWindowClass))

typedef struct _EaseEditorWindow EaseEditorWindow;
typedef struct _EaseEditorWindowClass EaseEditorWindowClass;
typedef struct _EaseEditorWindowPrivate EaseEditorWindowPrivate;

#define EASE_TYPE_SCROLLABLE_EMBED (ease_scrollable_embed_get_type ())
#define EASE_SCROLLABLE_EMBED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbed))
#define EASE_SCROLLABLE_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbedClass))
#define EASE_IS_SCROLLABLE_EMBED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SCROLLABLE_EMBED))
#define EASE_IS_SCROLLABLE_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SCROLLABLE_EMBED))
#define EASE_SCROLLABLE_EMBED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbedClass))

typedef struct _EaseScrollableEmbed EaseScrollableEmbed;
typedef struct _EaseScrollableEmbedClass EaseScrollableEmbedClass;

#define EASE_TYPE_EDITOR_EMBED (ease_editor_embed_get_type ())
#define EASE_EDITOR_EMBED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_EDITOR_EMBED, EaseEditorEmbed))
#define EASE_EDITOR_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_EDITOR_EMBED, EaseEditorEmbedClass))
#define EASE_IS_EDITOR_EMBED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_EDITOR_EMBED))
#define EASE_IS_EDITOR_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_EDITOR_EMBED))
#define EASE_EDITOR_EMBED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_EDITOR_EMBED, EaseEditorEmbedClass))

typedef struct _EaseEditorEmbed EaseEditorEmbed;
typedef struct _EaseEditorEmbedClass EaseEditorEmbedClass;

#define EASE_TYPE_SLIDE_BUTTON_PANEL (ease_slide_button_panel_get_type ())
#define EASE_SLIDE_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE_BUTTON_PANEL, EaseSlideButtonPanel))
#define EASE_SLIDE_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE_BUTTON_PANEL, EaseSlideButtonPanelClass))
#define EASE_IS_SLIDE_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE_BUTTON_PANEL))
#define EASE_IS_SLIDE_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE_BUTTON_PANEL))
#define EASE_SLIDE_BUTTON_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE_BUTTON_PANEL, EaseSlideButtonPanelClass))

typedef struct _EaseSlideButtonPanel EaseSlideButtonPanel;
typedef struct _EaseSlideButtonPanelClass EaseSlideButtonPanelClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _ease_main_editor_window_info_unref0(var) ((var == NULL) ? NULL : (var = (ease_main_editor_window_info_unref (var), NULL)))
typedef struct _EaseMainParamSpecEditorWindowInfo EaseMainParamSpecEditorWindowInfo;

struct _EaseMain {
	GObject parent_instance;
	EaseMainPrivate * priv;
};

struct _EaseMainClass {
	GObjectClass parent_class;
};

typedef enum  {
	EASE_MAIN_UNIQUE_COMMAND_OPEN_FILE = 1,
	EASE_MAIN_UNIQUE_COMMAND_PLAY_FILE = 2,
	EASE_MAIN_UNIQUE_COMMAND_SHOW_WELCOME = 3
} EaseMainUniqueCommand;

struct _EaseMainEditorWindowInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EaseMainEditorWindowInfoPrivate * priv;
	EaseEditorWindow* window;
	gint x;
	gint y;
};

struct _EaseMainEditorWindowInfoClass {
	GTypeClass parent_class;
	void (*finalize) (EaseMainEditorWindowInfo *self);
};

struct _EaseEditorWindow {
	GtkWindow parent_instance;
	EaseEditorWindowPrivate * priv;
	EaseEditorEmbed* embed;
	EaseSlideButtonPanel* slide_button_panel;
	EaseAnimatedZoomSlider* zoom_slider;
	EaseDocument* document;
	EaseSlide* slide;
};

struct _EaseEditorWindowClass {
	GtkWindowClass parent_class;
};

struct _EaseMainParamSpecEditorWindowInfo {
	GParamSpec parent_instance;
};


static GeeArrayList* ease_main_windows;
static GeeArrayList* ease_main_windows = NULL;
static EaseWelcomeWindow* ease_main_welcome;
static EaseWelcomeWindow* ease_main_welcome = NULL;
static UniqueApp* ease_main_app;
static UniqueApp* ease_main_app = NULL;
static char* ease_main_play_filename;
static char* ease_main_play_filename = NULL;
static char** ease_main_filenames;
static gint ease_main_filenames_length1;
static char** ease_main_filenames = NULL;
static gint ease_main_filenames_length1 = 0;
static gint _ease_main_filenames_size_ = 0;
extern gboolean ease_main_presentation_windowed;
gboolean ease_main_presentation_windowed = FALSE;
static gboolean ease_main_debug_undo;
static gboolean ease_main_debug_undo = FALSE;
static EasePlayer* ease_main_player;
static EasePlayer* ease_main_player = NULL;
static gpointer ease_main_editor_window_info_parent_class = NULL;
static gpointer ease_main_parent_class = NULL;

GType ease_main_get_type (void) G_GNUC_CONST;
enum  {
	EASE_MAIN_DUMMY_PROPERTY
};
static GType ease_main_unique_command_get_type (void) G_GNUC_UNUSED;
static gpointer ease_main_editor_window_info_ref (gpointer instance);
static void ease_main_editor_window_info_unref (gpointer instance);
static GParamSpec* ease_main_param_spec_editor_window_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void ease_main_value_set_editor_window_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void ease_main_value_take_editor_window_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer ease_main_value_get_editor_window_info (const GValue* value) G_GNUC_UNUSED;
static GType ease_main_editor_window_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType ease_welcome_window_get_type (void) G_GNUC_CONST;
GType ease_player_get_type (void) G_GNUC_CONST;
gint ease_main_main (char** args, int args_length1);
static UniqueResponse _lambda65_ (UniqueApp* _self_, gint cmd, UniqueMessageData* data, guint time_);
void ease_main_open_file (const char* path);
void ease_main_play_file (const char* file, gboolean close_when_done);
void ease_main_show_welcome (void);
static UniqueResponse __lambda65__unique_app_message_received (UniqueApp* _sender, gint command, UniqueMessageData* message_data, guint time_, gpointer self);
GType ease_editor_window_get_type (void) G_GNUC_CONST;
GType ease_scrollable_embed_get_type (void) G_GNUC_CONST;
GType ease_editor_embed_get_type (void) G_GNUC_CONST;
GType ease_slide_button_panel_get_type (void) G_GNUC_CONST;
EaseEditorWindow* ease_editor_window_new (EaseDocument* doc);
EaseEditorWindow* ease_editor_window_construct (GType object_type, EaseDocument* doc);
static void ease_main_add_window (EaseEditorWindow* win);
EasePlayer* ease_player_new (EaseDocument* doc);
EasePlayer* ease_player_construct (GType object_type, EaseDocument* doc);
ClutterStage* ease_player_get_stage (EasePlayer* self);
static void _lambda66_ (void);
static void __lambda66__clutter_actor_hide (ClutterActor* _sender, gpointer self);
void ease_main_new_from_theme (EaseTheme* theme, gint width, gint height);
static void ease_main_remove_window (EaseEditorWindow* win);
static void ease_main_on_play (EaseDocument* document);
static void _ease_main_on_play_ease_editor_window_play (EaseEditorWindow* _sender, EaseDocument* doc, gpointer self);
static void ease_main_on_close (EaseEditorWindow* _self_);
static void _ease_main_on_close_ease_editor_window_close (EaseEditorWindow* _sender, EaseEditorWindow* _self_, gpointer self);
static EaseMainEditorWindowInfo* ease_main_editor_window_info_new (EaseEditorWindow* win);
static EaseMainEditorWindowInfo* ease_main_editor_window_info_construct (GType object_type, EaseEditorWindow* win);
static void _lambda62_ (void);
static void __lambda62__ease_player_complete (EasePlayer* _sender, gpointer self);
EaseWelcomeWindow* ease_welcome_window_new (void);
EaseWelcomeWindow* ease_welcome_window_construct (GType object_type);
static void _lambda67_ (void);
void ease_main_remove_welcome (void);
static void __lambda67__gtk_widget_hide (GtkWidget* _sender, gpointer self);
EaseMain* ease_main_new (void);
EaseMain* ease_main_construct (GType object_type);
enum  {
	EASE_MAIN_EDITOR_WINDOW_INFO_DUMMY_PROPERTY
};
static void ease_main_editor_window_info_finalize (EaseMainEditorWindowInfo* obj);
static void ease_main_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const GOptionEntry EASE_MAIN_options[5] = {{"play", 'p', 0, G_OPTION_ARG_FILENAME, &ease_main_play_filename, "Play the specified file", "FILE"}, {"window", 'w', 0, G_OPTION_ARG_NONE, &ease_main_presentation_windowed, "Display presentations in a window", NULL}, {"debug-undo", (gchar) 0, 0, G_OPTION_ARG_NONE, &ease_main_debug_undo, "Display debugging messages about undo actions", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &ease_main_filenames, NULL, "FILE..."}, {NULL}};


static GType ease_main_unique_command_get_type (void) {
	static volatile gsize ease_main_unique_command_type_id__volatile = 0;
	if (g_once_init_enter (&ease_main_unique_command_type_id__volatile)) {
		static const GEnumValue values[] = {{EASE_MAIN_UNIQUE_COMMAND_OPEN_FILE, "EASE_MAIN_UNIQUE_COMMAND_OPEN_FILE", "open-file"}, {EASE_MAIN_UNIQUE_COMMAND_PLAY_FILE, "EASE_MAIN_UNIQUE_COMMAND_PLAY_FILE", "play-file"}, {EASE_MAIN_UNIQUE_COMMAND_SHOW_WELCOME, "EASE_MAIN_UNIQUE_COMMAND_SHOW_WELCOME", "show-welcome"}, {0, NULL, NULL}};
		GType ease_main_unique_command_type_id;
		ease_main_unique_command_type_id = g_enum_register_static ("EaseMainUniqueCommand", values);
		g_once_init_leave (&ease_main_unique_command_type_id__volatile, ease_main_unique_command_type_id);
	}
	return ease_main_unique_command_type_id__volatile;
}


/**
 * Start Ease to edit files.
 * 
 * If the user runs Ease with a filename as a parameter, this function
 * will open an {@link EditorWindow}. Otherwise, a {@link WelcomeWindow}
 * will be opened.
 *
 * @param args Program arguments.
 */
#line 96 "ease-main.vala"
static UniqueResponse _lambda65_ (UniqueApp* _self_, gint cmd, UniqueMessageData* data, guint time_) {
#line 283 "ease-main.c"
	UniqueResponse result = 0;
#line 96 "ease-main.vala"
	g_return_val_if_fail (_self_ != NULL, 0);
#line 96 "ease-main.vala"
	g_return_val_if_fail (data != NULL, 0);
#line 97 "ease-main.vala"
	switch (cmd) {
#line 291 "ease-main.c"
		case EASE_MAIN_UNIQUE_COMMAND_OPEN_FILE:
		{
			gint filenames_length1;
			gint _filenames_size_;
			char** _tmp0_;
			char** filenames;
			filenames = (_tmp0_ = unique_message_data_get_uris (data), filenames_length1 = -1, _filenames_size_ = filenames_length1, _tmp0_);
			{
				gint i;
#line 101 "ease-main.vala"
				i = 0;
#line 303 "ease-main.c"
				{
					gboolean _tmp1_;
#line 101 "ease-main.vala"
					_tmp1_ = TRUE;
#line 101 "ease-main.vala"
					while (TRUE) {
#line 101 "ease-main.vala"
						if (!_tmp1_) {
#line 101 "ease-main.vala"
							i++;
#line 314 "ease-main.c"
						}
#line 101 "ease-main.vala"
						_tmp1_ = FALSE;
#line 101 "ease-main.vala"
						if (!(filenames[i] != NULL)) {
#line 101 "ease-main.vala"
							break;
#line 322 "ease-main.c"
						}
#line 103 "ease-main.vala"
						ease_main_open_file (filenames[i]);
#line 326 "ease-main.c"
					}
				}
			}
			result = UNIQUE_RESPONSE_OK;
			filenames = (_vala_array_free (filenames, filenames_length1, (GDestroyNotify) g_free), NULL);
#line 105 "ease-main.vala"
			return result;
#line 334 "ease-main.c"
		}
		case EASE_MAIN_UNIQUE_COMMAND_PLAY_FILE:
		{
#line 107 "ease-main.vala"
			ease_main_play_file (unique_message_data_get_filename (data), FALSE);
#line 340 "ease-main.c"
			result = UNIQUE_RESPONSE_OK;
#line 108 "ease-main.vala"
			return result;
#line 344 "ease-main.c"
		}
		case EASE_MAIN_UNIQUE_COMMAND_SHOW_WELCOME:
		{
#line 110 "ease-main.vala"
			ease_main_show_welcome ();
#line 350 "ease-main.c"
			result = UNIQUE_RESPONSE_OK;
#line 111 "ease-main.vala"
			return result;
#line 354 "ease-main.c"
		}
	}
#line 115 "ease-main.vala"
	g_critical ("ease-main.vala:115: Invalid UniqueCommand");
#line 359 "ease-main.c"
	result = UNIQUE_RESPONSE_PASSTHROUGH;
#line 116 "ease-main.vala"
	return result;
#line 363 "ease-main.c"
}


#line 96 "ease-main.vala"
static UniqueResponse __lambda65__unique_app_message_received (UniqueApp* _sender, gint command, UniqueMessageData* message_data, guint time_, gpointer self) {
#line 369 "ease-main.c"
	UniqueResponse result;
	result = _lambda65_ (_sender, command, message_data, time_);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 58 "ease-main.vala"
gint ease_main_main (char** args, int args_length1) {
#line 383 "ease-main.c"
	gint result = 0;
	GOptionContext* context;
	UniqueApp* _tmp1_;
	gboolean _tmp2_;
	gboolean running;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
#line 61 "ease-main.vala"
	g_set_application_name ("Ease");
#line 62 "ease-main.vala"
	gtk_window_set_default_icon_name ("ease");
#line 65 "ease-main.vala"
	context = g_option_context_new (_ (" - a presentation editor"));
#line 68 "ease-main.vala"
	g_option_context_add_main_entries (context, EASE_MAIN_options, NULL);
#line 71 "ease-main.vala"
	g_option_context_add_group (context, gtk_get_option_group (TRUE));
#line 72 "ease-main.vala"
	g_option_context_add_group (context, clutter_get_option_group ());
#line 403 "ease-main.c"
	{
		gboolean _tmp0_;
#line 76 "ease-main.vala"
		_tmp0_ = g_option_context_parse (context, &args_length1, &args, &_inner_error_);
#line 408 "ease-main.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch12_g_option_error;
			}
			_g_option_context_free0 (context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
#line 76 "ease-main.vala"
		if (!_tmp0_) {
#line 420 "ease-main.c"
			result = 1;
			_g_option_context_free0 (context);
#line 76 "ease-main.vala"
			return result;
#line 425 "ease-main.c"
		}
	}
	goto __finally12;
	__catch12_g_option_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 80 "ease-main.vala"
			fprintf (stdout, _ ("error parsing options: %s\n"), e->message);
#line 437 "ease-main.c"
			result = 1;
			_g_error_free0 (e);
			_g_option_context_free0 (context);
#line 81 "ease-main.vala"
			return result;
#line 443 "ease-main.c"
		}
	}
	__finally12:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
#line 85 "ease-main.vala"
	ease_main_app = (_tmp1_ = unique_app_new ("org.ease-project.ease", NULL), _g_object_unref0 (ease_main_app), _tmp1_);
#line 86 "ease-main.vala"
	unique_app_add_command (ease_main_app, "Open document", (gint) EASE_MAIN_UNIQUE_COMMAND_OPEN_FILE);
#line 87 "ease-main.vala"
	unique_app_add_command (ease_main_app, "Play document", (gint) EASE_MAIN_UNIQUE_COMMAND_PLAY_FILE);
#line 88 "ease-main.vala"
	unique_app_add_command (ease_main_app, "Create new document", (gint) EASE_MAIN_UNIQUE_COMMAND_SHOW_WELCOME);
#line 91 "ease-main.vala"
	running = (g_object_get (ease_main_app, "is-running", &_tmp2_, NULL), _tmp2_);
#line 93 "ease-main.vala"
	if (!running) {
#line 465 "ease-main.c"
		GeeArrayList* _tmp3_;
		ClutterBackend* backend;
		GtkSettings* settings;
		gint _tmp4_;
		gint _tmp5_;
#line 96 "ease-main.vala"
		g_signal_connect (ease_main_app, "message-received", (GCallback) __lambda65__unique_app_message_received, NULL);
#line 120 "ease-main.vala"
		gst_init (&args_length1, &args);
#line 123 "ease-main.vala"
		ease_undo_controller_set_enable_debug (ease_main_debug_undo);
#line 126 "ease-main.vala"
		ease_main_windows = (_tmp3_ = gee_array_list_new (EASE_MAIN_TYPE_EDITOR_WINDOW_INFO, (GBoxedCopyFunc) ease_main_editor_window_info_ref, ease_main_editor_window_info_unref, NULL), _g_object_unref0 (ease_main_windows), _tmp3_);
#line 129 "ease-main.vala"
		backend = _g_object_ref0 (clutter_get_default_backend ());
#line 130 "ease-main.vala"
		settings = _g_object_ref0 (gtk_settings_get_default ());
#line 131 "ease-main.vala"
		clutter_backend_set_double_click_time (backend, (guint) (g_object_get (settings, "gtk-double-click-time", &_tmp4_, NULL), _tmp4_));
#line 132 "ease-main.vala"
		clutter_backend_set_double_click_distance (backend, (guint) (g_object_get (settings, "gtk-double-click-distance", &_tmp5_, NULL), _tmp5_));
#line 487 "ease-main.c"
		_g_object_unref0 (settings);
		_g_object_unref0 (backend);
	}
#line 137 "ease-main.vala"
	if (ease_main_filenames != NULL) {
#line 139 "ease-main.vala"
		if (!running) {
#line 495 "ease-main.c"
			{
				gint i;
#line 141 "ease-main.vala"
				i = 0;
#line 500 "ease-main.c"
				{
					gboolean _tmp6_;
#line 141 "ease-main.vala"
					_tmp6_ = TRUE;
#line 141 "ease-main.vala"
					while (TRUE) {
#line 141 "ease-main.vala"
						if (!_tmp6_) {
#line 141 "ease-main.vala"
							i++;
#line 511 "ease-main.c"
						}
#line 141 "ease-main.vala"
						_tmp6_ = FALSE;
#line 141 "ease-main.vala"
						if (!(ease_main_filenames[i] != NULL)) {
#line 141 "ease-main.vala"
							break;
#line 519 "ease-main.c"
						}
#line 143 "ease-main.vala"
						ease_main_open_file (ease_main_filenames[i]);
#line 523 "ease-main.c"
					}
				}
			}
		} else {
			UniqueMessageData* data;
#line 148 "ease-main.vala"
			data = unique_message_data_new ();
#line 149 "ease-main.vala"
			unique_message_data_set_uris (data, ease_main_filenames);
#line 150 "ease-main.vala"
			unique_app_send_message (ease_main_app, (gint) EASE_MAIN_UNIQUE_COMMAND_OPEN_FILE, data);
#line 535 "ease-main.c"
			_unique_message_data_free0 (data);
		}
	}
#line 155 "ease-main.vala"
	if (ease_main_play_filename != NULL) {
#line 157 "ease-main.vala"
		if (!running) {
#line 159 "ease-main.vala"
			ease_main_play_file (ease_main_play_filename, ease_main_filenames == NULL);
#line 545 "ease-main.c"
		} else {
			UniqueMessageData* data;
#line 163 "ease-main.vala"
			data = unique_message_data_new ();
#line 164 "ease-main.vala"
			unique_message_data_set_filename (data, ease_main_play_filename);
#line 165 "ease-main.vala"
			unique_app_send_message (ease_main_app, (gint) EASE_MAIN_UNIQUE_COMMAND_PLAY_FILE, data);
#line 554 "ease-main.c"
			_unique_message_data_free0 (data);
		}
	}
#line 170 "ease-main.vala"
	if (ease_main_filenames == NULL) {
#line 170 "ease-main.vala"
		_tmp7_ = ease_main_play_filename == NULL;
#line 562 "ease-main.c"
	} else {
#line 170 "ease-main.vala"
		_tmp7_ = FALSE;
#line 566 "ease-main.c"
	}
#line 170 "ease-main.vala"
	if (_tmp7_) {
#line 172 "ease-main.vala"
		if (!running) {
#line 172 "ease-main.vala"
			ease_main_show_welcome ();
#line 574 "ease-main.c"
		} else {
#line 173 "ease-main.vala"
			unique_app_send_message (ease_main_app, (gint) EASE_MAIN_UNIQUE_COMMAND_SHOW_WELCOME, NULL);
#line 578 "ease-main.c"
		}
	}
#line 177 "ease-main.vala"
	if (running) {
#line 583 "ease-main.c"
		result = 0;
		_g_option_context_free0 (context);
#line 177 "ease-main.vala"
		return result;
#line 588 "ease-main.c"
	}
#line 179 "ease-main.vala"
	gtk_main ();
#line 181 "ease-main.vala"
	ease_temp_clean ();
#line 594 "ease-main.c"
	result = 0;
	_g_option_context_free0 (context);
#line 183 "ease-main.vala"
	return result;
#line 599 "ease-main.c"
}


#line 58 "ease-main.vala"
int main (int argc, char ** argv) {
#line 605 "ease-main.c"
	g_thread_init (NULL);
#line 58 "ease-main.vala"
	g_type_init ();
#line 58 "ease-main.vala"
	return ease_main_main (argv, argc);
#line 611 "ease-main.c"
}


/**
 * Creates a new {@link EditorWindow}, or raises an existing one.
 *
 * If the passed filename does not have a window associated with it,
 * a new window will be created to edit that file. Otherwise, the currently
 * existing window will be raised.
 *
 * @param path The filename
 */
#line 195 "ease-main.vala"
void ease_main_open_file (const char* path) {
#line 626 "ease-main.c"
	GError * _inner_error_ = NULL;
#line 195 "ease-main.vala"
	g_return_if_fail (path != NULL);
#line 630 "ease-main.c"
	{
		GeeIterator* _info_it;
#line 197 "ease-main.vala"
		_info_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) ease_main_windows);
#line 197 "ease-main.vala"
		while (TRUE) {
#line 637 "ease-main.c"
			EaseMainEditorWindowInfo* info;
			char* _tmp0_;
			char* _tmp1_;
			gboolean _tmp2_;
#line 197 "ease-main.vala"
			if (!gee_iterator_next (_info_it)) {
#line 197 "ease-main.vala"
				break;
#line 646 "ease-main.c"
			}
#line 197 "ease-main.vala"
			info = (EaseMainEditorWindowInfo*) gee_iterator_get (_info_it);
#line 199 "ease-main.vala"
			if ((_tmp2_ = _vala_strcmp0 (_tmp0_ = ease_absolute_path (ease_document_get_filename (info->window->document)), _tmp1_ = ease_absolute_path (path)) == 0, _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_)) {
#line 202 "ease-main.vala"
				gtk_window_present ((GtkWindow*) info->window);
#line 654 "ease-main.c"
				_ease_main_editor_window_info_unref0 (info);
				_g_object_unref0 (_info_it);
#line 203 "ease-main.vala"
				return;
#line 659 "ease-main.c"
			}
			_ease_main_editor_window_info_unref0 (info);
		}
		_g_object_unref0 (_info_it);
	}
	{
		EaseDocument* doc;
		EaseEditorWindow* win;
#line 209 "ease-main.vala"
		doc = ease_document_new_from_saved (path, &_inner_error_);
#line 670 "ease-main.c"
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
#line 210 "ease-main.vala"
		win = g_object_ref_sink (ease_editor_window_new (doc));
#line 211 "ease-main.vala"
		ease_main_add_window (win);
#line 212 "ease-main.vala"
		gtk_widget_show_now ((GtkWidget*) win);
#line 213 "ease-main.vala"
		gtk_window_present ((GtkWindow*) win);
#line 682 "ease-main.c"
		_g_object_unref0 (win);
		_g_object_unref0 (doc);
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 217 "ease-main.vala"
			ease_error_dialog (_ ("Error Opening Document"), e->message);
#line 695 "ease-main.c"
			_g_error_free0 (e);
#line 218 "ease-main.vala"
			return;
#line 699 "ease-main.c"
		}
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
 * Plays a file.
 */
#line 239 "ease-main.vala"
static void _lambda66_ (void) {
#line 240 "ease-main.vala"
	gtk_main_quit ();
#line 718 "ease-main.c"
}


#line 239 "ease-main.vala"
static void __lambda66__clutter_actor_hide (ClutterActor* _sender, gpointer self) {
#line 724 "ease-main.c"
	_lambda66_ ();
}


#line 225 "ease-main.vala"
void ease_main_play_file (const char* file, gboolean close_when_done) {
#line 731 "ease-main.c"
	GError * _inner_error_ = NULL;
#line 225 "ease-main.vala"
	g_return_if_fail (file != NULL);
#line 227 "ease-main.vala"
	if (ease_main_player != NULL) {
#line 229 "ease-main.vala"
		g_warning ("ease-main.vala:229: Cannot play %s while another document is playing", file);
#line 739 "ease-main.c"
	}
	{
		EaseDocument* doc;
		EasePlayer* _tmp0_;
#line 233 "ease-main.vala"
		doc = ease_document_new_from_saved (file, &_inner_error_);
#line 746 "ease-main.c"
		if (_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
#line 234 "ease-main.vala"
		ease_main_player = (_tmp0_ = g_object_ref_sink (ease_player_new (doc)), _g_object_unref0 (ease_main_player), _tmp0_);
#line 237 "ease-main.vala"
		if (close_when_done) {
#line 239 "ease-main.vala"
			g_signal_connect ((ClutterActor*) ease_player_get_stage (ease_main_player), "hide", (GCallback) __lambda66__clutter_actor_hide, NULL);
#line 756 "ease-main.c"
		}
		_g_object_unref0 (doc);
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 246 "ease-main.vala"
			ease_error_dialog (_ ("Error Playing Document"), e->message);
#line 769 "ease-main.c"
			_g_error_free0 (e);
		}
	}
	__finally14:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
 * Creates a new {@link EditorWindow} from a theme and size.
 */
#line 253 "ease-main.vala"
void ease_main_new_from_theme (EaseTheme* theme, gint width, gint height) {
#line 787 "ease-main.c"
	GError * _inner_error_ = NULL;
#line 253 "ease-main.vala"
	g_return_if_fail (theme != NULL);
#line 791 "ease-main.c"
	{
		EaseDocument* document;
		EaseEditorWindow* editor;
#line 257 "ease-main.vala"
		document = ease_document_new_from_theme (theme, width, height, &_inner_error_);
#line 797 "ease-main.c"
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
#line 258 "ease-main.vala"
		editor = g_object_ref_sink (ease_editor_window_new (document));
#line 259 "ease-main.vala"
		ease_main_add_window (editor);
#line 260 "ease-main.vala"
		gtk_window_present ((GtkWindow*) editor);
#line 807 "ease-main.c"
		_g_object_unref0 (editor);
		_g_object_unref0 (document);
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 264 "ease-main.vala"
			ease_error_dialog (_ ("Error creating new document"), e->message);
#line 820 "ease-main.c"
			_g_error_free0 (e);
		}
	}
	__finally15:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
 * Removes an {@link EditorWindow} from Ease's internal store of windows.
 * 
 * Ease tracks the current windows in order to properly quit when there
 * are no {@link EditorWindow}s on screen and the {@link WelcomeWindow} is
 * hidden. This function will quit Ease if the removed window is the final
 * window and the {@link WelcomeWindow} is hidden.
 *
 * @param win The {@link EditorWindow}.
 */
#line 318 "ease-main.vala"
static void _ease_main_on_play_ease_editor_window_play (EaseEditorWindow* _sender, EaseDocument* doc, gpointer self) {
#line 845 "ease-main.c"
	ease_main_on_play (doc);
}


#line 342 "ease-main.vala"
static void _ease_main_on_close_ease_editor_window_close (EaseEditorWindow* _sender, EaseEditorWindow* _self_, gpointer self) {
#line 852 "ease-main.c"
	ease_main_on_close (_self_);
}


#line 278 "ease-main.vala"
static void ease_main_remove_window (EaseEditorWindow* win) {
#line 859 "ease-main.c"
	guint _tmp0_;
	guint _tmp1_;
	gboolean _tmp2_ = FALSE;
#line 278 "ease-main.vala"
	g_return_if_fail (win != NULL);
#line 865 "ease-main.c"
	{
		GeeIterator* _info_it;
#line 280 "ease-main.vala"
		_info_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) ease_main_windows);
#line 280 "ease-main.vala"
		while (TRUE) {
#line 872 "ease-main.c"
			EaseMainEditorWindowInfo* info;
#line 280 "ease-main.vala"
			if (!gee_iterator_next (_info_it)) {
#line 280 "ease-main.vala"
				break;
#line 878 "ease-main.c"
			}
#line 280 "ease-main.vala"
			info = (EaseMainEditorWindowInfo*) gee_iterator_get (_info_it);
#line 282 "ease-main.vala"
			if (info->window == win) {
#line 284 "ease-main.vala"
				gee_abstract_collection_remove ((GeeAbstractCollection*) ease_main_windows, info);
#line 886 "ease-main.c"
				_ease_main_editor_window_info_unref0 (info);
#line 285 "ease-main.vala"
				break;
#line 890 "ease-main.c"
			}
			_ease_main_editor_window_info_unref0 (info);
		}
		_g_object_unref0 (_info_it);
	}
#line 288 "ease-main.vala"
	g_signal_parse_name ("play", EASE_TYPE_EDITOR_WINDOW, &_tmp0_, NULL, FALSE);
#line 288 "ease-main.vala"
	g_signal_handlers_disconnect_matched (win, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _ease_main_on_play_ease_editor_window_play, NULL);
#line 289 "ease-main.vala"
	g_signal_parse_name ("close", EASE_TYPE_EDITOR_WINDOW, &_tmp1_, NULL, FALSE);
#line 289 "ease-main.vala"
	g_signal_handlers_disconnect_matched (win, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _ease_main_on_close_ease_editor_window_close, NULL);
#line 291 "ease-main.vala"
	if (gee_collection_get_size ((GeeCollection*) ease_main_windows) == 0) {
#line 291 "ease-main.vala"
		_tmp2_ = ease_main_welcome == NULL;
#line 908 "ease-main.c"
	} else {
#line 291 "ease-main.vala"
		_tmp2_ = FALSE;
#line 912 "ease-main.c"
	}
#line 291 "ease-main.vala"
	if (_tmp2_) {
#line 293 "ease-main.vala"
		gtk_main_quit ();
#line 918 "ease-main.c"
	}
}


/**
 * Adds an {@link EditorWindow} to Ease's internal store of windows.
 * 
 * Ease tracks the current windows in order to properly quit when there
 * are no {@link EditorWindow}s on screen and the {@link WelcomeWindow} is
 * hidden. 
 *
 * @param win The {@link EditorWindow}.
 */
#line 306 "ease-main.vala"
static void ease_main_add_window (EaseEditorWindow* win) {
#line 934 "ease-main.c"
	EaseMainEditorWindowInfo* _tmp0_;
#line 306 "ease-main.vala"
	g_return_if_fail (win != NULL);
#line 308 "ease-main.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) ease_main_windows, _tmp0_ = ease_main_editor_window_info_new (win));
#line 940 "ease-main.c"
	_ease_main_editor_window_info_unref0 (_tmp0_);
#line 309 "ease-main.vala"
	g_signal_connect (win, "play", (GCallback) _ease_main_on_play_ease_editor_window_play, NULL);
#line 310 "ease-main.vala"
	g_signal_connect (win, "close", (GCallback) _ease_main_on_close_ease_editor_window_close, NULL);
#line 946 "ease-main.c"
}


/**
 * Handles the {@link EditorWindow.play} signal.
 *
 * Hides all visible windows and displays the presentation.
 */
#line 323 "ease-main.vala"
static void _lambda62_ (void) {
#line 324 "ease-main.vala"
	gtk_object_destroy ((GtkObject*) ease_main_player);
#line 959 "ease-main.c"
	{
		GeeIterator* _info_it;
#line 325 "ease-main.vala"
		_info_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) ease_main_windows);
#line 325 "ease-main.vala"
		while (TRUE) {
#line 966 "ease-main.c"
			EaseMainEditorWindowInfo* info;
#line 325 "ease-main.vala"
			if (!gee_iterator_next (_info_it)) {
#line 325 "ease-main.vala"
				break;
#line 972 "ease-main.c"
			}
#line 325 "ease-main.vala"
			info = (EaseMainEditorWindowInfo*) gee_iterator_get (_info_it);
#line 327 "ease-main.vala"
			gtk_widget_show ((GtkWidget*) info->window);
#line 328 "ease-main.vala"
			gtk_window_move ((GtkWindow*) info->window, info->x, info->y);
#line 980 "ease-main.c"
			_ease_main_editor_window_info_unref0 (info);
		}
		_g_object_unref0 (_info_it);
	}
}


#line 323 "ease-main.vala"
static void __lambda62__ease_player_complete (EasePlayer* _sender, gpointer self) {
#line 990 "ease-main.c"
	_lambda62_ ();
}


#line 318 "ease-main.vala"
static void ease_main_on_play (EaseDocument* document) {
#line 997 "ease-main.c"
	EasePlayer* _tmp0_;
#line 318 "ease-main.vala"
	g_return_if_fail (document != NULL);
#line 320 "ease-main.vala"
	ease_main_player = (_tmp0_ = g_object_ref_sink (ease_player_new (document)), _g_object_unref0 (ease_main_player), _tmp0_);
#line 321 "ease-main.vala"
	gtk_window_present ((GtkWindow*) ease_main_player);
#line 323 "ease-main.vala"
	g_signal_connect (ease_main_player, "complete", (GCallback) __lambda62__ease_player_complete, NULL);
#line 1007 "ease-main.c"
	{
		GeeIterator* _info_it;
#line 332 "ease-main.vala"
		_info_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) ease_main_windows);
#line 332 "ease-main.vala"
		while (TRUE) {
#line 1014 "ease-main.c"
			EaseMainEditorWindowInfo* info;
#line 332 "ease-main.vala"
			if (!gee_iterator_next (_info_it)) {
#line 332 "ease-main.vala"
				break;
#line 1020 "ease-main.c"
			}
#line 332 "ease-main.vala"
			info = (EaseMainEditorWindowInfo*) gee_iterator_get (_info_it);
#line 334 "ease-main.vala"
			gtk_window_get_position ((GtkWindow*) info->window, &info->x, &info->y);
#line 335 "ease-main.vala"
			gtk_widget_hide ((GtkWidget*) info->window);
#line 1028 "ease-main.c"
			_ease_main_editor_window_info_unref0 (info);
		}
		_g_object_unref0 (_info_it);
	}
}


/**
 * Closes and removes an EditorWindow.
 */
#line 342 "ease-main.vala"
static void ease_main_on_close (EaseEditorWindow* _self_) {
#line 342 "ease-main.vala"
	g_return_if_fail (_self_ != NULL);
#line 344 "ease-main.vala"
	gtk_widget_hide ((GtkWidget*) _self_);
#line 345 "ease-main.vala"
	ease_main_remove_window (_self_);
#line 1047 "ease-main.c"
}


/**
 * Shows the {@link WelcomeWindow}
 * 
 * Shows the {@link WelcomeWindow}, or raises it to the top if it is not
 * already displayed.
 *
 */
#line 360 "ease-main.vala"
static void _lambda67_ (void) {
#line 360 "ease-main.vala"
	ease_main_remove_welcome ();
#line 1062 "ease-main.c"
}


#line 360 "ease-main.vala"
static void __lambda67__gtk_widget_hide (GtkWidget* _sender, gpointer self) {
#line 1068 "ease-main.c"
	_lambda67_ ();
}


#line 355 "ease-main.vala"
void ease_main_show_welcome (void) {
#line 357 "ease-main.vala"
	if (ease_main_welcome == NULL) {
#line 1077 "ease-main.c"
		EaseWelcomeWindow* _tmp0_;
#line 359 "ease-main.vala"
		ease_main_welcome = (_tmp0_ = g_object_ref_sink (ease_welcome_window_new ()), _g_object_unref0 (ease_main_welcome), _tmp0_);
#line 360 "ease-main.vala"
		g_signal_connect ((GtkWidget*) ease_main_welcome, "hide", (GCallback) __lambda67__gtk_widget_hide, NULL);
#line 1083 "ease-main.c"
	} else {
#line 364 "ease-main.vala"
		gtk_window_present ((GtkWindow*) ease_main_welcome);
#line 1087 "ease-main.c"
	}
}


/**
 * Hides the {@link WelcomeWindow}.
 * 
 * It's important to call this function when the {@link WelcomeWindow} is
 * hidden, so that Ease can properly exit when all windows are closed.
 * When the {@link WelcomeWindow} is shown via show_welcome, this function
 * is automatically added in that window's hide signal handler.
 */
#line 376 "ease-main.vala"
void ease_main_remove_welcome (void) {
#line 1102 "ease-main.c"
	EaseWelcomeWindow* _tmp0_;
#line 378 "ease-main.vala"
	gtk_widget_hide_all ((GtkWidget*) ease_main_welcome);
#line 379 "ease-main.vala"
	ease_main_welcome = (_tmp0_ = NULL, _g_object_unref0 (ease_main_welcome), _tmp0_);
#line 380 "ease-main.vala"
	if (gee_collection_get_size ((GeeCollection*) ease_main_windows) == 0) {
#line 382 "ease-main.vala"
		gtk_main_quit ();
#line 1112 "ease-main.c"
	}
}


#line 18 "ease-main.vala"
EaseMain* ease_main_construct (GType object_type) {
#line 1119 "ease-main.c"
	EaseMain * self;
#line 18 "ease-main.vala"
	self = (EaseMain*) g_object_new (object_type, NULL);
#line 1123 "ease-main.c"
	return self;
}


#line 18 "ease-main.vala"
EaseMain* ease_main_new (void) {
#line 18 "ease-main.vala"
	return ease_main_construct (EASE_TYPE_MAIN);
#line 1132 "ease-main.c"
}


#line 392 "ease-main.vala"
static EaseMainEditorWindowInfo* ease_main_editor_window_info_construct (GType object_type, EaseEditorWindow* win) {
#line 1138 "ease-main.c"
	EaseMainEditorWindowInfo* self;
	EaseEditorWindow* _tmp0_;
#line 392 "ease-main.vala"
	g_return_val_if_fail (win != NULL, NULL);
#line 1143 "ease-main.c"
	self = (EaseMainEditorWindowInfo*) g_type_create_instance (object_type);
#line 394 "ease-main.vala"
	self->window = (_tmp0_ = _g_object_ref0 (win), _g_object_unref0 (self->window), _tmp0_);
#line 1147 "ease-main.c"
	return self;
}


#line 392 "ease-main.vala"
static EaseMainEditorWindowInfo* ease_main_editor_window_info_new (EaseEditorWindow* win) {
#line 392 "ease-main.vala"
	return ease_main_editor_window_info_construct (EASE_MAIN_TYPE_EDITOR_WINDOW_INFO, win);
#line 1156 "ease-main.c"
}


static void ease_main_value_editor_window_info_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void ease_main_value_editor_window_info_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		ease_main_editor_window_info_unref (value->data[0].v_pointer);
	}
}


static void ease_main_value_editor_window_info_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ease_main_editor_window_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer ease_main_value_editor_window_info_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* ease_main_value_editor_window_info_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		EaseMainEditorWindowInfo* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ease_main_editor_window_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* ease_main_value_editor_window_info_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	EaseMainEditorWindowInfo** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ease_main_editor_window_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* ease_main_param_spec_editor_window_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	EaseMainParamSpecEditorWindowInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, EASE_MAIN_TYPE_EDITOR_WINDOW_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer ease_main_value_get_editor_window_info (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EASE_MAIN_TYPE_EDITOR_WINDOW_INFO), NULL);
	return value->data[0].v_pointer;
}


static void ease_main_value_set_editor_window_info (GValue* value, gpointer v_object) {
	EaseMainEditorWindowInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EASE_MAIN_TYPE_EDITOR_WINDOW_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EASE_MAIN_TYPE_EDITOR_WINDOW_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ease_main_editor_window_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ease_main_editor_window_info_unref (old);
	}
}


static void ease_main_value_take_editor_window_info (GValue* value, gpointer v_object) {
	EaseMainEditorWindowInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EASE_MAIN_TYPE_EDITOR_WINDOW_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EASE_MAIN_TYPE_EDITOR_WINDOW_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ease_main_editor_window_info_unref (old);
	}
}


static void ease_main_editor_window_info_class_init (EaseMainEditorWindowInfoClass * klass) {
	ease_main_editor_window_info_parent_class = g_type_class_peek_parent (klass);
	EASE_MAIN_EDITOR_WINDOW_INFO_CLASS (klass)->finalize = ease_main_editor_window_info_finalize;
}


static void ease_main_editor_window_info_instance_init (EaseMainEditorWindowInfo * self) {
	self->x = 0;
	self->y = 0;
	self->ref_count = 1;
}


static void ease_main_editor_window_info_finalize (EaseMainEditorWindowInfo* obj) {
	EaseMainEditorWindowInfo * self;
	self = EASE_MAIN_EDITOR_WINDOW_INFO (obj);
	_g_object_unref0 (self->window);
}


static GType ease_main_editor_window_info_get_type (void) {
	static volatile gsize ease_main_editor_window_info_type_id__volatile = 0;
	if (g_once_init_enter (&ease_main_editor_window_info_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { ease_main_value_editor_window_info_init, ease_main_value_editor_window_info_free_value, ease_main_value_editor_window_info_copy_value, ease_main_value_editor_window_info_peek_pointer, "p", ease_main_value_editor_window_info_collect_value, "p", ease_main_value_editor_window_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (EaseMainEditorWindowInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_main_editor_window_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseMainEditorWindowInfo), 0, (GInstanceInitFunc) ease_main_editor_window_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType ease_main_editor_window_info_type_id;
		ease_main_editor_window_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EaseMainEditorWindowInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&ease_main_editor_window_info_type_id__volatile, ease_main_editor_window_info_type_id);
	}
	return ease_main_editor_window_info_type_id__volatile;
}


static gpointer ease_main_editor_window_info_ref (gpointer instance) {
	EaseMainEditorWindowInfo* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void ease_main_editor_window_info_unref (gpointer instance) {
	EaseMainEditorWindowInfo* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		EASE_MAIN_EDITOR_WINDOW_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void ease_main_class_init (EaseMainClass * klass) {
	ease_main_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = ease_main_finalize;
}


static void ease_main_instance_init (EaseMain * self) {
}


static void ease_main_finalize (GObject* obj) {
	EaseMain * self;
	self = EASE_MAIN (obj);
	G_OBJECT_CLASS (ease_main_parent_class)->finalize (obj);
}


GType ease_main_get_type (void) {
	static volatile gsize ease_main_type_id__volatile = 0;
	if (g_once_init_enter (&ease_main_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseMain), 0, (GInstanceInitFunc) ease_main_instance_init, NULL };
		GType ease_main_type_id;
		ease_main_type_id = g_type_register_static (G_TYPE_OBJECT, "EaseMain", &g_define_type_info, 0);
		g_once_init_leave (&ease_main_type_id__volatile, ease_main_type_id);
	}
	return ease_main_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




