/* ease-welcome-actor.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-welcome-actor.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <ease-core.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>


#define EASE_TYPE_WELCOME_ACTOR (ease_welcome_actor_get_type ())
#define EASE_WELCOME_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_WELCOME_ACTOR, EaseWelcomeActor))
#define EASE_WELCOME_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_WELCOME_ACTOR, EaseWelcomeActorClass))
#define EASE_IS_WELCOME_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_WELCOME_ACTOR))
#define EASE_IS_WELCOME_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_WELCOME_ACTOR))
#define EASE_WELCOME_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_WELCOME_ACTOR, EaseWelcomeActorClass))

typedef struct _EaseWelcomeActor EaseWelcomeActor;
typedef struct _EaseWelcomeActorClass EaseWelcomeActorClass;
typedef struct _EaseWelcomeActorPrivate EaseWelcomeActorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _ease_slide_iterator_unref0(var) ((var == NULL) ? NULL : (var = (ease_slide_iterator_unref (var), NULL)))

struct _EaseWelcomeActor {
	ClutterGroup parent_instance;
	EaseWelcomeActorPrivate * priv;
};

struct _EaseWelcomeActorClass {
	ClutterGroupClass parent_class;
};

struct _EaseWelcomeActorPrivate {
	gboolean is_selected;
	ClutterCairoTexture* slide_actor;
	ClutterRectangle* rect;
	ClutterRectangle* hilight_rect;
	EaseTheme* _theme;
	ClutterText* text;
};


static gpointer ease_welcome_actor_parent_class = NULL;

GType ease_welcome_actor_get_type (void) G_GNUC_CONST;
#define EASE_WELCOME_ACTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_WELCOME_ACTOR, EaseWelcomeActorPrivate))
enum  {
	EASE_WELCOME_ACTOR_DUMMY_PROPERTY,
	EASE_WELCOME_ACTOR_THEME
};
#define EASE_WELCOME_ACTOR_FONT_NAME "Sans 8"
#define EASE_WELCOME_ACTOR_TEXT_OFFSET ((float) 5)
#define EASE_WELCOME_ACTOR_TEXT_HEIGHT ((float) 12)
#define EASE_WELCOME_ACTOR_FADE_TIME 200
#define EASE_WELCOME_ACTOR_FADE_INIT_TIME 1000
#define EASE_WELCOME_ACTOR_FADE_EASE ((gint) CLUTTER_EASE_IN_OUT_SINE)
#define EASE_WELCOME_ACTOR_FADE_OPACITY 150
#define EASE_WELCOME_ACTOR_RECT_B_W 1
#define EASE_WELCOME_ACTOR_HLRECT_W 2
#define EASE_WELCOME_ACTOR_PREVIEW_SLIDE EASE_THEME_TITLE
EaseWelcomeActor* ease_welcome_actor_new (EaseTheme* t);
EaseWelcomeActor* ease_welcome_actor_construct (GType object_type, EaseTheme* t);
void ease_welcome_actor_set_theme (EaseWelcomeActor* self, EaseTheme* value);
EaseTheme* ease_welcome_actor_get_theme (EaseWelcomeActor* self);
static gboolean _lambda55_ (ClutterActor* _self_, ClutterButtonEvent* event, EaseWelcomeActor* self);
static gboolean __lambda55__clutter_actor_button_press_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
void ease_welcome_actor_set_slide_size (EaseWelcomeActor* self, gint w, gint h);
static EaseSlide* ease_welcome_actor_create_slide (EaseWelcomeActor* self, gint w, gint h);
void ease_welcome_actor_set_actor_size (EaseWelcomeActor* self, float w, float h);
void ease_welcome_actor_fade (EaseWelcomeActor* self);
void ease_welcome_actor_unfade (EaseWelcomeActor* self);
static void ease_welcome_actor_finalize (GObject* obj);
static void ease_welcome_actor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_welcome_actor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const ClutterColor EASE_WELCOME_ACTOR_TEXT_COLOR = {(guchar) 255, (guchar) 255, (guchar) 255, (guchar) 255};
static const ClutterColor EASE_WELCOME_ACTOR_RECT_BG = {(guchar) 0, (guchar) 0, (guchar) 0, (guchar) 255};
static const ClutterColor EASE_WELCOME_ACTOR_RECT_B_C = {(guchar) 150, (guchar) 150, (guchar) 150, (guchar) 255};
static const ClutterColor EASE_WELCOME_ACTOR_HLRECT_C = {(guchar) 255, (guchar) 255, (guchar) 0, (guchar) 255};


/**
 * Instantiates a WelcomeActor.
 *
 * @param t The theme that this WelcomeActor will display.
 */
#line 133 "ease-welcome-actor.vala"
static gboolean _lambda55_ (ClutterActor* _self_, ClutterButtonEvent* event, EaseWelcomeActor* self) {
#line 114 "ease-welcome-actor.c"
	gboolean result = FALSE;
#line 133 "ease-welcome-actor.vala"
	g_return_val_if_fail (_self_ != NULL, FALSE);
#line 134 "ease-welcome-actor.vala"
	if ((*event).click_count == 2) {
#line 135 "ease-welcome-actor.vala"
		g_signal_emit_by_name (self, "double-click", self);
#line 122 "ease-welcome-actor.c"
		result = FALSE;
#line 136 "ease-welcome-actor.vala"
		return result;
#line 126 "ease-welcome-actor.c"
	}
#line 139 "ease-welcome-actor.vala"
	if (!self->priv->is_selected) {
#line 139 "ease-welcome-actor.vala"
		g_signal_emit_by_name (self, "selected", self);
#line 132 "ease-welcome-actor.c"
	}
	result = FALSE;
#line 140 "ease-welcome-actor.vala"
	return result;
#line 137 "ease-welcome-actor.c"
}


#line 133 "ease-welcome-actor.vala"
static gboolean __lambda55__clutter_actor_button_press_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
#line 143 "ease-welcome-actor.c"
	gboolean result;
	result = _lambda55_ (_sender, event, self);
	return result;
}


#line 94 "ease-welcome-actor.vala"
EaseWelcomeActor* ease_welcome_actor_construct (GType object_type, EaseTheme* t) {
#line 152 "ease-welcome-actor.c"
	EaseWelcomeActor * self;
	ClutterRectangle* _tmp0_;
	ClutterColor _tmp1_;
	ClutterColor _tmp2_;
	ClutterRectangle* _tmp3_;
	ClutterColor _tmp4_ = {0};
	ClutterColor _tmp5_;
	ClutterColor _tmp6_;
	ClutterText* _tmp7_;
	ClutterCairoTexture* _tmp8_;
#line 94 "ease-welcome-actor.vala"
	g_return_val_if_fail (t != NULL, NULL);
#line 165 "ease-welcome-actor.c"
	self = g_object_newv (object_type, 0, NULL);
#line 96 "ease-welcome-actor.vala"
	ease_welcome_actor_set_theme (self, t);
#line 97 "ease-welcome-actor.vala"
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
#line 100 "ease-welcome-actor.vala"
	self->priv->rect = (_tmp0_ = g_object_ref_sink ((ClutterRectangle*) clutter_rectangle_new ()), _g_object_unref0 (self->priv->rect), _tmp0_);
#line 101 "ease-welcome-actor.vala"
	clutter_rectangle_set_color (self->priv->rect, (_tmp1_ = EASE_WELCOME_ACTOR_RECT_BG, &_tmp1_));
#line 102 "ease-welcome-actor.vala"
	clutter_rectangle_set_border_color (self->priv->rect, (_tmp2_ = EASE_WELCOME_ACTOR_RECT_B_C, &_tmp2_));
#line 103 "ease-welcome-actor.vala"
	clutter_rectangle_set_border_width (self->priv->rect, (guint) EASE_WELCOME_ACTOR_RECT_B_W);
#line 104 "ease-welcome-actor.vala"
	clutter_actor_set_x ((ClutterActor*) self->priv->rect, (float) (-EASE_WELCOME_ACTOR_RECT_B_W));
#line 105 "ease-welcome-actor.vala"
	clutter_actor_set_y ((ClutterActor*) self->priv->rect, (float) (-EASE_WELCOME_ACTOR_RECT_B_W));
#line 106 "ease-welcome-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) self->priv->rect);
#line 109 "ease-welcome-actor.vala"
	self->priv->hilight_rect = (_tmp3_ = g_object_ref_sink ((ClutterRectangle*) clutter_rectangle_new ()), _g_object_unref0 (self->priv->hilight_rect), _tmp3_);
#line 110 "ease-welcome-actor.vala"
	clutter_rectangle_set_color (self->priv->hilight_rect, (_tmp5_ = (_tmp4_.red = (guchar) 0, _tmp4_.green = (guchar) 0, _tmp4_.blue = (guchar) 0, _tmp4_.alpha = (guchar) 255, _tmp4_), &_tmp5_));
#line 111 "ease-welcome-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) self->priv->hilight_rect, (guint) 0);
#line 112 "ease-welcome-actor.vala"
	clutter_rectangle_set_border_color (self->priv->hilight_rect, (_tmp6_ = EASE_WELCOME_ACTOR_HLRECT_C, &_tmp6_));
#line 113 "ease-welcome-actor.vala"
	clutter_rectangle_set_border_width (self->priv->hilight_rect, (guint) EASE_WELCOME_ACTOR_HLRECT_W);
#line 114 "ease-welcome-actor.vala"
	clutter_actor_set_x ((ClutterActor*) self->priv->hilight_rect, (float) (-EASE_WELCOME_ACTOR_HLRECT_W));
#line 115 "ease-welcome-actor.vala"
	clutter_actor_set_y ((ClutterActor*) self->priv->hilight_rect, (float) (-EASE_WELCOME_ACTOR_HLRECT_W));
#line 116 "ease-welcome-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) self->priv->hilight_rect);
#line 119 "ease-welcome-actor.vala"
	self->priv->text = (_tmp7_ = g_object_ref_sink ((ClutterText*) clutter_text_new_full (EASE_WELCOME_ACTOR_FONT_NAME, self->priv->_theme->title, &EASE_WELCOME_ACTOR_TEXT_COLOR)), _g_object_unref0 (self->priv->text), _tmp7_);
#line 120 "ease-welcome-actor.vala"
	clutter_actor_set_height ((ClutterActor*) self->priv->text, EASE_WELCOME_ACTOR_TEXT_HEIGHT);
#line 121 "ease-welcome-actor.vala"
	clutter_text_set_line_alignment (self->priv->text, PANGO_ALIGN_RIGHT);
#line 122 "ease-welcome-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) self->priv->text);
#line 125 "ease-welcome-actor.vala"
	self->priv->slide_actor = (_tmp8_ = g_object_ref_sink ((ClutterCairoTexture*) clutter_cairo_texture_new ((guint) 1024, (guint) 768)), _g_object_unref0 (self->priv->slide_actor), _tmp8_);
#line 126 "ease-welcome-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) self->priv->slide_actor);
#line 129 "ease-welcome-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
#line 130 "ease-welcome-actor.vala"
	clutter_actor_animate ((ClutterActor*) self, (gulong) EASE_WELCOME_ACTOR_FADE_EASE, (guint) EASE_WELCOME_ACTOR_FADE_INIT_TIME, "opacity", 255, NULL);
#line 133 "ease-welcome-actor.vala"
	g_signal_connect_object ((ClutterActor*) self, "button-press-event", (GCallback) __lambda55__clutter_actor_button_press_event, self, 0);
#line 219 "ease-welcome-actor.c"
	return self;
}


#line 94 "ease-welcome-actor.vala"
EaseWelcomeActor* ease_welcome_actor_new (EaseTheme* t) {
#line 94 "ease-welcome-actor.vala"
	return ease_welcome_actor_construct (EASE_TYPE_WELCOME_ACTOR, t);
#line 228 "ease-welcome-actor.c"
}


/**
 * Sets the slide preview size.
 *
 * @param w The width of the slide.
 * @param h The height of the slide.
 */
#line 150 "ease-welcome-actor.vala"
void ease_welcome_actor_set_slide_size (EaseWelcomeActor* self, gint w, gint h) {
#line 240 "ease-welcome-actor.c"
	GError * _inner_error_ = NULL;
#line 150 "ease-welcome-actor.vala"
	g_return_if_fail (self != NULL);
#line 153 "ease-welcome-actor.vala"
	clutter_cairo_texture_set_surface_size (self->priv->slide_actor, (guint) w, (guint) h);
#line 246 "ease-welcome-actor.c"
	{
		EaseSlide* slide;
		cairo_t* _tmp0_;
#line 158 "ease-welcome-actor.vala"
		slide = ease_welcome_actor_create_slide (self, w, h);
#line 159 "ease-welcome-actor.vala"
		ease_slide_cairo_render_sized (slide, _tmp0_ = clutter_cairo_texture_create (self->priv->slide_actor), w, h, &_inner_error_);
#line 254 "ease-welcome-actor.c"
		_cairo_destroy0 (_tmp0_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (slide);
			goto __catch20_g_error;
		}
		_g_object_unref0 (slide);
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 163 "ease-welcome-actor.vala"
			g_critical (_ ("Error rendering preview: %s"), e->message);
#line 271 "ease-welcome-actor.c"
			_g_error_free0 (e);
		}
	}
	__finally20:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
 * Sets the size of the slide preview actor.
 *
 * This method does not redraw the preview, it simply scales it.
 *
 * @param w The width of the actor.
 * @param h The height of the actor.
 */
#line 175 "ease-welcome-actor.vala"
void ease_welcome_actor_set_actor_size (EaseWelcomeActor* self, float w, float h) {
#line 175 "ease-welcome-actor.vala"
	g_return_if_fail (self != NULL);
#line 177 "ease-welcome-actor.vala"
	clutter_actor_set_width ((ClutterActor*) self->priv->rect, roundf (w) + (EASE_WELCOME_ACTOR_RECT_B_W * 2));
#line 178 "ease-welcome-actor.vala"
	clutter_actor_set_height ((ClutterActor*) self->priv->rect, roundf (h) + (EASE_WELCOME_ACTOR_RECT_B_W * 2));
#line 180 "ease-welcome-actor.vala"
	clutter_actor_set_width ((ClutterActor*) self->priv->hilight_rect, roundf (w) + (EASE_WELCOME_ACTOR_HLRECT_W * 2));
#line 181 "ease-welcome-actor.vala"
	clutter_actor_set_height ((ClutterActor*) self->priv->hilight_rect, roundf (h) + (EASE_WELCOME_ACTOR_HLRECT_W * 2));
#line 183 "ease-welcome-actor.vala"
	clutter_actor_set_x ((ClutterActor*) self->priv->text, roundf ((w / 2) - (clutter_actor_get_width ((ClutterActor*) self->priv->text) / 2)));
#line 184 "ease-welcome-actor.vala"
	clutter_actor_set_y ((ClutterActor*) self->priv->text, roundf (h + EASE_WELCOME_ACTOR_TEXT_OFFSET));
#line 186 "ease-welcome-actor.vala"
	if (self->priv->slide_actor != NULL) {
#line 188 "ease-welcome-actor.vala"
		clutter_actor_set_width ((ClutterActor*) self->priv->slide_actor, roundf (w));
#line 189 "ease-welcome-actor.vala"
		clutter_actor_set_height ((ClutterActor*) self->priv->slide_actor, roundf (h));
#line 314 "ease-welcome-actor.c"
	}
}


/**
 * Brings the preview to full brightness.
 */
#line 196 "ease-welcome-actor.vala"
void ease_welcome_actor_fade (EaseWelcomeActor* self) {
#line 196 "ease-welcome-actor.vala"
	g_return_if_fail (self != NULL);
#line 198 "ease-welcome-actor.vala"
	self->priv->is_selected = FALSE;
#line 199 "ease-welcome-actor.vala"
	clutter_actor_animate ((ClutterActor*) self->priv->slide_actor, (gulong) EASE_WELCOME_ACTOR_FADE_EASE, (guint) EASE_WELCOME_ACTOR_FADE_TIME, "opacity", EASE_WELCOME_ACTOR_FADE_OPACITY, NULL);
#line 200 "ease-welcome-actor.vala"
	clutter_actor_animate ((ClutterActor*) self->priv->hilight_rect, (gulong) EASE_WELCOME_ACTOR_FADE_EASE, (guint) EASE_WELCOME_ACTOR_FADE_TIME, "opacity", 0, NULL);
#line 332 "ease-welcome-actor.c"
}


/**
 * Dims the preview.
 */
#line 206 "ease-welcome-actor.vala"
void ease_welcome_actor_unfade (EaseWelcomeActor* self) {
#line 206 "ease-welcome-actor.vala"
	g_return_if_fail (self != NULL);
#line 208 "ease-welcome-actor.vala"
	self->priv->is_selected = TRUE;
#line 209 "ease-welcome-actor.vala"
	clutter_actor_animate ((ClutterActor*) self->priv->slide_actor, (gulong) EASE_WELCOME_ACTOR_FADE_EASE, (guint) EASE_WELCOME_ACTOR_FADE_TIME, "opacity", 255, NULL);
#line 210 "ease-welcome-actor.vala"
	clutter_actor_animate ((ClutterActor*) self->priv->hilight_rect, (gulong) EASE_WELCOME_ACTOR_FADE_EASE, (guint) EASE_WELCOME_ACTOR_FADE_TIME, "opacity", 255, NULL);
#line 349 "ease-welcome-actor.c"
}


/**
 * Creates a slide for preview of the given width and height.
 *
 * This method creates a slide from the WelcomeActor's {@link Theme},
 * and substitutes some appropriate "preview" properties for specified
 * elements. For example, the user's "real name" is placed in the "author"
 * field.
 *
 * @param w The width of the slide to create.
 * @param h The height of the slide to create.
 */
#line 224 "ease-welcome-actor.vala"
static EaseSlide* ease_welcome_actor_create_slide (EaseWelcomeActor* self, gint w, gint h) {
#line 366 "ease-welcome-actor.c"
	EaseSlide* result = NULL;
	EaseSlide* slide;
#line 224 "ease-welcome-actor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 226 "ease-welcome-actor.vala"
	slide = ease_theme_create_slide (self->priv->_theme, EASE_WELCOME_ACTOR_PREVIEW_SLIDE, w, h);
#line 373 "ease-welcome-actor.c"
	{
		EaseSlideIterator* _element_it;
#line 228 "ease-welcome-actor.vala"
		_element_it = ease_slide_iterator (slide);
#line 228 "ease-welcome-actor.vala"
		while (TRUE) {
#line 380 "ease-welcome-actor.c"
			EaseElement* element;
			const char* _tmp2_;
			GQuark _tmp3_;
#line 228 "ease-welcome-actor.vala"
			if (!ease_slide_iterator_next (_element_it)) {
#line 228 "ease-welcome-actor.vala"
				break;
#line 388 "ease-welcome-actor.c"
			}
#line 228 "ease-welcome-actor.vala"
			element = ease_slide_iterator_get (_element_it);
#line 230 "ease-welcome-actor.vala"
			ease_element_set_has_been_edited (element, TRUE);
#line 394 "ease-welcome-actor.c"
			_tmp2_ = ease_element_get_identifier (element);
			_tmp3_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
			if (_tmp3_ == g_quark_from_string (EASE_THEME_TITLE_TEXT))
			switch (0) {
				default:
				{
					EaseElement* _tmp0_;
#line 234 "ease-welcome-actor.vala"
					ease_text_element_set_text ((_tmp0_ = element, EASE_IS_TEXT_ELEMENT (_tmp0_) ? ((EaseTextElement*) _tmp0_) : NULL), self->priv->_theme->title);
#line 235 "ease-welcome-actor.vala"
					break;
#line 406 "ease-welcome-actor.c"
				}
			} else if (_tmp3_ == g_quark_from_string (EASE_THEME_AUTHOR_TEXT))
			switch (0) {
				default:
				{
					EaseElement* _tmp1_;
#line 237 "ease-welcome-actor.vala"
					ease_text_element_set_text ((_tmp1_ = element, EASE_IS_TEXT_ELEMENT (_tmp1_) ? ((EaseTextElement*) _tmp1_) : NULL), g_get_real_name ());
#line 238 "ease-welcome-actor.vala"
					break;
#line 417 "ease-welcome-actor.c"
				}
			}
			_g_object_unref0 (element);
		}
		_ease_slide_iterator_unref0 (_element_it);
	}
	result = slide;
#line 242 "ease-welcome-actor.vala"
	return result;
#line 427 "ease-welcome-actor.c"
}


EaseTheme* ease_welcome_actor_get_theme (EaseWelcomeActor* self) {
	EaseTheme* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_theme;
#line 52 "ease-welcome-actor.vala"
	return result;
#line 437 "ease-welcome-actor.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void ease_welcome_actor_set_theme (EaseWelcomeActor* self, EaseTheme* value) {
	EaseTheme* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_theme = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_theme), _tmp0_);
	g_object_notify ((GObject *) self, "theme");
}


static void ease_welcome_actor_class_init (EaseWelcomeActorClass * klass) {
	ease_welcome_actor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseWelcomeActorPrivate));
	G_OBJECT_CLASS (klass)->get_property = ease_welcome_actor_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_welcome_actor_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_welcome_actor_finalize;
	/**
	 * The theme previewed by this WelcomeActor.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_WELCOME_ACTOR_THEME, g_param_spec_object ("theme", "theme", "theme", EASE_TYPE_THEME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Triggered when the slide preview is selected (single click).
	 */
	g_signal_new ("selected", EASE_TYPE_WELCOME_ACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_WELCOME_ACTOR);
	/**
	 * Triggered when the slide preview is double clicked.
	 */
	g_signal_new ("double_click", EASE_TYPE_WELCOME_ACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_WELCOME_ACTOR);
}


static void ease_welcome_actor_instance_init (EaseWelcomeActor * self) {
	self->priv = EASE_WELCOME_ACTOR_GET_PRIVATE (self);
	self->priv->is_selected = FALSE;
}


static void ease_welcome_actor_finalize (GObject* obj) {
	EaseWelcomeActor * self;
	self = EASE_WELCOME_ACTOR (obj);
	_g_object_unref0 (self->priv->slide_actor);
	_g_object_unref0 (self->priv->rect);
	_g_object_unref0 (self->priv->hilight_rect);
	_g_object_unref0 (self->priv->_theme);
	_g_object_unref0 (self->priv->text);
	G_OBJECT_CLASS (ease_welcome_actor_parent_class)->finalize (obj);
}


/**
 * {@link Theme} tiles within the {@link WelcomeWindow}
 *
 * Each WelcomeActor is a preview of a {@link Theme}. The user can
 * click on these to create a new {@link Document} with that {@link Theme}.
 */
GType ease_welcome_actor_get_type (void) {
	static volatile gsize ease_welcome_actor_type_id__volatile = 0;
	if (g_once_init_enter (&ease_welcome_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseWelcomeActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_welcome_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseWelcomeActor), 0, (GInstanceInitFunc) ease_welcome_actor_instance_init, NULL };
		GType ease_welcome_actor_type_id;
		ease_welcome_actor_type_id = g_type_register_static (CLUTTER_TYPE_GROUP, "EaseWelcomeActor", &g_define_type_info, 0);
		g_once_init_leave (&ease_welcome_actor_type_id__volatile, ease_welcome_actor_type_id);
	}
	return ease_welcome_actor_type_id__volatile;
}


static void ease_welcome_actor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseWelcomeActor * self;
	self = EASE_WELCOME_ACTOR (object);
	switch (property_id) {
		case EASE_WELCOME_ACTOR_THEME:
		g_value_set_object (value, ease_welcome_actor_get_theme (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_welcome_actor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseWelcomeActor * self;
	self = EASE_WELCOME_ACTOR (object);
	switch (property_id) {
		case EASE_WELCOME_ACTOR_THEME:
		ease_welcome_actor_set_theme (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




