/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import java.io.IOException;
import org.acplt.oncrpc.OncRpcAuthenticationException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;
import org.acplt.oncrpc.server.OncRpcServerAuthNone;
import org.acplt.oncrpc.server.OncRpcServerAuthShort;
import org.acplt.oncrpc.server.OncRpcServerAuthUnix;

public abstract class OncRpcServerAuth {
    public abstract int getAuthenticationType();

    public static final OncRpcServerAuth xdrNew(XdrDecodingStream xdr, OncRpcServerAuth recycle) throws IOException, OncRpcException {
        OncRpcServerAuth auth;
        int authType = xdr.xdrDecodeInt();
        if (recycle != null && recycle.getAuthenticationType() == authType) {
            auth = recycle;
            ((OncRpcServerAuth)auth).xdrDecodeCredVerf(xdr);
        } else {
            switch (authType) {
                case 0: {
                    auth = OncRpcServerAuthNone.AUTH_NONE;
                    ((OncRpcServerAuth)auth).xdrDecodeCredVerf(xdr);
                    break;
                }
                case 2: {
                    auth = new OncRpcServerAuthShort(xdr);
                    break;
                }
                case 1: {
                    auth = new OncRpcServerAuthUnix(xdr);
                    break;
                }
                default: {
                    throw new OncRpcAuthenticationException(2);
                }
            }
        }
        return auth;
    }

    public abstract void xdrDecodeCredVerf(XdrDecodingStream var1) throws IOException, OncRpcException;

    public abstract void xdrEncodeVerf(XdrEncodingStream var1) throws IOException, OncRpcException;
}

