/***************************************************************************
 *            camel-kolab-imapx-store.h
 *
 *  Fri Sep  3 12:48:31 2010
 *  Copyright  2010  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
/*----------------------------------------------------------------------------*/

#ifndef _CAMEL_KOLAB_IMAPX_STORE_H_
#define _CAMEL_KOLAB_IMAPX_STORE_H_

/*----------------------------------------------------------------------------*/

#include <camel/camel-types.h>
#include <camel/camel-store.h>
#include <camel/camel-offline-store.h>

#include <camel/providers/imapx/camel-imapx-store.h>

#include "camel-kolab-imapx-metadata.h"

/*----------------------------------------------------------------------------*/

#define CAMEL_KOLAB_IMAPX_STORE_TYPE     	(camel_kolab_imapx_store_get_type ())
#define CAMEL_KOLAB_IMAPX_STORE(obj)     	(CAMEL_CHECK_CAST((obj), CAMEL_KOLAB_IMAPX_STORE_TYPE, CamelKolabIMAPXStore))
#define CAMEL_KOLAB_IMAPX_STORE_CLASS(klass)	(CAMEL_CHECK_CLASS_CAST ((klass), CAMEL_KOLAB_IMAPX_STORE_TYPE, CamelKolabIMAPXStoreClass))
#define CAMEL_IS_KOLAB_IMAPX_STORE(obj)		(CAMEL_CHECK_TYPE((obj), CAMEL_KOLAB_IMAPX_STORE_TYPE))

G_BEGIN_DECLS

/* We're a direct descendant of CamelIMAPXStore */

typedef struct {
	CamelIMAPXStore parent_object;

	/* Used for syncronizing get_folder_info. Check for re-use of any other lock. At the
	   moment, could not find anything suitable for this */
	GMutex *kolab_finfo_lock;

	CamelKolabIMAPXMetaData *kmd;
	KolabFolderTypeID folder_create_type;
	KolabFolderContextID folder_context;
	gboolean folder_types_do_care[KOLAB_FOLDER_LAST_TYPE];
	GList *folder_names_do_care;
} CamelKolabIMAPXStore;

typedef struct {
	CamelIMAPXStoreClass parent_class;

} CamelKolabIMAPXStoreClass;

/* Standard Camel function */
CamelType camel_kolab_imapx_store_get_type (void);

/* Kolab extension: set type for newly created folders */
gboolean kolab_imapx_store_set_folder_creation_type (CamelKolabIMAPXStore *store, KolabFolderTypeID type_id);

/* Kolab extension: set the folder context (email, calendar, contacts (defaults to email))*/
gboolean kolab_imapx_store_set_folder_context (CamelKolabIMAPXStore *store, KolabFolderContextID context);

/* Kolab extension: get the folder type id */
KolabFolderTypeID kolab_imapx_store_get_folder_type (CamelKolabIMAPXStore *store, const gchar *foldername, GError **err);

void kolab_imapx_store_logout_sync (CamelKolabIMAPXStore *store);
GList *kolab_imapx_store_resect_folder_list (CamelKolabIMAPXStore *store);

G_END_DECLS

/*----------------------------------------------------------------------------*/

#endif /* _CAMEL_KOLAB_IMAPX_STORE_H_ */

/*----------------------------------------------------------------------------*/
