/***************************************************************************
 *            camel-kolab-session.h
 *
 *  Tue Aug 10 15:04:38 2010
 *  Copyright  2010  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*----------------------------------------------------------------------------*/

/*
 * The CamelSession class for Kolab access. To be instantiated once for
 * each IMAPX Camel.Provider we have. Within EDS, this is one for address book
 * and one for calendar access. Within Evolution, there should be one more
 * for email (if at all we can supply our own IMAPX provider there).
 *
 * Since we have three independent connections to the one same
 * Kolab IMAP server for email, addresses and calendar, we will
 * (most probably) need three CamelSession instances. To avoid confusion,
 * we will declare one within the address book backend (process), one in
 * the calendar backend (process) and one in the email process.
 *
 * To hide these CamelSession objects from one another, we will declare
 * them within the libs which will use them only, rather than making
 * them visible system-wide.
 */

/*----------------------------------------------------------------------------*/

#ifndef _CAMEL_KOLAB_SESSION_H_
#define _CAMEL_KOLAB_SESSION_H_

/*----------------------------------------------------------------------------*/

#include <glib.h>

#include <camel/camel-types.h>
#include <camel/camel-session.h>

/*----------------------------------------------------------------------------*/

#define CAMEL_KOLAB_SESSION_TYPE     		(camel_kolab_session_get_type ())
#define CAMEL_KOLAB_SESSION(obj)     		(CAMEL_CHECK_CAST((obj), CAMEL_KOLAB_SESSION_TYPE, CamelKolabSession))
#define CAMEL_KOLAB_SESSION_CLASS(klass)	(CAMEL_CHECK_CLASS_CAST ((klass), CAMEL_KOLAB_SESSION_TYPE, CamelKolabSessionClass))
#define CAMEL_KOLAB_IS_SESSION(obj)    		(CAMEL_CHECK_TYPE((obj), CAMEL_KOLAB_SESSION_TYPE))

G_BEGIN_DECLS

typedef struct _CamelKolabSession {
        CamelSession parent_instance;

	gchar *data_dir;
	gchar *config_dir;
	gchar *nss_tok_pwd;
	gchar *passwd;
	gboolean is_initialized;
} CamelKolabSession;

typedef struct _CamelKolabSessionClass {
        CamelSessionClass parent_class;
	/* TODO check what else is needed here */
	
} CamelKolabSessionClass;

CamelType camel_kolab_session_get_type (void);

CamelKolabSession* camel_kolab_session_new (void);
gboolean camel_kolab_session_bringup (CamelKolabSession *self, GError **err);
gboolean camel_kolab_session_shutdown (CamelKolabSession *self, GError **err);

void camel_kolab_session_set_password (CamelKolabSession *self, const gchar *passwd);
void camel_kolab_session_set_token_pin (CamelKolabSession *self, const gchar *pin);

void camel_kolab_session_set_data_dir (CamelKolabSession *self, gchar *datadir);
const gchar* camel_kolab_session_get_data_dir (CamelKolabSession *self);
void camel_kolab_session_set_config_dir (CamelKolabSession *self, gchar *configdir);
const gchar* camel_kolab_session_get_config_dir (CamelKolabSession *self);

G_END_DECLS

/*----------------------------------------------------------------------------*/

#endif /* _CAMEL_KOLAB_SESSION_H_ */

/*----------------------------------------------------------------------------*/
