/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/*
 * evolution-kolab
 * Copyright (C) Silvan Marco Fin 2011 <silvan@kernelconcepts.de>
 * 
 * evolution-kolab is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * evolution-kolab is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _KOLAB_UTIL_CONTACT_CACHE_H_
#define _KOLAB_UTIL_CONTACT_CACHE_H_

#include <libekolab/kolab-mail-access.h>

#include <glib.h>
#include <libedata-book/e-book-backend-cache.h>

gboolean kolab_util_contact_cache_assure_uid_on_econtact (EBookBackendCache *cache, 
                                                          KolabMailAccess *koma,
                                                          const gchar *uri,
                                                          EContact *econtact,
                                                          GError **error);
EContact *kolab_util_contact_cache_get_object (EBookBackendCache *cache, 
                                               KolabMailAccess *koma, 
                                               const gchar *uri, 
                                               const gchar *uid, 
                                               GError **error);
void kolab_util_contact_cache_update_object (EBookBackendCache *cache,
                                             KolabMailAccess *koma,
                                             const gchar *uri,
                                             const gchar *uid,
                                             GError **error);
void kolab_util_contact_cache_update_on_query (EBookBackendCache *cache,
                                               KolabMailAccess *koma,
                                               const gchar *query,
                                               const gchar *uri);

GList* kolab_util_contact_cache_get_contacts (EBookBackendCache *cache,
                                              KolabMailAccess *koma,
                                              const gchar *query,
                                              const gchar *uri,
                                              GError **error);
#endif /* _KOLAB_UTIL_CONTACT_CACHE_H_ */
