/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * evolution-kolab
 * Copyright (C) Silvan Marco Fin 2011 <silvan@kernelconcepts.de>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#ifndef _KOLAB_UTIL_CALENDAR_H_
#define _KOLAB_UTIL_CALENDAR_H_

#include <libekolabutil/kolab-http-job.h>
#include <libekolab/kolab-settings-handler.h>
#include <libekolab/kolab-mail-access.h>

#include <libical/icalcomponent.h>
#include <libecal/e-cal.h>
#include <libedata-cal/e-cal-backend-sync.h>

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

/**
 * SECTION:kolab-util-calendar
 * @title: KolabUtilCalendar
 * @short_description: Utility methods for Evolution-Kolab calendar backend implementation.
 * 
 * The methods in this library don't use the ECalBackendCache.
 */

#define KOLAB_TYPE_UTIL_CALENDAR             (kolab_util_calendar_get_type ())
#define KOLAB_UTIL_CALENDAR(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), KOLAB_TYPE_UTIL_CALENDAR, ECalBackendKolabUtil))
#define KOLAB_UTIL_CALENDAR_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), KOLAB_TYPE_UTIL_CALENDAR, ECalBackendKolabUtilClass))
#define KOLAB_IS_UTIL_CALENDAR(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KOLAB_TYPE_UTIL_CALENDAR))
#define KOLAB_IS_UTIL_CALENDAR_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), KOLAB_TYPE_UTIL_CALENDAR))
#define KOLAB_UTIL_CALENDAR_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), KOLAB_TYPE_UTIL_CALENDAR, ECalBackendKolabUtilClass))

typedef struct _KolabUtilCalendarClass KolabUtilCalendarClass;
typedef struct _KolabUtilCalendar KolabUtilCalendar;


struct _KolabUtilCalendarClass
{
	GObjectClass parent_class;
};

struct _KolabUtilCalendar
{
	GObject parent_instance;
};

GType kolab_util_calendar_get_type (void) G_GNUC_CONST;

/* library functions */

ECalBackendSyncStatus kolab_util_calendar_extract (icalcomponent *icalcomp, ECalSourceType source_type, ECalComponent **ecalcomp, ECalComponent **tzcomp);
gchar *kolab_util_calendar_get_tzid (ECalComponent *comp, ECalComponentField from);
gboolean kolab_util_calendar_toggle_pfb_trigger (KolabSettingsHandler *ksettings, const gchar *sourcename);
KolabHttpJob *kolab_util_calendar_retrieve_xfb (KolabSettingsHandler *ksettings, gchar *query);
void kolab_util_calendar_store (ECalComponent *ecalcomp, ECalComponent *ecaltz, ECalComponent *default_tz, KolabMailAccess *koma, const gchar *uri, GError **error);
ECalBackendSyncStatus kolab_util_calendar_map_error (GError *error);

/* object methods */

G_END_DECLS

#endif /* _KOLAB_UTIL_CALENDAR_H_ */
